<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class EmployeeQualificaiton extends Model
{
	protected $guarded=[];

	public function employee(){
		return $this->hasOne('App\Employee','id','employee_id');
	}

	public function EducationLevel(){
		return $this->hasOne('App\QualificationEducationLevel','id','education_level_id');
	}
	public function LanguageSkill(){
		return $this->hasOne('App\QualificationLanguage','id','language_skill_id');
	}
	public function GeneralSkill(){
		return $this->hasOne('App\QualificationSkill','id','general_skill_id');
	}

	public function setGraduationDateAttribute($value)
	{
		$this->attributes['graduation_date'] = Carbon::createFromFormat(env('Date_Format'), $value)->format('Y-m-d');
	}

	public function getGraduationDateAttribute($value)
	{
		return Carbon::parse($value)->format(env('Date_Format'));
	}
}
