<?php

namespace App\Exports;

use App\Employee;
use App\Holiday;
use App\leave;
use App\ReportAttendance;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class ReportAttendanceExport implements FromView
{
    public function view(): View
    {
        $startDate = Carbon::now()->startOfMonth();
        $endDate = Carbon::now()->endOfMonth();
        $dates = [];

        $period = CarbonPeriod::create($startDate, $endDate);
        foreach ($period as $key => $date) {
            $dates[] =  $date->format('d-m-Y');
        }

        $datas = [];

        $employees = Employee::with([
            "employeeAttendance" => function ($query) use ($startDate, $endDate) {
                $query->whereBetween('attendance_date', [$startDate, $endDate]);
            },
            'officeShift',
            'department',
            'employeeLeave'
        ])->orderByRaw('position = 0, position')->get();

        foreach ($employees as $employee) {
            $data = [];
            $data['employee'] = $employee->first_name . ' ' . $employee->last_name;
            $data['department'] = $employee->department->department_name;

            $totalLeaves = $employee->remaining_leave;
            $thisMonthLeaves = leave::where('employee_id', $employee->id)->whereMonth('start_date', Carbon::now()->month)->sum('total_days');
            $data['remaining_leaves_last_month'] =  $totalLeaves + $thisMonthLeaves;

            //Date
            foreach ($dates as $date) {
                $formattedDate = Carbon::parse($date)->format('Y-m-d');
                $day = Carbon::parse($date)->format('l');

                if (Carbon::parse($formattedDate)->greaterThanOrEqualTo(Carbon::now())) {
                    $data[$date] =  [
                        'data' => '-',
                        'color' => 'black'
                    ];
                    continue;
                }

                $attendance = $employee->reportAttendances->where('attendance_date', $formattedDate)->first();
                $reportAttendance = $employee->reportAttendances->where('attendance_date', $formattedDate)->first();

                if ($attendance) {
                    if ($reportAttendance->status) {
                        if ($reportAttendance->is_checked) {
                            $data[$date] = [
                                'data' => $reportAttendance->status,
                                'color' => 'green'
                            ];
                        } else {
                            $data[$date] = [
                                'data' => $reportAttendance->status,
                                'color' => 'red'
                            ];
                        }
                    } else {
                        $time = Carbon::parse($reportAttendance->work_time)->format('H:i');
                        if ($reportAttendance->is_underwork) {
                            $data[$date] = [
                                'data' => $time,
                                'color' => 'red'
                            ];
                        } else {
                            $data[$date] = [
                                'data' => $time,
                                'color' => 'green'
                            ];
                        }
                    }
                } else {
                    $holiday = Holiday::where([
                        ['start_date', '<=', $formattedDate],
                        ['end_date', '>=', $formattedDate]
                    ])->first();
                    if ($day == 'Saturday' || $day == 'Sunday' || $holiday) {
                        $data[$date] = [
                            'data' => '-',
                            'color' => 'black'
                        ];
                    } else {
                        if ($employee->is_dispensation) {
                            $data[$date] = [
                                'data' => 'DIS',
                                'color' => 'green'
                            ];
                            continue;
                        }
                        $leave = leave::with('leaveType')->where([
                            ['employee_id', '=', $employee->id],
                            ['start_date', '<=', $formattedDate],
                            ['end_date', '>=', $formattedDate]
                        ])->first();
                        if ($leave) {
                            $status = '';
                            $leaveType = $leave->leaveType->id;
                            switch ($leaveType) {
                                case 1:
                                    $status = 'S';
                                    break;
                                case 2:
                                    $status = 'I';
                                    break;
                                case 3:
                                    if ($leave->is_half) {
                                        $status = 'C1';
                                    } else {
                                        $status = 'C';
                                    }
                                    break;
                                case 4:
                                    $status = 'M';
                                    break;
                                case 5:
                                    $status = 'C1';
                                    break;
                                case 6:
                                    $status = 'C2';
                                    break;
                                case 7:
                                    $status = 'C3';
                                    break;
                                case 8:
                                    $status = 'C4';
                                    break;
                                case 9:
                                    $status = 'DL';
                                    break;
                                case 10:
                                    $status = 'IK1';
                                    break;
                                case 11:
                                    $status = 'IK2';
                                    break;
                                case 12:
                                    $status = 'IT1';
                                    break;
                                case 13:
                                    $status = 'IT2';
                                    break;
                                case 14:
                                    $status = 'IP';
                                    break;
                                case 15:
                                    $status = 'TA1';
                                    break;
                                case 16:
                                    $status = 'TA2';
                                    break;
                                case 17:
                                    $status = 'DIS';
                                    break;
                                case 18:
                                    $status = 'PG';
                                    break;
                                default:
                                    $status =  '-';
                            }
                            $data[$date] =  [
                                'data' => $status,
                                'color' => 'blue'
                            ];
                        } else {
                            $status = 'TA3';
                            $data[$date] =  [
                                'data' => $status,
                                'color' => 'red'
                            ];
                        }
                    }
                }
            }

            //Kondite
            $totalS = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 1)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalS += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_s'] = $totalS;

            $totalI = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 2)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalI += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_i'] = $totalI;

            $totalC = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 3)->where('is_half', '!=', 1)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalC += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_c'] = $totalC;

            $totalM = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 4)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalM += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_m'] = $totalM;

            $totalC1 = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 3)->where('is_half', 1)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalC1 += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            foreach ($employee->employeeLeave->where('leave_type_id', 5)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalC1 += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_c1'] = $totalC1;
            
            $totalC2 = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 6)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalC2 += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_c2'] = $totalC2;

            $totalC3 = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 7)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalC3 += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_c3'] = $totalC3;
            
            $totalC4 = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 8)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalC4 += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_c4'] = $totalC4;

            $totalDl = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 9)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalDl += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_dl'] = $totalDl;

            $totalIk1 = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 10)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalIk1 += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_ik1'] = $totalIk1;

            $totalIk2 = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 12)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalIk2 += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_ik2'] = $totalIk2;

            $totalIt1 = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 13)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalIt1 += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_it1'] = $totalIt1;

            $totalIt2 = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 14)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalIt1 += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_it2'] = $totalIt2;

            $totalIp = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 15)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalIp += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_ip'] = $totalIp;
            
            $data['total_ta1'] = ReportAttendance::where([['employee_id', '=', $employee->id], ['status', '=', 'TA1']])->whereBetween('attendance_date', [$startDate, $endDate])->get()->count();
            $data['total_ta2'] = ReportAttendance::where([['employee_id', '=', $employee->id], ['status', '=', 'TA2']])->whereBetween('attendance_date', [$startDate, $endDate])->get()->count();

            //TA3
            //All date
            $now = Carbon::now();
            $filterEndDate = $endDate;
            if ($endDate->greaterThan($now)) {
                $filterEndDate = $now;
            }
            $count = $startDate->diffInDaysFiltered(
                function (Carbon $date) {
                    return !$date->isWeekend();
                },
                $filterEndDate
            );
            //Attendance report count
            $attendCount = ReportAttendance::where('employee_id', $employee->id)->whereBetween('attendance_date', [$startDate, $endDate])->get()->count();
            //Leaves count
            $leaveCount = 0;
            foreach ($employee->employeeLeave as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $leaveCount += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            //Total DIS & TA3
            if (!$employee->is_dispensation) {
                $data['total_ta3'] = $count - $attendCount - $leaveCount;
                $data['total_dis'] = 0;
            } else {
                $data['total_ta3'] = 0;
                $data['total_dis'] = $count - $attendCount - $leaveCount;
            }

          
            $totalPg = 0;
            foreach ($employee->employeeLeave->where('leave_type_id', 18)->all() as $leave) {
                $startLeave = Carbon::parse($leave->start_date);
                $endLeave = Carbon::parse($leave->end_date);
                if ($startLeave->lessThan($startDate)) {
                    $startLeave = $startDate;
                }
                if ($endLeave->greaterThan($endDate)) {
                    $endLeave = $endDate;
                }
                if ($startLeave->lessThanOrEqualTo($endLeave)) {
                    $totalPg += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                        return !$date->isWeekend();
                    }, $endLeave->addDay('1'));
                }
            }
            $data['total_pg'] = $totalPg;
            
            $data['remaining_leaves'] = $employee->remaining_leave;

            $datas[] = $data;
        }

        $now = Carbon::now()->subMonth();
        $last_month =  $now->format('F');

        //Holidays
        $startDate = Carbon::now()->startOfMonth();
        $endDate = Carbon::now()->endOfMonth();

        $period = CarbonPeriod::create($startDate, $endDate);
        $dates = [];
        $holidays = [];

        $fixedHolidays = Holiday::where('is_publish', 1)->get();
        foreach ($period as $key => $date) {
            $dates[] =  $date->format('d-m-Y');
            if ($date->isWeekend()) {
                $holidays[] = $key;
            } else {
                foreach ($fixedHolidays as $fixedHoliday) {
                    if ($date->betweenIncluded(Carbon::parse($fixedHoliday->start_date), Carbon::parse($fixedHoliday->end_date))) {
                        $holidays[] = $key;
                    }
                }
            }
        }

        return view('timesheet.report_attendances.export', compact('dates', 'datas', 'last_month', 'holidays'));
    }
}
