<?php

namespace App\Http\Controllers\API;

use Auth;
use App\BPJSTK;
use App\BPJSKes;
use App\Employee;
use App\company;
use App\department;
use App\leave;
use App\LeaveType;
use App\Holiday;
use App\office_shift;
use App\Http\Controllers\Controller;
use App\Http\Resources\EmployeeResource;
use App\Http\traits\TotalSalaryTrait;
use App\Payslip;
use App\PTKP;
use App\ReportAttendance;
use App\Reimbursement;
use App\ReimbursementType;
use App\SalaryBasic;
use App\SalaryLoan;
use App\Tax;
use App\Travel;
use App\TravelType;
use App\Notifications\ReimburseNotifyAdmin;
use App\Notifications\TravelNotifyAdmin;

use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Exception;
use Illuminate\Http\Request;
//Notification
use App\Notifications\EmployeeLeaveNotification; //Mail
use App\Notifications\LeaveNotification; //Database
use App\Notifications\LeaveNotificationToAdmin; //Database
use App\Notifications\ReimburseRequestNotify;
use App\Notifications\TravelRequestNotify;
use App\Notifications\EmployeeTravelStatus;
use App\User;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Validator;
use Response;

class EmployeeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    use TotalSalaryTrait;
	 public function index()
    {
        $employee = Employee::withCount('attendances')->where('id', Auth::user()->id)->get();
        return response([ 'employee' => new 
        EmployeeResource($employee), 'success' => true], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Employee  $employee
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
		$employee = Employee::withCount('attendances')->where('id', Auth::user()->id)->get();
        return response([ 'employee' => new 
        EmployeeResource($employee), 'success' => true], 200);
    }

    public function payslip(Request $request) {
        $month_year = $request->filter_month_year;
		$first_date = date('Y-m-d', strtotime('first day of ' . $month_year));
		$last_date = date('Y-m-d', strtotime('last day of ' . $month_year));

        $employee = Employee::with([
			'salaryBasic' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'kehadiran' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'allowances' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'commissions' => function ($query) use ($first_date) {
				$query->where('first_date', $first_date);
			},
			'loans' => function ($query) use ($first_date) {
				$query->where('first_date', '<=', $first_date)
                ->where('amount_remaining', '!=', 0)
					->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'deductions' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'otherPayments' => function ($query) use ($first_date) {
				$query->where('first_date', $first_date);
			},
			'overtimes' => function ($query) use ($month_year) {
				$query->where('month_year', $month_year);
			},
			'designation', 'department', 'user', 'setting',
			'employeeAttendance' => function ($query) use ($first_date, $last_date) {
				$query->whereBetween('attendance_date', [$first_date, $last_date]);
			},
            'user:id,username', 'company.Location.country',
			'department:id,department_name', 'designation:id,designation_name',
		])
        ->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.contact_no', 'employees.last_name', 'employees.basic_salary', 'employees.basic_salary_custom', 'employees.tunjangan_jabatan', 'employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.designation_id', 'employees.department_id', 'employees.joining_date', 'employees.dependent', 'ptkp.value as ptkp')
        ->leftjoin('ptkp', [
                'employees.company_id' => 'ptkp.company_id',
                'employees.dependent' => 'ptkp.name'
        ])
		->findOrFail(Auth::user()->id);
        
        //payslip_type && salary_basic
		foreach ($employee->salaryBasic as $salaryBasic) {
			if ($salaryBasic->first_date <= $first_date) {
				// $basic_salary = $salaryBasic->basic_salary;
				// $tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;
				// $basic_salary_custom = $salaryBasic->basic_salary_custom;
				// $total_gaji_tunjangan = $basic_salary+$tunjangan_jabatan;
				// $payslip_type = $salaryBasic->payslip_type;

				$basic_salary = $salaryBasic->basic_salary;
				$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;

				if($salaryBasic->basic_salary_custom == 0)
				{
					$basic_salary_custom = $salaryBasic->basic_salary;
				}
				else
				{
					$basic_salary_custom = $salaryBasic->basic_salary_custom;
				}

				$total_gaji_tunjangan = $basic_salary+$tunjangan_jabatan;
				$payslip_type = $salaryBasic->payslip_type;
			}
		}
        
		//dd($employee->salaryBasic);
		if($employee->salaryBasic->isEmpty()) {
			return response([ 'data' => 'Basic salary tidak ditemukan', 'success' => false], 404);
		}

        $prev_month = Carbon::createFromFormat('Y-m-d', $first_date)->subMonth();
        $cut_off_start = $prev_month->day(16);
        $cut_off_end = Carbon::createFromFormat('Y-m-d', $first_date)->day(15);
        $attendances = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end);
		
        $work_days = $attendances->count();
        $number_cut = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end)->whereIn('status', ['TA1', 'TA2', 'TA3'])->where('is_checked', 0)->count();
        if($work_days == 0) {
            $salary_cut_amount = 0;
        } else {
            $salary_cut_amount = $basic_salary/$work_days*$number_cut;
        }
		//TAMBAHAN UANG KEHADIRAN
		$salary_kehadiran = 0;
		if (!$employee->kehadiran->isEmpty()) {
			foreach ($employee->kehadiran as $item) {
				if ($item->first_date <= $first_date) {
					$salary_kehadiran = $item->salary_kehadiran * $work_days;
				}
			}
		} else {
			$salary_kehadiran = 0;
		}
		
        // $pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan);
        // $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
        // $jkk = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
        // $jkm = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
        // $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
        // $bpjskes = BPJSKes::where('company_id', $employee->company_id)->first();
        // $nilai_jht = $basic_salary_custom*($jht->employee ?? 0)/100;
        // $nilai_jkk = $basic_salary_custom*($jkk->employee ?? 0)/100;
        // $nilai_jkm = $basic_salary_custom*($jkm->employee ?? 0)/100;
        // $nilai_pensiun = $basic_salary_custom*($pensiun->employee ?? 0)/100;
        // $nilai_kes = $basic_salary_custom*($bpjskes->employee ?? 0)/100;
        // $pension_amount = $nilai_jht+$nilai_pensiun;

		$pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan);
		$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();   
		$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
		$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
		$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
		$bpjskes = BPJSKes::where('id', 1)->first();


        // $salary = $employee->salaryBasic[0];
		// if($salary->basic_salary_custom == 0)
		// {
		// 	$basic_salary_custom = $salary->basic_salary;
		// }
		// else
		// {
		// 	$basic_salary_custom = $salary->basic_salary_custom;
		// }

		$basicsalaryjht = $basic_salary_custom;
		if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
		{
			$basicsalaryjht = $jht->max_salary;
		}

		$basicsalarykes = $basic_salary_custom;
		if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
		{
			$basicsalarykes = $bpjskes->max_salary;
		}

        $nilai_jht = $basicsalaryjht*($jht->employee ?? 0)/100;
        $nilai_jkk = $basic_salary_custom*($jkk->employee ?? 0)/100;
        $nilai_jkm = $basic_salary_custom*($jkm->employee ?? 0)/100;
        $nilai_pensiun = $basic_salary_custom*($pensiun->employee ?? 0)/100;
        $nilai_kes = $basicsalarykes*($bpjskes->employee ?? 0)/100;
        $pension_amount = $nilai_jht+$nilai_pensiun;

        //Pension Amount

		$type          = "getArray";
		$allowances    = $this->allowances($employee, $first_date, $type, $work_days);
		$deductions    = $this->deductions($employee, $first_date, $type);
		$data = [];
        $data['month_year'] = $month_year;
		$data['basic_salary'] = $salaryBasic->basic_salary;
		$data['tunjangan_jabatan'] = $tunjangan_jabatan;
		$data['basic_total']  = $total_gaji_tunjangan;
		// $data['salary_kehadiran']   = number_format($salary_kehadiran, '0', ',', '.');
		$data['salary_kehadiran']   = $salary_kehadiran;
		$data['allowances']   = $allowances;
		$data['work_days']   = $work_days;
		$data['commissions']  = $employee->commissions;
		$data['loans']        = $employee->loans;
		$data['deductions']   = $deductions;
		$data['overtimes']    = $employee->overtimes;
		$data['other_payments'] = $employee->otherPayments;
		$data['pension_type']   = 'Percentage';
		$data['bpjs_kes'] = number_format($nilai_kes, '0', ',', '.');
		$data['bpjs_jht'] = number_format($nilai_jht, '0', ',', '.');
		$data['bpjs_jkk'] = number_format($nilai_jkk, '0', ',', '.');
		$data['bpjs_jkm'] = number_format($nilai_jkm, '0', ',', '.');
		$data['bpjs_pensiun'] = number_format($nilai_pensiun, '0', ',', '.');
        $data['attendance_cut_amount'] = number_format($salary_cut_amount, '0', ',', '.');

		$data['employee_id']          = $employee->id;
		$data['employee_full_name']   = $employee->full_name;
		$data['employee_designation'] = $employee->designation->designation_name ?? '';
		$data['employee_department']  = $employee->department->department_name ?? '';
		$data['employee_join_date']   = $employee->joining_date;
		$data['employee_username']    = $employee->user->username;
		$data['employee_pp']          = $employee->user->profile_photo ?? '';

		$data['payslip_type'] = $payslip_type;

		if ($payslip_type == 'Hourly') {
			$total = 0;
			$total_hours_worked = $this->totalWorkedHours($employee);
			$data['monthly_worked_hours'] = $total_hours_worked;
			//formatting in hour:min and separating them
			sscanf($total_hours_worked, '%d:%d', $hour, $min);
			//converting in minute
			$total += $hour * 60 + $min;

			$data['monthly_worked_amount'] = ($basic_salary / 60) * $total;

			$data['basic_total'] = $data['monthly_worked_amount'];
		}

		$type              = "getAmount";
		$allowance_amount  = $this->allowances($employee, $first_date, $type, $work_days);
		
		$pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan, $work_days, $first_date);
		
		$deduction_amount  = $this->deductions($employee, $first_date, $type);
        $data['allowance_amount'] = $allowance_amount;
		if ($payslip_type == 'Monthly') {
            $data['pph_bulanan'] = $pph_monthly;
			$data['total_salary'] = number_format($this->totalSalary($employee, $payslip_type, $total_gaji_tunjangan, $allowance_amount, $deduction_amount, $pph_monthly, $salary_cut_amount, $salary_kehadiran), 0, ',', '.');
		}

        return response([ 'data' => $data, 'success' => true], 200);
    }

	public function reimbursement_type() {
		$types = ReimbursementType::all();
		return response([ 'data' => $types, 'success' => true], 200);
	}

	public function reimbursement(Request $request) {
		$validator = Validator::make(
			$request->only(
				'reimbursement_type_id',
				'amount',
				'description',
				'reimbursement_attachments',
			),
			[
				'reimbursement_type_id' => 'required',
				'amount' => 'required',
				'description' => 'required',
				'reimbursement_attachments' => 'nullable|file|max:10240|mimes:jpeg,png,jpg,gif,ppt,pptx,doc,docx,pdf',
			]
		);

		if ($validator->fails()) {
			return response()->json(['success' => false, 'errors' => $validator->errors()->all()]);
		}

		$data = [];
		$data['employee_id'] = Auth::user()->id;
		$data['reimbursement_type_id'] = $request->reimbursement_type_id;
		$data['amount'] = $request->amount;
		$data['description'] = $request->description;
		$data['status'] = $request->status ?? 'pending';
		$file = $request->reimbursement_attachments;
		$file_name = null;
		if (isset($file)) {
			if ($file->isValid()) {
				$file_name = 'reimbursement_' . time() . '.' . $file->getClientOriginalExtension();
				$file->storeAs('reimbursement_attachments', $file_name);
				$data['attachment'] = $file_name;
			}
		}
		Reimbursement::create($data);
		
		$requester = Employee::findOrFail($data['employee_id']);
		$department = department::with('DepartmentHead:id')->where('id', $requester->department_id)->first();
		$text = "A new reimbursement has been requested by ". $requester->first_name ." ".$requester->last_name;
		if(!empty($department->department_head)) {
			$notifiable = User::findOrFail($department->department_head);
			$notifiable->notify(new ReimburseRequestNotify($text)); //To Department Head
		}

		if(!empty($department->supervisor)) {
			$notifiable = User::findOrFail($department->supervisor);
			$notifiable->notify(new ReimburseRequestNotify($text)); //To Supervisor
		}
		
		// HR Company
		$employee_info = Employee::find(Auth::user()->id);
		$users_hr = User::where('role_users_id', 6)
				->whereJsonContains('company_ids', (int)$employee_info->company_id)
				->get();
				
		foreach ($users_hr as $hr) {
			$hr->notify(new ReimburseNotifyAdmin($text));
		}
		
		return response()->json(['success' => true, 'message' => __('Data Added successfully.')]);
	}

	public function reimbursement_history(Request $request) {
		$perPage = $request->input('limit', 10); // Default limit per page is 10
        $page = $request->input('page', 1); // Default page is 1

		$reimburse = Reimbursement::where('employee_id', Auth::user()->id)
						->paginate($perPage, ['*'], 'page', $page);
						
		return Response::json($reimburse, 200);
	}

	public function leave_type(Request $request) {
		$leave_types = LeaveType::all();
		return response([ 'data' => $leave_types, 'success' => true], 200);
	}

	public function leave_history(Request $request) {
		// Set default values for pagination
        $perPage = $request->input('limit', 10); // Default limit per page is 10
        $page = $request->input('page', 1); // Default page is 1
    
        // Fetch paginated leave records for the authenticated user
        $leave = Leave::where('employee_id', Auth::user()->id)
                      ->paginate($perPage, ['*'], 'page', $page);
    
        // Return paginated data as JSON response
        return Response::json($leave, 200);
	}

	public function ask_leaves(Request $request) {
		$validator = Validator::make(
			$request->only('leave_type', 'start_date', 'end_date', 'total_days'),
			[
				'leave_type' => 'required',
				'total_days' => 'required',
				'start_date' => 'required',
				'end_date' => 'required|after_or_equal:start_date'
			]
		);
		if ($validator->fails()) {
			return response()->json(['success' => false, 'errors' => $validator->errors()->all()]);
		}

		$leave = LeaveType::findOrFail($request->leave_type);
		$employee = Employee::find(Auth::user()->id);
		$employee2 = leave::where('employee_id', $employee->id)
				->where('leave_type_id', $request->leave_type);
		
		if ($employee2->exists()) {
			$total = 0;
			$employee_leaves = $employee2->get();

			foreach ($employee_leaves as $employee_leave) {
				$total = $total + $employee_leave->total_days;
			}
			$total = $total + $request->diff_date_hidden;

			if ($leave->allocated_day != null && $leave->allocated_day < $total) {
				return response()->json(['success' => false, 'errors' => __('Allocated quota for this leave type is less then requested days for this employee')]);
			}
		} else {
			if ($leave->allocated_day != null && $leave->allocated_day < $request->diff_date_hidden) {
				return response()->json(['success' => false, 'errors' => __('Allocated quota for this leave type is less then requested days,You can select manual')]);
			}
		}

        ####CALCULATE TOTAL LEAVE DAYS###########
		$karyawan = $employee;
		$start_date = Carbon::parse($request->start_date);
		$end_date = Carbon::parse($request->end_date);
		$office_shift = office_shift::find($karyawan->office_shift_id); // Asumsikan ada satu shift yang digunakan
		$workdays = [];
		if ($office_shift->monday_in) {
			$workdays[] = Carbon::MONDAY;
		}
		if ($office_shift->tuesday_in) {
			$workdays[] = Carbon::TUESDAY;
		}
		if ($office_shift->wednesday_in) {
			$workdays[] = Carbon::WEDNESDAY;
		}
		if ($office_shift->thursday_in) {
			$workdays[] = Carbon::THURSDAY;
		}
		if ($office_shift->friday_in) {
			$workdays[] = Carbon::FRIDAY;
		}
		if ($office_shift->saturday_in) {
			$workdays[] = Carbon::SATURDAY;
		}
		if ($office_shift->sunday_in) {
			$workdays[] = Carbon::SUNDAY;
		}

		// Ambil data hari libur nasional
		$holidays = Holiday::where(function ($query) use ($start_date, $end_date) {
			$query->whereBetween('start_date', [$start_date, $end_date])
				->orWhereBetween('end_date', [$start_date, $end_date])
				->orWhere(function ($query) use ($start_date, $end_date) {
					$query->where('start_date', '<=', $start_date)
						->where('end_date', '>=', $end_date);
				});
		})->get();

		$total_leave_days = 0;

		for ($date = $start_date; $date->lte($end_date); $date->addDay()) {
			if (in_array($date->dayOfWeek, $workdays)) {
				// Cek apakah tanggal ini merupakan hari libur nasional
				$isHoliday = $holidays->contains(function ($holiday) use ($date) {
					return $date->between($holiday->start_date, $holiday->end_date);
				});

				if (!$isHoliday) {
					$total_leave_days++;
				}
			}
		}
		########END CALCULATE TOTAL LEAVE##########
        
		$data = [];
		$data['employee_id'] = $employee->id;
		$data['company_id'] = $employee->company_id;
		$data['department_id'] = $employee->department_id;
		$data['leave_type_id'] = $request->leave_type;
		$data['leave_reason'] = $request->leave_reason;
		$data['remarks'] = $request->remarks;
		$data['status'] = 'pending';
		$data['is_half'] = $request->is_half;
		$data['is_notify'] = $request->is_notify;
		$data['start_date'] = $request->start_date;
		$data['end_date'] = $request->end_date;
		$data['total_days'] = $total_leave_days;

		//Employee Remaining Leave --- Start
		if ($total_leave_days > $employee->remaining_leave) {
			return response()->json(['success' => false, 'errors' => "The employee's remaining leaves are insufficient"]);
		}
		//Employee Remaining Leave  --- End


		$leave = leave::create($data);

		$text = "A new leave-notification has been requested by ". $employee->first_name ." ".$employee->last_name;
		$notifiable = User::findOrFail($data['employee_id']);
		$notifiable->notify(new LeaveNotification($text)); //To Employee
		
		//Get All HR
		$companyId = $employee->company_id;
		$HR_user = User::whereJsonContains('company_ids', $companyId)->get();
		if($HR_user->count() > 0)
		{
			foreach($HR_user as $hr){
				$hr->notify(new LeaveNotification($text));
				
				if(!empty($hr->email))
				{
					Notification::route('mail', $hr->email)
					->notify(new EmployeeLeaveNotification(
						$leave->employee->full_name,
						$leave->total_days,
						$leave->start_date,
						$leave->end_date,
						$leave->leave_reason,
					));
				}
			}
		}

		//get-leave-notification - 294
		$role_ids = DB::table('role_has_permissions')->where('permission_id', 294)->get()->pluck('role_id');
		$role_ids[] = 1;

		$notifiable = User::whereIn('role_users_id', $role_ids)->get();
		foreach ($notifiable as $item) {
			$item->notify(new LeaveNotificationToAdmin());
		}

		//Mail
		$department = department::with('DepartmentHead:id,email')->where('id', $request->department_id)->first();

		if(!empty($department->department_head)) {
			$notifiable = User::findOrFail($department->department_head);
			$notifiable->notify(new LeaveNotification($text)); //To Department Head
			Notification::route('mail', $department->DepartmentHead->email)
				->notify(new EmployeeLeaveNotification(
					$leave->employee->full_name,
					$leave->total_days,
					$leave->start_date,
					$leave->end_date,
					$leave->leave_reason,
				));
		}

		if(!empty($department->supervisor)) {
			$notifiable = User::findOrFail($department->supervisor);
			$notifiable->notify(new LeaveNotification($text)); //To Supervisor
		}

		return response()->json(['success' => true, 'message' => __('Data Added successfully.')]);
	}

	protected function allowances($employee, $first_date, $type, $work_days = 0)
	{
		if ($type == "getArray") {
            $allowances = array();
            if (!$employee->allowances->isEmpty()) {
					foreach ($employee->allowances as $key => $value) {
						if ($value->first_date <= $first_date) {
							//$allowances = array();
							$allowances[] =  $employee->allowances[$key];
						}
					}
			} else {
				$allowances = [];
			}
			return $allowances;
		} elseif ($type == "getAmount") {
			$allowance_amount = 0;
			if (!$employee->allowances->isEmpty()) {
				foreach ($employee->allowances as $item) {
					if ($item->first_date <= $first_date) {
						if ($item->is_taxable == 1)
						{
							$allowance_amount += $item->allowance_amount;
						}
						else
						{
							$allowance_amount += $item->allowance_amount*$work_days;
						}
					}
				}
			}
			return $allowance_amount;
		}
	}

	protected function deductions($employee, $first_date, $type)
	{
		if ($type == "getAmount") {
			$deduction_amount = 0;
			if (!$employee->deductions->isEmpty()) {
				foreach ($employee->deductions as $item) {
					if ($item->first_date <= $first_date) {
						$deduction_amount = 0;
						foreach ($employee->deductions as $value) {
							if ($value->first_date <= $first_date) {
								if ($item->first_date == $value->first_date) {
									$deduction_amount += $value->deduction_amount;
								}
							}
						}
					}
				}
			}
			return $deduction_amount;
		} elseif ($type == "getArray") {
			if (!$employee->deductions->isEmpty()) {
				foreach ($employee->deductions as $item) {
					if ($item->first_date <= $first_date) {
						$deductions = array();
						foreach ($employee->deductions as $key => $value) {
							if ($value->first_date <= $first_date) {
								if ($item->first_date == $value->first_date) {
									$deductions[] =  $employee->deductions[$key];
								}
							}
						}
					}
				}
			} else {
				$deductions = [];
			}
			return $deductions;
		}
	}
	
	# Travel
	public function travel_type() {
		$types = TravelType::all();
		return response([ 'data' => $types, 'success' => true], 200);
	}
	
	public function travel_mode() {
		$mode = ["By Bus", "By Train", "By Plane", "By Taxi", "By Rental Car", "By Other"];

		return response([ 'data' => $mode, 'success' => true], 200);
	}

	public function travel(Request $request) {
		$validator = Validator::make(
			$request->only(
				'description',
				'travel_type_id',
				'travel_mode',
				'start_date',
				'end_date',
				'purpose_of_visit',
				'place_of_visit',
				'expected_budget',
				'actual_budget'
			),
			[
				'travel_type_id' => 'required',
				'place_of_visit' => 'required',
				'purpose_of_visit' => 'required',
				'start_date' => 'required',
				'end_date' => 'required|after_or_equal:start_date',
			]
		);

		if ($validator->fails()) {
			return response()->json(['success' => false, 'errors' => $validator->errors()->all()]);
		}

		$data = [];

		$data['employee_id'] = Auth::user()->id;
		$data['company_id'] = Auth::user()	->company_ids;
		$data['travel_type'] = $request->travel_type_id;
		$data['description'] = $request->description;
		$data['travel_mode'] = $request->travel_mode;
		$data['purpose_of_visit'] = $request->purpose_of_visit;
		$data['place_of_visit'] = $request->place_of_visit;
		$data['expected_budget'] = $request->expected_budget;
		$data['actual_budget'] = $request->actual_budget;
		$data['status'] = "Pending";
		$data['start_date'] = $request->start_date;
		$data['end_date'] = $request->end_date;


		$travel = Travel::create($data);

		if ($travel->status != 'pending') {
			$notifiable = User::findOrFail($data['employee_id']);

			$notifiable->notify(new EmployeeTravelStatus($travel->status));
		}
		
		$requester = Employee::findOrFail($data['employee_id']);
		$department = department::with('DepartmentHead:id')->where('id', $requester->department_id)->first();
		$text = "A new travel-notification has been requested by ". $requester->first_name ." ".$requester->last_name;
		if(!empty($department->supervisor)) {
			$notifiable = User::findOrFail($department->department_head);
			$notifiable->notify(new TravelRequestNotify($text)); //To Department Head
		}

		if(!empty($department->supervisor)) {
			$notifiable = User::findOrFail($department->supervisor);
			$notifiable->notify(new TravelRequestNotify($text)); //To Supervisor
		}
		
		// HR Company
		$employee_info = Employee::find(Auth::user()->id);
		$users_hr = User::where('role_users_id', 6)
				->whereJsonContains('company_ids', (int)$employee_info->company_id)
				->get();
				
		foreach ($users_hr as $hr) {
			$hr->notify(new TravelNotifyAdmin($text));
		}

		return response()->json(['success' => true, 'message' => __('Data Added successfully.')]);
	}

	public function travel_history(Request $request) {
		$perPage = $request->input('limit', 10); // Default limit per page is 10
        $page = $request->input('page', 1); // Default page is 1
        
		$travel = Travel::with('TravelType', 'company')->where('employee_id', Auth::user()->id)
						->paginate($perPage, ['*'], 'page', $page);

		return Response::json($travel, 200);
	}
	
}
