<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class LoginController extends Controller
{
	public function login(Request $request)
    {
        $data = $request->validate([
            'username' => 'required',
            'password' => 'required'
        ]);

        if (!auth()->attempt($data)) {
            return response(['errors' => 'Incorrect Details. Please try again', 'success' => false]);
        }
        if(auth()->user()->role_users_id == 2 || auth()->user()->role_users_id == 4 || auth()->user()->role_users_id == 7) {
            $token = auth()->user()->createToken('API Token')->accessToken;
            return response(['success' => true, 'token' => $token]);
        } else {
            return response(['errors' => 'Access is not authorized', 'success' => false]);
        }
    }
}
