<?php

namespace App\Http\Controllers;

use App\company;
use App\Employee;
use App\Http\Controllers\Controller;
use App\MailReceiver;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class MailReceiverController extends Controller
{
    public function index()
    {
        $logged_user = auth()->user();
        $companyId = null;
        if ($logged_user->role_users_id == 6) {
            $companyId = json_decode($logged_user->company_ids);
        }
        $companies = company::select('id', 'company_name')->get();

        if ($logged_user->can('view-mail-receiver')) {
            if (request()->ajax()) {
                $mails = MailReceiver::with(['employee', 'employee.company']);
                if ($companyId) {
                    $mails = $mails->whereHas('employee', function ($query) use ($companyId) {
                        return $query->whereIn('company_id', $companyId);
                    });
                }
                return datatables()->of($mails->get())
                    ->setRowId(function ($ptkp) {
                        return $ptkp->id;
                    })
                    ->addColumn('name', function ($row) {
                        return $row->employee->first_name . ' ' . $row->employee->last_name;
                    })
                    ->addColumn('company', function ($row) {
                        return $row->employee->company->company_name;
                    })
                    ->addColumn('action', function ($data) {
                        $button = '';
                        if (auth()->user()->can('delete-mail-receiver')) {
                            $button .= '<button type="button" name="delete" id="' . $data->id . '" class="delete btn btn-danger btn-sm"><i class="dripicons-trash"></i></button>';
                        }

                        return $button;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
            }

            return view('core_hr.mail_receiver.index', compact('companies'));
        }

        return abort('403', __('You are not authorized'));
    }

    public function store(Request $request)
    {
        $logged_user = auth()->user();

        if ($logged_user->can('store-mail-receiver')) {
            $validator = Validator::make(
                $request->only(
                    'employee_id',
                ),
                [
                    'employee_id' => 'required',
                ]
            );


            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()->all()]);
            }


            $data = [];

            $data['employee_id'] = $request->employee_id;
            MailReceiver::create($data);

            return response()->json(['success' => __('Data Added successfully.')]);
        }

        return response()->json(['success' => __('You are not authorized')]);
    }


    public function destroy($id)
    {
        if (!env('USER_VERIFIED')) {
            return response()->json(['error' => 'This feature is disabled for demo!']);
        }
        $logged_user = auth()->user();

        if ($logged_user->can('delete-mail-receiver')) {
            MailReceiver::whereId($id)->delete();

            return response()->json(['success' => __('Data is successfully deleted')]);
        }
        return response()->json(['success' => __('You are not authorized')]);
    }

    public function delete_by_selection(Request $request)
    {
        if (!env('USER_VERIFIED')) {
            return response()->json(['error' => 'This feature is disabled for demo!']);
        }
        $logged_user = auth()->user();

        if ($logged_user->can('delete-mail-receiver')) {

            $mail_receiver_id = $request['mailReceiverIdArray'];
            $mailReceiver = MailReceiver::whereIntegerInRaw('id', $mail_receiver_id);
            if ($mailReceiver->delete()) {
                return response()->json(['success' => __('Multi Delete', ['key' => __('Mail Receiver')])]);
            } else {
                return response()->json(['error' => 'Error, selected Mail Receiver can not be deleted']);
            }
        }
        return response()->json(['success' => __('You are not authorized')]);
    }
}
