<?php

namespace App\Http\Controllers;

use App\PTKP;
use App\company;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PTKPController extends Controller
{
    public function index()
    {
        $logged_user = auth()->user();
        $companies = company::select('id', 'company_name')->get();

        if ($logged_user->can('view-ptkp')) {
            if (request()->ajax()) {
                return datatables()->of(PTKP::with('company')->get())
                    ->setRowId(function ($ptkp) {
                        return $ptkp->id;
                    })
                    ->addColumn('name', function ($row) {
                        return $row->name;
                    })
                    ->addColumn('company_name', function ($row) {
                        return $row->company->company_name;
                    })
                    ->addColumn('value', function ($row) {
                        return $row->value_formatted;
                    })
                    ->addColumn('action', function ($data) {
                        $button = '<button type="button" name="show" id="' . $data->id . '" class="show_new btn btn-success btn-sm"><i class="dripicons-preview"></i></button>';
                        $button .= '&nbsp;&nbsp;';
                        if (auth()->user()->can('edit-ptkp')) {
                            $button .= '<button type="button" name="edit" id="' . $data->id . '" class="edit btn btn-primary btn-sm"><i class="dripicons-pencil"></i></button>';
                            $button .= '&nbsp;&nbsp;';
                        }
                        if (auth()->user()->can('delete-ptkp')) {
                            $button .= '<button type="button" name="delete" id="' . $data->id . '" class="delete btn btn-danger btn-sm"><i class="dripicons-trash"></i></button>';
                        }

                        return $button;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
            }

            return view('core_hr.ptkp.index', compact('companies'));
        }

        return abort('403', __('You are not authorized'));
    }

    public function store(Request $request)
    {
        $logged_user = auth()->user();

        if ($logged_user->can('store-ptkp')) {
            $validator = Validator::make(
                $request->only(
                    'company_id',
                    'name',
                    'value',
                ),
                [
                    'company_id' => 'required',
                    'name' => 'required',
                    'value' => 'required',
                ]
            );


            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()->all()]);
            }


            $data = [];

            $data['company_id'] = $request->company_id;
            $data['name'] = $request->name;
            $data['value'] = $request->value;
            PTKP::create($data);

            return response()->json(['success' => __('Data Added successfully.')]);
        }

        return response()->json(['success' => __('You are not authorized')]);
    }

    public function edit($id)
	{
		if (request()->ajax())
		{
			$data = PTKP::with('company')->findOrFail($id);

			return response()->json(['data' => $data]);
		}
	}

    public function update(Request $request)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('edit-ptkp'))
		{
			$id = $request->hidden_id;

            $validator = Validator::make(
                $request->only(
                    'company_id',
                    'name',
                    'value',
                ),
                [
                    'company_id' => 'required',
                    'name' => 'required',
                    'value' => 'required',
                ]
            );


			if ($validator->fails())
			{
				return response()->json(['errors' => $validator->errors()->all()]);
			}


			$data = [];

            $data['company_id'] = $request->company_id;
            $data['name'] = $request->name;
            $data['value'] = $request->value;

			PTKP::find($id)->update($data);

			return response()->json(['success' => __('Data is successfully updated')]);
		}
		return response()->json(['success' => __('You are not authorized')]);
	}

    public function destroy($id)
	{
		if(!env('USER_VERIFIED'))
		{
			return response()->json(['error' => 'This feature is disabled for demo!']);
		}
		$logged_user = auth()->user();

		if ($logged_user->can('delete-ptkp'))
		{
			PTKP::whereId($id)->delete();

			return response()->json(['success' => __('Data is successfully deleted')]);
		}
		return response()->json(['success' => __('You are not authorized')]);
	}
    public function delete_by_selection(Request $request)
	{
		if(!env('USER_VERIFIED'))
		{
			return response()->json(['error' => 'This feature is disabled for demo!']);
		}
		$logged_user = auth()->user();

		if ($logged_user->can('delete-ptkp'))
		{

			$ptkp_id = $request['ptkpIdArray'];
			$ptkp = PTKP::whereIntegerInRaw('id', $ptkp_id);
			if ($ptkp->delete())
			{
				return response()->json(['success' => __('Multi Delete', ['key' => __('BPJS TK')])]);
			} else
			{
				return response()->json(['error' => 'Error, selected BPJS TK can not be deleted']);
			}
		}
		return response()->json(['success' => __('You are not authorized')]);
	}
    public function show($id)
	{
		if (request()->ajax())
		{
			$data = PTKP::with('company')->findOrFail($id);
			return response()->json(['data' => $data]);
		}
	}
}
