<?php

namespace App\Http\Controllers;

use App\company;
use App\BPJSTK;
use App\BPJSKes;
use App\Employee;
use App\FinanceBankCash;
use App\FinanceExpense;
use App\FinanceTransaction;
use App\Http\traits\TotalSalaryTrait;
use App\Payslip;
use App\PTKP;
use App\ReportAttendance;
use App\SalaryBasic;
use App\SalaryLoan;
use App\Tax;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Throwable;
use App\Http\traits\MonthlyWorkedHours;

use App\Exports\PayslipExport;
use App\Exports\SlipExport;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade as PDF;

class PayrollController extends Controller
{

	use TotalSalaryTrait;
	use MonthlyWorkedHours;

	public function index(Request $request)
	{
		$logged_user = auth()->user();
		// $companies = company::all();
		if ($logged_user->role_users_id == 6) {
			$companyId = json_decode($logged_user->company_ids);
			
			$companies = company::select('id', 'company_name')->whereIn('id', $companyId)->get();
		}
		else if($logged_user->role_users_id == 1) {
			$companies = company::select('id', 'company_name')->get();
		}

		$selected_date = empty($request->filter_month_year) ? now()->format('F-Y') : $request->filter_month_year;
		$first_date = date('Y-m-d', strtotime('first day of ' . $selected_date));
		$last_date = date('Y-m-d', strtotime('last day of ' . $selected_date));

		if ($logged_user->can('view-paylist')) {
			if (request()->ajax()) {
				$paid_employees = Payslip::where('month_year', $selected_date)->pluck('employee_id');
				$salary_basic_employees = SalaryBasic::where('first_date', '<=', $first_date)->distinct()->pluck('employee_id');
				$totalSalarySum = 0;
				$pphMonthlySum = 0;

				if (!empty($request->filter_company && $request->filter_department)) {
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'allowances' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'kehadiran' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'commissions' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'loans' => function ($query) use ($first_date) {
							$query->where('first_date', '<=', $first_date)
								->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'deductions' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'otherPayments' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'overtimes' => function ($query) use ($selected_date) {
							$query->where('month_year', $selected_date);
						},
						'payslips' => function ($query) use ($selected_date) {
							$query->where('month_year', $selected_date);
						},
						'employeeAttendance' => function ($query) use ($first_date, $last_date) {
							$query->whereBetween('attendance_date', [$first_date, $last_date]);
						}
					])
						->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary_custom', 'employees.basic_salary','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
                        ->leftjoin('ptkp', [
                            'employees.company_id' => 'ptkp.company_id',
                            'employees.dependent' => 'ptkp.name'
                        ])
						->where('employees.company_id', $request->filter_company)
						->where('employees.department_id', $request->filter_department)
						->whereIntegerInRaw('employees.id', $salary_basic_employees)
						->whereIntegerNotInRaw('employees.id', $paid_employees)
						->where('employees.is_active', 1)
						->where('employees.exit_date', NULL)
						->get();
				} elseif (!empty($request->filter_company)) {
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'kehadiran' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'allowances' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'commissions' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'loans' => function ($query) use ($first_date) {
							$query->where('first_date', '<=', $first_date)
								->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'deductions' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'otherPayments' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'overtimes' => function ($query) use ($selected_date) {
							$query->where('month_year', $selected_date);
						},
						'payslips' => function ($query) use ($selected_date) {
							$query->where('month_year', $selected_date);
						},
						'employeeAttendance' => function ($query) use ($first_date, $last_date) {
							$query->whereBetween('attendance_date', [$first_date, $last_date]);
						}
					])
                        ->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary','employees.basic_salary_custom','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
                        ->leftjoin('ptkp', [
                            'employees.company_id' => 'ptkp.company_id',
                            'employees.dependent' => 'ptkp.name'
                        ])
						->where('employees.company_id', $request->filter_company)
						->whereIntegerInRaw('employees.id', $salary_basic_employees)
						->whereIntegerNotInRaw('employees.id', $paid_employees)
						->where('employees.is_active', 1)->where('employees.exit_date', NULL)
						->get();
				} else {
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'kehadiran' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'allowances' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'commissions' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'loans' => function ($query) use ($first_date) {
							$query->where('first_date', '<=', $first_date)
                            ->where('amount_remaining', '!=', 0)
								->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'deductions' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'otherPayments' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'overtimes' => function ($query) use ($selected_date) {
							$query->where('month_year', $selected_date);
						},
						'payslips' => function ($query) use ($selected_date) {
							$query->where('month_year', $selected_date);
						},
						'employeeAttendance' => function ($query) use ($first_date, $last_date) {
							$query->whereBetween('attendance_date', [$first_date, $last_date]);
						}
					])
						->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary','employees.basic_salary_custom','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
                        ->leftjoin('ptkp', [
                            'employees.company_id' => 'ptkp.company_id',
                            'employees.dependent' => 'ptkp.name'
                        ])
						//->whereIntegerInRaw('id',$salary_basic_employees)
						// ->whereIntegerNotInRaw('id',$paid_employees)
						->whereIntegerInRaw('employees.id', $salary_basic_employees)
						->whereIntegerNotInRaw('employees.id', $paid_employees)
						->where('is_active', 1)
						->where('exit_date', NULL)
						->get();
				}
				
				$totalSalarySum = 0;
				$pphMonthlySum = 0;
				$totalBpjsTk = 0;
				$totalBpjsKes = 0;
				$totalBpjsTkComp = 0;
				$totalBpjsKesComp = 0;
				$tanggungan = 0;

				foreach ($employees as $employee) {
					//payslip_type & basic_salary
					foreach ($employee->salaryBasic as $salaryBasic) {
						if ($salaryBasic->first_date <= $first_date) {
							$payslip_type = $salaryBasic->payslip_type;
							$basicsalary = $salaryBasic->basic_salary;
							$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;
							// $basicsalarycustom = $salaryBasic->basic_salary_custom;
							$total_gaji_tunjangan = $basicsalary+$tunjangan_jabatan;
							$tanggungan = $salaryBasic->tanggungan_kes;

							if($salaryBasic->basic_salary_custom == 0)
							{
								$basicsalarycustom = $salaryBasic->basic_salary;
							}
							else
							{
								$basicsalarycustom = $salaryBasic->basic_salary_custom;
							}
						}
					}
					
					// $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
					// $jkk = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
					// $jkm = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
					// $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
					// $bpjskes = BPJSKes::where('company_id', $employee->company_id)->first();
					$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();   
					$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
					$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
					$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
					// $bpjskes = BPJSKes::where('id', 1)->where('name', 'Kesehatan')->first();
					$bpjskes = BPJSKes::where('id', 1)->first();
					
					$basicsalaryjht = $basicsalarycustom;
					if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
					{
						$basicsalaryjht = $jht->max_salary;
					}
					
					$basicsalaryjp = $basicsalarycustom;
					$current_date = date('Y-m-d');
					$birth_date = $employee->date_of_birth;
					$age = date_diff(date_create($birth_date), date_create($current_date))->y;
					if ($age < 60) {
						if($pensiun->max_salary > 0 && $basicsalaryjp >= $pensiun->max_salary)
						{
							$basicsalaryjp = $pensiun->max_salary;
						}
					}
					else {
						$basicsalaryjp = 0;
					}

					$basicsalarykes = $basicsalarycustom;
					if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
					{
						$basicsalarykes = $bpjskes->max_salary;
					}

					$nilai_jht = $basicsalaryjht * ($jht->employee ?? 0) / 100;
                    $nilai_jkk = $basicsalarycustom * ($jkk->employee ?? 0) / 100;
                    $nilai_jkm = $basicsalarycustom * ($jkm->employee ?? 0) / 100;
                    $nilai_pensiun = $basicsalaryjp * ($pensiun->employee ?? 0) / 100;
                    $nilai_kes = $basicsalarykes * ($bpjskes->employee ?? 0) / 100;
                    
                    $bpjs_tk = $nilai_jht + $nilai_jkk + $nilai_jkm + $nilai_pensiun;
                    $nilai_tanggungan = $nilai_kes * $tanggungan;
                    $bpjs_kes = $nilai_kes + $nilai_tanggungan;
                    
                    $nilai_jht_comp = $basicsalarycustom * ($jht->company ?? 0) / 100;
                    $nilai_jkk_comp = $basicsalarycustom * ($jkk->company ?? 0) / 100;
                    $nilai_jkm_comp = $basicsalarycustom * ($jkm->company ?? 0) / 100;
                    $nilai_pensiun_comp = $basicsalaryjp * ($pensiun->company ?? 0) / 100;
                    $nilai_kes_comp = $basicsalarycustom * ($bpjskes->company ?? 0) / 100;
                    
                    $bpjs_tk_comp = $nilai_jht_comp + $nilai_jkk_comp + $nilai_jkm_comp + $nilai_pensiun_comp;
                    $bpjs_kes_comp = $nilai_kes_comp;

					$prev_month = Carbon::createFromFormat('Y-m-d', $first_date)->subMonth();
					$cut_off_start = $prev_month->day(16);
					$cut_off_end =  Carbon::createFromFormat('Y-m-d', $first_date)->day(15);
					$attendances = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end);
					$work_days = $attendances->count();
					$number_cut = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end)->whereIn('status', ['TA1', 'TA2', 'TA3'])->where('is_checked', 0)->count();

					if ($work_days == 0) {
						$salary_cut_amount = 0;
					} else {
						$salary_cut_amount = $basicsalary / $work_days * $number_cut;
					}
					
					$salary_kehadiran = 0;
            		if (!$employee->kehadiran->isEmpty()) {
            			foreach ($employee->kehadiran as $item) {
            				if ($item->first_date <= $first_date) {
            					$salary_kehadiran = $item->salary_kehadiran * $work_days;
            				}
            			}
            		} else {
            			$salary_kehadiran = 0;
            		}

					$type = "getAmount";
					$allowance_amount = $this->allowances($employee, $first_date, $type, $work_days);
					
					$current_month = date('m', strtotime($selected_date));
				// 	if ($current_month == '12') {
    //                     $first_date_of_year = $current_year . '-01-01'; // January 1st
    //                     $last_date_of_year = $current_year . '-12-31'; // December 31st
				// 	}
				// 	$pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan, $work_days, $first_date); 
				    $pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan, $work_days, $first_date, $salary_kehadiran);
					
					$deduction_amount = $this->deductions($employee, $first_date, $type);
					$salary_cut_attendance = $salary_cut_amount;
					//TAMBAHAN UANG KEHADIRAN
					if (!$employee->kehadiran->isEmpty()) {
						foreach ($employee->kehadiran as $item) {
							if ($item->first_date <= $first_date) {
								$salary_kehadiran = $item->salary_kehadiran * $work_days;
							}
						}
					} else {
						$salary_kehadiran = 0;
					}
					//Net Salary
					if ($payslip_type == 'Monthly') {
						// $pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan);

						$total_salary = $this->totalSalary($employee, $payslip_type, $total_gaji_tunjangan, $allowance_amount, $deduction_amount, $pph_monthly, $salary_cut_attendance, $salary_kehadiran);
					} else {
						$total = 0;
						$total_hours = $this->totalWorkedHours($employee);
						sscanf($total_hours, '%d:%d', $hour, $min);
						$total += $hour * 60 + $min;

						$total_salary = $this->totalSalary($employee, $payslip_type, $total_gaji_tunjangan, $allowance_amount, $deduction_amount, $pension_amount, 0, $total);
					}

					$totalSalarySum += $total_salary;
					$pphMonthlySum += $pph_monthly;
					$totalBpjsTk += $bpjs_tk;
					$totalBpjsKes += $bpjs_kes;
					$totalBpjsTkComp += $bpjs_tk_comp;
					$totalBpjsKesComp += $bpjs_kes_comp;

					// Add additional properties to the employee object
					$employee->total_salary = number_format($total_salary, 0, ',', '.');
					$employee->salary_kehadiran = number_format($salary_kehadiran, 0, ',', '.');
				}
				$totalSalarySumFormatted = number_format($totalSalarySum, 0, ',', '.');
				$pphMonthlySumFormatted = number_format($pphMonthlySum, 0, ',', '.');
				$bpjsTkSumFormatted = number_format($totalBpjsTk, 0, ',', '.');
				$bpjsKesSumFormatted = number_format($totalBpjsKes, 0, ',', '.');
				$bpjsTkCompSumFormatted = number_format($totalBpjsTkComp, 0, ',', '.');
				$bpjsKesCompSumFormatted = number_format($totalBpjsKesComp, 0, ',', '.');
				
				return datatables()->of($employees)
					->setRowId(function ($pay_list) {
						return $pay_list->id;
					})
					->addColumn('employee_name', function ($row) {
						return $row->full_name;
					})
					->addColumn('payslip_type', function ($row) use ($first_date) {
						foreach ($row->salaryBasic as $salaryBasic) {
							if ($salaryBasic->first_date <= $first_date) {
								$payslip_type = $salaryBasic->payslip_type; //payslip_type
							}
						}
						return $payslip_type;
					})
					->addColumn('basic_salary', function ($row) use ($first_date) {
						foreach ($row->salaryBasic as $salaryBasic) {
							if ($salaryBasic->first_date <= $first_date) {
								$basicsalary = $salaryBasic->basic_salary; //basic salary
								$basicsalary =  number_format($basicsalary, 0, ',', '.');
							}
						}
						return $basicsalary;
					})
					->addColumn('tunjangan_jabatan', function ($row) use ($first_date) {
						foreach ($row->salaryBasic as $salaryBasic) {
							if ($salaryBasic->first_date <= $first_date) {
								$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan; //basic salary
								$tunjangan_jabatan =  number_format($tunjangan_jabatan, 0, ',', '.');
							}
						}
						return $tunjangan_jabatan;
					})
					
					->addColumn('uang_kehadiran', function ($row) use ($first_date) {
						return $row->salary_kehadiran;
					})
					->addColumn('net_salary', function ($row) use ($first_date) {
						return $row->total_salary; // Access the previously added total_salary property
					})
					->addColumn('status', function ($row) {
						foreach ($row->payslips as $payslip) {
							$status = $payslip->status;

							return $status;
						}
					})
					->addColumn('action', function ($data) {
						if (auth()->user()->can('view-paylist')) {
							if (auth()->user()->can('make-payment')) {
								$button = '<button type="button" name="view" id="' . $data->id . '" class="details btn btn-primary btn-sm" title="Details"><i class="dripicons-preview"></i></button>';
								$button .= '&nbsp;&nbsp;';
								$button .= '<button type="button" data-export="pdf" id="' . $data->id . '" class="exports btn btn-danger btn-sm" title="Details"><i class="fa fa-file-pdf-o"></i></button>';
                                $button .= '&nbsp;&nbsp;';
								$button .= '<button type="button" data-export="excel" id="' . $data->id . '" class="exports_xls btn btn-danger btn-sm" title="Details"><i class="fa fa-file-excel-o"></i></button>';
                                $button .= '&nbsp;&nbsp;';
								$button .= '<button type="button" name="payment" id="' . $data->id . '" class="generate_payment btn btn-success btn-sm" title="generate_payment"><i class="fa fa-money"></i></button>';
								$button .= '&nbsp;&nbsp;';
								// $button .= '<button type="button" name="payment" id="' . $data->id . '" class="payment_slip btn btn-warning btn-sm" title="payment_slip">Payslip</button>';
								$button .= '<button type="button" name="payslip" id="' . $data->id . '" class="payment_slip_exp btn btn-warning btn-sm" title="payment_slip">Payslip Export</button>';
                                
							} else {
								$button = '';
							}
							return $button;
						} else {
							return '';
						}
					})
					->with('total_salary_sum', $totalSalarySumFormatted) // Pass the total salary sum to the view
					->with('pph_monthly_sum', $pphMonthlySumFormatted) // Pass the PPH monthly sum to the view
					->with('bpjs_tk_sum', $bpjsTkSumFormatted) // Pass the BPJS TK sum to the view
					->with('bpjs_kes_sum', $bpjsKesSumFormatted) // Pass the BPJS Kes sum to the view
					->with('bpjs_tk_sum_comp', $bpjsTkCompSumFormatted) // Pass the BPJS TK sum to the view
					->with('bpjs_kes_sum_comp', $bpjsKesCompSumFormatted) // Pass the BPJS Kes sum to the view
					->rawColumns(['action'])
					->make(true);
			}
            
			return view('salary.pay_list.index', compact('companies'));
		}

		return abort('403', __('You are not authorized'));
	}

// 	public function bpjs(Request $request) {
// 		$logged_user = auth()->user();
// 		// $companies = company::all();
// 		if ($logged_user->role_users_id == 6) {
// 			$companyId = json_decode($logged_user->company_ids);
			
// 			$companies = company::select('id', 'company_name')->whereIn('id', $companyId)->get();
// 		}
// 		else if($logged_user->role_users_id == 1) {
// 			$companies = company::select('id', 'company_name')->get();
// 		}

// 		$selected_date = empty($request->filter_month_year) ? now()->format('F-Y') : $request->filter_month_year;
// 		$first_date = date('Y-m-d', strtotime('first day of ' . $selected_date));
// 		$last_date = date('Y-m-d', strtotime('last day of ' . $selected_date));
// 		if ($logged_user->can('view-paylist')) {
// 			if (request()->ajax()) {
// 				$paid_employees = Payslip::where('month_year', $selected_date)->pluck('employee_id');
// 				$salary_basic_employees = SalaryBasic::where('first_date', '<=', $first_date)->distinct()->pluck('employee_id');
// 				$totalSalarySum = 0;
// 				$pphMonthlySum = 0;

// 				if (!empty($request->filter_company && $request->filter_department)) {
// 					$employees = Employee::with([
// 						'salaryBasic' => function ($query) {
// 							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
// 						},
// 					])
// 					->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary_custom', 'employees.basic_salary','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp')
// 					->leftjoin('ptkp', [
// 						'employees.company_id' => 'ptkp.company_id',
// 						'employees.dependent' => 'ptkp.name'
// 					])
// 					->where('employees.company_id', $request->filter_company)
// 					->where('employees.department_id', $request->filter_department)
// 					->whereIntegerInRaw('employees.id', $salary_basic_employees)
// 					->whereIntegerNotInRaw('employees.id', $paid_employees)
// 					->where('employees.is_active', 1)
// 					->where('employees.exit_date', NULL)
// 					->get();
// 				} elseif (!empty($request->filter_company)) {
// 					$employees = Employee::with([
// 						'salaryBasic' => function ($query) {
// 							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
// 						},
// 					])
//                         ->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary','employees.basic_salary_custom','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp')
//                         ->leftjoin('ptkp', [
//                             'employees.company_id' => 'ptkp.company_id',
//                             'employees.dependent' => 'ptkp.name'
//                         ])
// 						->where('employees.company_id', $request->filter_company)
// 						->whereIntegerInRaw('employees.id', $salary_basic_employees)
// 						->whereIntegerNotInRaw('employees.id', $paid_employees)
// 						->where('employees.is_active', 1)->where('employees.exit_date', NULL)
// 						->get();
// 				} else {
// 					$employees = Employee::with([
// 						'salaryBasic' => function ($query) {
// 							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
// 						},
// 					])
// 					->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary','employees.basic_salary_custom','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp')
// 					->leftjoin('ptkp', [
// 						'employees.company_id' => 'ptkp.company_id',
// 						'employees.dependent' => 'ptkp.name'
// 					])
// 					//->whereIntegerInRaw('id',$salary_basic_employees)
// 					// ->whereIntegerNotInRaw('id',$paid_employees)
// 					->whereIntegerInRaw('employees.id', $salary_basic_employees)
// 					->whereIntegerNotInRaw('employees.id', $paid_employees)
// 					->where('is_active', 1)
// 					->where('exit_date', NULL)
// 					->get();
// 				}
				
// 				$pphMonthlySum = 0;
// 				$totalBpjsTk = 0;
// 				$totalBpjsKes = 0;
// 				$totalBpjsTkComp = 0;
// 				$totalBpjsKesComp = 0;

// 				foreach ($employees as $employee) {
// 					//payslip_type & basic_salary
// 					foreach ($employee->salaryBasic as $salaryBasic) {
// 						if ($salaryBasic->first_date <= $first_date) {
// 							$payslip_type = $salaryBasic->payslip_type;
// 							$basicsalary = $salaryBasic->basic_salary;
// 							$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;

// 							if($salaryBasic->basic_salary_custom == 0)
// 							{
// 								$basicsalarycustom = $salaryBasic->basic_salary;
// 							}
// 							else
// 							{
// 								$basicsalarycustom = $salaryBasic->basic_salary_custom;
// 							}
// 						}
// 					}
					
// 					// $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
// 					// $jkk = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
// 					// $jkm = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
// 					// $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
// 					// $bpjskes = BPJSKes::where('company_id', $employee->company_id)->first();
// 					$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();   
// 					$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
// 					$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
// 					$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
// 					// $bpjskes = BPJSKes::where('id', 1)->where('name', 'Kesehatan')->first();
// 					$bpjskes = BPJSKes::where('id', 1)->first();
					
// 					$basicsalaryjht = $basicsalarycustom;
// 					if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
// 					{
// 						$basicsalaryjht = $jht->max_salary;
// 					}

// 					$basicsalarykes = $basicsalarycustom;
// 					if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
// 					{
// 						$basicsalarykes = $bpjskes->max_salary;
// 					}

// 					$nilai_jht = $basicsalaryjht * ($jht->employee ?? 0) / 100;
//                     $nilai_jkk = $basicsalarycustom * ($jkk->employee ?? 0) / 100;
//                     $nilai_jkm = $basicsalarycustom * ($jkm->employee ?? 0) / 100;
//                     $nilai_pensiun = $basicsalarycustom * ($pensiun->employee ?? 0) / 100;
//                     $nilai_kes = $basicsalarykes * ($bpjskes->employee ?? 0) / 100;
                    
//                     $bpjs_tk = $nilai_jht + $nilai_jkk + $nilai_jkm + $nilai_pensiun;
//                     $bpjs_kes = $nilai_kes;
                    
//                     $nilai_jht_comp = $basicsalarycustom * ($jht->company ?? 0) / 100;
//                     $nilai_jkk_comp = $basicsalarycustom * ($jkk->company ?? 0) / 100;
//                     $nilai_jkm_comp = $basicsalarycustom * ($jkm->company ?? 0) / 100;
//                     $nilai_pensiun_comp = $basicsalarycustom * ($pensiun->company ?? 0) / 100;
//                     $nilai_kes_comp = $basicsalarycustom * ($bpjskes->company ?? 0) / 100;
                    
//                     $bpjs_tk_comp = $nilai_jht_comp + $nilai_jkk_comp + $nilai_jkm_comp + $nilai_pensiun_comp;
//                     $bpjs_kes_comp = $nilai_kes_comp;

// 					$employee->nilaiJhtFormatted = number_format($nilai_jht, 0, ',', '.');
// 					$employee->nilaiJkkFormatted = number_format($nilai_jkk, 0, ',', '.');
// 					$employee->nilaiJkmFormatted = number_format($nilai_jkm, 0, ',', '.');
// 					$employee->nilaiPensiunFormatted = number_format($nilai_pensiun, 0, ',', '.');
// 					$employee->nilaiKesFormatted = number_format($nilai_kes, 0, ',', '.');

					
// 					$employee->nilaiJhtCompFormatted = number_format($nilai_jht_comp, 0, ',', '.');
// 					$employee->nilaiJkkCompFormatted = number_format($nilai_jkk_comp, 0, ',', '.');
// 					$employee->nilaiJkmCompFormatted = number_format($nilai_jkm_comp, 0, ',', '.');
// 					$employee->nilaiPensiunCompFormatted = number_format($nilai_pensiun_comp, 0, ',', '.');
// 					$employee->nilaiKesCompFormatted = number_format($nilai_kes_comp, 0, ',', '.');

// 					$totalBpjsTk += $bpjs_tk;
// 					$totalBpjsKes += $bpjs_kes;
// 					$totalBpjsTkComp += $bpjs_tk_comp;
// 					$totalBpjsKesComp += $bpjs_kes_comp;
// 				}
// 				$bpjsTkSumFormatted = number_format($totalBpjsTk, 0, ',', '.');
// 				$bpjsKesSumFormatted = number_format($totalBpjsKes, 0, ',', '.');
// 				$bpjsTkCompSumFormatted = number_format($totalBpjsTkComp, 0, ',', '.');
// 				$bpjsKesCompSumFormatted = number_format($totalBpjsKesComp, 0, ',', '.');
				
// 				return datatables()->of($employees)
// 					->setRowId(function ($pay_list) {
// 						return $pay_list->id;
// 					})
// 					->addColumn('employee_name', function ($row) {
// 						return $row->full_name;
// 					})
// 					->addColumn('bpjs_kes', function ($row) {
// 						return $row->nilaiKesCompFormatted;
// 					})
// 					->addColumn('jht', function ($row) {
// 						return $row->nilaiJhtCompFormatted;
// 					})
// 					->addColumn('jkk', function ($row) {
// 						return $row->nilaiJkkCompFormatted;
// 					})
// 					->addColumn('jkm', function ($row) {
// 						return $row->nilaiJkmCompFormatted;
// 					})
// 					->addColumn('pensiun', function ($row) {
// 						return $row->nilaiPensiunCompFormatted;
// 					})
// 					->addColumn('action', function ($data) {
// 						if (auth()->user()->can('view-paylist')) {
// 							if (auth()->user()->can('make-payment')) {
// 								$button = '<button type="button" name="view" id="' . $data->id . '" class="details btn btn-primary btn-sm" title="Details"><i class="dripicons-preview"></i></button>';
// 								$button .= '&nbsp;&nbsp;';
// 								$button .= '<button type="button" data-export="pdf" id="' . $data->id . '" class="exports btn btn-danger btn-sm" title="Details"><i class="fa fa-file-pdf-o"></i></button>';
//                                 $button .= '&nbsp;&nbsp;';
// 								$button .= '<button type="button" data-export="excel" id="' . $data->id . '" class="exports_xls btn btn-danger btn-sm" title="Details"><i class="fa fa-file-excel-o"></i></button>';
//                                 $button .= '&nbsp;&nbsp;';
// 								$button .= '<button type="button" name="payment" id="' . $data->id . '" class="generate_payment btn btn-success btn-sm" title="generate_payment"><i class="fa fa-money"></i></button>';
// 								$button .= '&nbsp;&nbsp;';
// 								// $button .= '<button type="button" name="payment" id="' . $data->id . '" class="payment_slip btn btn-warning btn-sm" title="payment_slip">Payslip</button>';
// 								$button .= '<button type="button" name="payslip" id="' . $data->id . '" class="payment_slip_exp btn btn-warning btn-sm" title="payment_slip">Payslip Export</button>';
                                
// 							} else {
// 								$button = '';
// 							}
// 							return $button;
// 						} else {
// 							return '';
// 						}
// 					})
// 					->with('bpjs_tk_sum', $bpjsTkSumFormatted) // Pass the BPJS TK sum to the view
// 					->with('bpjs_kes_sum', $bpjsKesSumFormatted) // Pass the BPJS Kes sum to the view
// 					->with('bpjs_tk_sum_comp', $bpjsTkCompSumFormatted) // Pass the BPJS TK sum to the view
// 					->with('bpjs_kes_sum_comp', $bpjsKesCompSumFormatted) // Pass the BPJS Kes sum to the view
// 					->rawColumns(['action'])
// 					->make(true);
// 			}
// 		}
// 		return view('salary.pay_list.bpjs', compact('companies'));
// 	}

    public function bpjs(Request $request) {
		$logged_user = auth()->user();
		// $companies = company::all();
		if ($logged_user->role_users_id == 6) {
			$companyId = json_decode($logged_user->company_ids);
			
			$companies = company::select('id', 'company_name')->whereIn('id', $companyId)->get();
		}
		else if($logged_user->role_users_id == 1) {
			$companies = company::select('id', 'company_name')->get();
		}

		$selected_date = empty($request->filter_month_year) ? now()->format('F-Y') : $request->filter_month_year;
		$first_date = date('Y-m-d', strtotime('first day of ' . $selected_date));
		$last_date = date('Y-m-d', strtotime('last day of ' . $selected_date));
		if ($logged_user->can('view-paylist')) {
			if (request()->ajax()) {
				$paid_employees = Payslip::where('month_year', $selected_date)->pluck('employee_id');
				$salary_basic_employees = SalaryBasic::where('first_date', '<=', $first_date)->distinct()->pluck('employee_id');
				$totalSalarySum = 0;
				$pphMonthlySum = 0;

				if (!empty($request->filter_company && $request->filter_department)) {
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
					])
					->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary_custom', 'employees.basic_salary','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
					->leftjoin('ptkp', [
						'employees.company_id' => 'ptkp.company_id',
						'employees.dependent' => 'ptkp.name'
					])
					->where('employees.company_id', $request->filter_company)
					->where('employees.department_id', $request->filter_department)
					->whereIntegerInRaw('employees.id', $salary_basic_employees)
					->whereIntegerNotInRaw('employees.id', $paid_employees)
					->where('employees.is_active', 1)
					->where('employees.exit_date', NULL)
					->get();
				} elseif (!empty($request->filter_company)) {
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
					])
                        ->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary','employees.basic_salary_custom','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
                        ->leftjoin('ptkp', [
                            'employees.company_id' => 'ptkp.company_id',
                            'employees.dependent' => 'ptkp.name'
                        ])
						->where('employees.company_id', $request->filter_company)
						->whereIntegerInRaw('employees.id', $salary_basic_employees)
						->whereIntegerNotInRaw('employees.id', $paid_employees)
						->where('employees.is_active', 1)->where('employees.exit_date', NULL)
						->get();
				} else {
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
					])
					->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary','employees.basic_salary_custom','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
					->leftjoin('ptkp', [
						'employees.company_id' => 'ptkp.company_id',
						'employees.dependent' => 'ptkp.name'
					])
					//->whereIntegerInRaw('id',$salary_basic_employees)
					// ->whereIntegerNotInRaw('id',$paid_employees)
					->whereIntegerInRaw('employees.id', $salary_basic_employees)
					->whereIntegerNotInRaw('employees.id', $paid_employees)
					->where('is_active', 1)
					->where('exit_date', NULL)
					->get();
				}
				
				$pphMonthlySum = 0;
				$totalBpjsTk = 0;
				$totalBpjsKes = 0;
				$totalBpjsTkComp = 0;
				$totalBpjsKesComp = 0;

				foreach ($employees as $employee) {
					//payslip_type & basic_salary
					foreach ($employee->salaryBasic as $salaryBasic) {
						if ($salaryBasic->first_date <= $first_date) {
							$payslip_type = $salaryBasic->payslip_type;
							$basicsalary = $salaryBasic->basic_salary;
							$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;

							if($salaryBasic->basic_salary_custom == 0)
							{
								$basicsalarycustom = $salaryBasic->basic_salary;
							}
							else
							{
								$basicsalarycustom = $salaryBasic->basic_salary_custom;
							}
						}
					}
					
					// $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
					// $jkk = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
					// $jkm = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
					// $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
					// $bpjskes = BPJSKes::where('company_id', $employee->company_id)->first();
					$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();   
					$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
					$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
					$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
					// $bpjskes = BPJSKes::where('id', 1)->where('name', 'Kesehatan')->first();
					$bpjskes = BPJSKes::where('id', 1)->first();
					
					$basicsalaryjht = $basicsalarycustom;
					if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
					{
						$basicsalaryjht = $jht->max_salary;
					}

					$basicsalarykes = $basicsalarycustom;
					if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
					{
						$basicsalarykes = $bpjskes->max_salary;
					}
					
					$basicsalaryjp = $basicsalarycustom;
					$current_date = date('Y-m-d');
					$birth_date = $employee->date_of_birth;
					$age = date_diff(date_create($birth_date), date_create($current_date))->y;
					if ($age < 60) {
						if($pensiun->max_salary > 0 && $basicsalaryjp >= $pensiun->max_salary)
						{
							$basicsalaryjp = $pensiun->max_salary;
						}
					}
					else {
						$basicsalaryjp = 0;
					}

					$nilai_jht = $basicsalaryjht * ($jht->employee ?? 0) / 100;
                    $nilai_jkk = $basicsalarycustom * ($jkk->employee ?? 0) / 100;
                    $nilai_jkm = $basicsalarycustom * ($jkm->employee ?? 0) / 100;
                    $nilai_pensiun = $basicsalaryjp * ($pensiun->employee ?? 0) / 100;
                    $nilai_kes = $basicsalarykes * ($bpjskes->employee ?? 0) / 100;
                    
                    $bpjs_tk = $nilai_jht + $nilai_jkk + $nilai_jkm + $nilai_pensiun;
                    $bpjs_kes = $nilai_kes;
                    
                    $nilai_jht_comp = $basicsalarycustom * ($jht->company ?? 0) / 100;
                    $nilai_jkk_comp = $basicsalarycustom * ($jkk->company ?? 0) / 100;
                    $nilai_jkm_comp = $basicsalarycustom * ($jkm->company ?? 0) / 100;
                    $nilai_pensiun_comp = $basicsalaryjp * ($pensiun->company ?? 0) / 100;
                    $nilai_kes_comp = $basicsalarycustom * ($bpjskes->company ?? 0) / 100;
                    
                    $bpjs_tk_comp = $nilai_jht_comp + $nilai_jkk_comp + $nilai_jkm_comp + $nilai_pensiun_comp;
                    $bpjs_kes_comp = $nilai_kes_comp;
					$bpjs_tk_tot = $bpjs_tk + $bpjs_tk_comp;

					$employee->salary = number_format($basicsalarycustom, 0, ',', '.');

					$employee->nilaiJhtFormatted = number_format($nilai_jht, 0, ',', '.');
					$employee->nilaiJkkFormatted = number_format($nilai_jkk, 0, ',', '.');
					$employee->nilaiJkmFormatted = number_format($nilai_jkm, 0, ',', '.');
					$employee->nilaiPensiunFormatted = number_format($nilai_pensiun, 0, ',', '.');
					$employee->nilaiKesFormatted = number_format($nilai_kes, 0, ',', '.');

					
					$employee->nilaiJhtCompFormatted = number_format($nilai_jht_comp, 0, ',', '.');
					$employee->nilaiJkkCompFormatted = number_format($nilai_jkk_comp, 0, ',', '.');
					$employee->nilaiJkmCompFormatted = number_format($nilai_jkm_comp, 0, ',', '.');
					$employee->nilaiPensiunCompFormatted = number_format($nilai_pensiun_comp, 0, ',', '.');
					$employee->nilaiKesCompFormatted = number_format($nilai_kes_comp, 0, ',', '.');

					$employee->nilaiTKTotalFormatted = number_format($bpjs_tk_tot, 0, ',', '.');

					$totalBpjsTk += $bpjs_tk;
					$totalBpjsKes += $bpjs_kes;
					$totalBpjsTkComp += $bpjs_tk_comp;
					$totalBpjsKesComp += $bpjs_kes_comp;
				}
				$bpjsTkSumFormatted = number_format($totalBpjsTk, 0, ',', '.');
				$bpjsKesSumFormatted = number_format($totalBpjsKes, 0, ',', '.');
				$bpjsTkCompSumFormatted = number_format($totalBpjsTkComp, 0, ',', '.');
				$bpjsKesCompSumFormatted = number_format($totalBpjsKesComp, 0, ',', '.');
				
				return datatables()->of($employees)
					->setRowId(function ($pay_list) {
						return $pay_list->id;
					})
					->addColumn('employee_name', function ($row) {
						return $row->full_name;
					})
					->addColumn('salary', function ($row) {
						return $row->salary;
					})
					->addColumn('jht_comp', function ($row) {
						return $row->nilaiJhtCompFormatted;
					})
					->addColumn('jkk_comp', function ($row) {
						return $row->nilaiJkkCompFormatted;
					})
					->addColumn('jkm_comp', function ($row) {
						return $row->nilaiJkmCompFormatted;
					})
					->addColumn('pensiun_comp', function ($row) {
						return $row->nilaiPensiunCompFormatted;
					})
					->addColumn('jht', function ($row) {
						return $row->nilaiJhtFormatted;
					})
					->addColumn('jkk', function ($row) {
						return $row->nilaiJkkFormatted;
					})
					->addColumn('jkm', function ($row) {
						return $row->nilaiJkmFormatted;
					})
					->addColumn('pensiun', function ($row) {
						return $row->nilaiPensiunFormatted;
					})
					->addColumn('bpjs_tk_tot', function ($row) {
						return $row->nilaiTKTotalFormatted;
					})
					->addColumn('action', function ($data) {
						if (auth()->user()->can('view-paylist')) {
							if (auth()->user()->can('make-payment')) {
								$button = '<button type="button" name="view" id="' . $data->id . '" class="details btn btn-primary btn-sm" title="Details"><i class="dripicons-preview"></i></button>';
								$button .= '&nbsp;&nbsp;';
								$button .= '<button type="button" data-export="pdf" id="' . $data->id . '" class="exports btn btn-danger btn-sm" title="Details"><i class="fa fa-file-pdf-o"></i></button>';
                                $button .= '&nbsp;&nbsp;';
								$button .= '<button type="button" data-export="excel" id="' . $data->id . '" class="exports_xls btn btn-danger btn-sm" title="Details"><i class="fa fa-file-excel-o"></i></button>';
                                $button .= '&nbsp;&nbsp;';
								$button .= '<button type="button" name="payment" id="' . $data->id . '" class="generate_payment btn btn-success btn-sm" title="generate_payment"><i class="fa fa-money"></i></button>';
								$button .= '&nbsp;&nbsp;';
								// $button .= '<button type="button" name="payment" id="' . $data->id . '" class="payment_slip btn btn-warning btn-sm" title="payment_slip">Payslip</button>';
								$button .= '<button type="button" name="payslip" id="' . $data->id . '" class="payment_slip_exp btn btn-warning btn-sm" title="payment_slip">Payslip Export</button>';
                                
							} else {
								$button = '';
							}
							return $button;
						} else {
							return '';
						}
					})
					->with('bpjs_tk_sum', $bpjsTkSumFormatted) // Pass the BPJS TK sum to the view
					->with('bpjs_kes_sum', $bpjsKesSumFormatted) // Pass the BPJS Kes sum to the view
					->with('bpjs_tk_sum_comp', $bpjsTkCompSumFormatted) // Pass the BPJS TK sum to the view
					->with('bpjs_kes_sum_comp', $bpjsKesCompSumFormatted) // Pass the BPJS Kes sum to the view
					->rawColumns(['action'])
					->make(true);
			}
		}
		return view('salary.pay_list.bpjs', compact('companies'));
	}
	
	public function bpjs_kes(Request $request) {
		$logged_user = auth()->user();
		// $companies = company::all();
		if ($logged_user->role_users_id == 6) {
			$companyId = json_decode($logged_user->company_ids);
			
			$companies = company::select('id', 'company_name')->whereIn('id', $companyId)->get();
		}
		else if($logged_user->role_users_id == 1) {
			$companies = company::select('id', 'company_name')->get();
		}

		$selected_date = empty($request->filter_month_year) ? now()->format('F-Y') : $request->filter_month_year;
		$first_date = date('Y-m-d', strtotime('first day of ' . $selected_date));
		$last_date = date('Y-m-d', strtotime('last day of ' . $selected_date));
		if ($logged_user->can('view-paylist')) {
			if (request()->ajax()) {
				$paid_employees = Payslip::where('month_year', $selected_date)->pluck('employee_id');
				$salary_basic_employees = SalaryBasic::where('first_date', '<=', $first_date)->distinct()->pluck('employee_id');
				$totalSalarySum = 0;
				$pphMonthlySum = 0;

				if (!empty($request->filter_company && $request->filter_department)) {
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
					])
					->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary_custom', 'employees.basic_salary','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
					->leftjoin('ptkp', [
						'employees.company_id' => 'ptkp.company_id',
						'employees.dependent' => 'ptkp.name'
					])
					->where('employees.company_id', $request->filter_company)
					->where('employees.department_id', $request->filter_department)
					->whereIntegerInRaw('employees.id', $salary_basic_employees)
					->whereIntegerNotInRaw('employees.id', $paid_employees)
					->where('employees.is_active', 1)
					->where('employees.exit_date', NULL)
					->get();
				} elseif (!empty($request->filter_company)) {
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
					])
                        ->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary','employees.basic_salary_custom','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
                        ->leftjoin('ptkp', [
                            'employees.company_id' => 'ptkp.company_id',
                            'employees.dependent' => 'ptkp.name'
                        ])
						->where('employees.company_id', $request->filter_company)
						->whereIntegerInRaw('employees.id', $salary_basic_employees)
						->whereIntegerNotInRaw('employees.id', $paid_employees)
						->where('employees.is_active', 1)->where('employees.exit_date', NULL)
						->get();
				} else {
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
					])
					->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.last_name', 'employees.basic_salary','employees.basic_salary_custom','employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
					->leftjoin('ptkp', [
						'employees.company_id' => 'ptkp.company_id',
						'employees.dependent' => 'ptkp.name'
					])
					//->whereIntegerInRaw('id',$salary_basic_employees)
					// ->whereIntegerNotInRaw('id',$paid_employees)
					->whereIntegerInRaw('employees.id', $salary_basic_employees)
					->whereIntegerNotInRaw('employees.id', $paid_employees)
					->where('is_active', 1)
					->where('exit_date', NULL)
					->get();
				}
				
				$pphMonthlySum = 0;
				$totalBpjsTk = 0;
				$totalBpjsKes = 0;
				$totalBpjsTkComp = 0;
				$totalBpjsKesComp = 0;
				$tanggungan = 0;

				foreach ($employees as $employee) {
					//payslip_type & basic_salary
					foreach ($employee->salaryBasic as $salaryBasic) {
						if ($salaryBasic->first_date <= $first_date) {
							$payslip_type = $salaryBasic->payslip_type;
							$basicsalary = $salaryBasic->basic_salary;
							$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;
							$tanggungan = $salaryBasic->tanggungan_kes;

							if($salaryBasic->basic_salary_custom == 0)
							{
								$basicsalarycustom = $salaryBasic->basic_salary;
							}
							else
							{
								$basicsalarycustom = $salaryBasic->basic_salary_custom;
							}
						}
					}
					
					// $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
					// $jkk = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
					// $jkm = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
					// $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
					// $bpjskes = BPJSKes::where('company_id', $employee->company_id)->first();
					$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();   
					$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
					$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
					$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
					// $bpjskes = BPJSKes::where('id', 1)->where('name', 'Kesehatan')->first();
					$bpjskes = BPJSKes::where('id', 1)->first();
					
					$basicsalaryjht = $basicsalarycustom;
					if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
					{
						$basicsalaryjht = $jht->max_salary;
					}

					$basicsalarykes = $basicsalarycustom;
					if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
					{
						$basicsalarykes = $bpjskes->max_salary;
					}

					$nilai_jht = $basicsalaryjht * ($jht->employee ?? 0) / 100;
                    $nilai_jkk = $basicsalarycustom * ($jkk->employee ?? 0) / 100;
                    $nilai_jkm = $basicsalarycustom * ($jkm->employee ?? 0) / 100;
                    $nilai_pensiun = $basicsalarycustom * ($pensiun->employee ?? 0) / 100;
                    $nilai_kes = $basicsalarykes * ($bpjskes->employee ?? 0) / 100;
					$nilai_tanggungan = $nilai_kes * $tanggungan;
                    
                    $bpjs_tk = $nilai_jht + $nilai_jkk + $nilai_jkm + $nilai_pensiun;
                    $bpjs_kes = $nilai_kes;
                    
                    $nilai_jht_comp = $basicsalarycustom * ($jht->company ?? 0) / 100;
                    $nilai_jkk_comp = $basicsalarycustom * ($jkk->company ?? 0) / 100;
                    $nilai_jkm_comp = $basicsalarycustom * ($jkm->company ?? 0) / 100;
                    $nilai_pensiun_comp = $basicsalarycustom * ($pensiun->company ?? 0) / 100;
                    $nilai_kes_comp = $basicsalarycustom * ($bpjskes->company ?? 0) / 100;
                    
                    $bpjs_tk_comp = $nilai_jht_comp + $nilai_jkk_comp + $nilai_jkm_comp + $nilai_pensiun_comp;
                    $bpjs_kes_comp = $nilai_kes_comp;
					$bpjs_kes_tot = $bpjs_kes + $bpjs_kes_comp + $nilai_tanggungan;

					$employee->salary = number_format($basicsalarycustom, 0, ',', '.');

					$employee->nilaiJhtFormatted = number_format($nilai_jht, 0, ',', '.');
					$employee->nilaiJkkFormatted = number_format($nilai_jkk, 0, ',', '.');
					$employee->nilaiJkmFormatted = number_format($nilai_jkm, 0, ',', '.');
					$employee->nilaiPensiunFormatted = number_format($nilai_pensiun, 0, ',', '.');
					$employee->nilaiKesFormatted = number_format($nilai_kes, 0, ',', '.');
					$employee->tanggunganFormatted = number_format($nilai_tanggungan, 0, ',', '.');
					
					$employee->nilaiJhtCompFormatted = number_format($nilai_jht_comp, 0, ',', '.');
					$employee->nilaiJkkCompFormatted = number_format($nilai_jkk_comp, 0, ',', '.');
					$employee->nilaiJkmCompFormatted = number_format($nilai_jkm_comp, 0, ',', '.');
					$employee->nilaiPensiunCompFormatted = number_format($nilai_pensiun_comp, 0, ',', '.');
					$employee->nilaiKesCompFormatted = number_format($nilai_kes_comp, 0, ',', '.');

					$employee->nilaiKesTotalFormatted = number_format($bpjs_kes_tot, 0, ',', '.');

					$totalBpjsTk += $bpjs_tk;
					$totalBpjsKes += $bpjs_kes + $nilai_tanggungan;
					$totalBpjsTkComp += $bpjs_tk_comp;
					$totalBpjsKesComp += $bpjs_kes_comp;
				}
				$bpjsTkSumFormatted = number_format($totalBpjsTk, 0, ',', '.');
				$bpjsKesSumFormatted = number_format($totalBpjsKes, 0, ',', '.');
				$bpjsTkCompSumFormatted = number_format($totalBpjsTkComp, 0, ',', '.');
				$bpjsKesCompSumFormatted = number_format($totalBpjsKesComp, 0, ',', '.');
				
				return datatables()->of($employees)
					->setRowId(function ($pay_list) {
						return $pay_list->id;
					})
					->addColumn('employee_name', function ($row) {
						return $row->full_name;
					})
					->addColumn('salary', function ($row) {
						return $row->salary;
					})
					->addColumn('bpjs_kes_comp', function ($row) {
						return $row->nilaiKesCompFormatted;
					})
					->addColumn('bpjs_kes_emp', function ($row) {
						return $row->nilaiKesFormatted;
					})
					->addColumn('bpjs_kes_oth', function ($row) {
						return $row->tanggunganFormatted;
					})
					->addColumn('bpjs_kes_tot', function ($row) {
						return $row->nilaiKesTotalFormatted;
					})
					->with('bpjs_tk_sum', $bpjsTkSumFormatted) // Pass the BPJS TK sum to the view
					->with('bpjs_kes_sum', $bpjsKesSumFormatted) // Pass the BPJS Kes sum to the view
					->with('bpjs_tk_sum_comp', $bpjsTkCompSumFormatted) // Pass the BPJS TK sum to the view
					->with('bpjs_kes_sum_comp', $bpjsKesCompSumFormatted) // Pass the BPJS Kes sum to the view
					->rawColumns(['action'])
					->make(true);
			}
		}
		return view('salary.pay_list.bpjs_kes', compact('companies'));
	}

	public function paySlip(Request $request)
	{
		$month_year = $request->filter_month_year;
		$first_date = date('Y-m-d', strtotime('first day of ' . $month_year));
		$last_date = date('Y-m-d', strtotime('last day of ' . $month_year));

		$employee = Employee::with([
			'salaryBasic' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'kehadiran' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'allowances' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'commissions' => function ($query) use ($first_date) {
				$query->where('first_date', $first_date);
			},
			'loans' => function ($query) use ($first_date) {
				$query->where('first_date', '<=', $first_date)
                ->where('amount_remaining', '!=', 0)
					->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'deductions' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'otherPayments' => function ($query) use ($first_date) {
				$query->where('first_date', $first_date);
			},
			'overtimes' => function ($query) use ($month_year) {
				$query->where('month_year', $month_year);
			},
			'designation', 'department', 'user', 'setting',
			'employeeAttendance' => function ($query) use ($first_date, $last_date) {
				$query->whereBetween('attendance_date', [$first_date, $last_date]);
			},
            'user:id,username', 'company.Location.country',
			'department:id,department_name', 'designation:id,designation_name',
		])
        ->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.contact_no', 'employees.last_name', 'employees.basic_salary', 'employees.basic_salary_custom', 'employees.tunjangan_jabatan', 'employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.designation_id', 'employees.department_id', 'employees.joining_date', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
        ->leftjoin('ptkp', [
                'employees.company_id' => 'ptkp.company_id',
                'employees.dependent' => 'ptkp.name'
        ])
		->findOrFail($request->id);
		
		$tanggungan = 0;
		//payslip_type && salary_basic
		foreach ($employee->salaryBasic as $salaryBasic) {
			if ($salaryBasic->first_date <= $first_date) {
				$basic_salary = $salaryBasic->basic_salary;
				$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;
				$tanggungan = $salaryBasic->tanggungan_kes;

				if($salaryBasic->basic_salary_custom == 0)
				{
					$basic_salary_custom = $salaryBasic->basic_salary;
				}
				else
				{
					$basic_salary_custom = $salaryBasic->basic_salary_custom;
				}

				$total_gaji_tunjangan = $basic_salary+$tunjangan_jabatan;
				$payslip_type = $salaryBasic->payslip_type;
			}
		}
        
        $prev_month = Carbon::createFromFormat('Y-m-d', $first_date)->subMonth();
        $cut_off_start = $prev_month->day(16);
        $cut_off_end = Carbon::createFromFormat('Y-m-d', $first_date)->day(15);
        $attendances = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end);
		
        $work_days = $attendances->count();
        $number_cut = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end)->whereIn('status', ['TA1', 'TA2', 'TA3'])->where('is_checked', 0)->count();
        if($work_days == 0) {
            $salary_cut_amount = 0;
        } else {
            $salary_cut_amount = $basic_salary/$work_days*$number_cut;
        }
		//TAMBAHAN UANG KEHADIRAN
		$salary_kehadiran = 0;
		if (!$employee->kehadiran->isEmpty()) {
			foreach ($employee->kehadiran as $item) {
				if ($item->first_date <= $first_date) {
					$salary_kehadiran = $item->salary_kehadiran * $work_days;
				}
			}
		} else {
			$salary_kehadiran = 0;
		}
		
        // $pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan);
        $pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan, $work_days, $first_date, $salary_kehadiran);
        
        // $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
        // $jkk = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
        // $jkm = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
        // $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
        // $bpjskes = BPJSKes::where('company_id', $employee->company_id)->first();

		$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();   
		$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
		$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
		$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
		// $bpjskes = BPJSKes::where('id', 1)->where('name', 'Kesehatan')->first();
		$bpjskes = BPJSKes::where('id', 1)->first();

		$basicsalaryjht = $basic_salary_custom;
		if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
		{
			$basicsalaryjht = $jht->max_salary;
		}

		$basicsalarykes = $basic_salary_custom;
		if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
		{
			$basicsalarykes = $bpjskes->max_salary;
		}
		
		$basicsalaryjp = $basic_salary_custom;
		$current_date = date('Y-m-d');
		$birth_date = $employee->date_of_birth;
		$age = date_diff(date_create($birth_date), date_create($current_date))->y;
		if ($age < 60) {
			if($pensiun->max_salary > 0 && $basicsalaryjp >= $pensiun->max_salary)
			{
				$basicsalaryjp = $pensiun->max_salary;
			}
		}
		else {
			$basicsalaryjp = 0;
		}

        $nilai_jht = $basicsalaryjht*($jht->employee ?? 0)/100;
        $nilai_jkk = $basic_salary_custom*($jkk->employee ?? 0)/100;
        $nilai_jkm = $basic_salary_custom*($jkm->employee ?? 0)/100;
        $nilai_pensiun = $basicsalaryjp*($pensiun->employee ?? 0)/100;
        $nilai_kes = $basicsalarykes*($bpjskes->employee ?? 0)/100;

		$nilai_kes = $nilai_kes + ($nilai_kes * $tanggungan);

        $pension_amount = $nilai_jht+$nilai_pensiun;

        //Pension Amount

		$type          = "getArray";
		$allowances    = $this->allowances($employee, $first_date, $type, $work_days);
		$deductions    = $this->deductions($employee, $first_date, $type);
		$data = [];
        $data['month_year'] = $month_year;
		$data['basic_salary'] = $salaryBasic->basic_salary;
		$data['tunjangan_jabatan'] = $tunjangan_jabatan;
		$data['basic_total']  = $total_gaji_tunjangan;
		// $data['salary_kehadiran']   = number_format($salary_kehadiran, '0', ',', '.');
		$data['salary_kehadiran']   = $salary_kehadiran;
		$data['allowances']   = $allowances;
		$data['work_days']   = $work_days;
		$data['commissions']  = $employee->commissions;
		$data['loans']        = $employee->loans;
		$data['deductions']   = $deductions;
		$data['overtimes']    = $employee->overtimes;
		$data['other_payments'] = $employee->otherPayments;
		$data['pension_type']   = 'Percentage';
		$data['bpjs_kes'] = number_format($nilai_kes, '0', ',', '.');
		$data['bpjs_jht'] = number_format($nilai_jht, '0', ',', '.');
		$data['bpjs_jkk'] = number_format($nilai_jkk, '0', ',', '.');
		$data['bpjs_jkm'] = number_format($nilai_jkm, '0', ',', '.');
		$data['bpjs_pensiun'] = number_format($nilai_pensiun, '0', ',', '.');
        $data['attendance_cut_amount'] = number_format($salary_cut_amount, '0', ',', '.');

		$data['employee_id']          = $employee->id;
		$data['employee_full_name']   = $employee->full_name;
		$data['employee_designation'] = $employee->designation->designation_name ?? '';
		$data['employee_department']  = $employee->department->department_name ?? '';
		$data['employee_join_date']   = $employee->joining_date;
		$data['employee_username']    = $employee->user->username;
		$data['employee_pp']          = $employee->user->profile_photo ?? '';

		$data['payslip_type'] = $payslip_type;

		if ($payslip_type == 'Hourly') {
			$total = 0;
			$total_hours_worked = $this->totalWorkedHours($employee);
			$data['monthly_worked_hours'] = $total_hours_worked;
			//formatting in hour:min and separating them
			sscanf($total_hours_worked, '%d:%d', $hour, $min);
			//converting in minute
			$total += $hour * 60 + $min;

			$data['monthly_worked_amount'] = ($basic_salary / 60) * $total;

			$data['basic_total'] = $data['monthly_worked_amount'];
		}

		$type              = "getAmount";
		$allowance_amount  = $this->allowances($employee, $first_date, $type, $work_days);

		$pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan, $work_days, $first_date, $salary_kehadiran);

		$deduction_amount  = $this->deductions($employee, $first_date, $type);
        $data['allowance_amount'] = $allowance_amount;
		if ($payslip_type == 'Monthly') {
            $data['pph_bulanan'] = $pph_monthly;
			$data['total_salary'] = number_format($this->totalSalary($employee, $payslip_type, $total_gaji_tunjangan, $allowance_amount, $deduction_amount, $pph_monthly, $salary_cut_amount, $salary_kehadiran), 0, ',', '.');
		}
		
        if(empty($request->export)) {
		    return response()->json(['data' => $data, 'employee' => $employee]);
        } elseif($request->export == 'pdf') {
            PDF::setOptions(['dpi' => 10, 'defaultFont' => 'sans-serif', 'tempDir' => storage_path('temp')]);
		    $pdf = PDF::loadView('salary.payslip.export', $data, $employee->toArray());
		    return $pdf->stream();
        } elseif($request->export == 'excel') {
            $export = new SlipExport($request->id, $request->filter_month_year);
            return Excel::download($export, 'Payslip.xlsx');
        } else {
            return response()->json(['data' => $data, 'employee' => $employee]);
        }
	}

	public function paySlipGenerate(Request $request)
	{
		$month_year = $request->filter_month_year;
		$first_date = date('Y-m-d', strtotime('first day of ' . $month_year));
		$last_date = date('Y-m-d', strtotime('last day of ' . $month_year));

		$employee = Employee::with([
			'salaryBasic' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'kehadiran' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'allowances' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'commissions' => function ($query) use ($first_date) {
				$query->where('first_date', $first_date);
			},
			'loans' => function ($query) use ($first_date) {
				$query->where('first_date', '<=', $first_date)
                ->where('amount_remaining', '!=', 0)
					->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'deductions' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'otherPayments' => function ($query) use ($first_date) {
				$query->where('first_date', $first_date);
			},
			'overtimes' => function ($query) use ($month_year) {
				$query->where('month_year', $month_year);
			},
			'designation', 'department', 'user', 'setting',
			'employeeAttendance' => function ($query) use ($first_date, $last_date) {
				$query->whereBetween('attendance_date', [$first_date, $last_date]);
			},
            'user:id,username', 'company.Location.country',
			'department:id,department_name', 'designation:id,designation_name',
		])
        ->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.contact_no', 'employees.last_name', 'employees.basic_salary', 'employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.designation_id', 'employees.department_id', 'employees.joining_date', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
        ->leftjoin('ptkp', [
                'employees.company_id' => 'ptkp.company_id',
                'employees.dependent' => 'ptkp.name'
        ])
		->findOrFail($request->id);

		$tanggungan = 0;
		//payslip_type & basic_salary
		foreach ($employee->salaryBasic as $salaryBasic) {
			if ($salaryBasic->first_date <= $first_date) {
				$basic_salary = $salaryBasic->basic_salary;
				$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;
				$tanggungan = $salaryBasic->tanggungan_kes;

				if($salaryBasic->basic_salary_custom == 0)
				{
					$basic_salary_custom = $salaryBasic->basic_salary;
				}
				else
				{
					$basic_salary_custom = $salaryBasic->basic_salary_custom;
				}

				$total_gaji_tunjangan = $basic_salary+$tunjangan_jabatan;
				$payslip_type = $salaryBasic->payslip_type;
			}
		}

        $prev_month = Carbon::createFromFormat('Y-m-d', $first_date)->subMonth();
        $cut_off_start = $prev_month->day(16);
        $cut_off_end = Carbon::createFromFormat('Y-m-d', $first_date)->day(15);
        $attendances = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end);
        $work_days = $attendances->count();
         $number_cut = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end)->whereIn('status', ['TA1', 'TA2', 'TA3'])->where('is_checked', 0)->count();
        if($work_days == 0) {
            $salary_cut_amount = 0;
        } else {
            $salary_cut_amount = $basic_salary/$work_days*$number_cut;
        }
		//TAMBAHAN UANG KEHADIRAN
		if (!$employee->kehadiran->isEmpty()) {
			foreach ($employee->kehadiran as $item) {
				if ($item->first_date <= $first_date) {
					$salary_kehadiran = $item->salary_kehadiran * $work_days;
				}
			}
		} else {
			$salary_kehadiran = 0;
		}
        // $pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan);
        $pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan, $work_days, $first_date, $salary_kehadiran);
        
        // $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
        // $jkk = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
        // $jkm = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
        // $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
        // $bpjskes = BPJSKes::where('company_id', $employee->company_id)->where('name', 'Kesehatan')->first();

		$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();   
		$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
		$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
		$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
		// $bpjskes = BPJSKes::where('id', 1)->where('name', 'Kesehatan')->first();
		$bpjskes = BPJSKes::where('id', 1)->first();

		$basicsalaryjht = $basic_salary_custom;
		if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
		{
			$basicsalaryjht = $jht->max_salary;
		}

		$basicsalarykes = $basic_salary_custom;
		if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
		{
			$basicsalarykes = $bpjskes->max_salary;
		}
		
		$basicsalaryjp = $basic_salary_custom;
		$current_date = date('Y-m-d');
		$birth_date = $employee->date_of_birth;
		$age = date_diff(date_create($birth_date), date_create($current_date))->y;
		if ($age < 60) {
			if($pensiun->max_salary > 0 && $basicsalaryjp >= $pensiun->max_salary)
			{
				$basicsalaryjp = $pensiun->max_salary;
			}
		}
		else {
			$basicsalaryjp = 0;
		}

        $nilai_jht = $basicsalaryjht*($jht->employee ?? 0)/100;
        $nilai_jkk = $basic_salary_custom*($jkk->employee ?? 0)/100;
        $nilai_jkm = $basic_salary_custom*($jkm->employee ?? 0)/100;
        $nilai_pensiun = $basicsalaryjp*($pensiun->employee ?? 0)/100;
        $nilai_kes = $basicsalarykes*($bpjskes->employee ?? 0)/100;

		$nilai_kes = $nilai_kes + ($nilai_kes * $tanggungan);

        $pension_amount = $nilai_jht+$nilai_pensiun;

        $type              = "getAmount";
		$allowance_amount  = $this->allowances($employee, $first_date, $type, $work_days);

		$pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan, $work_days, $first_date);

		$deduction_amount  = $this->deductions($employee, $first_date, $type);
        $data['allowance_amount'] = $allowance_amount;

		$data = [];
		$data['employee']         = $employee->id;
		$data['basic_salary']     = $basic_salary;
		$data['salary_kehadiran'] = $salary_kehadiran;
		$data['total_allowance']  = $allowance_amount;
		$data['total_commission'] = $employee->commissions->sum('commission_amount');
		$data['monthly_payable']  = $employee->loans->sum('monthly_payable');
		$data['amount_remaining'] = $employee->loans->sum('amount_remaining');
		$data['total_deduction']  = $deduction_amount;
		$data['total_overtime']   = $employee->overtimes->sum('overtime_amount');
		$data['total_other_payment'] = $employee->otherPayments->sum('other_payment_amount');
		$data['payslip_type']     = $payslip_type;
		$data['pension_amount']   = $pension_amount;
        $data['bpjs_kes'] = $nilai_kes;
		$data['bpjs_jht'] = $nilai_jht;
		$data['bpjs_jkk'] = $nilai_jkk;
		$data['bpjs_jkm'] = $nilai_jkm;
		$data['bpjs_pensiun'] = $nilai_pensiun;
        $data['attendance_cut_amount'] = number_format($salary_cut_amount, '0', ',', '');
		if ($payslip_type == 'Monthly') {
            $data['pph_bulanan'] = $pph_monthly;
			$data['total_salary'] = number_format($this->totalSalary($employee, $payslip_type, $total_gaji_tunjangan, $allowance_amount, $deduction_amount, $pph_monthly, $salary_cut_amount), '0', ',', '');
		} else {
			$total = 0;
			$total_hours = $this->totalWorkedHours($employee);
			sscanf($total_hours, '%d:%d', $hour, $min);
			//converting in minute
			$total += $hour * 60 + $min;
			$data['total_hours'] = $total_hours;
			$data['worked_amount'] = ($data['basic_salary'] / 60) * $total;
			$data['total_salary'] = number_format($this->totalSalary($employee, $payslip_type, $basic_salary, $allowance_amount, $deduction_amount, $pension_amount, $total), '0', ',', '.');
		}
		return response()->json(['data' => $data]);
	}


	public function payEmployee($id, Request $request)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('make-payment')) {
			$first_date = date('Y-m-d', strtotime('first day of ' . $request->month_year));

			DB::beginTransaction();
			try {
				$employee = Employee::with([
					'allowances' => function ($query) {
						$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
					},
					'commissions' => function ($query) use ($first_date) {
						$query->where('first_date', $first_date);
					},
					'loans' => function ($query) use ($first_date) {
						$query->where('first_date', '<=', $first_date)
							->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
					},
					'deductions' => function ($query) {
						$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
					},
					'otherPayments' => function ($query) use ($first_date) {
						$query->where('first_date', $first_date);
					},
					'overtimes' => function ($query) use ($first_date) {
						$query->where('first_date', $first_date);
					}
				])
					->select('id', 'first_name', 'last_name', 'basic_salary', 'tunjangan_jabatan', 'payslip_type', 'pension_type', 'pension_amount', 'company_id')
					->findOrFail($id);


				$type          = "getArray";
				$allowances_array    = $this->allowances($employee, $first_date, $type); //getArray
				$deductions    = $this->deductions($employee, $first_date, $type);
				$data = [];
				$data['payslip_key']    = Str::random('20');
				$data['payslip_number'] = mt_rand(1000000000, 9999999999);
				$data['payment_type']   = $employee->payslip_type;
				$data['basic_salary']   = $request->basic_salary;
				$data['tunjangan_jabatan']   = $request->tunjangan_jabatan;
				$data['allowances']     = $allowances_array;
				$data['commissions']    = $employee->commissions;
				$data['loans']          = $employee->loans;
				$data['deductions']     = $deductions;
				$data['overtimes']      = $employee->overtimes;
				$data['other_payments'] = $employee->otherPayments;
				$data['month_year']     = $request->month_year;
				$data['net_salary']     = $request->net_salary;
				$data['status']         = 1;
				$data['employee_id']    = $employee->id;
				$data['hours_worked']   = $request->worked_hours;
				$data['pension_type']   = $employee->pension_type;
				$data['pension_amount'] = $request->pension_amount;
				$data['company_id']     = $employee->company_id;

				if ($data['payment_type'] == NULL) { //No Need This Line
					return response()->json(['payment_type_error' => __('Please select a payslip-type for this employee.')]);
				}

				$account_balance = DB::table('finance_bank_cashes')->where('id', config('variable.account_id'))->pluck('account_balance')->first();

				if ((int)$account_balance < (int)$request->net_salary) {
					return response()->json(['error' => 'requested balance is less then available balance']);
				}

				$new_balance = (int)$account_balance - (int)$request->net_salary;

				$finance_data = [];

				$finance_data['account_id'] = config('variable.account_id');
				$finance_data['amount'] = $request->net_salary;
				$finance_data['expense_date'] = now()->format(env('Date_Format'));
				$finance_data['expense_reference'] = trans('file.Payroll');


				FinanceBankCash::whereId($finance_data['account_id'])->update(['account_balance' => $new_balance]);

				$Expense = FinanceTransaction::create($finance_data);

				$finance_data['id'] = $Expense->id;

				FinanceExpense::create($finance_data);

				if ($employee->loans) {
					foreach ($employee->loans as $loan) {
						if ($loan->time_remaining == '0') {
							$amount_remaining = 0;
							$time_remaining   = 0;
							$monthly_payable  = 0;
						} else {
							$amount_remaining = (int) $loan->amount_remaining - (int) $loan->monthly_payable;
							$time_remaining   = (int) $loan->time_remaining - 1;
							$monthly_payable  = $amount_remaining != 0 ? $loan->monthly_payable : 0;
						}
						SalaryLoan::whereId($loan->id)->update([
							'amount_remaining' => $amount_remaining, 'time_remaining' => $time_remaining,
							'monthly_payable' => $monthly_payable
						]);
					}
					$employee_loan = Employee::with('loans:id,employee_id,loan_title,loan_amount,time_remaining,amount_remaining,monthly_payable')
						->select('id', 'first_name', 'last_name', 'basic_salary', 'payslip_type')
						->findOrFail($id);
					$data['loans'] = $employee_loan->loans;
				}
				Payslip::create($data);

				DB::commit();
			} catch (Exception $e) {
				DB::rollback();
				return response()->json(['error' => $e->getMessage()]);
			} catch (Throwable $e) {
				DB::rollback();
				return response()->json(['error' => $e->getMessage()]);
			}

			return response()->json(['success' => __('Data Added successfully.')]);
		}
		return response()->json(['success' => __('You are not authorized')]);
	}


	//--- Updated ----
	public function payBulk(Request $request)
	{
		$logged_user = auth()->user();
		if ($logged_user->can('make-bulk_payment')) {
			if (request()->ajax()) {
				$first_date = date('Y-m-d', strtotime('first day of ' . $request->month_year));
				$employeeArrayId = $request->all_checkbox_id;
				//$employeesId = Employee::whereIntegerInRaw('id',$employeeArrayId)->whereIntegerNotInRaw('id',$paid_employee)->pluck('id');

				if (!empty($request->filter_company && $request->filter_department)) //No Need
				{
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'allowances' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'commissions' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'loans' => function ($query) use ($first_date) {
							$query->where('first_date', '<=', $first_date)
								->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'deductions' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'otherPayments' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'overtimes' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						}
					])
						->select('id', 'first_name', 'last_name', 'basic_salary', 'tunjangan_jabatan', 'payslip_type', 'pension_type', 'pension_amount', 'company_id')
						->where('company_id', $request->filter_company)
						->where('department_id', $request->filter_department)
						->whereIntegerInRaw('id', $employeeArrayId)
						->where('is_active', 1)->where('exit_date', NULL)
						->get();
				} elseif (!empty($request->filter_company)) //No Need
				{
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'allowances' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'commissions' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'loans' => function ($query) use ($first_date) {
							$query->where('first_date', '<=', $first_date)
								->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'deductions' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'otherPayments' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'overtimes' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						}
					])
						->select('id', 'first_name', 'last_name', 'basic_salary', 'tunjangan_jabatan', 'payslip_type', 'pension_type', 'pension_amount', 'company_id')
						->where('company_id', $request->filter_company)
						->whereIntegerInRaw('id', $employeeArrayId)
						->where('is_active', 1)->where('exit_date', NULL)
						->get();
				} else {
					$employees = Employee::with([
						'salaryBasic' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'allowances' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'commissions' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'loans' => function ($query) use ($first_date) {
							$query->where('first_date', '<=', $first_date)
								->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'deductions' => function ($query) {
							$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
						},
						'otherPayments' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						},
						'overtimes' => function ($query) use ($first_date) {
							$query->where('first_date', $first_date);
						}
					])
						->select('id', 'first_name', 'last_name', 'basic_salary', 'tunjangan_jabatan', 'payslip_type', 'pension_type', 'pension_amount', 'company_id')
						->whereIntegerInRaw('id', $employeeArrayId)
						->where('is_active', 1)->where('exit_date', NULL)
						->get();
				}


				DB::beginTransaction();
				try {
					$total_sum = 0;
					foreach ($employees as $employee) {
						//payslip_type & basic_salary
						foreach ($employee->salaryBasic as $salaryBasic) {
							if ($salaryBasic->first_date <= $first_date) {
								$payslip_type = $salaryBasic->payslip_type;
								$basicsalary = $salaryBasic->basic_salary;
								$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;
								$total_gaji_tunjangan = $basicsalary+$tunjangan_jabatan;
							}
						}

						//Pension Amount
						if ($employee->pension_type == "percentage") {
							$pension_amount =  ($total_gaji_tunjangan * $employee->pension_amount) / 100;
						} else {
							$pension_amount = $employee->pension_amount;
						}

						$type1          = "getArray";
						$allowances    = $this->allowances($employee, $first_date, $type1); //getArray
						$deductions    = $this->deductions($employee, $first_date, $type1);

						$type2             = "getAmount";
						$allowance_amount  = $this->allowances($employee, $first_date, $type2);
						$deduction_amount  = $this->deductions($employee, $first_date, $type2);


						//Net Salary
						if ($payslip_type == 'Monthly') {
							$net_salary = $this->totalSalary($employee, $payslip_type, $total_gaji_tunjangan, $allowance_amount, $deduction_amount, $pension_amount);


							//New- just store work hours, not calculte with salary
							$total = 0;
							$total_hours = $this->totalWorkedHours($employee);
							sscanf($total_hours, '%d:%d', $hour, $min);
							//converting in minute
							$total += $hour * 60 + $min;
						} else {
							$total = 0;
							$total_hours = $this->totalWorkedHours($employee);
							sscanf($total_hours, '%d:%d', $hour, $min);
							//converting in minute
							$total += $hour * 60 + $min;
							$net_salary = $this->totalSalary($employee, $payslip_type, $total_gaji_tunjangan, $allowance_amount, $deduction_amount, $pension_amount, $total);
						}

						$data = [];
						$data['payslip_key']    = Str::random('20');
						$data['payslip_number'] = mt_rand(1000000000, 9999999999);
						$data['payment_type']   = $payslip_type;
						$data['basic_salary']   = $basicsalary; //
						$data['allowances']     = $allowances;
						$data['commissions']    = $employee->commissions;
						$data['loans']          = $employee->loans;
						$data['deductions']     = $deductions;
						$data['overtimes']      = $employee->overtimes;
						$data['other_payments'] = $employee->otherPayments;
						$data['month_year']     = $request->month_year;
						$data['net_salary']     = $net_salary;
						$data['status']         = 1;
						$data['employee_id']    = $employee->id;
						$data['hours_worked']   = $total_hours; //only for Hourly base employee
						$data['pension_type']   = $employee->pension_type;
						$data['pension_amount'] = $pension_amount;
						$data['company_id']     = $employee->company_id;

						$total_sum = $total_sum + $net_salary;

						if ($employee->loans) {
							foreach ($employee->loans as $loan) {
								if ($loan->time_remaining == '0') {
									$amount_remaining = 0;
									$time_remaining = 0;
									$monthly_payable = 0;
								} else {
									$amount_remaining = $loan->amount_remaining - $loan->monthly_payable;
									$time_remaining = $loan->time_remaining - 1;
									$monthly_payable = $amount_remaining != 0 ? $loan->monthly_payable : 0;
								}
								SalaryLoan::whereId($loan->id)->update([
									'amount_remaining' => $amount_remaining, 'time_remaining' => $time_remaining,
									'monthly_payable' => $monthly_payable
								]);
							}
							$employee_loan = Employee::with('loans:id,employee_id,loan_title,loan_amount,time_remaining,amount_remaining,monthly_payable')
								->select('id', 'first_name', 'last_name', 'basic_salary', 'payslip_type')
								->findOrFail($employee->id);
							$data['loans'] = $employee_loan->loans;
						}

						if ($data['payment_type'] == NULL) { //New
							return response()->json(['payment_type_error' => __('Please select payslip-type for the employees.')]);
						}
						Payslip::create($data);
					}


					$account_balance = DB::table('finance_bank_cashes')->where('id', config('variable.account_id'))->pluck('account_balance')->first();

					if ((int)$account_balance < $total_sum) {
						throw new Exception("requested balance is less then available balance");
					}

					$new_balance = (int)$account_balance - (int)$total_sum;

					$finance_data = [];

					$finance_data['account_id'] = config('variable.account_id');
					$finance_data['amount'] = $total_sum;
					$finance_data['expense_date'] = now()->format(env('Date_Format'));
					$finance_data['expense_reference'] = trans('file.Payroll');


					FinanceBankCash::whereId($finance_data['account_id'])->update(['account_balance' => $new_balance]);

					$Expense = FinanceTransaction::create($finance_data);

					$finance_data['id'] = $Expense->id;

					FinanceExpense::create($finance_data);

					DB::commit();
				} catch (Exception $e) {
					DB::rollback();
					return response()->json(['error' =>  $e->getMessage()]);
				} catch (Throwable $e) {
					DB::rollback();
					return response()->json(['error' => $e->getMessage()]);
				}

				return response()->json(['success' => __('Paid Successfully')]);
			}
		}

		return response()->json(['error' => __('Error')]);
	}

	protected function allowances($employee, $first_date, $type, $work_days = 0)
	{
		if ($type == "getArray") {
            $allowances = array();
            if (!$employee->allowances->isEmpty()) {
				foreach ($employee->allowances as $item) {
					if ($item->first_date <= $first_date) {
						$allowances[] = $item;
					}
				}
			} // If $employee->allowances is empty, $allowances will also be an empty array.
			return $allowances;
		} elseif ($type == "getAmount") {
			$allowance_amount = 0;
			if (!$employee->allowances->isEmpty()) {
				foreach ($employee->allowances as $item) {
					if ($item->first_date <= $first_date) {
						if($item->is_taxable == 1)
						{
							$allowance_amount += $item->allowance_amount;
						}
						else
						{
							$allowance_amount += $item->allowance_amount * $work_days;
						}
						
					}
				}
			}
			return $allowance_amount;
		}
	}

	protected function deductions($employee, $first_date, $type)
	{
		if ($type == "getAmount") {
			$deduction_amount = 0;
			if (!$employee->deductions->isEmpty()) {
				foreach ($employee->deductions as $item) {
					if ($item->first_date <= $first_date) {
						$deduction_amount = 0;
						foreach ($employee->deductions as $value) {
							if ($value->first_date <= $first_date) {
								if ($item->first_date == $value->first_date) {
									$deduction_amount += $value->deduction_amount;
								}
							}
						}
					}
				}
			}
			return $deduction_amount;
		} elseif ($type == "getArray") {
			if (!$employee->deductions->isEmpty()) {
				foreach ($employee->deductions as $item) {
					if ($item->first_date <= $first_date) {
						$deductions = array();
						foreach ($employee->deductions as $key => $value) {
							if ($value->first_date <= $first_date) {
								if ($item->first_date == $value->first_date) {
									$deductions[] =  $employee->deductions[$key];
								}
							}
						}
					}
				}
			} else {
				$deductions = [];
			}
			return $deductions;
		}
	}

	public function export()
    {
        return Excel::download(new PayslipExport, 'payroll.xlsx');
    }

}
