<?php


namespace App\Http\Controllers\Variables;


use App\status;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class StatusTypeController {

	public function index()
	{

		if (request()->ajax())
		{
			return datatables()->of(status::select('id', 'status_title')->get())
				->setRowId(function ($status_type)
				{
					return $status_type->id;
				})
				->addColumn('action', function ($data)
				{
					if (auth()->user()->can('user-edit'))
					{
						$button = '<button type="button" name="edit" id="' . $data->id . '" class="status_edit btn btn-primary btn-sm"><i class="dripicons-pencil"></i></button>';
						$button .= '&nbsp;&nbsp;';
						$button .= '<button type="button" name="delete" id="' . $data->id . '" class="status_delete btn btn-danger btn-sm"><i class="dripicons-trash"></i></button>';

						return $button;
					} else
					{
						return '';
					}
				})
				->rawColumns(['action'])
				->make(true);
		}

	}

	public function store(Request $request)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('user-add'))
		{
			$validator = Validator::make($request->only('status_title'),
				[
					'status_title' => 'required|unique:statuses',
				]
//				,
//				[
//					'status_title.required' => 'Status name can not be empty',
//					'status_title.unique'  => 'Status name already exist',
//				]
			);


			if ($validator->fails())
			{
				return response()->json(['errors' => $validator->errors()->all()]);
			}

			$data = [];

			$data['status_title'] = $request->get('status_title');

			status::create($data);

			return response()->json(['success' => __('Data Added successfully.')]);
		}

		return abort('403', __('You are not authorized'));

	}



	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param int $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id)
	{
		if(request()->ajax())
		{
			$data = status::findOrFail($id);

			return response()->json(['data' => $data]);
		}
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param \Illuminate\Http\Request $request
	 * @param int $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('user-edit'))
		{
			$id = $request->hidden_status_id;

			$validator = Validator::make($request->only('status_title_edit'),
				[
					'status_title_edit' => 'required|unique:statuses,status_title,'.$id,
				]
//				,
//				[
//					'status_title_edit.required' => 'Status name can not be empty',
//					'status_title_edit.unique'  => 'Status name already exist',
//				]
			);


			if ($validator->fails())
			{
				return response()->json(['errors' => $validator->errors()->all()]);
			}

			$data = [];

			$data['status_title'] = $request->get('status_title_edit');



			status::whereId($id)->update($data);

			return response()->json(['success' => __('Data is successfully updated')]);
		} else
		{

			return abort('403', __('You are not authorized'));
		}
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param int $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id)
	{
		if(!env('USER_VERIFIED'))
		{
			return response()->json(['error' => 'This feature is disabled for demo!']);
		}
		$logged_user = auth()->user();

		if ($logged_user->can('user-delete'))
		{
			status::whereId($id)->delete();
			return response()->json(['success' => __('Data is successfully deleted')]);
		}
		return abort('403',__('You are not authorized'));
	}

}