<?php

namespace App\Http\Middleware;

use Closure;
use Auth;
use App\company;

class CheckAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::check() && (Auth::user()->role_users_id == 1 || Auth::user()->role_users_id == 6)) {
			if(Auth::user()->role_users_id == 1) {
				$companyId = json_decode(Auth::user()->company_ids, true);
				$companies = company::all();
				$my_companies = company::all();
				view()->share(['companies' => $companies, 'my_companies' => $my_companies]);
			}
			if(Auth::user()->role_users_id == 6) {
				if(!$request->session()->has('selected_company')) {
					$companyId = json_decode(Auth::user()->company_ids, true);
				} else {
					$companyId = array(session('selected_company'));
				}
				$companies = company::whereIn('id', $companyId)->get();
				$my_companies = company::whereIn('id', json_decode(Auth::user()->company_ids, true))->get();
				view()->share(['companies' => $companies, 'my_companies' => $my_companies]);
			}

            return $next($request);
        }
        /*if(Auth::check() && Auth::user()->role_id==2){

			return redirect("/employee/dashboard");
		}
		*/


        return redirect("/");
    }
}
