<?php


	namespace App\Imports;

	use App\company;
	use App\department;
	use App\designation;
	use App\Employee;
	use App\EmployeeBankAccount;
	use App\EmployeeSetting;
	use App\GeneralSetting;
	use App\office_shift;
	use App\SalaryBasic;
	use App\status;
	use App\User;
	use Illuminate\Contracts\Queue\ShouldQueue;
	use Illuminate\Support\Collection;
	use Illuminate\Support\Facades\DB;
	use Illuminate\Support\Facades\Hash;
	use Illuminate\Support\Facades\Validator;
	use Maatwebsite\Excel\Concerns\ToCollection;
	use Maatwebsite\Excel\Concerns\WithChunkReading;
	use Maatwebsite\Excel\Concerns\WithHeadingRow;
	use Maatwebsite\Excel\Validators\Failure;
	use Illuminate\Validation\ValidationException;

	class EmployeeImport implements ToCollection, WithHeadingRow, ShouldQueue, WithChunkReading
	{
		protected $errors = [];

		public function collection(Collection $rows)
		{
			$i = 2;

			foreach ($rows as $row) {
				$officeShiftId = null;
				if(!empty($row['first_name']) && $row['first_name'] != "")
				{
					// Check required fields and throw exceptions if not valid
					if (empty($row['first_name'])) {
						throw new \Exception("First Name is required in line '{$i}'");
					}
				
					if (empty($row['staff_id'])) {
						throw new \Exception("Staff ID is required in line '{$i}'");
					}
				
					if (empty($row['identity_number'])) {
						throw new \Exception("Identity Number is required in line '{$i}'");
					}
				
					if (empty($row['password'])) {
						throw new \Exception("Password is required in line '{$i}'");
					}
					
					// Password validation
                    $password = $row['password'];
                    if (!$this->isValidPassword($password)) {
                        throw new \Exception("Password does not meet the criteria in line '{$i}'");
                    }
				
					if (empty($row['joining_date'])) {
						throw new \Exception("Joining Date is required in line '{$i}'");
					}
				
					if (empty($row['gender'])) {
						throw new \Exception("Gender is required in line '{$i}'");
					}
				
					if (empty($row['date_of_birth'])) {
						throw new \Exception("Date of Birth is required in line '{$i}'");
					}
				
					if (empty($row['marital_status'])) {
						throw new \Exception("Marital Status is required in line '{$i}'");
					}
				
					if (!isset($row['dependent'])) {
						throw new \Exception("Dependent field is required in line '{$i}'");
					}
				
					if (empty($row['company_name'])) {
						throw new \Exception("Company Name is required in line '{$i}'");
					}
				
					if (empty($row['department_name'])) {
						throw new \Exception("Department Name is required in line '{$i}'");
					}
				
					if (empty($row['designation_name'])) {
						throw new \Exception("Designation Name is required in line '{$i}'");
					}
				
					if (!isset($row['basic_salary_payslip'])) {
						throw new \Exception("Basic Salary Payslip is required in line '{$i}'");
					}
				
					if (empty($row['basic_salary'])) {
						throw new \Exception("Basic Salary is required in line '{$i}'");
					}
				
					if (empty($row['bank_account_title'])) {
						throw new \Exception("Bank Account Title is required in line '{$i}'");
					}
				
					if (empty($row['bank_account_number'])) {
						throw new \Exception("Bank Account Number is required in line '{$i}'");
					}
				
					if (empty($row['bank_name'])) {
						throw new \Exception("Bank Name is required in line '{$i}'");
					}
				
					if (!isset($row['include_bpjs_tk'])) {
						throw new \Exception("Include BPJS TK is required in line '{$i}'");
					}
				
					if (!isset($row['include_bpjs_kes'])) {
						throw new \Exception("Include BPJS Kes is required in line '{$i}'");
					}
				
					if (!isset($row['include_tax'])) {
						throw new \Exception("Include Tax is required in line '{$i}'");
					}

					$companyId = null;
					if (isset($row['company_name'])) {
						$companyData = company::where('company_name', $row['company_name'])->select('id')->first(); 
						if (!$companyData) {
							// $this->errors[] = "Company '{$row['company_name']}' not found for employee '{$row['first_name']}' in line '{$i}'";
							throw new \Exception("Company '{$row['company_name']}' not found for employee '{$row['first_name']}' in line '{$i}'");
							continue; // Skip this row
						}
						else
						{
							$companyId = $companyData->id;	
						}
						// $companyId = $companyData ? $companyData->id : null;
					}
					
					if (isset($row['shift_name'])) {
						$officeShiftData = office_shift::where('shift_name', $row['shift_name'])->where('company_id', $companyId)->select('id')->first();
						
						if (!$officeShiftData) {
							throw new \Exception("Shift '{$row['shift_name']}' in Company '{$row['company_name']}' not found in line '{$i}'");
							continue; // Skip this row
						}
						else
						{
							$officeShiftId = $officeShiftData ? $officeShiftData->id : null;
						}
					}

					$departmentId = null;
					if (isset($row['department_name'])) {
						$departmentData = department::where('department_name', $row['department_name'])->where('company_id', $companyId)->select('id')->first(); 
						$departmentId = $departmentData ? $departmentData->id : null;
					}
				
					$designationId = null;
					if (isset($row['designation_name'])) {
						$designation_data = designation::where('designation_name', $row['designation_name'])->where('company_id', $companyId)->where('department_id', $departmentId)->select('id')->first();
						$designationId = $designation_data ? $designation_data->id : null;
					}
					
					$statusId = null;
					if (isset($row['status'])) {
						$statusData = status::where('status_title', $row['status'])->select('id')->first();
						$statusId = $statusData->id;
					}
		
					if (is_string($row['joining_date'])) {
						$joiningDate = date('Y-m-d', strtotime($row['joining_date']));
					} else {
						$joiningDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['joining_date'])->format('Y-m-d');
					}
					
					if (is_string($row['end_of_contract'])) {
						$exitDate = $row['end_of_contract'] ? date('Y-m-d', strtotime($row['end_of_contract'])) : null;
					} else {
						$exitDate = $row['end_of_contract'] ? \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['end_of_contract'])->format('Y-m-d') : null;
					}
					
					if (is_string($row['date_of_birth'])) {
						$birthDate = date('Y-m-d', strtotime($row['date_of_birth']));
					} else {
						$birthDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['date_of_birth'])->format('Y-m-d');
					}
		
					$position = isset($row['position']) && $row['position'] !== '' ? $row['position'] : 0;
					$dispensation = isset($row['dispensation']) && $row['dispensation'] !== '' ? $row['dispensation'] : 0;
					$religion = isset($row['religion']) && $row['religion'] !== '' ? $row['religion'] : null;

					//Check Employee NIK
					$check_id_card = Employee::where('identity_number', $row['identity_number'])->first();
					if(!empty($check_id_card))
					{
						throw new \Exception("ID Number '{$row['identity_number']}' already registered in line '{$i}'");
						continue; // Skip this row
					}

					//Checking Existing Staff id
					$check_employee = Employee::where('staff_id', $row['staff_id'])->first();
					if($check_employee)
					{
						throw new \Exception("Staff ID '{$row['identity_number']}' already registered in line '{$i}'");
						continue; // Skip this row
					}
		
					if ($row['username'] != null && $row['username'] != '') {
						$user = User::create([
							'username' => $row['username'],
							'first_name' => $row['first_name'],
							'last_name' => $row['last_name'],
							'email' => $row['email'],
							// 'password' => Hash::make($row['password']),
							'password' => bcrypt($row['password']),
							'contact_no' => $row['contact_no'],
							'company_ids' => $companyId,
							'role_users_id' => 2,
							'is_active' => 1,
						]);
		
				// 		$employee = Employee::create([
				// 			'id' => $user->id,
				// 			'first_name' => $row['first_name'],
				// 			'last_name' => $row['last_name'],
				// 			'staff_id' => $row['staff_id'],
				// 			'email' => $row['email'],
				// 			// 'identity_number' => $row['identity_number'],
				// 			// 'npwp' => $row['npwp'],
				// 			'contact_no' => (string)$row['contact_no'],
				// 			'date_of_birth' => $birthDate,
				// 			'gender' => $row['gender'],
				// 			'office_shift_id' => (int)$officeShiftId,
				// 			'company_id' => $companyId,
				// 			'department_id' => $departmentId,
				// 			'designation_id' => $designationId,
				// 			'role_users_id' => 2,
				// 			'status_id' => $statusId,
				// 			'joining_date' => $joiningDate,
				// 			'exit_date' => $exitDate,
				// 			'religion' => $religion,
				// 			'marital_status' => strtolower($row['marital_status']),
				// 			'dependent' => $row['dependent'],
				// 			'address' => $row['address'],
				// 			'city' => $row['city'],
				// 			'state' => $row['state'],
				// 			'zip_code' => $row['zip'],
				// 			'attendance_type' => 'General',
				// 			'position' => $position,
				// 			'is_dispensation' => $dispensation,
				// 			'is_active' => 1,
				// 			'country' => 100,
				// 		]);
				
				        $formattedBirthDate = isset($birthDate) ? date('Y-m-d', strtotime($birthDate)) : null;
                        $formattedJoiningDate = isset($joiningDate) ? date('Y-m-d', strtotime($joiningDate)) : null;
                        $formattedExitDate = isset($exitDate) ? date('Y-m-d', strtotime($exitDate)) : null;
                    
                        // Insert and get ID
                        $employeeId = DB::table('employees')->insertGetId([
                            'id' => $user->id,
                            'first_name' => $row['first_name'],
                            'last_name' => $row['last_name'],
                            'staff_id' => $row['staff_id'],
                            'email' => $row['email'],
                            'contact_no' => (string)$row['contact_no'],
                            'date_of_birth' => $formattedBirthDate,
                            'gender' => $row['gender'],
                            'office_shift_id' => (int)$officeShiftId,
                            'company_id' => $companyId,
                            'department_id' => $departmentId,
                            'designation_id' => $designationId,
                            'role_users_id' => 2,
                            'status_id' => $statusId,
                            'joining_date' => $formattedJoiningDate,
                            'exit_date' => $formattedExitDate,
                            'religion' => $religion,
                            'marital_status' => strtolower($row['marital_status']),
                            'dependent' => $row['dependent'],
                            'address' => $row['address'],
                            'city' => $row['city'],
                            'state' => $row['state'],
                            'zip_code' => $row['zip'],
                            'attendance_type' => 'General',
                            'position' => $position,
                            'is_dispensation' => $dispensation,
                            'is_active' => 1,
                            'country' => 100,
                        ]);
                    
                        // Retrieve and return the inserted employee data
                        $employee = DB::table('employees')->where('id', $employeeId)->first();
                        
					} else {
						$employee = Employee::create([
							'first_name' => $row['first_name'],
							'last_name' => $row['last_name'],
							'staff_id' => $row['staff_id'],
							'email' => $row['email'],
							// 'identity_number' => $row['identity_number'],
							// 'npwp' => $row['npwp'],
							'contact_no' => (string)$row['contact_no'],
							'date_of_birth' => $birthDate,
							'gender' => $row['gender'],
							'office_shift_id' => (int)$officeShiftId,
							'company_id' => $companyId,
							'department_id' => $departmentId,
							'designation_id' => $designationId,
							'role_users_id' => 2,
							'status_id' => $statusId,
							'joining_date' => $joiningDate,
							'exit_date' => $exitDate,
							'religion' => $religion,
							'marital_status' => strtolower($row['marital_status']),
							'dependent' => $row['dependent'],
							'address' => $row['address'],
							'city' => $row['city'],
							'state' => $row['state'],
							'zip_code' => $row['zip'],
							'attendance_type' => 'General',
							'position' => $position,
							'is_dispensation' => $dispensation,
							'is_active' => 1,
							'country' => 100,
						]);
					}
		
					if ($row['basic_salary_month_year'] != null && $row['basic_salary_month_year'] != '') {
						$firstDate = date('Y-m-d', strtotime('first day of ' . $row['basic_salary_month_year']));
						SalaryBasic::create([
							'employee_id' => $employee->id,
							'month_year' => $row['basic_salary_month_year'],
							'first_date' => $firstDate,
							'payslip_type' => $row['basic_salary_payslip'],
							'basic_salary' => $row['basic_salary']
						]);
					}
		
					if ($row['bank_account_title'] != null && $row['bank_account_title'] != '') {
						EmployeeBankAccount::create([
							'employee_id' => $employee->id,
							'account_name' => $row['bank_account_title'],
							'account_number' => (string)$row['bank_account_number'],
							'bank_name' => $row['bank_name'],
							'bank_code' => $row['bank_code'],
							'bank_branch' => $row['bank_branch'],
						]);
					}
		
					EmployeeSetting::create([
						'employee_id' => $employee->id,
						'is_bpjs_tk_include' => $row['include_bpjs_tk'],
						'is_bpjs_kes_include' => $row['include_bpjs_kes'],
						'is_tax_include' => $row['include_tax'],
					]);

					if(!empty($employee))
					{
						$data['identity_number'] = (string)$row['identity_number'];
						$data['npwp'] = (string)$row['npwp'];
						employee::find($employee->id)->update($data);
					}
				}
				else
				{
					throw new \Exception("First Name is required in line '{$i}'");
				}
				
				$i++;
			}
			
			// return $this->errors;
		}
		
		/**
		 * Validate password complexity.
		 * 
		 * @param string $password
		 * @return bool
		 */
		private function isValidPassword($password)
		{
			$minLength = 8;
			$hasUppercase = preg_match('/[A-Z]/', $password);
			$hasLowercase = preg_match('/[a-z]/', $password);
			$hasNumber = preg_match('/[0-9]/', $password);
			$hasSpecialChar = preg_match('/[\W_]/', $password); // Matches special characters

			return strlen($password) >= $minLength && $hasUppercase && $hasLowercase && $hasNumber && $hasSpecialChar;
		}
		
		public function chunkSize(): int
		{
			return 500;
		}
	}
