<?php

namespace App\Mail;

use App\Employee;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Envelope;

class EmployeeContractReminderMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $employee;
    protected $companyLogo;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($employee, $companyLogo)
    {
        $this->employee = $employee;
        $this->companyLogo = $companyLogo;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.employee_contract', [
            'employee_name' => $this->employee->first_name  . ' ' . $this->employee->last_name,
            'exit_date' => $this->employee->exit_date,
            'company_logo' => $this->companyLogo
        ]);
    }
}
