<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RawAttendance extends Model
{
    use HasFactory;

    protected $fillable = ['employee_id', 'attendance_date', 'attendance_time', 'photos'];
    protected $appends = ['formatted_attendance_time'];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function getFormattedAttendanceTimeAttribute()
    {
        $time = new Carbon($this->attributes['attendance_time']);
        return $time->format('g:iA');
    }
}
