<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Reimbursement extends Model
{
  use HasFactory;

  protected $fillable = ['employee_id', 'reimbursement_type_id', 'amount', 'description', 'attachment', 'status'];
  protected $appends = ['amount_formatted', 'attachment_url'];

  public function employee()
  {
    return $this->belongsTo(Employee::class);
  }

  public function reimbursementType()
  {
    return $this->belongsTo(ReimbursementType::class);
  }

  public function getAmountFormattedAttribute()
  {
    return number_format($this->attributes['amount'], 0, ',', '.');
  }

  public function getAttachmentUrlAttribute()
  {
    return url("uploads/reimbursement_attachments/". $this->attributes['attachment']);
  }
}
