<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SalaryDeduction extends Model
{

	protected $guarded = [];
	protected $appends = ['deduction_amount_formatted'];

	public function employee()
	{
		return $this->hasOne('App\Employee', 'id', 'employee_id');
	}

	public function getDeductionAmountFormattedAttribute()
	{
		return number_format($this->attributes['deduction_amount'], 0, ',', '.');
	}
}
