<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tax extends Model
{
    use HasFactory;

    protected $fillable = ['company_id', 'max_salary', 'min_salary', 'percentage'];
    protected $appends = ['min_salary_formatted', 'max_salary_formatted'];

    public function company()
    {
        return $this->belongsTo(company::class);
    }

    public function getMinSalaryFormattedAttribute()
    {
        return number_format($this->attributes['min_salary'], 0, ',', '.');
    }

    public function getMaxSalaryFormattedAttribute()
    {
        return number_format($this->attributes['max_salary'], 0, ',', '.');
    }
}
