SET foreign_key_checks = 0;

CREATE TABLE `announcements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `summary` text DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `added_by` varchar(40) DEFAULT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `announcements_company_id_foreign` (`company_id`),
  KEY `announcements_department_id_foreign` (`department_id`),
  KEY `announcements_added_by_foreign` (`added_by`),
  CONSTRAINT `announcements_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `announcements_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO announcements VALUES('1','Testing Announcement','2024-05-01','2024-06-23','testing','test','2','','timas_suplindo','1','2024-05-07 08:57:38','2024-05-07 08:57:38');



CREATE TABLE `appraisals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `department_id` bigint(20) unsigned NOT NULL,
  `designation_id` bigint(20) unsigned NOT NULL,
  `customer_experience` varchar(191) NOT NULL,
  `marketing` varchar(191) DEFAULT NULL,
  `administration` varchar(191) DEFAULT NULL,
  `professionalism` varchar(191) DEFAULT NULL,
  `integrity` varchar(191) DEFAULT NULL,
  `attendance` varchar(191) DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `date` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `asset_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `category_name` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `asset_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO asset_categories VALUES('1','','ATK','2024-02-07 15:05:23','2024-02-07 15:05:23');
INSERT INTO asset_categories VALUES('2','','PANTRY','2024-02-07 15:05:44','2024-02-07 15:05:44');
INSERT INTO asset_categories VALUES('3','','OFFICE','2024-02-07 15:05:57','2024-02-07 15:05:57');



CREATE TABLE `assets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_name` varchar(50) NOT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `asset_code` varchar(80) NOT NULL,
  `assets_category_id` bigint(20) unsigned NOT NULL,
  `Asset_note` mediumtext DEFAULT NULL,
  `manufacturer` varchar(191) NOT NULL,
  `serial_number` varchar(191) NOT NULL,
  `invoice_number` varchar(191) NOT NULL,
  `asset_image` varchar(191) DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `warranty_date` date NOT NULL,
  `status` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_company_id_foreign` (`company_id`),
  KEY `assets_employee_id_foreign` (`employee_id`),
  KEY `assets_assets_category_id_foreign` (`assets_category_id`),
  CONSTRAINT `assets_assets_category_id_foreign` FOREIGN KEY (`assets_category_id`) REFERENCES `asset_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `attendance_date` date NOT NULL,
  `clock_in` varchar(191) NOT NULL,
  `clock_out` varchar(191) NOT NULL,
  `total_work` varchar(191) NOT NULL DEFAULT '00:00',
  `is_underwork` tinyint(1) NOT NULL,
  `status` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attendances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `attendances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `award_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `award_name` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO award_types VALUES('1','PANJAT PINANG','2024-02-06 16:14:17','2024-02-06 16:14:17');
INSERT INTO award_types VALUES('2','LOMBA ADZAN','2024-02-06 16:14:32','2024-02-06 16:14:32');



CREATE TABLE `awards` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `award_information` mediumtext DEFAULT NULL,
  `award_date` date NOT NULL,
  `gift` varchar(40) DEFAULT NULL,
  `cash` varchar(40) DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `award_type_id` bigint(20) unsigned DEFAULT NULL,
  `award_photo` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `awards_company_id_foreign` (`company_id`),
  KEY `awards_department_id_foreign` (`department_id`),
  KEY `awards_employee_id_foreign` (`employee_id`),
  KEY `awards_award_type_id_foreign` (`award_type_id`),
  CONSTRAINT `awards_award_type_id_foreign` FOREIGN KEY (`award_type_id`) REFERENCES `award_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `bpjs_kes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `company` decimal(8,2) NOT NULL,
  `employee` decimal(8,2) NOT NULL,
  `min_salary` double NOT NULL,
  `max_salary` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bpjs_kes_company_id_foreign` (`company_id`),
  CONSTRAINT `bpjs_kes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO bpjs_kes VALUES('1','1','Kesehatan','4.00','1.00','0','999999999','2024-02-06 13:27:55','2024-02-06 13:27:55');



CREATE TABLE `bpjs_tk` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `general` decimal(8,2) NOT NULL,
  `company` decimal(8,2) NOT NULL,
  `employee` decimal(8,2) NOT NULL,
  `type` enum('pensiun','jht','jkm','jkk') DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bpjs_tk_company_id_foreign` (`company_id`),
  CONSTRAINT `bpjs_tk_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO bpjs_tk VALUES('1','1','Jaminan Pensiun','0.00','2.00','1.00','pensiun','2024-02-06 13:26:08','2024-02-06 13:26:08');
INSERT INTO bpjs_tk VALUES('2','1','Jaminan Hari Tua','0.00','3.70','2.00','jht','2024-02-06 13:26:30','2024-02-06 13:26:30');
INSERT INTO bpjs_tk VALUES('3','1','Jaminan Kematian','0.30','0.00','0.00','jkm','2024-02-06 13:26:47','2024-02-06 13:26:47');
INSERT INTO bpjs_tk VALUES('4','1','Jaminan Kecelakaan Kerja','0.24','0.00','0.00','jkk','2024-02-06 13:27:11','2024-02-06 13:27:11');



CREATE TABLE `c_m_s` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `home` longtext DEFAULT NULL,
  `about` longtext DEFAULT NULL,
  `contact` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `calendarables` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `candidate_interview` (
  `interview_id` bigint(20) unsigned NOT NULL,
  `candidate_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`interview_id`,`candidate_id`),
  KEY `candidate_interview_candidate_id_foreign` (`candidate_id`),
  CONSTRAINT `candidate_interview_candidate_id_foreign` FOREIGN KEY (`candidate_id`) REFERENCES `job_candidates` (`id`),
  CONSTRAINT `candidate_interview_interview_id_foreign` FOREIGN KEY (`interview_id`) REFERENCES `job_interviews` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) NOT NULL,
  `last_name` varchar(191) NOT NULL,
  `email` varchar(191) DEFAULT NULL,
  `contact_no` varchar(15) NOT NULL,
  `username` varchar(64) NOT NULL,
  `profile` varchar(191) DEFAULT NULL,
  `company_name` varchar(191) NOT NULL,
  `gender` varchar(40) NOT NULL,
  `website` varchar(40) DEFAULT NULL,
  `address1` mediumtext DEFAULT NULL,
  `address2` mediumtext DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `zip` varchar(191) DEFAULT NULL,
  `country` tinyint(4) DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `clients_id_foreign` FOREIGN KEY (`id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `companies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(191) NOT NULL,
  `company_type` varchar(191) NOT NULL,
  `trading_name` varchar(191) DEFAULT NULL,
  `registration_no` varchar(191) DEFAULT NULL,
  `contact_no` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `tax_no` varchar(191) DEFAULT NULL,
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `company_logo` varchar(191) DEFAULT NULL,
  `start_cut_off_date` tinyint(4) NOT NULL,
  `end_cut_off_date` tinyint(4) NOT NULL,
  `leave_amount` int(11) NOT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companies_location_id_foreign` (`location_id`),
  CONSTRAINT `companies_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `locations` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO companies VALUES('1','HEAD OFFICE','corporation','HO','','0213522828','hrga@timas.com','','01.335.995.5-073.000','1','1441048652_1715011233.jpg','1','31','21','','2024-02-05 15:36:37','2024-05-06 23:00:33');
INSERT INTO companies VALUES('2','RAPP','corporation','','','082373325808','afriyon@timas.com','','192837465647382','2','509447849_1707280943.jpg','21','20','25','','2024-02-05 16:55:38','2024-02-07 11:42:23');
INSERT INTO companies VALUES('3','FABRICATION SHOP','corporation','FS','','0213522828','hrga.workshop@timas.com','','01.335.995.5-073.000','3','','21','20','25','','2024-02-05 19:43:02','2024-02-05 19:44:00');
INSERT INTO companies VALUES('4','TIMAS MULTI KONSTRUKSI','corporation','TMK','','0213522828','hrga@timas.com','','01.850.021.5-028.000','1','59739154_1715011147.jpg','1','31','21','','2024-02-05 19:47:20','2024-05-06 22:59:07');
INSERT INTO companies VALUES('5','TIMAS OCEANSTAR INDONESIA','corporation','TOI','','02129921828','hrga@timas.com','','96.332.046.0-076.000','1','','1','31','21','','2024-02-05 19:49:32','2024-02-05 19:49:32');
INSERT INTO companies VALUES('6','TIMAS SAMUDERA INDONESIA','corporation','TSI','','02129921828','hrga@timas.com','','01.335.995.5-073.000','1','','1','31','21','','2024-02-05 19:51:36','2024-02-05 19:51:36');
INSERT INTO companies VALUES('7','PRI','corporation','PRI','','0213522828','hrga@timas.com','','01.335.995.5-073.000','4','','21','20','25','','2024-02-05 19:55:10','2024-02-05 19:55:10');
INSERT INTO companies VALUES('8','OKI','corporation','OKI','','0213522828','hrga@timas.com','','01.335.995.5-073.000','5','','21','20','25','','2024-02-05 19:57:07','2024-04-23 14:40:47');
INSERT INTO companies VALUES('9','TIMAS SUPLINDO - OFFSHORE DIVISION','corporation','TP','','02129921828','hrga@timas.com','','01.850.021.5-028.000','1','242125747_1715011189.jpg','1','31','21','','2024-02-05 20:07:23','2024-05-07 14:39:17');
INSERT INTO companies VALUES('10','DURI','corporation','AD','','0213522828','hrga@timas.com','','01.335.995.5-073.000','1','','21','20','12','','2024-04-29 10:28:07','2024-04-29 10:28:07');
INSERT INTO companies VALUES('11','CONSORTIUM TIMAS SUPLINDO - AMR','partnership','CONS TS - AMR','','02129921828','hrga@timas.com','','01.335.995.5-073.000','1','','1','31','12','','2024-05-07 14:43:32','2024-05-07 14:43:32');



CREATE TABLE `complaints` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `complaint_title` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `complaint_from` bigint(20) unsigned NOT NULL,
  `complaint_against` bigint(20) unsigned NOT NULL,
  `complaint_date` date NOT NULL,
  `status` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `complaints_company_id_foreign` (`company_id`),
  KEY `complaints_complaint_from_foreign` (`complaint_from`),
  KEY `complaints_complaint_against_foreign` (`complaint_against`),
  CONSTRAINT `complaints_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `complaints_complaint_against_foreign` FOREIGN KEY (`complaint_against`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `complaints_complaint_from_foreign` FOREIGN KEY (`complaint_from`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO countries VALUES('1','US','United States');
INSERT INTO countries VALUES('2','CA','Canada');
INSERT INTO countries VALUES('3','AF','Afghanistan');
INSERT INTO countries VALUES('4','AL','Albania');
INSERT INTO countries VALUES('5','DZ','Algeria');
INSERT INTO countries VALUES('6','DS','American Samoa');
INSERT INTO countries VALUES('7','AD','Andorra');
INSERT INTO countries VALUES('8','AO','Angola');
INSERT INTO countries VALUES('9','AI','Anguilla');
INSERT INTO countries VALUES('10','AQ','Antarctica');
INSERT INTO countries VALUES('11','AG','Antigua and/or Barbuda');
INSERT INTO countries VALUES('12','AR','Argentina');
INSERT INTO countries VALUES('13','AM','Armenia');
INSERT INTO countries VALUES('14','AW','Aruba');
INSERT INTO countries VALUES('15','AU','Australia');
INSERT INTO countries VALUES('16','AT','Austria');
INSERT INTO countries VALUES('17','AZ','Azerbaijan');
INSERT INTO countries VALUES('18','BS','Bahamas');
INSERT INTO countries VALUES('19','BH','Bahrain');
INSERT INTO countries VALUES('20','BD','Bangladesh');
INSERT INTO countries VALUES('21','BB','Barbados');
INSERT INTO countries VALUES('22','BY','Belarus');
INSERT INTO countries VALUES('23','BE','Belgium');
INSERT INTO countries VALUES('24','BZ','Belize');
INSERT INTO countries VALUES('25','BJ','Benin');
INSERT INTO countries VALUES('26','BM','Bermuda');
INSERT INTO countries VALUES('27','BT','Bhutan');
INSERT INTO countries VALUES('28','BO','Bolivia');
INSERT INTO countries VALUES('29','BA','Bosnia and Herzegovina');
INSERT INTO countries VALUES('30','BW','Botswana');
INSERT INTO countries VALUES('31','BV','Bouvet Island');
INSERT INTO countries VALUES('32','BR','Brazil');
INSERT INTO countries VALUES('33','IO','British lndian Ocean Territory');
INSERT INTO countries VALUES('34','BN','Brunei Darussalam');
INSERT INTO countries VALUES('35','BG','Bulgaria');
INSERT INTO countries VALUES('36','BF','Burkina Faso');
INSERT INTO countries VALUES('37','BI','Burundi');
INSERT INTO countries VALUES('38','KH','Cambodia');
INSERT INTO countries VALUES('39','CM','Cameroon');
INSERT INTO countries VALUES('40','CV','Cape Verde');
INSERT INTO countries VALUES('41','KY','Cayman Islands');
INSERT INTO countries VALUES('42','CF','Central African Republic');
INSERT INTO countries VALUES('43','TD','Chad');
INSERT INTO countries VALUES('44','CL','Chile');
INSERT INTO countries VALUES('45','CN','China');
INSERT INTO countries VALUES('46','CX','Christmas Island');
INSERT INTO countries VALUES('47','CC','Cocos (Keeling) Islands');
INSERT INTO countries VALUES('48','CO','Colombia');
INSERT INTO countries VALUES('49','KM','Comoros');
INSERT INTO countries VALUES('50','CG','Congo');
INSERT INTO countries VALUES('51','CK','Cook Islands');
INSERT INTO countries VALUES('52','CR','Costa Rica');
INSERT INTO countries VALUES('53','HR','Croatia (Hrvatska)');
INSERT INTO countries VALUES('54','CU','Cuba');
INSERT INTO countries VALUES('55','CY','Cyprus');
INSERT INTO countries VALUES('56','CZ','Czech Republic');
INSERT INTO countries VALUES('57','DK','Denmark');
INSERT INTO countries VALUES('58','DJ','Djibouti');
INSERT INTO countries VALUES('59','DM','Dominica');
INSERT INTO countries VALUES('60','DO','Dominican Republic');
INSERT INTO countries VALUES('61','TP','East Timor');
INSERT INTO countries VALUES('62','EC','Ecudaor');
INSERT INTO countries VALUES('63','EG','Egypt');
INSERT INTO countries VALUES('64','SV','El Salvador');
INSERT INTO countries VALUES('65','GQ','Equatorial Guinea');
INSERT INTO countries VALUES('66','ER','Eritrea');
INSERT INTO countries VALUES('67','EE','Estonia');
INSERT INTO countries VALUES('68','ET','Ethiopia');
INSERT INTO countries VALUES('69','FK','Falkland Islands (Malvinas)');
INSERT INTO countries VALUES('70','FO','Faroe Islands');
INSERT INTO countries VALUES('71','FJ','Fiji');
INSERT INTO countries VALUES('72','FI','Finland');
INSERT INTO countries VALUES('73','FR','France');
INSERT INTO countries VALUES('74','FX','France, Metropolitan');
INSERT INTO countries VALUES('75','GF','French Guiana');
INSERT INTO countries VALUES('76','PF','French Polynesia');
INSERT INTO countries VALUES('77','TF','French Southern Territories');
INSERT INTO countries VALUES('78','GA','Gabon');
INSERT INTO countries VALUES('79','GM','Gambia');
INSERT INTO countries VALUES('80','GE','Georgia');
INSERT INTO countries VALUES('81','DE','Germany');
INSERT INTO countries VALUES('82','GH','Ghana');
INSERT INTO countries VALUES('83','GI','Gibraltar');
INSERT INTO countries VALUES('84','GR','Greece');
INSERT INTO countries VALUES('85','GL','Greenland');
INSERT INTO countries VALUES('86','GD','Grenada');
INSERT INTO countries VALUES('87','GP','Guadeloupe');
INSERT INTO countries VALUES('88','GU','Guam');
INSERT INTO countries VALUES('89','GT','Guatemala');
INSERT INTO countries VALUES('90','GN','Guinea');
INSERT INTO countries VALUES('91','GW','Guinea-Bissau');
INSERT INTO countries VALUES('92','GY','Guyana');
INSERT INTO countries VALUES('93','HT','Haiti');
INSERT INTO countries VALUES('94','HM','Heard and Mc Donald Islands');
INSERT INTO countries VALUES('95','HN','Honduras');
INSERT INTO countries VALUES('96','HK','Hong Kong');
INSERT INTO countries VALUES('97','HU','Hungary');
INSERT INTO countries VALUES('98','IS','Iceland');
INSERT INTO countries VALUES('99','IN','India');
INSERT INTO countries VALUES('100','ID','Indonesia');
INSERT INTO countries VALUES('101','IR','Iran (Islamic Republic of)');
INSERT INTO countries VALUES('102','IQ','Iraq');
INSERT INTO countries VALUES('103','IE','Ireland');
INSERT INTO countries VALUES('104','IL','Israel');
INSERT INTO countries VALUES('105','IT','Italy');
INSERT INTO countries VALUES('106','CI','Ivory Coast');
INSERT INTO countries VALUES('107','JM','Jamaica');
INSERT INTO countries VALUES('108','JP','Japan');
INSERT INTO countries VALUES('109','JO','Jordan');
INSERT INTO countries VALUES('110','KZ','Kazakhstan');
INSERT INTO countries VALUES('111','KE','Kenya');
INSERT INTO countries VALUES('112','KI','Kiribati');
INSERT INTO countries VALUES('113','KP','Korea, Democratic People\'s Republic of');
INSERT INTO countries VALUES('114','KR','Korea, Republic of');
INSERT INTO countries VALUES('115','KW','Kuwait');
INSERT INTO countries VALUES('116','KG','Kyrgyzstan');
INSERT INTO countries VALUES('117','LA','Lao People\'s Democratic Republic');
INSERT INTO countries VALUES('118','LV','Latvia');
INSERT INTO countries VALUES('119','LB','Lebanon');
INSERT INTO countries VALUES('120','LS','Lesotho');
INSERT INTO countries VALUES('121','LR','Liberia');
INSERT INTO countries VALUES('122','LY','Libyan Arab Jamahiriya');
INSERT INTO countries VALUES('123','LI','Liechtenstein');
INSERT INTO countries VALUES('124','LT','Lithuania');
INSERT INTO countries VALUES('125','LU','Luxembourg');
INSERT INTO countries VALUES('126','MO','Macau');
INSERT INTO countries VALUES('127','MK','Macedonia');
INSERT INTO countries VALUES('128','MG','Madagascar');
INSERT INTO countries VALUES('129','MW','Malawi');
INSERT INTO countries VALUES('130','MY','Malaysia');
INSERT INTO countries VALUES('131','MV','Maldives');
INSERT INTO countries VALUES('132','ML','Mali');
INSERT INTO countries VALUES('133','MT','Malta');
INSERT INTO countries VALUES('134','MH','Marshall Islands');
INSERT INTO countries VALUES('135','MQ','Martinique');
INSERT INTO countries VALUES('136','MR','Mauritania');
INSERT INTO countries VALUES('137','MU','Mauritius');
INSERT INTO countries VALUES('138','TY','Mayotte');
INSERT INTO countries VALUES('139','MX','Mexico');
INSERT INTO countries VALUES('140','FM','Micronesia, Federated States of');
INSERT INTO countries VALUES('141','MD','Moldova, Republic of');
INSERT INTO countries VALUES('142','MC','Monaco');
INSERT INTO countries VALUES('143','MN','Mongolia');
INSERT INTO countries VALUES('144','MS','Montserrat');
INSERT INTO countries VALUES('145','MA','Morocco');
INSERT INTO countries VALUES('146','MZ','Mozambique');
INSERT INTO countries VALUES('147','MM','Myanmar');
INSERT INTO countries VALUES('148','NA','Namibia');
INSERT INTO countries VALUES('149','NR','Nauru');
INSERT INTO countries VALUES('150','NP','Nepal');
INSERT INTO countries VALUES('151','NL','Netherlands');
INSERT INTO countries VALUES('152','AN','Netherlands Antilles');
INSERT INTO countries VALUES('153','NC','New Caledonia');
INSERT INTO countries VALUES('154','NZ','New Zealand');
INSERT INTO countries VALUES('155','NI','Nicaragua');
INSERT INTO countries VALUES('156','NE','Niger');
INSERT INTO countries VALUES('157','NG','Nigeria');
INSERT INTO countries VALUES('158','NU','Niue');
INSERT INTO countries VALUES('159','NF','Norfork Island');
INSERT INTO countries VALUES('160','MP','Northern Mariana Islands');
INSERT INTO countries VALUES('161','NO','Norway');
INSERT INTO countries VALUES('162','OM','Oman');
INSERT INTO countries VALUES('163','PK','Pakistan');
INSERT INTO countries VALUES('164','PW','Palau');
INSERT INTO countries VALUES('165','PA','Panama');
INSERT INTO countries VALUES('166','PG','Papua New Guinea');
INSERT INTO countries VALUES('167','PY','Paraguay');
INSERT INTO countries VALUES('168','PE','Peru');
INSERT INTO countries VALUES('169','PH','Philippines');
INSERT INTO countries VALUES('170','PN','Pitcairn');
INSERT INTO countries VALUES('171','PL','Poland');
INSERT INTO countries VALUES('172','PT','Portugal');
INSERT INTO countries VALUES('173','PR','Puerto Rico');
INSERT INTO countries VALUES('174','QA','Qatar');
INSERT INTO countries VALUES('175','RE','Reunion');
INSERT INTO countries VALUES('176','RO','Romania');
INSERT INTO countries VALUES('177','RU','Russian Federation');
INSERT INTO countries VALUES('178','RW','Rwanda');
INSERT INTO countries VALUES('179','KN','Saint Kitts and Nevis');
INSERT INTO countries VALUES('180','LC','Saint Lucia');
INSERT INTO countries VALUES('181','VC','Saint Vincent and the Grenadines');
INSERT INTO countries VALUES('182','WS','Samoa');
INSERT INTO countries VALUES('183','SM','San Marino');
INSERT INTO countries VALUES('184','ST','Sao Tome and Principe');
INSERT INTO countries VALUES('185','SA','Saudi Arabia');
INSERT INTO countries VALUES('186','SN','Senegal');
INSERT INTO countries VALUES('187','SC','Seychelles');
INSERT INTO countries VALUES('188','SL','Sierra Leone');
INSERT INTO countries VALUES('189','SG','Singapore');
INSERT INTO countries VALUES('190','SK','Slovakia');
INSERT INTO countries VALUES('191','SI','Slovenia');
INSERT INTO countries VALUES('192','SB','Solomon Islands');
INSERT INTO countries VALUES('193','SO','Somalia');
INSERT INTO countries VALUES('194','ZA','South Africa');
INSERT INTO countries VALUES('195','GS','South Georgia South Sandwich Islands');
INSERT INTO countries VALUES('196','ES','Spain');
INSERT INTO countries VALUES('197','LK','Sri Lanka');
INSERT INTO countries VALUES('198','SH','St. Helena');
INSERT INTO countries VALUES('199','PM','St. Pierre and Miquelon');
INSERT INTO countries VALUES('200','SD','Sudan');
INSERT INTO countries VALUES('201','SR','Suriname');
INSERT INTO countries VALUES('202','SJ','Svalbarn and Jan Mayen Islands');
INSERT INTO countries VALUES('203','SZ','Swaziland');
INSERT INTO countries VALUES('204','SE','Sweden');
INSERT INTO countries VALUES('205','CH','Switzerland');
INSERT INTO countries VALUES('206','SY','Syrian Arab Republic');
INSERT INTO countries VALUES('207','TW','Taiwan');
INSERT INTO countries VALUES('208','TJ','Tajikistan');
INSERT INTO countries VALUES('209','TZ','Tanzania, United Republic of');
INSERT INTO countries VALUES('210','TH','Thailand');
INSERT INTO countries VALUES('211','TG','Togo');
INSERT INTO countries VALUES('212','TK','Tokelau');
INSERT INTO countries VALUES('213','TO','Tonga');
INSERT INTO countries VALUES('214','TT','Trinidad and Tobago');
INSERT INTO countries VALUES('215','TN','Tunisia');
INSERT INTO countries VALUES('216','TR','Turkey');
INSERT INTO countries VALUES('217','TM','Turkmenistan');
INSERT INTO countries VALUES('218','TC','Turks and Caicos Islands');
INSERT INTO countries VALUES('219','TV','Tuvalu');
INSERT INTO countries VALUES('220','UG','Uganda');
INSERT INTO countries VALUES('221','UA','Ukraine');
INSERT INTO countries VALUES('222','AE','United Arab Emirates');
INSERT INTO countries VALUES('223','GB','United Kingdom');
INSERT INTO countries VALUES('224','UM','United States minor outlying islands');
INSERT INTO countries VALUES('225','UY','Uruguay');
INSERT INTO countries VALUES('226','UZ','Uzbekistan');
INSERT INTO countries VALUES('227','VU','Vanuatu');
INSERT INTO countries VALUES('228','VA','Vatican City State');
INSERT INTO countries VALUES('229','VE','Venezuela');
INSERT INTO countries VALUES('230','VN','Vietnam');
INSERT INTO countries VALUES('231','VG','Virigan Islands (British)');
INSERT INTO countries VALUES('232','VI','Virgin Islands (U.S.)');
INSERT INTO countries VALUES('233','WF','Wallis and Futuna Islands');
INSERT INTO countries VALUES('234','EH','Western Sahara');
INSERT INTO countries VALUES('235','YE','Yemen');
INSERT INTO countries VALUES('236','YU','Yugoslavia');
INSERT INTO countries VALUES('237','ZR','Zaire');
INSERT INTO countries VALUES('238','ZM','Zambia');
INSERT INTO countries VALUES('239','ZW','Zimbabwe');



CREATE TABLE `departments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `department_name` varchar(191) NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_head` bigint(20) unsigned DEFAULT NULL,
  `supervisor` bigint(20) DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `departments_company_id_foreign` (`company_id`),
  KEY `departments_department_head_foreign` (`department_head`),
  CONSTRAINT `departments_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `departments_department_head_foreign` FOREIGN KEY (`department_head`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=154 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO departments VALUES('2','ENGINEERING','1','','','','2024-02-05 16:10:01','2024-02-05 16:10:01');
INSERT INTO departments VALUES('3','FINANCE','1','','','','2024-02-05 16:55:21','2024-02-05 16:55:21');
INSERT INTO departments VALUES('4','ACC & TAX','1','','','','2024-02-05 16:55:34','2024-02-05 16:55:34');
INSERT INTO departments VALUES('5','ACCOUNT PAYABLE','1','','','','2024-02-05 16:56:06','2024-02-05 16:56:06');
INSERT INTO departments VALUES('7','IT','1','','','','2024-02-05 16:56:41','2024-05-07 15:24:46');
INSERT INTO departments VALUES('9','LEGAL & INSURANCE','1','','','','2024-02-05 16:57:51','2024-02-05 16:57:51');
INSERT INTO departments VALUES('10','ASSET MANAGEMENT','1','','','','2024-02-05 16:58:28','2024-02-05 16:58:28');
INSERT INTO departments VALUES('12','PROCUREMENT','1','','','','2024-02-05 16:58:45','2024-02-05 16:58:45');
INSERT INTO departments VALUES('13','QMR','1','','','','2024-02-05 16:58:59','2024-02-05 16:58:59');
INSERT INTO departments VALUES('14','CREATIVE CONTENT &amp; BRANDING','1','','','','2024-02-05 16:59:24','2024-05-08 14:44:09');
INSERT INTO departments VALUES('15','BUSINESS DEVELOPMENT','1','','','','2024-02-05 16:59:53','2024-02-05 16:59:53');
INSERT INTO departments VALUES('16','FABRICATION SHOP','1','','','','2024-02-05 17:00:09','2024-02-05 17:00:09');
INSERT INTO departments VALUES('17','HRGA','2','','','','2024-02-05 17:00:13','2024-04-22 14:43:10');
INSERT INTO departments VALUES('18','PMT','1','','','','2024-02-05 17:01:00','2024-02-05 17:01:00');
INSERT INTO departments VALUES('19','PROJECT SERVICE','1','','','','2024-02-05 17:01:19','2024-02-05 17:01:19');
INSERT INTO departments VALUES('20','HSSE','1','','','','2024-02-05 17:01:27','2024-02-05 17:01:27');
INSERT INTO departments VALUES('21','HR & GA','1','','','','2024-02-05 17:01:38','2024-02-05 17:01:38');
INSERT INTO departments VALUES('23','QA/QC','1','','','','2024-02-05 17:01:46','2024-02-05 17:01:46');
INSERT INTO departments VALUES('24','COMMERCIAL &amp; ETHICS','1','','','','2024-02-05 17:02:09','2024-05-07 18:37:18');
INSERT INTO departments VALUES('25','ENGINEER','2','','','','2024-02-05 17:46:57','2024-04-22 14:42:17');
INSERT INTO departments VALUES('27','CSE','3','','','','2024-02-05 19:45:18','2024-02-05 19:45:18');
INSERT INTO departments VALUES('28','PMT','3','','','','2024-02-05 19:46:00','2024-02-05 19:46:00');
INSERT INTO departments VALUES('29','HR & GA','3','','','','2024-02-05 19:46:15','2024-02-05 19:46:15');
INSERT INTO departments VALUES('30','FINANCE','3','','','','2024-02-05 19:47:15','2024-02-05 19:47:15');
INSERT INTO departments VALUES('31','QA & QC','3','','','','2024-02-05 19:47:22','2024-02-05 19:47:22');
INSERT INTO departments VALUES('32','PPC','3','','','','2024-02-05 19:47:28','2024-02-05 19:47:28');
INSERT INTO departments VALUES('33','ENGINEERING','3','','','','2024-02-05 19:47:48','2024-02-05 19:47:48');
INSERT INTO departments VALUES('34','HSSE','3','','','','2024-02-05 19:47:56','2024-02-05 19:47:56');
INSERT INTO departments VALUES('35','PRODUCTION','3','','','','2024-02-05 19:48:06','2024-02-05 19:48:06');
INSERT INTO departments VALUES('36','LOGISTIC','3','','','','2024-02-05 19:48:20','2024-02-05 19:48:20');
INSERT INTO departments VALUES('37','WAREHOUSE OFFSHORE','3','','','','2024-02-05 19:48:37','2024-02-05 19:48:37');
INSERT INTO departments VALUES('38','ELECTRIC','2','','','','2024-02-06 09:02:25','2024-02-06 09:02:25');
INSERT INTO departments VALUES('39','HEAVY EQUIPMENT','2','','','','2024-02-06 09:02:48','2024-02-06 09:02:48');
INSERT INTO departments VALUES('40','HSSE','2','','','','2024-02-06 09:02:57','2024-02-06 09:02:57');
INSERT INTO departments VALUES('41','INFORMATION TECHNOLOGY','2','','','','2024-02-06 09:03:25','2024-02-06 09:03:25');
INSERT INTO departments VALUES('42','MATERIAL HANDLING','2','','','','2024-02-06 09:04:15','2024-02-06 09:04:15');
INSERT INTO departments VALUES('43','MECHANICAL','2','','','','2024-02-06 09:04:44','2024-02-06 09:04:44');
INSERT INTO departments VALUES('44','PAINTING','2','','','','2024-02-06 09:04:51','2024-02-06 09:04:51');
INSERT INTO departments VALUES('45','PIPING','2','','','','2024-02-06 09:05:01','2024-02-06 09:05:01');
INSERT INTO departments VALUES('46','PMT','2','','','','2024-02-06 09:05:12','2024-02-06 09:05:12');
INSERT INTO departments VALUES('47','PPC','2','','','','2024-02-06 09:05:29','2024-02-06 09:05:29');
INSERT INTO departments VALUES('48','PURCHASING','2','','','','2024-02-06 09:06:25','2024-04-22 14:46:49');
INSERT INTO departments VALUES('50','RIGGING','2','','','','2024-02-06 09:06:41','2024-02-06 09:06:41');
INSERT INTO departments VALUES('51','SCAFFOLDING','2','','','','2024-02-06 09:06:48','2024-02-06 09:06:48');
INSERT INTO departments VALUES('52','SDCC','2','','','','2024-02-06 09:07:00','2024-02-06 09:07:00');
INSERT INTO departments VALUES('53','STRUCTURE','2','','','','2024-02-06 09:07:11','2024-02-06 09:07:11');
INSERT INTO departments VALUES('55','WAREHOUSE','2','','','','2024-02-06 09:07:36','2024-02-06 09:07:36');
INSERT INTO departments VALUES('56','WELDING','2','','','','2024-02-06 09:07:43','2024-02-06 09:07:43');
INSERT INTO departments VALUES('57','HR & GA','3','','','','2024-02-20 20:50:17','2024-02-20 20:50:17');
INSERT INTO departments VALUES('58','HR & GA','4','','','','2024-02-20 20:51:39','2024-02-20 20:51:39');
INSERT INTO departments VALUES('59','FINANCE','4','','','','2024-02-20 20:51:49','2024-02-20 20:51:49');
INSERT INTO departments VALUES('60','HR & GA','5','','','','2024-02-20 20:51:56','2024-02-20 20:51:56');
INSERT INTO departments VALUES('61','FINANCE','5','','','','2024-02-20 20:52:03','2024-02-20 20:52:03');
INSERT INTO departments VALUES('62','HR & GA','6','','','','2024-02-20 20:52:09','2024-02-20 20:52:09');
INSERT INTO departments VALUES('63','FINANCE','6','','','','2024-02-20 20:52:15','2024-02-20 20:52:15');
INSERT INTO departments VALUES('65','FINANCE','7','','','','2024-02-20 20:52:27','2024-02-20 20:52:27');
INSERT INTO departments VALUES('66','HR & GA','8','','','','2024-02-20 20:52:32','2024-02-20 20:52:32');
INSERT INTO departments VALUES('67','FINANCE','8','','','','2024-02-20 20:52:38','2024-02-20 20:52:38');
INSERT INTO departments VALUES('68','FABRICATION ENGINEERING','3','','','','2024-04-16 15:53:02','2024-04-16 15:53:02');
INSERT INTO departments VALUES('69','FABRICATION SHOP','3','','','','2024-04-16 15:55:06','2024-04-16 15:55:06');
INSERT INTO departments VALUES('70','WH TOD','3','','','','2024-04-16 16:23:03','2024-04-16 16:23:03');
INSERT INTO departments VALUES('71','DOKUMENT CONTROL','7','','','','2024-04-22 08:49:45','2024-04-22 08:49:45');
INSERT INTO departments VALUES('72','ELECTRICAL','7','','','','2024-04-22 08:50:06','2024-04-22 08:50:06');
INSERT INTO departments VALUES('73','ENGINEER','7','','','','2024-04-22 08:50:26','2024-04-22 08:50:26');
INSERT INTO departments VALUES('74','HEAVY EQUIPMENT','7','','','','2024-04-22 08:50:44','2024-04-22 08:50:44');
INSERT INTO departments VALUES('76','HSSE','7','','','','2024-04-22 08:51:04','2024-04-22 08:51:04');
INSERT INTO departments VALUES('77','INSTRUMENT ELECTRICAL','7','','','','2024-04-22 08:51:28','2024-04-22 08:51:28');
INSERT INTO departments VALUES('78','MATERIAL HANDLING','7','','','','2024-04-22 08:51:45','2024-04-22 08:51:45');
INSERT INTO departments VALUES('79','MECHANICAL','7','','','','2024-04-22 08:51:56','2024-04-22 08:51:56');
INSERT INTO departments VALUES('80','PIPING','7','','','','2024-04-22 08:52:14','2024-04-22 08:52:14');
INSERT INTO departments VALUES('81','PMT','7','','','','2024-04-22 08:52:30','2024-04-22 08:52:30');
INSERT INTO departments VALUES('82','PPC','7','','','','2024-04-22 08:52:34','2024-04-22 08:52:34');
INSERT INTO departments VALUES('83','QAQC','2','','','','2024-04-22 08:52:39','2024-04-22 08:52:39');
INSERT INTO departments VALUES('84','RENTAL','7','','','','2024-04-22 08:52:56','2024-04-22 08:52:56');
INSERT INTO departments VALUES('85','RENTAL PT.YIP','7','','','','2024-04-22 08:53:05','2024-04-22 08:53:05');
INSERT INTO departments VALUES('86','RIGGING','7','','','','2024-04-22 08:53:23','2024-04-22 08:53:23');
INSERT INTO departments VALUES('87','SCAFFOLDING','7','','','','2024-04-22 08:53:38','2024-04-22 08:53:38');
INSERT INTO departments VALUES('88','SDCC','7','','','','2024-04-22 08:53:52','2024-04-22 08:53:52');
INSERT INTO departments VALUES('89','SRTUCTURE','7','','','','2024-04-22 08:54:10','2024-04-22 08:54:10');
INSERT INTO departments VALUES('90','WAREHOUSE','7','','','','2024-04-22 08:54:21','2024-04-22 08:54:21');
INSERT INTO departments VALUES('91','SURVEY','7','','','','2024-04-22 08:54:25','2024-04-22 08:54:25');
INSERT INTO departments VALUES('92','HRGA','7','','','','2024-04-22 09:08:59','2024-04-22 09:08:59');
INSERT INTO departments VALUES('93','QAQC','7','','','','2024-04-22 09:52:53','2024-04-22 09:52:53');
INSERT INTO departments VALUES('94','ENGINEER PIPING','2','','','','2024-04-22 14:42:53','2024-04-22 14:42:53');
INSERT INTO departments VALUES('95','IT','2','','','','2024-04-22 14:45:11','2024-04-22 14:45:11');
INSERT INTO departments VALUES('96','MATERIAL HANDLING & HEAVY EQUIPMENT','2','','','','2024-04-22 14:46:02','2024-04-22 14:46:02');
INSERT INTO departments VALUES('97','MATERIAL HANDLING PIPING','2','','','','2024-04-22 14:46:17','2024-04-22 14:46:17');
INSERT INTO departments VALUES('98','INSULATION','2','','','','2024-04-22 15:15:37','2024-04-22 15:15:37');
INSERT INTO departments VALUES('99','SURVEYOR','2','','','','2024-04-22 15:45:51','2024-04-22 15:45:51');
INSERT INTO departments VALUES('100','TUBING','2','','','','2024-04-22 15:47:09','2024-04-22 15:47:09');
INSERT INTO departments VALUES('101','ELECTRICAL','8','','','','2024-04-23 14:41:14','2024-04-23 14:41:14');
INSERT INTO departments VALUES('102','ENGINEERING','8','','','','2024-04-23 14:41:25','2024-04-23 14:41:25');
INSERT INTO departments VALUES('103','HRGA','8','','','','2024-04-23 14:41:44','2024-04-23 14:41:44');
INSERT INTO departments VALUES('104','HSSE','8','','','','2024-04-23 14:41:47','2024-04-23 14:41:47');
INSERT INTO departments VALUES('105','PIPING','8','','','','2024-04-23 14:41:57','2024-04-23 14:41:57');
INSERT INTO departments VALUES('106','PMT','8','','','','2024-04-23 14:42:05','2024-04-23 14:42:05');
INSERT INTO departments VALUES('107','PROCUREMENT','8','','','','2024-04-23 14:42:12','2024-04-23 14:42:12');
INSERT INTO departments VALUES('108','STRUCTURE','8','','','','2024-04-23 14:42:22','2024-04-23 14:42:22');
INSERT INTO departments VALUES('109','SURVEYOR','8','','','','2024-04-23 14:42:29','2024-04-23 14:42:29');
INSERT INTO departments VALUES('110','PMT','4','','','','2024-05-06 22:22:53','2024-05-06 22:22:53');
INSERT INTO departments VALUES('112','FAT','11','','','','2024-05-07 16:37:02','2024-05-07 16:37:02');
INSERT INTO departments VALUES('113','PMT','11','','','','2024-05-07 16:37:10','2024-05-07 16:37:10');
INSERT INTO departments VALUES('114','FAT','5','','','','2024-05-07 16:37:32','2024-05-07 16:37:32');
INSERT INTO departments VALUES('115','LEGAL & INSURANCE','5','','','','2024-05-07 16:37:44','2024-05-07 16:37:44');
INSERT INTO departments VALUES('116','PMT','5','','','','2024-05-07 16:37:55','2024-05-07 16:37:55');
INSERT INTO departments VALUES('117','HSSE','5','','','','2024-05-07 16:38:01','2024-05-07 16:38:01');
INSERT INTO departments VALUES('118','HR & GA','6','','','','2024-05-07 16:38:19','2024-05-07 16:38:19');
INSERT INTO departments VALUES('119','TSI','6','','','','2024-05-07 16:38:31','2024-05-07 16:38:31');
INSERT INTO departments VALUES('120','IT','6','','','','2024-05-07 16:38:36','2024-05-07 16:38:36');
INSERT INTO departments VALUES('121','LOGISTIC/ OPERATIONS','6','','','','2024-05-07 16:38:58','2024-05-07 16:38:58');
INSERT INTO departments VALUES('122','QA/QC','6','','','','2024-05-07 16:39:14','2024-05-07 16:39:14');
INSERT INTO departments VALUES('123','ENGINEERING','6','','','','2024-05-07 16:39:21','2024-05-07 16:39:21');
INSERT INTO departments VALUES('124','CONS&INST/OPERATIONS','6','','','','2024-05-07 16:39:46','2024-05-07 16:39:46');
INSERT INTO departments VALUES('125','PROJECT SERVICE','6','','','','2024-05-07 16:39:54','2024-05-07 16:39:54');
INSERT INTO departments VALUES('126','SUBCONTRACTOR','6','','','','2024-05-07 16:40:02','2024-05-07 16:40:02');
INSERT INTO departments VALUES('127','MARINE/OPERATIONS','6','','','','2024-05-07 16:40:17','2024-05-07 16:40:17');
INSERT INTO departments VALUES('128','PROPOSAL & TENDER','6','','','','2024-05-07 16:40:33','2024-05-07 16:40:33');
INSERT INTO departments VALUES('129','HSSE','6','','','','2024-05-07 16:40:38','2024-05-07 16:40:38');
INSERT INTO departments VALUES('130','PROCUREMENT','6','','','','2024-05-07 16:40:48','2024-05-07 17:05:19');
INSERT INTO departments VALUES('131','ENGINEERING','9','','','','2024-05-07 16:41:30','2024-05-07 16:41:30');
INSERT INTO departments VALUES('132','PROJECT SERVICE','9','','','','2024-05-07 16:41:39','2024-05-07 16:41:39');
INSERT INTO departments VALUES('133','QA/QC','9','','','','2024-05-07 16:41:47','2024-05-07 16:41:47');
INSERT INTO departments VALUES('134','PROCUREMENT','9','','','','2024-05-07 16:41:56','2024-05-07 16:41:56');
INSERT INTO departments VALUES('135','SUBCONTRACTOR','9','','','','2024-05-07 16:42:07','2024-05-07 16:42:07');
INSERT INTO departments VALUES('136','CONS&INST/OPERATIONS','9','','','','2024-05-07 16:42:28','2024-05-07 16:42:28');
INSERT INTO departments VALUES('137','FAT','9','','','','2024-05-07 16:42:32','2024-05-07 16:42:32');
INSERT INTO departments VALUES('138','LEGAL &amp; INSURANCE','9','','','','2024-05-07 16:42:41','2024-05-07 16:42:54');
INSERT INTO departments VALUES('139','HR & GA','9','','','','2024-05-07 16:43:05','2024-05-07 16:43:05');
INSERT INTO departments VALUES('141','PRECOM-COM/OPERATIONS','9','','','','2024-05-07 16:43:42','2024-05-07 16:43:42');
INSERT INTO departments VALUES('142','MANAGEMENT','9','','','','2024-05-07 16:43:50','2024-05-07 16:43:50');
INSERT INTO departments VALUES('143','HSSE','9','','','','2024-05-07 16:43:59','2024-05-07 16:43:59');
INSERT INTO departments VALUES('144','PMT','9','','','','2024-05-07 16:44:03','2024-05-07 16:44:03');
INSERT INTO departments VALUES('145','PROPOSAL & TENDER','9','','','','2024-05-07 16:44:17','2024-05-07 16:44:17');
INSERT INTO departments VALUES('146','LOGISTIC/OPERATIONS','9','','','','2024-05-07 16:44:37','2024-05-07 16:44:37');
INSERT INTO departments VALUES('147','FAT','6','','','','2024-05-07 16:56:28','2024-05-07 16:56:28');
INSERT INTO departments VALUES('148','LEGAL & INSURANCE','6','','','','2024-05-07 17:02:10','2024-05-07 17:02:10');
INSERT INTO departments VALUES('149','OPERATION','6','','','','2024-05-07 17:05:04','2024-05-07 17:05:04');
INSERT INTO departments VALUES('150','PMT','6','','','','2024-05-07 17:06:35','2024-05-07 17:06:35');
INSERT INTO departments VALUES('151','IT','9','','','','2024-05-07 17:37:19','2024-05-07 17:37:19');
INSERT INTO departments VALUES('152','OPERATION','9','','','','2024-05-07 17:48:16','2024-05-07 17:49:01');
INSERT INTO departments VALUES('153','MANAGEMENT','1','','','','2024-05-07 18:49:40','2024-05-07 18:49:40');



CREATE TABLE `designations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `designation_name` text NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `designations_company_id_foreign` (`company_id`),
  KEY `designations_department_id_foreign` (`department_id`),
  CONSTRAINT `designations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `designations_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=660 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO designations VALUES('1','HR & GA Officer','1','','','2024-02-05 15:51:46','2024-02-05 17:48:57');
INSERT INTO designations VALUES('2','FINANCE MANAGER','1','3','','2024-02-05 17:44:56','2024-02-05 17:44:56');
INSERT INTO designations VALUES('3','HR & GA Staff','1','21','','2024-02-05 17:45:07','2024-02-05 17:45:07');
INSERT INTO designations VALUES('4','PROCESS IMPROVEMENT STAFF','1','13','','2024-02-05 17:45:26','2024-02-05 17:45:26');
INSERT INTO designations VALUES('14','STAFF','3','35','','2024-02-20 20:55:35','2024-02-20 20:55:35');
INSERT INTO designations VALUES('15','STAFF','4','59','','2024-02-20 20:55:45','2024-02-20 20:55:45');
INSERT INTO designations VALUES('16','STAFF','4','58','','2024-02-20 20:55:54','2024-02-20 20:55:54');
INSERT INTO designations VALUES('17','STAFF','5','61','','2024-02-20 20:56:11','2024-02-20 20:56:11');
INSERT INTO designations VALUES('18','STAFF','5','60','','2024-02-20 20:56:24','2024-02-20 20:56:24');
INSERT INTO designations VALUES('19','STAFF','6','63','','2024-02-20 20:56:33','2024-02-20 20:56:33');
INSERT INTO designations VALUES('20','STAFF','6','62','','2024-02-20 20:56:51','2024-02-20 20:56:51');
INSERT INTO designations VALUES('21','STAFF','7','65','','2024-02-20 20:57:09','2024-02-20 20:57:09');
INSERT INTO designations VALUES('23','STAFF','8','67','','2024-02-20 20:57:27','2024-02-20 20:57:27');
INSERT INTO designations VALUES('24','STAFF','8','66','','2024-02-20 20:57:35','2024-02-20 20:57:35');
INSERT INTO designations VALUES('29','ESTIMATOR','1','15','','2024-02-27 09:13:47','2024-02-27 09:13:47');
INSERT INTO designations VALUES('31','STAFF','1','9','','2024-02-27 09:15:58','2024-02-27 09:15:58');
INSERT INTO designations VALUES('32','PROGAMMER','1','7','','2024-02-27 09:16:10','2024-02-27 09:16:10');
INSERT INTO designations VALUES('33','HSSE ADVISOR','1','20','','2024-02-27 09:16:22','2024-02-27 09:16:22');
INSERT INTO designations VALUES('34','HEAD FAB.ENGINEERING','3','68','','2024-04-16 15:54:03','2024-04-16 15:54:03');
INSERT INTO designations VALUES('35','DRAFTER / ENGINEERING ADMIN','3','68','','2024-04-16 15:54:39','2024-04-16 15:54:39');
INSERT INTO designations VALUES('36','HEAD OF FABRICATION SHOP','3','69','','2024-04-16 15:55:29','2024-04-16 15:55:29');
INSERT INTO designations VALUES('37','CASHIER','3','30','','2024-04-16 15:55:57','2024-04-16 15:55:57');
INSERT INTO designations VALUES('38','HEAD HR &amp; GA','3','29','','2024-04-16 15:56:22','2024-04-16 15:56:22');
INSERT INTO designations VALUES('39','GA STAFF','3','29','','2024-04-16 15:56:32','2024-04-16 15:56:32');
INSERT INTO designations VALUES('40','HR STAFF','3','29','','2024-04-16 15:56:41','2024-04-16 15:56:41');
INSERT INTO designations VALUES('41','DRIVER','3','29','','2024-04-16 15:56:56','2024-04-16 15:56:56');
INSERT INTO designations VALUES('42','GENERAL SUPPORT','3','29','','2024-04-16 15:57:11','2024-04-16 15:57:11');
INSERT INTO designations VALUES('43','RESEPSIONIST','3','29','','2024-04-16 15:57:23','2024-04-16 15:57:23');
INSERT INTO designations VALUES('44','CLEANING SERVICE','3','29','','2024-04-16 15:57:39','2024-04-16 15:57:39');
INSERT INTO designations VALUES('45','MAINTENANCE BUILDING','3','29','','2024-04-16 15:58:07','2024-04-16 15:58:07');
INSERT INTO designations VALUES('46','OFFICE BOY','3','29','','2024-04-16 15:58:22','2024-04-16 15:58:22');
INSERT INTO designations VALUES('47','HEAD HSSE','3','34','','2024-04-16 15:59:36','2024-04-16 15:59:36');
INSERT INTO designations VALUES('48','HSSE ADVISOR/ OFFICER','3','34','','2024-04-16 15:59:54','2024-04-16 15:59:54');
INSERT INTO designations VALUES('49','DANRU SECURITY','3','34','','2024-04-16 16:00:07','2024-04-16 16:00:07');
INSERT INTO designations VALUES('50','SECURITY','3','34','','2024-04-16 16:00:17','2024-04-16 16:00:17');
INSERT INTO designations VALUES('51','HEAD LOGISTIC','3','36','','2024-04-16 16:00:33','2024-04-16 16:00:33');
INSERT INTO designations VALUES('52','PACKING &amp; SHIPMENT','3','36','','2024-04-16 16:00:48','2024-04-16 16:00:48');
INSERT INTO designations VALUES('53','PACKER','3','36','','2024-04-16 16:00:58','2024-04-16 16:00:58');
INSERT INTO designations VALUES('54','STOREMAN','3','36','','2024-04-16 16:01:07','2024-04-16 16:01:07');
INSERT INTO designations VALUES('55','ADMIN','3','36','','2024-04-16 16:01:12','2024-04-16 16:01:12');
INSERT INTO designations VALUES('56','LEADER MAINTENANCE','3','36','','2024-04-16 16:01:32','2024-04-16 16:01:32');
INSERT INTO designations VALUES('57','TEKNISI','3','36','','2024-04-16 16:01:43','2024-04-16 16:02:02');
INSERT INTO designations VALUES('58','OPR.FORKLIFT','3','36','','2024-04-16 16:02:21','2024-04-16 16:02:21');
INSERT INTO designations VALUES('59','HELPER','3','36','','2024-04-16 16:02:32','2024-04-16 16:02:32');
INSERT INTO designations VALUES('60','HEAD PPC','3','32','','2024-04-16 16:02:59','2024-04-16 16:02:59');
INSERT INTO designations VALUES('61','PROJECT CONTROL','3','32','','2024-04-16 16:03:21','2024-04-16 16:03:21');
INSERT INTO designations VALUES('62','MATERIAL CONTROL','3','32','','2024-04-16 16:03:30','2024-04-16 16:03:30');
INSERT INTO designations VALUES('63','PROJECT CONTROL JUNIOR','3','32','','2024-04-16 16:03:47','2024-04-16 16:03:47');
INSERT INTO designations VALUES('64','HEAD PRODUCTION','3','35','','2024-04-16 16:04:04','2024-04-16 16:04:04');
INSERT INTO designations VALUES('66','ADMIN','3','35','','2024-04-16 16:06:31','2024-04-16 16:06:31');
INSERT INTO designations VALUES('67','FOREMAN WELDER','3','35','','2024-04-16 16:08:05','2024-04-16 16:08:05');
INSERT INTO designations VALUES('68','WELDER GTAW-SMAW','3','35','','2024-04-16 16:08:23','2024-04-16 16:08:23');
INSERT INTO designations VALUES('69','WELDER SMAW','3','35','','2024-04-16 16:08:34','2024-04-16 16:08:34');
INSERT INTO designations VALUES('70','WELDER GTAW-SMAW-SAW','3','35','','2024-04-16 16:08:53','2024-04-16 16:08:53');
INSERT INTO designations VALUES('71','HELPER','3','35','','2024-04-16 16:09:03','2024-04-16 16:09:03');
INSERT INTO designations VALUES('72','FOREMAN MACHINING','3','35','','2024-04-16 16:09:16','2024-04-16 16:09:16');
INSERT INTO designations VALUES('73','OPR. MARKING CUTTING','3','35','','2024-04-16 16:09:38','2024-04-16 16:09:38');
INSERT INTO designations VALUES('74','OPR. MARKING CUTTING (CNC)','3','35','','2024-04-16 16:09:47','2024-04-16 16:09:47');
INSERT INTO designations VALUES('75','OPR.ROLLING','3','35','','2024-04-16 16:09:58','2024-04-16 16:09:58');
INSERT INTO designations VALUES('76','OPR.DRILLING','3','35','','2024-04-16 16:13:59','2024-04-16 16:13:59');
INSERT INTO designations VALUES('77','OPR.MACHINING','3','35','','2024-04-16 16:14:14','2024-04-16 16:14:14');
INSERT INTO designations VALUES('78','OPR.MACHINING &amp; DRILLING','3','35','','2024-04-16 16:14:48','2024-04-16 16:14:48');
INSERT INTO designations VALUES('79','FITTER I','3','35','','2024-04-16 16:16:28','2024-04-16 16:16:28');
INSERT INTO designations VALUES('80','FOREMAN FITTER','3','35','','2024-04-16 16:16:40','2024-04-16 16:16:40');
INSERT INTO designations VALUES('81','FITTER II','3','35','','2024-04-16 16:16:55','2024-04-16 16:16:55');
INSERT INTO designations VALUES('82','FOREMAN FINISHING','3','35','','2024-04-16 16:17:15','2024-04-16 16:17:15');
INSERT INTO designations VALUES('83','OPR.HYDROTEST','3','35','','2024-04-16 16:17:32','2024-04-16 16:17:32');
INSERT INTO designations VALUES('84','OPR.EXPAND','3','35','','2024-04-16 16:17:45','2024-04-16 16:17:45');
INSERT INTO designations VALUES('85','FOREMAN LIFTING','3','35','','2024-04-16 16:17:58','2024-04-16 16:17:58');
INSERT INTO designations VALUES('86','RIGGER &amp; SCAFFOLDER','3','35','','2024-04-16 16:18:15','2024-04-16 16:18:15');
INSERT INTO designations VALUES('87','OPR.OVERHEAD CRANE','3','35','','2024-04-16 16:18:29','2024-04-16 16:18:29');
INSERT INTO designations VALUES('88','RIGGER','3','35','','2024-04-16 16:18:37','2024-04-16 16:18:37');
INSERT INTO designations VALUES('89','SCAFFOLDER','3','35','','2024-04-16 16:18:44','2024-04-16 16:18:44');
INSERT INTO designations VALUES('90','INSPECTOR SCAFFOLDER','3','35','','2024-04-16 16:19:01','2024-04-16 16:19:01');
INSERT INTO designations VALUES('91','FOREMAN PAINTING','3','35','','2024-04-16 16:19:11','2024-04-16 16:19:11');
INSERT INTO designations VALUES('92','PAINTER','3','35','','2024-04-16 16:19:19','2024-04-16 16:19:19');
INSERT INTO designations VALUES('93','BLASTER','3','35','','2024-04-16 16:19:26','2024-04-16 16:19:26');
INSERT INTO designations VALUES('94','PICKLING','3','32','','2024-04-16 16:19:41','2024-04-16 16:19:41');
INSERT INTO designations VALUES('95','HEAD QA &amp; QC','3','31','','2024-04-16 16:20:14','2024-04-16 16:20:14');
INSERT INTO designations VALUES('96','QC INSPECTION COORDINATOR','3','35','','2024-04-16 16:20:27','2024-04-16 16:20:27');
INSERT INTO designations VALUES('97','QC MATERIAL RECEIVING','3','31','','2024-04-16 16:20:50','2024-04-16 16:20:50');
INSERT INTO designations VALUES('98','QA ENGINEER','3','31','','2024-04-16 16:20:59','2024-04-16 16:20:59');
INSERT INTO designations VALUES('99','WELDING INSPECTOR &amp; NDT','3','31','','2024-04-16 16:21:17','2024-04-16 16:21:17');
INSERT INTO designations VALUES('100','DIMENSIONAL','3','31','','2024-04-16 16:21:27','2024-04-16 16:21:27');
INSERT INTO designations VALUES('101','PAINTING INSPECTOR','3','31','','2024-04-16 16:21:38','2024-04-16 16:21:38');
INSERT INTO designations VALUES('102','QUALITY ASSURANCE','3','31','','2024-04-16 16:22:25','2024-04-16 16:22:25');
INSERT INTO designations VALUES('103','WELDING INSPECTOR','3','31','','2024-04-16 16:22:35','2024-04-16 16:22:35');
INSERT INTO designations VALUES('104','OPR.FORKLIFT','3','70','','2024-04-16 16:23:23','2024-04-16 16:23:23');
INSERT INTO designations VALUES('105','ADMIN','7','71','','2024-04-22 08:54:53','2024-04-22 08:54:53');
INSERT INTO designations VALUES('106','SUPERVISOR ELEKTRIK','7','72','','2024-04-22 08:55:19','2024-04-22 08:55:19');
INSERT INTO designations VALUES('107','FOREMAN ELECTRIK','7','72','','2024-04-22 08:55:29','2024-04-22 08:55:29');
INSERT INTO designations VALUES('108','HELPER','7','72','','2024-04-22 08:55:37','2024-04-22 08:55:37');
INSERT INTO designations VALUES('109','ELECTRIC 1','7','72','','2024-04-22 08:55:50','2024-04-22 08:55:50');
INSERT INTO designations VALUES('110','SENIOR DRAFTER','7','73','','2024-04-22 08:56:11','2024-04-22 08:56:11');
INSERT INTO designations VALUES('111','LIFTING ENGINEER','7','73','','2024-04-22 08:56:50','2024-04-22 08:56:50');
INSERT INTO designations VALUES('112','ENGINEER','7','73','','2024-04-22 08:57:02','2024-04-22 08:57:02');
INSERT INTO designations VALUES('113','CHIEF ENGINEER','7','73','','2024-04-22 08:57:11','2024-04-22 08:57:11');
INSERT INTO designations VALUES('114','DRAFTER','7','73','','2024-04-22 08:57:29','2024-04-22 08:57:29');
INSERT INTO designations VALUES('115','ADMIN','7','73','','2024-04-22 08:57:36','2024-04-22 08:57:36');
INSERT INTO designations VALUES('116','LEAD ENGINEER','7','73','','2024-04-22 08:59:48','2024-04-22 08:59:48');
INSERT INTO designations VALUES('117','FINANCE','7','65','','2024-04-22 09:00:08','2024-04-22 09:00:08');
INSERT INTO designations VALUES('118','OPERATOR FOCO','7','74','','2024-04-22 09:00:24','2024-04-22 09:00:24');
INSERT INTO designations VALUES('119','DRIVER TL','7','74','','2024-04-22 09:00:36','2024-04-22 09:00:36');
INSERT INTO designations VALUES('120','HELPER','7','74','','2024-04-22 09:00:49','2024-04-22 09:00:49');
INSERT INTO designations VALUES('121','HRGA COORDINATOR','7','','','2024-04-22 09:02:15','2024-04-22 09:02:15');
INSERT INTO designations VALUES('122','DRIVER','7','','','2024-04-22 09:02:26','2024-04-22 09:02:26');
INSERT INTO designations VALUES('123','HRGA','7','','','2024-04-22 09:02:51','2024-04-22 09:02:51');
INSERT INTO designations VALUES('124','IT','7','','','2024-04-22 09:02:58','2024-04-22 09:02:58');
INSERT INTO designations VALUES('125','GA','7','','','2024-04-22 09:03:07','2024-04-22 09:03:07');
INSERT INTO designations VALUES('126','HELPER','7','','','2024-04-22 09:03:16','2024-04-22 09:03:16');
INSERT INTO designations VALUES('127','AST PAYROL','7','','','2024-04-22 09:03:34','2024-04-22 09:03:34');
INSERT INTO designations VALUES('128','MECHANIC','7','','','2024-04-22 09:04:16','2024-04-22 09:04:16');
INSERT INTO designations VALUES('129','SKILL 2','7','','','2024-04-22 09:04:28','2024-04-22 09:04:28');
INSERT INTO designations VALUES('130','BENNEFIT','7','','','2024-04-22 09:04:42','2024-04-22 09:04:42');
INSERT INTO designations VALUES('131','OFFICE BOY','7','','','2024-04-22 09:04:52','2024-04-22 09:04:52');
INSERT INTO designations VALUES('132','HSSE COORDINATOR','7','76','','2024-04-22 09:05:19','2024-04-22 09:05:19');
INSERT INTO designations VALUES('133','SECURITY','7','76','','2024-04-22 09:05:32','2024-04-22 09:05:32');
INSERT INTO designations VALUES('134','HSSE OFFICER','7','76','','2024-04-22 09:05:50','2024-04-22 09:05:50');
INSERT INTO designations VALUES('135','ADMIN','7','76','','2024-04-22 09:05:59','2024-04-22 09:05:59');
INSERT INTO designations VALUES('136','HELPER','7','76','','2024-04-22 09:06:09','2024-04-22 09:06:09');
INSERT INTO designations VALUES('137','SAFETYMAN','7','76','','2024-04-22 09:06:21','2024-04-22 09:06:21');
INSERT INTO designations VALUES('138','HRGA COORDINATOR','7','92','','2024-04-22 09:09:25','2024-04-22 09:09:25');
INSERT INTO designations VALUES('139','DRIVER','7','92','','2024-04-22 09:09:36','2024-04-22 09:09:36');
INSERT INTO designations VALUES('140','HRGA','7','92','','2024-04-22 09:09:43','2024-04-22 09:09:43');
INSERT INTO designations VALUES('141','IT','7','92','','2024-04-22 09:09:51','2024-04-22 09:09:51');
INSERT INTO designations VALUES('142','GA','7','92','','2024-04-22 09:09:58','2024-04-22 09:09:58');
INSERT INTO designations VALUES('143','AST PAYROL','7','92','','2024-04-22 09:10:11','2024-04-22 09:11:30');
INSERT INTO designations VALUES('144','MECHANIC','7','92','','2024-04-22 09:11:46','2024-04-22 09:11:46');
INSERT INTO designations VALUES('145','SKILL 2','7','92','','2024-04-22 09:11:57','2024-04-22 09:11:57');
INSERT INTO designations VALUES('146','BENEFIT','7','92','','2024-04-22 09:12:07','2024-04-22 09:32:21');
INSERT INTO designations VALUES('147','OFFICE BOY','7','92','','2024-04-22 09:12:22','2024-04-22 09:12:22');
INSERT INTO designations VALUES('148','ELECTRICAL INSTRUMENT','7','77','','2024-04-22 09:16:29','2024-04-22 09:16:29');
INSERT INTO designations VALUES('149','ENGINEER ELECTRICAL','7','77','','2024-04-22 09:16:42','2024-04-22 09:16:42');
INSERT INTO designations VALUES('150','ENGINEER','7','77','','2024-04-22 09:16:51','2024-04-22 09:16:51');
INSERT INTO designations VALUES('151','SUPERVISOR ELECTRICAL','7','77','','2024-04-22 09:17:02','2024-04-22 09:17:02');
INSERT INTO designations VALUES('152','FITTER 1','7','77','','2024-04-22 09:17:16','2024-04-22 09:17:16');
INSERT INTO designations VALUES('153','WELDER','7','77','','2024-04-22 09:17:26','2024-04-22 09:17:26');
INSERT INTO designations VALUES('154','FOREMAN','7','77','','2024-04-22 09:17:41','2024-04-22 09:17:41');
INSERT INTO designations VALUES('155','ADMIN','7','77','','2024-04-22 09:17:48','2024-04-22 09:17:48');
INSERT INTO designations VALUES('156','SUPERVISOR','7','77','','2024-04-22 09:18:00','2024-04-22 09:18:00');
INSERT INTO designations VALUES('157','SITE MANAGER','7','77','','2024-04-22 09:18:11','2024-04-22 09:18:11');
INSERT INTO designations VALUES('158','PPC','7','77','','2024-04-22 09:18:18','2024-04-22 09:18:18');
INSERT INTO designations VALUES('159','HELPER','7','77','','2024-04-22 09:18:29','2024-04-22 09:18:29');
INSERT INTO designations VALUES('160','QA / QC INSPECTOR','7','77','','2024-04-22 09:21:39','2024-04-22 09:21:39');
INSERT INTO designations VALUES('161','MATERIAL CONTROL','7','77','','2024-04-22 09:21:56','2024-04-22 09:21:56');
INSERT INTO designations VALUES('162','TEKNISI','7','77','','2024-04-22 09:22:09','2024-04-22 09:22:09');
INSERT INTO designations VALUES('163','WELDER SMAW','7','77','','2024-04-22 09:22:33','2024-04-22 09:22:33');
INSERT INTO designations VALUES('164','TEKNISI 2','7','77','','2024-04-22 09:22:44','2024-04-22 09:22:44');
INSERT INTO designations VALUES('165','LEAD QC','7','77','','2024-04-22 09:22:54','2024-04-22 09:23:04');
INSERT INTO designations VALUES('166','PROJECT CONTROL','7','77','','2024-04-22 09:23:19','2024-04-22 09:23:19');
INSERT INTO designations VALUES('167','SUPERINTENDENT','7','77','','2024-04-22 09:23:33','2024-04-22 09:23:33');
INSERT INTO designations VALUES('168','WELDER GTAW','7','77','','2024-04-22 09:23:42','2024-04-22 09:23:42');
INSERT INTO designations VALUES('169','SUPERVISOR MH','7','78','','2024-04-22 09:24:01','2024-04-22 09:24:01');
INSERT INTO designations VALUES('170','MATERIAL HANDLING 1','7','78','','2024-04-22 09:24:11','2024-04-22 09:24:11');
INSERT INTO designations VALUES('171','FOREMAN','7','78','','2024-04-22 09:24:30','2024-04-22 09:24:30');
INSERT INTO designations VALUES('172','HELPER','7','78','','2024-04-22 09:24:41','2024-04-22 09:24:41');
INSERT INTO designations VALUES('173','MATERIAL HANDLING 2','7','78','','2024-04-22 09:24:52','2024-04-22 09:24:52');
INSERT INTO designations VALUES('174','FITTER','7','79','','2024-04-22 09:25:22','2024-04-22 09:25:22');
INSERT INTO designations VALUES('175','WELDER','7','79','','2024-04-22 09:28:28','2024-04-22 09:28:28');
INSERT INTO designations VALUES('176','WELDER SMAW','7','79','','2024-04-22 09:28:37','2024-04-22 09:28:37');
INSERT INTO designations VALUES('177','FITTER 1','7','79','','2024-04-22 09:28:46','2024-04-22 09:28:46');
INSERT INTO designations VALUES('178','FOREMAN','7','79','','2024-04-22 09:28:58','2024-04-22 09:28:58');
INSERT INTO designations VALUES('179','SUPERVISOR','7','79','','2024-04-22 09:29:09','2024-04-22 09:29:09');
INSERT INTO designations VALUES('180','JR ENGINEER','7','79','','2024-04-22 09:29:22','2024-04-22 09:29:22');
INSERT INTO designations VALUES('181','MECHANICAL SPV','7','79','','2024-04-22 09:29:34','2024-04-22 09:29:34');
INSERT INTO designations VALUES('182','SUPERVISOR MECHANICAL','7','79','','2024-04-22 09:29:58','2024-04-22 09:29:58');
INSERT INTO designations VALUES('183','ENGINEER','7','79','','2024-04-22 09:30:07','2024-04-22 09:30:07');
INSERT INTO designations VALUES('184','HELPER','7','79','','2024-04-22 09:30:18','2024-04-22 09:30:18');
INSERT INTO designations VALUES('185','MILLWRIGHT 1','7','79','','2024-04-22 09:30:28','2024-04-22 09:30:51');
INSERT INTO designations VALUES('186','MILLWRIGTH 2','7','79','','2024-04-22 09:31:35','2024-04-22 09:31:35');
INSERT INTO designations VALUES('187','BENEFIT','7','79','','2024-04-22 09:31:44','2024-04-22 09:31:44');
INSERT INTO designations VALUES('188','MECHANICAL SUPERVISOR','7','80','','2024-04-22 09:32:50','2024-04-22 09:32:50');
INSERT INTO designations VALUES('189','FITTER 1','7','80','','2024-04-22 09:32:59','2024-04-22 09:32:59');
INSERT INTO designations VALUES('190','FITTER 2','7','80','','2024-04-22 09:33:09','2024-04-22 09:33:09');
INSERT INTO designations VALUES('191','FOREMAN','7','80','','2024-04-22 09:33:22','2024-04-22 09:33:22');
INSERT INTO designations VALUES('192','SUPERVISOR','7','80','','2024-04-22 09:33:30','2024-04-22 09:33:30');
INSERT INTO designations VALUES('193','PAINTER 1','7','80','','2024-04-22 09:47:42','2024-04-22 09:47:42');
INSERT INTO designations VALUES('194','WELDER GTAW','7','80','','2024-04-22 09:48:38','2024-04-22 09:48:38');
INSERT INTO designations VALUES('195','ADMIN','7','80','','2024-04-22 09:48:46','2024-04-22 09:48:46');
INSERT INTO designations VALUES('196','SUPERVISOR WELDER','7','80','','2024-04-22 09:48:56','2024-04-22 09:48:56');
INSERT INTO designations VALUES('197','WELDER','7','80','','2024-04-22 09:49:24','2024-04-22 09:49:24');
INSERT INTO designations VALUES('198','HELPER','7','80','','2024-04-22 09:49:32','2024-04-22 09:49:32');
INSERT INTO designations VALUES('199','ENGINEER','7','80','','2024-04-22 09:50:00','2024-04-22 09:50:00');
INSERT INTO designations VALUES('200','WELDER SMAW','7','80','','2024-04-22 09:50:17','2024-04-22 09:50:17');
INSERT INTO designations VALUES('201','TEKNISI 1','7','80','','2024-04-22 09:50:25','2024-04-22 09:50:25');
INSERT INTO designations VALUES('202','PROJECT MANAGER','7','81','','2024-04-22 09:51:03','2024-04-22 09:51:03');
INSERT INTO designations VALUES('203','CONSTRUCTION MANAGER','7','81','','2024-04-22 09:51:16','2024-04-22 09:51:16');
INSERT INTO designations VALUES('204','SITE MANAGER','7','81','','2024-04-22 09:51:25','2024-04-22 09:51:25');
INSERT INTO designations VALUES('205','PPC MANAGER','7','82','','2024-04-22 09:51:41','2024-04-22 09:51:41');
INSERT INTO designations VALUES('206','SCHEDULER','7','82','','2024-04-22 09:51:53','2024-04-22 09:51:53');
INSERT INTO designations VALUES('207','PPC','7','82','','2024-04-22 09:52:00','2024-04-22 09:52:00');
INSERT INTO designations VALUES('208','ADMIN','7','82','','2024-04-22 09:52:09','2024-04-22 09:52:09');
INSERT INTO designations VALUES('209','EXPEDITER','7','82','','2024-04-22 09:52:19','2024-04-22 09:52:19');
INSERT INTO designations VALUES('210','QAQC COORDINATOR','7','93','','2024-04-22 09:53:27','2024-04-22 09:53:27');
INSERT INTO designations VALUES('211','QA/QC INSPECTOR','7','93','','2024-04-22 09:53:42','2024-04-22 09:53:42');
INSERT INTO designations VALUES('212','ADMIN','7','93','','2024-04-22 09:53:51','2024-04-22 09:53:51');
INSERT INTO designations VALUES('213','NDT','7','93','','2024-04-22 09:54:00','2024-04-22 09:54:00');
INSERT INTO designations VALUES('214','NDT JUNIOR','7','93','','2024-04-22 09:54:13','2024-04-22 09:54:13');
INSERT INTO designations VALUES('215','HELPER','7','93','','2024-04-22 09:54:27','2024-04-22 09:54:27');
INSERT INTO designations VALUES('216','HELPER','7','84','','2024-04-22 09:54:46','2024-04-22 09:54:46');
INSERT INTO designations VALUES('217','OPR.CRANE','7','85','','2024-04-22 09:55:02','2024-04-22 09:55:02');
INSERT INTO designations VALUES('218','HELPER','7','85','','2024-04-22 09:55:11','2024-04-22 09:55:11');
INSERT INTO designations VALUES('219','RIGGER 2','7','86','','2024-04-22 09:55:27','2024-04-22 09:55:27');
INSERT INTO designations VALUES('220','RIGGER 1','7','86','','2024-04-22 09:55:34','2024-04-22 09:55:34');
INSERT INTO designations VALUES('221','FOREMAN RIGGER','7','86','','2024-04-22 09:55:57','2024-04-22 09:55:57');
INSERT INTO designations VALUES('222','FOREMAN','7','86','','2024-04-22 09:56:06','2024-04-22 09:56:06');
INSERT INTO designations VALUES('223','SUPERVISOR RIGGER','7','86','','2024-04-22 10:17:39','2024-04-22 10:17:39');
INSERT INTO designations VALUES('224','OPERATOR FOCO','7','86','','2024-04-22 10:18:03','2024-04-22 10:18:03');
INSERT INTO designations VALUES('225','OPERATOR OHC','7','86','','2024-04-22 10:18:31','2024-04-22 10:18:31');
INSERT INTO designations VALUES('226','HE COORDINATOR','7','86','','2024-04-22 10:18:46','2024-04-22 10:18:46');
INSERT INTO designations VALUES('227','HELPER','7','86','','2024-04-22 10:19:05','2024-04-22 10:19:05');
INSERT INTO designations VALUES('228','OPERATOR CRANE','7','86','','2024-04-22 10:19:18','2024-04-22 10:19:18');
INSERT INTO designations VALUES('229','SCAFFOLDER 1','7','87','','2024-04-22 10:19:36','2024-04-22 10:20:14');
INSERT INTO designations VALUES('230','SCAFOLLDER 2','7','87','','2024-04-22 10:19:52','2024-04-22 10:19:52');
INSERT INTO designations VALUES('231','SUPERVISOR SCAFFOLDER','7','87','','2024-04-22 10:20:49','2024-04-22 10:21:26');
INSERT INTO designations VALUES('232','FOREMAN SCAFFOLDING','7','87','','2024-04-22 10:21:52','2024-04-22 10:21:52');
INSERT INTO designations VALUES('233','FOREMAN','7','87','','2024-04-22 10:22:03','2024-04-22 10:22:03');
INSERT INTO designations VALUES('234','SUPERVISOR','7','87','','2024-04-22 10:22:16','2024-04-22 10:22:27');
INSERT INTO designations VALUES('235','HELPER','7','87','','2024-04-22 10:22:41','2024-04-22 10:22:41');
INSERT INTO designations VALUES('236','INSPECTOR SCAFFOLDING','7','87','','2024-04-22 10:23:00','2024-04-22 10:23:00');
INSERT INTO designations VALUES('237','SDCC','7','88','','2024-04-22 10:23:16','2024-04-22 10:23:16');
INSERT INTO designations VALUES('238','FOREMAN','7','89','','2024-04-22 10:23:39','2024-04-22 10:23:39');
INSERT INTO designations VALUES('239','FITTER 1','7','89','','2024-04-22 10:23:54','2024-04-22 10:23:54');
INSERT INTO designations VALUES('240','FITTER','7','89','','2024-04-22 10:24:01','2024-04-22 10:24:01');
INSERT INTO designations VALUES('241','FOREMAN SURVEYOR','7','91','','2024-04-22 10:24:14','2024-04-22 10:24:14');
INSERT INTO designations VALUES('242','SURVEYOR SUPERVISOR','7','91','','2024-04-22 10:24:31','2024-04-22 10:24:31');
INSERT INTO designations VALUES('243','SURVEYOR 1','7','91','','2024-04-22 10:24:41','2024-04-22 10:25:17');
INSERT INTO designations VALUES('244','SURVEYOR 2','7','91','','2024-04-22 10:24:57','2024-04-22 10:24:57');
INSERT INTO designations VALUES('245','HELPER','7','91','','2024-04-22 10:25:31','2024-04-22 10:25:31');
INSERT INTO designations VALUES('246','ADMIN','7','90','','2024-04-22 10:25:44','2024-04-22 10:25:44');
INSERT INTO designations VALUES('247','WAREHOUSE SUPERVISOR','7','90','','2024-04-22 10:26:01','2024-04-22 10:26:01');
INSERT INTO designations VALUES('248','FOREMAN WH','7','90','','2024-04-22 10:26:16','2024-04-22 10:26:16');
INSERT INTO designations VALUES('249','WAREHOUSE 1','7','90','','2024-04-22 10:26:25','2024-04-22 10:26:25');
INSERT INTO designations VALUES('250','HELPER','7','90','','2024-04-22 10:26:32','2024-04-22 10:26:32');
INSERT INTO designations VALUES('251','WAREHOUSE 2','7','90','','2024-04-22 10:26:46','2024-04-22 10:26:46');
INSERT INTO designations VALUES('252','FOREMAN','7','90','','2024-04-22 10:26:55','2024-04-22 10:26:55');
INSERT INTO designations VALUES('253','LEAD WAREHOUSE','7','90','','2024-04-22 10:27:06','2024-04-22 10:27:06');
INSERT INTO designations VALUES('254','SUPERVISOR ELEKTRIK','2','38','','2024-04-22 14:52:01','2024-04-22 14:52:01');
INSERT INTO designations VALUES('255','ELECTRIC 2','2','38','','2024-04-22 14:52:12','2024-04-22 14:52:12');
INSERT INTO designations VALUES('256','LEAD HEAD','2','38','','2024-04-22 14:52:22','2024-04-22 14:52:22');
INSERT INTO designations VALUES('257','FOREMAN','2','38','','2024-04-22 14:52:32','2024-04-22 14:52:32');
INSERT INTO designations VALUES('258','ELECTRIC 1','2','38','','2024-04-22 14:52:42','2024-04-22 14:52:42');
INSERT INTO designations VALUES('259','HELPER','2','38','','2024-04-22 14:52:56','2024-04-22 14:52:56');
INSERT INTO designations VALUES('260','JR. ENGINEER','2','25','','2024-04-22 14:53:17','2024-04-22 14:53:17');
INSERT INTO designations VALUES('261','CHIP ENGINEER','2','25','','2024-04-22 14:53:26','2024-04-22 14:53:26');
INSERT INTO designations VALUES('262','DRAFTER','2','25','','2024-04-22 14:53:34','2024-04-22 14:53:34');
INSERT INTO designations VALUES('263','ENGINEER','2','38','','2024-04-22 14:53:51','2024-04-22 14:53:51');
INSERT INTO designations VALUES('264','PIPING ENGINEER','2','25','','2024-04-22 14:54:05','2024-04-22 14:54:05');
INSERT INTO designations VALUES('265','RIGGING ENGINEER','2','25','','2024-04-22 14:54:19','2024-04-22 14:54:19');
INSERT INTO designations VALUES('266','JR. ENGINEER','2','94','','2024-04-22 14:54:57','2024-04-22 14:54:57');
INSERT INTO designations VALUES('267','DRAFTER','2','94','','2024-04-22 14:55:08','2024-04-22 14:55:08');
INSERT INTO designations VALUES('268','DRIVER','2','17','','2024-04-22 14:55:23','2024-04-22 14:55:23');
INSERT INTO designations VALUES('269','PERSONALIA','2','17','','2024-04-22 14:55:32','2024-04-22 14:55:32');
INSERT INTO designations VALUES('270','BENEFIT','2','17','','2024-04-22 14:56:36','2024-04-22 14:56:36');
INSERT INTO designations VALUES('271','OFFICE BOY','2','17','','2024-04-22 14:56:43','2024-04-22 14:56:43');
INSERT INTO designations VALUES('272','SKILL 1','2','17','','2024-04-22 14:56:53','2024-04-22 14:56:53');
INSERT INTO designations VALUES('273','SKILL 2','2','17','','2024-04-22 14:57:04','2024-04-22 14:57:04');
INSERT INTO designations VALUES('274','HELPER','2','17','','2024-04-22 14:57:12','2024-04-22 14:57:12');
INSERT INTO designations VALUES('275','HR&amp;GA COORDINATOR','2','17','','2024-04-22 14:57:25','2024-04-22 14:57:25');
INSERT INTO designations VALUES('276','STAFF OFFICE BADGING','2','17','','2024-04-22 15:08:44','2024-04-22 15:08:44');
INSERT INTO designations VALUES('277','TRANSPORT COORD','2','17','','2024-04-22 15:08:57','2024-04-22 15:08:57');
INSERT INTO designations VALUES('278','STAFF GA','2','17','','2024-04-22 15:09:06','2024-04-22 15:09:06');
INSERT INTO designations VALUES('279','FOREMAN TRANSPORT','2','17','','2024-04-22 15:09:28','2024-04-22 15:09:28');
INSERT INTO designations VALUES('280','ADMIN NEW HIRE &amp; TRANSPORT','2','17','','2024-04-22 15:09:41','2024-04-22 15:09:41');
INSERT INTO designations VALUES('281','PAYROLL STAFF','2','17','','2024-04-22 15:09:57','2024-04-22 15:09:57');
INSERT INTO designations VALUES('282','HE &amp; TRANSPORT STAFF','2','17','','2024-04-22 15:10:59','2024-04-22 15:10:59');
INSERT INTO designations VALUES('283','SECURITY','2','40','','2024-04-22 15:11:14','2024-04-22 15:11:14');
INSERT INTO designations VALUES('284','HELPER','2','40','','2024-04-22 15:11:20','2024-04-22 15:11:20');
INSERT INTO designations VALUES('285','HSSE OFFICER','2','40','','2024-04-22 15:11:33','2024-04-22 15:11:33');
INSERT INTO designations VALUES('286','SAFETYMAN','2','40','','2024-04-22 15:11:41','2024-04-22 15:11:41');
INSERT INTO designations VALUES('287','HSSE COORDINATOR','2','40','','2024-04-22 15:11:53','2024-04-22 15:11:53');
INSERT INTO designations VALUES('288','HSSE INSPECTOR','2','40','','2024-04-22 15:12:05','2024-04-22 15:12:05');
INSERT INTO designations VALUES('289','LEAD COMANDER','2','40','','2024-04-22 15:12:17','2024-04-22 15:12:17');
INSERT INTO designations VALUES('290','HSSE MANAGER','2','40','','2024-04-22 15:12:30','2024-04-22 15:12:30');
INSERT INTO designations VALUES('291','ADMIN','2','40','','2024-04-22 15:13:09','2024-04-22 15:13:09');
INSERT INTO designations VALUES('292','SECURITY OFFICER','2','40','','2024-04-22 15:13:40','2024-04-22 15:13:40');
INSERT INTO designations VALUES('293','SAFETY OFFICER','2','40','','2024-04-22 15:13:49','2024-04-22 15:13:49');
INSERT INTO designations VALUES('294','PARAMEDIC','2','40','','2024-04-22 15:14:00','2024-04-22 15:14:00');
INSERT INTO designations VALUES('295','CHEKER','2','98','','2024-04-22 15:16:54','2024-04-22 15:16:54');
INSERT INTO designations VALUES('296','HELPER','2','98','','2024-04-22 15:17:03','2024-04-22 15:17:03');
INSERT INTO designations VALUES('297','INSULATION','2','98','','2024-04-22 15:17:13','2024-04-22 15:17:13');
INSERT INTO designations VALUES('298','ADMIN','2','98','','2024-04-22 15:17:20','2024-04-22 15:17:20');
INSERT INTO designations VALUES('299','INSULATION COORDINATOR','2','98','','2024-04-22 15:17:31','2024-04-22 15:17:31');
INSERT INTO designations VALUES('300','FITTER','2','98','','2024-04-22 15:17:39','2024-04-22 15:17:39');
INSERT INTO designations VALUES('301','FITTER 2','2','98','','2024-04-22 15:17:49','2024-04-22 15:17:49');
INSERT INTO designations VALUES('302','INSULATOR','2','98','','2024-04-22 15:18:01','2024-04-22 15:18:01');
INSERT INTO designations VALUES('303','SKILL 2','2','98','','2024-04-22 15:18:17','2024-04-22 15:18:17');
INSERT INTO designations VALUES('304','FOREMAN','2','98','','2024-04-22 15:18:26','2024-04-22 15:18:26');
INSERT INTO designations VALUES('305','IT STAFF','2','95','','2024-04-22 15:18:37','2024-04-22 15:18:37');
INSERT INTO designations VALUES('306','ASST. MATERIAL HANDLING','2','42','','2024-04-22 15:19:05','2024-04-22 15:19:05');
INSERT INTO designations VALUES('307','SUPERVISOR M/H','2','42','','2024-04-22 15:19:21','2024-04-22 15:19:21');
INSERT INTO designations VALUES('308','MATERIAL HANDLING 1','2','42','','2024-04-22 15:19:32','2024-04-22 15:19:32');
INSERT INTO designations VALUES('309','MATERIAL HANDLING 2','2','42','','2024-04-22 15:19:42','2024-04-22 15:19:42');
INSERT INTO designations VALUES('310','MATERIAL CONTROL 2','2','42','','2024-04-22 15:19:58','2024-04-22 15:19:58');
INSERT INTO designations VALUES('311','FOREMAN','2','95','','2024-04-22 15:20:07','2024-04-22 15:20:07');
INSERT INTO designations VALUES('312','ADMIN','2','42','','2024-04-22 15:20:19','2024-04-22 15:20:19');
INSERT INTO designations VALUES('313','SEMI SKILL','2','42','','2024-04-22 15:20:30','2024-04-22 15:20:30');
INSERT INTO designations VALUES('314','FOREMAN MATERIAL HANDLING','2','42','','2024-04-22 15:20:41','2024-04-22 15:20:41');
INSERT INTO designations VALUES('315','MH SUPERVISOR','2','42','','2024-04-22 15:20:51','2024-04-22 15:20:51');
INSERT INTO designations VALUES('316','FOREMAN','2','96','','2024-04-22 15:21:54','2024-04-22 15:21:54');
INSERT INTO designations VALUES('317','OPERATOR FOCO','2','96','','2024-04-22 15:22:27','2024-04-22 15:22:27');
INSERT INTO designations VALUES('318','SEMI SKILL','2','96','','2024-04-22 15:22:35','2024-04-22 15:22:35');
INSERT INTO designations VALUES('319','OPR. FOCO TRUCK','2','96','','2024-04-22 15:22:49','2024-04-22 15:22:49');
INSERT INTO designations VALUES('320','MH &amp; HE COORDINATOR','2','96','','2024-04-22 15:23:06','2024-04-22 15:23:06');
INSERT INTO designations VALUES('321','DRIVER TRAILER','2','96','','2024-04-22 15:23:19','2024-04-22 15:23:19');
INSERT INTO designations VALUES('322','RIGGER 1','2','96','','2024-04-22 15:23:29','2024-04-22 15:23:29');
INSERT INTO designations VALUES('323','MATERIAL HANDLING 1','2','96','','2024-04-22 15:23:41','2024-04-22 15:23:41');
INSERT INTO designations VALUES('324','OPR. OHC','2','96','','2024-04-22 15:23:58','2024-04-22 15:23:58');
INSERT INTO designations VALUES('325','SEMI SKILL','2','97','','2024-04-22 15:24:10','2024-04-22 15:24:10');
INSERT INTO designations VALUES('326','FITTER 1','2','43','','2024-04-22 15:24:28','2024-04-22 15:24:28');
INSERT INTO designations VALUES('327','FITTER 2','2','43','','2024-04-22 15:24:34','2024-04-22 15:24:34');
INSERT INTO designations VALUES('328','HELPER','2','43','','2024-04-22 15:24:43','2024-04-22 15:24:43');
INSERT INTO designations VALUES('329','SEMI SKILL','2','43','','2024-04-22 15:24:52','2024-04-22 15:24:52');
INSERT INTO designations VALUES('330','FOREMAN','2','43','','2024-04-22 15:25:03','2024-04-22 15:25:03');
INSERT INTO designations VALUES('331','MILLWIRGHT 1','2','43','','2024-04-22 15:25:14','2024-04-22 15:25:14');
INSERT INTO designations VALUES('332','SUPEVISOR MECHANICAL','2','43','','2024-04-22 15:25:30','2024-04-22 15:25:30');
INSERT INTO designations VALUES('333','MILLWRIGHT 2','2','43','','2024-04-22 15:25:58','2024-04-22 15:25:58');
INSERT INTO designations VALUES('334','SUPERVISOR TANKI','2','43','','2024-04-22 15:26:11','2024-04-22 15:26:11');
INSERT INTO designations VALUES('335','SUPERVISOR','2','43','','2024-04-22 15:26:24','2024-04-22 15:26:24');
INSERT INTO designations VALUES('336','SUPERVISOR','2','45','','2024-04-22 15:26:58','2024-04-22 15:26:58');
INSERT INTO designations VALUES('337','FITTER 1','2','45','','2024-04-22 15:27:08','2024-04-22 15:27:08');
INSERT INTO designations VALUES('338','CHECKER QC','2','45','','2024-04-22 15:27:19','2024-04-22 15:27:19');
INSERT INTO designations VALUES('339','HELPER','2','45','','2024-04-22 15:27:28','2024-04-22 15:27:28');
INSERT INTO designations VALUES('340','FITTER 2','2','45','','2024-04-22 15:27:38','2024-04-22 15:27:38');
INSERT INTO designations VALUES('341','FOREMAN','2','45','','2024-04-22 15:27:49','2024-04-22 15:27:49');
INSERT INTO designations VALUES('342','WELDER','2','45','','2024-04-22 15:27:58','2024-04-22 15:27:58');
INSERT INTO designations VALUES('343','ADMIN','2','45','','2024-04-22 15:28:04','2024-04-22 15:28:04');
INSERT INTO designations VALUES('344','SEMI SKILL','2','45','','2024-04-22 15:28:13','2024-04-22 15:28:13');
INSERT INTO designations VALUES('345','SUPERVISOR PIPING','2','45','','2024-04-22 15:28:24','2024-04-22 15:28:24');
INSERT INTO designations VALUES('346','JR ENGINEER','2','45','','2024-04-22 15:28:34','2024-04-22 15:28:34');
INSERT INTO designations VALUES('347','PANTING 1','2','45','','2024-04-22 15:29:37','2024-04-22 15:29:37');
INSERT INTO designations VALUES('348','PPC COORDINATOR','2','46','','2024-04-22 15:30:57','2024-04-22 15:30:57');
INSERT INTO designations VALUES('349','CONSTRUCTION MANAGER','7','82','','2024-04-22 15:31:11','2024-04-22 15:31:11');
INSERT INTO designations VALUES('350','FINANCE','2','46','','2024-04-22 15:31:22','2024-04-22 15:31:22');
INSERT INTO designations VALUES('351','SITE MANAGER','2','46','','2024-04-22 15:31:31','2024-04-22 15:31:31');
INSERT INTO designations VALUES('352','PROJECT MANAGER','2','46','','2024-04-22 15:31:45','2024-04-22 15:31:45');
INSERT INTO designations VALUES('353','ADMIN','2','47','','2024-04-22 15:32:02','2024-04-22 15:32:02');
INSERT INTO designations VALUES('354','COST CONTROL','2','47','','2024-04-22 15:32:15','2024-04-22 15:32:15');
INSERT INTO designations VALUES('355','ASISTEN PPC','2','47','','2024-04-22 15:32:54','2024-04-22 15:32:54');
INSERT INTO designations VALUES('356','ADMIN PROJECT','2','47','','2024-04-22 15:33:04','2024-04-22 15:33:04');
INSERT INTO designations VALUES('357','PPC AREA','2','47','','2024-04-22 15:33:13','2024-04-22 15:33:13');
INSERT INTO designations VALUES('358','PPC','2','47','','2024-04-22 15:33:29','2024-04-22 15:33:29');
INSERT INTO designations VALUES('359','ADMIN PPC','2','47','','2024-04-22 15:33:44','2024-04-22 15:33:44');
INSERT INTO designations VALUES('360','ADMIN','2','48','','2024-04-22 15:34:21','2024-04-22 15:34:21');
INSERT INTO designations VALUES('361','QAQC COORDINATOR','2','83','','2024-04-22 15:34:44','2024-04-22 15:34:44');
INSERT INTO designations VALUES('362','ADMIN','2','83','','2024-04-22 15:34:56','2024-04-22 15:34:56');
INSERT INTO designations VALUES('363','INSPECTOR','2','83','','2024-04-22 15:35:08','2024-04-22 15:35:08');
INSERT INTO designations VALUES('364','PAINTER 1','2','83','','2024-04-22 15:35:19','2024-04-22 15:35:19');
INSERT INTO designations VALUES('365','QC INSPECTOR','2','83','','2024-04-22 15:35:48','2024-04-22 15:35:48');
INSERT INTO designations VALUES('366','ADMIN QC','2','83','','2024-04-22 15:36:01','2024-04-22 15:36:01');
INSERT INTO designations VALUES('367','ADMIN QAQC','2','83','','2024-04-22 15:36:10','2024-04-22 15:36:10');
INSERT INTO designations VALUES('368','JR INSPECTOR','2','83','','2024-04-22 15:36:28','2024-04-22 15:36:28');
INSERT INTO designations VALUES('369','QC CHECKER','2','83','','2024-04-22 15:36:44','2024-04-22 15:36:44');
INSERT INTO designations VALUES('370','QUALITY CONTROL','2','83','','2024-04-22 15:36:57','2024-04-22 15:36:57');
INSERT INTO designations VALUES('371','JUNIOR QC','2','83','','2024-04-22 15:37:18','2024-04-22 15:37:18');
INSERT INTO designations VALUES('372','CHECKER PIPING','2','83','','2024-04-22 15:37:32','2024-04-22 15:37:32');
INSERT INTO designations VALUES('373','FOREMAN','2','50','','2024-04-22 15:37:47','2024-04-22 15:37:47');
INSERT INTO designations VALUES('374','RIGGER 1','2','50','','2024-04-22 15:38:00','2024-04-22 15:38:00');
INSERT INTO designations VALUES('375','RIGGER 2','2','50','','2024-04-22 15:38:10','2024-04-22 15:38:10');
INSERT INTO designations VALUES('376','OPR FOCO CRANE','2','50','','2024-04-22 15:38:29','2024-04-22 15:38:29');
INSERT INTO designations VALUES('377','RIGGING ENGINEER','2','50','','2024-04-22 15:38:45','2024-04-22 15:38:45');
INSERT INTO designations VALUES('378','SEMI SKILL','2','50','','2024-04-22 15:39:00','2024-04-22 15:39:00');
INSERT INTO designations VALUES('379','SUPERVISOR','2','50','','2024-04-22 15:39:10','2024-04-22 15:39:10');
INSERT INTO designations VALUES('380','HELPER','2','50','','2024-04-22 15:39:24','2024-04-22 15:39:24');
INSERT INTO designations VALUES('381','OPERATOR FOCO','2','50','','2024-04-22 15:39:36','2024-04-22 15:39:36');
INSERT INTO designations VALUES('382','INSPECTOR SCAFFOLDER','2','51','','2024-04-22 15:40:31','2024-04-22 15:40:31');
INSERT INTO designations VALUES('383','SPV SCAFFOLDER','2','51','','2024-04-22 15:40:47','2024-04-22 15:40:47');
INSERT INTO designations VALUES('384','FOREMAN','2','51','','2024-04-22 15:40:55','2024-04-22 15:40:55');
INSERT INTO designations VALUES('385','SCAFFOLDER 1','2','51','','2024-04-22 15:41:14','2024-04-22 15:41:14');
INSERT INTO designations VALUES('386','SCAFFOLDER 2','2','51','','2024-04-22 15:41:22','2024-04-22 15:41:22');
INSERT INTO designations VALUES('387','LEAD HEAD','2','51','','2024-04-22 15:41:32','2024-04-22 15:41:32');
INSERT INTO designations VALUES('388','HELPER','2','51','','2024-04-22 15:41:43','2024-04-22 15:41:43');
INSERT INTO designations VALUES('389','SCAFFOLDING 1','2','51','','2024-04-22 15:42:02','2024-04-22 15:42:02');
INSERT INTO designations VALUES('390','SUPERVISOR','2','51','','2024-04-22 15:42:13','2024-04-22 15:42:13');
INSERT INTO designations VALUES('391','HELPER SCAFFOLDER','2','51','','2024-04-22 15:42:39','2024-04-22 15:42:39');
INSERT INTO designations VALUES('392','DOCUMENT CONTROLLER','2','52','','2024-04-22 15:43:04','2024-04-22 15:43:04');
INSERT INTO designations VALUES('393','ADMIN','2','52','','2024-04-22 15:43:12','2024-04-22 15:43:12');
INSERT INTO designations VALUES('394','FITTER','2','53','','2024-04-22 15:44:15','2024-04-22 15:44:15');
INSERT INTO designations VALUES('395','GA','2','53','','2024-04-22 15:44:26','2024-04-22 15:44:26');
INSERT INTO designations VALUES('396','ADMIN','2','53','','2024-04-22 15:44:37','2024-04-22 15:44:37');
INSERT INTO designations VALUES('397','FOREMAN','2','53','','2024-04-22 15:44:49','2024-04-22 15:44:49');
INSERT INTO designations VALUES('398','FITTER 1','2','53','','2024-04-22 15:45:01','2024-04-22 15:45:01');
INSERT INTO designations VALUES('399','FITTER 2','2','53','','2024-04-22 15:45:13','2024-04-22 15:45:13');
INSERT INTO designations VALUES('400','HELPER','2','53','','2024-04-22 15:45:25','2024-04-22 15:45:25');
INSERT INTO designations VALUES('401','SURVEYOR','2','99','','2024-04-22 15:46:06','2024-04-22 15:46:06');
INSERT INTO designations VALUES('402','SUPERVISOR','2','99','','2024-04-22 15:46:14','2024-04-22 15:46:14');
INSERT INTO designations VALUES('403','HELPER','2','99','','2024-04-22 15:46:25','2024-04-22 15:46:25');
INSERT INTO designations VALUES('404','SEMI SKILL','2','99','','2024-04-22 15:46:38','2024-04-22 15:46:38');
INSERT INTO designations VALUES('405','FITTER','2','100','','2024-04-22 15:51:26','2024-04-22 15:51:26');
INSERT INTO designations VALUES('406','ADMIN','2','55','','2024-04-22 15:51:41','2024-04-22 15:51:41');
INSERT INTO designations VALUES('407','WAREHOUSE 2','2','55','','2024-04-22 15:51:51','2024-04-22 15:51:51');
INSERT INTO designations VALUES('408','SEMI SKILL','2','55','','2024-04-22 15:52:02','2024-04-22 15:52:02');
INSERT INTO designations VALUES('409','WAREHOUSE 1','2','55','','2024-04-22 15:52:12','2024-04-22 15:52:12');
INSERT INTO designations VALUES('410','WAREHOUSE COORDINATOR','2','55','','2024-04-22 15:52:27','2024-04-22 15:52:27');
INSERT INTO designations VALUES('411','WAREHOUSE SPV','2','55','','2024-04-22 15:52:41','2024-04-22 15:52:41');
INSERT INTO designations VALUES('412','LEADMAN','2','55','','2024-04-22 15:52:55','2024-04-22 15:52:55');
INSERT INTO designations VALUES('413','HELPER','2','55','','2024-04-22 15:53:06','2024-04-22 15:53:06');
INSERT INTO designations VALUES('414','WELDER GTAW SMAW SS','2','56','','2024-04-22 15:53:22','2024-04-22 15:53:22');
INSERT INTO designations VALUES('415','WELDER SMAW SS / DUPLEX','2','56','','2024-04-22 15:53:36','2024-04-22 15:53:36');
INSERT INTO designations VALUES('416','HELPER','2','56','','2024-04-22 15:53:47','2024-04-22 15:53:47');
INSERT INTO designations VALUES('417','WELDER GTAW SMAW DUPLEX / TUBE HP / PIPE STEAM','2','56','','2024-04-22 15:54:17','2024-04-22 15:54:17');
INSERT INTO designations VALUES('418','WELDER','2','56','','2024-04-22 15:54:31','2024-04-22 15:54:31');
INSERT INTO designations VALUES('419','SUPERVISOR','2','56','','2024-04-22 15:54:45','2024-04-22 15:54:45');
INSERT INTO designations VALUES('420','WELDER SMAW CS SUPPORT','2','56','','2024-04-22 15:54:55','2024-04-22 15:54:55');
INSERT INTO designations VALUES('421','WELDING SUPERVISOR','2','56','','2024-04-22 15:55:07','2024-04-22 15:55:07');
INSERT INTO designations VALUES('422','WELDER SMAW SS','2','56','','2024-04-22 15:55:22','2024-04-22 15:55:22');
INSERT INTO designations VALUES('423','SUPERVISOR','8','101','','2024-04-23 14:42:43','2024-04-23 14:42:43');
INSERT INTO designations VALUES('424','ENGINEER','8','102','','2024-04-23 14:43:01','2024-04-23 14:43:01');
INSERT INTO designations VALUES('425','FINANCE SITE','8','67','','2024-04-23 14:43:44','2024-04-23 14:43:44');
INSERT INTO designations VALUES('426','HRGA SITE','8','103','','2024-04-23 14:49:42','2024-04-23 14:49:42');
INSERT INTO designations VALUES('427','DRIVER','8','103','','2024-04-23 14:49:50','2024-04-23 14:49:50');
INSERT INTO designations VALUES('428','HSSE OFFICER','8','104','','2024-04-23 14:51:23','2024-04-23 14:51:23');
INSERT INTO designations VALUES('429','SECURITY','8','104','','2024-04-23 14:51:31','2024-04-23 14:51:31');
INSERT INTO designations VALUES('430','FITTER','8','105','','2024-04-23 14:52:14','2024-04-23 14:52:14');
INSERT INTO designations VALUES('431','PROJECT MANAGER','8','106','','2024-04-23 14:52:27','2024-04-23 14:52:27');
INSERT INTO designations VALUES('432','STAFF PROCUREMENT','8','107','','2024-04-23 14:52:45','2024-04-23 14:52:45');
INSERT INTO designations VALUES('433','EXPEDITOR','8','105','','2024-04-23 14:52:54','2024-04-23 14:52:54');
INSERT INTO designations VALUES('434','SUPERVISOR','8','108','','2024-04-23 14:53:06','2024-04-23 14:53:06');
INSERT INTO designations VALUES('435','FITTER','8','108','','2024-04-23 14:53:16','2024-04-23 14:53:16');
INSERT INTO designations VALUES('436','SURVEYOR','8','109','','2024-04-23 14:53:36','2024-04-23 14:54:15');
INSERT INTO designations VALUES('437','PPC Coordinator','1','18','','2024-05-06 22:23:33','2024-05-06 22:23:33');
INSERT INTO designations VALUES('438','PPC Coordinator','4','110','','2024-05-06 22:23:43','2024-05-06 22:23:43');
INSERT INTO designations VALUES('439','ACCOUNT PAYABLE STAFF','1','5','','2024-05-07 15:26:09','2024-05-07 15:26:09');
INSERT INTO designations VALUES('440','FAT STAFF','11','112','','2024-05-07 16:46:28','2024-05-07 16:46:28');
INSERT INTO designations VALUES('441','TIMAS REPRESENTATIVE','11','113','','2024-05-07 16:46:55','2024-05-07 16:46:55');
INSERT INTO designations VALUES('442','O&amp;M MANAGER','11','113','','2024-05-07 16:47:10','2024-05-07 16:47:10');
INSERT INTO designations VALUES('443','GENERAL ADMIN','5','114','','2024-05-07 16:48:08','2024-05-07 16:48:08');
INSERT INTO designations VALUES('444','RISK&amp;INSURANCE COORDINATOR','5','115','','2024-05-07 16:48:38','2024-05-07 16:48:38');
INSERT INTO designations VALUES('445','OPERATION INTERFACE ENGINEER','5','116','','2024-05-07 16:49:02','2024-05-07 16:49:02');
INSERT INTO designations VALUES('446','HSSE ADVISOR','5','117','','2024-05-07 16:49:12','2024-05-07 16:49:12');
INSERT INTO designations VALUES('447','FIELD ENGINEER','6','124','','2024-05-07 16:50:50','2024-05-07 16:50:50');
INSERT INTO designations VALUES('448','ONSHORE CONSTRUCTION MANAGER','6','124','','2024-05-07 16:51:14','2024-05-07 16:51:14');
INSERT INTO designations VALUES('449','PROJECT ENGINEERING MANAGER','6','123','','2024-05-07 16:51:45','2024-05-07 16:51:45');
INSERT INTO designations VALUES('450','LEAD NAVAL ENGINEER','6','123','','2024-05-07 16:51:58','2024-05-07 16:51:58');
INSERT INTO designations VALUES('451','T/I DRAFTER','6','123','','2024-05-07 16:52:15','2024-05-07 16:52:15');
INSERT INTO designations VALUES('452','STRUCTURAL ENGINEER','6','123','','2024-05-07 16:52:27','2024-05-07 16:52:27');
INSERT INTO designations VALUES('453','SR. DESIGNER','6','123','','2024-05-07 16:52:43','2024-05-07 16:52:43');
INSERT INTO designations VALUES('454','DRAFTER','6','123','','2024-05-07 16:52:55','2024-05-07 16:52:55');
INSERT INTO designations VALUES('455','PIPING DESIGNER','6','123','','2024-05-07 16:53:10','2024-05-07 16:53:10');
INSERT INTO designations VALUES('456','STRUCTURE ENGINEER','6','123','','2024-05-07 16:53:24','2024-05-07 16:53:24');
INSERT INTO designations VALUES('457','ACCOUNT PAYABLE STAFF','6','147','','2024-05-07 16:56:55','2024-05-07 16:56:55');
INSERT INTO designations VALUES('458','FINANCE TSI','6','147','','2024-05-07 16:57:08','2024-05-07 16:57:08');
INSERT INTO designations VALUES('459','DRIVER','6','62','','2024-05-07 16:57:23','2024-05-07 16:57:23');
INSERT INTO designations VALUES('460','OFFICE BOY','6','62','','2024-05-07 16:57:31','2024-05-07 16:58:50');
INSERT INTO designations VALUES('461','HR SERVICE','6','62','','2024-05-07 16:59:33','2024-05-07 16:59:46');
INSERT INTO designations VALUES('462','GA ADMINISTRATOR','6','62','','2024-05-07 17:00:06','2024-05-07 17:00:06');
INSERT INTO designations VALUES('463','HSSE ADVISOR','6','129','','2024-05-07 17:00:27','2024-05-07 17:00:27');
INSERT INTO designations VALUES('464','PROJECT HSSE MANAGER','6','129','','2024-05-07 17:00:42','2024-05-07 17:00:42');
INSERT INTO designations VALUES('465','MEDICAL COORDINATOR','6','129','','2024-05-07 17:00:53','2024-05-07 17:00:53');
INSERT INTO designations VALUES('466','IT PROGRAMMER','6','120','','2024-05-07 17:01:26','2024-05-07 17:01:26');
INSERT INTO designations VALUES('467','SENIOR CONTRACT ENGINEER','6','148','','2024-05-07 17:02:38','2024-05-07 17:02:38');
INSERT INTO designations VALUES('468','LOGISTIC COORDINATOR','6','121','','2024-05-07 17:03:03','2024-05-07 17:03:03');
INSERT INTO designations VALUES('469','CREW PAYROLL','6','121','','2024-05-07 17:03:21','2024-05-07 17:03:21');
INSERT INTO designations VALUES('470','CREW COORDINATOR','6','121','','2024-05-07 17:03:33','2024-05-07 17:03:33');
INSERT INTO designations VALUES('471','MARINE OPERATION','6','127','','2024-05-07 17:03:51','2024-05-07 17:03:51');
INSERT INTO designations VALUES('472','LOGISTIC &amp; FORMALITIES COORDINATOR','6','149','','2024-05-07 17:05:50','2024-05-07 17:05:50');
INSERT INTO designations VALUES('473','SENIOR FIELD ENGINEER','6','149','','2024-05-07 17:06:01','2024-05-07 17:06:01');
INSERT INTO designations VALUES('474','WAREHOUSE','6','149','','2024-05-07 17:06:11','2024-05-07 17:06:11');
INSERT INTO designations VALUES('475','PROJECT SECRETARY','6','150','','2024-05-07 17:06:57','2024-05-07 17:06:57');
INSERT INTO designations VALUES('476','PROJECT MANAGER','6','150','','2024-05-07 17:07:09','2024-05-07 17:07:09');
INSERT INTO designations VALUES('477','BUYER','6','130','','2024-05-07 17:07:23','2024-05-07 17:07:23');
INSERT INTO designations VALUES('478','EXPEDITOR','6','130','','2024-05-07 17:07:38','2024-05-07 17:07:38');
INSERT INTO designations VALUES('479','PROCUREMENT ADMINISTRATOR','6','130','','2024-05-07 17:08:00','2024-05-07 17:08:00');
INSERT INTO designations VALUES('480','PROCUREMENT MANAGER','6','130','','2024-05-07 17:08:11','2024-05-07 17:08:11');
INSERT INTO designations VALUES('481','DOCUMENT CONTROLLER','6','125','','2024-05-07 17:09:36','2024-05-07 17:09:36');
INSERT INTO designations VALUES('482','PROJECT CONTROL ENGINEER','6','125','','2024-05-07 17:09:52','2024-05-07 17:09:52');
INSERT INTO designations VALUES('483','PROJECT SERVICE MANAGER','6','125','','2024-05-07 17:10:06','2024-05-07 17:10:06');
INSERT INTO designations VALUES('484','PROPOSAL COORDINATOR','6','128','','2024-05-07 17:10:27','2024-05-07 17:10:27');
INSERT INTO designations VALUES('485','PROPOSAL MANAGER','6','128','','2024-05-07 17:10:39','2024-05-07 17:10:39');
INSERT INTO designations VALUES('486','QA / QC DOCUMENTATION','6','122','','2024-05-07 17:11:13','2024-05-07 17:11:13');
INSERT INTO designations VALUES('487','COORPORATE QAQC MANAGER','6','122','','2024-05-07 17:11:35','2024-05-07 17:11:35');
INSERT INTO designations VALUES('488','SUBCONTRACTOR SPECIALIST','6','126','','2024-05-07 17:14:07','2024-05-07 17:14:07');
INSERT INTO designations VALUES('489','SUBCONTRACTOR ADMINISTRATOR','6','126','','2024-05-07 17:14:19','2024-05-07 17:14:19');
INSERT INTO designations VALUES('490','MARINE SUBCONTRACTOR BUYER','6','126','','2024-05-07 17:14:50','2024-05-07 17:14:50');
INSERT INTO designations VALUES('491','ADMIN TSI','6','119','','2024-05-07 17:15:24','2024-05-07 17:15:24');
INSERT INTO designations VALUES('492','BUYER TSI','6','119','','2024-05-07 17:15:53','2024-05-07 17:15:53');
INSERT INTO designations VALUES('493','LOGISTIC','6','119','','2024-05-07 17:16:37','2024-05-07 17:16:37');
INSERT INTO designations VALUES('494','SECRETARY FOR PRESIDENT DIRECTOR','6','119','','2024-05-07 17:17:25','2024-05-07 17:17:25');
INSERT INTO designations VALUES('495','FIELD ENGINEER','9','136','','2024-05-07 17:17:48','2024-05-07 17:17:48');
INSERT INTO designations VALUES('496','SENIOR FIELD ENGINEER','9','136','','2024-05-07 17:18:00','2024-05-07 17:18:00');
INSERT INTO designations VALUES('497','LEAD ELECTRICAL ENGINEER','9','131','','2024-05-07 17:18:20','2024-05-07 17:18:20');
INSERT INTO designations VALUES('498','LEAD PROCESS ENGINEER','9','131','','2024-05-07 17:18:39','2024-05-07 17:18:39');
INSERT INTO designations VALUES('499','PIPELINE ENGINEER','9','131','','2024-05-07 17:18:49','2024-05-07 17:18:49');
INSERT INTO designations VALUES('500','LEAD MECHANICAL ENGINEER','9','131','','2024-05-07 17:19:01','2024-05-07 17:19:01');
INSERT INTO designations VALUES('501','SENIOR PIPING','9','131','','2024-05-07 17:19:11','2024-05-07 17:19:11');
INSERT INTO designations VALUES('502','STRUCTURE ENGINEER','9','131','','2024-05-07 17:19:28','2024-05-07 17:19:28');
INSERT INTO designations VALUES('503','NAVAL ENGINEER','9','131','','2024-05-07 17:19:38','2024-05-07 17:19:38');
INSERT INTO designations VALUES('504','INTERFACE ENGINEER','9','131','','2024-05-07 17:19:49','2024-05-07 17:19:49');
INSERT INTO designations VALUES('505','LEAD PIPING','9','131','','2024-05-07 17:20:00','2024-05-07 17:20:00');
INSERT INTO designations VALUES('506','LEAD MECHANICAL','9','131','','2024-05-07 17:20:11','2024-05-07 17:20:11');
INSERT INTO designations VALUES('507','LEAD INSTRUMENT&amp;TELECOM ENGINEER','9','131','','2024-05-07 17:20:34','2024-05-07 17:20:34');
INSERT INTO designations VALUES('508','JUNIOR PROJECT ENGINEER','9','131','','2024-05-07 17:20:46','2024-05-07 17:20:46');
INSERT INTO designations VALUES('509','ACCOUNT PAYABLE','9','137','','2024-05-07 17:22:46','2024-05-07 17:22:46');
INSERT INTO designations VALUES('510','FINANCE CASHIER','9','137','','2024-05-07 17:23:04','2024-05-07 17:23:04');
INSERT INTO designations VALUES('511','FAT STAFF','9','137','','2024-05-07 17:25:50','2024-05-07 17:25:50');
INSERT INTO designations VALUES('512','MESSANGER','9','139','','2024-05-07 17:26:13','2024-05-07 17:26:13');
INSERT INTO designations VALUES('513','DRIVER','9','139','','2024-05-07 17:26:22','2024-05-07 17:26:22');
INSERT INTO designations VALUES('514','RESEPSIONIST','9','139','','2024-05-07 17:26:43','2024-05-07 17:26:43');
INSERT INTO designations VALUES('515','HRGA MANAGER','9','139','','2024-05-07 17:26:57','2024-05-07 17:26:57');
INSERT INTO designations VALUES('516','OFFICE BOY','9','139','','2024-05-07 17:27:10','2024-05-07 17:27:10');
INSERT INTO designations VALUES('517','PROJECT SECRETARY','9','139','','2024-05-07 17:27:23','2024-05-07 17:27:23');
INSERT INTO designations VALUES('518','HSSE ADMINISTRATOR','9','143','','2024-05-07 17:28:31','2024-05-07 17:28:31');
INSERT INTO designations VALUES('519','PROJECT HSSE MANAGER','9','143','','2024-05-07 17:29:19','2024-05-07 17:29:19');
INSERT INTO designations VALUES('520','COORPORATE HSSE MANAGER','9','143','','2024-05-07 17:29:33','2024-05-07 17:29:33');
INSERT INTO designations VALUES('521','IT SUPPORT','9','151','','2024-05-07 17:37:34','2024-05-07 17:37:34');
INSERT INTO designations VALUES('522','IT MANAGER','9','151','','2024-05-07 17:37:42','2024-05-07 17:38:53');
INSERT INTO designations VALUES('523','INSURANCE ADMINISTRATOR','9','138','','2024-05-07 17:39:39','2024-05-07 17:39:39');
INSERT INTO designations VALUES('524','LEGAL &amp; INSURANCE STAFF','9','138','','2024-05-07 17:39:53','2024-05-07 17:39:53');
INSERT INTO designations VALUES('525','LOGISTIC ADMINISTRATOR','9','146','','2024-05-07 17:40:42','2024-05-07 17:40:42');
INSERT INTO designations VALUES('526','ADMIN CREWING','9','146','','2024-05-07 17:40:57','2024-05-07 17:40:57');
INSERT INTO designations VALUES('527','CREW COORDINATOR','9','146','','2024-05-07 17:42:03','2024-05-07 17:42:03');
INSERT INTO designations VALUES('528','LOGISTIC OPERATION','9','146','','2024-05-07 17:42:18','2024-05-07 17:42:18');
INSERT INTO designations VALUES('529','LOGISTIC FORMALITIES','9','146','','2024-05-07 17:42:34','2024-05-07 17:42:34');
INSERT INTO designations VALUES('530','MATERIAL CONTROLLER','9','146','','2024-05-07 17:42:48','2024-05-07 17:42:48');
INSERT INTO designations VALUES('531','SECRETARY VICE PRESIDENT','9','142','','2024-05-07 17:44:00','2024-05-07 17:44:00');
INSERT INTO designations VALUES('532','SECRETARY FOR PRESIDENT DIRECTOR','9','142','','2024-05-07 17:44:16','2024-05-07 17:44:16');
INSERT INTO designations VALUES('533','SECRETARY FOR DEPUTY PRESIDENT DIRECTOR','9','142','','2024-05-07 17:44:56','2024-05-07 17:44:56');
INSERT INTO designations VALUES('534','VISE PRESIDENT','9','142','','2024-05-07 17:45:06','2024-05-07 17:45:06');
INSERT INTO designations VALUES('535','DEPUTY PRESIDENT DIRECTOR','9','142','','2024-05-07 17:45:28','2024-05-07 17:45:28');
INSERT INTO designations VALUES('538','MARINE OPERATION','9','152','','2024-05-07 17:49:49','2024-05-07 17:51:16');
INSERT INTO designations VALUES('539','LOGISTIC &amp; FORMALITIES COORDINATOR','9','152','','2024-05-07 17:52:17','2024-05-07 17:52:17');
INSERT INTO designations VALUES('540','CONSTRUCTION ENGINEER','9','144','','2024-05-07 17:52:35','2024-05-07 17:52:35');
INSERT INTO designations VALUES('541','ASSET INTEGRITY MANAGER','9','144','','2024-05-07 17:52:55','2024-05-07 17:52:55');
INSERT INTO designations VALUES('542','PROJECT MANAGER','9','144','','2024-05-07 17:53:18','2024-05-07 17:53:18');
INSERT INTO designations VALUES('543','DOCUMENT CONTROLLER','9','144','','2024-05-07 17:53:31','2024-05-07 17:53:31');
INSERT INTO designations VALUES('544','PMCSM ENGINEER','9','141','','2024-05-07 17:54:57','2024-05-07 17:54:57');
INSERT INTO designations VALUES('545','INSTALATION ENGINEER','9','141','','2024-05-07 17:55:09','2024-05-07 17:55:09');
INSERT INTO designations VALUES('546','HUC SENIOR STRUCTURAL ENGINEER','9','141','','2024-05-07 17:55:29','2024-05-07 17:55:51');
INSERT INTO designations VALUES('547','LEAD PIPING PRECOMM COMMISIONING','9','141','','2024-05-07 17:56:35','2024-05-07 17:56:35');
INSERT INTO designations VALUES('548','EI COMM ENGINEER','9','141','','2024-05-07 17:56:46','2024-05-07 17:56:46');
INSERT INTO designations VALUES('549','PCMS ENGINEER','9','141','','2024-05-07 17:56:58','2024-05-07 17:56:58');
INSERT INTO designations VALUES('550','EXPEDITOR','9','134','','2024-05-07 17:57:10','2024-05-07 17:57:10');
INSERT INTO designations VALUES('551','BUYER','9','134','','2024-05-07 17:57:17','2024-05-07 17:57:17');
INSERT INTO designations VALUES('552','SENIOR BUYER','9','134','','2024-05-07 17:57:29','2024-05-07 17:57:29');
INSERT INTO designations VALUES('553','PROCUREMENT ADMINISTRATOR','9','134','','2024-05-07 17:57:46','2024-05-07 17:57:46');
INSERT INTO designations VALUES('554','PLANNING ENGINEER','9','132','','2024-05-07 17:58:04','2024-05-07 17:58:04');
INSERT INTO designations VALUES('555','DOCUMENT CONTROLLER','9','132','','2024-05-07 17:58:14','2024-05-07 17:58:14');
INSERT INTO designations VALUES('556','LEAD PROJECT CONTROL ENGINEER','9','132','','2024-05-07 17:58:27','2024-05-07 17:58:27');
INSERT INTO designations VALUES('557','COST CONTROLLER','9','132','','2024-05-07 17:58:37','2024-05-07 17:58:37');
INSERT INTO designations VALUES('558','PROJECT SERVICE ADMINISTRATOR','9','132','','2024-05-07 17:58:56','2024-05-07 17:58:56');
INSERT INTO designations VALUES('559','LEAD PROPOSAL COORDINATOR','9','145','','2024-05-07 17:59:18','2024-05-07 17:59:18');
INSERT INTO designations VALUES('560','PROPOSAL ESTIMATOR','9','145','','2024-05-07 17:59:30','2024-05-07 17:59:30');
INSERT INTO designations VALUES('561','PROPOSAL ADMINISTRATOR','9','145','','2024-05-07 17:59:47','2024-05-07 17:59:47');
INSERT INTO designations VALUES('562','PROPOSAL ENGINEER','9','145','','2024-05-07 18:00:03','2024-05-07 18:00:03');
INSERT INTO designations VALUES('563','QC COORDINATOR','9','133','','2024-05-07 18:00:23','2024-05-07 18:00:23');
INSERT INTO designations VALUES('564','QA ENGINEER','9','133','','2024-05-07 18:00:37','2024-05-07 18:00:37');
INSERT INTO designations VALUES('565','WELDING ENGINEER','9','133','','2024-05-07 18:00:51','2024-05-07 18:00:51');
INSERT INTO designations VALUES('566','QAQC ADMINISTRATOR','9','133','','2024-05-07 18:01:04','2024-05-07 18:01:04');
INSERT INTO designations VALUES('567','LEAD QAQC','9','133','','2024-05-07 18:01:22','2024-05-07 18:01:22');
INSERT INTO designations VALUES('568','SUBCONTRACTOR MANAGER','9','135','','2024-05-07 18:02:04','2024-05-07 18:02:04');
INSERT INTO designations VALUES('569','SUBCONTRACTOR BUYER','9','135','','2024-05-07 18:02:17','2024-05-07 18:02:17');
INSERT INTO designations VALUES('570','SUBCONTRACTOR SPECIALIST','9','135','','2024-05-07 18:02:28','2024-05-07 18:02:28');
INSERT INTO designations VALUES('571','SUBCONTRACTOR MARINE-BUYER','9','135','','2024-05-07 18:02:42','2024-05-07 18:02:42');
INSERT INTO designations VALUES('572','AP MANAGER','1','5','','2024-05-07 18:25:58','2024-05-07 18:25:58');
INSERT INTO designations VALUES('573','TAX STAFF','1','4','','2024-05-07 18:28:04','2024-05-07 18:28:04');
INSERT INTO designations VALUES('574','ACCOUNTING &amp; TAX MANAGER','1','4','','2024-05-07 18:28:29','2024-05-07 18:28:29');
INSERT INTO designations VALUES('575','A/R STAFF','1','4','','2024-05-07 18:28:39','2024-05-07 18:28:39');
INSERT INTO designations VALUES('576','ACCOUNTING SUPERVISOR','1','4','','2024-05-07 18:28:52','2024-05-07 18:28:52');
INSERT INTO designations VALUES('577','ACCOUNTING STAFF','1','4','','2024-05-07 18:29:04','2024-05-07 18:29:04');
INSERT INTO designations VALUES('578','ACC &amp; TAX STAFF','1','4','','2024-05-07 18:29:21','2024-05-07 18:29:21');
INSERT INTO designations VALUES('579','ASSET MANAGEMENT STAFF','1','10','','2024-05-07 18:31:25','2024-05-07 18:31:25');
INSERT INTO designations VALUES('580','PROPOSAL SUPERVISOR','1','15','','2024-05-07 18:31:43','2024-05-07 18:31:43');
INSERT INTO designations VALUES('581','BUSINESS DEVELOPMENT MANAGER','1','15','','2024-05-07 18:32:00','2024-05-07 18:32:00');
INSERT INTO designations VALUES('582','PROPOSAL STAFF','1','15','','2024-05-07 18:32:11','2024-05-07 18:32:11');
INSERT INTO designations VALUES('584','MARKETING','1','15','','2024-05-07 18:32:31','2024-05-07 18:32:31');
INSERT INTO designations VALUES('585','ESTIMATOR SUPERINTENDENT','1','15','','2024-05-07 18:33:34','2024-05-07 18:33:34');
INSERT INTO designations VALUES('586','PROPOSAL ENGINEER','1','15','','2024-05-07 18:34:34','2024-05-07 18:34:34');
INSERT INTO designations VALUES('587','SPV INTERNAL AUDIT','1','24','','2024-05-07 18:37:35','2024-05-07 18:37:35');
INSERT INTO designations VALUES('588','SENIOR AUDITOR','1','24','','2024-05-07 18:37:47','2024-05-07 18:37:47');
INSERT INTO designations VALUES('589','CCB SUPERVISOR','1','14','','2024-05-07 18:39:48','2024-05-07 18:39:48');
INSERT INTO designations VALUES('590','CCB STAFF','1','14','','2024-05-07 18:39:59','2024-05-07 18:39:59');
INSERT INTO designations VALUES('591','DRAFTER','1','2','','2024-05-07 18:40:13','2024-05-07 18:40:13');
INSERT INTO designations VALUES('592','DRAFTER SUPERVISOR','1','2','','2024-05-07 18:40:33','2024-05-07 18:40:33');
INSERT INTO designations VALUES('593','MECHANICAL ENGINEER','1','2','','2024-05-07 18:40:47','2024-05-07 18:40:47');
INSERT INTO designations VALUES('594','DRAFTER MECHANICAL','1','2','','2024-05-07 18:40:56','2024-05-07 18:40:56');
INSERT INTO designations VALUES('595','ELECTRICAL &amp; INSTRUMENT DESIGNER','1','2','','2024-05-07 18:41:04','2024-05-07 18:41:04');
INSERT INTO designations VALUES('596','PROCESS ENGINEER','1','2','','2024-05-07 18:41:19','2024-05-07 18:41:19');
INSERT INTO designations VALUES('597','PIPING ENGINEER','1','2','','2024-05-07 18:41:30','2024-05-07 18:41:30');
INSERT INTO designations VALUES('598','EI ENGINEERING','1','2','','2024-05-07 18:41:53','2024-05-07 18:41:53');
INSERT INTO designations VALUES('599','LEAD PIPING &amp; MECHANICAL ENGINEER','1','2','','2024-05-07 18:42:02','2024-05-07 18:42:02');
INSERT INTO designations VALUES('600','ENGINEERING MANAGER','1','2','','2024-05-07 18:42:11','2024-05-07 18:42:11');
INSERT INTO designations VALUES('601','MECHANICAL DESIGNER','1','2','','2024-05-07 18:42:21','2024-05-07 18:42:21');
INSERT INTO designations VALUES('602','KASIR PROYEK','1','3','','2024-05-07 18:42:47','2024-05-07 18:44:32');
INSERT INTO designations VALUES('603','FINANCE SUPERVISOR','1','3','','2024-05-07 18:42:56','2024-05-07 18:42:56');
INSERT INTO designations VALUES('604','KASIR HO','1','3','','2024-05-07 18:43:04','2024-05-07 18:43:04');
INSERT INTO designations VALUES('605','FINANCE STAFF','1','3','','2024-05-07 18:43:16','2024-05-07 18:43:16');
INSERT INTO designations VALUES('606','PERSONAL ASSISTANT FOR FINANCE DIRECTOR','1','3','','2024-05-07 18:43:25','2024-05-07 18:43:25');
INSERT INTO designations VALUES('607','MESSENGER','1','21','','2024-05-07 18:44:42','2024-05-07 18:44:42');
INSERT INTO designations VALUES('608','GENERAL AFFAIR STAFF','1','21','','2024-05-07 18:44:57','2024-05-07 18:44:57');
INSERT INTO designations VALUES('609','OFFICE BOY','1','21','','2024-05-07 18:45:09','2024-05-07 18:45:09');
INSERT INTO designations VALUES('610','HR &amp; GA STAFF','1','21','','2024-05-07 18:45:20','2024-05-07 18:45:20');
INSERT INTO designations VALUES('611','DRIVER','1','21','','2024-05-07 18:45:29','2024-05-07 18:45:29');
INSERT INTO designations VALUES('612','HR &amp; GA SUPERVISOR','1','21','','2024-05-07 18:45:40','2024-05-07 18:45:40');
INSERT INTO designations VALUES('613','HRGA OFFICER','1','21','','2024-05-07 18:45:50','2024-05-07 18:45:50');
INSERT INTO designations VALUES('614','HRGA COORDINATOR','1','21','','2024-05-07 18:45:59','2024-05-07 18:45:59');
INSERT INTO designations VALUES('615','RESEPSIONIS','1','21','','2024-05-07 18:46:14','2024-05-07 18:46:14');
INSERT INTO designations VALUES('616','SECURITY','1','20','','2024-05-07 18:47:13','2024-05-07 18:47:13');
INSERT INTO designations VALUES('617','PROJECT HSSE COORDINATOR','1','20','','2024-05-07 18:47:21','2024-05-07 18:47:21');
INSERT INTO designations VALUES('618','HSSE MANAGER ONSHORE DIVISION','1','20','','2024-05-07 18:47:30','2024-05-07 18:47:30');
INSERT INTO designations VALUES('619','HSSE OFFICER','1','20','','2024-05-07 18:47:45','2024-05-07 18:47:45');
INSERT INTO designations VALUES('620','IT SUPERVISOR','1','7','','2024-05-07 18:48:16','2024-05-07 18:48:16');
INSERT INTO designations VALUES('621','IT STAFF','1','7','','2024-05-07 18:48:24','2024-05-07 18:48:24');
INSERT INTO designations VALUES('622','PROGRAMMER','1','7','','2024-05-07 18:48:56','2024-05-07 18:48:56');
INSERT INTO designations VALUES('623','INSURANCE STAFF','1','9','','2024-05-07 18:49:10','2024-05-07 18:49:10');
INSERT INTO designations VALUES('624','LEGAL &amp; INSURANCE SUPERVISOR','1','9','','2024-05-07 18:49:19','2024-05-07 18:49:19');
INSERT INTO designations VALUES('625','VICE PRESIDENT ONSHORE','1','153','','2024-05-07 18:49:54','2024-05-07 18:49:54');
INSERT INTO designations VALUES('626','HRGA MANAGER/DEPUTY VP ONSHORE','1','153','','2024-05-07 18:50:05','2024-05-07 18:50:05');
INSERT INTO designations VALUES('627','SITE MANAGER','1','18','','2024-05-07 18:50:26','2024-05-07 18:50:26');
INSERT INTO designations VALUES('628','PROJECT MANAGER','1','18','','2024-05-07 18:50:37','2024-05-07 18:50:37');
INSERT INTO designations VALUES('629','CONSTRUCTION MANAGER','1','18','','2024-05-07 18:50:50','2024-05-07 18:50:50');
INSERT INTO designations VALUES('630','PPC','1','18','','2024-05-07 18:51:00','2024-05-07 18:51:00');
INSERT INTO designations VALUES('631','PMT TEAM','1','18','','2024-05-07 18:51:09','2024-05-07 18:51:09');
INSERT INTO designations VALUES('632','WELDER SUPERVISOR','1','18','','2024-05-07 18:51:21','2024-05-07 18:51:21');
INSERT INTO designations VALUES('633','LEAD ENGINEER','1','18','','2024-05-07 18:51:38','2024-05-07 18:51:38');
INSERT INTO designations VALUES('634','LOGISTIC &amp; WAREHOUSE COORDINATOR','1','18','','2024-05-07 18:51:48','2024-05-07 18:51:48');
INSERT INTO designations VALUES('635','DOCUMENT CONTROL &amp; KASIR PROYEK','1','18','','2024-05-07 18:51:58','2024-05-07 18:51:58');
INSERT INTO designations VALUES('636','ADMINISTRASI DAN PERIJINAN','1','18','','2024-05-07 18:52:06','2024-05-07 18:52:06');
INSERT INTO designations VALUES('637','PPC PROJECT','1','18','','2024-05-07 18:52:14','2024-05-07 18:52:14');
INSERT INTO designations VALUES('638','DRIVER','1','18','','2024-05-07 18:52:28','2024-05-07 18:52:28');
INSERT INTO designations VALUES('639','OFFICE BOY','1','18','','2024-05-07 18:52:36','2024-05-07 18:52:36');
INSERT INTO designations VALUES('640','DEPUTY PROJECT MANAGER','1','18','','2024-05-07 18:52:44','2024-05-07 18:52:44');
INSERT INTO designations VALUES('641','RIGGING SUPERVISOR','1','18','','2024-05-07 18:52:52','2024-05-07 18:52:52');
INSERT INTO designations VALUES('642','PROJECT SECRETARY','1','18','','2024-05-07 18:52:59','2024-05-07 18:52:59');
INSERT INTO designations VALUES('643','BUYER SUPERVISOR','1','12','','2024-05-07 18:53:31','2024-05-07 18:53:31');
INSERT INTO designations VALUES('644','WAREHOUSE STAFF','1','12','','2024-05-07 18:53:42','2024-05-07 18:53:42');
INSERT INTO designations VALUES('645','ADMIN INVOICING','1','12','','2024-05-07 18:53:52','2024-05-07 18:53:52');
INSERT INTO designations VALUES('646','BUYER','1','12','','2024-05-07 18:54:02','2024-05-07 18:54:02');
INSERT INTO designations VALUES('647','EXPEDITOR &amp; LOGISTIC','1','12','','2024-05-07 18:54:14','2024-05-07 18:54:14');
INSERT INTO designations VALUES('648','LOGISTIC STAFF','1','12','','2024-05-07 18:54:23','2024-05-07 18:54:23');
INSERT INTO designations VALUES('649','ADMIN PROCUREMENT','1','12','','2024-05-07 18:54:32','2024-05-07 18:54:32');
INSERT INTO designations VALUES('650','PROCUREMENT STAFF','1','12','','2024-05-07 18:54:41','2024-05-07 18:54:41');
INSERT INTO designations VALUES('651','PROCUREMENT MANAGER','1','12','','2024-05-07 18:54:50','2024-05-07 18:54:50');
INSERT INTO designations VALUES('652','PPC COORDINATOR','1','19','','2024-05-07 18:55:04','2024-05-07 18:55:04');
INSERT INTO designations VALUES('653','DOCUMENT CONTROL','1','19','','2024-05-07 18:55:12','2024-05-07 18:55:12');
INSERT INTO designations VALUES('654','COST CONTROL','1','19','','2024-05-07 18:55:22','2024-05-07 18:55:22');
INSERT INTO designations VALUES('655','QA/QC COORDINATOR','1','23','','2024-05-07 18:55:33','2024-05-07 18:55:33');
INSERT INTO designations VALUES('656','QA/QC MANAGER','1','23','','2024-05-07 18:55:43','2024-05-07 18:55:43');
INSERT INTO designations VALUES('657','QMR MANAGER','1','13','','2024-05-07 18:55:55','2024-05-07 18:55:55');
INSERT INTO designations VALUES('658','QMR DOCUMENT CONTROLLER','1','13','','2024-05-07 18:56:03','2024-05-07 18:56:03');
INSERT INTO designations VALUES('659','QMR SUPERVISOR','1','13','','2024-05-07 18:56:12','2024-05-07 18:56:12');



CREATE TABLE `document_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `document_type` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_types_company_id_foreign` (`company_id`),
  CONSTRAINT `document_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO document_types VALUES('1','','KTP','2024-02-26 09:00:15','2024-02-26 09:00:15');
INSERT INTO document_types VALUES('2','','NPWP','2024-02-26 09:00:24','2024-02-26 09:00:24');



CREATE TABLE `employee_bank_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `account_name` varchar(191) DEFAULT NULL,
  `account_number` varchar(191) NOT NULL,
  `bank_name` varchar(191) NOT NULL,
  `bank_code` varchar(191) NOT NULL,
  `bank_branch` varchar(191) NOT NULL,
  `document_file` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_bank_accounts_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_bank_accounts_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3027 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_bank_accounts VALUES('1','3068','OKI CANDRA','9000029466233','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('2','3069','ARIANTO DANDRES','1080023697957','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('3','3070','SALMAN NOFARI','1080023662993','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('4','3071','SUTARTO WS','1110016143717','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('5','3072','MUHAMMAD AMIN SANDYSTA, S.E.,','1080017280653','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('6','3073','RIZAL GUNAWAN','1080023654727','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('7','3074','RIZKI WAHYU RINALDI','1080023809776','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('8','3075','UNGGUL AKBAR','1080023805410','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('9','3076','IDRIS NASUTION','1080023865828','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('10','3077','HERU ARIYADI','1080023869200','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('11','3078','ARDISON','1080024017098','Bank Mandiri','-','-','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_bank_accounts VALUES('12','3079','JEFRI MUNANDAR','1080024185309','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('13','3080','AFDHAL FEBRIANDIWA','1110020137051','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('14','3081','APRIZAL','1080023881122','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('15','3082','DIMAS NATAPRAYOGA, S.Pd','1120001606669','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('16','3083','Imam Mujoko','1080017901274','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('17','3084','Zakaria','1080020325107','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('18','3085','ADIS MAN ARI','1080023943674','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('19','3086','YUSRI','1080023958409','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('20','3087','SOFYAN WIRANDA','1070017985500','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('21','3088','MERLANG INDRA','1560010290213','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('22','3089','FAHMI GUSMANTO','1080024088255','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('23','3090','Firman H','1720003490259','Bank Mandiri','-','-','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_bank_accounts VALUES('24','3091','SUGIARTO','1110019924915','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('25','3092','ALI IMRAN YASIN','1080024643216','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('26','3093','SURYA PRAWIBOWO','1050014575645','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('27','3094','ELISA SEPTIA','1080024023229','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('28','3095','ANDRIAN PURNAMA','1330024933483','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('29','3096','RUDI HARTONO','1080023460687','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('30','3097','ILHAM MAULANA','1080024199524','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('31','3098','CHRISTIAN GANINDA','1840000809499','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('32','3099','KHAIRUN NISA SARAGIH','1080023291876','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('33','3100','SELAMAT PRIADI SIREGAR','1060015451613','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('34','3101','MARTUA SINAGA','1080017381915','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('35','3102','JAMSON TAMPUBOLON','1080024362932','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('36','3103','REONALDO PAMALIAN HUTABARAT','1080011832525','Bank Mandiri','-','-','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_bank_accounts VALUES('37','3104','TOTO EDI SUTIONO','1560004254233','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('38','3105','FARMA SUHENDRA','1090020093258','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('39','3106','WELI SANDRA','9000031419816','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('40','3107','ARDIANSYAH SIREGAR','1060015629168','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('41','3108','PANDU RAHMADANI','1800012109361','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('42','3109','RIJEV FARDIAN','1090013513023','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('43','3110','INDRA WARMAN','1080022542014','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('44','3111','MHD. FIRMANSAH ISMAIL','1080024411515','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('45','3112','MARTUNIS','1090020257978','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('46','3113','WANTY VERONICA PANGARIBUAN','1080023112866','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('47','3114','ABDUL RAHMAN','1070016082259','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('48','3115','WANDI MANIK','1080018773300','Bank Mandiri','-','-','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_bank_accounts VALUES('49','3116','TARMUZI','1080024461437','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('50','3117','ANDRE MAYORA','1080023151799','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('51','3118','ISWANDI','1080023228589','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('52','3119','NGAMANKEN TARIGAN','1080018804881','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('53','3120','SANTO PATERSON','1060013431591','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('54','3121','ACE','1080023311146','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('55','3122','BENNY S TARIGAN','1050014488393','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('56','3123','JAMILASI KABAN','1050016695813','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('57','3124','EDI SUSANTO','1050013464932','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('58','3125','TAUFIK AKBAR','1080018717901','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('59','3126','GILANG RAMADHAN','1080024552151','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('60','3127','NAEMAN NABABAN','1080018377250','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('61','3128','SUPARNO HUTAPEA','1080024639446','Bank Mandiri','-','-','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_bank_accounts VALUES('62','3129','NOVER RANTO PURBA','1080025694937','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('63','3130','GERI SINAGA','1080024769284','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('64','3131','Rezki Saputra Noflin','1080022904990','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('65','3132','JONA SITOHANG','1080023775621','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('66','3133','Febriyadi','1080022559851','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('67','3134','RENDI LOPA','1830003491627','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('68','3135','HELMIZA','1080024796683','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('69','3136','INDRA FEBRIANTO','1080024411531','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('70','3137','RIO MANGASI TUA LUMBAN GAOL','1080023397160','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('71','3138','EKO RIZKY VALIAN AKBAR','9000032725914','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('72','3139','FAZRIN RAHMADHAN','1080024950918','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('73','3140','Roni Pranata','1080020584844','Bank Mandiri','-','-','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_bank_accounts VALUES('74','3141','YUDI DARMADI','1080022794037','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('75','3142','MARLON SIHOMBING','1080023407225','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('76','3143','CANDRA PURBA','1080024546559','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('77','3144','M. DANI ERIZON','1080024015043','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('78','3145','SATYA PRATAMA','1110017156312','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('79','3146','SUTARSO','1080015748008','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('80','3147','LELY SUHERY DAULAY','1080024245327','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('81','3148','FAJRI RISALDI','1080022489513','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('82','3149','MANGIHUT GULTOM','1080023291645','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('83','3150','SANDI','-','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('84','3151','ABDI SIMANUNGKALIT','-','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('85','3152','FIRMANSYAH','1720003996354','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('86','3153','IRMAN SILABAN','1080022753827','Bank Mandiri','-','-','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_bank_accounts VALUES('87','3154','AHMAD SAI','1080023875850','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('88','3155','OTNIEL PANDIANGAN','1080020545670','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('89','3156','IKBAL ARNIANSYAH','1340023256406','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('90','3157','PAHMI RAMBE','1080024271588','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('91','3158','Susanto','1080020388659','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('92','3159','MUHAMMAD RIZKI','1080020810991','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('93','3160','IWANTO','-','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('94','3161','KHOLIDAN','-','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('95','3162','Muslim','1080018798737','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('96','3163','YELDI MARDIANTO','1080026317629','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('97','3164','Noel Nicolas Holysandi Pasaribu','1080014716469','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('98','3165','SUSENO HERLAMBANG','1080021461034','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('99','3166','TONI FIRDAUS','1080005267878','Bank Mandiri','-','-','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_bank_accounts VALUES('100','3167','Kriswandi','1080015245864','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('101','3168','RONI ASIH AMPU PARULIAN MANIK','1080025840597','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('102','3169','Ismael','1080011579498','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('103','3170','EKO MULYONO','9000011246296','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('104','3171','SUDIELI ZAGOTO','1080025188328','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('105','3172','FAUZAN ARIEF','1080023764377','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('106','3173','HOTMANAFER SIMATUPANG','1080023772081','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('107','3174','SUBKHAN WICAKSONO','1850003758155','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('108','3175','BOBY DESRIYANTO','1080024453749','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('109','3176','ANDRIAN SAPUTRA','1080023984827','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('110','3177','HARUN AL RASYID','1080023233068','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('111','3178','KIKI FRI NANDA','1080021795266','Bank Mandiri','-','-','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_bank_accounts VALUES('112','3179','Jhoni As\'ari','1080020410032','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('113','3180','Maragonti Harahap','1080015773154','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('114','3181','YOKI GUSRIANTO','1080025111999','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('115','3182','FAJAR NUGRAHA','-','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('116','3183','Robert Manurung','1080014953054','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('117','3184','JINBEN BINARA PARHUSIP','1080025144586','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('118','3185','Bagus Haryono','1080023117485','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('119','3186','Abdul Rasyid Sidik','1080023110720','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('120','3187','Lailatul Rahmah','1080020742343','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('121','3188','DENI KURNIAWAN','-','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('122','3189','Thomas Marhasil Tampubolon','1060014927670','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('123','3190','Eko Putra Mardiansyah','1860001673470','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('124','3191','TSANDI MUKHLASIN','1420020110853','Bank Mandiri','-','-','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_bank_accounts VALUES('125','3192','Jimmi Natal Situmorang','-','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('126','3193','ABID SANGKARA','-','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('127','3194','DAVID CHANNIAGO','1080024505373','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('128','3195','DENO SAFRIZAL','1060012011634','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('129','3196','IRVAN','1080025299430','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('130','3197','RANDI IQBAL','1080023798292','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('131','3198','Andri Ahmad Yani','1070010764878','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('132','3199','Julfri Adis','1080019319079','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('133','3200','Yudi Lupik','1080022569686','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('134','3201','Haryadi Saputra','1080022718481','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('135','3202','INDRI THAHARAH','1080019971911','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('136','3203','Aldo Novrizal','1080022639083','Bank Mandiri','-','-','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_bank_accounts VALUES('137','3204','DAFID EDGAR SAUQI','1110019784665','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('138','3205','JULIANDA LUBENSYAMER','1130016701173','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('139','3206','Muhazzir','1080020410644','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('140','3207','Selamet Riyadi','1080022569728','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('141','3208','Rudianto','1080013799409','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('142','3209','Amir Hamzah','1080022494992','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('143','3210','DEFRIANTO','1080023839203','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('144','3211','Anton Sudomo','1080022718804','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('145','3212','A. Maulana','1080022719042','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('146','3213','MUHAMMAD ANUGRAH GULTOM','-','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('147','3214','ASEP BARON','-','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('148','3215','HOLIL WAHYUDIN','-','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('149','3216','Dirja Gunawan','1080022773098','Bank Mandiri','-','-','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_bank_accounts VALUES('150','3217','PERI SUMANTRI','1080025635658','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('151','3218','HARIANDI JOHANSYAH SITORUS','1050016419263','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('152','3219','ALBET ARIF IRAWAN','1080023408694','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('153','3220','RUSDI','1080024088040','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('154','3221','MIKAEL SIMANJUNTAK','1080023852347','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('155','3222','AGUS TIYAN','1080023979934','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('156','3223','YEFRIZAL','1110018723672','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('157','3224','DIAN SUKMA PRAYOGA','1830002874013','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('158','3225','M. YUSUF','-','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('159','3226','RISKI GUNAWAN SINAGA','1080021591459','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('160','3227','ZUKRIAL','1080023770739','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('161','3228','HARKANI','1080023422026','Bank Mandiri','-','-','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_bank_accounts VALUES('162','3229','RAHMAN WAHYU RAMADHAN','1080024522444','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('163','3230','INDRA SUMANTRI','1080023764294','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('164','3231','Zakiah Gustiani','1120017016911','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('165','3232','DITA NATALIA DAVRIN SITOMPUL','1080025840696','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('166','3233','Dedi Miswar','1080020413358','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('167','3234','Sikta Joko Priyanto','1120007132918','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('168','3235','LAMBAS SINAGA','1080025751877','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('169','3236','PUTU SUDIANTARA','1080025751729','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('170','3237','OBER SAMOSIR','1080025871089','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('171','3238','RENO ROMANSYA','1080025927683','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('172','3239','NADILA AULIA','1080025596819','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('173','3240','PANDI PADANG','1080025874844','Bank Mandiri','-','-','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_bank_accounts VALUES('174','3241','HIDAYAH RAMADHAN YUSUF','1080024546427','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('175','3242','TEGOR RAHMAN SAPUTRA','1080023424279','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('176','3243','ABIB PRASTIKO','1080023424220','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('177','3244','KINDY AKHMAD TITO','1840000705143','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('178','3245','TAUFIQURRAHMAN','1080023953814','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('179','3246','JUBAIR AL KUDRI','1080020061116','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('180','3247','Agielfitriadi','1080015910343','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('181','3248','Rici Sumanta','1080023053763','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('182','3249','RAHMAT WAL HIDAYAH','1080023771620','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('183','3250','Adi Sulistio','1630002006404','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('184','3251','SAIRUDIN','1020009949899','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('185','3252','EDO PRAYOGI','1070018440364','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('186','3253','ARIO M FATHONAH','-','Bank Mandiri','-','-','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_bank_accounts VALUES('187','3254','Pandu Wijaya Pratama','1080023115018','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('188','3255','Nofi Maryo Handa','1080007993927','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('189','3256','ALANDINO SUANDI','1080024019524','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('190','3257','HERMANTONI','1100016831627','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('191','3258','CINDY FAUZIAH','1080023497309','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('192','3259','AA SUGANDA','-','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('193','3260','MAMAN ROSANA','-','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('194','3261','Engkus Kusnadi','-','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('195','3262','Dayat','-','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('196','3263','Sartono','-','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('197','3264','KAMALUDIN','-','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('198','3265','MUHAMMAD RIDO','-','Bank Mandiri','-','-','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_bank_accounts VALUES('199','3266','DIKRY FIRMAN MAULANA','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('200','3267','DADI','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('201','3268','MUHAMMAD ADE SYAPUTRA','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('202','3269','HERMAN','1080015120687','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('203','3270','UCUP MUNANDAR','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('204','3271','SUNARYO','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('205','3272','RIQKY ANDIKA','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('206','3273','Enur Nurdin','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('207','3274','AEP SAEPUDIN','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('208','3275','EPUL','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('209','3276','TEDY FIRMANSYAH','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('210','3277','SANDI ARDIANSAH','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('211','3278','SUNARYA','-','Bank Mandiri','-','-','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_bank_accounts VALUES('212','3279','ASEP RAHMAT','-','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('213','3280','AHMAD FAHRUROZI','-','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('214','3281','Zikra','1120021175109','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('215','3282','Deni Warman','1080022950373','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('216','3283','EBY ARDO HUTASOIT','1080023555825','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('217','3284','BOY SANDY','1080026360660','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('218','3285','HENDRI MULYANTO','1080026316118','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('219','3286','M. ARIEL AGUSTIAN','1080026361106','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('220','3287','MULYADI','1080025905713','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('221','3288','WAHYU LAKSANA','1120021063271','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('222','3289','IRVAN','1080026360751','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('223','3290','YUDO YENSI','1080026360504','Bank Mandiri','-','-','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_bank_accounts VALUES('224','3291','ROPI NIKO','1080026358359','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('225','3292','RAMA','1080026331752','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('226','3293','SUKARI','-','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('227','3294','DEPIS ARDIANSYAH','-','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('228','3295','RIDWAN','-','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('229','3296','NOPRIADI','1080026798398','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('230','3297','Suparta Simanjuntak','1080019344051','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('231','3298','MECHAEL YACOB SARAGIH','1080023473656','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('232','3299','Eduard Tamba','-','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('233','3300','Poltak Halomoan Situmorang','-','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('234','3301','Ismail','1080016480924','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('235','3302','Darwis M','1080023230676','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('236','3303','HERDIANTO','1080023484075','Bank Mandiri','-','-','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_bank_accounts VALUES('237','3304','Dedek Syaputra','1080018838467','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('238','3305','Ramadhan','9000034613076','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('239','3306','YURISMAN','1080022963541','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('240','3307','Rudi Waluyo','1080015271308','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('241','3308','Solihin Nasution','1830001445344','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('242','3309','Darman Pardosi','1080018776600','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('243','3310','HANAFI ZUHRA','1080024014939','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('244','3311','DARLAN SIANTURI','1840001284502','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('245','3312','UNDANG SOPYAN','-','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('246','3313','Shintia Raminda','1080023111553','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('247','3314','RIGA APRILA','1080023221220','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('248','3315','Indra Huda','1130015832524','Bank Mandiri','-','-','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_bank_accounts VALUES('249','3316','Suyono','1080013210423','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('250','3317','JENTRISMEN FRANSISKUS HASUGIAN','-','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('251','3318','MUHAMMAD AGI SATRIA','1080023776199','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('252','3319','Lasman Simbolon','1080017940264','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('253','3320','Aldi Pratama','1080020793858','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('254','3321','ZULFIKRI','1080023433551','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('255','3322','Selamat Aritonang','9000010223981','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('256','3323','SAMUEL SITORUS','1080023871123','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('257','3324','Iwan Kaswari','1080021755328','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('258','3325','Muhammad Eka Azhari','1080020805876','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('259','3326','GOSPEL SIMANJUNTAK','1070018513517','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('260','3327','Wawan Setiawan','-','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('261','3328','Putri Arta Manullang','1080022774229','Bank Mandiri','-','-','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_bank_accounts VALUES('262','3329','Saino','1110018702676','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('263','3330','Nurkhairani Octavia','1080023230742','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('264','3331','Johan Dodi','9000032116643','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('265','3332','Soala Roha','1080016835309','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('266','3333','Indra Kurniawan','1080017974123','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('267','3334','ELIAKIM GULTOM','1070018466328','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('268','3335','Aten Wawan Kusuma','-','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('269','3336','Didi Prabowo','-','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('270','3337','ASWIN RIVADIANSYAH','1120015382075','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('271','3338','RICKO HENDRI PARNINGOTAN MARPAUNG','1050017153309','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('272','3339','TAUFIK ANANTA S','1130004845016','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('273','3340','Budi Sofyan Girsang','1080005354718','Bank Mandiri','-','-','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_bank_accounts VALUES('274','3341','REXY GURUH SAPUTRA','1080024082852','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('275','3342','Isra Alfarizi','1070016073647','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('276','3343','Nasirun','1080022479530','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('277','3344','Bizar','1080023152037','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('278','3345','Herry Suryadi','1110010424600','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('279','3346','Ariyanto','1080021805552','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('280','3347','Yusron','1080021773404','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('281','3348','Muhaiminul Aziz','1630002055948','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('282','3349','Mudahar','1080014910773','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('283','3350','ANDRIAN ARIPIN','1080023418297','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('284','3351','Herman Sofyan','9000036238377','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('285','3352','Agung Nugroho','1080013731048','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('286','3353','Jumedi Budiman','1080021774568','Bank Mandiri','-','-','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_bank_accounts VALUES('287','3354','MAULAYA SIDDIK PURBA','1070018350795','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('288','3355','Juma\'ah','1120018137930','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('289','3356','Edi Derianto','1080012594033','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('290','3357','Muhammad Amri','1830002306586','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('291','3358','Rudolf Lumban Tobing','1080022710207','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('292','3359','AHMAD DUANI','1080023068340','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('293','3360','MUSLIM SAHRONI SIHOMBING','1080024267867','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('294','3361','HARIMAN','1080024341407','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('295','3362','Adim','1080023166987','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('296','3363','Kristiwan Silitonga','1080021801585','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('297','3364','Aidiel Anry','1080021757639','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('298','3365','Charles Fernando','1080020559697','Bank Mandiri','-','-','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_bank_accounts VALUES('299','3366','Goklin Sibarani','1080022721139','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('300','3367','FAIS HEJRI','1080023380174','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('301','3368','MARUNTUNG TAMBA','1080023375760','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('302','3369','Emil Suganda','-','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('303','3370','AI SAADAH','-','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('304','3371','HAPOSAN DAMANIK','1080024510431','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('305','3372','REZA ANDHY FAUZI','1550012320217','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('306','3373','Ahmad Imam Rafsanjanya','-','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('307','3374','FAISAL','-','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('308','3375','DIDIT HARYANTO','-','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('309','3376','Muhammad Safi\'i','-','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('310','3377','Berlin Marbun','1080022564059','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('311','3378','Farhan Gusfadillah','1080019733675','Bank Mandiri','-','-','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_bank_accounts VALUES('312','3379','PANJI ANGGRIO','1130016020368','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('313','3380','Jeprianto','1080019105411','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('314','3381','Renaldo AL','1080005286258','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('315','3382','ROBY SAMUEL','1720004075547','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('316','3383','SUFEBRIANTO','1120019096762','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('317','3384','Ino Resi Parno','1120011098857','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('318','3385','Ahmad Isa','9000013178455','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('319','3386','JUPRINDO MANULANG','-','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('320','3387','HOLMES SINAGA','-','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('321','3388','RUDI HARTONO PANJAITAN','1080023998918','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('322','3389','DODO','-','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('323','3390','ANGGA ARINANDA','1080024900632','Bank Mandiri','-','-','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_bank_accounts VALUES('324','3391','Bina Suryani','1080016559107','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('325','3392','AZMANDA','1080017439358','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('326','3393','ADANG','-','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('327','3394','Paisal Hakim','-','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('328','3395','TONI NUGRAHA','-','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('329','3396','Suryadi','1080024761125','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('330','3397','AMRIH WIBOWO','1120015382562','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('331','3398','BAGANDA TUA SIANTURI','1050016986444','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('332','3399','ANKE RIFALDI','1120020932369','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('333','3400','Roi Hotasi Siallagan','1070014315487','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('334','3401','Liman Boston Silaban','1080022741947','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('335','3402','Ikhma Kurniawan','1120017846184','Bank Mandiri','-','-','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_bank_accounts VALUES('336','3403','SIMON SILABAN','1080024022692','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('337','3404','AMOS BUTAR BUTAR','1080024511660','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('338','3405','PARNINGOTAN BUTAR BUTAR','1080024953557','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('339','3406','Tommi Erikson Tambunan','1080014371463','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('340','3407','Indra Gunawan Hasibuan','1060013555068','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('341','3408','Bena Adiningtias','1080022693080','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('342','3409','Cecep Hermawan','1120011216830','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('343','3410','IRMANSYAH','1080026226424','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('344','3411','Zulham','1830000095710','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('345','3412','MHD. FADLAN','1080026208018','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('346','3413','EDY SUSANTO','-','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('347','3414','Hartono Siburian','-','Bank Mandiri','-','-','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_bank_accounts VALUES('348','3415','NUR IKHSAN','1130016623401','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('349','3416','Alif Fauzan','1080020457215','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('350','3417','ARON RAYMOND P','-','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('351','3418','Anggi Firdaus Ernawan','1080021791794','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('352','3419','ADIBAH HASNAH','1080026368846','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('353','3420','Toni Mardiyan','1830000959527','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('354','3421','DANIEL MARPAUNG','-','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('355','3422','NICHO ADITYA SYAHPUTRA. N','-','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('356','3423','EDI CHANIAGO SITORUS','-','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('357','3424','Daseng Suherman','-','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('358','3425','Puji Pidiyanto','-','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('359','3426','M ADAM BRAMASTA','-','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('360','3427','METHA LEUEKA','-','Bank Mandiri','-','-','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_bank_accounts VALUES('361','3428','SYAHRIZAL POHAN','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('362','3429','Sihol Manurung','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('363','3430','Hotbel Silaban','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('364','3431','ADI KUSUMA','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('365','3432','DADANG SURYANA','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('366','3433','IRFAN JAYANTO','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('367','3434','DWI AFRIASTOMO ARBI','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('368','3435','SUDARMONO','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('369','3436','ANDRY DEL PIERO SIMBOLON','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('370','3437','AFRI FAHRURAZI','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('371','3438','MARAJOHAN P.ARITONANG','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('372','3439','JEFRY SIHOMBING','-','Bank Mandiri','-','-','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_bank_accounts VALUES('373','3440','CANDRA SILITONGA','1080026541376','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('374','3441','AIDIL AMALI','1080026551177','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('375','3442','MUHAMMAD KHAIRUL AMBRI','1080026548033','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('376','3443','UJANG EKO SAPUTRA','1080026552217','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('377','3444','AFRIZAL','1080023236806','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('378','3445','ANDRI ROZA','1080023311039','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('379','3446','ARMANSYAH','1510007587246','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('380','3447','JEFRI AGUSTONO PANGARIBUAN','1080023405310','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('381','3448','SOPANDI','1080023881395','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('382','3449','T FAJRI','1080023865190','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('383','3450','M RIDHO KURNIAWAN','1080024760242','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('384','3451','EDI SETYAWAN','1080024691934','Bank Mandiri','-','-','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_bank_accounts VALUES('385','3452','Martomu Sihombing','1080021733036','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('386','3453','SYAHRIAL','9000016847965','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('387','3454','MIKES SUWANDI','1080024767957','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('388','3455','WINANTO','1080023156483','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('389','3456','EDI WARDANI','1830000480482','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('390','3457','KRISTIAN VIERIANTO SIMAREMARE','1080023852271','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('391','3458','Arif Rahman Setia Ramadani','1100006877705','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('392','3459','Torkis Rangkuti','1080005355061','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('393','3460','SALAMUN','1080023801377','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('394','3461','Paisal Nasution','1080018848672','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('395','3462','YUS MELANIE SIRAIT','1060015108494','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('396','3463','JOHAN TUA PANJAITAN','-','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('397','3464','ERIJAL MARBUN','-','Bank Mandiri','-','-','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_bank_accounts VALUES('398','3465','SENTOSA GEA','-','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('399','3466','WAHYU WIDODO','-','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('400','3467','PEPI SOPIAN','-','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('401','3468','MUHAMMAD DANIL','-','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('402','3469','Abdul Rahmansyah','-','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('403','3470','Bambang Budianto','-','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('404','3471','Zulham Effendi','-','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('405','3472','EDI SYA PUTRA','1830003070314','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('406','3473','ALFINO EKO NANDA','1080024773856','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('407','3474','ASTIAN','1080023967848','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('408','3475','DECKY CANDRA PRAYOGI','1080024777048','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('409','3476','DWIKI FEBRIANANDA','1080024773799','Bank Mandiri','-','-','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_bank_accounts VALUES('410','3477','FARHAN WALID','1110020521908','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('411','3478','HERMAN','1110019235775','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('412','3479','IRFAN SAPUTRA','1110019234604','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('413','3480','WAHYUDI ALFITRA','1080023315774','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('414','3481','YULIUS HALAWA','1080023541916','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('415','3482','ZULHAM','1080023967962','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('416','3483','Sugiyanto','1080004876992','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('417','3484','Jarwin Silaban','1080018355975','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('418','3485','Abu Bakar Sidik','1070012086270','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('419','3486','Sugun Raharjo','1850003130025','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('420','3487','MARIHOTTUA S','1080020382710','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('421','3488','Zulfahmi','1120010872856','Bank Mandiri','-','-','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_bank_accounts VALUES('422','3489','JEKKY AGUSTA ARITONANG','1080025653719','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('423','3490','MUHAMMAD ERLANGGA','1120020572793','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('424','3491','IKA GUSTIAWAN','1080025808420','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('425','3492','Bastian Sibarani','1080020477189','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('426','3493','Muhammad Febri','1080021775185','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('427','3494','Mangatur Hutauruk','1080022993175','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('428','3495','Rendra Maresta','1080022895115','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('429','3496','Faudri Amhal','1830002751807','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('430','3497','WILLY WAHYUDI','1120018762224','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('431','3498','FAUZAN','1630006132578','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('432','3499','Bayu','1080021775243','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('433','3500','MUHAMMAD KHADAFFI A','1080025825515','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('434','3501','BAYANUDIN','-','Bank Mandiri','-','-','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_bank_accounts VALUES('435','3502','UUN','-','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('436','3503','Amin Rosidin','-','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('437','3504','RETNO PRANATA SINAGA','-','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('438','3505','DASRIL A','-','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('439','3506','RAHMAD NURHIDAYAT','-','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('440','3507','Asep Mulyana','-','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('441','3508','LEDYANA MANALU','-','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('442','3509','Junansi Gultom','-','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('443','3510','Patar Sianipar','-','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('444','3511','ALIAMSAH TINAMBUNAN','-','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('445','3512','JEKI','1080023439335','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('446','3513','SUHARTO','1080023870885','Bank Mandiri','-','-','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_bank_accounts VALUES('447','3514','DERA ALFINDI','1080023718316','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('448','3515','DHIKA PRASETYO','1080023715478','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('449','3516','IRWAN MANALU','1080022752829','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('450','3517','IRWAN SULFAN','1080025099657','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('451','3518','JAMRES TOGATOROP','1080024525421','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('452','3519','JULIASKA','1080016511066','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('453','3520','MARTUA PARLAGUTAN HUTAPEA','1070018390114','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('454','3521','MASLAN ARITONANG','1080024021942','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('455','3522','RIZKI WANDA TAMBUNAN','1070010853564','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('456','3523','Sapi\'i','1080020573672','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('457','3524','Wendi Nurwandani','1080023011472','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('458','3525','Firdaus','1080020547593','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('459','3526','Sutino','9000012852191','Bank Mandiri','-','-','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_bank_accounts VALUES('460','3527','KADRI RAHMAD','1080024696974','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('461','3528','MEDRI YANTO','1080024491202','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('462','3529','YOHANES PURNOMO ADI','1080024625080','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('463','3530','Amin','1120010805419','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('464','3531','Saut Tua','1080023038368','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('465','3532','RUDI HAMKA PASARIBU','1080023502546','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('466','3533','HASANUDDIN HASIBUAN','1080023481774','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('467','3534','VIKI ARDIANSYAH','1080024768369','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('468','3535','VICTOR GULTOM','1080023861769','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('469','3536','Hiskia Munthe','1080016985963','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('470','3537','NASRO DAMANIK','1080023409734','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('471','3538','FADLIL ABDULLATIF','1080024705411','Bank Mandiri','-','-','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_bank_accounts VALUES('472','3539','MARDI','1080023698831','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('473','3540','ILHAM HANAFI','1830002891272','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('474','3541','ISKANDAR MUDA','1720003482686','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('475','3542','MUHAMMAD KHAIDIR','1080022793955','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('476','3543','EDY KURNIAWAN','1080023841373','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('477','3544','ADEN ARZONA','1080023998975','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('478','3545','Bezalel Pandiangan','1080025340077','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('479','3546','HAMIDI','1080023984645','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('480','3547','ANTON','1080023998280','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('481','3548','MEMET','1080025143364','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('482','3549','DEDI APRIANTO','1080024050198','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('483','3550','ALEX LEONARDO SIPAYUNG','1070019204777','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('484','3551','RUDI CHARIANTO','1080023340558','Bank Mandiri','-','-','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_bank_accounts VALUES('485','3552','DANIEL SYAPUTRA PANDIANGAN','1080025062549','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('486','3553','ANING HIDAYATULLOH','1080024005721','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('487','3554','Pantas Silitonga','1060012961044','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('488','3555','Apit Hariadi','1080016623929','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('489','3556','Aspiner Pasaribu','1080020544574','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('490','3557','BUNSAWAN','1080024186737','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('491','3558','Antoni Manalu','1080022603147','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('492','3559','Daniel Togi Parulian Tampubolon','1080022703889','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('493','3560','Darno Manalu','1080019992685','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('494','3561','DEDEK','1080023984918','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('495','3562','FITRAH HIDAYAT','1100017135861','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('496','3563','James Purba','1080023116818','Bank Mandiri','-','-','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_bank_accounts VALUES('497','3564','Lili Budi Hartono','9000034064270','Bank Mandiri','-','-','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_bank_accounts VALUES('498','3565','MARULI TUA','1720004513547','Bank Mandiri','-','-','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_bank_accounts VALUES('499','3566','Ronal Sinaga','1720001589821','Bank Mandiri','-','-','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_bank_accounts VALUES('500','3567','Wendi','1630002516899','Bank Mandiri','-','-','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_bank_accounts VALUES('501','3568','Lamres Sinambela','1080014039706','Bank Mandiri','-','-','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_bank_accounts VALUES('502','3569','JAMOT NOVEN TOGATOROP','1070018429839','Bank Mandiri','-','-','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_bank_accounts VALUES('503','3570','PAIAN BATUARA','1080023424535','Bank Mandiri','-','-','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_bank_accounts VALUES('504','3571','SAMSUL','1090015543515','Bank Mandiri','-','-','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_bank_accounts VALUES('505','3572','DAVID SIMANJUNTAK','1080023861579','Bank Mandiri','-','-','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_bank_accounts VALUES('506','3573','TEGUH SYAIDINA ALI','1080023540058','Bank Mandiri','-','-','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_bank_accounts VALUES('507','3574','RIO MANOGI ULI SIREGAR','1080023542401','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('508','3575','JONES SIBURIAN','1080024196249','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('509','3576','CHANDRA S','1080023829998','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('510','3577','GABRIEL PRISMAN','1720003869452','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('511','3578','FAISAL','1080024036742','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('512','3579','IBNU HAJAR','1490012985166','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('513','3580','EDWAR','1110022177477','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('514','3581','BENY SAPUTRA','1080026814559','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('515','3582','Bahrum Efendi','1080012517752','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('516','3583','Polmat Rumabutar','1080015689301','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('517','3584','IWAN TAMPUBOLON','1070017825029','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('518','3585','Elron Pasaribu','1080023107775','Bank Mandiri','-','-','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_bank_accounts VALUES('519','3586','Elris Ganiel Pasaribu','1080023114615','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('520','3587','T. Saiful Bahri','9000022107297','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('521','3588','Nofi Sasmita','1080023120711','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('522','3589','Kadim Anggiat M Hutabarat','1080018772484','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('523','3590','Kaab Lubis','1080026745142','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('524','3591','Frando Nababan','1070016985956','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('525','3592','Dodi Hutapea','1080023037519','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('526','3593','Ari Kristianto S','1720003195270','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('527','3594','Partomuan Tampubolon','1080020478013','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('528','3595','STEVEN ANDRYANUS SINURAT','1070018474280','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('529','3596','Sidokmauliate Reynaldo Sinaga','1080020725033','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('530','3597','ARIHTA SUKOCO SEMBIRING','1080025846909','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('531','3598','ABDUL ROHIM','1080014629449','Bank Mandiri','-','-','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_bank_accounts VALUES('532','3599','AMALI ALMI PRATAMA','1080024682743','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('533','3600','FAISAL THOLIB','1080024697725','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('534','3601','Anggiat Tampubolon','1080018731142','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('535','3602','MUHAMMAD PUTRA PRATAMA','1080023167449','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('536','3603','Pantri Manalu','1120010835283','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('537','3604','HAFIDZ APRIYANSYAH','1080023817605','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('538','3605','Despi Yunardi','1090017049867','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('539','3606','RAVENZA ZAKKY SAPUTRA','1080023871925','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('540','3607','Besron Naibaho','1080005721981','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('541','3608','Aidil Raka','1080019712794','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('542','3609','Josua Gultom','9000004688801','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('543','3610','Grant Samuel Samosir','1080018832536','Bank Mandiri','-','-','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_bank_accounts VALUES('544','3611','REZA CAHYADI','1080023440200','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('545','3612','VINERA TASYA','1050015618980','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('546','3613','AIDIL FADILLAH','1110020502858','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('547','3614','AYU SITI CHOTIJAH','1080016114028','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('548','3615','BOBY ARINATA PANJAITAN','1830004705694','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('549','3616','AHMAD ALDI MARPAUNG','1830004211891','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('550','3617','HABIBI AMIN','1080023366132','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('551','3618','Jefri Pernando Sitorus','1080020368172','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('552','3619','Apfit Putra Perdana','1410012754388','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('553','3620','SANDHY HARWADHY','1330012450789','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('554','3621','Ahmad ','1080015175053','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('555','3622','ADE CANDRA','1080010692268','Bank Mandiri','-','-','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_bank_accounts VALUES('556','3623','Bambang Lestiono','1460013251835','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('557','3624','INDRA MURDANI','1080025914194','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('558','3625','ROZIMAN','1080025855181','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('559','3626','ANGGI RESTU PRASETYA','1100017549681','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('560','3627','MARUDUT B.U SITUMORANG','1080026846189','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('561','3628','RIDWAN FIRMAN RUMABUTAR','1080026853169','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('562','3629','RUDOLF SILALAHI','1080026846551','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('563','3630','YOGI LOLENSA','1780005745498','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('564','3631','ARDIANSYAH','1080026853250','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('565','3632','YUSTONI MARIPUL PANDIANGAN','1080026888041','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('566','3633','ABDUL RAHMAN','1590005516249','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('567','3634','HANDHIKA HUTASOIT','1830004265780','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('568','3635','PALIT TNJ','1080023318166','Bank Mandiri','-','-','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_bank_accounts VALUES('569','3636','AMUNG SUNARYA','1080026931411','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('570','3637','TANWIR LUBIS','1830002872645','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('571','3638','AIDIL RIZKI','1080026854290','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('572','3639','ZAMNURDIN MA\'ARIF AL GHAFFAR','1400019777433','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('573','3640','NAPTALIS PEDROY MALAU','1080026944844','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('574','3641','HASIHOLAN LUMBAN TOBING','1080026665779','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('575','3642','Arman','1080026877101','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('576','3643','EDI SUMARDI','1080026856147','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('577','3644','JONSON MANGUNSONG','1080025846867','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('578','3645','WAWAN SETYAWAN','1080026897703','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('579','3646','JULHANUDDIN SIMATUPANG','1080026862640','Bank Mandiri','-','-','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_bank_accounts VALUES('580','3647','YANRI','1070020349561','Bank Mandiri','-','-','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_bank_accounts VALUES('581','3648','IHSAN HABIB ANDIKA','1080026879800','Bank Mandiri','-','-','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_bank_accounts VALUES('582','3649','ALVINDRA FEBRINO','1080026513839','Bank Mandiri','-','-','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_bank_accounts VALUES('583','3650','LUPIANTO','-','Bank Mandiri','-','-','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_bank_accounts VALUES('584','3651','ABENI LASE','-','Bank Mandiri','-','-','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_bank_accounts VALUES('585','3652','MUHAMMAD TAUPIK','-','Bank Mandiri','-','-','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_bank_accounts VALUES('586','3653','GUSRIANSAH','-','Bank Mandiri','-','-','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_bank_accounts VALUES('587','3654','ARNANDA AFRIZA','-','Bank Mandiri','-','-','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_bank_accounts VALUES('588','3655','HERMON','-','Bank Mandiri','-','-','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_bank_accounts VALUES('589','3656','ENCENG','-','Bank Mandiri','-','-','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_bank_accounts VALUES('590','3657','INDRA GUNAWAN','-','Bank Mandiri','-','-','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_bank_accounts VALUES('591','3658','RUHIYAT','-','Bank Mandiri','-','-','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_bank_accounts VALUES('592','3659','EVI HANAFIAH','-','Bank Mandiri','-','-','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_bank_accounts VALUES('593','3660','Chandra OP Sunggu','1080022552948','Bank Mandiri','-','-','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_bank_accounts VALUES('594','3661','KISWAN IBRAHIM SIREGAR','1080024945280','Bank Mandiri','-','-','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_bank_accounts VALUES('595','3662','ANNAS HABEAHAN','1080027023135','Bank Mandiri','-','-','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_bank_accounts VALUES('596','3663','MARHASIL SIGALINGGING','1080024040520','Bank Mandiri','-','-','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_bank_accounts VALUES('597','3664','THEO RANGGA HEKSA','1080026241472','Bank Mandiri','-','-','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_bank_accounts VALUES('598','3665','MUHAMMAD AFRIZAL TANJUNG','1080027000448','Bank Mandiri','-','-','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_bank_accounts VALUES('599','3666','NIKE WIRANTI','1120012955147','Bank Mandiri','-','-','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_bank_accounts VALUES('600','3667','FAIRUS OKTOBRIZKY SIPAHUTAR','1070016095038','Bank Mandiri','-','-','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_bank_accounts VALUES('601','3668','LONI AGUSTIN','1080022717954','Bank Mandiri','-','-','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_bank_accounts VALUES('602','3669','MUHAMMAD INDRAJID A','1080027004440','Bank Mandiri','-','-','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_bank_accounts VALUES('603','3670','WILMAR OP.SUNGGU','1290014222570','Bank Mandiri','-','-','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_bank_accounts VALUES('604','3671','ESTER VIRGINIA SIHOMBING','1080023817886','Bank Mandiri','-','-','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_bank_accounts VALUES('605','3672','SURYADI ARIPAN SEJUK','1080023944029','Bank Mandiri','-','-','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_bank_accounts VALUES('606','3673','Ahmad Dirjan','1080017748204','Bank Mandiri','-','-','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_bank_accounts VALUES('1035','4280','Siswandi','1080021311106','MANDIRI','-','-','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_bank_accounts VALUES('1036','4281','Hamzah Sayap','1560021506565','MANDIRI','-','-','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_bank_accounts VALUES('1037','4282','Berri Pratama','1210010254708','MANDIRI','-','-','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_bank_accounts VALUES('1038','4283','Yohana Rede','1480020924620','MANDIRI','-','-','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_bank_accounts VALUES('1039','4284','Moh. Ridwan Virgiawan','1490016219968','MANDIRI','-','-','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_bank_accounts VALUES('1040','4285','Linda Waty','1490016258834','MANDIRI','-','-','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_bank_accounts VALUES('1041','4286','Arisman','1490014438537','MANDIRI','-','-','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_bank_accounts VALUES('1042','4287','Junior Dedi Sukanto S','9000019147512','MANDIRI','-','-','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_bank_accounts VALUES('1043','4288','Tuppal Pangaribuan','1080017119414','MANDIRI','-','-','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_bank_accounts VALUES('1044','4289','Dahlan','1080015259436','MANDIRI','-','-','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_bank_accounts VALUES('1045','4290','Adam Malik','1490014511481','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1046','4291','Erizon','1080014495338','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1047','4292','Gus Amin','1120005044396','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1048','4293','Karina Andria Putri','1330027443381','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1049','4294','Syahtullah','1490016582050','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1050','4295','Ujang','1080010278977','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1051','4296','Wiwin Saputra','1120010961121','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1052','4297','M  Shobri','1120011045239','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1053','4298','Afni Efendi','1120016139409','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1054','4299','Ari Pratama','1080022554704','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1055','4300','Sukri Yanto','1120015514446','MANDIRI','-','-','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_bank_accounts VALUES('1056','4301','Zulkifli','1120011209884','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1057','4302','Mimi Susanto','1490007135777','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1058','4303','Ari Saputra','9000031414668','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1059','4304','Ahmad Fadhlillah Mahsun','1370022906669','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1060','4305','Sudarmo','1080013898284','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1061','4306','Rijalul Rahman Hakim','1080020941994','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1062','4307','Riovani Sinaga','1070018855538','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1063','4308','Juliaddin','1080094071793','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1064','4309','Yogi Merio Dili','1080018340241','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1065','4310','Suman','1490016396071','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1066','4311','Widi Pratama','1490015745476','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1067','4312','Arjamis','1490016413561','MANDIRI','-','-','','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_bank_accounts VALUES('1068','4313','Dadang','1490016415996','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1069','4314','Nurhadi','1340026588938','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1070','4315','Diki Priyatna','1340023061954','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1071','4316','Desanto','1330016834178','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1072','4317','Tarsiman','1340026617109','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1073','4318','Warto','1340023271082','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1074','4319','Rosikin','9000031160170','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1075','4320','Syahidullah','1380023451383','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1076','4321','Dwi Sampurno','1840000413573','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1077','4322','Alek Sander','1130016193694','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1078','4323','Widnu Wira Setia','1080024532021','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1079','4324','Musni Hadi','-','MANDIRI','-','-','','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_bank_accounts VALUES('1080','4325','Nur Arifin','1340023568164','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1081','4326','Dedi Pernandi','1340026646371','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1082','4327','Daspunah','1340026623487','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1083','4328','Herudin','1340026627488','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1084','4329','Kusnita','1340026631365','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1085','4330','Endang Supriatno','1340026617471','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1086','4331','Mukhlisin','1490016582019','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1087','4332','Dedi Triasmoro','1340026629963','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1088','4333','Mukti','1140024902465','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1089','4334','Arnold Indra Lesmana P','1080022909577','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1090','4335','Abri Paswanto','1110018214102','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1091','4336','Ahmad Pasaribu','1080023884464','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1092','4337','Albert Fernando Saragih','1060015648978','MANDIRI','-','-','','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_bank_accounts VALUES('1093','4338','Budi Herianto','1080024682834','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1094','4339','Henrikus Simanihuruk','1080025680118','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1095','4340','Jefri Harison','1720003564921','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1096','4341','Nanda Kusuma Yudha Sitorus','1080024205362','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1097','4342','Tri Sabdo Bahaduri','1080024209208','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1098','4343','Berlin Laurencus Sinaga','1070012418184','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1099','4344','Adi Surya','1490015881065','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1100','4345','Adri Oktoni','1080016562820','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1101','4346','Agung Setiawan','1080018736794','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1102','4347','Kiki Mahmudi','1080018117904','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1103','4348','Manat Silaban','1080019103002','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1104','4349','Marihot Silitonga','1080018753161','MANDIRI','-','-','','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_bank_accounts VALUES('1105','4350','Marulitua Lumbanraja','1080023419477','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1106','4351','Wahyudi','1080020842598','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1107','4352','Yunus Radianto Wensly','9000032409592','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1108','4353','Evlin Ramadhona Prabel','1690001214193','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1109','4354','Bagus Prabowo','1080016447022','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1110','4355','Rosanti Br Panggabean','1490016546568','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1111','4356','Akhir Subuh Hasibuan','1830000386630','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1112','4357','Aliftha Adrian Maulana','1820012511515','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1113','4358','Ardoni Idris','1340016968710','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1114','4359','Unggul Pribadi','9000033710857','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1115','4360','Eka Wahyu Bin Husin','1080016409543','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1116','4361','Fahrum','1080023228159','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1117','4362','Heru Merio Dilli','1080025884363','MANDIRI','-','-','','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_bank_accounts VALUES('1118','4363','Junaidi','1080023321475','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1119','4364','Leo Candra','1490016582035','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1120','4365','Leprandi','1440018417029','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1121','4366','M. Rizki Al-Khani','1490016582043','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1122','4367','Mahyudin','1130018267207','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1123','4368','Ramli','1490016519573','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1124','4369','Yayat Maulana','1120015543262','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1125','4370','Safri','9000032624216','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1126','4371','Setiawan','1120017708798','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1127','4372','Dedi Aprianto','9000030643119','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1128','4373','Sulistyo Indarto','-','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1129','4374','Ruber J Pandiangan','1120011327058','MANDIRI','-','-','','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_bank_accounts VALUES('1130','4375','Budi','1490016582068','MANDIRI','-','-','','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_bank_accounts VALUES('1131','4376','Reski Amalia','1480016012117','MANDIRI','-','-','','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_bank_accounts VALUES('1132','4377','Ismail. B','1490016507891','MANDIRI','-','-','','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_bank_accounts VALUES('1133','4378','Mustaqiem Karyani','9000035743443','MANDIRI','-','-','','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_bank_accounts VALUES('1134','4379','Andira Gardenia','1490015334107','MANDIRI','-','-','','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_bank_accounts VALUES('1135','4380','Yanto Emel Pasaribu','9000034172115','MANDIRI','-','-','','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_bank_accounts VALUES('1136','4381','Doni Jhonson. H','1080024505191','MANDIRI','-','-','','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_bank_accounts VALUES('1137','4382','Andreas Gonazaga Rumahorbo','1080024542509','MANDIRI','-','-','','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_bank_accounts VALUES('1138','4383','Wahyu Haikal','1080023980619','MANDIRI','-','-','','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_bank_accounts VALUES('1139','4384','Jeklin Ariman Rajagukguk','1080025084782','MANDIRI','-','-','','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_bank_accounts VALUES('1140','4385','M. Romadhon Oki Riansyah','1490016591325','MANDIRI','-','-','','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_bank_accounts VALUES('1141','4386','Ade Syahputra','1080023117287','MANDIRI','-','-','','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_bank_accounts VALUES('1142','4387','Desinta Dian','1080023855530','MANDIRI','-','-','','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_bank_accounts VALUES('1143','4388','Soniya Elsa Sanzany Pardede','1070017757644','MANDIRI','-','-','','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_bank_accounts VALUES('1144','4389','Reksi Kurniawan','1080023470611','MANDIRI','-','-','','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_bank_accounts VALUES('1145','4390','Agustinus Sampe','1490016582027','MANDIRI','-','-','','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_bank_accounts VALUES('1146','4391','Wawan Bin Jamsir','1490016322390','MANDIRI','-','-','','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_bank_accounts VALUES('1147','4392','Maurip Malau','9000031160337','MANDIRI','-','-','','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_bank_accounts VALUES('1148','4393','Burhan','1490016710347','MANDIRI','-','-','','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_bank_accounts VALUES('1149','4394','Denny Wanner Siallagan','1490016710339','MANDIRI','-','-','','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_bank_accounts VALUES('1150','4395','Basran','1490014076824','MANDIRI','-','-','','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_bank_accounts VALUES('1151','4396','Arisman Jaya','1620006077093','MANDIRI','-','-','','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_bank_accounts VALUES('1152','4397','Amar Mufid','-','MANDIRI','-','-','','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_bank_accounts VALUES('1153','4398','Tarwin','1560017274087','MANDIRI','-','-','','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_bank_accounts VALUES('1154','4399','Toat','1080025156879','MANDIRI','-','-','','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_bank_accounts VALUES('1155','4400','Durani Nuraini','1340026771781','MANDIRI','-','-','','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_bank_accounts VALUES('1156','4401','Suhasisno','9000030635289','MANDIRI','-','-','','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_bank_accounts VALUES('1157','4402','Alifya Putri Askolani','1010013002330','MANDIRI','-','-','','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_bank_accounts VALUES('1158','4403','Ahmad Kholil','1080024302581','MANDIRI','-','-','','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_bank_accounts VALUES('1159','4404','Roby Santoso','1490015307509','MANDIRI','-','-','','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_bank_accounts VALUES('1160','4405','Ryan Ohara Saragi Turnip','1080023068068','MANDIRI','-','-','','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_bank_accounts VALUES('1161','4406','Binsar Parulian Sihombing','1080023654867','MANDIRI','-','-','','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_bank_accounts VALUES('1162','4407','Kevin Sijabat','1080025099475','MANDIRI','-','-','','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_bank_accounts VALUES('1163','4408','Ariyan Hidayat','1080025065617','MANDIRI','-','-','','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_bank_accounts VALUES('1164','4409','Haidir','1080025065633','MANDIRI','-','-','','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_bank_accounts VALUES('1165','4410','Faisal','1080023698096','MANDIRI','-','-','','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_bank_accounts VALUES('1166','4411','Marulam Hasudungan Marbun','1070013770112','MANDIRI','-','-','','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_bank_accounts VALUES('1167','4412','Ricky Octa Putra Pratama','1080022849526','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1168','4413','Eko Rianto Rajagukguk','1080023328280','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1169','4414','Diyan Puri Herdiyanto','1210005667161','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1170','4415','Kardyna Nur Afifah','-','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1171','4416','Andri Winoto','1400011333540','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1172','4417','Misbahul Munir','1430030143299','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1173','4418','Moh. Syamsul Anwar','1780016140673','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1174','4419','Suyanto','1780006149062','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1175','4420','Syamsul Arifin','1430026152932','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1176','4421','Taufik Bahanan','1430017501113','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1177','4422','Ahmad Reza','1080016507080','MANDIRI','-','-','','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_bank_accounts VALUES('1178','4423','Deddy Manurung','1070018048126','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1179','4424','Heri Aditya Clinton Sinaga','1080024569700','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1180','4425','Iskandar Muda Siregar','1060013595692','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1181','4426','M. Zikri','1080020836442','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1182','4427','Menak Simanjuntak','1080012153764','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1183','4428','Meri Irawan','1080024326630','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1184','4429','Rolinca Dionsius Sinaga','1080014281969','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1185','4430','Lidia Hellanda Mubiyanto','1080023421127','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1186','4431','Arif Santoso','9000031414742','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1187','4432','Aswanto','1120021429860','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1188','4433','Egianto','1080016108822','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1189','4434','M. Lindu Akbar','1080023832174','MANDIRI','-','-','','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_bank_accounts VALUES('1190','4435','Ristianto','1120019033872','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1191','4436','Yudi','1080020474764','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1192','4437','Budi Hot Tua','1080023015697','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1193','4438','Muhammad Maryandico Irfandresky','1080023095962','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1194','4439','Alwi','1080022693874','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1195','4440','Agus Cahyono','1080018318205','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1196','4441','Wahyu Aditya','1110018230066','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1197','4442','Wahyudi Gunawan Hasibuan','1060013480143','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1198','4443','Marianus Yohanes Edo','1090018767517','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1199','4444','Herwin Hermansyah','1660002158657','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1200','4445','Larson Rianto Manurung','1080025099970','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1201','4446','Amron Parsaoran Hutasoit','1080018859778','MANDIRI','-','-','','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_bank_accounts VALUES('1202','4447','Jetro Medi Lubis','1080024690050','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1203','4448','Rilianta Sitinjak','1080023129472','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1204','4449','Edi Purnama Sigalingging','1080020474335','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1205','4450','Sopian Supriadi Simbolon','1070010748798','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1206','4451','Togap Jadiaman Pane','1080024469174','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1207','4452','Muhammad Edi Yulianto','1080024015035','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1208','4453','Aldi Marselinus Gultom','1080025658635','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1209','4454','Aron Hutasoit','1080025098808','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1210','4455','Masdi','1120015212611','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1211','4456','Tobi Pratama','1860003486723','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1212','4457','Bagas Amunasor','1120019879738','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1213','4458','Despri Sinaga','1080024272750','MANDIRI','-','-','','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_bank_accounts VALUES('1214','4459','Tamryn Hadi Hutagalung','1080023387633','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1215','4460','Sulis Hari Putra Siregar','1080024503964','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1216','4461','Agustian Manurung','1080024273527','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1217','4462','Joslen Simorangkir','1080016670441','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1218','4463','Angga Marelandhi','1120021468611','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1219','4464','Jhonny Maniur Silaban','1080026849027','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1220','4465','Muhammad Ridho','1080024053531','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1221','4466','Pardamean Silalahi','1080026843475','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1222','4467','Govin M','1080021621785','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1223','4468','Riston Naiborhu','1080016455405','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1224','4469','Jhon Franki Pangaribuan','9000031909071','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1225','4470','Ipan Anggara','1690002814223','MANDIRI','-','-','','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_bank_accounts VALUES('1226','4471','Sarivan Demelo','1720001643206','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1227','4472','Rido Ireneus Hasibuan','1080025280398','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1228','4473','Richard Siallagan','1080024201841','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1229','4474','Ray Natanael Silalahi','1490016710313','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1230','4475','Maruli Tua Sinaga','1080024754708','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1231','4476','Herman Putra','1080023030506','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1232','4477','Hasler Matulesi Siallagan','1490016710321','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1233','4478','Brian Rezki O.Manalu','1490016710305','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1234','4479','M. Gries Mount Soeharto','1490016973267','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1235','4480','Sadam Husein','1630007196259','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1236','4481','Saeful Hidayat','1800012160018','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1237','4482','Wahyudi','1560015230446','MANDIRI','-','-','','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_bank_accounts VALUES('1238','4483','Alpian','1490016710388','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1239','4484','Rupinus Surya Gandama Sipayung','1080023744700','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1240','4485','Daslan Silitonga','1080011555324','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1241','4486','Abdul Rajak','-','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1242','4487','Arlina','1490016710404','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1243','4488','Eggyanto Cahya Ramadhan','1270010811741','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1244','4489','Fachri Pratama','1480010484817','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1245','4490','Heri Rachmat','1490014438453','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1246','4491','Syaiful','1490016840573','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1247','4492','Daniel','1490014120820','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1248','4493','Ari Fernanda','1080022952205','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1249','4494','Juliansyah Rhomadani','1490016841126','MANDIRI','-','-','','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_bank_accounts VALUES('1250','4495','Rendy Julfiandar','1490017011810','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1251','4496','Kasmil','1490016840540','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1252','4497','Yoga Rivaldi Lubis','1080026873738','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1253','4498','Teuku Abdurrani','1080019368654','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1254','4499','Romi Nofriansyah','1080025706061','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1255','4500','Muhammad Lutfillah Kurniawan','-','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1256','4501','M Yundra Syaputra','1120013017749','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1257','4502','Nanang Sugandi','1490016840623','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1258','4503','Rizki Dwiputra','1630006374899','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1259','4504','Ahmad Zulkipli','1120018440326','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1260','4505','Benhot Ricardo Pandiangan','1080024206568','MANDIRI','-','-','','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_bank_accounts VALUES('1261','4506','Mananti Simatupang','1070017917792','MANDIRI','-','-','','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_bank_accounts VALUES('1262','4507','Azelansyah','1490016840615','MANDIRI','-','-','','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_bank_accounts VALUES('1263','4508','Muhammad Tomi','1080025458978','MANDIRI','-','-','','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_bank_accounts VALUES('1264','4509','Zekson Tanjung','-','MANDIRI','-','-','','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_bank_accounts VALUES('1265','4510','Mazalan Ambarita','1080025843567','MANDIRI','-','-','','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_bank_accounts VALUES('1266','4511','Rivaldi Syahrul Rozi Hutagalung','1080025852634','MANDIRI','-','-','','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_bank_accounts VALUES('1267','4512','Lamhong Simbolon','1080025871170','MANDIRI','-','-','','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_bank_accounts VALUES('1268','4513','Heru Melano Wardana','1490016841134','MANDIRI','-','-','','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_bank_accounts VALUES('1269','4514','Andi Akram','1490016869895','MANDIRI','-','-','','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_bank_accounts VALUES('1270','4515','Ilham Syahputra','1490015307319','MANDIRI','-','-','','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_bank_accounts VALUES('1271','4516','Douglas Hutabarat','1080024196116','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1272','4517','Andri Pernando Hutapea','1070020398857','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1273','4518','Paiso Hartono','1430030244147','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1274','4519','Junaedi','1430030241218','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1275','4520','Ibon Rizal','1080018859158','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1276','4521','Lisbet Juliker Situmorang','1490017011851','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1277','4522','Riandi','1490014511556','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1278','4523','Andi Pramana Putra','1110022384966','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1279','4524','Aldiansyah','1480022521754','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1280','4525','Andi Saputra Tambunan','1080026939554','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1281','4526','Muh Wahyu','1490017011802','MANDIRI','-','-','','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_bank_accounts VALUES('1282','4527','Eko Rasdani Samosir','1080022708680','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1283','4528','Arman','1700013889922','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1284','4529','Muhamad','1340027114544','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1285','4530','Habibi Hamzah','1340027107266','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1286','4531','Fatikin','1340025402396','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1287','4532','Erwin','1340026573070','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1288','4533','Kusnanto','1340027082279','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1289','4534','Duki Ernawan','1340025448290','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1290','4535','Wahyu Darmawan','1080020426459','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1291','4536','Iqbal Alhadi','1080022485677','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1292','4537','A. Andri','1080025938185','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1293','4538','Hotmarito Sigalingging','1080019992958','MANDIRI','-','-','','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_bank_accounts VALUES('1294','4539','Saragi Jon Hermanto','1490016840508','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1295','4540','Nesi Saifuddin','1080025096182','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1296','4541','Eru Setiawan','1080023900823','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1297','4542','Sandra','1080024088115','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1298','4543','Rolas Silitonga','1080023120091','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1299','4544','Alvin Pratama','1120019635569','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1300','4545','Sujarwo','1120018586862','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1301','4546','Junaidi','1080023091797','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1302','4547','Ersa','1860002144059','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1303','4548','Henra Mt Sihite','1090018086777','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1304','4549','Santoso','1490016840557','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1305','4550','Sumito','1390018758262','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1306','4551','Andi Putra','1340017008342','MANDIRI','-','-','','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_bank_accounts VALUES('1307','4552','Dedy Firmansyah St','1050016275798','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1308','4553','Rahmat Ramadon','1340016961129','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1309','4554','Supriansyah','-','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1310','4555','Hairul','1490016841118','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1311','4556','Muh. Parid','1490016840524','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1312','4557','Andy Prasetya','1800004352672','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1313','4558','Eko Harjianto','1490016771190','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1314','4559','Yayat Perli Yano','1120021540732','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1315','4560','Heri Irawan','1120021540922','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1316','4561','Angga Trisno','1130018461180','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1317','4562','Andeska','1080023990444','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1318','4563','Rizky Simanungkalit','1830004778436','MANDIRI','-','-','','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_bank_accounts VALUES('1319','4564','Jumrik','1080024006307','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1320','4565','Teuku Tariq Aulia','1080026846502','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1321','4566','Saipul','1080026944240','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1322','4567','Gilang Saputra','1080026921156','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1323','4568','Parlagutan Rambe','1080023832232','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1324','4569','Sungkono','1080014851183','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1325','4570','Iwan Darmawan','1490016840482','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1326','4571','Dandi Laide','1490016855480','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1327','4572','Hengky Edison Sitorus','1490016840474','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1328','4573','Yori Anggara','1490016715452','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1329','4574','Hendri Kurniawan','1080014225123','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1330','4575','Ilman Nafian Pasaribu','1080026919689','MANDIRI','-','-','','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_bank_accounts VALUES('1331','4576','Bernard Alen Aritonang','1490017011869','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1332','4577','Bernad M.Manurung','1490017011778','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1333','4578','Suci Nurfajriah','1370016875185','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1334','4579','Arfieawan Bayu Taqwa','1490016834477','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1335','4580','Jafar','1490016598148','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1336','4581','Azis','1490017011745','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1337','4582','Arief Asriyan Noer','1490016985857','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1338','4583','Sumardi Simanungkalit','9000032983216','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1339','4584','Rahmat Yuliandi','1080024647258','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1340','4585','Pirton Manahan Hutabarat','1490012372381','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1341','4586','Muhammad Soleh Harahap','1080023964266','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1342','4587','Ahmad Yani Siregar','1830004488663','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1343','4588','Ahmad Husein','1080022960760','MANDIRI','-','-','','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_bank_accounts VALUES('1344','4589','Stepenson Ky. Siboro','1070017926462','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1345','4590','Mhd Riswandi','1080023972756','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1346','4591','Guslan Efendi Siregar','1080023319370','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1347','4592','Jenri Saputra Gultom','1080016711427','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1348','4593','Marulitua Manik','1080022557434','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1349','4594','Firman Hadaid','1080015702716','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1350','4595','Mangihut Sinambela','1080015831408','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1351','4596','Sopian Lubis','1080016879448','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1352','4597','Torkis Abadi','1070007269741','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1353','4598','Hendriyanto Situmorang','1080026927971','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1354','4599','Togu Briman Siagian','1070018585853','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1355','4600','Mhd Andre Wijaya','1720004989879','MANDIRI','-','-','','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_bank_accounts VALUES('1356','4601','Alpa Riski','1720004989796','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1357','4602','David Manurung','1080026931304','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1358','4603','Jonatan Hengky Elivai Simanjuntak','1080027035386','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1359','4604','Valentino Bu\'Ulolo','1080022737796','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1360','4605','Raji Saut Htb Sinaga','1080022551247','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1361','4606','Risdo Agus Surya Sinaga','1070020428340','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1362','4607','Saut Simamora','1080016814320','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1363','4608','Federnelis Simanullang','1720003550730','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1364','4609','Tarmizi','1490017101421','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1365','4610','Irwansyah','1490016854772','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1366','4611','Andre Hasan','1490017011794','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1367','4612','Joko Teddy Sitorus','1070020413789','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1368','4613','Rafael Kryssanto Rumahorbo','1070020399137','MANDIRI','-','-','','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_bank_accounts VALUES('1369','4614','Jhon Sahat Verianto Manalu','1490016973283','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1370','4615','Dediansyah','1490016973275','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1371','4616','Basuan','1120014444231','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1372','4617','Rikki Jonatan Nababan','1080026109356','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1373','4618','Simon Sitohang','1080015790422','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1374','4619','Baringin Nainggolan','1720003730852','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1375','4620','Marudut Martua Sinaga','1070020424976','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1376','4621','Abbas','1490017011760','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1377','4622','Ahmat Ramli','1490017011786','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1378','4623','Marudut Hutagalung','1080023389001','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1379','4624','Jarisman Sinaga','1080025680191','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1380','4625','Alexius Siallagan','1070020520443','MANDIRI','-','-','','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_bank_accounts VALUES('1381','4626','Kiki Maurid Sianipar','1080024044159','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1382','4627','Rai Akbar Khan','1490016973259','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1383','4628','Agung Ramul','1490016979793','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1384','4629','Junaidi','-','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1385','4630','Agus Zidane','1490016973242','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1386','4631','Nur Azizah Nazwar','1490016881775','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1387','4632','Andar Erizwan','-','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1388','4633','Riris Nur\'Afifah Juriani','9000027202309','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1389','4634','Yongky Sapakoly','1490016973234','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1390','4635','Dicky Yunus Pakpahan','1060018322522','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1391','4636','Bosly Reno Sihombing','1080024169394','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1392','4637','Rusman Sidabalok','1080023300354','MANDIRI','-','-','','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_bank_accounts VALUES('1393','4638','Khaidir Sako','1700014149888','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1394','4639','Salman','-','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1395','4640','Haris Abidin','-','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1396','4641','Firman','1490016874028','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1397','4642','Zetro Siahaan','1070015774369','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1398','4643','Puji Nurahmiyati','1490016975999','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1399','4644','Yogie Fratama','1120021698951','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1400','4645','Ananta Maulana Pratama','1330026032268','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1401','4646','Harmoko Pangaribuan','1490017011828','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1402','4647','Roland Patandi','1490017011844','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1403','4648','Ibrahim Dael','1490017011828','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1404','4649','Wandri Santopel Natarez','1080022852082','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1405','4650','Alviola','1110022496232','MANDIRI','-','-','','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_bank_accounts VALUES('1407','4652','Daniel Fernandes Pardede','1080023388839','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1408','4653','Gaing Iskandar','1490017021546','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1409','4654','Marsel I.P. Ginting','1080023487557','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1410','4655','Ramadan','-','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1411','4656','Pernando Lumbantoruan','1080025344186','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1412','4657','Martin Johannes Aritonang','1080022741731','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1413','4658','Pauzi','1080024701642','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1414','4659','Riki Hariadi Purnomo','-','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1415','4660','Arya Sandi','1080025096273','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1416','4661','Herianto Simanungkalit','1080026981390','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1417','4662','Akbar. N','-','MANDIRI','-','-','','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_bank_accounts VALUES('1418','4663','Bintang Halasanro Sinabutar','1070020605681','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1419','4664','Harjana','-','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1420','4665','Kunadi','-','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1421','4666','Dodi Wahyudin','1340020454806','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1422','4667','Irfandi Hasanudin','1340022677164','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1423','4668','Nurito','1490017102411','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1424','4669','Brilian Nur Ramadhon','1340024204231','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1425','4670','Azwar','-','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1426','4671','Boston Situmorang','1080022983317','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1427','4672','Ricky Teddy Lerio Purba','1080023533673','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1428','4673','Yudhi Trisno','9000034613019','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1429','4674','Parman Sinaga','1080021653424','MANDIRI','-','-','','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_bank_accounts VALUES('1430','4675','Frengki Sahalatua Hutapea','1070020437598','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1431','4676','Rolasdi Lubis','1080023361471','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1432','4677','Tober Abdi Gunawan','1080027217414','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1433','4678','Maruli Manurung','1080023861801','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1434','4679','Togi Marito Gultom','1070020437655','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1435','4680','Irvan Samuel Sianipar','1080022996293','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1436','4681','Ronal Benget Leonardo Sitompul','-','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1437','4682','Maradona Siburian','1080017845661','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1438','4683','Ricardo Sinaga','1080027184879','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1439','4684','Bernad Handriono Sidabutar','1080021804225','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1440','4685','Damsir','1080023036008','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1441','4686','Dhoni Dwi Saputra','1840006957599','MANDIRI','-','-','','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_bank_accounts VALUES('1442','4687','Zulham','1700012472829','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1443','4688','Faisal Muhtar','1490017067887','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1444','4689','Roi','1490014527768','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1445','4690','Roy','-','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1446','4691','Nazaludin Latif','1340027444099','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1447','4692','Sahrul Maulana','1340027403483','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1448','4693','Bambang Deka Isbandi','1340026507433','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1449','4694','Mukhamad Akaun','1340027409720','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1450','4695','Andy Suseno','-','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1451','4696','Insan Setiadi','1340026689579','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1452','4697','Haris Solehuddin','-','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1453','4698','Kezia Putri Berliani','1780002295620','MANDIRI','-','-','','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_bank_accounts VALUES('1454','4699','Mamun','1340027411668','MANDIRI','-','-','','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_bank_accounts VALUES('1455','4700','Farras Abyyoga','1720003949627','MANDIRI','-','-','','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_bank_accounts VALUES('1456','4701','Iwan Saputra','1480015579454','MANDIRI','-','-','','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_bank_accounts VALUES('1457','4702','Tri Zulyanto','1480016037973','MANDIRI','-','-','','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_bank_accounts VALUES('1458','4703','Hendra Dwi Wibowo Prasetyo','1490017100308','MANDIRI','-','-','','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_bank_accounts VALUES('1459','4704','Andi Muhammad Ihksan','1490017102932','MANDIRI','-','-','','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_bank_accounts VALUES('1460','4705','Helmi Yusup','9000037016780','MANDIRI','-','-','','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_bank_accounts VALUES('1461','4706','Hadi Saputra','1490012393379','MANDIRI','-','-','','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_bank_accounts VALUES('1462','4707','Rinto Erbin Leo Simanullang','1080023552848','MANDIRI','-','-','','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_bank_accounts VALUES('1463','6237','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:50','2024-05-08 11:09:50');
INSERT INTO employee_bank_accounts VALUES('1464','6238','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:50','2024-05-08 11:09:50');
INSERT INTO employee_bank_accounts VALUES('1465','6239','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:50','2024-05-08 11:09:50');
INSERT INTO employee_bank_accounts VALUES('1466','6240','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1467','6241','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1468','6242','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1469','6243','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1470','6244','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1471','6245','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1472','6246','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1473','6247','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1474','6248','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1475','6249','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1476','6250','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1477','6251','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_bank_accounts VALUES('1478','6252','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1479','6253','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1480','6254','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1481','6255','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1482','6256','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1483','6257','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1484','6258','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1485','6259','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1486','6260','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1487','6261','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1488','6262','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1489','6263','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1490','6264','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_bank_accounts VALUES('1491','6265','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1492','6266','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1493','6267','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1494','6268','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1495','6269','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1496','6270','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1497','6271','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1498','6272','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1499','6273','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1500','6274','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1501','6275','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1502','6276','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_bank_accounts VALUES('1503','6277','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1504','6278','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1505','6279','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1506','6280','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1507','6281','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1508','6282','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1509','6283','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1510','6284','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1511','6285','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1512','6286','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1513','6287','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1514','6288','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_bank_accounts VALUES('1515','6289','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1516','6290','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1517','6291','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1518','6292','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1519','6293','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1520','6294','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1521','6295','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1522','6296','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1523','6297','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1524','6298','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1525','6299','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1526','6300','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_bank_accounts VALUES('1527','6301','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1528','6302','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1529','6303','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1530','6304','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1531','6305','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1532','6306','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1533','6307','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1534','6308','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1535','6309','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1536','6310','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1537','6311','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1538','6312','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_bank_accounts VALUES('1539','6313','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1540','6314','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1541','6315','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1542','6316','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1543','6317','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1544','6318','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1545','6319','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1546','6320','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1547','6321','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1548','6322','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1549','6323','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1550','6324','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1551','6325','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_bank_accounts VALUES('1552','6326','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1553','6327','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1554','6328','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1555','6329','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1556','6330','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1557','6331','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1558','6332','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1559','6333','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1560','6334','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1561','6335','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1562','6336','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1563','6337','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1564','6338','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_bank_accounts VALUES('1565','6339','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_bank_accounts VALUES('1566','6340','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_bank_accounts VALUES('1567','6341','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_bank_accounts VALUES('1568','6342','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_bank_accounts VALUES('1569','6343','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_bank_accounts VALUES('1570','6344','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_bank_accounts VALUES('1571','6345','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_bank_accounts VALUES('1572','6346','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_bank_accounts VALUES('1573','6347','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_bank_accounts VALUES('1574','6348','-','-','Bank Mandiri','-','-','','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_bank_accounts VALUES('1575','6349','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1576','6350','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1577','6351','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1578','6352','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1579','6353','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1580','6354','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1581','6355','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1582','6356','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1583','6357','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1584','6358','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1585','6359','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1586','6360','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_bank_accounts VALUES('1587','6361','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1588','6362','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1589','6363','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1590','6364','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1591','6365','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1592','6366','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1593','6367','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1594','6368','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1595','6369','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1596','6370','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1597','6371','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1598','6372','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_bank_accounts VALUES('1599','6373','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_bank_accounts VALUES('1600','6374','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_bank_accounts VALUES('1601','6375','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_bank_accounts VALUES('1602','6376','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_bank_accounts VALUES('1603','6377','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_bank_accounts VALUES('1604','6378','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_bank_accounts VALUES('1605','6379','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_bank_accounts VALUES('1606','6380','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_bank_accounts VALUES('1607','6381','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_bank_accounts VALUES('1608','6382','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1609','6383','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1610','6384','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1611','6385','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1612','6386','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1613','6387','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1614','6388','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1615','6389','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1616','6390','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1617','6391','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1618','6392','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_bank_accounts VALUES('1619','6393','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_bank_accounts VALUES('1620','6394','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_bank_accounts VALUES('1621','6395','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_bank_accounts VALUES('1622','6396','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_bank_accounts VALUES('1623','6397','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_bank_accounts VALUES('1624','6398','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_bank_accounts VALUES('1625','6399','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_bank_accounts VALUES('1626','6400','-','-','Bank Mandiri','-','-','','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_bank_accounts VALUES('2052','6826','Asrievani Junyta','1220012087709','Bank Mandiri','-','Wisma Nusantara','','2024-05-08 11:23:14','2024-05-08 11:23:14');
INSERT INTO employee_bank_accounts VALUES('2053','6827','Godam Januar','1290014265470','Bank Mandiri','-','Jakarta, Kramat Jati','','2024-05-08 11:23:14','2024-05-08 11:23:14');
INSERT INTO employee_bank_accounts VALUES('2054','6828','Ruspenda Ruspenda','1040004722992','Bank Mandiri','-','Bursa Efek Jakarta','','2024-05-08 11:23:14','2024-05-08 11:23:14');
INSERT INTO employee_bank_accounts VALUES('2055','6829','Chintia Suci Ananda','1020011040646','Bank Mandiri','-','Sudirman','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2056','6830','Ade Jaelani','1220011340786','Bank Mandiri','-','Plaza Indonesia','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2057','6831','Ade Chrisna Dewi Johan Putri','1230010206144','Bank Mandiri','-','KCP Jakarta Salemba Raya','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2058','6832','Agus Pujiono','1210005709286','Bank Mandiri','-','Duta merlin','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2059','6833','Ahmad Anik Anwar','9000006355565','Bank Mandiri','-','MANGGA DUA','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2060','6834','Aidy Nor','1490006601761','Bank Mandiri','-','KCP HANDIL','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2061','6835','Ajat Sendi Rahmat','1640002546382','Bank Mandiri','-','Jakarta','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2062','6836','Arie Nuryadi','9000013577771','Bank Mandiri','-','Duta merlin','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2063','6837','Asri Dyah Retnowati','1240005291399','Bank Mandiri','-','Jakarta Wisma Tugu','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2064','6838','Binsar Tohom Pardede','1070006325973','Bank Mandiri','-','Balige','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2065','6839','Budi Setiawan','9000003910156','Bank Mandiri','-','Duta marline','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2066','6840','Budi Dwisakti','1240002088913','Bank Mandiri','-','KCP Jakarta Rasuna Said (12401)','','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_bank_accounts VALUES('2067','6841','Dede Wahyuni','1310007777149','Bank Mandiri','-','Cabang Martadinata','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2068','6842','Dhani Fayumi Asyhar','1220010080664','Bank Mandiri','-','Plaza Indonesia','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2069','6843','Dian Wilandari','1280005872137','Bank Mandiri','-','Tangerang Bintaro','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2070','6844','Donny Hidayat','1650011301174','Bank Mandiri','-','KCP Slipi Jaya','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2071','6845','Dwi Andik Harianto','1040004360025','Bank Mandiri','-','Bursa Efek Jakarta','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2072','6846','Dwi Setiaji Marwanto','9000013723581','Bank Mandiri','-','Pondok Betung','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2073','6847','Esra Esra','1020005761975','Bank Mandiri','-','Sampoerna Strategic Sudirman','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2074','6848','Fajar Fitriyanto','1210005940568','Bank Mandiri','-','KCP duta merlin','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2075','6849','Firmansyah','1220007653762','Bank Mandiri','-','Plaza Indonesia','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2076','6850','Ghani Fikri Yasri','1230007706296','Bank Mandiri','-','Bank Mandiri Jakarta Cempaka Putih Permai','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2077','6851','Hartanto Hartanto','1240004343266','Bank Mandiri','-','Setiabudhi','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2078','6852','Hendro Susilo','1160004753951','Bank Mandiri','-','Cilegon','','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_bank_accounts VALUES('2079','6853','Hizbul','1630000839772','Bank Mandiri','-','Makassar','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2080','6854','Indra Faturochman','1090016221129','Bank Mandiri','-','KCP Batam Center','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2081','6855','Irwan Kurniawan','1330013199849','Bank Mandiri','-','Bogor','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2082','6856','Irwan Kurniawan','1220007558722','Bank Mandiri','-','Wisma nusantara','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2083','6857','Irwan','1090011996485','Bank Mandiri','-','Raja Ali Haji','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2084','6858','Joni','1220007560470','Bank Mandiri','-','Wisma mulia','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2085','6859','Joni Hirto','9000006726534','Bank Mandiri','-','Plaza Indonesia','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2086','6860','Leonora Hutabarat','1200004759077','Bank Mandiri','-','KCP CAKUNG','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2087','6861','Michael Stephanus Barasa','1250010734408','Bank Mandiri','-','Harapan indah','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2088','6862','Muhamad Romdon','1220007846663','Bank Mandiri','-','PLAZA INDONESIA','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2089','6863','Muhammad Rizki Rinaldi','1370004035917','Bank Mandiri','-','Yogyakarta Sudirman','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2090','6864','Novia Syaleika Putri','1640001499443','Bank Mandiri','-','Ciputat','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2091','6865','Nur Ramdani','1220007729067','Bank Mandiri','-','Plaza Indonesia','','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_bank_accounts VALUES('2092','6866','Patricia R. Wiriamanggala','1010001004694','Bank Mandiri','-','Mall Pondok Indah','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2093','6867','Rachma Juni','1220011794537','Bank Mandiri','-','Thamrin','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2094','6868','Rachmadany Pinem','9000002409275','Bank Mandiri','-','JAKARTA SLIPI JAYA','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2095','6869','Rahmat Isnain, St.','1210005892140','Bank Mandiri','-','Duta Merlin','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2096','6870','Reza Bani Sadr','1180010358769','Bank Mandiri','-','St. Morriz','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2097','6871','Ririn Suryaningsih','9000008917644','Bank Mandiri','-','Patra Jasa','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2098','6872','Servasius Gosmon','1210005152347','Bank Mandiri','-','DUTA MERLIN - JAKARTA','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2099','6873','Siti Nurmawati','1220009797336','Bank Mandiri','-','PLAZA INDONESIA','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2100','6874','Sugiarto','1210091819205','Bank Mandiri','-','JAKARTA','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2101','6875','Supardi','700010318397','Bank Mandiri','-','Wisma mulia','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2102','6876','Taufik Mardialy','1210006016152','Bank Mandiri','-','Thamrin','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2103','6877','Thomas Dandi Utomo','1220005328110','Bank Mandiri','-','KCP Jakarta Bendungan Hilir 12209','','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_bank_accounts VALUES('2104','6878','Tomi Gunawan','1020005683856','Bank Mandiri','-','Sampoerna Square','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2105','6879','Valen Thofany','1190006408460','Bank Mandiri','-','Jakarta','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2106','6880','Yudhi','1220011434019','Bank Mandiri','-','Jakarta pusat','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2107','6881','Zenal Aripin','1220007843900','Bank Mandiri','-','Wisma mulya','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2108','6882','Aan Suwandi','1210005809870','Bank Mandiri','-','Jakarta','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2109','6883','Abdul Rozak','1280098007393','Bank Mandiri','-','Bintaro','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2110','6884','Abu Amar','9000004642519','Bank Mandiri','-','SERANG','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2111','6885','Adidjaya Chandra Nugraha S.T.','1570007583603','Bank Mandiri','-','CINERE','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2112','6886','Afrizal Achmad Madhy','1220007587424','Bank Mandiri','-','Jakarta Berdharma','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2113','6887','Ajay Kumar Gupta','1010006655268','Bank Mandiri','-','Aminta Plaza','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2114','6888','Akhmad Maruf Nur','1640003118975','Bank Mandiri','-','Tangerang BSD Modern','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2115','6889','Al Varian Pradipta','1640001311234','Bank Mandiri','-','KCP TANGERANG ITC BSD','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2116','6890','Alfina Idelia Ds','1220010094780','Bank Mandiri','-','Bank Mandiri Plaza Indonesia','','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_bank_accounts VALUES('2117','6891','Amani Fidella','60006911634','Bank Mandiri','-','Jakarta, Kalimalang','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2118','6892','Amir Firmansyah','1270007093402','Bank Mandiri','-','Jakarta','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2119','6893','Andi Kusumah','1220007553533','Bank Mandiri','-','Mandiri KCP Jakarta Plaza Indonesia','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2120','6894','Andy Wijaya','121000541d4481','Bank Mandiri','-','Mandiri Duta Merlin','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2121','6895','Arif Ratno Hidayat','9000031895163','Bank Mandiri','-','Plaza indonesia','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2122','6896','Arini Banowati Azalia Adnin','1430024059915','Bank Mandiri','-','kemang pratama','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2123','6897','Bachtiar Afrezi','1230004367159','Bank Mandiri','-','jakarta selatan','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2124','6898','Bagus Bagaskara Putra','1640002296335','Bank Mandiri','-','KCP Tangerang Pasar Modern BSD','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2125','6899','Buyung','1210005872555','Bank Mandiri','-','Tanah Abang','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2126','6900','Candra Listanto','1290010214936','Bank Mandiri','-','Cijantung','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2127','6901','Debi Muslim','1270005957103','Bank Mandiri','-','WISMA TUGU JAKARTA SELATAN','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2128','6902','Dede Yuda Sukmana','1160005793873','Bank Mandiri','-','S.Parman','','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_bank_accounts VALUES('2129','6903','Dedy Kurniawan','1640003646553','Bank Mandiri','-','ITC BSD','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2130','6904','Dedy Darmawan','9000015258057','Bank Mandiri','-','Plasa Indonesia','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2131','6905','Deny Agus Iriyanto','1240007821631','Bank Mandiri','-','Jakarta Rasuna Said','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2132','6906','Diana Kurniawan','1240013258604','Bank Mandiri','-','Mall Kota Casablanca','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2133','6907','Dikut Supriyanto','1210005137983','Bank Mandiri','-','Cabang Jakarta Duta Merlin','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2134','6908','Wiwis Triwidayanti','1370018169603','Bank Mandiri','-','UGM YOGYAKARTA','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2135','6909','Efriadi','1090017633231','Bank Mandiri','-','NAGOYA','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2136','6910','Eka Priantara Wibowo','1010004834733','Bank Mandiri','-','Pondok Pinang','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2137','6911','Fahmi Meirizal','1140006524659','Bank Mandiri','-','Bandar Lampung','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2138','6912','Fajar Abdul Latif','1180013395222','Bank Mandiri','-','Taman Palem','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2139','6913','Fani Rahayu','1550006849437','Bank Mandiri','-','KCP Tangerang Ciledug 15507','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2140','6914','Felik Singgih R','1550000494685','Bank Mandiri','-','Ciledug','','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_bank_accounts VALUES('2141','6915','Fitri Yani Nainggolan','1160005818662','Bank Mandiri','-','Daan Mogot','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2142','6916','Friddy Mornianda Anaedi Putra','60004529586','Bank Mandiri','-','Jakarta Pahlawan Revolusi','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2143','6917','Ghinaa Keisha','1290011071624','Bank Mandiri','-','Taman Mini','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2144','6918','Harry Syaukani','1020005317174','Bank Mandiri','-','Jakarta','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2145','6919','Hasan Arifin','1560018266488','Bank Mandiri','-','Jakarta','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2146','6920','Hendra Gunawan','1550005243897','Bank Mandiri','-','Lippo Karawaci - Tangerang','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2147','6921','Imelda Simatupang','107 000 6563 565','Bank Mandiri','-','Simorangkir Tarutung','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2148','6922','Jatmiko Adi Nugraha','1210005138163','Bank Mandiri','-','Duta Merlin','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2149','6923','Bhide','1220007295937','Bank Mandiri','-','Plaza Indonesia','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2150','6924','Mbudiarto','1260004655881','Bank Mandiri','-','Cibinong','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2151','6925','Meliana Sihaloho','1210006011062','Bank Mandiri','-','Duta Merlin','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2152','6926','Mochammad Gifari Ilyasa Ramadhan','700009914446','Bank Mandiri','-','Wisma Mulia','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2153','6927','M.Jajuli','9000036088525','Bank Mandiri','-','Mandiri bogor juanda','','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_bank_accounts VALUES('2154','6928','Muhammad Alfian Dwi Putra','461699E+20','Bank Mandiri','-','Plaza Indonesia','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2155','6929','Mohammad Rizal Fachrudin','1240005883484','Bank Mandiri','-','Kuningan','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2156','6930','Mulyono','1220011762039','Bank Mandiri','-','Plaza Indonesia','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2157','6931','Niken Ramadhiani','1300012535079','Bank Mandiri','-','Bandung ITB','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2158','6932','Noor Ali Syarifudin','1490005375169','Bank Mandiri','-','Pati','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2159','6933','Novi Andri','1270012489330','Bank Mandiri','-','KCP RP. SOEROSO','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2160','6934','Ir E Nugroho Sulistyo P','1210007322849','Bank Mandiri','-','KCP JAKARTA TCC BATAVIA','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2161','6935','Nuraeni Nuraeni','1270004410989','Bank Mandiri','-','Mandiri Cabang Plaza indonesia','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2162','6936','Nurjai','1290004446585','Bank Mandiri','-','KRAMAT JATI','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2163','6937','Nylam Apriyuna Rengganis','1330015040231','Bank Mandiri','-','Universitas Pakuan Bogor','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2164','6938','Okta Juliant Dwi Sangaji','1210005710037','Bank Mandiri','-','Duta Merlin','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2165','6939','Osa Setiawan','1310013826831','Bank Mandiri','-','KCP Bandung Martadinata 13103','','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_bank_accounts VALUES('2166','6940','Parsono','1650001906388','Bank Mandiri','-','KC JAKARTA GREEN VILLE','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2167','6941','Patricia Dalima','1180013249213','Bank Mandiri','-','M.h Thamrin','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2168','6942','Petrick Jeki Kambey','1150005556800','Bank Mandiri','-','Muara Karang','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2169','6943','R Firmansyah St','1210005956929','Bank Mandiri','-','DUTA MERLIN','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2170','6944','Raden Panca Utama Sukomulya P','9000005135372','Bank Mandiri','-','Duta Merlin','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2171','6945','Renni Septi','1220009976328','Bank Mandiri','-','Jakarta','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2172','6946','Resandi Sasmita','1240006254537','Bank Mandiri','-','Jakarta Kalibata Rawajati','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2173','6947','Retta Theresia Tobing','1270004563266','Bank Mandiri','-','Ragunan','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2174','6948','Richard Florend Papilaya','1210011560376','Bank Mandiri','-','Tanah Abang','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2175','6949','Rizki Amelia','1550009864243','Bank Mandiri','-','KCP TANGERANG','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2176','6950','Rizki Yuni Pratiwi','1210009726724','Bank Mandiri','-','TCC Batavia','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2177','6951','Rizky Yuniawan','9000009900698','Bank Mandiri','-','JKT Gedung Elnusa 12705','','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_bank_accounts VALUES('2178','6952','Rizky Rodytullah','1240007312003','Bank Mandiri','-','Pasar Minggu','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2179','6953','Rosdiana Siahaan','1220011630145','Bank Mandiri','-','Bank Mandiri KCP Jakarta Wisma Nusantara','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2180','6954','Sani Nrrhasan Baihaki','1300014788767','Bank Mandiri','-','Mandiri KCP Kopo Bandung','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2181','6955','Sasongko Bambang Prayoga','1210005138395','Bank Mandiri','-','Jakarta Duta Merlin','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2182','6956','Senny Agus Widiyanti','MANDIRI','Bank Mandiri','-','HARMONI','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2183','6957','Soekirno','1550001656738','Bank Mandiri','-','Cilegon, Banten','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2184','6958','Sofian','1220007633004','Bank Mandiri','-','KCP pulman','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2185','6959','Sujianto','1210005138445','Bank Mandiri','-','Jakarta Duta Merlin','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2186','6960','Surono Panduwagung','1210007553831','Bank Mandiri','-','Universities Indonesia','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2187','6961','Suryadi','1220011774794','Bank Mandiri','-','Mh Thamrin','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2188','6962','Syarief Alfiantoni','1270011088059','Bank Mandiri','-','Bank Mandiri - Gedung Aneka Tambang','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2189','6963','Tassya Rismasari','9000009019820','Bank Mandiri','-','Duta merlin','','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_bank_accounts VALUES('2190','6964','Tiopan','1220007572475','Bank Mandiri','-','Duta Merlin','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2191','6965','Wahyudi Eko Cahyono','1260004701818','Bank Mandiri','-','Graha Iskandar Syah','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2192','6966','Widiastuti Resiningrum','1010011497656','Bank Mandiri','-','Petukangan','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2193','6967','Wisnu Tri Prasetya Samoen','1020004963150','Bank Mandiri','-','Senayan','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2194','6968','Yanu Tri Utomo','1160004498904','Bank Mandiri','-','Cilegon anyer','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2195','6969','Yohanes Erik','1020006516006','Bank Mandiri','-','Sudirman','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2196','6970','Zaky Arsalan','1010006350548','Bank Mandiri','-','KCP Bintaro','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2197','6971','Triyono','9000001626226','Bank Mandiri','-','KCP duta marlin','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2198','6972','Gemilar Sapta Pratama','1550001301855','Bank Mandiri','-','Borobudur, Tangerang','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2199','6973','Angelina Luciana Candra','0060009909460','Bank Mandiri','-','Jakarta Cipinang Jaya','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2200','6974','Ferry Setya Herwanto','1040004329582','Bank Mandiri','-','BEJ','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2201','6975','Dian Purnama Zainal','1630000196835','Bank Mandiri','-','Cilegon','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2202','6976','Mandiri','1220009976252','Bank Mandiri','-','Kcp wisma nusantara','','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_bank_accounts VALUES('2203','6977','Ignatius Adrian Syailendra','1360032020387','Bank Mandiri','-','Online ','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2204','6978','Iman Sulaeman','1260004578976','Bank Mandiri','-','kalibata','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2205','6979','Muhammad Irfan','1020010117551','Bank Mandiri','-','Kota Kasablanca','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2206','6980','Supriyatna','1640001513052','Bank Mandiri','-','KCP BINTARO','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2207','6981','Galih Ramadhan','9000042356056','Bank Mandiri','-','Cilacap','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2208','6982','Mohammad Malik Abd Azis','1220010076019','Bank Mandiri','-','KCP Plaza Indonesia','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2209','6983','DR. Agung Setiawan','0060005092436','Bank Mandiri','-','Pramuka','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2210','6984','Rossiana Wulandari','1220007659835','Bank Mandiri','-','Plaza Indonesia','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2211','6985','Noor Adlan Bin Mohd Noor','1240007101869','Bank Mandiri','-','JAKARTA, MENARA PALMA','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2212','6986','Gunawan Adi Waskito','1320012867553','Bank Mandiri','-','Bandung Pasar Baru','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2213','6987','Gaya Delyla Assuncao Silva Pereira','60011516428','Bank Mandiri','-','online','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2214','6988','Nina Agustin','1150005001468','Bank Mandiri','-','Pantai indah kapuk','','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_bank_accounts VALUES('2215','6989','Fitrandy Virgianto','700000139357','Bank Mandiri','-','Jakarta M.T. Haryono','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2216','6990','Aas Tajudin','9000004952967','Bank Mandiri','-','Bendungan Hilir','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2217','6991','Augene Mahdarreza','1220005858041','Bank Mandiri','-','Jakarta Mid Plaza','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2218','6992','Denny Ronald','1210005137959','Bank Mandiri','-','Harmoni','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2219','6993','Herry Hermawan','1210005138080','Bank Mandiri','-','Duta Merlin','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2220','6994','Evita Indraswati','1090005315189','Bank Mandiri','-','Batam','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2221','6995','Agnes Teresa','1290012737777','Bank Mandiri','-','KRAMAT JATI','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2222','6996','AHYADI','60010010985','Bank Mandiri','-','Matraman','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2223','6997','Aji Tumin Probowo ','1330012414322','Bank Mandiri','-','-','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2224','6998','Ajub Paddy Siwalette ','1560000212318','Bank Mandiri','-','-','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2225','6999','Anry Hippy ','1090012390811','Bank Mandiri','-','-','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2226','7000','Benjamin Alain Courtier','9000005676086','Bank Mandiri','-','-','','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_bank_accounts VALUES('2227','7001','Cindy ','1680020112015','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2228','7002','Dwi Nurul Khasanah','1020007568519','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2229','7003','Erdiansyah Wirya Saputra ','1260006262132','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2230','7004','Esta Andhizar','1310011375823','Bank Mandiri','-','Bandung Dago','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2231','7005','Herawati Dwi Astiningrum ','1220006317575','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2232','7006','Hermoko','9000001626200','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2233','7007','Indra Wijaya ','9000007675029','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2234','7008','Jonri Freddi Tambunan ','9000009019838','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2235','7009','Karunakaran Logasundar','1220007353983','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2236','7010','Khalid Alting','9000010303635','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2237','7011','M Rizal Sabir','1310010549311','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2238','7012','Mashudi Benarto','1220006194735','Bank Mandiri','-','-','','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_bank_accounts VALUES('2239','7013','Muhammad Rubby Fahlefi','12400011886885','Bank Mandiri','-','Tebet timur','','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_bank_accounts VALUES('2240','7014','Musa Anthony Siregar','1220006278462','Bank Mandiri','-','-','','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_bank_accounts VALUES('2241','7015','Reza Rizaldi','1340013383525','Bank Mandiri','-','-','','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_bank_accounts VALUES('2242','7016','Riswan ','9000022641980','Bank Mandiri','-','-','','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_bank_accounts VALUES('2243','7017','Sushil Singh Bisht','1040004115866','Bank Mandiri','-','-','','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_bank_accounts VALUES('2244','7018','Tamsor Rambe ','1090013466040','Bank Mandiri','-','-','','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_bank_accounts VALUES('2245','7019','Dedy Kurniawan','1480016118104','Bank Mandiri','-','Muawa Jawa Ulu','','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_bank_accounts VALUES('2763','7537','-','1080005270229','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2764','7538','-','1080006873823','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2765','7539','-','1080093071661','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2766','7540','-','1720000626665','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2767','7541','-','1080004930690','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2768','7542','-','1080006004791','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2769','7543','-','1080010695683','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2770','7544','-','1080004941515','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2771','7545','-','1720000108516','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2772','7546','-','1080010396977','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2773','7547','-','1720004242063','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2774','7548','-','1080001339242','MANDIRI','008','-','','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_bank_accounts VALUES('2775','7549','-','1720000620122','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2776','7550','-','1080006769286','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2777','7551','-','1720000609711','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2778','7552','-','1720000539199','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2779','7553','-','1720000148819','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2780','7554','-','1720000609927','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2781','7555','-','1720000609471','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2782','7556','-','1080007952618','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2783','7557','-','1720000609570','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2784','7558','-','1080012861317','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2785','7559','-','1720000609489','MANDIRI','008','-','','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_bank_accounts VALUES('2786','7560','-','1080006765953','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2787','7561','-','1080005263695','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2788','7562','-','1080006769211','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2789','7563','-','1720000626657','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2790','7564','-','1720000626699','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2791','7565','-','9000024326986','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2792','7566','-','1720000628638','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2793','7567','-','1720000626616','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2794','7568','-','1720000626681','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2795','7569','-','1720000636532','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2796','7570','-','1720000636508','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2797','7571','-','1720000051039','MANDIRI','008','-','','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_bank_accounts VALUES('2798','7572','-','9000013291282','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2799','7573','-','1080012583044','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2800','7574','-','9000019459016','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2801','7575','-','1720000636565','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2802','7576','-','1720000017378','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2803','7577','-','1720000471559','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2804','7578','-','1720000651416','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2805','7579','-','1080006035993','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2806','7580','-','1720000816894','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2807','7581','-','1130007101094','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2808','7582','-','1080093076702','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2809','7583','-','1080011905149','MANDIRI','008','-','','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_bank_accounts VALUES('2810','7584','-','1720001580416','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2811','7585','-','9000019404814','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2812','7586','-','1720002456962','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2813','7587','-','1720001573908','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2814','7588','-','1080012909686','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2815','7589','-','1080005264503','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2816','7590','-','1720003479286','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2817','7591','-','1080021750535','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2818','7592','-','1720003193895','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2819','7593','-','1720000636615','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2820','7594','-','1720003948769','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2821','7595','-','1080022902556','MANDIRI','008','-','','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_bank_accounts VALUES('2822','7596','-','1720004186211','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2823','7597','-','1720004209369','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2824','7598','-','1720004192557','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2825','7599','-','1080024496102','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2826','7600','-','1720004477925','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2827','7601','-','1720004477917','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2828','7602','-','1120018866272','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2829','7603','-','1720004477933','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2830','7604','-','1080005935565','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2831','7605','-','1720004708279','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2832','7606','-','1080016103286','MANDIRI','008','-','','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_bank_accounts VALUES('2833','7607','-','1720004814333','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2834','7608','-','1720002676858','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2835','7609','-','1080005263703','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2836','7610','-','1080002030790','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2837','7611','-','1080007351241','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2838','7612','-','1720005103058','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2839','7613','-','1720005103009','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2840','7614','-','1720005102993','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2841','7615','-','1720005103025','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2842','7616','-','1720005103017','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2843','7617','-','1720005103108','MANDIRI','008','-','','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_bank_accounts VALUES('2844','7618','-','1720005102977','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2845','7619','-','1720005103033','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2846','7620','-','1720005102944','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2847','7621','-','1720004038115','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2848','7622','-','1720005102928','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2849','7623','-','1720005103066','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2850','7624','-','1720005103116','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2851','7625','-','1080024087323','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2852','7626','-','1720005103082','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2853','7627','-','1720005103090','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2854','7628','-','1720005103074','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2855','7629','-','1720005103041','MANDIRI','008','-','','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_bank_accounts VALUES('2856','7630','-','1720005102936','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2857','7631','-','#N/A','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2858','7632','-','1720005102985','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2859','7633','-','\'1720002854869','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2860','7634','-','1080006767173','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2861','7635','-','1080006766175','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2862','7636','-','1080006766779','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2863','7637','-','1080005465894','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2864','7638','-','1720004516862','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2865','7639','-','1720004516870','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2866','7640','-','1080011604197','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2867','7641','-','1720000636581','MANDIRI','008','-','','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_bank_accounts VALUES('2868','7642','-','1080010920545','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2869','7643','-','1720004508265','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2870','7644','-','1720000308033','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2871','7645','-','1720004315521','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2872','7646','-','1720001750001','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2873','7647','-','1080006767090','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2874','7648','-','1720000636557','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2875','7649','-','1720003176908','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2876','7650','-','1720000616245','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2877','7651','-','1720004757136','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2878','7652','-','1720000626707','MANDIRI','008','-','','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_bank_accounts VALUES('2879','7653','-','1080002030675','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2880','7654','-','1720000157026','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2881','7655','-','1080025280208','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2882','7656','-','1080012857273','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2883','7657','-','1720000616880','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2884','7658','-','1720000628620','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2885','7659','-','1080007463970','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2886','7660','-','1720003912229','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2887','7661','-','1720004513307','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2888','7662','-','1080017749855','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2889','7663','-','1720000651457','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2890','7664','-','1720004531465','MANDIRI','008','-','','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_bank_accounts VALUES('2891','7665','-','1720000002131','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2892','7666','-','1720003039528','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2893','7667','-','1720004677284','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2894','7668','-','1080018783507','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2895','7669','-','1720000423410','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2896','7670','-','1720000087082','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2897','7671','-','1720001573023','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2898','7672','-','1720003678473','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2899','7673','-','1720005040748','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2900','7674','-','1720005103181','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2901','7675','-','1720005103132','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2902','7676','-','1720004206944','MANDIRI','008','-','','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_bank_accounts VALUES('2903','7677','-','1720004207405','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2904','7678','-','1720004934511','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2905','7679','-','1720004207413','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2906','7680','-','1720004207181','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2907','7681','-','1720004219236','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2908','7682','-','1720004207462','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2909','7683','-','1080010381300','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2910','7684','-','1720004207025','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2911','7685','-','1720004182947','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2912','7686','-','1720004207066','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2913','7687','-','1720004184604','MANDIRI','008','-','','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_bank_accounts VALUES('2914','7688','-','1720004231314','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2915','7689','-','1720004207470','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2916','7690','-','1080098258263','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2917','7691','-','1720004206951','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2918','7692','-','1720004245249','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2919','7693','-','1230006060562','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2920','7694','-','1110007906270','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2921','7695','-','1720004207371','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2922','7696','-','1720004207256','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2923','7697','-','1720003980846','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2924','7698','-','1720000274805','MANDIRI','008','-','','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_bank_accounts VALUES('2925','7699','-','1720004193688','MANDIRI','008','-','','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_bank_accounts VALUES('2926','7700','-','1720004183291','MANDIRI','008','-','','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_bank_accounts VALUES('2927','7701','-','1720004178945','MANDIRI','008','-','','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_bank_accounts VALUES('2928','7702','-','1720004206977','MANDIRI','008','-','','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_bank_accounts VALUES('2929','7703','-','1720004207009','MANDIRI','008','-','','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_bank_accounts VALUES('2930','7704','-','1720004207165','MANDIRI','008','-','','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_bank_accounts VALUES('2931','7705','-','1720004207058','MANDIRI','008','-','','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_bank_accounts VALUES('2932','7706','-','1720004241982','MANDIRI','008','-','','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_bank_accounts VALUES('2933','7707','-','1720004207322','MANDIRI','008','-','','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_bank_accounts VALUES('2934','7708','-','1080000189242','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2935','7709','-','1720004207264','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2936','7710','-','1050011786807','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2937','7711','-','1720004184497','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2938','7712','-','1720004207488','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2939','7713','-','1720004207397','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2940','7714','-','1720004242188','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2941','7715','-','1720004207249','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2942','7716','-','1720004207488','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2943','7717','-','1050014504033','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2944','7718','-','1080023646954','MANDIRI','008','-','','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_bank_accounts VALUES('2945','7719','-','1720004207439','MANDIRI','008','-','','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_bank_accounts VALUES('2946','7720','-','1720004207199','MANDIRI','008','-','','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_bank_accounts VALUES('2947','7721','-','1720004242014','MANDIRI','008','-','','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_bank_accounts VALUES('2948','7722','-','1720004242162','MANDIRI','008','-','','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_bank_accounts VALUES('2949','7723','-','1720004178572','MANDIRI','008','-','','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_bank_accounts VALUES('2950','7724','-','1720004207090','MANDIRI','008','-','','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_bank_accounts VALUES('2951','7725','-','1720000050361','MANDIRI','008','-','','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_bank_accounts VALUES('2952','7726','-','1080024365711','MANDIRI','008','-','','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_bank_accounts VALUES('2953','7727','-','1720004207074','MANDIRI','008','-','','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_bank_accounts VALUES('2954','7728','-','1080005625679','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2955','7729','-','1720004207223','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2956','7730','-','1720004207330','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2957','7731','-','1720000662850','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2958','7732','-','1720004207017','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2959','7733','-','1370006025247','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2960','7734','-','1720004207272','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2961','7735','-','1720004245256','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2962','7736','-','1720004207207','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2963','7737','-','1080017501991','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2964','7738','-','1720004207389','MANDIRI','008','-','','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_bank_accounts VALUES('2965','7739','-','1080024380488','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2966','7740','-','1720004206985','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2967','7741','-','1720001757253','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2968','7742','-','1720004207108','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2969','7743','-','1720004207454','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2970','7744','-','1720004207124','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2971','7745','-','1720002840637','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2972','7746','-','1720004182863','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2973','7747','-','1720004241990','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2974','7748','-','1720004207041','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2975','7749','-','1720004207298','MANDIRI','008','-','','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_bank_accounts VALUES('2976','7750','-','1720004207447','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2977','7751','-','1720004183192','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2978','7752','-','1720004183549','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2979','7753','-','1720004207348','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2980','7754','-','1720004206969','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2981','7755','-','1720004207173','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2982','7756','-','1720004207140','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2983','7757','-','1720004184778','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2984','7758','-','1720004190106','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2985','7759','-','1720004207116','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2986','7760','-','1720002190629','MANDIRI','008','-','','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_bank_accounts VALUES('2987','7761','-','1720004207363','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2988','7762','-','1720004477917','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2989','7763','-','1720004242188','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2990','7764','-','1720004188845','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2991','7765','-','1720004179752','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2992','7766','-','1640004596310','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2993','7767','-','1720004207033','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2994','7768','-','1720004206993','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2995','7769','-','1080011498376','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2996','7770','-','1720004207355','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2997','7771','-','1720004207215','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2998','7772','-','1720004242055','MANDIRI','008','-','','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_bank_accounts VALUES('2999','7773','-','1720004242246','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3000','7774','-','1720004210078','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3001','7775','-','1720004293207','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3002','7776','-','1720004243061','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3003','7777','-','1720004677417','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3004','7778','-','1720004206241','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3005','7779','-','1720004884096','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3006','7780','-','#N/A','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3007','7781','-','1720005180361','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3008','7782','-','1720005180460','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3009','7783','-','#N/A','MANDIRI','008','-','','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_bank_accounts VALUES('3010','7784','-','1080010565878','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3011','7785','-','1080005320404','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3012','7786','-','1080010678309','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3013','7787','-','1080010613413','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3014','7788','-','1080007552863','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3015','7789','-','9000021634523','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3016','7790','-','1080005527131','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3017','7791','-','1720000018400','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3018','7792','-','1550001711897','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3019','7793','-','1720000723678','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3020','7794','-','1720001673815','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3021','7795','-','1580002046928','MANDIRI','008','-','','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_bank_accounts VALUES('3022','7796','-','1720001537929','MANDIRI','008','-','','2024-05-08 17:02:11','2024-05-08 17:02:11');
INSERT INTO employee_bank_accounts VALUES('3023','7797','-','1720004186203','MANDIRI','008','-','','2024-05-08 17:02:11','2024-05-08 17:02:11');
INSERT INTO employee_bank_accounts VALUES('3024','7798','-','1720004260818','MANDIRI','008','-','','2024-05-08 17:02:11','2024-05-08 17:02:11');
INSERT INTO employee_bank_accounts VALUES('3025','7799','-','1720001460841','MANDIRI','008','-','','2024-05-08 17:02:11','2024-05-08 17:02:11');
INSERT INTO employee_bank_accounts VALUES('3026','7800','-','1720004242022','MANDIRI','008','-','','2024-05-08 17:02:11','2024-05-08 17:02:11');



CREATE TABLE `employee_contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `relation` varchar(50) NOT NULL,
  `is_primary` tinyint(4) DEFAULT 0,
  `is_dependent` tinyint(4) DEFAULT 0,
  `contact_name` varchar(191) NOT NULL,
  `work_phone` varchar(191) DEFAULT NULL,
  `work_phone_ext` varchar(191) DEFAULT NULL,
  `personal_phone` varchar(191) DEFAULT NULL,
  `home_phone` varchar(191) DEFAULT NULL,
  `work_email` varchar(191) DEFAULT NULL,
  `personal_email` varchar(191) DEFAULT NULL,
  `address1` varchar(191) DEFAULT NULL,
  `address2` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `zip` varchar(191) DEFAULT NULL,
  `country_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_contacts_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_contacts_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_documents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `document_type_id` bigint(20) unsigned DEFAULT NULL,
  `document_type` varchar(191) DEFAULT NULL,
  `document_title` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  `expiry_date` date NOT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_documents_employee_id_foreign` (`employee_id`),
  KEY `employee_documents_document_type_id_foreign` (`document_type_id`),
  CONSTRAINT `employee_documents_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_documents_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_immigrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `document_type_id` bigint(20) unsigned DEFAULT NULL,
  `document_type` varchar(191) DEFAULT NULL,
  `document_number` varchar(191) NOT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  `issue_date` date NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `eligible_review_date` date DEFAULT NULL,
  `country_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_immigrations_employee_id_foreign` (`employee_id`),
  KEY `employee_immigrations_document_type_id_foreign` (`document_type_id`),
  CONSTRAINT `employee_immigrations_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_immigrations_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_interview` (
  `interview_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`interview_id`,`employee_id`),
  KEY `employee_interview_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_interview_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `employee_interview_interview_id_foreign` FOREIGN KEY (`interview_id`) REFERENCES `job_interviews` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_meeting` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `meeting_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`meeting_id`),
  KEY `employee_meeting_meeting_id_foreign` (`meeting_id`),
  CONSTRAINT `employee_meeting_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_meeting_meeting_id_foreign` FOREIGN KEY (`meeting_id`) REFERENCES `meetings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_project` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `project_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`project_id`),
  KEY `employee_project_project_id_foreign` (`project_id`),
  CONSTRAINT `employee_project_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_project_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_qualificaitons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `education_level_id` bigint(20) unsigned DEFAULT NULL,
  `education_level` varchar(191) DEFAULT NULL,
  `institution_name` varchar(191) NOT NULL,
  `from_year` date DEFAULT NULL,
  `to_year` date DEFAULT NULL,
  `language_skill_id` bigint(20) unsigned DEFAULT NULL,
  `general_skill_id` bigint(20) unsigned DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `graduation_date` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_qualificaitons_employee_id_foreign` (`employee_id`),
  KEY `employee_qualificaitons_education_level_id_foreign` (`education_level_id`),
  KEY `employee_qualificaitons_language_skill_id_foreign` (`language_skill_id`),
  KEY `employee_qualificaitons_general_skill_id_foreign` (`general_skill_id`),
  CONSTRAINT `employee_qualificaitons_education_level_id_foreign` FOREIGN KEY (`education_level_id`) REFERENCES `qualification_education_levels` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_qualificaitons_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_qualificaitons_general_skill_id_foreign` FOREIGN KEY (`general_skill_id`) REFERENCES `qualification_skills` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_qualificaitons_language_skill_id_foreign` FOREIGN KEY (`language_skill_id`) REFERENCES `qualification_languages` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `is_bpjs_tk_include` tinyint(1) NOT NULL,
  `is_bpjs_kes_include` tinyint(1) NOT NULL,
  `is_tax_include` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_settings_employee_id_foreign` (`employee_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5501 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_settings VALUES('1','2296','1','1','1','2024-04-22 10:45:31','2024-04-22 10:45:31');
INSERT INTO employee_settings VALUES('2','2297','1','1','1','2024-04-22 10:45:31','2024-04-22 10:45:31');
INSERT INTO employee_settings VALUES('3','2298','1','1','1','2024-04-22 10:45:31','2024-04-22 10:45:31');
INSERT INTO employee_settings VALUES('4','2299','1','1','1','2024-04-22 10:45:31','2024-04-22 10:45:31');
INSERT INTO employee_settings VALUES('5','2300','1','1','1','2024-04-22 10:45:31','2024-04-22 10:45:31');
INSERT INTO employee_settings VALUES('6','2301','1','1','1','2024-04-22 10:45:31','2024-04-22 10:45:31');
INSERT INTO employee_settings VALUES('7','2302','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('8','2303','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('9','2304','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('10','2305','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('11','2306','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('12','2307','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('13','2308','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('14','2309','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('15','2310','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('16','2311','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('17','2312','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('18','2313','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('19','2314','1','1','1','2024-04-22 10:45:32','2024-04-22 10:45:32');
INSERT INTO employee_settings VALUES('20','2315','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('21','2316','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('22','2317','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('23','2318','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('24','2319','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('25','2320','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('26','2321','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('27','2322','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('28','2323','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('29','2324','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('30','2325','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('31','2326','1','1','1','2024-04-22 10:45:33','2024-04-22 10:45:33');
INSERT INTO employee_settings VALUES('32','2327','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('33','2328','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('34','2329','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('35','2330','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('36','2331','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('37','2332','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('38','2333','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('39','2334','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('40','2335','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('41','2336','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('42','2337','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('43','2338','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('44','2339','1','1','1','2024-04-22 10:45:34','2024-04-22 10:45:34');
INSERT INTO employee_settings VALUES('45','2340','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('46','2341','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('47','2342','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('48','2343','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('49','2344','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('50','2345','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('51','2346','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('52','2347','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('53','2348','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('54','2349','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('55','2350','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('56','2351','1','1','1','2024-04-22 10:45:35','2024-04-22 10:45:35');
INSERT INTO employee_settings VALUES('57','2352','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('58','2353','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('59','2354','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('60','2355','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('61','2356','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('62','2357','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('63','2358','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('64','2359','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('65','2360','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('66','2361','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('67','2362','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('68','2363','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('69','2364','1','1','1','2024-04-22 10:45:36','2024-04-22 10:45:36');
INSERT INTO employee_settings VALUES('70','2365','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('71','2366','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('72','2367','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('73','2368','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('74','2369','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('75','2370','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('76','2371','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('77','2372','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('78','2373','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('79','2374','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('80','2375','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('81','2376','1','1','1','2024-04-22 10:45:37','2024-04-22 10:45:37');
INSERT INTO employee_settings VALUES('82','2377','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('83','2378','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('84','2379','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('85','2380','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('86','2381','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('87','2382','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('88','2383','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('89','2384','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('90','2385','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('91','2386','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('92','2387','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('93','2388','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('94','2389','1','1','1','2024-04-22 10:45:38','2024-04-22 10:45:38');
INSERT INTO employee_settings VALUES('95','2390','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('96','2391','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('97','2392','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('98','2393','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('99','2394','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('100','2395','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('101','2396','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('102','2397','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('103','2398','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('104','2399','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('105','2400','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('106','2401','1','1','1','2024-04-22 10:45:39','2024-04-22 10:45:39');
INSERT INTO employee_settings VALUES('107','2402','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('108','2403','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('109','2404','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('110','2405','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('111','2406','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('112','2407','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('113','2408','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('114','2409','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('115','2410','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('116','2411','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('117','2412','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('118','2413','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('119','2414','1','1','1','2024-04-22 10:45:40','2024-04-22 10:45:40');
INSERT INTO employee_settings VALUES('120','2415','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('121','2416','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('122','2417','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('123','2418','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('124','2419','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('125','2420','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('126','2421','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('127','2422','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('128','2423','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('129','2424','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('130','2425','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('131','2426','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('132','2427','1','1','1','2024-04-22 10:45:41','2024-04-22 10:45:41');
INSERT INTO employee_settings VALUES('133','2428','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('134','2429','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('135','2430','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('136','2431','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('137','2432','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('138','2433','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('139','2434','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('140','2435','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('141','2436','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('142','2437','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('143','2438','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('144','2439','1','1','1','2024-04-22 10:45:42','2024-04-22 10:45:42');
INSERT INTO employee_settings VALUES('145','2440','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('146','2441','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('147','2442','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('148','2443','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('149','2444','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('150','2445','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('151','2446','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('152','2447','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('153','2448','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('154','2449','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('155','2450','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('156','2451','1','1','1','2024-04-22 10:45:43','2024-04-22 10:45:43');
INSERT INTO employee_settings VALUES('157','2452','1','1','1','2024-04-22 10:45:44','2024-04-22 10:45:44');
INSERT INTO employee_settings VALUES('158','2453','1','1','1','2024-04-22 10:45:44','2024-04-22 10:45:44');
INSERT INTO employee_settings VALUES('159','2454','1','1','1','2024-04-22 10:45:44','2024-04-22 10:45:44');
INSERT INTO employee_settings VALUES('160','2455','1','1','1','2024-04-22 10:45:44','2024-04-22 10:45:44');
INSERT INTO employee_settings VALUES('161','2456','1','1','1','2024-04-22 10:45:44','2024-04-22 10:45:44');
INSERT INTO employee_settings VALUES('164','2461','1','1','1','2024-04-23 10:26:49','2024-04-23 10:26:49');
INSERT INTO employee_settings VALUES('165','2462','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('166','2463','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('167','2464','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('168','2465','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('169','2466','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('170','2467','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('171','2468','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('172','2469','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('173','2470','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('174','2471','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('175','2472','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('176','2473','1','1','1','2024-04-23 10:26:50','2024-04-23 10:26:50');
INSERT INTO employee_settings VALUES('177','2474','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('178','2475','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('179','2476','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('180','2477','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('181','2478','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('182','2479','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('183','2480','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('184','2481','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('185','2482','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('186','2483','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('187','2484','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('188','2485','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('189','2486','1','1','1','2024-04-23 10:26:51','2024-04-23 10:26:51');
INSERT INTO employee_settings VALUES('190','2487','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('191','2488','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('192','2489','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('193','2490','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('194','2491','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('195','2492','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('196','2493','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('197','2494','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('198','2495','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('199','2496','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('200','2497','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('201','2498','1','1','1','2024-04-23 10:26:52','2024-04-23 10:26:52');
INSERT INTO employee_settings VALUES('202','2499','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('203','2500','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('204','2501','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('205','2502','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('206','2503','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('207','2504','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('208','2505','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('209','2506','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('210','2507','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('211','2508','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('212','2509','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('213','2510','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('214','2511','1','1','1','2024-04-23 10:26:53','2024-04-23 10:26:53');
INSERT INTO employee_settings VALUES('215','2512','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('216','2513','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('217','2514','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('218','2515','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('219','2516','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('220','2517','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('221','2518','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('222','2519','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('223','2520','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('224','2521','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('225','2522','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('226','2523','1','1','1','2024-04-23 10:26:54','2024-04-23 10:26:54');
INSERT INTO employee_settings VALUES('227','2524','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('228','2525','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('229','2526','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('230','2527','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('231','2528','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('232','2529','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('233','2530','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('234','2531','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('235','2532','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('236','2533','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('237','2534','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('238','2535','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('239','2536','1','1','1','2024-04-23 10:26:55','2024-04-23 10:26:55');
INSERT INTO employee_settings VALUES('240','2537','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('241','2538','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('242','2539','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('243','2540','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('244','2541','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('245','2542','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('246','2543','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('247','2544','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('248','2545','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('249','2546','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('250','2547','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('251','2548','1','1','1','2024-04-23 10:26:56','2024-04-23 10:26:56');
INSERT INTO employee_settings VALUES('252','2549','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('253','2550','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('254','2551','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('255','2552','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('256','2553','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('257','2554','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('258','2555','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('259','2556','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('260','2557','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('261','2558','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('262','2559','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('263','2560','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('264','2561','1','1','1','2024-04-23 10:26:57','2024-04-23 10:26:57');
INSERT INTO employee_settings VALUES('265','2562','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('266','2563','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('267','2564','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('268','2565','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('269','2566','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('270','2567','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('271','2568','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('272','2569','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('273','2570','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('274','2571','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('275','2572','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('276','2573','1','1','1','2024-04-23 10:26:58','2024-04-23 10:26:58');
INSERT INTO employee_settings VALUES('277','2574','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('278','2575','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('279','2576','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('280','2577','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('281','2578','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('282','2579','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('283','2580','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('284','2581','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('285','2582','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('286','2583','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('287','2584','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('288','2585','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('289','2586','1','1','1','2024-04-23 10:26:59','2024-04-23 10:26:59');
INSERT INTO employee_settings VALUES('290','2587','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('291','2588','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('292','2589','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('293','2590','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('294','2591','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('295','2592','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('296','2593','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('297','2594','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('298','2595','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('299','2596','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('300','2597','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('301','2598','1','1','1','2024-04-23 10:27:00','2024-04-23 10:27:00');
INSERT INTO employee_settings VALUES('302','2599','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('303','2600','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('304','2601','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('305','2602','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('306','2603','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('307','2604','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('308','2605','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('309','2606','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('310','2607','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('311','2608','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('312','2609','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('313','2610','1','1','1','2024-04-23 10:27:01','2024-04-23 10:27:01');
INSERT INTO employee_settings VALUES('314','2611','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('315','2612','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('316','2613','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('317','2614','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('318','2615','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('319','2616','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('320','2617','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('321','2618','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('322','2619','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('323','2620','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('324','2621','1','1','1','2024-04-23 10:27:02','2024-04-23 10:27:02');
INSERT INTO employee_settings VALUES('325','2622','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('326','2623','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('327','2624','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('328','2625','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('329','2626','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('330','2627','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('331','2628','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('332','2629','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('333','2630','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('334','2631','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('335','2632','1','1','1','2024-04-23 10:27:03','2024-04-23 10:27:03');
INSERT INTO employee_settings VALUES('336','2633','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('337','2634','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('338','2635','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('339','2636','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('340','2637','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('341','2638','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('342','2639','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('343','2640','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('344','2641','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('345','2642','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('346','2643','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('347','2644','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('348','2645','1','1','1','2024-04-23 10:27:04','2024-04-23 10:27:04');
INSERT INTO employee_settings VALUES('349','2646','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('350','2647','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('351','2648','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('352','2649','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('353','2650','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('354','2651','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('355','2652','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('356','2653','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('357','2654','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('358','2655','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('359','2656','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('360','2657','1','1','1','2024-04-23 10:27:05','2024-04-23 10:27:05');
INSERT INTO employee_settings VALUES('361','2658','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('362','2659','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('363','2660','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('364','2661','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('365','2662','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('366','2663','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('367','2664','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('368','2665','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('369','2666','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('370','2667','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('371','2668','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('372','2669','1','1','1','2024-04-23 10:27:06','2024-04-23 10:27:06');
INSERT INTO employee_settings VALUES('373','2670','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('374','2671','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('375','2672','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('376','2673','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('377','2674','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('378','2675','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('379','2676','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('380','2677','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('381','2678','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('382','2679','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('383','2680','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('384','2681','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('385','2682','1','1','1','2024-04-23 10:27:07','2024-04-23 10:27:07');
INSERT INTO employee_settings VALUES('386','2683','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('387','2684','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('388','2685','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('389','2686','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('390','2687','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('391','2688','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('392','2689','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('393','2690','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('394','2691','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('395','2692','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('396','2693','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('397','2694','1','1','1','2024-04-23 10:27:08','2024-04-23 10:27:08');
INSERT INTO employee_settings VALUES('398','2695','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('399','2696','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('400','2697','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('401','2698','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('402','2699','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('403','2700','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('404','2701','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('405','2702','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('406','2703','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('407','2704','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('408','2705','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('409','2706','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('410','2707','1','1','1','2024-04-23 10:27:09','2024-04-23 10:27:09');
INSERT INTO employee_settings VALUES('411','2708','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('412','2709','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('413','2710','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('414','2711','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('415','2712','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('416','2713','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('417','2714','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('418','2715','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('419','2716','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('420','2717','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('421','2718','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('422','2719','1','1','1','2024-04-23 10:27:10','2024-04-23 10:27:10');
INSERT INTO employee_settings VALUES('423','2720','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('424','2721','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('425','2722','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('426','2723','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('427','2724','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('428','2725','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('429','2726','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('430','2727','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('431','2728','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('432','2729','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('433','2730','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('434','2731','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('435','2732','1','1','1','2024-04-23 10:27:11','2024-04-23 10:27:11');
INSERT INTO employee_settings VALUES('436','2733','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('437','2734','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('438','2735','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('439','2736','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('440','2737','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('441','2738','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('442','2739','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('443','2740','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('444','2741','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('445','2742','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('446','2743','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('447','2744','1','1','1','2024-04-23 10:27:12','2024-04-23 10:27:12');
INSERT INTO employee_settings VALUES('448','2745','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('449','2746','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('450','2747','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('451','2748','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('452','2749','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('453','2750','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('454','2751','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('455','2752','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('456','2753','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('457','2754','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('458','2755','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('459','2756','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('460','2757','1','1','1','2024-04-23 10:27:13','2024-04-23 10:27:13');
INSERT INTO employee_settings VALUES('461','2758','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('462','2759','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('463','2760','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('464','2761','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('465','2762','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('466','2763','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('467','2764','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('468','2765','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('469','2766','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('470','2767','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('471','2768','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('472','2769','1','1','1','2024-04-23 10:27:14','2024-04-23 10:27:14');
INSERT INTO employee_settings VALUES('473','2770','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('474','2771','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('475','2772','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('476','2773','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('477','2774','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('478','2775','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('479','2776','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('480','2777','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('481','2778','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('482','2779','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('483','2780','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('484','2781','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('485','2782','1','1','1','2024-04-23 10:27:15','2024-04-23 10:27:15');
INSERT INTO employee_settings VALUES('486','2783','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('487','2784','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('488','2785','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('489','2786','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('490','2787','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('491','2788','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('492','2789','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('493','2790','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('494','2791','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('495','2792','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('496','2793','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('497','2794','1','1','1','2024-04-23 10:27:16','2024-04-23 10:27:16');
INSERT INTO employee_settings VALUES('498','2795','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('499','2796','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('500','2797','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('501','2798','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('502','2799','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('503','2800','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('504','2801','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('505','2802','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('506','2803','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('507','2804','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('508','2805','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('509','2806','1','1','1','2024-04-23 10:27:17','2024-04-23 10:27:17');
INSERT INTO employee_settings VALUES('510','2807','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('511','2808','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('512','2809','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('513','2810','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('514','2811','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('515','2812','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('516','2813','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('517','2814','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('518','2815','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('519','2816','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('520','2817','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('521','2818','1','1','1','2024-04-23 10:27:18','2024-04-23 10:27:18');
INSERT INTO employee_settings VALUES('522','2819','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('523','2820','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('524','2821','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('525','2822','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('526','2823','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('527','2824','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('528','2825','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('529','2826','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('530','2827','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('531','2828','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('532','2829','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('533','2830','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('534','2831','1','1','1','2024-04-23 10:27:19','2024-04-23 10:27:19');
INSERT INTO employee_settings VALUES('535','2832','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('536','2833','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('537','2834','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('538','2835','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('539','2836','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('540','2837','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('541','2838','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('542','2839','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('543','2840','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('544','2841','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('545','2842','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('546','2843','1','1','1','2024-04-23 10:27:20','2024-04-23 10:27:20');
INSERT INTO employee_settings VALUES('547','2844','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('548','2845','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('549','2846','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('550','2847','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('551','2848','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('552','2849','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('553','2850','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('554','2851','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('555','2852','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('556','2853','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('557','2854','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('558','2855','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('559','2856','1','1','1','2024-04-23 10:27:21','2024-04-23 10:27:21');
INSERT INTO employee_settings VALUES('560','2857','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('561','2858','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('562','2859','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('563','2860','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('564','2861','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('565','2862','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('566','2863','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('567','2864','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('568','2865','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('569','2866','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('570','2867','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('571','2868','1','1','1','2024-04-23 10:27:22','2024-04-23 10:27:22');
INSERT INTO employee_settings VALUES('572','2869','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('573','2870','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('574','2871','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('575','2872','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('576','2873','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('577','2874','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('578','2875','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('579','2876','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('580','2877','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('581','2878','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('582','2879','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('583','2880','1','1','1','2024-04-23 10:27:23','2024-04-23 10:27:23');
INSERT INTO employee_settings VALUES('584','2881','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('585','2882','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('586','2883','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('587','2884','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('588','2885','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('589','2886','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('590','2887','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('591','2888','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('592','2889','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('593','2890','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('594','2891','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('595','2892','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('596','2893','1','1','1','2024-04-23 10:27:24','2024-04-23 10:27:24');
INSERT INTO employee_settings VALUES('597','2894','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('598','2895','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('599','2896','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('600','2897','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('601','2898','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('602','2899','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('603','2900','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('604','2901','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('605','2902','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('606','2903','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('607','2904','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('608','2905','1','1','1','2024-04-23 10:27:25','2024-04-23 10:27:25');
INSERT INTO employee_settings VALUES('609','2906','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('610','2907','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('611','2908','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('612','2909','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('613','2910','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('614','2911','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('615','2912','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('616','2913','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('617','2914','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('618','2915','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('619','2916','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('620','2917','1','1','1','2024-04-23 10:27:26','2024-04-23 10:27:26');
INSERT INTO employee_settings VALUES('621','2918','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('622','2919','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('623','2920','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('624','2921','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('625','2922','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('626','2923','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('627','2924','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('628','2925','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('629','2926','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('630','2927','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('631','2928','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('632','2929','1','1','1','2024-04-23 10:27:27','2024-04-23 10:27:27');
INSERT INTO employee_settings VALUES('633','2930','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('634','2931','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('635','2932','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('636','2933','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('637','2934','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('638','2935','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('639','2936','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('640','2937','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('641','2938','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('642','2939','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('643','2940','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('644','2941','1','1','1','2024-04-23 10:27:28','2024-04-23 10:27:28');
INSERT INTO employee_settings VALUES('645','2942','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('646','2943','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('647','2944','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('648','2945','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('649','2946','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('650','2947','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('651','2948','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('652','2949','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('653','2950','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('654','2951','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('655','2952','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('656','2953','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('657','2954','1','1','1','2024-04-23 10:27:29','2024-04-23 10:27:29');
INSERT INTO employee_settings VALUES('658','2955','1','1','1','2024-04-23 10:27:30','2024-04-23 10:27:30');
INSERT INTO employee_settings VALUES('659','2956','1','1','1','2024-04-23 10:27:30','2024-04-23 10:27:30');
INSERT INTO employee_settings VALUES('660','2957','1','1','1','2024-04-23 10:27:30','2024-04-23 10:27:30');
INSERT INTO employee_settings VALUES('661','2958','1','1','1','2024-04-23 10:27:30','2024-04-23 10:27:30');
INSERT INTO employee_settings VALUES('662','2959','1','1','1','2024-04-23 10:27:30','2024-04-23 10:27:30');
INSERT INTO employee_settings VALUES('663','2960','1','1','1','2024-04-23 10:27:30','2024-04-23 10:27:30');
INSERT INTO employee_settings VALUES('664','2961','1','1','1','2024-04-23 10:27:30','2024-04-23 10:27:30');
INSERT INTO employee_settings VALUES('665','2962','1','1','1','2024-04-23 10:27:30','2024-04-23 10:27:30');
INSERT INTO employee_settings VALUES('666','2963','1','1','1','2024-04-23 10:27:30','2024-04-23 10:27:30');
INSERT INTO employee_settings VALUES('667','2964','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('668','2965','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('669','2966','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('670','2967','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('671','2968','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('672','2969','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('673','2970','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('674','2971','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('675','2972','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('676','2973','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('677','2974','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('678','2975','1','1','1','2024-04-23 10:27:31','2024-04-23 10:27:31');
INSERT INTO employee_settings VALUES('679','2976','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('680','2977','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('681','2978','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('682','2979','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('683','2980','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('684','2981','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('685','2982','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('686','2983','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('687','2984','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('688','2985','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('689','2986','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('690','2987','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('691','2988','1','1','1','2024-04-23 10:27:32','2024-04-23 10:27:32');
INSERT INTO employee_settings VALUES('692','2989','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('693','2990','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('694','2991','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('695','2992','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('696','2993','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('697','2994','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('698','2995','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('699','2996','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('700','2997','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('701','2998','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('702','2999','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('703','3000','1','1','1','2024-04-23 10:27:33','2024-04-23 10:27:33');
INSERT INTO employee_settings VALUES('704','3001','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('705','3002','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('706','3003','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('707','3004','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('708','3005','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('709','3006','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('710','3007','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('711','3008','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('712','3009','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('713','3010','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('714','3011','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('715','3012','1','1','1','2024-04-23 10:27:34','2024-04-23 10:27:34');
INSERT INTO employee_settings VALUES('716','3013','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('717','3014','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('718','3015','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('719','3016','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('720','3017','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('721','3018','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('722','3019','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('723','3020','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('724','3021','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('725','3022','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('726','3023','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('727','3024','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('728','3025','1','1','1','2024-04-23 10:27:35','2024-04-23 10:27:35');
INSERT INTO employee_settings VALUES('729','3026','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('730','3027','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('731','3028','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('732','3029','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('733','3030','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('734','3031','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('735','3032','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('736','3033','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('737','3034','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('738','3035','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('739','3036','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('740','3037','1','1','1','2024-04-23 10:27:36','2024-04-23 10:27:36');
INSERT INTO employee_settings VALUES('741','3038','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('742','3039','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('743','3040','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('744','3041','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('745','3042','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('746','3043','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('747','3044','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('748','3045','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('749','3046','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('750','3047','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('751','3048','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('752','3049','1','1','1','2024-04-23 10:27:37','2024-04-23 10:27:37');
INSERT INTO employee_settings VALUES('753','3050','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('754','3051','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('755','3052','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('756','3053','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('757','3054','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('758','3055','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('759','3056','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('760','3057','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('761','3058','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('762','3059','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('763','3060','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('764','3061','1','1','1','2024-04-23 10:27:38','2024-04-23 10:27:38');
INSERT INTO employee_settings VALUES('765','3062','1','1','1','2024-04-23 10:27:39','2024-04-23 10:27:39');
INSERT INTO employee_settings VALUES('766','3063','1','1','1','2024-04-23 10:27:39','2024-04-23 10:27:39');
INSERT INTO employee_settings VALUES('767','3064','1','1','1','2024-04-23 10:27:39','2024-04-23 10:27:39');
INSERT INTO employee_settings VALUES('768','3065','1','1','1','2024-04-23 10:27:39','2024-04-23 10:27:39');
INSERT INTO employee_settings VALUES('769','3066','1','1','1','2024-04-23 10:27:39','2024-04-23 10:27:39');
INSERT INTO employee_settings VALUES('770','3068','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('771','3069','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('772','3070','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('773','3071','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('774','3072','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('775','3073','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('776','3074','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('777','3075','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('778','3076','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('779','3077','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('780','3078','1','1','1','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employee_settings VALUES('781','3079','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('782','3080','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('783','3081','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('784','3082','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('785','3083','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('786','3084','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('787','3085','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('788','3086','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('789','3087','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('790','3088','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('791','3089','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('792','3090','1','1','1','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employee_settings VALUES('793','3091','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('794','3092','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('795','3093','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('796','3094','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('797','3095','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('798','3096','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('799','3097','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('800','3098','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('801','3099','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('802','3100','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('803','3101','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('804','3102','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('805','3103','1','1','1','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employee_settings VALUES('806','3104','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('807','3105','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('808','3106','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('809','3107','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('810','3108','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('811','3109','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('812','3110','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('813','3111','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('814','3112','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('815','3113','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('816','3114','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('817','3115','1','1','1','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employee_settings VALUES('818','3116','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('819','3117','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('820','3118','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('821','3119','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('822','3120','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('823','3121','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('824','3122','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('825','3123','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('826','3124','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('827','3125','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('828','3126','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('829','3127','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('830','3128','1','1','1','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employee_settings VALUES('831','3129','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('832','3130','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('833','3131','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('834','3132','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('835','3133','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('836','3134','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('837','3135','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('838','3136','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('839','3137','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('840','3138','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('841','3139','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('842','3140','1','1','1','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employee_settings VALUES('843','3141','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('844','3142','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('845','3143','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('846','3144','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('847','3145','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('848','3146','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('849','3147','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('850','3148','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('851','3149','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('852','3150','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('853','3151','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('854','3152','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('855','3153','1','1','1','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employee_settings VALUES('856','3154','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('857','3155','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('858','3156','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('859','3157','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('860','3158','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('861','3159','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('862','3160','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('863','3161','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('864','3162','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('865','3163','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('866','3164','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('867','3165','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('868','3166','1','1','1','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employee_settings VALUES('869','3167','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('870','3168','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('871','3169','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('872','3170','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('873','3171','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('874','3172','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('875','3173','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('876','3174','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('877','3175','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('878','3176','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('879','3177','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('880','3178','1','1','1','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employee_settings VALUES('881','3179','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('882','3180','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('883','3181','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('884','3182','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('885','3183','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('886','3184','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('887','3185','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('888','3186','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('889','3187','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('890','3188','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('891','3189','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('892','3190','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('893','3191','1','1','1','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employee_settings VALUES('894','3192','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('895','3193','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('896','3194','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('897','3195','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('898','3196','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('899','3197','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('900','3198','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('901','3199','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('902','3200','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('903','3201','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('904','3202','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('905','3203','1','1','1','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employee_settings VALUES('906','3204','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('907','3205','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('908','3206','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('909','3207','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('910','3208','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('911','3209','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('912','3210','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('913','3211','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('914','3212','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('915','3213','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('916','3214','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('917','3215','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('918','3216','1','1','1','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employee_settings VALUES('919','3217','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('920','3218','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('921','3219','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('922','3220','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('923','3221','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('924','3222','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('925','3223','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('926','3224','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('927','3225','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('928','3226','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('929','3227','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('930','3228','1','1','1','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employee_settings VALUES('931','3229','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('932','3230','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('933','3231','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('934','3232','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('935','3233','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('936','3234','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('937','3235','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('938','3236','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('939','3237','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('940','3238','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('941','3239','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('942','3240','1','1','1','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employee_settings VALUES('943','3241','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('944','3242','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('945','3243','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('946','3244','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('947','3245','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('948','3246','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('949','3247','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('950','3248','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('951','3249','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('952','3250','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('953','3251','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('954','3252','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('955','3253','1','1','1','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employee_settings VALUES('956','3254','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('957','3255','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('958','3256','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('959','3257','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('960','3258','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('961','3259','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('962','3260','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('963','3261','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('964','3262','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('965','3263','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('966','3264','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('967','3265','1','1','1','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employee_settings VALUES('968','3266','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('969','3267','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('970','3268','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('971','3269','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('972','3270','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('973','3271','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('974','3272','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('975','3273','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('976','3274','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('977','3275','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('978','3276','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('979','3277','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('980','3278','1','1','1','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employee_settings VALUES('981','3279','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('982','3280','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('983','3281','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('984','3282','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('985','3283','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('986','3284','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('987','3285','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('988','3286','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('989','3287','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('990','3288','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('991','3289','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('992','3290','1','1','1','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employee_settings VALUES('993','3291','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('994','3292','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('995','3293','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('996','3294','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('997','3295','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('998','3296','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('999','3297','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('1000','3298','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('1001','3299','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('1002','3300','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('1003','3301','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('1004','3302','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('1005','3303','1','1','1','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employee_settings VALUES('1006','3304','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1007','3305','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1008','3306','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1009','3307','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1010','3308','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1011','3309','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1012','3310','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1013','3311','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1014','3312','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1015','3313','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1016','3314','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1017','3315','1','1','1','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employee_settings VALUES('1018','3316','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1019','3317','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1020','3318','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1021','3319','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1022','3320','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1023','3321','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1024','3322','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1025','3323','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1026','3324','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1027','3325','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1028','3326','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1029','3327','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1030','3328','1','1','1','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employee_settings VALUES('1031','3329','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1032','3330','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1033','3331','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1034','3332','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1035','3333','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1036','3334','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1037','3335','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1038','3336','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1039','3337','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1040','3338','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1041','3339','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1042','3340','1','1','1','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employee_settings VALUES('1043','3341','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1044','3342','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1045','3343','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1046','3344','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1047','3345','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1048','3346','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1049','3347','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1050','3348','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1051','3349','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1052','3350','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1053','3351','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1054','3352','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1055','3353','1','1','1','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employee_settings VALUES('1056','3354','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1057','3355','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1058','3356','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1059','3357','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1060','3358','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1061','3359','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1062','3360','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1063','3361','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1064','3362','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1065','3363','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1066','3364','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1067','3365','1','1','1','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employee_settings VALUES('1068','3366','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1069','3367','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1070','3368','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1071','3369','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1072','3370','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1073','3371','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1074','3372','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1075','3373','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1076','3374','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1077','3375','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1078','3376','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1079','3377','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1080','3378','1','1','1','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employee_settings VALUES('1081','3379','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1082','3380','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1083','3381','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1084','3382','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1085','3383','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1086','3384','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1087','3385','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1088','3386','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1089','3387','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1090','3388','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1091','3389','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1092','3390','1','1','1','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employee_settings VALUES('1093','3391','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1094','3392','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1095','3393','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1096','3394','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1097','3395','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1098','3396','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1099','3397','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1100','3398','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1101','3399','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1102','3400','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1103','3401','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1104','3402','1','1','1','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employee_settings VALUES('1105','3403','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1106','3404','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1107','3405','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1108','3406','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1109','3407','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1110','3408','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1111','3409','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1112','3410','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1113','3411','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1114','3412','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1115','3413','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1116','3414','1','1','1','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employee_settings VALUES('1117','3415','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1118','3416','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1119','3417','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1120','3418','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1121','3419','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1122','3420','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1123','3421','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1124','3422','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1125','3423','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1126','3424','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1127','3425','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1128','3426','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1129','3427','1','1','1','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employee_settings VALUES('1130','3428','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1131','3429','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1132','3430','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1133','3431','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1134','3432','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1135','3433','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1136','3434','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1137','3435','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1138','3436','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1139','3437','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1140','3438','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1141','3439','1','1','1','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employee_settings VALUES('1142','3440','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1143','3441','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1144','3442','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1145','3443','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1146','3444','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1147','3445','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1148','3446','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1149','3447','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1150','3448','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1151','3449','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1152','3450','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1153','3451','1','1','1','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employee_settings VALUES('1154','3452','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1155','3453','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1156','3454','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1157','3455','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1158','3456','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1159','3457','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1160','3458','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1161','3459','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1162','3460','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1163','3461','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1164','3462','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1165','3463','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1166','3464','1','1','1','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employee_settings VALUES('1167','3465','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1168','3466','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1169','3467','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1170','3468','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1171','3469','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1172','3470','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1173','3471','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1174','3472','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1175','3473','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1176','3474','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1177','3475','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1178','3476','1','1','1','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employee_settings VALUES('1179','3477','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1180','3478','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1181','3479','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1182','3480','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1183','3481','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1184','3482','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1185','3483','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1186','3484','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1187','3485','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1188','3486','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1189','3487','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1190','3488','1','1','1','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employee_settings VALUES('1191','3489','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1192','3490','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1193','3491','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1194','3492','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1195','3493','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1196','3494','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1197','3495','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1198','3496','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1199','3497','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1200','3498','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1201','3499','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1202','3500','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1203','3501','1','1','1','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employee_settings VALUES('1204','3502','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1205','3503','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1206','3504','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1207','3505','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1208','3506','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1209','3507','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1210','3508','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1211','3509','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1212','3510','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1213','3511','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1214','3512','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1215','3513','1','1','1','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employee_settings VALUES('1216','3514','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1217','3515','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1218','3516','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1219','3517','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1220','3518','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1221','3519','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1222','3520','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1223','3521','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1224','3522','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1225','3523','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1226','3524','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1227','3525','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1228','3526','1','1','1','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employee_settings VALUES('1229','3527','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1230','3528','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1231','3529','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1232','3530','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1233','3531','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1234','3532','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1235','3533','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1236','3534','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1237','3535','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1238','3536','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1239','3537','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1240','3538','1','1','1','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employee_settings VALUES('1241','3539','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1242','3540','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1243','3541','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1244','3542','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1245','3543','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1246','3544','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1247','3545','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1248','3546','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1249','3547','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1250','3548','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1251','3549','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1252','3550','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1253','3551','1','1','1','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employee_settings VALUES('1254','3552','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1255','3553','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1256','3554','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1257','3555','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1258','3556','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1259','3557','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1260','3558','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1261','3559','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1262','3560','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1263','3561','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1264','3562','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1265','3563','1','1','1','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employee_settings VALUES('1266','3564','1','1','1','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_settings VALUES('1267','3565','1','1','1','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_settings VALUES('1268','3566','1','1','1','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_settings VALUES('1269','3567','1','1','1','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_settings VALUES('1270','3568','1','1','1','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_settings VALUES('1271','3569','1','1','1','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_settings VALUES('1272','3570','1','1','1','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_settings VALUES('1273','3571','1','1','1','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_settings VALUES('1274','3572','1','1','1','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_settings VALUES('1275','3573','1','1','1','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employee_settings VALUES('1276','3574','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1277','3575','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1278','3576','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1279','3577','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1280','3578','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1281','3579','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1282','3580','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1283','3581','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1284','3582','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1285','3583','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1286','3584','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1287','3585','1','1','1','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employee_settings VALUES('1288','3586','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1289','3587','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1290','3588','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1291','3589','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1292','3590','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1293','3591','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1294','3592','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1295','3593','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1296','3594','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1297','3595','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1298','3596','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1299','3597','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1300','3598','1','1','1','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employee_settings VALUES('1301','3599','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1302','3600','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1303','3601','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1304','3602','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1305','3603','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1306','3604','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1307','3605','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1308','3606','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1309','3607','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1310','3608','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1311','3609','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1312','3610','1','1','1','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employee_settings VALUES('1313','3611','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1314','3612','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1315','3613','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1316','3614','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1317','3615','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1318','3616','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1319','3617','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1320','3618','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1321','3619','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1322','3620','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1323','3621','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1324','3622','1','1','1','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employee_settings VALUES('1325','3623','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1326','3624','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1327','3625','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1328','3626','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1329','3627','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1330','3628','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1331','3629','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1332','3630','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1333','3631','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1334','3632','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1335','3633','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1336','3634','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1337','3635','1','1','1','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employee_settings VALUES('1338','3636','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1339','3637','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1340','3638','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1341','3639','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1342','3640','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1343','3641','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1344','3642','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1345','3643','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1346','3644','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1347','3645','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1348','3646','1','1','1','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employee_settings VALUES('1349','3647','1','1','1','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_settings VALUES('1350','3648','1','1','1','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_settings VALUES('1351','3649','1','1','1','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_settings VALUES('1352','3650','1','1','1','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_settings VALUES('1353','3651','1','1','1','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_settings VALUES('1354','3652','1','1','1','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_settings VALUES('1355','3653','1','1','1','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_settings VALUES('1356','3654','1','1','1','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_settings VALUES('1357','3655','1','1','1','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employee_settings VALUES('1358','3656','1','1','1','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_settings VALUES('1359','3657','1','1','1','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_settings VALUES('1360','3658','1','1','1','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_settings VALUES('1361','3659','1','1','1','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_settings VALUES('1362','3660','1','1','1','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_settings VALUES('1363','3661','1','1','1','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employee_settings VALUES('1364','3662','1','1','1','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_settings VALUES('1365','3663','1','1','1','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_settings VALUES('1366','3664','1','1','1','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_settings VALUES('1367','3665','1','1','1','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_settings VALUES('1368','3666','1','1','1','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_settings VALUES('1369','3667','1','1','1','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employee_settings VALUES('1370','3668','1','1','1','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_settings VALUES('1371','3669','1','1','1','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_settings VALUES('1372','3670','1','1','1','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_settings VALUES('1373','3671','1','1','1','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_settings VALUES('1374','3672','1','1','1','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_settings VALUES('1375','3673','1','1','1','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employee_settings VALUES('1376','3674','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1377','3675','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1378','3676','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1379','3677','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1380','3678','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1381','3679','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1382','3680','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1383','3681','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1384','3682','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1385','3683','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1386','3684','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1387','3685','1','1','1','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employee_settings VALUES('1388','3686','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1389','3687','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1390','3688','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1391','3689','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1392','3690','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1393','3691','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1394','3692','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1395','3693','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1396','3694','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1397','3695','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1398','3696','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1399','3697','1','1','1','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employee_settings VALUES('1400','3698','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1401','3699','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1402','3700','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1403','3701','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1404','3702','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1405','3703','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1406','3704','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1407','3705','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1408','3706','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1409','3707','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1410','3708','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1411','3709','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1412','3710','1','1','1','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employee_settings VALUES('1413','3711','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1414','3712','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1415','3713','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1416','3714','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1417','3715','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1418','3716','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1419','3717','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1420','3718','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1421','3719','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1422','3720','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1423','3721','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1424','3722','1','1','1','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employee_settings VALUES('1425','3723','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1426','3724','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1427','3725','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1428','3726','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1429','3727','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1430','3728','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1431','3729','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1432','3730','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1433','3731','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1434','3732','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1435','3733','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1436','3734','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1437','3735','1','1','1','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employee_settings VALUES('1438','3736','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1439','3737','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1440','3738','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1441','3739','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1442','3740','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1443','3741','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1444','3742','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1445','3743','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1446','3744','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1447','3745','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1448','3746','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1449','3747','1','1','1','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employee_settings VALUES('1450','3748','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1451','3749','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1452','3750','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1453','3751','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1454','3752','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1455','3753','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1456','3754','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1457','3755','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1458','3756','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1459','3757','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1460','3758','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1461','3759','1','1','1','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employee_settings VALUES('1462','3760','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1463','3761','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1464','3762','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1465','3763','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1466','3764','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1467','3765','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1468','3766','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1469','3767','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1470','3768','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1471','3769','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1472','3770','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1473','3771','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1474','3772','1','1','1','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employee_settings VALUES('1475','3773','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1476','3774','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1477','3775','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1478','3776','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1479','3777','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1480','3778','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1481','3779','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1482','3780','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1483','3781','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1484','3782','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1485','3783','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1486','3784','1','1','1','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employee_settings VALUES('1487','3785','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1488','3786','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1489','3787','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1490','3788','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1491','3789','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1492','3790','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1493','3791','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1494','3792','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1495','3793','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1496','3794','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1497','3795','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1498','3796','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1499','3797','1','1','1','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employee_settings VALUES('1500','3798','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1501','3799','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1502','3800','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1503','3801','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1504','3802','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1505','3803','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1506','3804','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1507','3805','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1508','3806','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1509','3807','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1510','3808','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1511','3809','1','1','1','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employee_settings VALUES('1512','3810','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1513','3811','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1514','3812','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1515','3813','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1516','3814','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1517','3815','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1518','3816','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1519','3817','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1520','3818','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1521','3819','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1522','3820','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1523','3821','1','1','1','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employee_settings VALUES('1524','3822','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1525','3823','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1526','3824','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1527','3825','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1528','3826','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1529','3827','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1530','3828','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1531','3829','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1532','3830','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1533','3831','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1534','3832','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1535','3833','1','1','1','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employee_settings VALUES('1536','3834','1','1','1','2024-04-23 17:15:23','2024-04-23 17:15:23');
INSERT INTO employee_settings VALUES('1537','3835','1','1','1','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employee_settings VALUES('1538','3836','1','1','1','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employee_settings VALUES('1539','3837','1','1','1','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employee_settings VALUES('1540','3838','1','1','1','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employee_settings VALUES('1541','3839','1','1','1','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employee_settings VALUES('1542','3840','1','1','1','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employee_settings VALUES('1543','3841','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1544','3842','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1545','3843','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1546','3844','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1547','3845','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1548','3846','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1549','3847','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1550','3848','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1551','3849','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1552','3850','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1553','3851','1','1','1','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employee_settings VALUES('1982','4280','1','1','1','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_settings VALUES('1983','4281','1','1','1','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_settings VALUES('1984','4282','1','1','1','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_settings VALUES('1985','4283','1','1','1','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_settings VALUES('1986','4284','1','1','1','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_settings VALUES('1987','4285','1','1','1','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_settings VALUES('1988','4286','1','1','1','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_settings VALUES('1989','4287','1','1','1','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_settings VALUES('1990','4288','1','1','1','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_settings VALUES('1991','4289','1','1','1','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employee_settings VALUES('1992','4290','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('1993','4291','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('1994','4292','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('1995','4293','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('1996','4294','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('1997','4295','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('1998','4296','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('1999','4297','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('2000','4298','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('2001','4299','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('2002','4300','1','1','1','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employee_settings VALUES('2003','4301','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2004','4302','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2005','4303','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2006','4304','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2007','4305','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2008','4306','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2009','4307','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2010','4308','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2011','4309','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2012','4310','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2013','4311','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2014','4312','1','1','1','2024-04-29 16:18:42','2024-04-29 16:18:42');
INSERT INTO employee_settings VALUES('2015','4313','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2016','4314','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2017','4315','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2018','4316','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2019','4317','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2020','4318','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2021','4319','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2022','4320','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2023','4321','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2024','4322','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2025','4323','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2026','4324','1','1','1','2024-04-29 16:18:43','2024-04-29 16:18:43');
INSERT INTO employee_settings VALUES('2027','4325','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2028','4326','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2029','4327','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2030','4328','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2031','4329','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2032','4330','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2033','4331','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2034','4332','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2035','4333','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2036','4334','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2037','4335','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2038','4336','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2039','4337','1','1','1','2024-04-29 16:18:44','2024-04-29 16:18:44');
INSERT INTO employee_settings VALUES('2040','4338','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2041','4339','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2042','4340','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2043','4341','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2044','4342','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2045','4343','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2046','4344','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2047','4345','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2048','4346','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2049','4347','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2050','4348','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2051','4349','1','1','1','2024-04-29 16:18:45','2024-04-29 16:18:45');
INSERT INTO employee_settings VALUES('2052','4350','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2053','4351','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2054','4352','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2055','4353','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2056','4354','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2057','4355','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2058','4356','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2059','4357','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2060','4358','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2061','4359','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2062','4360','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2063','4361','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2064','4362','1','1','1','2024-04-29 16:18:46','2024-04-29 16:18:46');
INSERT INTO employee_settings VALUES('2065','4363','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2066','4364','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2067','4365','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2068','4366','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2069','4367','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2070','4368','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2071','4369','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2072','4370','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2073','4371','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2074','4372','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2075','4373','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2076','4374','1','1','1','2024-04-29 16:18:47','2024-04-29 16:18:47');
INSERT INTO employee_settings VALUES('2077','4375','1','1','1','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_settings VALUES('2078','4376','1','1','1','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_settings VALUES('2079','4377','1','1','1','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_settings VALUES('2080','4378','1','1','1','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_settings VALUES('2081','4379','1','1','1','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_settings VALUES('2082','4380','1','1','1','2024-04-29 16:18:48','2024-04-29 16:18:48');
INSERT INTO employee_settings VALUES('2083','4381','1','1','1','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_settings VALUES('2084','4382','1','1','1','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_settings VALUES('2085','4383','1','1','1','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_settings VALUES('2086','4384','1','1','1','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_settings VALUES('2087','4385','1','1','1','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_settings VALUES('2088','4386','1','1','1','2024-04-29 16:18:49','2024-04-29 16:18:49');
INSERT INTO employee_settings VALUES('2089','4387','1','1','1','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_settings VALUES('2090','4388','1','1','1','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_settings VALUES('2091','4389','1','1','1','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_settings VALUES('2092','4390','1','1','1','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_settings VALUES('2093','4391','1','1','1','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_settings VALUES('2094','4392','1','1','1','2024-04-29 16:18:50','2024-04-29 16:18:50');
INSERT INTO employee_settings VALUES('2095','4393','1','1','1','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_settings VALUES('2096','4394','1','1','1','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_settings VALUES('2097','4395','1','1','1','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_settings VALUES('2098','4396','1','1','1','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_settings VALUES('2099','4397','1','1','1','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_settings VALUES('2100','4398','1','1','1','2024-04-29 16:18:51','2024-04-29 16:18:51');
INSERT INTO employee_settings VALUES('2101','4399','1','1','1','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_settings VALUES('2102','4400','1','1','1','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_settings VALUES('2103','4401','1','1','1','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_settings VALUES('2104','4402','1','1','1','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_settings VALUES('2105','4403','1','1','1','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_settings VALUES('2106','4404','1','1','1','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_settings VALUES('2107','4405','1','1','1','2024-04-29 16:18:52','2024-04-29 16:18:52');
INSERT INTO employee_settings VALUES('2108','4406','1','1','1','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_settings VALUES('2109','4407','1','1','1','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_settings VALUES('2110','4408','1','1','1','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_settings VALUES('2111','4409','1','1','1','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_settings VALUES('2112','4410','1','1','1','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_settings VALUES('2113','4411','1','1','1','2024-04-29 16:18:53','2024-04-29 16:18:53');
INSERT INTO employee_settings VALUES('2114','4412','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2115','4413','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2116','4414','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2117','4415','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2118','4416','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2119','4417','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2120','4418','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2121','4419','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2122','4420','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2123','4421','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2124','4422','1','1','1','2024-04-29 16:18:54','2024-04-29 16:18:54');
INSERT INTO employee_settings VALUES('2125','4423','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2126','4424','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2127','4425','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2128','4426','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2129','4427','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2130','4428','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2131','4429','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2132','4430','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2133','4431','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2134','4432','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2135','4433','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2136','4434','1','1','1','2024-04-29 16:18:55','2024-04-29 16:18:55');
INSERT INTO employee_settings VALUES('2137','4435','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2138','4436','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2139','4437','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2140','4438','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2141','4439','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2142','4440','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2143','4441','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2144','4442','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2145','4443','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2146','4444','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2147','4445','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2148','4446','1','1','1','2024-04-29 16:18:56','2024-04-29 16:18:56');
INSERT INTO employee_settings VALUES('2149','4447','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2150','4448','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2151','4449','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2152','4450','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2153','4451','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2154','4452','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2155','4453','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2156','4454','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2157','4455','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2158','4456','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2159','4457','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2160','4458','1','1','1','2024-04-29 16:18:57','2024-04-29 16:18:57');
INSERT INTO employee_settings VALUES('2161','4459','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2162','4460','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2163','4461','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2164','4462','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2165','4463','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2166','4464','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2167','4465','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2168','4466','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2169','4467','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2170','4468','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2171','4469','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2172','4470','1','1','1','2024-04-29 16:18:58','2024-04-29 16:18:58');
INSERT INTO employee_settings VALUES('2173','4471','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2174','4472','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2175','4473','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2176','4474','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2177','4475','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2178','4476','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2179','4477','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2180','4478','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2181','4479','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2182','4480','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2183','4481','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2184','4482','1','1','1','2024-04-29 16:18:59','2024-04-29 16:18:59');
INSERT INTO employee_settings VALUES('2185','4483','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2186','4484','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2187','4485','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2188','4486','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2189','4487','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2190','4488','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2191','4489','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2192','4490','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2193','4491','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2194','4492','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2195','4493','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2196','4494','1','1','1','2024-04-29 16:19:00','2024-04-29 16:19:00');
INSERT INTO employee_settings VALUES('2197','4495','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2198','4496','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2199','4497','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2200','4498','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2201','4499','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2202','4500','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2203','4501','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2204','4502','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2205','4503','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2206','4504','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2207','4505','1','1','1','2024-04-29 16:19:01','2024-04-29 16:19:01');
INSERT INTO employee_settings VALUES('2208','4506','1','1','1','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_settings VALUES('2209','4507','1','1','1','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_settings VALUES('2210','4508','1','1','1','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_settings VALUES('2211','4509','1','1','1','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_settings VALUES('2212','4510','1','1','1','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_settings VALUES('2213','4511','1','1','1','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_settings VALUES('2214','4512','1','1','1','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_settings VALUES('2215','4513','1','1','1','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_settings VALUES('2216','4514','1','1','1','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_settings VALUES('2217','4515','1','1','1','2024-04-29 16:19:02','2024-04-29 16:19:02');
INSERT INTO employee_settings VALUES('2218','4516','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2219','4517','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2220','4518','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2221','4519','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2222','4520','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2223','4521','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2224','4522','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2225','4523','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2226','4524','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2227','4525','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2228','4526','1','1','1','2024-04-29 16:19:03','2024-04-29 16:19:03');
INSERT INTO employee_settings VALUES('2229','4527','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2230','4528','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2231','4529','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2232','4530','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2233','4531','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2234','4532','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2235','4533','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2236','4534','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2237','4535','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2238','4536','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2239','4537','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2240','4538','1','1','1','2024-04-29 16:19:04','2024-04-29 16:19:04');
INSERT INTO employee_settings VALUES('2241','4539','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2242','4540','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2243','4541','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2244','4542','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2245','4543','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2246','4544','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2247','4545','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2248','4546','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2249','4547','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2250','4548','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2251','4549','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2252','4550','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2253','4551','1','1','1','2024-04-29 16:19:05','2024-04-29 16:19:05');
INSERT INTO employee_settings VALUES('2254','4552','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2255','4553','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2256','4554','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2257','4555','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2258','4556','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2259','4557','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2260','4558','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2261','4559','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2262','4560','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2263','4561','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2264','4562','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2265','4563','1','1','1','2024-04-29 16:19:06','2024-04-29 16:19:06');
INSERT INTO employee_settings VALUES('2266','4564','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2267','4565','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2268','4566','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2269','4567','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2270','4568','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2271','4569','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2272','4570','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2273','4571','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2274','4572','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2275','4573','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2276','4574','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2277','4575','1','1','1','2024-04-29 16:19:07','2024-04-29 16:19:07');
INSERT INTO employee_settings VALUES('2278','4576','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2279','4577','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2280','4578','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2281','4579','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2282','4580','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2283','4581','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2284','4582','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2285','4583','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2286','4584','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2287','4585','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2288','4586','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2289','4587','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2290','4588','1','1','1','2024-04-29 16:19:08','2024-04-29 16:19:08');
INSERT INTO employee_settings VALUES('2291','4589','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2292','4590','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2293','4591','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2294','4592','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2295','4593','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2296','4594','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2297','4595','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2298','4596','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2299','4597','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2300','4598','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2301','4599','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2302','4600','1','1','1','2024-04-29 16:19:09','2024-04-29 16:19:09');
INSERT INTO employee_settings VALUES('2303','4601','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2304','4602','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2305','4603','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2306','4604','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2307','4605','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2308','4606','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2309','4607','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2310','4608','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2311','4609','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2312','4610','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2313','4611','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2314','4612','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2315','4613','1','1','1','2024-04-29 16:19:10','2024-04-29 16:19:10');
INSERT INTO employee_settings VALUES('2316','4614','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2317','4615','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2318','4616','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2319','4617','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2320','4618','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2321','4619','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2322','4620','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2323','4621','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2324','4622','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2325','4623','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2326','4624','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2327','4625','1','1','1','2024-04-29 16:19:11','2024-04-29 16:19:11');
INSERT INTO employee_settings VALUES('2328','4626','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2329','4627','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2330','4628','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2331','4629','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2332','4630','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2333','4631','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2334','4632','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2335','4633','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2336','4634','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2337','4635','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2338','4636','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2339','4637','1','1','1','2024-04-29 16:19:12','2024-04-29 16:19:12');
INSERT INTO employee_settings VALUES('2340','4638','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2341','4639','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2342','4640','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2343','4641','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2344','4642','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2345','4643','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2346','4644','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2347','4645','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2348','4646','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2349','4647','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2350','4648','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2351','4649','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2352','4650','1','1','1','2024-04-29 16:19:13','2024-04-29 16:19:13');
INSERT INTO employee_settings VALUES('2353','4651','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2354','4652','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2355','4653','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2356','4654','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2357','4655','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2358','4656','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2359','4657','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2360','4658','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2361','4659','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2362','4660','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2363','4661','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2364','4662','1','1','1','2024-04-29 16:19:14','2024-04-29 16:19:14');
INSERT INTO employee_settings VALUES('2365','4663','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2366','4664','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2367','4665','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2368','4666','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2369','4667','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2370','4668','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2371','4669','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2372','4670','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2373','4671','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2374','4672','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2375','4673','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2376','4674','1','1','1','2024-04-29 16:19:15','2024-04-29 16:19:15');
INSERT INTO employee_settings VALUES('2377','4675','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2378','4676','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2379','4677','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2380','4678','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2381','4679','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2382','4680','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2383','4681','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2384','4682','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2385','4683','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2386','4684','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2387','4685','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2388','4686','1','1','1','2024-04-29 16:19:16','2024-04-29 16:19:16');
INSERT INTO employee_settings VALUES('2389','4687','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2390','4688','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2391','4689','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2392','4690','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2393','4691','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2394','4692','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2395','4693','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2396','4694','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2397','4695','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2398','4696','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2399','4697','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2400','4698','1','1','1','2024-04-29 16:19:17','2024-04-29 16:19:17');
INSERT INTO employee_settings VALUES('2401','4699','1','1','1','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_settings VALUES('2402','4700','1','1','1','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_settings VALUES('2403','4701','1','1','1','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_settings VALUES('2404','4702','1','1','1','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_settings VALUES('2405','4703','1','1','1','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_settings VALUES('2406','4704','1','1','1','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_settings VALUES('2407','4705','1','1','1','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_settings VALUES('2408','4706','1','1','1','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_settings VALUES('2409','4707','1','1','1','2024-04-29 16:19:18','2024-04-29 16:19:18');
INSERT INTO employee_settings VALUES('3773','6073','1','1','1','2024-05-06 22:40:16','2024-05-06 22:40:16');
INSERT INTO employee_settings VALUES('3774','6074','1','1','1','2024-05-06 22:40:16','2024-05-06 22:40:16');
INSERT INTO employee_settings VALUES('3775','6075','1','1','1','2024-05-06 22:40:16','2024-05-06 22:40:16');
INSERT INTO employee_settings VALUES('3776','6076','1','1','1','2024-05-06 22:40:16','2024-05-06 22:40:16');
INSERT INTO employee_settings VALUES('3777','6077','1','1','1','2024-05-06 22:40:16','2024-05-06 22:40:16');
INSERT INTO employee_settings VALUES('3778','6078','1','1','1','2024-05-06 22:40:16','2024-05-06 22:40:16');
INSERT INTO employee_settings VALUES('3779','6079','1','1','1','2024-05-06 22:40:16','2024-05-06 22:40:16');
INSERT INTO employee_settings VALUES('3780','6080','1','1','1','2024-05-06 22:40:16','2024-05-06 22:40:16');
INSERT INTO employee_settings VALUES('3781','6081','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3782','6082','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3783','6083','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3784','6084','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3785','6085','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3786','6086','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3787','6087','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3788','6088','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3789','6089','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3790','6090','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3791','6091','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3792','6092','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3793','6093','1','1','1','2024-05-06 22:40:17','2024-05-06 22:40:17');
INSERT INTO employee_settings VALUES('3794','6094','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3795','6095','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3796','6096','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3797','6097','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3798','6098','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3799','6099','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3800','6100','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3801','6101','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3802','6102','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3803','6103','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3804','6104','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3805','6105','1','1','1','2024-05-06 22:40:18','2024-05-06 22:40:18');
INSERT INTO employee_settings VALUES('3806','6106','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3807','6107','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3808','6108','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3809','6109','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3810','6110','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3811','6111','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3812','6112','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3813','6113','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3814','6114','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3815','6115','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3816','6116','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3817','6117','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3818','6118','1','1','1','2024-05-06 22:40:19','2024-05-06 22:40:19');
INSERT INTO employee_settings VALUES('3819','6119','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3820','6120','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3821','6121','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3822','6122','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3823','6123','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3824','6124','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3825','6125','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3826','6126','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3827','6127','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3828','6128','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3829','6129','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3830','6130','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3831','6131','1','1','1','2024-05-06 22:40:20','2024-05-06 22:40:20');
INSERT INTO employee_settings VALUES('3832','6132','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3833','6133','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3834','6134','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3835','6135','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3836','6136','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3837','6137','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3838','6138','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3839','6139','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3840','6140','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3841','6141','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3842','6142','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3843','6143','1','1','1','2024-05-06 22:40:21','2024-05-06 22:40:21');
INSERT INTO employee_settings VALUES('3844','6144','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3845','6145','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3846','6146','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3847','6147','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3848','6148','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3849','6149','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3850','6150','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3851','6151','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3852','6152','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3853','6153','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3854','6154','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3855','6155','1','1','1','2024-05-06 22:40:22','2024-05-06 22:40:22');
INSERT INTO employee_settings VALUES('3856','6156','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3857','6157','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3858','6158','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3859','6159','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3860','6160','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3861','6161','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3862','6162','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3863','6163','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3864','6164','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3865','6165','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3866','6166','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3867','6167','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3868','6168','1','1','1','2024-05-06 22:40:23','2024-05-06 22:40:23');
INSERT INTO employee_settings VALUES('3869','6169','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3870','6170','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3871','6171','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3872','6172','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3873','6173','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3874','6174','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3875','6175','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3876','6176','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3877','6177','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3878','6178','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3879','6179','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3880','6180','1','1','1','2024-05-06 22:40:24','2024-05-06 22:40:24');
INSERT INTO employee_settings VALUES('3881','6181','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3882','6182','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3883','6183','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3884','6184','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3885','6185','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3886','6186','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3887','6187','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3888','6188','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3889','6189','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3890','6190','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3891','6191','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3892','6192','1','1','1','2024-05-06 22:40:25','2024-05-06 22:40:25');
INSERT INTO employee_settings VALUES('3893','6193','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3894','6194','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3895','6195','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3896','6196','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3897','6197','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3898','6198','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3899','6199','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3900','6200','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3901','6201','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3902','6202','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3903','6203','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3904','6204','1','1','1','2024-05-06 22:40:26','2024-05-06 22:40:26');
INSERT INTO employee_settings VALUES('3905','6205','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3906','6206','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3907','6207','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3908','6208','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3909','6209','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3910','6210','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3911','6211','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3912','6212','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3913','6213','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3914','6214','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3915','6215','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3916','6216','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3917','6217','1','1','1','2024-05-06 22:40:27','2024-05-06 22:40:27');
INSERT INTO employee_settings VALUES('3918','6218','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3919','6219','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3920','6220','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3921','6221','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3922','6222','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3923','6223','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3924','6224','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3925','6225','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3926','6226','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3927','6227','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3928','6228','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3929','6229','1','1','1','2024-05-06 22:40:28','2024-05-06 22:40:28');
INSERT INTO employee_settings VALUES('3930','6230','1','1','1','2024-05-06 22:40:29','2024-05-06 22:40:29');
INSERT INTO employee_settings VALUES('3931','6231','1','1','1','2024-05-06 22:40:29','2024-05-06 22:40:29');
INSERT INTO employee_settings VALUES('3932','6232','1','1','1','2024-05-06 22:40:29','2024-05-06 22:40:29');
INSERT INTO employee_settings VALUES('3933','6233','1','1','1','2024-05-06 22:40:29','2024-05-06 22:40:29');
INSERT INTO employee_settings VALUES('3934','6234','1','1','1','2024-05-06 22:40:29','2024-05-06 22:40:29');
INSERT INTO employee_settings VALUES('3935','6235','1','1','1','2024-05-06 22:40:29','2024-05-06 22:40:29');
INSERT INTO employee_settings VALUES('3936','6236','1','1','1','2024-05-06 22:40:29','2024-05-06 22:40:29');
INSERT INTO employee_settings VALUES('3937','6237','1','1','1','2024-05-08 11:09:50','2024-05-08 11:09:50');
INSERT INTO employee_settings VALUES('3938','6238','1','1','1','2024-05-08 11:09:50','2024-05-08 11:09:50');
INSERT INTO employee_settings VALUES('3939','6239','1','1','1','2024-05-08 11:09:50','2024-05-08 11:09:50');
INSERT INTO employee_settings VALUES('3940','6240','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3941','6241','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3942','6242','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3943','6243','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3944','6244','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3945','6245','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3946','6246','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3947','6247','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3948','6248','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3949','6249','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3950','6250','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3951','6251','1','1','1','2024-05-08 11:09:51','2024-05-08 11:09:51');
INSERT INTO employee_settings VALUES('3952','6252','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3953','6253','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3954','6254','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3955','6255','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3956','6256','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3957','6257','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3958','6258','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3959','6259','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3960','6260','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3961','6261','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3962','6262','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3963','6263','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3964','6264','1','1','1','2024-05-08 11:09:52','2024-05-08 11:09:52');
INSERT INTO employee_settings VALUES('3965','6265','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3966','6266','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3967','6267','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3968','6268','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3969','6269','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3970','6270','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3971','6271','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3972','6272','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3973','6273','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3974','6274','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3975','6275','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3976','6276','1','1','1','2024-05-08 11:09:53','2024-05-08 11:09:53');
INSERT INTO employee_settings VALUES('3977','6277','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3978','6278','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3979','6279','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3980','6280','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3981','6281','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3982','6282','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3983','6283','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3984','6284','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3985','6285','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3986','6286','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3987','6287','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3988','6288','1','1','1','2024-05-08 11:09:54','2024-05-08 11:09:54');
INSERT INTO employee_settings VALUES('3989','6289','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('3990','6290','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('3991','6291','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('3992','6292','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('3993','6293','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('3994','6294','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('3995','6295','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('3996','6296','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('3997','6297','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('3998','6298','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('3999','6299','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('4000','6300','1','1','1','2024-05-08 11:09:55','2024-05-08 11:09:55');
INSERT INTO employee_settings VALUES('4001','6301','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4002','6302','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4003','6303','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4004','6304','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4005','6305','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4006','6306','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4007','6307','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4008','6308','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4009','6309','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4010','6310','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4011','6311','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4012','6312','1','1','1','2024-05-08 11:09:56','2024-05-08 11:09:56');
INSERT INTO employee_settings VALUES('4013','6313','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4014','6314','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4015','6315','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4016','6316','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4017','6317','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4018','6318','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4019','6319','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4020','6320','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4021','6321','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4022','6322','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4023','6323','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4024','6324','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4025','6325','1','1','1','2024-05-08 11:09:57','2024-05-08 11:09:57');
INSERT INTO employee_settings VALUES('4026','6326','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4027','6327','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4028','6328','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4029','6329','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4030','6330','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4031','6331','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4032','6332','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4033','6333','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4034','6334','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4035','6335','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4036','6336','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4037','6337','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4038','6338','1','1','1','2024-05-08 11:09:58','2024-05-08 11:09:58');
INSERT INTO employee_settings VALUES('4039','6339','1','1','1','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_settings VALUES('4040','6340','1','1','1','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_settings VALUES('4041','6341','1','1','1','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_settings VALUES('4042','6342','1','1','1','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_settings VALUES('4043','6343','1','1','1','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_settings VALUES('4044','6344','1','1','1','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_settings VALUES('4045','6345','1','1','1','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_settings VALUES('4046','6346','1','1','1','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_settings VALUES('4047','6347','1','1','1','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_settings VALUES('4048','6348','1','1','1','2024-05-08 11:09:59','2024-05-08 11:09:59');
INSERT INTO employee_settings VALUES('4049','6349','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4050','6350','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4051','6351','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4052','6352','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4053','6353','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4054','6354','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4055','6355','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4056','6356','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4057','6357','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4058','6358','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4059','6359','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4060','6360','1','1','1','2024-05-08 11:10:00','2024-05-08 11:10:00');
INSERT INTO employee_settings VALUES('4061','6361','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4062','6362','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4063','6363','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4064','6364','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4065','6365','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4066','6366','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4067','6367','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4068','6368','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4069','6369','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4070','6370','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4071','6371','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4072','6372','1','1','1','2024-05-08 11:10:01','2024-05-08 11:10:01');
INSERT INTO employee_settings VALUES('4073','6373','1','1','1','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_settings VALUES('4074','6374','1','1','1','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_settings VALUES('4075','6375','1','1','1','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_settings VALUES('4076','6376','1','1','1','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_settings VALUES('4077','6377','1','1','1','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_settings VALUES('4078','6378','1','1','1','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_settings VALUES('4079','6379','1','1','1','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_settings VALUES('4080','6380','1','1','1','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_settings VALUES('4081','6381','1','1','1','2024-05-08 11:10:02','2024-05-08 11:10:02');
INSERT INTO employee_settings VALUES('4082','6382','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4083','6383','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4084','6384','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4085','6385','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4086','6386','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4087','6387','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4088','6388','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4089','6389','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4090','6390','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4091','6391','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4092','6392','1','1','1','2024-05-08 11:10:03','2024-05-08 11:10:03');
INSERT INTO employee_settings VALUES('4093','6393','1','1','1','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_settings VALUES('4094','6394','1','1','1','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_settings VALUES('4095','6395','1','1','1','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_settings VALUES('4096','6396','1','1','1','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_settings VALUES('4097','6397','1','1','1','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_settings VALUES('4098','6398','1','1','1','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_settings VALUES('4099','6399','1','1','1','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_settings VALUES('4100','6400','1','1','1','2024-05-08 11:10:04','2024-05-08 11:10:04');
INSERT INTO employee_settings VALUES('4526','6826','1','1','1','2024-05-08 11:23:14','2024-05-08 11:23:14');
INSERT INTO employee_settings VALUES('4527','6827','1','1','1','2024-05-08 11:23:14','2024-05-08 11:23:14');
INSERT INTO employee_settings VALUES('4528','6828','1','1','1','2024-05-08 11:23:14','2024-05-08 11:23:14');
INSERT INTO employee_settings VALUES('4529','6829','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4530','6830','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4531','6831','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4532','6832','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4533','6833','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4534','6834','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4535','6835','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4536','6836','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4537','6837','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4538','6838','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4539','6839','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4540','6840','1','1','1','2024-05-08 11:23:15','2024-05-08 11:23:15');
INSERT INTO employee_settings VALUES('4541','6841','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4542','6842','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4543','6843','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4544','6844','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4545','6845','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4546','6846','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4547','6847','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4548','6848','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4549','6849','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4550','6850','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4551','6851','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4552','6852','1','1','1','2024-05-08 11:23:16','2024-05-08 11:23:16');
INSERT INTO employee_settings VALUES('4553','6853','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4554','6854','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4555','6855','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4556','6856','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4557','6857','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4558','6858','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4559','6859','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4560','6860','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4561','6861','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4562','6862','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4563','6863','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4564','6864','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4565','6865','1','1','1','2024-05-08 11:23:17','2024-05-08 11:23:17');
INSERT INTO employee_settings VALUES('4566','6866','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4567','6867','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4568','6868','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4569','6869','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4570','6870','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4571','6871','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4572','6872','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4573','6873','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4574','6874','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4575','6875','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4576','6876','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4577','6877','1','1','1','2024-05-08 11:23:18','2024-05-08 11:23:18');
INSERT INTO employee_settings VALUES('4578','6878','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4579','6879','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4580','6880','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4581','6881','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4582','6882','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4583','6883','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4584','6884','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4585','6885','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4586','6886','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4587','6887','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4588','6888','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4589','6889','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4590','6890','1','1','1','2024-05-08 11:23:19','2024-05-08 11:23:19');
INSERT INTO employee_settings VALUES('4591','6891','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4592','6892','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4593','6893','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4594','6894','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4595','6895','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4596','6896','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4597','6897','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4598','6898','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4599','6899','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4600','6900','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4601','6901','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4602','6902','1','1','1','2024-05-08 11:23:20','2024-05-08 11:23:20');
INSERT INTO employee_settings VALUES('4603','6903','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4604','6904','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4605','6905','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4606','6906','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4607','6907','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4608','6908','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4609','6909','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4610','6910','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4611','6911','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4612','6912','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4613','6913','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4614','6914','1','1','1','2024-05-08 11:23:21','2024-05-08 11:23:21');
INSERT INTO employee_settings VALUES('4615','6915','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4616','6916','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4617','6917','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4618','6918','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4619','6919','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4620','6920','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4621','6921','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4622','6922','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4623','6923','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4624','6924','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4625','6925','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4626','6926','1','1','1','2024-05-08 11:23:22','2024-05-08 11:23:22');
INSERT INTO employee_settings VALUES('4627','6927','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4628','6928','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4629','6929','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4630','6930','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4631','6931','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4632','6932','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4633','6933','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4634','6934','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4635','6935','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4636','6936','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4637','6937','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4638','6938','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4639','6939','1','1','1','2024-05-08 11:23:23','2024-05-08 11:23:23');
INSERT INTO employee_settings VALUES('4640','6940','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4641','6941','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4642','6942','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4643','6943','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4644','6944','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4645','6945','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4646','6946','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4647','6947','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4648','6948','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4649','6949','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4650','6950','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4651','6951','1','1','1','2024-05-08 11:23:24','2024-05-08 11:23:24');
INSERT INTO employee_settings VALUES('4652','6952','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4653','6953','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4654','6954','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4655','6955','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4656','6956','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4657','6957','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4658','6958','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4659','6959','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4660','6960','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4661','6961','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4662','6962','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4663','6963','1','1','1','2024-05-08 11:23:25','2024-05-08 11:23:25');
INSERT INTO employee_settings VALUES('4664','6964','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4665','6965','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4666','6966','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4667','6967','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4668','6968','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4669','6969','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4670','6970','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4671','6971','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4672','6972','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4673','6973','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4674','6974','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4675','6975','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4676','6976','1','1','1','2024-05-08 11:23:26','2024-05-08 11:23:26');
INSERT INTO employee_settings VALUES('4677','6977','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4678','6978','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4679','6979','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4680','6980','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4681','6981','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4682','6982','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4683','6983','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4684','6984','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4685','6985','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4686','6986','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4687','6987','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4688','6988','1','1','1','2024-05-08 11:23:27','2024-05-08 11:23:27');
INSERT INTO employee_settings VALUES('4689','6989','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4690','6990','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4691','6991','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4692','6992','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4693','6993','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4694','6994','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4695','6995','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4696','6996','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4697','6997','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4698','6998','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4699','6999','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4700','7000','1','1','1','2024-05-08 11:23:28','2024-05-08 11:23:28');
INSERT INTO employee_settings VALUES('4701','7001','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4702','7002','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4703','7003','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4704','7004','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4705','7005','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4706','7006','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4707','7007','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4708','7008','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4709','7009','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4710','7010','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4711','7011','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4712','7012','1','1','1','2024-05-08 11:23:29','2024-05-08 11:23:29');
INSERT INTO employee_settings VALUES('4713','7013','1','1','1','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_settings VALUES('4714','7014','1','1','1','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_settings VALUES('4715','7015','1','1','1','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_settings VALUES('4716','7016','1','1','1','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_settings VALUES('4717','7017','1','1','1','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_settings VALUES('4718','7018','1','1','1','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_settings VALUES('4719','7019','1','1','1','2024-05-08 11:23:30','2024-05-08 11:23:30');
INSERT INTO employee_settings VALUES('5237','7537','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5238','7538','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5239','7539','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5240','7540','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5241','7541','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5242','7542','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5243','7543','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5244','7544','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5245','7545','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5246','7546','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5247','7547','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5248','7548','1','1','1','2024-05-08 17:01:48','2024-05-08 17:01:48');
INSERT INTO employee_settings VALUES('5249','7549','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5250','7550','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5251','7551','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5252','7552','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5253','7553','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5254','7554','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5255','7555','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5256','7556','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5257','7557','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5258','7558','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5259','7559','1','1','1','2024-05-08 17:01:49','2024-05-08 17:01:49');
INSERT INTO employee_settings VALUES('5260','7560','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5261','7561','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5262','7562','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5263','7563','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5264','7564','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5265','7565','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5266','7566','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5267','7567','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5268','7568','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5269','7569','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5270','7570','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5271','7571','1','1','1','2024-05-08 17:01:50','2024-05-08 17:01:50');
INSERT INTO employee_settings VALUES('5272','7572','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5273','7573','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5274','7574','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5275','7575','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5276','7576','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5277','7577','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5278','7578','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5279','7579','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5280','7580','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5281','7581','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5282','7582','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5283','7583','1','1','1','2024-05-08 17:01:51','2024-05-08 17:01:51');
INSERT INTO employee_settings VALUES('5284','7584','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5285','7585','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5286','7586','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5287','7587','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5288','7588','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5289','7589','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5290','7590','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5291','7591','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5292','7592','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5293','7593','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5294','7594','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5295','7595','1','1','1','2024-05-08 17:01:52','2024-05-08 17:01:52');
INSERT INTO employee_settings VALUES('5296','7596','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5297','7597','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5298','7598','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5299','7599','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5300','7600','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5301','7601','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5302','7602','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5303','7603','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5304','7604','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5305','7605','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5306','7606','1','1','1','2024-05-08 17:01:53','2024-05-08 17:01:53');
INSERT INTO employee_settings VALUES('5307','7607','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5308','7608','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5309','7609','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5310','7610','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5311','7611','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5312','7612','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5313','7613','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5314','7614','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5315','7615','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5316','7616','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5317','7617','1','1','1','2024-05-08 17:01:54','2024-05-08 17:01:54');
INSERT INTO employee_settings VALUES('5318','7618','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5319','7619','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5320','7620','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5321','7621','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5322','7622','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5323','7623','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5324','7624','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5325','7625','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5326','7626','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5327','7627','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5328','7628','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5329','7629','1','1','1','2024-05-08 17:01:55','2024-05-08 17:01:55');
INSERT INTO employee_settings VALUES('5330','7630','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5331','7631','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5332','7632','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5333','7633','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5334','7634','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5335','7635','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5336','7636','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5337','7637','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5338','7638','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5339','7639','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5340','7640','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5341','7641','1','1','1','2024-05-08 17:01:56','2024-05-08 17:01:56');
INSERT INTO employee_settings VALUES('5342','7642','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5343','7643','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5344','7644','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5345','7645','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5346','7646','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5347','7647','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5348','7648','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5349','7649','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5350','7650','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5351','7651','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5352','7652','1','1','1','2024-05-08 17:01:57','2024-05-08 17:01:57');
INSERT INTO employee_settings VALUES('5353','7653','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5354','7654','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5355','7655','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5356','7656','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5357','7657','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5358','7658','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5359','7659','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5360','7660','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5361','7661','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5362','7662','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5363','7663','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5364','7664','1','1','1','2024-05-08 17:01:58','2024-05-08 17:01:58');
INSERT INTO employee_settings VALUES('5365','7665','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5366','7666','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5367','7667','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5368','7668','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5369','7669','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5370','7670','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5371','7671','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5372','7672','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5373','7673','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5374','7674','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5375','7675','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5376','7676','1','1','1','2024-05-08 17:01:59','2024-05-08 17:01:59');
INSERT INTO employee_settings VALUES('5377','7677','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5378','7678','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5379','7679','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5380','7680','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5381','7681','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5382','7682','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5383','7683','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5384','7684','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5385','7685','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5386','7686','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5387','7687','1','1','1','2024-05-08 17:02:00','2024-05-08 17:02:00');
INSERT INTO employee_settings VALUES('5388','7688','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5389','7689','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5390','7690','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5391','7691','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5392','7692','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5393','7693','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5394','7694','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5395','7695','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5396','7696','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5397','7697','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5398','7698','1','1','1','2024-05-08 17:02:01','2024-05-08 17:02:01');
INSERT INTO employee_settings VALUES('5399','7699','1','1','1','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_settings VALUES('5400','7700','1','1','1','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_settings VALUES('5401','7701','1','1','1','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_settings VALUES('5402','7702','1','1','1','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_settings VALUES('5403','7703','1','1','1','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_settings VALUES('5404','7704','1','1','1','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_settings VALUES('5405','7705','1','1','1','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_settings VALUES('5406','7706','1','1','1','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_settings VALUES('5407','7707','1','1','1','2024-05-08 17:02:02','2024-05-08 17:02:02');
INSERT INTO employee_settings VALUES('5408','7708','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5409','7709','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5410','7710','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5411','7711','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5412','7712','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5413','7713','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5414','7714','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5415','7715','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5416','7716','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5417','7717','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5418','7718','1','1','1','2024-05-08 17:02:03','2024-05-08 17:02:03');
INSERT INTO employee_settings VALUES('5419','7719','1','1','1','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_settings VALUES('5420','7720','1','1','1','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_settings VALUES('5421','7721','1','1','1','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_settings VALUES('5422','7722','1','1','1','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_settings VALUES('5423','7723','1','1','1','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_settings VALUES('5424','7724','1','1','1','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_settings VALUES('5425','7725','1','1','1','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_settings VALUES('5426','7726','1','1','1','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_settings VALUES('5427','7727','1','1','1','2024-05-08 17:02:04','2024-05-08 17:02:04');
INSERT INTO employee_settings VALUES('5428','7728','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5429','7729','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5430','7730','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5431','7731','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5432','7732','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5433','7733','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5434','7734','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5435','7735','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5436','7736','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5437','7737','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5438','7738','1','1','1','2024-05-08 17:02:05','2024-05-08 17:02:05');
INSERT INTO employee_settings VALUES('5439','7739','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5440','7740','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5441','7741','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5442','7742','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5443','7743','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5444','7744','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5445','7745','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5446','7746','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5447','7747','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5448','7748','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5449','7749','1','1','1','2024-05-08 17:02:06','2024-05-08 17:02:06');
INSERT INTO employee_settings VALUES('5450','7750','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5451','7751','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5452','7752','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5453','7753','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5454','7754','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5455','7755','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5456','7756','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5457','7757','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5458','7758','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5459','7759','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5460','7760','1','1','1','2024-05-08 17:02:07','2024-05-08 17:02:07');
INSERT INTO employee_settings VALUES('5461','7761','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5462','7762','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5463','7763','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5464','7764','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5465','7765','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5466','7766','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5467','7767','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5468','7768','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5469','7769','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5470','7770','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5471','7771','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5472','7772','1','1','1','2024-05-08 17:02:08','2024-05-08 17:02:08');
INSERT INTO employee_settings VALUES('5473','7773','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5474','7774','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5475','7775','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5476','7776','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5477','7777','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5478','7778','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5479','7779','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5480','7780','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5481','7781','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5482','7782','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5483','7783','1','1','1','2024-05-08 17:02:09','2024-05-08 17:02:09');
INSERT INTO employee_settings VALUES('5484','7784','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5485','7785','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5486','7786','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5487','7787','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5488','7788','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5489','7789','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5490','7790','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5491','7791','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5492','7792','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5493','7793','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5494','7794','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5495','7795','1','1','1','2024-05-08 17:02:10','2024-05-08 17:02:10');
INSERT INTO employee_settings VALUES('5496','7796','1','1','1','2024-05-08 17:02:11','2024-05-08 17:02:11');
INSERT INTO employee_settings VALUES('5497','7797','1','1','1','2024-05-08 17:02:11','2024-05-08 17:02:11');
INSERT INTO employee_settings VALUES('5498','7798','1','1','1','2024-05-08 17:02:11','2024-05-08 17:02:11');
INSERT INTO employee_settings VALUES('5499','7799','1','1','1','2024-05-08 17:02:11','2024-05-08 17:02:11');
INSERT INTO employee_settings VALUES('5500','7800','1','1','1','2024-05-08 17:02:11','2024-05-08 17:02:11');



CREATE TABLE `employee_support_ticket` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `support_ticket_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`support_ticket_id`),
  KEY `employee_support_ticket_support_ticket_id_foreign` (`support_ticket_id`),
  CONSTRAINT `employee_support_ticket_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_support_ticket_support_ticket_id_foreign` FOREIGN KEY (`support_ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_task` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `task_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`task_id`),
  KEY `employee_task_task_id_foreign` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_training_list` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `training_list_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`training_list_id`),
  KEY `employee_training_list_training_list_id_foreign` (`training_list_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_work_experience` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `company_name` varchar(191) NOT NULL,
  `from_year` date DEFAULT NULL,
  `to_year` date DEFAULT NULL,
  `post` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_work_experience_employee_id_foreign` (`employee_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employees` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `staff_id` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `identity_number` varchar(191) NOT NULL,
  `npwp` varchar(25) DEFAULT NULL,
  `contact_no` varchar(15) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `gender` varchar(191) DEFAULT NULL,
  `office_shift_id` bigint(20) unsigned DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `designation_id` bigint(20) unsigned DEFAULT NULL,
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `role_users_id` bigint(20) unsigned DEFAULT NULL,
  `status_id` bigint(20) unsigned DEFAULT NULL,
  `following_company_id` bigint(20) unsigned DEFAULT NULL,
  `following_employee_id` bigint(20) unsigned DEFAULT NULL,
  `coo` int(11) NOT NULL DEFAULT 0,
  `dept_head` int(11) NOT NULL DEFAULT 0,
  `supervisor` int(11) NOT NULL DEFAULT 0,
  `joining_date` date DEFAULT NULL,
  `exit_date` date DEFAULT NULL,
  `marital_status` varchar(191) DEFAULT NULL,
  `religion` varchar(191) DEFAULT NULL,
  `dependent` varchar(191) NOT NULL,
  `address` text DEFAULT NULL,
  `city` varchar(64) DEFAULT NULL,
  `state` varchar(64) DEFAULT NULL,
  `country` varchar(64) DEFAULT NULL,
  `zip_code` varchar(24) DEFAULT NULL,
  `cv` varchar(64) DEFAULT NULL,
  `skype_id` varchar(64) DEFAULT NULL,
  `fb_id` varchar(64) DEFAULT NULL,
  `twitter_id` varchar(64) DEFAULT NULL,
  `linkedIn_id` varchar(64) DEFAULT NULL,
  `whatsapp_id` varchar(64) DEFAULT NULL,
  `basic_salary` double DEFAULT 0,
  `basic_salary_custom` double DEFAULT NULL,
  `tunjangan_jabatan` double DEFAULT NULL,
  `payslip_type` varchar(191) DEFAULT NULL,
  `attendance_type` varchar(191) DEFAULT NULL,
  `total_leave` int(11) DEFAULT 0,
  `remaining_leave` int(11) DEFAULT 0,
  `last_year_leave` double NOT NULL,
  `pension_type` varchar(50) DEFAULT NULL,
  `pension_amount` double(8,2) DEFAULT 0.00,
  `is_dispensation` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  `is_payroll` tinyint(1) NOT NULL,
  `is_ceo` tinyint(1) NOT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employees_office_shift_id_foreign` (`office_shift_id`),
  KEY `employees_company_id_foreign` (`company_id`),
  KEY `employees_department_id_foreign` (`department_id`),
  KEY `employees_designation_id_foreign` (`designation_id`),
  KEY `employees_location_id_foreign` (`location_id`),
  KEY `employees_role_users_id_foreign` (`role_users_id`),
  KEY `employees_status_id_foreign` (`status_id`),
  KEY `employees_following_company_id_foreign` (`following_company_id`),
  KEY `employees_following_employee_id_foreign` (`following_employee_id`),
  CONSTRAINT `employees_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_designation_id_foreign` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_following_company_id_foreign` FOREIGN KEY (`following_company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_following_employee_id_foreign` FOREIGN KEY (`following_employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `locations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_office_shift_id_foreign` FOREIGN KEY (`office_shift_id`) REFERENCES `office_shifts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_role_users_id_foreign` FOREIGN KEY (`role_users_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employees_status_id_foreign` FOREIGN KEY (`status_id`) REFERENCES `statuses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7801 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employees VALUES('3068','OKI','CANDRA','AE02911','','1304042806820004','82.515.915.5-204.000','0','1982-07-28','Male','2','2','17','268','','2','1','','','0','0','0','2022-01-19','','married','','K/2','Jorong Cubadak Rt..- Rw.- Kel. Cubaadak Ke. Lima Kaum Kab. Tanah Datar','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3069','ARIANTO','DANDRES','AE03542','arianto.dandres@timas.com','1402011907950001','65.385.544.5-216.000','085264736353','1995-07-19','MALE','2','2','17','269','','2','1','','','0','0','0','2022-05-13','','single','','TK/0','JL.NARASINGA NO.66, RT.013, RW.004, KEL.KAMPUNG BESAR KOTA, KEC.RENGAT, KAB.INHU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3070','SALMAN','NOFARI','AE03460','','1408041811880002','15.021.384.1-222.000','081275556574','1988-11-18','MALE','2','2','43','326','','2','1','','','0','0','0','2022-05-09','','married','','K/2','JL.RAYA KM 5, RT.007, RW.006, KEL.PERAWANG, KEC.TUALANG, KAB.SIAK','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3071','SUTARTO','WS','AE03679','','1402121205600004','78.501.868.0-221.000','081378344723','1960-05-12','MALE','2','2','40','283','','2','1','','','0','0','0','2022-05-16','','married','','K/1','JL. PURWAJAYA, RT.000, RW.000, DESA SARILAMAK, KEC.HARAU, KAB.LIMA PULUH KOTA, PROV.SUMATRA BARAT','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3072','MUHAMMAD','AMIN SANDYSTA, S.E.,','AE03787','muhammad.amin@timas.com','1405020704940003','84.445.377.9-222.000','082299090660','1994-04-07','MALE','2','2','52','392','','2','1','','','0','0','0','2022-06-02','','single','','TK/0','JL. ARBES GG. NURUL SALAM NO. 123, RT.005, RW.006, KEL.PKL KERINCI TIMUR, KEC.PKL KERINCI, KAB. PELALAWAN PRO. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3073','RIZAL','GUNAWAN','AE03788','','1402091903000001','65.139.462.9-213.000','082392404680','2000-03-19','MALE','2','2','40','283','','2','1','','','0','0','0','2022-06-02','','single','','TK/0','LAMBANG SARI, RT.005, RW.003, DESA LAMBANG SARI I,II,III, KEC.LIRIK, KAB.INHU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3074','RIZKI','WAHYU RINALDI','AE03829','','1408041403960004','','082364577984','1996-03-14','MALE','2','2','43','326','','2','1','','','0','0','0','2022-05-31','','married','','K/1','DUSUN II SEI PUTIH RT 002, RW 001, KEL. KUALU NENAS, KEC. TAMBANG, KAB. KAMPAR, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3075','UNGGUL','AKBAR','AE03859','unggul.akbar@timas.com','1401033112890001','15.905.279.4-221.000','085271377191','1989-12-31','MALE','2','2','17','270','','2','1','','','0','0','0','2022-06-02','','married','','K/3','JL. TERATAI RT. 002 RW. 009 KEL. SIDOMULYO BARAT KEC. TAMPAN KOTA PEKANBARU PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3076','IDRIS','NASUTION','AE03846','','1471120105800061','65.328.036.2-211.000','082382395311','1980-05-01','MALE','2','2','40','284','','2','1','','','0','0','0','2022-05-30','','married','','K/2','JL. LIMBUNGAN GG. CEMARA, RT.003, RW.009, KEL. LIMBUNGAN, KEC. RUMBAI PESISIR, KOTA PEKANBARU, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3077','HERU','ARIYADI','AE03847','','1277023001030002','','081264788067','2003-01-30','MALE','2','2','43','327','','2','1','','','0','0','0','2022-05-30','','single','','TK/0','JL. R.  JUNJUNGAN LBS. GG ABADI. NO 46, RT.001, RW.003, KEL.UJUNG PADANG, KEC.PADANG SIDEMPUAN SELATAN, KOTA PADANG SIDEMPUAN, PROV. SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3078','ARDISON','','AE04423','','1303081309820001','','082174178348','1982-09-13','MALE','2','2','43','327','','2','1','','','0','0','0','2022-07-22','','married','','K/3','JL. BADAK KANAN, RT. 003, RW. 015, KEL. SIALANGSAKTI, KEC. TENAYAN RAYA, KOTA PEKANBARU, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:15','2024-04-23 17:11:15');
INSERT INTO employees VALUES('3079','JEFRI','MUNANDAR','AE04739','jefri.munandar@timas.com','1403042207952339','41.283.566.2-219.000','081364708356','1995-07-22','MALE','2','2','94','266','','2','1','','','0','0','0','2022-08-22','','single','','TK/0','JL. H. NAWAWI, RT. 001, RW. 003, KEL. PELANTAI, KEC. MERBAU, KAB. KEPULAUAN MERANTI, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3080','AFDHAL','FEBRIANDIWA','AE04742','','1305062502970002','60.662.822.0-201.000','089685079155','1997-02-25','MALE','2','2','25','260','','2','1','','','0','0','0','2022-08-24','','single','','TK/0','BASUNG SNGAI JANIH, RT. 000, RW. 000, KEL SIKUCUR, KEC. V KOTO KP CALAM, KAB. PADANG PARIAMAN, PROV. SUMATERA BARAT','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3081','APRIZAL','','AE04025','','1405020707820010','','082381189119','1982-07-07','MALE','2','2','17','271','','2','1','','','0','0','0','2022-06-23','','married','','K/3','JL.WAJIB SENYUM 04/09, PKL.KERINCI, KAB.PELALAWAN','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3082','DIMAS','NATAPRAYOGA, S.Pd','AE04098','dimas.nataprayoga@timas.com','1671131606880004','84.523.599.3-306.000','085384048008','1988-06-16','MALE','2','2','42','306','','2','1','','','0','0','0','2022-06-24','','married','','K/2','JL. KI MEROGAN LR MATARAM II NO. 474, RT. 008, RW. 002, KEL. KEMAS RINDO, KEC. KERTAPATI, KOTA PALEMBANG, PROV. SUMATERA SELATAN','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3083','Imam','Mujoko','AE00885','','1405021011740003','16.260.186.8-222.000','0','1974-11-10','MALE','2','2','17','272','','2','1','','','0','0','0','2020-08-01','','married','','K/2','Jl. Jambu GG. Putri Rt.002 Rw.004 Kel. Pangkalan Kerinci Kota Kec. Apngkalan Kerinci Kab. Pelalawan','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3084','Zakaria','','AE00881','','1405021011890002','72.906.733.0-222.000','081277706518','1989-11-10','MALE','2','2','17','273','','2','1','','','0','0','0','2020-08-01','','married','','K/2','Jl. Lintas Timur Gg. Famili Rt.006 Rw.005 Kel. Pangkalan Kerinci Timur Kec. Pangkalan Kerinci Kab. Pelalawan','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3085','ADIS','MAN ARI','AE00422','','1405022712940002','40.091.618.5-222.000','082288541839','1994-12-27','MALE','2','2','40','285','','2','1','','','0','0','0','2022-07-05','','married','','K/0','JL.ARIFIN PULAU PAYUNG, KEL.PANGKALAN KERINCI TIMUR, KEC.PANGKALAN KERINCI, PELALAWAN','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3086','YUSRI','','AE04289','','1405020910700006','','081365525032','1970-10-09','MALE','2','2','38','254','','2','1','','','0','0','0','2022-07-13','','single','','TK/0','JL. MELUR, RT. 002, RW. 005, KEC. PANGKALAN KERINCI, KAB. PELALAWAN, PROV. RIAU.','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3087','SOFYAN','WIRANDA','AE03182','','1219062107890004','63.219.665.5-115.000','085359149814','1989-07-21','MALE','2','2','17','274','','2','1','','','0','0','0','2022-03-15','','married','','K/2','DUSUN IV, RT.000/RW.000, KEL.PAHANG, KEC.TALAWI, KAB.BATUBARA, SUMUT','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3088','MERLANG','INDRA','AE03010','merlang.indra@timas.com','1471073006730001','15.785.438.1-216.000','082157990943','1973-06-30','MALE','2','2','42','307','','2','1','','','0','0','0','2022-01-31','','married','','K/2','JL.BUKIT BARISAN PERUM BUKIT BARISAN GARDEN REGENCY D3 RT/RW 003/005 KEL.TANGKERANG TIMUR-TENAYAN RAYA-PEKANBARU-RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3089','FAHMI','GUSMANTO','AE04396','','1307060808970001','','','1997-08-08','MALE','2','2','43','328','','2','1','','','0','0','0','2022-07-18','','single','','TK/0','LUBUAK NAGO','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3090','Firman','H','AE02909','','1375012010810001','16.211.904.4-202.000','','1981-10-20','Male','2','2','43','327','','2','1','','','0','0','0','2022-01-09','','married','','K/2','Jl. Abdurrahman Gg. Matoa A6 Rt.003 Rw.008 Kel. Pematng Pudu Kec. Mandau Kec. Bengklis','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:16','2024-04-23 17:11:16');
INSERT INTO employees VALUES('3091','SUGIARTO','','AE04439','','1308051508790002','60.230.556.7-202.000','081364673095','1978-02-15','MALE','2','2','97','325','','2','1','','','0','0','0','2022-07-27','','married','','K/2','KP. ANAU JR-III, RT. 000, RW. 000, KEL. SUNDATA, KEC. LUBUK SIKAPING, KAB. PASAMAN, PROV. SUMATERA BARAT','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3092','ALI','IMRAN YASIN','AE07184','','1104032903810002','67.143.659.0-121.000','081375361821','1981-03-29','MALE','2','2','43','327','','2','1','','','0','0','0','2022-10-21','','married','','K/2','DUSUN VIII JLN P SIANTAR NO. 82 A, RT. 000, RW. 000, KEL. PAGAR JATI, KEC. LUBUK PAKAM, KAB. DELI SERDANG, PROV. SUAMTERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3093','SURYA','PRAWIBOWO','AE00140','','1271112301970004','','082292413244','1997-01-23','MALE','2','2','38','255','','2','1','','','0','0','0','2022-05-21','','married','','K/2','JORONG DATA SEI TALEH, KEL.BARINGIN, KEC.PALEMBAYAN, KAB.AGAM, SUMBAR','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3094','ELISA','SEPTIA','AE04500','elisa.septia@timas.com','1471066209920001','94.966.437.9-211.000','082173568675','1992-09-22','FEMALE','2','2','55','406','','2','1','','','0','0','0','2022-07-25','','single','','TK/0','JL. TOMAN I, RT. 003, RW. 006, KEL. MUARAFAJAR BARAT, KEC. RUMBAI, KOTA PEKANBARU, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3095','ANDRIAN','PURNAMA','AE04615','','3201112907960002','86.346.904.5-403.000','0895320525669','1996-07-29','MALE','2','2','55','407','','2','1','','','0','0','0','2022-08-06','','single','','TK/0','KP. CURUG, RT. 004, RW. 004, KEL. CURUG, KEC. GUNUNG SINDUR, KAB. BOGOR, PROV. JAWA BARAT','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3096','RUDI','HARTONO','AE04642','rudi.hartanto@timas.com','1405020107950028','','082284572145','1995-08-07','MALE','2','2','40','283','','2','1','','','0','0','0','2022-08-12','','married','','K/2','RANTAU BARU, RT 02, RW 01, KEL/DESA RANTAU BARU, KEC. PANGKALAN KERINCI, KAB. PELALAWAN, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3097','ILHAM','MAULANA','AE04653','','1311011907000004','50.285.124.9-203.000','081363043343','2000-07-19','MALE','2','2','17','268','','2','1','','','0','0','0','2022-08-12','','single','','TK/0','AIA MANYURUAK, RT. 000, RW. 000, KEL. LUBUK GADANG SELATAN, KEC. SANGIR, KAB. SOLOK SELATAN, PROV. SUMATERA SELATAN','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3098','CHRISTIAN','GANINDA','AE03689','christian.ganinda@timas.com','3577020512860002','79.382.948.2-621.000','081280752225','1986-12-05','MALE','2','2','83','','','2','1','','','0','0','0','2022-05-23','','married','','K/3','JERUKWANGI, RT. 02, RW. 06, KEL. JERUK WANGI, KEC. BANGSRI, KAB. JEPARA, PROV. JAWA TENGAH','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3099','KHAIRUN','NISA SARAGIH','AE03014','','1218096010990010','63.066.176.7-114.000','082287913737','1999-10-20','FEMALE','2','2','83','362','','2','1','','','0','0','0','2022-02-07','','single','','TK/0','DUSUN I DESA MALASORI-DOLOK MASIHUL-SERDANG BEDAGAI-SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3100','SELAMAT','PRIADI SIREGAR','AE03772','','1205180112890001','88.602.305.0-119.000','085372754577','1989-12-01','MALE','2','2','83','363','','2','1','','','0','0','0','2022-05-26','','married','','K/0','LINGK. UTAMA KELURAHAN TANGKAHAN DURIAN KEC. BERANDAN BARAT KAB. LANGKAT','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3101','MARTUA','SINAGA','AE04708','','1216063009860002','94.139.332.4-222.000','081314283471','1986-09-30','MALE','2','2','45','336','','2','1','','','0','0','0','2022-08-20','','married','','K/1','JL. SEPAKAT GANG SUKA MAJU 1 NO. 17, RT. 002, RW. 008, KEL. PANGKALAN KERINCI TIMUR, KEC. PANGKALAN KERINCI, KAB. PELALAWAN, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3102','JAMSON','TAMPUBOLON','AE04856','','1407051304750003','','082288341766','1975-04-13','MALE','2','2','45','337','','2','1','','','0','0','0','2022-09-15','','married','','K/1','JL. KELUARGA, RT. 004, RW. 007, KEL. PANGKALAN KERINCI TIMUR, KEC. PANGKALAN KERINCI, KAB. PELALAWAN, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3103','REONALDO','PAMALIAN HUTABARAT','AE07302','','1403090110829054','84.620.484.0-219.000','085376781221','1982-10-01','MALE','2','2','43','327','','2','1','','','0','0','0','2022-11-22','','married','','K/1','JL. SIDOMULYO, RT. 003, RW. 001, KEL. SELATPANJANG TIMUR, KEC. TEBING TINGGI, KAB. KEPULAUAN MERANTI, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:17','2024-04-23 17:11:17');
INSERT INTO employees VALUES('3104','TOTO','EDI SUTIONO','AE03133','toto.sutiono@timas.com','1205141709700001','59.097.081.0-119.000','081264992227/08','1970-09-17','MALE','2','2','46','','','2','1','','','0','0','0','2022-02-27','','married','','K/2','DUSUN KAMPUNG JAWA, RT. 000, RW. 000, KEL. SECURAI SELATAN, KEC. BABALAN, KAB. LANGKAT, PROV. SUMATERA SELATAN','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3105','FARMA','SUHENDRA','AE04886','','1307131404020002','53.742.180.2-225.000','081276865881','2002-04-14','MALE','2','2','55','408','','2','1','','','0','0','0','2022-09-19','','single','','TK/0','GRIYA BATU AJI ASRI TAHAP 5 BLOK C2 NO. 12, RT. 002, RW. 017, KEL. SUNGAI LANGKAI, KEC. SAGULUNG, KOTA BATAM, PROV. KEPULAUAN RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3106','WELI','SANDRA','AE00145','weli.sandra@timas.com','1307062001860001','63.092.122.9-222.000','085265455965','1986-01-20','MALE','2','2','17','276','','2','1','','','0','0','0','2021-11-03','','married','','K/0','JL. TENGKU BEY I GG. ANGGUR,NO 178 002/003 SIMPANG TIGA,BUKIT RAYA KOTA PEKANBARU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3107','ARDIANSYAH','SIREGAR','AE04502','','1207232607930003','44.116.291.4-125.000','082365452961','1993-07-26','MALE','2','2','25','262','','2','1','','','0','0','0','2022-07-25','','single','','TK/0','JL. PEMBANGUNAN KM. 12 DSN IV, RT. 000, RW. 000, KEL. MULIOREJO, KEC. SUNGGAL, KAB. DELI SERDANG, PROV. SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3108','PANDU','RAHMADANI','AE07312','','3301222401980001','63.197.205.6-522.000','081225914835','1998-01-24','MALE','2','2','94','267','','2','1','','','0','0','0','2022-11-25','','single','','TK/0','JL. WILING NO.9,005/002,DONAN,CILACAPTENGAH,CILACAP,JAWA TENGAH','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3109','RIJEV','FARDIAN','AE07005','','2171061511791001','98.434.175.0-215.000','082390031424','1979-11-15','MALE','2','2','50','373','','2','1','','','0','0','0','2022-09-28','','married','','K/2','JL. JAMBU, RT. 007, RW. 004, KEL. PANGKALAN KERINCI TIMUR, KEC. PANGKALAN KERINCI, KAB. PELALAWAN, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3110','INDRA','WARMAN','AE02594','','1308050103780001','11.758.101.7-202.000','081378962033','1978-03-01','MALE','2','2','17','268','','2','1','','','0','0','0','2022-09-29','','single','','TK/0','AMPANG GADANG, PANTI SELATAN, RT. 000, RW. 000, KEL. PANTI SELATAN, KEC. PANTI, KAB. PASAMAN, PROV. SUMATERA BARAT','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3111','MHD.','FIRMANSAH ISMAIL','AE07053','','1219071103950001','','082283597543/ 0','1995-03-11','MALE','2','2','50','375','','2','1','','','0','0','0','2022-09-24','','married','','K/1','JL. DUA B47 MEDAN, RT. 000, RW. 000, KEL. PULO BRAYAN BENGKEL, KEC. MEDAN TIMUR, KOTA MEDAN, PROV. SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3112','MARTUNIS','','AE06703','','1108052903000001','','082259260169','2000-03-29','MALE','2','2','43','327','','2','1','','','0','0','0','2023-06-10','','single','','TK/0','KP.BANJAR BARU RT/RW.001/001 KEL.GUUNG KIJANG KEC.GUNUNG KIJANG KAB.BINTAN','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3113','WANTY','VERONICA PANGARIBUAN','AE02982','wanty.veronica@timas.com','1405025907000004','','+62 822-8711-81','2003-07-19','MALE','2','2','47','353','','2','1','','','0','0','0','2022-01-29','','single','','TK/0','JL. KELUARGA BTN BPP BLOK A8 NO. 24, RT. 001, RW. 007, KEL. PANGKALAN KERINCI TIMUR, KEC. PANGKALAN KERINCI, KAB. PELALAWAN, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3114','ABDUL','RAHMAN','AE99071','','1219061202030004','43.155.801.4-115.000','','2003-02-12','MALE','2','2','43','329','','2','1','','','0','0','0','2021-11-29','','single','','TK/0','DUSUNI I TANJUNG MULIA, RT. 000, RW. 000, KEL. TANJUNG MULIA, KEC. NIBUNG HANGUS, KAB. BATU BARA, PROV. SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3115','WANDI','MANIK','AE00439','','1408040301730004','48.006.988.9-212.000','081275184703','1973-01-03','MALE','2','2','43','326','','2','1','','','0','0','0','2021-11-26','','married','','K/3','BTN CENDRAWASIH, RT. 007, RW. 001, KEL. PERAWANG BARAT, KEC. TUALANG, KAB. SIAK, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:18','2024-04-23 17:11:18');
INSERT INTO employees VALUES('3116','TARMUZI','','AE07097','','1408040610870006','69.852.989.8-222.000','','1987-10-06','MALE','2','2','43','330','','2','1','','','0','0','0','2022-09-30','','married','','K/2','JL. AR HAKIM GG. SEJAHTERA, RT. 010, RW. 005, KEL. PERAWANG, KEC. TUALANG, KAB. SIAK, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3117','ANDRE','MAYORA','AE03025','','1471073012910021','','081332433487/ 0','1991-12-30','MALE','2','2','42','308','','2','1','','','0','0','0','2022-02-07','','single','','TK/0','JL. PROVINSI PERUM NEGERI BERTUAH NO.38A, RT/RW 006/001, KEL.PERHENTIAN MARPOYAN, KEC.MARPOYAN DAMAI','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3118','ISWANDI','','AE03026','','3174023112790013','','081379768081','1979-12-31','MALE','2','2','42','308','','2','1','','','0','0','0','2022-02-07','','married','','K/1','JL.MENTENG ATAS GG.II NO.20, RT/RW 002/012, KEL.MENTENG ATAS, KEC.SETIA BUDI','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3119','NGAMANKEN','TARIGAN','AE00766','','1207092206920001','94.104.275.6-222.000','0','1992-06-22','MALE','2','2','43','330','','2','1','','','0','0','0','2021-10-22','','married','','K/1','Jl. Ambisi Rt.002 Rw.004 Kel. Pangkalan Kerinci Timur Kec. Pangkalan Kerinci Kab. Pelalawan','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3120','SANTO','PATERSON','AE02784','','1403091302970006','','082283056900','1997-02-13','MALE','2','2','43','','','2','1','','','0','0','0','2021-11-11','','single','','TK/0','JL. KARYA BAKTI, RT. 003, RW. 010, KEL. AIR JAMBAN, KEC. MANDAU, KAB. BENGKALIS, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3121','ACE','','AE03040','','3216200911780003','47.500.075.8-414.000','081276151501','1978-11-09','MALE','2','2','43','326','','2','1','','','0','0','0','2022-02-07','','married','','K/2','JL.ANOA V/G-2/81 CIKARANG BARU RT/RW 002/008 DESA JAYAMUKTI-CIKARANG PUSAT-BEKASI','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3122','BENNY','S TARIGAN','AE00148','','1271072304000001','93.811.451.9-121.000','082368864006','2000-04-23','MALE','2','2','43','326','','2','1','','','0','0','0','2021-10-22','','single','','TK/0','JL. LETJEN JAMIN GINTING LK1 NO. 26 MEDAN, RT. 000, RW. 000, KEL. LAU CIH, KEC. MEDAN TUNTUNGAN, KOTA MEDAN, PROV. SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3123','JAMILASI','KABAN','AE03709','','2171070801789002','65.322.257.0-121.000','081372109700','1978-01-08','MALE','2','2','43','326','','2','1','','','0','0','0','2022-05-23','','married','','K/2','JL. BUNGA RAYA LK VI, KEL. ASAM KUMBANG, KEC. MEDAN SELAYANG, KOTA MEDAN, PROV. SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3124','EDI','SUSANTO','AE00100','','1271072009720001','14.634.434.6-222.000','','1972-09-20','MALE','2','2','43','','','2','1','','','0','0','0','2021-10-11','','married','','K/3','JLN. LETJEN JAMIN GINTING LK I NO. 26, RT. 000, RW. 000, KEL. LAU CIH, KEC. MEDAN TUNTUNGAN, KOTA MEDAN, PROV. SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3125','TAUFIK','AKBAR','AE07145','','1405021607750010','','081365792275','1975-07-16','MALE','2','2','50','374','','2','1','','','0','0','0','2022-10-18','','married','','K/2','JL. PEMDA, RT/003 RW/008, KEL. PANGKALAN KERINCI KOTA, KEC. PANGKALAN KERINCI, KAB. PELALAWAN, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3126','GILANG','RAMADHAN','AE07208','','1471100712990001','','085954763104','1999-12-17','MALE','2','2','42','310','','2','1','','','0','0','0','2022-10-27','','single','','TK/0','JL. BAMBU KUNING GG. AUR NO. 6 E, RT. 004, RW. 010, KEL. BAMBUKUNING, KEC. TENAYAN RAYA, KOTA PEKANBARU, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3127','NAEMAN','NABABAN','AE07245','','1209200302980002','','081319710687','1998-05-25','MALE','2','2','43','327','','2','1','','','0','0','0','2022-11-10','','single','','TK/0','JL. BELIBIS LESTARI, RT. 000, RW. 000, KEL. LESTARI, KEC. KOTA KISARAN TIMUR, KAB. ASAHAN, PROV. SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3128','SUPARNO','HUTAPEA','AE07247','','1271060302920005','50.369.625.4-222.000','081364362319','1992-02-03','MALE','2','2','43','327','','2','1','','','0','0','0','2022-11-10','','single','','TK/0','JL. PENDIDIKAN KOMP BTN GAJAH TUNGGAL PERMAI BLOK A, RT. 006, RW. 007, KEL. TUALANG, KEC. TUALANG, KAB. SIAK, PROV. RIAU','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:19','2024-04-23 17:11:19');
INSERT INTO employees VALUES('3129','NOVER','RANTO PURBA','AE07616','','1209201711900001','','082288284733','1990-11-11','MALE','2','2','43','327','','2','1','','','0','0','0','2023-06-13','','single','','TK/0','AFD I PERKEBUNAN AJAMU,000/000,PANAI HULU,LABUHAN BATU,SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3130','GERI','SINAGA','AE07306','','1207092210010002','','0895324812778/ ','2001-08-22','MALE','2','2','43','327','','2','1','','','0','0','0','2022-11-24','','single','','TK/0','DUSUN VII DAGANG BULUH, RT. 000, RW. 000, KEL. MABAR, KEC. BANGUN PURBA, KAB. DELI SERDANG, PROV. SUMATERA UTARA','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3131','Rezki','Saputra Noflin','AE02774','rezki.saputra@timas.com','1403133007970230','41.594.506.2-219.000','081368094492','1997-07-30','Male','2','2','25','262','','2','1','','','0','0','0','2021-11-07','','single','','TK/0','Jl.Garuda RT/RW:002/003 Kel.Titian Antui kec.Pinggir,Bengkalis-Riau','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3132','JONA','SITOHANG','AE03789','','1222032105960009','65.283.009.2-222.000','','1995-05-21','MALE','2','2','56','414','','2','1','','','0','0','0','2022-05-17','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3133','Febriyadi','','AE02681','','1205141202870004','86.485.433.6-222.000','','1987-02-12','MALE','2','2','56','415','','2','1','','','0','0','0','2021-10-05','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3134','RENDI','LOPA','AE04673','','1221013006010001','91.514.212.9-118.000','','2001-06-30','MALE','2','2','56','416','','2','1','','','0','0','0','2022-08-16','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3135','HELMIZA','','AE07344','','1407035312910001','','','1991-12-13','MALE','2','2','83','364','','2','1','','','0','0','0','2022-12-12','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3136','INDRA','FEBRIANTO','AE04972','','1405021205790007','','','1979-09-15','MALE','2','2','43','326','','2','1','','','0','0','0','2022-09-23','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3137','RIO','MANGASI TUA LUMBAN GAOL','AE03071','','1216020202000001','50.339.142.7-127.000','','2000-02-02','MALE','2','2','40','286','','2','1','','','0','0','0','2022-02-24','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3138','EKO','RIZKY VALIAN AKBAR','AE07364','','1405021804980002','96.769.544.6-222.000','','1998-04-18','MALE','2','2','45','338','','2','1','','','0','0','0','2022-12-28','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3139','FAZRIN','RAHMADHAN','AE07378','','1203022010040007','','','2004-10-20','MALE','2','2','45','339','','2','1','','','0','0','0','2023-01-05','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3140','Roni','Pranata','AE01336','','1405021003820008','16.665.699.1-222.000','','1982-03-10','Male','2','2','56','417','','2','1','','','0','0','0','2021-09-04','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:20','2024-04-23 17:11:20');
INSERT INTO employees VALUES('3141','YUDI','DARMADI','AE03060','','1405022202840002','63.100.032.0-222.000','','1984-02-22','MALE','2','2','56','414','','2','1','','','0','0','0','2022-02-03','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3142','MARLON','SIHOMBING','AE03172','','1210080102800001','','','1980-02-01','MALE','2','2','56','416','','2','1','','','0','0','0','2022-03-14','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3143','CANDRA','PURBA','AE07130','','1211071710910002','','','1991-10-17','MALE','2','2','56','','','2','1','','','0','0','0','2022-10-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3144','M.','DANI ERIZON','AE04421','','1307130612030001','50.295.307.8-204.000','','2003-12-06','MALE','2','2','43','328','','2','1','','','0','0','0','2022-07-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3145','SATYA','PRATAMA','AE02907','','1373011502020001','43.405.741.0-203.000','','2002-03-15','MALE','2','2','43','329','','2','1','','','0','0','0','2022-01-17','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3146','SUTARSO','','AE04745','','1406132805930002','84.088.572.7-221.000','','1993-05-28','MALE','2','2','45','340','','2','1','','','0','0','0','2022-08-29','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3147','LELY','SUHERY DAULAY','AE04752','','1405031507770003','14.231.459.0-216.000','','1977-07-15','MALE','2','2','45','340','','2','1','','','0','0','0','2022-08-31','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3148','FAJRI','RISALDI','AE02617','','1409011006960001','','','1996-07-10','MALE','2','2','17','277','','2','1','','','0','0','0','2021-09-15','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3149','MANGIHUT','GULTOM','AE03007','','1208212104830008','42.189.309.0-222.000','','1983-04-21','Male','2','2','17','268','','2','1','','','0','0','0','2022-02-08','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3150','SANDI','','AE05464','','1209191506030004','','','2003-06-15','MALE','2','2','45','339','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3151','ABDI','SIMANUNGKALIT','AE05524','','1571072812820121','94.288.473.5-331.000','','1982-12-28','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3152','FIRMANSYAH','','AE04117','','1403091805970002','40.327.669.4-222.000','','1997-05-18','MALE','2','2','17','268','','2','1','','','0','0','0','2022-06-30','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3153','IRMAN','SILABAN','AE00980','','1201101607880001','84.171.211.0-222.000','','1988-07-10','MALE','2','2','45','340','','2','1','','','0','0','0','2022-05-25','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:21','2024-04-23 17:11:21');
INSERT INTO employees VALUES('3154','AHMAD','SAI','AE03661','','1205141008700006','','','1970-08-10','MALE','2','2','45','340','','2','1','','','0','0','0','2022-05-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3155','OTNIEL','PANDIANGAN','AE03843','','1506061406840002','','','1984-06-14','MALE','2','2','45','341','','2','1','','','0','0','0','2022-05-27','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3156','IKBAL','ARNIANSYAH','AE03969','','3212310509820001','85.333.060.3-437.000','','1982-09-05','MALE','2','2','45','337','','2','1','','','0','0','0','2022-06-13','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3157','PAHMI','RAMBE','AE04797','','1405050301920004','39.788.445.3-222.000','','1992-01-03','MALE','2','2','40','284','','2','1','','','0','0','0','2022-09-09','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3158','Susanto','','AE00888','','1209152903910002','95.653.717.9.222.000','','1991-03-29','Male','2','2','40','285','','2','1','','','0','0','0','2022-01-12','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3159','MUHAMMAD','RIZKI','AE04968','','1405030202020011','','','2002-02-02','MALE','2','2','45','339','','2','1','','','0','0','0','2022-09-23','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3160','IWANTO','','AE06556','','1405021111760004','57.368.827.2-222.000','','1976-11-11','MALE','2','2','45','342','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3161','KHOLIDAN','','AE06557','','1405020401870002','94.011.772.4-222.000','','1987-01-04','MALE','2','2','45','342','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3162','Muslim','','AE00255','','1408040505660002','47.007.618.3-222.000','','1966-05-05','Male','2','2','43','327','','2','1','','','0','0','0','2020-01-15','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3163','YELDI','MARDIANTO','AE03816','','1409010904030001','','','2003-04-09','MALE','2','2','43','328','','2','1','','','0','0','0','2023-01-16','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3164','Noel','Nicolas Holysandi Pasaribu','AE02720','noel.pasaribu@timas.com','1405020908980004','84.698.613.1-222.000','','1998-08-09','Male','2','2','83','362','','2','1','','','0','0','0','2021-10-25','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3165','SUSENO','HERLAMBANG','AE03518','','1307051804940001','93.190.505.3-204.000','','1994-04-18','MALE','2','2','40','285','','2','1','','','0','0','0','2022-05-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3166','TONI','FIRDAUS','AE00169','toni.firdaus@timas.com','1408041001750001','','','1975-01-10','MALE','2','2','55','410','','2','1','','','0','0','0','2020-01-10','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:22','2024-04-23 17:11:22');
INSERT INTO employees VALUES('3167','Kriswandi','','AE00045','kriswandi@timas.com','1405022512650004','66.885.340.1-222.000','','1965-12-25','Male','2','2','83','361','','2','1','','','0','0','0','2019-12-01','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3168','RONI','ASIH AMPU PARULIAN MANIK','AE07689','','1408041901000005','','','2000-01-19','MALE','2','2','43','327','','2','1','','','0','0','0','2023-06-27','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3169','Ismael','','AE02886','','1405020404740009','43.029.639.2-211.000','','1974-04-04','Male','2','2','96','316','','2','1','','','0','0','0','2022-01-12','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3170','EKO','MULYONO','AE00173','','1301020705770001','74.521.726.5-222.000','','1977-05-07','Male','2','2','38','256','','2','1','','','0','0','0','2021-07-16','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3171','SUDIELI','ZAGOTO','AE07467','','1214100111860002','94.215.612.6-126.000','','1986-11-01','MALE','2','2','42','','','2','1','','','0','0','0','2023-01-25','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3172','FAUZAN','ARIEF','AE03492','','1373041102930002','','','1993-02-11','MALE','2','2','45','343','','2','1','','','0','0','0','2022-05-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3173','HOTMANAFER','SIMATUPANG','AE03811','','2171091111880006','42.783.796.8-222.000','','1988-11-11','MALE','2','2','45','340','','2','1','','','0','0','0','2022-06-04','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3174','SUBKHAN','WICAKSONO','AE03416','subhkan.wicaksono@timas.com','3305052004980002','65.082.993.0-523.000','','1998-04-20','MALE','2','2','25','','','2','1','','','0','0','0','2022-04-26','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3175','BOBY','DESRIYANTO','AE07122','','1471120112970022','96.699.486.5-211.000','','1997-12-01','MALE','2','2','25','','','2','1','','','0','0','0','2022-10-06','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3176','ANDRIAN','SAPUTRA','AE03987','','1304131805020002','','','2002-05-18','MALE','2','2','43','328','','2','1','','','0','0','0','2022-06-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3177','HARUN','AL RASYID','AE02928','','1405020804960003','84.225.206.6-222.000','','1996-04-08','MALE','2','2','43','328','','2','1','','','0','0','0','2022-01-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3178','KIKI','FRI NANDA','AE03553','','1405061311960002','84.079.163.6-222.000','','1996-11-13','MALE','2','2','45','339','','2','1','','','0','0','0','2022-05-18','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:23','2024-04-23 17:11:23');
INSERT INTO employees VALUES('3179','Jhoni','As\'ari','AE01193','','1405020109970004','82.583.515.0-222.000','','1997-09-01','Male','2','2','45','340','','2','1','','','0','0','0','2021-12-02','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3180','Maragonti','Harahap','AE00060','','1405021209850012','83.947.592.8-222.000','','1985-09-12','Male','2','2','50','376','','2','1','','','0','0','0','2019-12-02','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3181','YOKI','GUSRIANTO','AE07510','','1409012108010001','50.308.239.8-213.000','','2001-08-21','MALE','2','2','43','328','','2','1','','','0','0','0','2023-02-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3182','FAJAR','NUGRAHA','AE05356','','1471091709000002','50.295.782.2-216.000','','2000-09-17','MALE','2','2','45','343','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3183','Robert','Manurung','AE02716','robert.manurung@timas.com','1405022305820007','84.152.920.9-222.000','','1982-05-23','Male','2','2','40','287','','2','1','','','0','0','0','2021-10-23','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3184','JINBEN','BINARA PARHUSIP','AE07538','','1217051512030001','','','2003-12-15','MALE','2','2','45','344','','2','1','','','0','0','0','2023-02-15','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3185','Bagus','Haryono','AE02879','','1205152702920002','84.076.351.0-119.000','','1992-02-27','Male','2','2','42','309','','2','1','','','0','0','0','2022-01-02','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3186','Abdul','Rasyid Sidik','AE02910','','1405022406970004','50.211.272.5-222.000','','1997-06-24','Male','2','2','42','309','','2','1','','','0','0','0','2022-01-18','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3187','Lailatul','Rahmah','AE02864','lailatul.rahmah@timas.com','1471064212000041','93.086.242.0-211.000','','2000-12-02','Female','2','2','42','312','','2','1','','','0','0','0','2021-12-28','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3188','DENI','KURNIAWAN','AE06743','','1606052002910002','62.953.796.0-216.000','','1991-02-20','MALE','2','2','45','342','','2','1','','','0','0','0','2023-12-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3189','Thomas','Marhasil Tampubolon','AE02781','thomas.tampubolon@timas.com','1271022909900002','53.080.441.8-124.000','','1990-09-29','Male','2','2','25','260','','2','1','','','0','0','0','2021-10-29','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3190','Eko','Putra Mardiansyah','AE02821','eko.putra@timas.com','1205140507960002','53.411.106.7-119.000','','1996-07-05','Male','2','2','25','','','2','1','','','0','0','0','2021-11-29','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3191','TSANDI','MUKHLASIN','AE04496','','3516033010960001','60.231.414.8-602.000','','1996-10-30','MALE','2','2','83','363','','2','1','','','0','0','0','2022-07-23','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:24','2024-04-23 17:11:24');
INSERT INTO employees VALUES('3192','Jimmi','Natal Situmorang','AE05097','','1405021912850002','','','1985-12-19','Male','2','2','45','345','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3193','ABID','SANGKARA','AE06886','','1607051905030006','','','2003-05-19','MALE','2','2','45','339','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3194','DAVID','CHANNIAGO','AE07905','','1471060608910001','','','1991-08-06','MALE','2','2','43','333','','2','1','','','0','0','0','2022-09-30','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3195','DENO','SAFRIZAL','AE07904','','1205010412840010','86.892.274.1-119.000','','1984-12-04','MALE','2','2','43','334','','2','1','','','0','0','0','2022-10-02','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3196','IRVAN','','AE07573','','1507071010010004','62.885.639.5-334.000','','2001-10-10','MALE','2','2','44','','','2','1','','','0','0','0','2023-03-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3197','RANDI','IQBAL','AE04686','','1471071601940001','80.665.357.3-216.000','','1994-01-16','MALE','2','2','98','295','','2','1','','','0','0','0','2022-08-12','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3198','Andri','Ahmad Yani','AE00067','andri.yani@timas.com','1209151105880007','74.994.872.5-115.000','','1988-05-11','Male','2','2','55','411','','2','1','','','0','0','0','2019-12-19','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3199','Julfri','Adis','AE00526','','1403130506902701','73.466.288.5-219.000','','1990-06-05','Male','2','2','51','382','','2','1','','','0','0','0','2020-02-07','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3200','Yudi','Lupik','AE02637','','1408040303770004','58.436.292.5-312.000','','1977-03-03','Male','2','2','51','383','','2','1','','','0','0','0','2021-09-17','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3201','Haryadi','Saputra','AE02688','','1671010204890004','71.635.961.7-307.000','','1989-04-02','Male','2','2','51','384','','2','1','','','0','0','0','2021-10-01','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3202','INDRI','THAHARAH','AE02996','indri.thararah@timas.com','1405025103960001','90.609.396.8-222.000','','1996-03-11','Female','2','2','40','285','','2','1','','','0','0','0','2022-02-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3203','Aldo','Novrizal','AE02655','','1803020911910009','84.661.774.4-326.000','','1991-11-09','Male','2','2','83','362','','2','1','','','0','0','0','2021-09-24','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:25','2024-04-23 17:11:25');
INSERT INTO employees VALUES('3204','DAFID','EDGAR SAUQI','AE03777','','1304012611880003','13.266.828.6-204.000','','1988-11-26','MALE','2','2','45','337','','2','1','','','0','0','0','2022-05-27','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3205','JULIANDA','LUBENSYAMER','AE07151','','1605011507980001','65.480.014.3-303.000','','1998-07-15','MALE','2','2','83','362','','2','1','','','0','0','0','2022-10-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3206','Muhazzir','','AE00994','','1173021105830003','84.135.664.5-222.000','','1983-05-11','Male','2','2','43','327','','2','1','','','0','0','0','2021-08-13','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3207','Selamet','Riyadi','AE02691','','1602082607730001','00.000.000.0-000.000','','1973-07-26','Male','2','2','51','386','','2','1','','','0','0','0','2021-10-01','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3208','Rudianto','','AE02842','','1408071409940001','00.000.000.0-000.000','','1994-09-14','Male','2','2','44','','','2','1','','','0','0','0','2021-12-11','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3209','Amir','Hamzah','AE02850','','1808101403000004','43.250.671.5-326.000','','2000-03-14','Male','2','2','44','','','2','1','','','0','0','0','2021-12-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3210','DEFRIANTO','','AE04297','','1471010212870021','','','1987-12-02','MALE','2','2','44','','','2','1','','','0','0','0','2022-07-08','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3211','Anton','Sudomo','AE02690','','1602232110871001','00.000.000.0-000.000','','1987-10-21','Male','2','2','51','385','','2','1','','','0','0','0','2021-10-01','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3212','A.','Maulana','AE02689','','1671012608940001','00.000.000.0-000.000','','1994-08-26','Male','2','2','51','386','','2','1','','','0','0','0','2021-10-01','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3213','MUHAMMAD','ANUGRAH GULTOM','AE06421','','1208181306040001','','','2004-06-13','MALE','2','2','98','296','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3214','ASEP','BARON','AE09123','','3206370510790001','','','1979-10-05','MALE','2','2','98','297','','2','1','','','0','0','0','2023-05-08','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3215','HOLIL','WAHYUDIN','AE00246','','3206390405920002','62.383.810.9-425.000','','1992-07-05','MALE','2','2','98','298','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3216','Dirja','Gunawan','AE02723','','1602080804950002','00.000.000.0-000.000','','1995-04-08','Male','2','2','51','387','','2','1','','','0','0','0','2021-10-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:26','2024-04-23 17:11:26');
INSERT INTO employees VALUES('3217','PERI','SUMANTRI','AE07598','','1275050807830001','','','1983-07-08','MALE','2','2','43','327','','2','1','','','0','0','0','2023-06-08','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3218','HARIANDI','JOHANSYAH SITORUS','AE07610','','1102020502000001','','','2000-02-03','MALE','2','2','43','327','','2','1','','','0','0','0','2023-06-14','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3219','ALBET','ARIF IRAWAN','AE03169','','1602080809950006','','','1995-09-08','MALE','2','2','51','385','','2','1','','','0','0','0','2022-03-04','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3220','RUSDI','','AE04385','','1602082210950001','','','1995-10-22','MALE','2','2','51','386','','2','1','','','0','0','0','2022-07-19','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3221','MIKAEL','SIMANJUNTAK','AE03867','','1202091805010001','','','2001-05-18','MALE','2','2','51','386','','2','1','','','0','0','0','2022-05-28','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3222','AGUS','TIYAN','AE04063','','1602082308000002','','','2000-08-23','MALE','2','2','51','386','','2','1','','','0','0','0','2022-06-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3223','YEFRIZAL','','AE02947','','1304130110940001','50.281.552.5-204.000','','1994-10-01','MALE','2','2','43','329','','2','1','','','0','0','0','2022-01-25','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3224','DIAN','SUKMA PRAYOGA','AE05085','','1201102010020001','','','2002-10-16','MALE','2','2','43','329','','2','1','','','0','0','0','2022-05-25','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3225','M.','YUSUF','AE05724','','1671071705750006','79.425.608.1-307.000','','1975-05-15','MALE','2','2','98','299','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3226','RISKI','GUNAWAN SINAGA','AE07673','','1207270102020002','','','2002-02-01','MALE','2','2','45','340','','2','1','','','0','0','0','2023-06-23','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3227','ZUKRIAL','','AE00790','','1304031005730003','14.160.811.7-216.000','','1973-05-15','MALE','2','2','43','335','','2','1','','','0','0','0','2022-01-02','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3228','HARKANI','','AE03165','','1674020410870002','36.613.314.8-313.000','','1987-10-04','MALE','2','2','55','412','','2','1','','','0','0','0','2022-03-04','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:27','2024-04-23 17:11:27');
INSERT INTO employees VALUES('3229','RAHMAN','WAHYU RAMADHAN','AE07108','rahman.ramadhan@timas.com','1674062101980001','','','1998-01-21','MALE','2','2','55','407','','2','1','','','0','0','0','2022-10-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3230','INDRA','SUMANTRI','AE03922','indra.sumantri@timas.com','1207221110800004','92.727.844.0-222.000','','1984-10-11','MALE','2','2','25','','','2','1','','','0','0','0','2022-06-08','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3231','Zakiah','Gustiani','AE00313','zakiah.gustiani@timas.com','1671145808930005','83.927.870.2-306.000','','1993-08-18','Female','2','2','47','354','','2','1','','','0','0','0','2020-01-15','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3232','DITA','NATALIA DAVRIN SITOMPUL','AE07712','','1207234603990002','53.779.356.4-124.000','','1999-12-22','FEMALE','2','2','47','355','','2','1','','','0','0','0','2023-07-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3233','Dedi','Miswar','AE01123','','1405022505900004','95.792.344.4-222.000','','1990-05-25','Male','2','2','83','362','','2','1','','','0','0','0','2021-08-24','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3234','Sikta','Joko Priyanto','AE00083','','1601291202790002','57.229.870.1-402.000','','1979-02-12','Male','2','2','25','264','','2','1','','','0','0','0','2019-12-11','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3235','LAMBAS','SINAGA','AE07729','','1403131401900001','','','1990-01-14','MALE','2','2','45','337','','2','1','','','0','0','0','2023-07-05','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3236','PUTU','SUDIANTARA','AE07730','','1806171106050001','','','2005-06-11','MALE','2','2','45','340','','2','1','','','0','0','0','2023-07-05','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3237','OBER','SAMOSIR','AE07732','','1271042106930006','','','1993-06-21','MALE','2','2','45','340','','2','1','','','0','0','0','2023-07-11','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3238','RENO','ROMANSYA','AE07740','','1702072011980002','','','1998-11-20','MALE','2','2','45','340','','2','1','','','0','0','0','2023-07-12','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3239','NADILA','AULIA','AE07758','','1471084510980002','40.162.007.5-216.000','','1998-10-05','MALE','2','2','83','362','','2','1','','','0','0','0','2023-07-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3240','PANDI','PADANG','AE07770','','1211031310990001','','','1999-10-15','MALE','2','2','45','337','','2','1','','','0','0','0','2023-07-17','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:28','2024-04-23 17:11:28');
INSERT INTO employees VALUES('3241','HIDAYAH','RAMADHAN YUSUF','AE07193','','3578202005860001','81.495.117.4-618.000','','1986-05-20','MALE','2','2','56','416','','2','1','','','0','0','0','2022-10-31','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3242','TEGOR','RAHMAN SAPUTRA','AE03205','','1603151303010003','','','2001-03-12','MALE','2','2','56','418','','2','1','','','0','0','0','2022-03-18','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3243','ABIB','PRASTIKO','AE03215','','3312162112010001','','','2001-12-21','MALE','2','2','56','418','','2','1','','','0','0','0','2022-03-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3244','KINDY','AKHMAD TITO','AE03393','kindy.akhmad@timas.com','3320080202930002','86.502.232.1-516.000','','1993-02-02','MALE','2','2','50','','','2','1','','','0','0','0','2022-04-19','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3245','TAUFIQURRAHMAN','','AE04034','taufiq.ananta@timas.com','1206062801010001','65.859.150.8-221.000','','2001-01-28','MALE','2','2','25','','','2','1','','','0','0','0','2022-06-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3246','JUBAIR','AL KUDRI','AE07159','','1471061207960002','','','1996-07-12','MALE','2','2','25','260','','2','1','','','0','0','0','2022-10-17','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3247','Agielfitriadi','','AE02837','','1408042202960004','00.000.000.0-000.000','','1996-02-22','Male','2','2','44','','','2','1','','','0','0','0','2021-12-04','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3248','Rici','Sumanta','AE02852','','1305082303830001','00.000.000.0-000.000','','1983-03-23','Male','2','2','44','','','2','1','','','0','0','0','2021-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3249','RAHMAT','WAL HIDAYAH','AE03483','','1405020609030004','65.490.979.5-222.000','','2003-09-06','MALE','2','2','44','','','2','1','','','0','0','0','2022-05-14','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3250','Adi','Sulistio','AE05028','','1403052405930001','','','1993-05-24','Male','2','2','44','','','2','1','','','0','0','0','2022-05-24','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3251','SAIRUDIN','','AE03780','','1405100306920002','84.041.069.0-222.000','','1992-06-03','MALE','2','2','44','','','2','1','','','0','0','0','2022-05-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3252','EDO','PRAYOGI','AE04768','','1209320611990001','65.423.517.5-117.000','','1999-11-06','MALE','2','2','44','','','2','1','','','0','0','0','2022-09-06','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3253','ARIO','M FATHONAH','AE05843','','1373022302010003','50.368.691.7-222.000','','2001-02-23','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:29','2024-04-23 17:11:29');
INSERT INTO employees VALUES('3254','Pandu','Wijaya Pratama','AE02931','','1405020312940003','83.027.391.8-222.000','','1994-12-03','Male','2','2','40','283','','2','1','','','0','0','0','2022-01-22','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3255','Nofi','Maryo Handa','AE00190','','1472011303880062','70.611.528.4-212.000','','1988-03-13','Male','2','2','83','365','','2','1','','','0','0','0','2021-08-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3256','ALANDINO','SUANDI','AE04342','','1307062705990001','','','1999-05-27','MALE','2','2','40','283','','2','1','','','0','0','0','2022-07-19','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3257','HERMANTONI','','AE07212','','1501171006880004','','','1988-06-10','MALE','2','2','40','283','','2','1','','','0','0','0','2022-11-07','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3258','CINDY','FAUZIAH','AE03218','','1403096408990004','50.317.340.3-219.000','','1999-08-24','FEMALE','2','2','83','366','','2','1','','','0','0','0','2022-03-18','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3259','AA','SUGANDA','AE02397','','3206390401730001','','','1973-08-28','MALE','2','2','98','300','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3260','MAMAN','ROSANA','AE02505','','3206391510770002','','','1977-07-10','MALE','2','2','98','300','','2','1','','','0','0','0','2023-12-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3261','Engkus','Kusnadi','AE02396','','3206361209790003','','','1979-09-12','Male','2','2','98','300','','2','1','','','0','0','0','2023-12-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3262','Dayat','','AE02650','','3206390808770001','','','1977-08-08','Male','2','2','98','300','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3263','Sartono','','AE02403','','1405022806930008','','','1993-06-28','Male','2','2','98','301','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3264','KAMALUDIN','','AE02497','','3206391112660002','62.450.707.5-425.000','','1966-12-11','MALE','2','2','98','301','','2','1','','','0','0','0','2023-12-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3265','MUHAMMAD','RIDO','AE05733','','1205111409940002','','','1994-09-14','MALE','2','2','98','302','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:30','2024-04-23 17:11:30');
INSERT INTO employees VALUES('3266','DIKRY','FIRMAN MAULANA','AE09055','','3211211010020011','','','2002-10-10','MALE','2','2','98','296','','2','1','','','0','0','0','2022-11-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3267','DADI','','AE09033','','3206361009000001','','','2000-09-10','MALE','2','2','98','302','','2','1','','','0','0','0','2022-10-03','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3268','MUHAMMAD','ADE SYAPUTRA','AE06446','','1674010106000002','','','2000-06-01','MALE','2','2','98','296','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3269','HERMAN','','AE04488','','1405021811820005','86.879.230.0-222.000','','1982-11-18','MALE','2','2','43','330','','2','1','','','0','0','0','2023-08-24','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3270','UCUP','MUNANDAR','AE09421','','3209052205840005','','','1984-05-22','MALE','2','2','98','297','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3271','SUNARYO','','AE05864','','3604300909850003','','','1985-09-09','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3272','RIQKY','ANDIKA','AE09113','','1271162906980002','','','1998-06-29','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3273','Enur','Nurdin','AE00390','','1505050102720001','','','1972-02-01','Male','2','2','98','','','2','1','','','0','0','0','2023-12-21','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3274','AEP','SAEPUDIN','AE09034','','3206350101680014','','','1968-01-01','MALE','2','2','98','302','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3275','EPUL','','AE09120','','3206372508790001','','','1979-08-25','MALE','2','2','98','297','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3276','TEDY','FIRMANSYAH','AE09125','','3214012306040004','40.686.858.8-409.000','','2004-06-23','MALE','2','2','98','296','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3277','SANDI','ARDIANSAH','AE09127','','3206362507000001','','','2000-07-25','MALE','2','2','98','296','','2','1','','','0','0','0','2023-05-08','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3278','SUNARYA','','AE09128','','3206360710940003','','','1994-10-07','MALE','2','2','98','296','','2','1','','','0','0','0','2023-05-08','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:31','2024-04-23 17:11:31');
INSERT INTO employees VALUES('3279','ASEP','RAHMAT','AE09131','','3206361704830003','','','1983-04-17','MALE','2','2','98','296','','2','1','','','0','0','0','2023-05-08','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3280','AHMAD','FAHRUROZI','AE05902','','3604300510830001','','','1983-10-05','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3281','Zikra','','AE00069','','1103100102900001','83.860.529.3-105.000','','1990-02-01','Male','2','2','38','257','','2','1','','','0','0','0','2019-12-06','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3282','Deni','Warman','AE02841','','1408041508750012','92.628.337.5-222.000','','1975-08-15','Male','2','2','44','','','2','1','','','0','0','0','2021-12-04','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3283','EBY','ARDO HUTASOIT','AE03266','','1202012504000001','50.346.963.7-127.000','','2000-04-25','MALE','2','2','45','346','','2','1','','','0','0','0','2022-03-31','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3284','BOY','SANDY','AE04380','','1602122512951001','','','1995-12-25','MALE','2','2','51','385','','2','1','','','0','0','0','2023-09-29','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3285','HENDRI','MULYANTO','AE07814','','1602080206950003','','','1995-06-02','MALE','2','2','51','386','','2','1','','','0','0','0','2023-09-29','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3286','M.','ARIEL AGUSTIAN','AE07815','','1671011008050002','','','2005-08-10','MALE','2','2','51','386','','2','1','','','0','0','0','2023-09-29','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3287','MULYADI','','AE07816','','1602120707840002','','','1984-07-07','MALE','2','2','51','386','','2','1','','','0','0','0','2023-09-29','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3288','WAHYU','LAKSANA','AE07817','','1602081411030001','','','2003-11-14','MALE','2','2','51','386','','2','1','','','0','0','0','2023-09-29','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3289','IRVAN','','AE07818','','1602182711030001','60.091.091.3-321.000','','2000-11-27','MALE','2','2','51','386','','2','1','','','0','0','0','2023-09-29','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3290','YUDO','YENSI','AE07819','','1602112807960001','','','1996-07-28','MALE','2','2','51','386','','2','1','','','0','0','0','2023-09-29','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:32','2024-04-23 17:11:32');
INSERT INTO employees VALUES('3291','ROPI','NIKO','AE07823','','1602120505860001','','','1986-05-05','MALE','2','2','51','386','','2','1','','','0','0','0','2023-10-05','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3292','RAMA','','AE07824','','1602122903990001','','','1999-03-29','MALE','2','2','51','386','','2','1','','','0','0','0','2023-10-05','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3293','SUKARI','','AE09151','','3604240101860011','','','1986-01-01','MALE','2','2','98','296','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3294','DEPIS','ARDIANSYAH','AE09114','','1602083006870001','','','1987-06-30','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3295','RIDWAN','','AE05847','','1471111302010021','','','2001-02-13','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3296','NOPRIADI','','AE07846','','1602121111010001','','','2001-11-11','MALE','2','2','96','317','','2','1','','','0','0','0','2023-12-18','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3297','Suparta','Simanjuntak','AE00520','','1272032303860002','84.212.740.9-117.000','','1986-03-23','Male','2','2','42','308','','2','1','','','0','0','0','2021-10-07','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3298','MECHAEL','YACOB SARAGIH','AE03325','mechael.saragih@timas.com','1402020605900002','93.049.926.4-213.000','','1990-05-06','MALE','2','2','42','309','','2','1','','','0','0','0','2022-04-07','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3299','Eduard','Tamba','AE05103','','1217061101950001','62.421.940.8-127.000','','1995-01-11','Male','2','2','','','','2','1','','','0','0','0','2023-08-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3300','Poltak','Halomoan Situmorang','AE05136','','1223010411800003','62.435.415.5-222.000','','1980-11-04','Male','2','2','','','','2','1','','','0','0','0','2023-08-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3301','Ismail','','AE02754','','1408040103740011','84.406.076.4-222.000','','1974-03-01','Male','2','2','50','373','','2','1','','','0','0','0','2021-11-02','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3302','Darwis','M','AE02933','','3172040507870022','','','1987-07-05','Male','2','2','50','375','','2','1','','','0','0','0','2022-01-24','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3303','HERDIANTO','','AE03302','','1602080107970037','63.781.965.7-312.000','','1996-06-06','MALE','2','2','50','374','','2','1','','','0','0','0','2022-03-31','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:33','2024-04-23 17:11:33');
INSERT INTO employees VALUES('3304','Dedek','Syaputra','AE00443','','1209191211950001','84.376.007.5-115.000','','1995-11-12','Male','2','2','99','','','2','1','','','0','0','0','2021-11-16','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3305','Ramadhan','','AE00550','','1213092211690002','84.283.808.8-118.000','','1969-11-22','Male','2','2','96','318','','2','1','','','0','0','0','2021-09-14','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3306','YURISMAN','','AE03178','','1471121506670022','53.326.490.9-211.000','','1967-06-15','MALE','2','2','96','','','2','1','','','0','0','0','2022-03-06','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3307','Rudi','Waluyo','AE00094','','1218080410890003','98.353.567.5-114.000','','1989-11-04','Male','2','2','50','374','','2','1','','','0','0','0','2021-09-17','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3308','Solihin','Nasution','AE00807','','1221022402930001','86.805.499.0-118.000','','1993-02-24','Male','2','2','50','374','','2','1','','','0','0','0','2021-09-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3309','Darman','Pardosi','AE00261','','1202140802850004','84.109.995.5-212.000','','1985-02-08','Male','2','2','50','374','','2','1','','','0','0','0','2020-01-15','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3310','HANAFI','ZUHRA','AE04359','','1405023001950001','65.270.119.4-222.000','','1995-01-30','MALE','2','2','50','378','','2','1','','','0','0','0','2022-07-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3311','DARLAN','SIANTURI','AE03311','','3209022708680002','','','1968-08-27','MALE','2','2','38','258','','2','1','','','0','0','0','2022-04-04','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3312','UNDANG','SOPYAN','AE05324','','3206371612960001','','','1996-12-16','MALE','2','2','98','300','','2','1','','','0','0','0','2023-08-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3313','Shintia','Raminda','AE02870','shintia.raminda@timas.com','1307026209990001','00.000.000.0-000.000','','1999-09-22','Female','2','2','83','362','','2','1','','','0','0','0','2021-12-29','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3314','RIGA','APRILA','AE02994','','1308056204010006','','','2001-04-22','Female','2','2','83','367','','2','1','','','0','0','0','2022-01-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3315','Indra','Huda','AE02805','indra.huda@timas.com','1607012712880002','15.828.704.5-215.000','','1988-12-27','Male','2','2','83','363','','2','1','','','0','0','0','2021-11-22','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:34','2024-04-23 17:11:34');
INSERT INTO employees VALUES('3316','Suyono','','AE02825','suyono@timas.com','1209150606750008','74.994.746.1-115.000','','1975-06-06','Male','2','2','25','265','','2','1','','','0','0','0','2021-12-02','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3317','JENTRISMEN','FRANSISKUS HASUGIAN','AE04462','','1209052805860005','94.298.333.9-216.000','','1986-05-28','MALE','2','2','43','327','','2','1','','','0','0','0','2022-07-25','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3318','MUHAMMAD','AGI SATRIA','AE03519','','1605071902970001','93.726.025.5-311.000','','1997-08-05','MALE','2','2','44','','','2','1','','','0','0','0','2022-05-12','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3319','Lasman','Simbolon','AE00563','','1405020709690006','87.953.108.5-222.000','','1969-09-07','Male','2','2','45','340','','2','1','','','0','0','0','2021-08-04','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3320','Aldi','Pratama','AE02806','','1405020105000005','00.000.000.0-000.000','','2000-05-01','Male','2','2','44','','','2','1','','','0','0','0','2021-11-27','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3321','ZULFIKRI','','AE03202','','1471100701990022','','','1999-01-07','MALE','2','2','51','','','2','1','','','0','0','0','2022-03-18','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3322','Selamat','Aritonang','AE00053','','1403091009824525','70.597.526.6-219.000','','1982-09-10','Male','2','2','17','268','','2','1','','','0','0','0','2019-11-28','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3323','SAMUEL','SITORUS','AE03589','','1208100311990002','','','1999-11-03','MALE','2','2','51','385','','2','1','','','0','0','0','2022-05-17','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3324','Iwan','Kaswari','AE02591','','1408041008820010','43.108.914.3-222.000','','1982-08-10','Male','2','2','99','402','','2','1','','','0','0','0','2021-08-18','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3325','Muhammad','Eka Azhari','AE02788','','1405021306020008','43.144.681.4-222.000','','2002-06-13','Male','2','2','99','403','','2','1','','','0','0','0','2021-11-18','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3326','GOSPEL','SIMANJUNTAK','AE04631','','1202121908030001','','','2003-08-19','MALE','2','2','51','','','2','1','','','0','0','0','2022-08-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3327','Wawan','Setiawan','AE00579','','1408032412910001','62.377.052.6-211.000','','1991-12-24','Male','2','2','45','344','','2','1','','','0','0','0','2021-08-09','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3328','Putri','Arta Manullang','AE02752','putri.arta@timas.com','1471104904990001','53.032.666.9-222.000','','1999-04-09','Male','2','2','47','356','','2','1','','','0','0','0','2021-11-06','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:35','2024-04-23 17:11:35');
INSERT INTO employees VALUES('3329','Saino','','AE02888','','1301031808700004','00.000.000.0-000.000','','1970-08-18','Male','2','2','17','278','','2','1','','','0','0','0','2022-01-07','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3330','Nurkhairani','Octavia','AE02957','nurkhairani.octavia@timas.com','1404106210020002','','','2002-10-28','Female','2','2','52','393','','2','1','','','0','0','0','2022-01-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3331','Johan','Dodi','AE02856','','1401062911890001','74.105.953.9-221.000','','1989-11-29','Male','2','2','40','285','','2','1','','','0','0','0','2021-12-22','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3332','Soala','Roha','AE02924','','2171092106880005','70.526.326.7-215.000','','1988-06-21','Male','2','2','40','288','','2','1','','','0','0','0','2022-01-20','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3333','Indra','Kurniawan','AE00630','','1405023007830002','72.907.013.6-222.000','','1983-07-30','Male','2','2','40','289','','2','1','','','0','0','0','2020-02-18','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3334','ELIAKIM','GULTOM','AE04340','','1219030706930003','60.145.402.8-115.000','','1993-06-07','MALE','2','2','40','286','','2','1','','','0','0','0','2022-07-13','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3335','Aten','Wawan Kusuma','AE02061','','3211210806550002','','','1955-06-08','Male','2','2','53','394','','2','1','','','0','0','0','2023-08-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3336','Didi','Prabowo','AE02571','','140801904010002 ','','','2001-04-19','Male','2','2','98','303','','2','1','','','0','0','0','2023-08-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3337','ASWIN','RIVADIANSYAH','AE04795','','1701110401840002','60.571.690.1-311.000','','1984-01-04','MALE','2','2','83','368','','2','1','','','0','0','0','2022-09-05','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3338','RICKO','HENDRI PARNINGOTAN MARPAUNG','AE07068','','1271073001990002','95.856.908.9-121.000','','1998-01-30','MALE','2','2','25','','','2','1','','','0','0','0','2022-09-28','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3339','TAUFIK','ANANTA S','AE07124','','1207212802720001','14.173.291.7-727.000','','1972-02-28','MALE','2','2','40','290','','2','1','','','0','0','0','2022-10-03','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3340','Budi','Sofyan Girsang','AE00010','budi.girsang@timas.com','1405020705730005','14.634.433.8-222.000','','1973-05-07','Male','2','2','96','','','2','1','','','0','0','0','2019-11-11','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:36','2024-04-23 17:11:36');
INSERT INTO employees VALUES('3341','REXY','GURUH SAPUTRA','AE04699','','1405072303980002','42.042.110.9-222.000','','1998-03-23','MALE','2','2','25','','','2','1','','','0','0','0','2022-08-19','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3342','Isra','Alfarizi','AE02566','','1276020812960002','85.480.834.2-114.000','','1996-12-08','Male','2','2','25','262','','2','1','','','0','0','0','2021-08-05','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3343','Nasirun','','AE02718','','1308070306860005','94.341.240.3-202.000','','1986-06-03','Male','2','2','40','284','','2','1','','','0','0','0','2021-10-23','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3344','Bizar','','AE02930','','1405091305880001','60.798.768.2-222.000','','1988-05-13','Male','2','2','40','283','','2','1','','','0','0','0','2022-01-22','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3345','Herry','Suryadi','AE02733','herry.suryadi@timas.com','1471112412820022','15.161.088.8-216.000','','1982-12-24','Male','2','2','47','357','','2','1','','','0','0','0','2021-10-29','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3346','Ariyanto','','AE02596','','1405021507860004','43.275.834.0-222.000','','1986-07-15','Male','2','2','40','283','','2','1','','','0','0','0','2021-08-26','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3347','Yusron','','AE02569','yusron.docon@timas.com','3271040810970006','43.150.778.9-222.000','','1997-10-08','Male','2','2','47','358','','2','1','','','0','0','0','2021-08-12','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3348','Muhaiminul','Aziz','AE02050','muhaiminul.aziz@timas.com','3604091410930001','55.730.828.5-401.000','','1993-10-14','Male','2','2','95','305','','2','1','','','0','0','0','2021-08-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3349','Mudahar','','AE00068','','1405021512770003','49.979.940.1-216.000','','1977-12-15','Male','2','2','40','283','','2','1','','','0','0','0','2019-12-09','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3350','ANDRIAN','ARIPIN','AE03214','','1402032509950001','63.776.774.0-213.000','','1995-09-25','MALE','2','2','40','283','','2','1','','','0','0','0','2022-03-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3351','Herman','Sofyan','AE00165','','1405022311710001','00.000.000.0-000.000','','1971-11-23','Male','2','2','55','409','','2','1','','','0','0','0','2021-09-14','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3352','Agung','Nugroho','AE00628','agung.nugroho@timas.com','1471092303910023','70.208.896.4-216.000','','1991-03-23','Male','2','2','46','','','2','1','','','0','0','0','2020-02-14','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3353','Jumedi','Budiman','AE02554','','1603030405760003','42.376.705.2-313.000','','1987-05-05','Male','2','2','17','271','','2','1','','','0','0','0','2021-08-04','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:37','2024-04-23 17:11:37');
INSERT INTO employees VALUES('3354','MAULAYA','SIDDIK PURBA','AE04156','','1208172502010001','63.648.655.7-117.000','','2001-02-25','MALE','2','2','99','403','','2','1','','','0','0','0','2022-07-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3355','Juma\'ah','','AE02844','','1603031409790004','86.813.536.9-313.000','','1979-09-14','Male','2','2','53','395','','2','1','','','0','0','0','2021-12-13','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3356','Edi','Derianto','AE00668','','1405020806740006','84.053.316.0-222.000','','1974-06-08','Male','2','2','17','279','','2','1','','','0','0','0','2020-02-17','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3357','Muhammad','Amri','AE02636','','1213101911940002','74.898.189.1-118.000','','1994-11-19','Male','2','2','17','268','','2','1','','','0','0','0','2021-09-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3358','Rudolf','Lumban Tobing','AE00072','','1408011008810002','93.874.230.1-222.000','','1981-08-10','Male','2','2','17','268','','2','1','','','0','0','0','2021-10-09','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3359','AHMAD','DUANI','AE07801','','1405020206730002','16.329.873.0-222.000','','1973-06-26','MALE','2','2','96','321','','2','1','','','0','0','0','2023-08-16','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3360','MUSLIM','SAHRONI SIHOMBING','AE04505','','1203031911910001','83.965.391.2-118.000','','1991-11-19','MALE','2','2','99','404','','2','1','','','0','0','0','2022-07-29','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3361','HARIMAN','','AE04765','','1405063004760001','81.961.625.1-222.000','','1976-04-25','MALE','2','2','40','292','','2','1','','','0','0','0','2022-09-06','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3362','Adim','','AE02981','','3212041912870002','','','1985-06-08','Male','2','2','51','388','','2','1','','','0','0','0','2022-01-29','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3363','Kristiwan','Silitonga','AE02567','','1202121812970001','00.000.000.0-000.000','','1997-12-18','Male','2','2','51','385','','2','1','','','0','0','0','2021-08-12','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3364','Aidiel','Anry','AE02572','','1405060109790002','59.629.283.2-122.000','','1979-09-01','Male','2','2','51','388','','2','1','','','0','0','0','2021-08-13','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3365','Charles','Fernando','AE01374','','1407050709940003','84.211.645.1-212.000','','1994-09-07','Male','2','2','51','389','','2','1','','','0','0','0','2020-09-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:38','2024-04-23 17:11:38');
INSERT INTO employees VALUES('3366','Goklin','Sibarani','AE02663','','1271141502850002','00.000.000.0-000.000','','1985-02-15','Male','2','2','51','','','2','1','','','0','0','0','2021-10-01','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3367','FAIS','HEJRI','AE03106','','1308041606920001','','','1992-06-16','MALE','2','2','51','385','','2','1','','','0','0','0','2022-02-23','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3368','MARUNTUNG','TAMBA','AE03117','','1217062707930001','','','1993-07-27','MALE','2','2','51','388','','2','1','','','0','0','0','2022-03-04','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3369','Emil','Suganda','AE05026','','3214110106940001','','','1994-06-01','Male','2','2','53','394','','2','1','','','0','0','0','2023-08-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3370','AI','SAADAH','AE05231','','1506066302990002','','','1999-02-23','Female','2','2','53','396','','2','1','','','0','0','0','2023-08-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3371','HAPOSAN','DAMANIK','AE07027','','1208101206030001','','','2004-06-18','MALE','2','2','51','388','','2','1','','','0','0','0','2022-09-29','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3372','REZA','ANDHY FAUZI','AE07470','','1506061701870002','','','1987-01-17','MALE','2','2','51','385','','2','1','','','0','0','0','2023-01-25','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3373','Ahmad','Imam Rafsanjanya','AE00772','','1276022110920002','94.211.555.1-114.000','','1992-10-21','Male','2','2','45','340','','2','1','','','0','0','0','2021-08-09','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3374','FAISAL','','AE09062','','1408042009900004','61.492.553.5-222.000','','1990-09-20','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3375','DIDIT','HARYANTO','AE09391','','1607031311890002','','','1989-11-13','MALE','2','2','','','','2','1','','','0','0','0','2023-08-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3376','Muhammad','Safi\'i','AE00760','','1408070106820001','94.470.322.2-222.000','','1982-06-01','Male','2','2','56','414','','2','1','','','0','0','0','2021-06-24','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3377','Berlin','Marbun','AE02184','','1211110610940002','53.034.824.2-128.000','','1994-10-06','Male','2','2','40','291','','2','1','','','0','0','0','2021-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3378','Farhan','Gusfadillah','AE00998','','1405020908020005','43.789.929.7-222.000','','2002-08-09','Male','2','2','83','362','','2','1','','','0','0','0','2021-09-15','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:39','2024-04-23 17:11:39');
INSERT INTO employees VALUES('3379','PANJI','ANGGRIO','AE03134','','1605012508970002','63.569.932.5-303.000','','1997-08-25','MALE','2','2','83','362','','2','1','','','0','0','0','2022-02-23','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3380','Jeprianto','','AE00907','','1223080511890003','95.568.180.4-222.000','','1989-02-04','Male','2','2','45','337','','2','1','','','0','0','0','2020-08-01','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3381','Renaldo','AL','AE00298','','1408042804820008','84.106.593.1-222.000','','1982-04-28','Male','2','2','53','397','','2','1','','','0','0','0','2021-09-09','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3382','ROBY','SAMUEL','AE04680','','1403090911980008','60.500.209.6-219.000','','1998-11-09','MALE','2','2','25','','','2','1','','','0','0','0','2022-08-13','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3383','SUFEBRIANTO','','AE04722','','1607011302850006','34.983.797.1-314.000','','1985-02-13','MALE','2','2','83','368','','2','1','','','0','0','0','2022-08-19','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3384','Ino','Resi Parno','AE00102','','1209140711830001','86.220.747.9-115.000','','1983-11-07','Male','2','2','50','379','','2','1','','','0','0','0','2021-08-18','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3385','Ahmad','Isa','AE00024','','1219052205760001','14.634.459.3-222.000','','1976-05-22','Male','2','2','46','','','2','1','','','0','0','0','2019-12-01','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3386','JUPRINDO','MANULANG','AE06626','','3217072020940002','','','1994-10-20','MALE','2','2','45','337','','2','1','','','0','0','0','2024-01-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3387','HOLMES','SINAGA','AE06603','','1217052504030001','','','2003-04-25','MALE','2','2','45','339','','2','1','','','0','0','0','2023-08-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3388','RUDI','HARTONO PANJAITAN','AE04101','','1208111109790002','','','1979-08-11','MALE','2','2','40','293','','2','1','','','0','0','0','2022-06-28','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3389','DODO','','AE09527','','3206370406670002','','','1967-06-04','MALE','2','2','','','','2','1','','','0','0','0','2024-01-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3390','ANGGA','ARINANDA','AE07414','','1304051809860002','','','1986-09-18','MALE','2','2','83','362','','2','1','','','0','0','0','2023-01-18','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:40','2024-04-23 17:11:40');
INSERT INTO employees VALUES('3391','Bina','Suryani','AE00091','bina.suryani@timas.com','1571024303900041','94.082.556.5-335.000','','1990-03-03','Female','2','2','48','360','','2','1','','','0','0','0','2021-07-29','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3392','AZMANDA','','AE00555','azmanda@timas.com','1407051804960004','90.610.203.3-212.000','','1996-04-18','MALE','2','2','17','269','','2','1','','','0','0','0','2021-12-27','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3393','ADANG','','AE09529','','3206371908700003','','','1970-08-19','MALE','2','2','','','','2','1','','','0','0','0','2024-01-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3394','Paisal','Hakim','AE05027','','3214111206030003','','','1993-06-12','Male','2','2','53','399','','2','1','','','0','0','0','2021-10-01','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3395','TONI','NUGRAHA','AE09105','','3207190707980002','','','1998-07-07','MALE','2','2','98','296','','2','1','','','0','0','0','2024-01-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3396','Suryadi','','AE00453','','1371012310700002','83.605.546.7-222.000','','1978-10-23','Male','2','2','17','268','','2','1','','','0','0','0','2021-06-25','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3397','AMRIH','WIBOWO','AE04735','','1607012007840001','60.612.695.1-314.000','','1984-07-20','MALE','2','2','83','363','','2','1','','','0','0','0','2023-09-23','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3398','BAGANDA','TUA SIANTURI','AE07158','','1206012501990004','','','1999-01-25','MALE','2','2','98','296','','2','1','','','0','0','0','2023-09-29','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3399','ANKE','RIFALDI','AE07812','','1604101303970006','50.143.764.4-309.000','','1997-03-13','MALE','2','2','99','403','','2','1','','','0','0','0','2023-09-30','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3400','Roi','Hotasi Siallagan','AE00264','','1208016402750001','93.932.712.8-117.000','','1973-08-16','Male','2','2','50','374','','2','1','','','0','0','0','2021-08-12','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3401','Liman','Boston Silaban','AE02682','','1216052508990004','53.588.117.1-222.000','','1999-08-25','Male','2','2','50','375','','2','1','','','0','0','0','2021-10-06','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3402','Ikhma','Kurniawan','AE02700','','1602080804940002','43.704.169.2-312.000','','1994-08-08','Male','2','2','50','374','','2','1','','','0','0','0','2021-10-07','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:41','2024-04-23 17:11:41');
INSERT INTO employees VALUES('3403','SIMON','SILABAN','AE04344','','1216050206040002','','','2004-06-02','MALE','2','2','50','380','','2','1','','','0','0','0','2022-07-19','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3404','AMOS','BUTAR BUTAR','AE07119','','1218133006040002','','','2004-06-30','MALE','2','2','50','380','','2','1','','','0','0','0','2022-10-12','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3405','PARNINGOTAN','BUTAR BUTAR','AE07372','','1223010809890003','62.328.212.6-116.000','','1989-09-08','MALE','2','2','50','381','','2','1','','','0','0','0','2022-12-30','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3406','Tommi','Erikson Tambunan','AE00832','','1405022103830002','92.254.092.7-222.000','','1983-03-21','Male','2','2','53','398','','2','1','','','0','0','0','2021-10-05','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3407','Indra','Gunawan Hasibuan','AE00432','','1205171305930005','93.987.048.1-119.000','','1993-05-13','Male','2','2','53','398','','2','1','','','0','0','0','2021-09-14','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3408','Bena','Adiningtias','AE02630','','1509090607970001','53.904.093.1-222.000','','1997-07-06','Male','2','2','53','399','','2','1','','','0','0','0','2021-09-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3409','Cecep','Hermawan','AE00188','','1610080810810001','84.311.495.0-312.000','','1981-10-08','Male','2','2','53','397','','2','1','','','0','0','0','2021-09-14','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3410','IRMANSYAH','','AE07803','','1405020606750009','59.372.746.4-222.000','','1975-06-06','MALE','2','2','53','400','','2','1','','','0','0','0','2023-09-01','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3411','Zulham','','AE00289','','1219062201880001','81.130.709.9-115.000','','1988-08-04','Male','2','2','53','399','','2','1','','','0','0','0','2023-09-11','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3412','MHD.','FADLAN','AE07811','','1213081010720002','','','1972-10-10','MALE','2','2','53','398','','2','1','','','0','0','0','2023-09-11','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3413','EDY','SUSANTO','AE09439','','1208232310870001','','','1987-10-23','MALE','2','2','','','','2','1','','','0','0','0','2023-10-16','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3414','Hartono','Siburian','AE09443','','1223030208970002','','','1997-08-02','Male','2','2','45','','','2','1','','','0','0','0','2022-08-02','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:42','2024-04-23 17:11:42');
INSERT INTO employees VALUES('3415','NUR','IKHSAN','AE07828','','1605121808820004','67.921.655.6-314.000','','1982-08-18','MALE','2','2','83','369','','2','1','','','0','0','0','2023-10-16','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3416','Alif','Fauzan','AE01015','','1408041208010001','00.000.000.0-000.000','','2001-08-12','Male','2','2','38','','','2','1','','','0','0','0','2021-08-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3417','ARON','RAYMOND P','AE01061','','1211110207980001','53.535.624.0-222.000','','1998-07-02','Male','2','2','45','337','','2','1','','','0','0','0','2023-11-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3418','Anggi','Firdaus Ernawan','AE02627','','1405020806960004','43.165.081.1-222.000','','1996-09-08','Male','2','2','96','318','','2','1','','','0','0','0','2021-09-17','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3419','ADIBAH','HASNAH','AE07830','adibah.hasnah@timas.com','1405024203000007','60.065.996.5-222.000','','2000-03-02','FEMALE','2','2','47','359','','2','1','','','0','0','0','2023-10-28','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3420','Toni','Mardiyan','AE02550','','1209141010990001','94.529.034.4-115.000','','1998-10-09','Male','2','2','96','322','','2','1','','','0','0','0','2021-07-30','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3421','DANIEL','MARPAUNG','AE09456','','1401060503740004','','','1974-03-05','MALE','2','2','','','','2','1','','','0','0','0','2023-10-13','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3422','NICHO','ADITYA SYAHPUTRA. N','AE03593','','3273230610030002','61.655.045.5-222.000','','2003-10-06','MALE','2','2','45','340','','2','1','','','0','0','0','2023-10-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3423','EDI','CHANIAGO SITORUS','AE09531','','1405021608960004','','','1996-08-16','MALE','2','2','','','','2','1','','','0','0','0','2024-01-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3424','Daseng','Suherman','AE02081','','3206371912710001','','','1971-12-19','Male','2','2','53','394','','2','1','','','0','0','0','2021-10-01','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3425','Puji','Pidiyanto','AE00085','','1374010406780001','83.959.744.0-202.000','','1978-06-04','Male','2','2','45','','','2','1','','','0','0','0','2021-08-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3426','M','ADAM BRAMASTA','AE05415','','3510160805010002','62.394.358.6-627.000','','2001-05-08','MALE','2','2','45','','','2','1','','','0','0','0','2022-05-24','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3427','METHA','LEUEKA','AE09392','','3572027009000004','','','2000-09-30','FEMALE','2','2','45','343','','2','1','','','0','0','0','2023-07-12','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:43','2024-04-23 17:11:43');
INSERT INTO employees VALUES('3428','SYAHRIZAL','POHAN','AE05323','','1210011207920001','','','2002-07-12','MALE','2','2','56','418','','2','1','','','0','0','0','2022-02-28','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3429','Sihol','Manurung','AE00464','','1405021407770004','69.838.193.6-222.000','','1977-07-14','Male','2','2','56','419','','2','1','','','0','0','0','2021-06-24','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3430','Hotbel','Silaban','AE02583','','2171032007879004','','','1987-07-20','Male','2','2','56','414','','2','1','','','0','0','0','2021-08-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3431','ADI','KUSUMA','AE00062','','1405022709780005','58.067.490.1-222.000','','1978-09-27','MALE','2','2','45','336','','2','1','','','0','0','0','2022-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3432','DADANG','SURYANA','AE02191','','1223062504850003','84.276.622.2-222.000','','1985-04-25','MALE','2','2','45','337','','2','1','','','0','0','0','2022-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3433','IRFAN','JAYANTO','AE04930','','1471080707900041','','','1990-07-07','MALE','2','2','45','337','','2','1','','','0','0','0','2022-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3434','DWI','AFRIASTOMO ARBI','AE04939','','1205150904000002','','','2000-04-09','MALE','2','2','45','340','','2','1','','','0','0','0','2022-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3435','SUDARMONO','','AE04940','','1405022904860003','64.294.061.3-222.000','','1986-04-19','MALE','2','2','45','340','','2','1','','','0','0','0','2022-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3436','ANDRY','DEL PIERO SIMBOLON','AE04941','','1211040502980004','42.781.124.5-222.000','','1998-02-05','MALE','2','2','45','340','','2','1','','','0','0','0','2022-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3437','AFRI','FAHRURAZI','AE07762','','1205153007990002','','','1998-02-03','MALE','2','2','45','340','','2','1','','','0','0','0','2023-07-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3438','MARAJOHAN','P.ARITONANG','AE09491','','1202101904020002','','','2002-04-19','MALE','2','2','45','339','','2','1','','','0','0','0','2023-11-06','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3439','JEFRY','SIHOMBING','AE09492','','1211112602970003','','','1997-02-26','MALE','2','2','','','','2','1','','','0','0','0','2023-11-15','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:44','2024-04-23 17:11:44');
INSERT INTO employees VALUES('3440','CANDRA','SILITONGA','AE05243','','1405020505910014','','','1991-05-05','MALE','2','2','51','386','','2','1','','','0','0','0','2023-11-17','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3441','AIDIL','AMALI','AE07831','','1407052112010001','','','2001-12-21','MALE','2','2','51','388','','2','1','','','0','0','0','2023-11-17','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3442','MUHAMMAD','KHAIRUL AMBRI','AE07832','','1219041310040007','','','2004-10-13','MALE','2','2','83','362','','2','1','','','0','0','0','2023-11-13','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3443','UJANG','EKO SAPUTRA','AE07834','','1506031804900004','','','1990-04-18','MALE','2','2','51','385','','2','1','','','0','0','0','2023-11-13','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3444','AFRIZAL','','AE00557','','1304032109880001','94.020.020.7-204.000','','1988-09-21','MALE','2','2','45','340','','2','1','','','0','0','0','2022-02-07','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3445','ANDRI','ROZA','AE00718','','1408060704750001','','','1975-04-07','MALE','2','2','45','341','','2','1','','','0','0','0','2022-02-07','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3446','ARMANSYAH','','AE03048','','1304032002950004','','','1995-02-20','MALE','2','2','45','337','','2','1','','','0','0','0','2022-02-11','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3447','JEFRI','AGUSTONO PANGARIBUAN','AE03183','','1212071708910001','77.648.365.3-127.000','','1991-08-17','MALE','2','2','45','344','','2','1','','','0','0','0','2022-03-15','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3448','SOPANDI','','AE03940','','1208082609930002','','','1993-11-16','MALE','2','2','45','337','','2','1','','','0','0','0','2022-06-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3449','T','FAJRI','AE03949','','1111031403960001','','','1996-03-14','MALE','2','2','45','344','','2','1','','','0','0','0','2022-06-15','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3450','M','RIDHO KURNIAWAN','AE07280','','1471092807010123','50.374.983.0-216.000','','2001-07-28','MALE','2','2','45','','','2','1','','','0','0','0','2022-11-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3451','EDI','SETYAWAN','AE07313','','1209181501000003','','','2000-01-15','MALE','2','2','45','340','','2','1','','','0','0','0','2022-11-25','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:45','2024-04-23 17:11:45');
INSERT INTO employees VALUES('3452','Martomu','Sihombing','AE02559','','1405020112710002','43.051.445.5-222.000','','1971-12-01','Male','2','2','96','323','','2','1','','','0','0','0','2023-11-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3453','SYAHRIAL','','AE00415','','1304033108670001','94.203.643.5-204.000','','1967-08-31','MALE','2','2','45','345','','2','1','','','0','0','0','2022-02-07','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3454','MIKES','SUWANDI','AE07295','mikes.suwandi@timas.com','1409011603930001','40.257.715.9-213.000','','1993-03-16','MALE','2','2','17','','','2','1','','','0','0','0','2022-11-19','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3455','WINANTO','','AE03569','','3312050201900002','61.312.653.1-532.000','','1990-01-02','MALE','2','2','45','337','','2','1','','','0','0','0','2022-05-13','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3456','EDI','WARDANI','AE03524','','1213080405920001','86.205.967.2-118.000','','1992-05-04','MALE','2','2','45','341','','2','1','','','0','0','0','2022-05-13','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3457','KRISTIAN','VIERIANTO SIMAREMARE','AE03734','','1405021209030006','','','2003-09-12','MALE','2','2','45','339','','2','1','','','0','0','0','2022-06-02','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3458','Arif','Rahman Setia Ramadani','AE00570','arif.rahman@timas.com','1277021701970003','94.227.845.8-222.000','','1997-01-17','Male','2','2','17','281','','2','1','','','0','0','0','2021-07-30','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3459','Torkis','Rangkuti','AE00820','torkis.rangkuti@timas.com','1471053112730102','15.731.224.0-211.000','','1973-12-31','Male','2','2','17','','','2','1','','','0','0','0','2021-07-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3460','SALAMUN','','AE03396','','1405060704800003','39.696.490.0-222.000','','1980-04-07','MALE','2','2','17','268','','2','1','','','0','0','0','2022-04-25','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3461','Paisal','Nasution','AE00109','','1213012803880004','84.003.537.2-118.000','','1988-03-28','Male','2','2','17','268','','2','1','','','0','0','0','2019-12-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3462','YUS','MELANIE SIRAIT','AE03009','','1271014705990006','43.299.094.3-111.000','','1999-05-07','FEMALE','2','2','83','362','','2','1','','','0','0','0','2022-02-03','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3463','JOHAN','TUA PANJAITAN','AE06560','','1671070909860015','','','1986-09-09','MALE','2','2','45','342','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3464','ERIJAL','MARBUN','AE06627','','1217060903040002','50.336.290.7-222.000','','2004-03-09','MALE','2','2','','','','2','1','','','0','0','0','2023-11-21','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:46','2024-04-23 17:11:46');
INSERT INTO employees VALUES('3465','SENTOSA','GEA','AE04208','','1204110711010001','','','2001-11-01','MALE','2','2','45','339','','2','1','','','0','0','0','2023-11-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3466','WAHYU','WIDODO','AE06514','','1405063008990002','','','1997-08-30','MALE','2','2','45','342','','2','1','','','0','0','0','2023-11-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3467','PEPI','SOPIAN','AE09436','','1405021906870007','','','1987-06-19','MALE','2','2','45','342','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3468','MUHAMMAD','DANIL','AE09431','','1108081110880001','','','1988-10-11','MALE','2','2','','','','2','1','','','0','0','0','2023-11-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3469','Abdul','Rahmansyah','AE00099','','1209050403920001','93.761.680.3-115.000','','1991-08-13','Male','2','2','45','340','','2','1','','','0','0','0','2023-11-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3470','Bambang','Budianto','AE01349','','1408041909770002','62.396.503.5-222.000','','1977-09-19','Male','2','2','45','337','','2','1','','','0','0','0','2023-11-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3471','Zulham','Effendi','AE00098','','1219051011870006','74.994.860.0-115.000','','1987-11-10','Male','2','2','45','340','','2','1','','','0','0','0','2023-11-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3472','EDI','SYA PUTRA','AE03327','','1209140503010001','63.797.966.7-115.000','','2001-03-05','MALE','2','2','50','378','','2','1','','','0','0','0','2022-04-12','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3473','ALFINO','EKO NANDA','AE07298','','1373041903960001','','','1996-04-19','MALE','2','2','45','337','','2','1','','','0','0','0','2022-11-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3474','ASTIAN','','AE03942','','1602120107890103','','','1989-02-07','MALE','2','2','45','340','','2','1','','','0','0','0','2022-06-10','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3475','DECKY','CANDRA PRAYOGI','AE07301','','3511162706950002','71.803.711.2-656.000','','1995-06-27','MALE','2','2','45','344','','2','1','','','0','0','0','2022-11-25','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3476','DWIKI','FEBRIANANDA','AE07305','','1373042202010001','','','2001-02-22','MALE','2','2','45','340','','2','1','','','0','0','0','2022-11-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:47','2024-04-23 17:11:47');
INSERT INTO employees VALUES('3477','FARHAN','WALID','AE07254','','1307020803940002','','','1994-03-08','MALE','2','2','45','344','','2','1','','','0','0','0','2022-11-14','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3478','HERMAN','','AE03224','','1302080107750010','','','1975-07-01','MALE','2','2','45','340','','2','1','','','0','0','0','2022-03-22','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3479','IRFAN','SAPUTRA','AE03185','','1307021111000001','','','2000-11-11','MALE','2','2','45','340','','2','1','','','0','0','0','2022-03-15','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3480','WAHYUDI','ALFITRA','AE03034','','1471091101920001','16.743.515.5-216.000','','1992-01-11','MALE','2','2','45','337','','2','1','','','0','0','0','2022-02-07','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3481','YULIUS','HALAWA','AE03228','','1408040707900003','','','1990-07-07','MALE','2','2','45','337','','2','1','','','0','0','0','2022-03-21','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3482','ZULHAM','','AE04057','','1271080304700001','65.860.452.5-112.000','','1970-04-03','MALE','2','2','45','341','','2','1','','','0','0','0','2022-06-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3483','Sugiyanto','','AE02586','','3305060806740001','71.826.794.1-222.000','','1974-06-08','Male','2','2','45','336','','2','1','','','0','0','0','2021-08-16','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3484','Jarwin','Silaban','AE00358','','1405021101870002','84.115.241.6-222.000','','1987-01-11','Male','2','2','53','398','','2','1','','','0','0','0','2021-10-01','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3485','Abu','Bakar Sidik','AE00311','','1219050702940005','93.783.600.5-115.000','','1994-02-07','Male','2','2','53','399','','2','1','','','0','0','0','2021-10-06','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3486','Sugun','Raharjo','AE02764','','3305050110970002','53.615.261.4-222.000','','1997-10-01','Male','2','2','45','339','','2','1','','','0','0','0','2021-11-09','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3487','MARIHOTTUA','S','AE00978','','1471082611900001','60.488.928.7-222.000','','1990-11-26','MALE','2','2','45','337','','2','1','','','0','0','0','2022-04-22','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3488','Zulfahmi','','AE99068','','1205172305840002','43.428.097.0-119.000','','1984-05-23','Male','2','2','45','337','','2','1','','','0','0','0','2021-10-01','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:48','2024-04-23 17:11:48');
INSERT INTO employees VALUES('3489','JEKKY','AGUSTA ARITONANG','AE05539','','1401066601010002','','','1996-08-17','MALE','2','2','45','340','','2','1','','','0','0','0','2023-06-13','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3490','MUHAMMAD','ERLANGGA','AE07686','','1671022710940012','','','1994-10-27','MALE','2','2','45','340','','2','1','','','0','0','0','2023-06-28','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3491','IKA','GUSTIAWAN','AE07700','','1409013108040001','','','2004-08-31','MALE','2','2','45','339','','2','1','','','0','0','0','2023-07-06','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3492','Bastian','Sibarani','AE01019','','1405020411970002','95.928.842.4-222.000','','1997-11-04','Male','2','2','45','336','','2','1','','','0','0','0','2023-11-25','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3493','Muhammad','Febri','AE99014','','1405022505020010','43.114.063.1.222.000','','2002-05-25','Male','2','2','45','339','','2','1','','','0','0','0','2021-10-01','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3494','Mangatur','Hutauruk','AE02750','','1209162408880002','53.430.880.4-222.000','','1988-08-24','Male','2','2','45','337','','2','1','','','0','0','0','2021-11-05','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3495','Rendra','Maresta','AE02763','','1408042105840001','84.249.906.3-222.000','','1984-05-21','Male','2','2','45','341','','2','1','','','0','0','0','2021-11-03','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3496','Faudri','Amhal','AE02791','','1219051202830004','57.372.991.0-086.000','','1983-02-12','Male','2','2','45','340','','2','1','','','0','0','0','2021-11-17','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3497','WILLY','WAHYUDI','AE03733','','1671020501030014','65.379.487.5-306.000','','2003-01-05','MALE','2','2','45','337','','2','1','','','0','0','0','2022-05-23','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3498','FAUZAN','','AE04649','','3601091005880001','60.292.230.4-419.000','','1978-01-05','MALE','2','2','45','337','','2','1','','','0','0','0','2022-08-09','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3499','Bayu','','AE02589','','1405022007020003','43.102.828.1-222.000','','2002-07-20','Male','2','2','45','339','','2','1','','','0','0','0','2021-08-24','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3500','MUHAMMAD','KHADAFFI A','AE07678','','1471061205930021','','','1993-05-12','MALE','2','2','45','339','','2','1','','','0','0','0','2023-07-01','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3501','BAYANUDIN','','AE05491','','3206372512960001','','','1996-12-25','MALE','2','2','98','302','','2','1','','','0','0','0','2022-12-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:49','2024-04-23 17:11:49');
INSERT INTO employees VALUES('3502','UUN','','AE02348','','3206390211610002','','','1961-11-02','MALE','2','2','98','302','','2','1','','','0','0','0','2022-10-03','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3503','Amin','Rosidin','AE00253','','1506060102860000','','','1986-02-01','Male','2','2','98','304','','2','1','','','0','0','0','2023-08-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3504','RETNO','PRANATA SINAGA','AE05942','','1401150306980001','','','1998-06-03','MALE','2','2','45','337','','2','1','','','0','0','0','2023-02-23','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3505','DASRIL','A','AE07188','','1371081012780001','','','1978-12-10','MALE','2','2','56','420','','2','1','','','0','0','0','2022-12-20','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3506','RAHMAD','NURHIDAYAT','AE00573','','1403120602945004','94.030.591.5-219.000','','1994-02-06','MALE','2','2','56','418','','2','1','','','0','0','0','2023-09-05','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3507','Asep','Mulyana','AE05212','','1408042206860001','','','1986-06-22','Male','2','2','45','342','','2','1','','','0','0','0','2022-01-16','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3508','LEDYANA','MANALU','AE05428','','1405025201980005','','','1998-01-12','MALE','2','2','','','','2','1','','','0','0','0','2022-09-07','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3509','Junansi','Gultom','AE00267','','1405021010780012','64.310.725.3-222.000','','1978-10-10','Male','2','2','56','414','','2','1','','','0','0','0','2021-06-24','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3510','Patar','Sianipar','AE00769','','1271020806830003','84.528.897.6-124.000','','1983-06-08','Male','2','2','56','414','','2','1','','','0','0','0','2021-06-24','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3511','ALIAMSAH','TINAMBUNAN','AE02174','','1408042505850003','','','1985-05-25','MALE','2','2','56','418','','2','1','','','0','0','0','2022-09-14','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3512','JEKI','','AE03220','','1602080912880001','12.056.103.0-312.000','','1988-12-09','MALE','2','2','50','375','','2','1','','','0','0','0','2022-03-22','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3513','SUHARTO','','AE03794','','1407081504740002','47.002.963.8-222.000','','1974-04-15','MALE','2','2','43','335','','2','1','','','0','0','0','2022-05-28','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:50','2024-04-23 17:11:50');
INSERT INTO employees VALUES('3514','DERA','ALFINDI','AE03464','','1408041612920001','64.294.026.6-222.000','','1992-12-16','MALE','2','2','43','327','','2','1','','','0','0','0','2022-05-09','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3515','DHIKA','PRASETYO','AE03793','','1505072401880002','','','1988-01-24','MALE','2','2','43','330','','2','1','','','0','0','0','2022-06-28','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3516','IRWAN','MANALU','AE03828','','1209112511010001','','','2001-01-25','MALE','2','2','43','327','','2','1','','','0','0','0','2022-06-06','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3517','IRWAN','SULFAN','AE07492','','1401020502860001','','','1986-02-05','MALE','2','2','43','328','','2','1','','','0','0','0','2023-02-06','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3518','JAMRES','TOGATOROP','AE07142','','1216040906810001','','','1991-03-01','MALE','2','2','43','327','','2','1','','','0','0','0','2023-07-05','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3519','JULIASKA','','AE04324','','1471071307690001','84.778.179.6-216.000','','1969-07-13','MALE','2','2','43','','','2','1','','','0','0','0','2022-07-12','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3520','MARTUA','PARLAGUTAN HUTAPEA','AE03955','','1202030103690002','','','1969-03-01','MALE','2','2','43','326','','2','1','','','0','0','0','2022-06-07','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3521','MASLAN','ARITONANG','AE04449','','1208011405850006','43.077.823.3-222.000','','1985-05-14','MALE','2','2','43','326','','2','1','','','0','0','0','2023-07-05','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3522','RIZKI','WANDA TAMBUNAN','AE04581','','1277022109830001','','','1983-09-21','MALE','2','2','43','327','','2','1','','','0','0','0','2022-08-09','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3523','Sapi\'i','','AE02840','','1404081306970001','00.000.000.0-000.000','','1997-06-13','Male','2','2','44','','','2','1','','','0','0','0','2021-12-11','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3524','Wendi','Nurwandani','AE02836','','1209320712000002','00.000.000.0-000.000','','2000-12-07','Male','2','2','44','','','2','1','','','0','0','0','2021-12-09','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3525','Firdaus','','AE01322','','1472011705800042','00.000.000.0-000.000','','1980-05-17','Male','2','2','45','','','2','1','','','0','0','0','2020-10-03','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3526','Sutino','','AE00086','','3312162101770001','62.376.366.1-532.000','','1977-01-21','Male','2','2','56','421','','2','1','','','0','0','0','2022-04-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:51','2024-04-23 17:11:51');
INSERT INTO employees VALUES('3527','KADRI','RAHMAD','AE07226','','1305091212010003','','','2000-12-30','MALE','2','2','56','416','','2','1','','','0','0','0','2022-11-11','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3528','MEDRI','YANTO','AE04965','','1408041802870005','','','1987-02-18','MALE','2','2','56','420','','2','1','','','0','0','0','2022-09-22','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3529','YOHANES','PURNOMO ADI','AE00798','','1271110412890002','50.317.973.1-222.000','','1989-12-04','MALE','2','2','56','418','','2','1','','','0','0','0','2022-10-17','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3530','Amin','','AE00488','','3212102006890004','90.119.303.7-312.000','','1989-06-20','Male','2','2','56','420','','2','1','','','0','0','0','2020-02-03','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3531','Saut','Tua','AE02846','','1403091212940007','72.557.855.3-219.000','','1994-12-12','Male','2','2','56','420','','2','1','','','0','0','0','2021-11-24','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3532','RUDI','HAMKA PASARIBU','AE02370','','1408042511770005','66.752.101.7-222.000','','1977-11-25','MALE','2','2','56','418','','2','1','','','0','0','0','2022-03-13','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3533','HASANUDDIN','HASIBUAN','AE03274','','1222031407990005','','','1999-07-14','MALE','2','2','56','418','','2','1','','','0','0','0','2022-04-01','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3534','VIKI','ARDIANSYAH','AE07331','','1671070609000007','93.616.680.0-222.000','','2000-09-06','MALE','2','2','56','416','','2','1','','','0','0','0','2022-12-06','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3535','VICTOR','GULTOM','AE00096','','1202131811840001','74.969.290.1-127.000','','1984-11-18','MALE','2','2','56','418','','2','1','','','0','0','0','2022-05-18','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3536','Hiskia','Munthe','AE00831','','1405021011840013','','','1984-11-10','Male','2','2','56','414','','2','1','','','0','0','0','2022-03-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3537','NASRO','DAMANIK','AE03139','','1208101103970003','85.806.347.2-225.000','','1997-03-11','MALE','2','2','56','418','','2','1','','','0','0','0','2022-02-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3538','FADLIL','ABDULLATIF','AE07253','','1306093005950001','','','1995-05-30','MALE','2','2','56','416','','2','1','','','0','0','0','2022-11-14','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:52','2024-04-23 17:11:52');
INSERT INTO employees VALUES('3539','MARDI','','AE00824','','1405022312890001','84.450.035.5-222.000','','1989-12-23','MALE','2','2','45','','','2','1','','','0','0','0','2022-06-27','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3540','ILHAM','HANAFI','AE02811','','1213082504930002','84.242.074.7-118.000','','1993-04-25','MALE','2','2','43','327','','2','1','','','0','0','0','2021-11-26','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3541','ISKANDAR','MUDA','AE99451','','1403131508000003','53.332.971.0-219.000','','2000-08-15','MALE','2','2','43','329','','2','1','','','0','0','0','2021-12-02','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3542','MUHAMMAD','KHAIDIR','AE03871','','1405060512750001','','','1975-12-05','MALE','2','2','45','341','','2','1','','','0','0','0','2022-06-08','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3543','EDY','KURNIAWAN','AE03579','','1205151010850008','','','1985-10-10','MALE','2','2','45','340','','2','1','','','0','0','0','2022-05-17','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3544','ADEN','ARZONA','AE04249','','1407072906950003','50.323.065.8-212.000','','1995-06-29','MALE','2','2','45','340','','2','1','','','0','0','0','2022-07-07','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3545','Bezalel','Pandiangan','AE00967','','1223030507000001','94.105.321.7-116.000','','2000-07-05','Male','2','2','45','341','','2','1','','','0','0','0','2022-06-27','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3546','HAMIDI','','AE04209','','1405025209920005','50.216.532.7-222.000','','1992-09-12','MALE','2','2','45','340','','2','1','','','0','0','0','2022-07-08','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3547','ANTON','','AE04288','','1203212703030004','','','2003-03-27','MALE','2','2','45','339','','2','1','','','0','0','0','2022-07-08','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3548','MEMET','','AE07425','','1405062608000002','','','2000-08-26','MALE','2','2','45','340','','2','1','','','0','0','0','2023-01-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3549','DEDI','APRIANTO','AE04431','','1208221104900004','','','1990-04-11','MALE','2','2','45','340','','2','1','','','0','0','0','2023-01-26','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3550','ALEX','LEONARDO SIPAYUNG','AE07445','','1211011912000001','50.322.639.1-222.000','','2000-12-19','MALE','2','2','45','340','','2','1','','','0','0','0','2023-01-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3551','RUDI','CHARIANTO','AE04027','','1116021204920001','76.801.610.7-105.000','','1992-04-12','MALE','2','2','43','329','','2','1','','','0','0','0','2023-02-01','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:53','2024-04-23 17:11:53');
INSERT INTO employees VALUES('3552','DANIEL','SYAPUTRA PANDIANGAN','AE07521','','1223031009000001','','','2000-09-10','MALE','2','2','45','340','','2','1','','','0','0','0','2023-02-13','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3553','ANING','HIDAYATULLOH','AE04256','','3213170509860001','50.344.039.8-439.000','','1986-09-05','MALE','2','2','45','337','','2','1','','','0','0','0','2022-07-07','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3554','Pantas','Silitonga','AE00492','','1271142608870001','84.209.561.4-113.000','','1987-08-26','Male','2','2','51','390','','2','1','','','0','0','0','2020-01-27','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3555','Apit','Hariadi','AE00749','','1408022804930003','72.506.011.5-222.000','','1995-06-28','Male','2','2','51','385','','2','1','','','0','0','0','2022-01-09','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3556','Aspiner','Pasaribu','AE01286','','1203212506850002','90.017.647.0-118.000','','1985-06-25','Male','2','2','51','384','','2','1','','','0','0','0','2020-09-24','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3557','BUNSAWAN','','AE04599','','1602122004990004','','','1998-01-27','MALE','2','2','51','386','','2','1','','','0','0','0','2022-08-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3558','Antoni','Manalu','AE02194','','1201093006900002','00.000.000.0-000.000','','1990-06-30','Male','2','2','51','385','','2','1','','','0','0','0','2021-08-20','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3559','Daniel','Togi Parulian Tampubolon','AE02672','','1210011102920009','84.320.212.8-116.000','','1992-02-11','Male','2','2','51','385','','2','1','','','0','0','0','2021-10-01','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3560','Darno','Manalu','AE02196','','1201022710940003','84.355.343.9-126.000','','1994-10-27','Male','2','2','51','385','','2','1','','','0','0','0','2020-06-12','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3561','DEDEK','','AE04108','','1602082605870001','','','1987-05-26','MALE','2','2','51','385','','2','1','','','0','0','0','2022-06-24','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3562','FITRAH','HIDAYAT','AE07471','','1506021701870001','93.936.265.3-334.000','','1987-01-17','MALE','2','2','51','385','','2','1','','','0','0','0','2023-01-25','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3563','James','Purba','AE02897','','1223041504860005','00.000.000.0-000.000','','1986-04-15','Male','2','2','51','385','','2','1','','','0','0','0','2022-01-09','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:54','2024-04-23 17:11:54');
INSERT INTO employees VALUES('3564','Lili','Budi Hartono','AE00451','','1671100510810011','86.841.242.0-301.000','','1981-10-05','Male','2','2','51','385','','2','1','','','0','0','0','2022-01-09','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employees VALUES('3565','MARULI','TUA','AE07562','','1407100710030004','','','2003-01-07','MALE','2','2','51','386','','2','1','','','0','0','0','2023-03-08','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employees VALUES('3566','Ronal','Sinaga','AE02661','','1208160605910001','84.441.130.6-225.000','','1991-05-06','Male','2','2','51','385','','2','1','','','0','0','0','2021-09-26','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employees VALUES('3567','Wendi','','AE00491','','1602122101910003','66.999.053.3-312.000','','1991-01-21','Male','2','2','51','384','','2','1','','','0','0','0','2021-08-06','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employees VALUES('3568','Lamres','Sinambela','AE00410','','1408041111780011','70.510.892.6-219.000','','1978-11-11','Male','2','2','45','336','','2','1','','','0','0','0','2021-07-31','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employees VALUES('3569','JAMOT','NOVEN TOGATOROP','AE04157','','1202151911020002','','','2002-11-19','MALE','2','2','45','340','','2','1','','','0','0','0','2022-06-28','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employees VALUES('3570','PAIAN','BATUARA','AE03140','','1408040303710011','','','1971-03-03','MALE','2','2','45','340','','2','1','','','0','0','0','2022-02-28','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employees VALUES('3571','SAMSUL','','AE00759','','2171032609850002','75.713.140.4-215.000','','1985-09-26','MALE','2','2','45','341','','2','1','','','0','0','0','2022-05-25','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employees VALUES('3572','DAVID','SIMANJUNTAK','AE03731','','1408042809010002','','','2001-09-28','MALE','2','2','45','340','','2','1','','','0','0','0','2022-05-27','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employees VALUES('3573','TEGUH','SYAIDINA ALI','AE03357','','1405021006930001','74.014.114.8-222.000','','1993-06-10','MALE','2','2','45','337','','2','1','','','0','0','0','2022-04-19','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:55','2024-04-23 17:11:55');
INSERT INTO employees VALUES('3574','RIO','MANOGI ULI SIREGAR','AE03380','','1405032301990007','65.118.959.9-222.000','','1999-01-23','MALE','2','2','45','340','','2','1','','','0','0','0','2022-04-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3575','JONES','SIBURIAN','AE04614','','1216040909930003','','','1993-09-09','MALE','2','2','45','340','','2','1','','','0','0','0','2023-07-07','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3576','CHANDRA','S','AE04789','','1405021811890002','65.563.224.8-222.000','','1989-11-18','MALE','2','2','45','340','','2','1','','','0','0','0','2022-09-07','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3577','GABRIEL','PRISMAN','AE07838','','1403092712030002','65.779.961.5-219.000','','2003-12-27','MALE','2','2','51','','','2','1','','','0','0','0','2023-12-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3578','FAISAL','','AE07842','','1223013006930004','','','1993-06-30','MALE','2','2','51','388','','2','1','','','0','0','0','2023-12-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3579','IBNU','HAJAR','AE07299','','1602080908780002','','','1979-08-28','MALE','2','2','45','340','','2','1','','','0','0','0','2023-12-19','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3580','EDWAR','','AE07844','','1304031212920001','','','1992-12-12','MALE','2','2','45','340','','2','1','','','0','0','0','2023-12-19','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3581','BENY','SAPUTRA','AE07845','','1471092507900001','','','1990-07-25','MALE','2','2','45','340','','2','1','','','0','0','0','2023-12-19','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3582','Bahrum','Efendi','AE00111','','1171022810650001','09.719.145.6-216.000','','1965-10-28','Male','2','2','45','336','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3583','Polmat','Rumabutar','AE00175','','1202112404920005','86.961.556.7-127.000','','1992-04-24','Male','2','2','45','337','','2','1','','','0','0','0','2023-12-21','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3584','IWAN','TAMPUBOLON','AE03812','','1202122211890001','43.275.743.3-127.000','','1989-11-22','MALE','2','2','45','337','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3585','Elron','Pasaribu','AE02954','','1205161502870009','90.082.964.9-222.000','','1987-02-15','Male','2','2','45','337','','2','1','','','0','0','0','2024-01-12','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:56','2024-04-23 17:11:56');
INSERT INTO employees VALUES('3586','Elris','Ganiel Pasaribu','AE02963','','1202050202880003','84.318.445.8-222.000','','1988-02-02','Male','2','2','45','337','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3587','T.','Saiful Bahri','AE00868','','1405021206760007','','','1976-06-12','Male','2','2','45','340','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3588','Nofi','Sasmita','AE02915','','1471102211890041','00.000.000.0-000.000','','1989-11-22','Male','2','2','45','340','','2','1','','','0','0','0','2023-12-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3589','Kadim','Anggiat M Hutabarat','AE00176','','1405020811740004','90.769.871.6-222.000','','1974-11-08','Male','2','2','45','340','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3590','Kaab','Lubis','AE00661','','1308140910970002','53.499.836.4-222.000','','1997-10-09','Male','2','2','45','340','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3591','Frando','Nababan','AE99020','','1202121502030002','53.608.045.0-222.000','','2003-02-15','Male','2','2','45','340','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3592','Dodi','Hutapea','AE05053','','3172031104840009','93.960.205.8-222.000','','1984-04-11','Male','2','2','45','340','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3593','Ari','Kristianto S','AE02958','','1403091602950004','53.880.452.7-219.000','','1995-02-16','Male','2','2','45','340','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3594','Partomuan','Tampubolon','AE00880','','1405022310830005','86.371.075.2-222.000','','1983-10-23','Male','2','2','45','341','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3595','STEVEN','ANDRYANUS SINURAT','AE04312','','3604052309010002','','','2001-09-23','MALE','2','2','45','339','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3596','Sidokmauliate','Reynaldo Sinaga','AE02948','','1405022703960002','53.192.574.1-222.000','','1996-03-27','Male','2','2','45','340','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3597','ARIHTA','SUKOCO SEMBIRING','AE07751','','1275040708830004','','','1983-08-07','MALE','2','2','45','339','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3598','ABDUL','ROHIM','AE04964','','1408041106970001','50.328.849.0-222.000','','1997-06-11','MALE','2','2','56','420','','2','1','','','0','0','0','2022-09-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:57','2024-04-23 17:11:57');
INSERT INTO employees VALUES('3599','AMALI','ALMI PRATAMA','AE07240','','1405022104030006','','','2003-04-21','MALE','2','2','56','416','','2','1','','','0','0','0','2022-11-14','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3600','FAISAL','THOLIB','AE07258','','1607012505660001','35.228.963.1-314.000','','1966-05-25','MALE','2','2','56','418','','2','1','','','0','0','0','2022-11-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3601','Anggiat','Tampubolon','AE02753','','1405022310730003','57.267.463.8-222.000','','1973-10-23','Male','2','2','42','308','','2','1','','','0','0','0','2021-11-08','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3602','MUHAMMAD','PUTRA PRATAMA','AE02991','','1405021505020005','63.048.191.9-222.000','','2002-05-15','Male','2','2','42','313','','2','1','','','0','0','0','2022-02-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3603','Pantri','Manalu','AE00075','','1202110908830002','00.000.000.0-000.000','','1983-08-09','Male','2','2','42','314','','2','1','','','0','0','0','2019-12-15','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3604','HAFIDZ','APRIYANSYAH','AE03652','','1471051906990001','','','1999-06-19','MALE','2','2','38','259','','2','1','','','0','0','0','2022-05-23','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3605','Despi','Yunardi','AE00325','despi.yunardi@timas.com','2171101412819011','44.024.655.1-215.000','','1981-12-14','Male','2','2','55','409','','2','1','','','0','0','0','2020-01-18','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3606','RAVENZA','ZAKKY SAPUTRA','AE03868','','1307010904020002','65.959.347.9-204.000','','2002-04-09','MALE','2','2','55','413','','2','1','','','0','0','0','2022-06-08','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3607','Besron','Naibaho','AE00204','','1408041906760002','70.444.862.0-222.000','','1976-06-19','Male','2','2','42','315','','2','1','','','0','0','0','2020-01-06','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3608','Aidil','Raka','AE01059','aidil.raka@timas.com','1307021505940003','86.739.334.0-204.000','','1994-05-15','Male','2','2','40','285','','2','1','','','0','0','0','2021-08-16','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3609','Josua','Gultom','AE00184','','1408041502770010','70.445.116.0-222.000','','1977-02-15','Male','2','2','40','285','','2','1','','','0','0','0','2020-01-06','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3610','Grant','Samuel Samosir','AE00435','','1202152211970001','94.238.280.5-127.000','','1997-11-22','Male','2','2','25','264','','2','1','','','0','0','0','2021-08-05','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:58','2024-04-23 17:11:58');
INSERT INTO employees VALUES('3611','REZA','CAHYADI','AE03292','','1471072011960003','63.918.290.6-216.000','','1996-11-20','MALE','2','2','25','','','2','1','','','0','0','0','2022-04-01','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3612','VINERA','TASYA','AE04750','','1271195907990001','','','1999-07-19','FEMALE','2','2','83','362','','2','1','','','0','0','0','2022-08-23','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3613','AIDIL','FADILLAH','AE07242','','1373041002970003','04.515.482.0-203.000','','1997-02-10','MALE','2','2','83','370','','2','1','','','0','0','0','2022-11-11','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3614','AYU','SITI CHOTIJAH','AE03300','ayu.chotijah@timas.com','1405024505990006','63.902.198.9-222.000','','1999-05-05','FEMALE','2','2','83','362','','2','1','','','0','0','0','2022-04-05','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3615','BOBY','ARINATA PANJAITAN','AE07847','','1209210502910001','','','1991-02-05','MALE','2','2','50','378','','2','1','','','0','0','0','2023-12-26','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3616','AHMAD','ALDI MARPAUNG','AE07639','','1209201201020008','39.252.864.2-115.000','','2002-01-12','MALE','2','2','43','327','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3617','HABIBI','AMIN','AE03111','','1221011303980002','50.323.304.1-222.000','','1998-03-15','MALE','2','2','51','386','','2','1','','','0','0','0','2022-03-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3618','Jefri','Pernando Sitorus','AE00929','','1405022302900001','77.920.359.5-215.000','','1990-02-23','Male','2','2','51','391','','2','1','','','0','0','0','2023-12-28','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3619','Apfit','Putra Perdana','AE00901','','3316082604900001','86.638.753.3-514.000','','1990-04-26','Male','2','2','25','264','','2','1','','','0','0','0','2021-08-20','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3620','SANDHY','HARWADHY','AE03031','','3215252807810004','59.972.461.4-408.000','','1981-07-28','MALE','2','2','25','','','2','1','','','0','0','0','2022-02-07','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3621','Ahmad','','AE00105','','1405020606700006','74.028.587.9-222.000','','1970-06-06','Male','2','2','17','268','','2','1','','','0','0','0','2023-08-04','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3622','ADE','CANDRA','AE07849','','1302102903890003','84.182.340.4-203.000','','1989-03-29','MALE','2','2','53','398','','2','1','','','0','0','0','2023-12-27','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:11:59','2024-04-23 17:11:59');
INSERT INTO employees VALUES('3623','Bambang','Lestiono','AE99039','','1205150406940002','75.195.473.6-119.000','','1994-06-04','Male','2','2','45','337','','2','1','','','0','0','0','2023-07-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3624','INDRA','MURDANI','AE09353','','1205151410930003','','','1993-10-14','MALE','2','2','45','340','','2','1','','','0','0','0','2023-07-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3625','ROZIMAN','','AE09359','','1405020310910004','','','1991-10-03','MALE','2','2','45','340','','2','1','','','0','0','0','2023-07-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3626','ANGGI','RESTU PRASETYA','AE07853','','1506062006960001','','','1996-06-20','MALE','2','2','51','385','','2','1','','','0','0','0','2024-01-03','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3627','MARUDUT','B.U SITUMORANG','AE07854','','3175080508820010','','','1982-08-05','MALE','2','2','51','385','','2','1','','','0','0','0','2024-01-03','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3628','RIDWAN','FIRMAN RUMABUTAR','AE07855','','1202110904980002','99.775.295.1-222.000','','1998-04-09','MALE','2','2','51','385','','2','1','','','0','0','0','2024-01-03','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3629','RUDOLF','SILALAHI','AE07856','','3604110807740001','','','1974-06-08','MALE','2','2','51','385','','2','1','','','0','0','0','2024-01-03','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3630','YOGI','LOLENSA','AE07624','','1602051905980001','','','1998-12-16','MALE','2','2','51','386','','2','1','','','0','0','0','2024-01-03','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3631','ARDIANSYAH','','AE07858','','1506032105030003','','','2003-05-21','MALE','2','2','51','386','','2','1','','','0','0','0','2024-01-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3632','YUSTONI','MARIPUL PANDIANGAN','AE07859','','1271081301900004','','','1989-01-13','MALE','2','2','51','388','','2','1','','','0','0','0','2024-01-08','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3633','ABDUL','RAHMAN','AE07860','','6204062004980002','','','1998-07-18','MALE','2','2','45','340','','2','1','','','0','0','0','2024-01-03','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3634','HANDHIKA','HUTASOIT','AE07861','','1277032006040001','39.567.276.9-118.000','','2004-06-20','MALE','2','2','45','340','','2','1','','','0','0','0','2024-01-03','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3635','PALIT','TNJ','AE02992','','1213100703860002','94.395.638.3-118.000','','1986-03-07','Male','2','2','43','326','','2','1','','','0','0','0','2024-01-05','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:00','2024-04-23 17:12:00');
INSERT INTO employees VALUES('3636','AMUNG','SUNARYA','AE07864','','1408072706860001','','','1986-06-07','MALE','2','2','45','337','','2','1','','','0','0','0','2024-01-05','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3637','TANWIR','LUBIS','AE07865','','1203212209870006','','','1987-06-23','MALE','2','2','51','386','','2','1','','','0','0','0','2024-01-05','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3638','AIDIL','RIZKI','AE07866','','1408040802980001','','','1998-02-08','MALE','2','2','45','340','','2','1','','','0','0','0','2024-01-10','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3639','ZAMNURDIN','MA\'ARIF AL GHAFFAR','AE07867','','3526102904000006','','','2000-04-29','MALE','2','2','25','','','2','1','','','0','0','0','2024-01-06','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3640','NAPTALIS','PEDROY MALAU','AE07869','','1207330912910001','','','1991-12-09','MALE','2','2','53','399','','2','1','','','0','0','0','2024-01-12','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3641','HASIHOLAN','LUMBAN TOBING','AE03863','','1805272305790002','50.036.314.8-127.000','','1975-03-23','MALE','2','2','56','422','','2','1','','','0','0','0','2024-01-12','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3642','Arman','','AE02809','','1405020207760006','71.351.443.8-222.000','','1976-07-02','Male','2','2','45','337','','2','1','','','0','0','0','2024-01-12','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3643','EDI','SUMARDI','AE07872','','1271090708760009','','','1976-08-07','MALE','2','2','45','337','','2','1','','','0','0','0','2024-01-12','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3644','JONSON','MANGUNSONG','AE07676','','1102062307860003','91.719.316.1-222.000','','1986-07-23','MALE','2','2','43','326','','2','1','','','0','0','0','2024-01-18','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3645','WAWAN','SETYAWAN','AE07876','','1408070305880004','','','1988-05-03','MALE','2','2','45','337','','2','1','','','0','0','0','2024-01-17','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3646','JULHANUDDIN','SIMATUPANG','AE07877','','1220050303940001','','','1994-03-03','MALE','2','2','43','327','','2','1','','','0','0','0','2024-01-17','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:01','2024-04-23 17:12:01');
INSERT INTO employees VALUES('3647','YANRI','','AE07878','','1308120310870001','','','1987-01-03','MALE','2','2','43','330','','2','1','','','0','0','0','2024-01-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employees VALUES('3648','IHSAN','HABIB ANDIKA','AE07879','','1307022102050001','','','2005-02-21','MALE','2','2','56','416','','2','1','','','0','0','0','2024-01-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employees VALUES('3649','ALVINDRA','FEBRINO','AE09484','','1409012511040002','','','2004-11-25','MALE','2','2','100','405','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employees VALUES('3650','LUPIANTO','','AE00905','','1373012410760001','','','1976-10-24','Male','2','2','56','418','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employees VALUES('3651','ABENI','LASE','AE09511','','1224092311030001','','','2003-11-23','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employees VALUES('3652','MUHAMMAD','TAUPIK','AE03166','','1218090908000003','53.176.617.8-114.000','','2000-08-09','MALE','2','2','45','340','','2','1','','','0','0','0','2023-12-21','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employees VALUES('3653','GUSRIANSAH','','AE09432','','1205142008940001','','','1994-08-10','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employees VALUES('3654','ARNANDA','AFRIZA','AE09433','','1405022712970010','','','1997-12-27','MALE','2','2','','','','2','1','','','0','0','0','2023-09-08','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employees VALUES('3655','HERMON','','AE09522','','1405022612850004','','','1986-12-26','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:02','2024-04-23 17:12:02');
INSERT INTO employees VALUES('3656','ENCENG','','AE06448','','3206351001860002','','','1986-01-10','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employees VALUES('3657','INDRA','GUNAWAN','AE09397','','1207232209810011','','','1981-09-22','MALE','2','2','98','296','','2','1','','','0','0','0','2023-12-21','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employees VALUES('3658','RUHIYAT','','AE09035','','3206350101810010','62.408.530.4-425.000','','1981-01-01','MALE','2','2','','','','2','1','','','0','0','0','2023-12-21','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employees VALUES('3659','EVI','HANAFIAH','AE09101','','3206393001940001','','','1994-01-30','MALE','2','2','','','','2','1','','','0','0','0','2024-01-21','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employees VALUES('3660','Chandra','OP Sunggu','AE00603','','1406091504920005','76.863.332.3-222.000','','1992-04-15','Male','2','2','56','418','','2','1','','','0','0','0','2021-10-05','','','','K/2','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employees VALUES('3661','KISWAN','IBRAHIM SIREGAR','AE07398','','1221012711870001','41.296.331.6-118.000','','1987-11-27','MALE','2','2','96','324','','2','1','','','0','0','0','2024-01-17','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:03','2024-04-23 17:12:03');
INSERT INTO employees VALUES('3662','ANNAS','HABEAHAN','AE04365','','1201161404920001','60.188.170.9-222.000','','1992-04-14','MALE','2','2','45','340','','2','1','','','0','0','0','2024-01-17','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employees VALUES('3663','MARHASIL','SIGALINGGING','AE04525','','1216050808920001','','','1992-08-01','MALE','2','2','45','340','','2','1','','','0','0','0','2024-01-22','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employees VALUES('3664','THEO','RANGGA HEKSA','AE07881','','1674012910000003','','','2000-10-23','MALE','2','2','43','327','','2','1','','','0','0','0','2024-01-22','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employees VALUES('3665','MUHAMMAD','AFRIZAL TANJUNG','AE07882','','1408090512990001','50.770.593.7-222.000','','1999-12-05','MALE','2','2','83','','','2','1','','','0','0','0','2024-01-22','','','','K/1','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employees VALUES('3666','NIKE','WIRANTI','AE07883','','1671045808000010','','','2000-08-18','FEMALE','2','2','83','362','','2','1','','','0','0','0','2024-01-22','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employees VALUES('3667','FAIRUS','OKTOBRIZKY SIPAHUTAR','AE09472','','1202010510950001','','','1995-10-05','MALE','2','2','','','','2','1','','','0','0','0','2024-01-29','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:04','2024-04-23 17:12:04');
INSERT INTO employees VALUES('3668','LONI','AGUSTIN','AE07807','','1471107108950062','','','1995-08-31','FEMALE','2','2','83','362','','2','1','','','0','0','0','2023-09-04','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employees VALUES('3669','MUHAMMAD','INDRAJID A','AE07884','','7204073010990006','90.905.106.2-834.000','','1999-10-30','MALE','2','2','83','371','','2','1','','','0','0','0','2024-02-02','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employees VALUES('3670','WILMAR','OP.SUNGGU','AE07886','','3175093107040001','04.545.805.6-009.000','','2004-07-31','MALE','2','2','83','372','','2','1','','','0','0','0','2024-02-06','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employees VALUES('3671','ESTER','VIRGINIA SIHOMBING','AE07887','','1405024109000003','','','2000-09-01','FEMALE','2','2','47','353','','2','1','','','0','0','0','2024-03-01','','','','TK/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employees VALUES('3672','SURYADI','ARIPAN SEJUK','AE03999','','1104130701920001','58.129.017.8-222.000','','1992-01-07','MALE','2','2','40','294','','2','1','','','0','0','0','2022-06-18','','','','K/0','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employees VALUES('3673','Ahmad','Dirjan','AE00576','','1308142210780001','00.000.000.0-000.000','','1978-10-22','Male','2','2','45','337','','2','1','','','0','0','0','2021-11-27','','','','K/3','','','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:12:05','2024-04-23 17:12:05');
INSERT INTO employees VALUES('3674','ALDO','NATANIEL ','AA00295','aldo.nataniel@timas.com','3201242804830006','-','081315084746','1983-04-28','Male','3','3','69','36','','2','1','','','0','0','0','2022-08-01','','married','','K/2','Jl.Sukajaya8 No.53 Rt/Rw 002/005 Kel.Tajur Kec.Kota Bogor Timur','Bogor','Jawa Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3675','HERI ','IRAWAN ','AB00003','heri.irawan@timas.com','3604160406880002','35.997.458.1-401.000','081385768634','1988-06-04','Male','3','3','29','','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Perum Puri Teratai Blok G-06/01 Rt/Rw 004/003 Kel.Situ Teratai Kec.Cikande','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3676','RADEN FRANS ','HIDAYAT ','AB00007','franhidayat994@gmail.com','3604162202880001','46.104.935.5-401.000','085959187871','1988-02-22','Male','3','3','29','','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Kp Warung Salikur Rt/Rw 003/001. Ds. Sukamaju. Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3677','YENITA','','AB00008','yenitazby@gmail.com','3601244403940005','66.615.614.6-419.000','082117981448','1994-03-04','Female','3','3','29','40','','2','1','','','0','0','0','2015-05-25','','single','','TK/0','Kp.Taman Rt/Rw 002/005 Ds.Pasir Gadung Kec.Patia','Pandeglang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3678','SARWAT ','','AB00009','Sarwat aja43@gmail.com','3604160502730004','79.408.694.2-401.000','082312953978','1973-02-05','Male','3','3','29','41','','2','1','','','0','0','0','2019-06-01','','married','','K/3','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3679','AMINULLOH','','AB00011','aminullohhifza@gmail.com','3604160904890001','68.068.508.8-401.000','081911291115','1989-04-09','Male','3','3','29','42','','2','1','','','0','0','0','2018-01-24','','married','','K/2','Kp.Ciwajik Rt/Rw 002/002 Ds.Kibin Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3680','IJAH','HADIJAH','AB00012','ijahadijah269@gmail.com','3604256206810001','79.408.663.7-401.000','081282911305','1981-06-22','Female','3','3','29','','','2','1','','','0','0','0','2019-06-01','','single','','TK/0','Kp.Rangkas Rt/Rw.002/001 Ds. Nyompok Kec. Kopo','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3681','KASIM','','AB00014','kasimalbantani01@gmail.com ','3604161204000001','91.600.712.3-454.000','081385348526','2001-01-22','Male','3','3','29','44','','2','1','','','0','0','0','2021-11-20','','single','','TK/0','Kp.Ciwajik Rt/Rw 002/002 Ds.Kibin Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3682','JAKA ','','AB00015','Jaka362514@gmail.com','3604160102920006','61.715.585.4-454.000','089651594719','1992-02-01','Male','3','3','29','41','','2','1','','','0','0','0','2022-06-15','','married','','K/1','Kp.Pasir Tegal Rt/Rw 007/002 Ds.Ketos Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3683','AHMAD ','YANI','AB00016','tama223tama@gmail.com','3604182411920001','98.169.848.3-401.000','088213714381','1992-11-24','Male','3','3','29','45','','2','1','','','0','0','0','2022-09-19','','married','','K/1','Kp. Kibin Rt/Rw 014/005 Kel/Ds. Gembor Kec. Binuang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3684','ASWANI','','AB00017','Aswanitambak@gmail.com','3604161010850004','75.435.887.7-401.300','081398144345','1989-10-10','Male','3','3','29','46','','2','1','','','0','0','0','2022-09-21','','married','','K/3','Kp. Palembangan Rt/Rw 006/005 Kel/Ds. Dukuh Kec. Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3685','WAWAN','','AB00160','wkang3446@gmail.com','3604161209790002','0','085219877292','1979-09-12','Male','3','3','29','41','','2','1','','','0','0','0','2023-04-05','','married','','K/3','Kp.Tambak Pasir Rt/Rw 002/001 Ds.Tambak Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:10','2024-04-23 17:15:10');
INSERT INTO employees VALUES('3686','FIRLIADI ','AL HAPSI ','AB00176','0','1609120107020062','53.865.814.7-454.000','083813123640','2002-07-01','Male','3','3','29','44','','2','1','','','0','0','0','2023-07-05','','single','','TK/0','Kp.Pasir Sembung Rt/Rw 018/005 Ds.Gembor Kec.Binuang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3687','SITI RATNA','AINUN','AB00018','ratna@timas.com','3275015805890020','69.783.756.5-407.000','08128602800','1989-05-18','Female','3','3','30','37','','2','1','','','0','0','0','2010-10-24','','single','','TK/0','Griya Asri Cluster Bintaro Blok D-11/12 Rt/Rw 006/008 Ds.Cikande Kec.Cikande','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3688','ANTON ','FRANS','AB00001','anton.frans@timas.com','3273080308750002','78.819.869.5-423.000','08121205315','1975-08-03','Male','3','3','31','','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Jl.Bukit Jarian Dlm No.29/166-D Rt/Rw 005/011 Ds.Hegarmanah Kec.Cidadap','Bandung','Jawa Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3689','SUGINO','','AB00019','sugino@timas.com','3604301407620003','78.387.172.401.000','082110895855','1970-07-14','Male','3','3','31','','','2','1','','','0','0','0','2016-09-09','','married','','K/3','Kp.Kamurang Rt/Rw 004/001 Ds.Kosambironyok Kec.Anyar','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3690','NANANG ','NASRUR','AB00020','nanang@timas.com','1812022607820001','79.408.674.4-321.000','081289244442','1982-07-27','Male','3','3','31','97','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Kp.Kadingding 008/002 Ds.Tambak Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3691','ETHANA HARITS',' BRYANO','AB00021','harits.bryano@timas.com','3578050203940002','74.160.271.8-607.000','081285964246','1994-03-02','Male','3','3','31','98','','2','1','','','0','0','0','2019-06-01','','married','','K/0','Jl. KH.M Kholil GM-2 Rt/Rw 084/009 Kel.Tropodo Kec.Waru','Sidoarjo','Jawa Timur','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3692','HERRY ','SURYONO','AB00023','herry.suryono34@gmail.com','3672081809770002','87.858.391.3-417.000','081288195056','1977-09-18','Male','3','3','31','','','2','1','','','0','0','0','2020-03-21','','married','','K/2','Link. Kubang Welut Rt/Rw 002/004 Ds.Samangraya Kec.Citangkil','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3693','SUHEL ','','AB00024','Suhel.binanusantara68@gmail.com','3604081906680001','81.884.489.6-401.000','085218729994','1968-06-19','Male','3','3','31','100','','2','1','','','0','0','0','2020-07-06','','married','','K/2','Kp.Sumur Wuluh Rt/Rw 008/003 Ds.Margasari Kec.Pulo Ampel','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3694','ANDRI',' KURNIAWAN','AB00025','andri.kurniawan@timas.com','2171120505879018','76.285.498.2-225.000','082122231380','1987-05-05','Male','3','3','31','101','','2','1','','','0','0','0','2021-08-03','','married','','K/1','Jl.Petojo Enclek 3 No.11 Rt/Rw 012/007 Ds.Petojo Selatan Kec.Gambir','Jakarta','DKI Jakarta','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3695','MUHAMAD IRFAN ','AL AMIN','AB00189','muhamad.irfan@timas.com','3672081202950003','41.580.033.3-417.000','087771325958','1995-02-12','Male','3','3','31','102','','2','1','','','0','0','0','2023-09-06','','single','','TK/0','Link.Kapudenok Masjid Rt/Rw 001/001 Ds.Lebak Denok Kec.Citangkil','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3696','RIZKI ','RAMADHONA.W','AB00197','rizkiramadhona@yahoo.com','3172022605870002','09.572.981.0-042.000','081284939394','1987-05-26','Male','3','3','31','103','','2','1','','','0','0','0','2023-10-09','','married','','K/1','Jl.Lurus GG.1 No.47 Rt/Rw 007/006 Ds.Kebon Bawang Kec.Tanjung Priok','Jakarta','DKI Jakarta','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3697','TEGUH HADI ','PRATAMA','AB00204','teguharsy@gmail.com','3604041902910163','80.282.186.8-401000','\'08987521618','1991-02-19','Male','3','3','31','103','','2','1','','','0','0','0','2023-11-24','','married','','K/2','Perumahan Samaji Asri Blok E No.1 Rt/Rw 001/010 Ds.Sepang Kec.Taktakan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:11','2024-04-23 17:15:11');
INSERT INTO employees VALUES('3698','HAERUL ','ANWAR','AB00206','haerul2009@gmail.com','3601300701850007','83.082.016.3-401.000','085697027549','1981-05-24','Male','3','3','31','100','','2','1','','','0','0','0','2024-01-24','','married','','K/3','Perum Puri Teratai Blok G 3 / 18 Rt/Rw 004/003 Ds.Situterate Kec.Cikande','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3699','AZHARI','','AB00212','azhari9697@gmail.com','3604171608970003','94.979.943.1-454.000','082246796048','1997-08-16','Male','3','3','31','102','','2','1','','','0','0','0','2024-04-15','','single','','TK/0','Kp. Kastana agung Rt/RW 018/001 Ds. Walikukun Kec. Carenang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3700','JEFRI ','SILALAHI','AB00002','jefri.silalahi@timas.com','3604072709750003','09.173.720.5-401.000','082178680320','1975-09-27','Male','3','3','32','60','','2','1','','','0','0','0','2020-08-21','','married','','K/3','Jl.Sultan Syarif Qasim Rt/Rw 010/007 Ds.Perawang Barat Kec.Tualang','Siak','Riau','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3701','MOH ','HASYIM','AB00030','moh.hasyim@timas.com','3318020509850001','79.408.826.0-507.000','082312027157','1985-09-05','Male','3','3','32','61','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Talun Rt/Rw 004/003 Ds.Talun Kec.Kayen','Pati','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3702','ALFI  ','SYAHRIMADONA','AB00031','alfi.syahrimadona@timas.com','3301230204910001','82.959.192.4-522.000','081227235553','1991-04-02','Male','3','3','32','61','','2','1','','','0','0','0','2017-10-09','','married','','K/1','Jl.Setia Budi No.12 Rt.Rw 001/004 Ds.Kebonmanis Kec.Cilacap Utara','Cilacap','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3703','MARYONO','','AB00033','maryono@timas.com','3604102910750076','79.408.715.5-401.000','081398051559','1975-10-29','Male','3','3','32','62','','2','1','','','0','0','0','2019-06-01','','married','','K/3','Puri Citra Blok D4 No.05 Rt/Rw 024/006 Pipitan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3704','AHMAD ','HABIBI','AB00034','ahmad.habibi@timas.com','3604062707790003','57.616.769.6-401.000','087876874679','1979-07-27','Male','3','3','32','61','','2','1','','','0','0','0','2022-08-30','','married','','K/3','Lebak indah Blok C4 No.16 RT005 RW007 Ds. Lebakwana Kec. Kramatwatu','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3705','RIFQI ','DHAIFULLAH','AB00198','rifqi.dhaifullah@timas.com','3604091810980001','39.315.926.4-454.000','085960618570','1998-10-18','Male','3','3','32','61','','2','1','','','0','0','0','2023-10-18','','single','','TK/0','TCP Blok G.8 No.38 Rt/Rw 003/005 Ds.Pelawad Kec.Ciruas','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3706','FAIZAL BAGUS ','PRIATMOJO','AB00205','faizal.priatmojo@timas.com','36041102039700008','40.981.945.5-454.000','081382969676','1997-06-02','Male','3','3','32','63','','2','1','','','0','0','0','2023-12-12','','single','','TK/0','Cisait Puri Pratama Blok A 4C No.8 Rt/Rw 001/005 Ds.Cisait Kec.Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3707','MOH. ARIFIN','RUMAJI','AB00004','arifin.rumaji@timas.com','3604100307680087','79.408.708.0-401.000','081311014239','1968-07-03','Male','3','3','68','34','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Puri Citra Blok C3 No.2 Rt/Rw 023/006 Ds.Pipitan Kec.Walantaka','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3708','WAHYU ','BUDIANTO','AB00036','wahyu.budianto@timas.com','3604053110700001','79.408.683.5-401.000','089697438880','1970-10-31','Male','3','3','68','35','','2','1','','','0','0','0','2019-06-01','','married','','K/1','Komp.GSI Blok B.21 No.2 Rt/Rw 003/004. Margatani. Kramatwatu','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3709','IWAN ','SISWANDI','AB00005','iwan.siswandi@timas.com','3601342003740004','34.580.773.9-419.000','087808291233','1975-03-08','Male','3','3','34','47','','2','1','','','0','0','0','2019-06-01','','married','','K/3','Perum.Kampoeng Raya Residence Blok C. No.2 Rt/Rw 004/023 Kel.Serang Kec.Serang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3710','VIVIT ERI ','HIDAYAT ','AB00037','vivit.eri@timas.com','3172032110831001','66.954.169.0-045.000','085718080847','1983-10-21','Male','3','3','34','','','2','1','','','0','0','0','2016-10-10','','married','','K/2','Komp.Uka Blok H no.33 Rt/Rw 001/008 Tugu Utara Kec.Koja','Jakarta Utara','DKI Jakarta','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:12','2024-04-23 17:15:12');
INSERT INTO employees VALUES('3711','ANDRI PUJI','SETIAWAN','AB00038','Andripujiset@gmail.com','3604051510970004','93.942.954.4-454.000','081285858716','1997-10-15','Male','3','3','34','','','2','1','','','0','0','0','2022-10-18','','single','','TK/0','Bukit Pelamunan Permai Blok A7/12 Rt/Rw 010/003 Kel.Pelamunan Kec.Kramatwatu','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3712','JAYA','HERYANA','AB00042','jay891143@gmail.com','3604112605760003','70.668.437.0-401.000','083877606993','1976-05-26','Male','3','3','34','49','','2','1','','','0','0','0','2014-07-15','','married','','K/2','Kp. Pabuaran Rt/Rw 007/004 Ds. Sentul Kec. Kragilan Serang-Banten','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3713','UMAR ','SUMARDI','AB00044','tohaf21@gmail.com','3604161002770006','79.408.703.1-401.000','081389238664','1977-02-10','Male','3','3','34','49','','2','1','','','0','0','0','2019-06-01','','married','','K/1','Kp. Panembong curug Rt/Rw 003/002 Nambo Ilir. Kab. Kibin','Serang','Banten','100','42185','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3714','RUDI',' HARTONO','AB00147','rudipaster242@gmail.com','3604111406780002','59.670.123.5-401.000','081310193667','1978-06-14','Male','3','3','34','49','','2','1','','','0','0','0','2023-02-01','','married','','K/2','BCP 2 Blok E 28 No.23 Rt/Rw 030/005 Ds.Ranjeng Kec.Ciruas','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3715','TARMIDI','','AB00043','tarmidileo160@gmail.com','3604171012700001','79.408.701.5-401.000','087788085051','1970-12-10','Male','3','3','34','50','','2','1','','','0','0','0','2019-06-01','','married','','K/3','Kp. Pasir Laban Rt/Rw 003/005 Teras. Carenang','Serang','Banten','100','42195','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3716','NANA ','SUCIATNA','AB00045','sigabjalakrawi@gmail.com','3604250710750005','45.191.563.1-401.000','087886095475','1975-10-07','Male','3','3','34','50','','2','1','','','0','0','0','2011-08-22','','married','','K/2','Perum Pesona Alam Kragilan Rt/Rw 011/002 D. Pematang Kec. Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3717','SUROTO','','AB00046','12suroto44@gmail,com','3603322401770001','70.239.486.7-401.000','085930285855','1977-01-24','Male','3','3','34','50','','2','1','','','0','0','0','2013-02-27','','married','','K/2','Kp.Cipaeh Sambidoyong Rt/rw 002/002 Onyam. Gunung Kaler','Tangerang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3718','ISMATULLAH ','','AB00047','Imatalvaro822@gmail com','3673032209840001','98.046.946.4-401.000','083848584016','1984-09-22','Male','3','3','34','50','','2','1','','','0','0','0','2021-07-01','','married','','K/1','Kp.Ampel Rt/Rw 002/001 Ds.Pangampelan Kec.Walantaka','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3719','MUHAMMAD ','PAHLEFI ','AB00048','muhammadpahlefi648@gmail.com','3604170204950004','86.427.276.0-454.000','082310436085','1995-04-02','Male','3','3','34','50','','2','1','','','0','0','0','2021-10-22','','single','','TK/0','Kp.Kasepatan Kompa Rt/Rw 006/004 Ds.Teras Kec.Carenang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3720','ENDANG ','SAPUTRA','AB00155','saputraendang020@gmail.com','3604160308870003','57.194.343.0-401.000','085717635769','1987-08-03','Male','3','3','34','50','','2','1','','','0','0','0','2023-02-21','','married','','K/2','Kp.Tambak Baru Rt/Rw 001/001 Ds.Kibin Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3721','DARWIN','SILALAHI','AB00187','0','1209080107940023','39.878.514.7-454.000','081282099356','1993-04-15','Male','3','3','34','50','','2','1','','','0','0','0','2023-08-16','','married','','K/1','Perum Banten Metro Polis Residence Blok E.4 No.24 Rt/Rw 024/005 Ds.Nagara Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3722','IRFAN DWI ','PUTRA','AB00213','lanangsejagat547@gmail.com','3604171404980001','81.893.427.5-401.000','081382733401','1998-04-14','Male','3','3','34','50','','2','1','','','0','0','0','2024-04-06','','married','','K/1','Kp. Endol Rt/Rw 015/004 Ds. Lempuyang Kec. Tanara','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:13','2024-04-23 17:15:13');
INSERT INTO employees VALUES('3723','SUEL ','SULAEMAN','AB00214','hafsahsumaelam@gmail.com','3604161509920002','80.325.026.5-401.000','081284136219','1992-09-19','Male','3','3','34','50','','2','1','','','0','0','0','2024-04-06','','married','','K/1','Kp. Golok masjid Rt/Rw 012/004 Ds. Kampung baru Kec. Pamarayan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3724','SAENIN','','AB00006','saenin@timas.com','3604111010690001','79.408.713.0-401.000','085284371675','1969-10-10','Male','3','3','35','64','','2','1','','','0','0','0','2019-06-01','','married','','K/3','Komp Ciujung Damai Blok C.42 No.1 Rt/Rw 006/007 Kendayakan Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3725','NOR ','SAID','AB00049','nursaidikram@gmail.com','3604091207760005','79.408.711.4-401.000','085219428892','1976-07-12','Male','3','3','35','14','','2','1','','','0','0','0','2019-06-01','','married','','K/3','BCP Vlok C 5 No.09 Rt/Rw 025/004 Ds.Ranjeng Kec.Ciruas','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3726','DWI ','YUNIAR','AB00162','0','1671074106930011','82.292.069.0-307.000','087801061993','1993-06-01','Female','3','3','35','66','','2','1','','','0','0','0','2023-03-30','','single','','TK/0','Jl.Tri Sukses No.2322 Rt/Rw 041/012 Ds.Srijaya Kec.Alang-alang Lebar','Palembang','Sumatera Selatan','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3727','RINTO ','SAMOSIR','AB00051','samosir.rinto68@gmail.com','3604163004840001','79.408.830.2.117.000','081280512987','1984-04-30','Male','3','3','35','67','','2','1','','','0','0','0','2019-06-01','','married','','K/3','Griya Asri Bintaro Blok D-10/14 Rt/Rw 006/008 Ds.Cikande Kec.Cikande','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3728','GENTHA OMAR PANJI ','WIJAYA','AB00052','genthapanji@gmail.com','3306072810900002','79.408.840.1-531.000','081291231530','1990-10-28','Male','3','3','35','67','','2','1','','','0','0','0','2018-08-01','','married','','K/2','Puri Teratai Blok G-01/34 Rt/Rw 004/003 Ds.Situ Terate Kec.Cikande','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3729','YUSUP ','RAMDHANI','AB00053','yusuframdani21@gmail.com','3604091407820007','79.408.760.1-401.000','081314162709','1982-07-14','Male','3','3','35','68','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Grand Mutiara Residance Rt/Rw 003/004 Ds.Kiara Kec.Walantaka','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3730','SUYADI','','AB00054','suyadiadi406@gmail.com','3604071802750002','63.269.402.2-417.000','08988665264','1975-02-18','Male','3','3','35','','','2','1','','','0','0','0','2021-09-24','','married','','K/3','Kp.Wadasari Rt/Rw 010/004 Ds.Karangkepuh Kec.Bojonegara','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3731','REZA DIAN  ','PERMANA','AB00055','rezarazzor130191@gmail.com','3672081301970002','85.173.622.3-417.000','087778482858','1991-01-13','Male','3','3','35','68','','2','1','','','0','0','0','2021-10-01','','married','','K/2','Link.Seneja Rt/Rw 002/001 Ds.Sukamaja Kec.Jombang','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3732','MUHLIS DONDI ','MIHARDI ','AB00056','muhlisdm69@gmail.com','3672052006820001','83.222.495.0-417.000','081268345411','1982-06-20','Male','3','3','35','68','','2','1','','','0','0','0','2022-05-09','','married','','K/2','Link Kenanga Rt/Rw 005/004 Ds.Masigit Kec.Jombang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3733','SANEN','','AB00057','sanen205@gmail.com','3604151012890002','98.046.880.5-401.000','082312182233','1989-12-10','Male','3','3','35','68','','2','1','','','0','0','0','2022-05-09','','married','','K/3','Kp.Sukamaju Rt/Rw 003/003 Ds.Nambo Udik Kec.Cikande','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3734','AZIZ ','AMIRUDIN','AB00058','azizamir844@gmail.com','3318020704930002','72.626.220.7-507.000','082312727937','1993-04-07','Male','3','3','35','','','2','1','','','0','0','0','2022-05-09','','married','','K/1','Kp.Legoknangka Rt/Rw 002/002 Ds.Sodong Kec.Saketi','Pandeglang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3735','INGGA ','MULYANA ','AB00059','Inggamulyana24@gmail.com','3301212406970002','76.913.587.2-522.000','085712610091','1997-06-24','Male','3','3','35','68','','2','1','','','0','0','0','2022-05-12','','married','','K/1','Jl.Kendeng No.64 Rt/Rw 005/014 Ds.Sidanegara Kec.Cilacap Tengah Cilacap - Jawa Tengah','Cilacap','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:14','2024-04-23 17:15:14');
INSERT INTO employees VALUES('3736','ERIK ','YULIADI','AB00062','yuliadierik@gmail.com ','3604152907780001','79.408.766.8-425.000','081281143405','1978-07-29','Male','3','3','35','69','','2','1','','','0','0','0','2022-05-09','','married','','K/2','Griya Asri Cluster Cendana Blok B.9/11 Rt/Rw 005/008 Ds.Cikande Kec.Cikande Serang-Banten','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3737','ANGGARA ','SAPUTRA','AB00063','anggarasaputra8227@gmail.com ','1572011807960002','76.763.799.4-401.000','081271442155','1996-07-05','Male','3','3','35','','','2','1','','','0','0','0','2022-05-09','','married','','K/1','Wonorejo III Rt/Rw 001/008 Ds.Pesawaran Indah Kec.Way Ratai Pesawaran - Lampung','Lampung','Sumatera Selatan','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3738','JHON ALBERT ','ARITONANG','AB00064','eliskaaritonang78@gmail.com','3604030808690003','62.685.109.1-401.000','081297238758','1969-08-08','Male','3','3','35','','','2','1','','','0','0','0','2022-09-02','','married','','K/3','Taman Angsoka Permai Rt/Rw 003/008 Ds.Kasemen Kec.Kasemen','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3739','BAMBANG','IRAWAN','AB00065','Bambangibenkibenk.gmail.com','3672082508880001','85.262.492.3-417.000','057808546949','1988-08-25','Male','3','3','35','68','','2','1','','','0','0','0','2022-09-12','','married','','K/3','Link.Delingseng Rt/Rw 001/001 Ds.Kebonsari Kec.Citangkil','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3740','DEDI ','RASDIANTO','AB00066','dedisuhar@gmail.com','3672050907760001','92.793.358.0-417.000','082115136397','1979-03-13','Male','3','3','35','68','','2','1','','','0','0','0','2022-09-12','','married','','K/3','Link.Leuweung Sawo Blok Bango Rt/Rw 004/009 Kel.Kotabumi Kec.Purwakarta','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3741','SASTRO WIJOYO ','BUTAR BUTAR','AB00067','sastrowijoyo174@gmail.com','3672082503840008','67.699.932.9-417.000','081388977156','1984-03-25','Male','3','3','35','69','','2','1','','','0','0','0','2022-10-06','','married','','K/3','Komp.TWI FWA 172 No.04 Rt/Rw 005/007 Kel.Warnasari Kec.Citangkil','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3742','SUHERI ','BIN IWAN','AB00171','0','3603121904810007','71.343.984.2-418.000','08311465229','1981-04-19','Male','3','3','35','68','','2','1','','','0','0','0','2023-06-07','','married','','K/2','Jl.Cempaka VI Blok HL.16 Bumi Indah Rt/Rw 004/008 Kel.Sukamantri Kec.Pasar Kemis','Tangerang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3743','SUANDI','','AB00166','0','3604171005860002','80.932.594.7-401.000','085693396879','1986-05-10','Male','3','3','35','68','','2','1','','','0','0','0','2023-06-07','','married','','K/3','Kp.Mandaya Rt/Rw 007/002 Ds.Panenjoan Kec.Carenang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3744','SUNDA','','AB00170','0','3604260709880002','80.859.345.3-401.000','081285804910','1988-09-07','Male','3','3','35','68','','2','1','','','0','0','0','2023-06-08','','married','','K/3','Kp.Koang Rt/Rw 022/004 Ds.Pangawinan Kec.Bandung','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3745','MOCHAMAD ','HAERONI ','AB00069','muhroni507@gmail.com','3604191602850002','70.239.336.4-401.000','085312974597','1985-02-16','Male','3','3','35','71','','2','1','','','0','0','0','2021-09-15','','single','','TK/0','Kp.Cilame Rt/Rw 001/003 Ds.Tambiluk Kec.Petir','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3746','SUPARMAN ','','AB00070','suparmanjon123@gmail.com','3604162007770003','70.233.170.3-401.000','045217991932','1977-07-20','Male','3','3','35','71','','2','1','','','0','0','0','2021-11-12','','married','','K/2','Kp.Gorda Asem Rt/Rw 001/003 Kel.Nambo Ilir Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3747','OSBIN ',' MALAU','AB00071','pudanrevan@gmail.com','3604151307860002','53.858.718.9-454.000','081294751486','1986-07-13','Male','3','3','35','71','','2','1','','','0','0','0','2022-10-05','','married','','K/2','Perum Cikande Permai Blok N.8 No.16 Rt/Rw 001/004 Ds.Cikande Permai Kec.Cikande','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:15','2024-04-23 17:15:15');
INSERT INTO employees VALUES('3748','YULIANTO','','AB00072','juliantoarepac@gmail.com','3501111607860005','79.408.793.2-045.000','081288713060','1986-07-16','Male','3','3','35','72','','2','1','','','0','0','0','2017-06-07','','married','','K/2','Nglembu Rt/Rw 004/007 Ds Pagerejo Kec Ngadirojo Pacitan Jawa timur','Pacitan','Jawa Timur','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3749','MAMAT','','AB00073','widyainayah30@gmail.com','3604091111700001','79.408.729.6-401.000','085228044525','1970-11-11','Male','3','3','35','','','2','1','','','0','0','0','2019-06-01','','married','','K/2','TCP Vlok K.3 No.10 Rt/Rw 003/004 Kel.Pelawad Kec.Ciruas','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3750','ERWAN','','AB00074','erwanerwan752@gmail.com','3604091309670002','79.408.744.5-401.000','085216368976','1967-09-13','Male','3','3','35','','','2','1','','','0','0','0','2019-06-01','','married','','K/3','BCP Blok C5 No.13 Rt/Rw 025/004 Ds.Ranjeng Kec.Ciruas','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3751','MATSAPIK ','','AB00075','matsapikm@gmail.com','3673031508800005','79.408.745.2.507.000','081210084545','1980-08-15','Male','3','3','35','75','','2','1','','','0','0','0','2021-06-19','','married','','K/2','DK Glempang Rt/Rw 005/002 Ds.Adisana Kec.Bumiayu','Brebes','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3752','WIGIHARDI ','','AB00076','wigihardi76@gmail.com','3604160204760012','79.408.812.0-426.000','081316820811','1976-04-02','Male','3','3','35','76','','2','1','','','0','0','0','2021-07-12','','married','','K/2','Glonggong Rt/Rw 001/002 Ds.Glonggong Kec.Jakenan','Pati','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3753','SOLEMAN ','','AB00077','Solesoleman257@gmail.com ','3602281004970001','83.913.929.2-418.000','085691866423','1998-08-09','Male','3','3','35','77','','2','1','','','0','0','0','2021-07-17','','single','','TK/0','Kp.Leuwi Urug Rt/Rw 011/003 Ds.Peucangpari Kec.Cigemblong','Lebak','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3754','AKYADI ','BIN RIPAN ','AB00078','yadidi87@gmail.com','3603072504840004','74.349.330.6-451.000','088214759053','1984-04-25','Male','3','3','35','','','2','1','','','0','0','0','2021-08-20','','married','','K/2','Kp.Pagenjahan Rt/Rw 001/003 Ds.Pagenjahan Kec.Kronjo','Tangerang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3755','DUDI ','ROHMAN ','AB00079','do3dy.88@gmail.com','3601260410880001','67.263.299.9-419.000','085773412324','1988-10-04','Male','3','3','35','76','','2','1','','','0','0','0','2021-09-02','','married','','K/1','Kp.Sukagalih Rt/Rw 003/004 Ds.Karyasari Kec.Cikedal','Pandeglang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3756','SUPARNO ','','AB00080','suparno01245678@gmail.com','3314111203730008','68.996.949.1-528.000','082142522143','1973-03-12','Male','3','3','35','76','','2','1','','','0','0','0','2021-09-04','','married','','K/3','Ngepos Rt/Rw 002/009 Ds.Jetak Kec.Sidoharjo','Sragen','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3757','SAEPUDIN','','AB00081','saepudinpudin837@gmail.com','3604261506890002','62.834.548.0.454.000','081316935415','1989-06-15','Male','3','3','35','77','','2','1','','','0','0','0','2021-12-02','','married','','K/2','Kp.Harendong Lembur Rt/Rw 010/003 Ds.Jawilan Kec.Jawilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3758','YUSUF ADE  ','SUPRIATNA','AB00082','Yusufadesupriatna123gmail.com','3672021202780004','98.375.779.0-417.000','087871466946','1978-02-12','Male','3','3','35','75','','2','1','','','0','0','0','2021-12-18','','married','','K/3','Link.Ciwedus Rt/Rw 003/002 Ds.Ciwedus Kec.Cilegon','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3759','SAEPULOH','','AB00083','Saepuls315@gmail.com','3201171204870011','68.274.180.6-434.000','085782972766','1987-04-12','Male','3','3','35','76','','2','1','','','0','0','0','2021-12-21','','married','','K/2','Kp.Pabuaran Rt/Rw 002/003 Ds.Gunung Bunder I Kec.Pamijahan','Bogor','Jawa Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:16','2024-04-23 17:15:16');
INSERT INTO employees VALUES('3760','PARYONO ','','AB00092','Yonoparyono02@gmail.com','3604111902870002','69.783.741.7-307.000','085313652724','1987-02-19','Male','3','3','35','79','','2','1','','','0','0','0','2021-07-01','','married','','K/0','Perum Graha Cisait Blok B2 No.02 Ds.Cisait Kec.Gragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3761','JAYAT ','SENO','AB00181','0','3310141308800001','68.996.951.7-401.000','085210502612','1987-02-19','Male','3','3','35','76','','2','1','','','0','0','0','2024-03-25','','married','','K/2','Durenan Rt/Rw 002/003 Kel/Ds. Trasan Kec. Juwiring','Klaten','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3762','NURAKHMAN','','AB00084','nu_achman@yahoo.com','3604161405720001','79.408.720.5-401.000','081310748372','1972-05-14','Male','3','3','35','80','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Kp.Maja Rt/Rw 002/004 Ds.Kibin Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3763','PURWANTO','','AB00085','purwanto321969@gmail.com','3604110302690001','79.408.732.0-401.000','085217374535','1969-02-03','Male','3','3','35','80','','2','1','','','0','0','0','2019-06-01','','married','','K/3','Perum Ciujung Damai C40 No.12. Rt/Rw 007/002 Ds.Kendayakan Kec.Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3764','M MUSA ','EFENDI','AB00086','mmusaefendi@gmail.com','3604161606750001','79.408.719.7-401.000','081399092269','1975-06-16','Male','3','3','35','79','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Kp.Citawa Rt/Rw 003/003 Ds.Kibin Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3765','AGUS ','SOFYAN','AB00087','agaysofyan21@gmail.com','3604162108780002','79.408.805.4-401.000','081387866051','1978-08-21','Male','3','3','35','79','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Perum Puri Tambak Gemilang Blk B3 No.4 Rt/Rw 15/3 Ds.Ciagel Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3766','SUKARDI','','AB00088','SSUKARDI135@GMAIL.COM','3604161202680002','79.408.728.7-321.000','081297238970','1968-02-12','Male','3','3','35','79','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Perm.Banten Metropolis Residence Blok A.14 No.0 Rt/Rw 023/005 Ds.Nagara Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3767','SUYATO','','AB00089','suyatoondel41317@gmail.com','3312200907690001','79.408.741.1-401-000','082210476846','1969-07-09','Male','3','3','35','79','','2','1','','','0','0','0','2019-06-01','','married','','K/1','Dusun Jegoh Rt/Rw 03/04 Ds.Rejosari Kec.Jatisrana','Wonogiri','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3768','ELI ','HERMANSYAH','AB00090','elihermansyahhermansyah@gmail.com','3212232211790002','76.279.294.3-437.000','087775845142','1979-11-22','Male','3','3','35','79','','2','1','','','0','0','0','2021-06-17','','married','','K/1','Dusun Bedeng Satu Rt/Rw 010/002 Ds. Bugis Tua Kec.Anjatan','Indramayu','Jawa Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3769','RIKI ','PURWANTO','AB00091','rikipurwanto46890@gmail.com','1403091909810002','74.691.322.7-219.000','081268966927','1981-09-19','Male','3','3','35','79','','2','1','','','0','0','0','2021-06-19','','married','','K/2','Jl.KH.Ahmad Dahlan GG Syuhada Rt/Rw 003/007 Ds.Balik alam Kec.Mandau','Bengkalis','Riau','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3770','IDDRISNO ','NAIBAHO ','AB00093','idrisnaibaho88@gmail.com','3604091906880004','95.601.075.5-454.000','0813857920052','1988-06-19','Male','3','3','35','79','','2','1','','','0','0','0','2021-11-17','','single','','TK/0','TCP Blok G-3 No.4 Rt/Rw 001/005 Ds.Pelawad Kec.Ciruas','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3771','RAHIMUDIN','','AB00094','rahimudin7788@gmail.com','3604092506770002','93.766.967.9-454.000','081278188622','1977-06-25','Male','3','3','35','79','','2','1','','','0','0','0','2021-11-17','','married','','K/2','Kp.Kebon Ratu Rt/Rw 008/004 Ds.Kebon Ratu Kec.Ciruas','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3772','JUNAIDI','','AB00095','Junaidicase@gmail.com','3604321606840001','53.760.395.3-454.000','081906274160','1984-06-16','Male','3','3','35','79','','2','1','','','0','0','0','2022-01-05','','married','','K/2','Kp.Kosambilandak Rt/Rw 010/002 Ds.Batukuda Kec.Mancak','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:17','2024-04-23 17:15:17');
INSERT INTO employees VALUES('3773','ROY RENOLD',' SIBURIAN','AB00098','roysiburian17@gmail.com','3604021701900003','72.854.212.7-401.000','08212935520','1990-01-17','Male','3','3','35','81','','2','1','','','0','0','0','2021-11-17','','married','','K/0','Peru Bumi Nagara Lestari Blok A.03 No.26 Rt/Rw 026/005 Ds.Nagara Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3774','DIAN ','HADIANSYAH ','AB00099','0','3604300603820002','63.426.822.1-454.000','085920671630','1982-04-05','Male','3','3','35','81','','2','1','','','0','0','0','2021-11-17','','married','','K/2','Kp.Kamurang Pal Rt/Rw 003/002 Ds.Grogol Indah Kec.Anyar','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3775','NIKMATULLAH','','AB00100','Nickkutubuku@gmail.com','3672010906900001','53.871.218.3-417.000','085693592382','1990-06-08','Male','3','3','35','81','','2','1','','','0','0','0','2022-01-05','','married','','K/2','Link.Cipaot Rt/Rw 001/002 Ds.Bulakan Kec.Cibeber','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3776','IRWAN ','WAHYUDI','AB00101','irwanwahyudi469@gmail.com','3604081909920002','70.313.148.2-401.000','081315128489','1992-09-19','Male','3','3','35','81','','2','1','','','0','0','0','2022-01-05','','married','','K/1','Kp.Peres Rt/Rw 001/002 Ds.Pulo Panjang Kec.Ampel','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3777','AJISLIM ','SILABAN','AB00102','ajislimsilabansilaban@gmail.com','3604090202950009','41.041.171.4-401.000','082353311506','1995-02-02','Male','3','3','35','81','','2','1','','','0','0','0','2022-01-18','','single','','TK/0','Komp.Griya Reang Indah Blok D.3 No.6 Rt/Rw 003/010 Ds.Banjar Sari Kec.Cipocok Jaya','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3778','MANSYUR','','AB00153','ajaikal898@gmail.com','3604100505730701','0','\'083127195698','1973-05-05','Male','3','3','35','81','','2','1','','','0','0','0','2023-02-10','','married','','K/3','Kp.Cibetik Rt/Rw 008/003 Ds.Pangampelan Kec.Walantaka','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3779','SOHADI','','AB00172','-','3604160211930001','81.265.792.2-401.000','083890898941','1993-11-02','Male','3','3','35','81','','2','1','','','0','0','0','2023-06-07','','married','','K/1','Kp.Warakas Rt/Rw 011/003 Ds.Lamaran Kec.Binuang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3780','CHARLY ','NABABAN','AB00165','-','3604042606830053','25.446.227.8-401.000','081379456337','1983-06-26','Male','3','3','35','79','','2','1','','','0','0','0','2023-06-07','','married','','K/2','Komp.Taman Mutiara Indah Blok G.5 No.42 Rt/Rw 002/018 Ds.Kaligandu Kec.Serang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3781','IMBRAN','','AB00169','-','3604160101800006','-','082123656003','1980-01-01','Male','3','3','35','81','','2','1','','','0','0','0','2023-06-07','','married','','K/3','Kp.Karenggan Rt/Rw 004/001 Ds.Sukamanju Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3782','ANDRY ','FIRMANSYAH','AB00154','andry_firmansyah17@yahoo.com','3604111704940001','81.218.599.9-401.000','085288846363','1994-04-17','Male','3','3','35','71','','2','1','','','0','0','0','2023-02-10','','married','','K/1','Kp.Pasir Binong Rt/Rw 014/005 Ds.Kendayakan Kec.Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3783','SUHEMI ','ANDRIANSYAH','AB00168','0','3604161905030001','42.633.252.4-454.000','083119047028','2003-05-19','Male','3','3','35','71','','2','1','','','0','0','0','2023-06-07','','single','','TK/0','Kp.Rangkong Rt/Rw 009/001 Ds.Kibin Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3784','M.KAMAN ','SANUSI','AB00103','Kamansanusi6@gmail.com','3604112504720004','79.408.723.9.401.000','081283600132','1972-04-25','Male','3','3','35','82','','2','1','','','0','0','0','2019-06-01','','divorce','','TK/1','Kp.Baru Pasar Rt/Rw 002/003 Ds.Kragilan Kec.Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:18','2024-04-23 17:15:18');
INSERT INTO employees VALUES('3785','WILLI  ','AFRILIAN','AB00104','willydoer1207@gmail.com','3303053004820002','63.413.834.1-529.000','085959568233','1982-04-30','Male','3','3','35','83','','2','1','','','0','0','0','2021-10-04','','single','','TK/0','Purbalingga Kulon Rt/Rw 003/001 Ds.Purbalingga Kulon Kec.Purbalingga','Purbalingga','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3786','HERI ','SUARNO ','AB00105','Herisuarno@gmail.com','3604090806750001','79.408.837.7-401.000','081291318134','1975-06-08','Male','3','3','35','84','','2','1','','','0','0','0','2021-09-15','','married','','K/2','Dusun Waringin Harjo Rt/Rw 004/004 Ds.Agon Kec.Kalianda','Lampung','Sumatera Selatan','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3787','DASRON ','SINAGA','AB00106','Sinagadasron9@gmail.com','3276090512870001','82.896.330.6-401.000','085215579970','1987-12-18','Male','3','3','35','84','','2','1','','','0','0','0','2022-01-18','','married','','K/1','Perum BCP 2 Blok K2A No.3 Rt/Rw 042/006 Ds.Ranjeng Kec.Ciruas','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3788','TOLHAS JONIER ','HUTASOIT ','AB00097','tolhasjunier@.gmail.comm','1273012812660001','53.229.024.4-454.000','085210714897','1986-12-28','Male','3','3','35','81','','2','1','','','0','0','0','2021-11-17','','married','','K/1','Perum Puri Mas Blok D6 No.07 Rt/Rw 002/004 Ds.Sititerate Kec.Cikande','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3789','MUHAMMAD ','KAHFI ','AB00107','muhammadkhf20@gmail.com','3604112004980001','84.028.650.4-401.000','083871952889','1998-04-20','Male','3','3','35','71','','2','1','','','0','0','0','2021-10-02','','single','','TK/0','Komp.Ciujung Damai Blok.C 44 No.11 Rt/Rw 007/002 Ds.Kendayakan Kec.Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3790','ROHMAT','','AB00108','dyah.fu19@gmail.com','3604091306780002','79.408.742.9-401.000','081315415696','1978-06-13','Male','3','3','35','85','','2','1','','','0','0','0','2019-06-01','','married','','K/3','Jl.Cikulur Masjid Rt/Rw 002/004 Ds.Serang Kec.Serang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3791','JULI','','AB00109','heriyadijuli18@gmail.com ','3604161211900004','\'70.239.303.4-401.000','085216916646','1990-11-12','Male','3','3','35','','','2','1','','','0','0','0','2021-06-16','','married','','K/2','Kp.Ciagel Rt/Rw 003/001 Ds.Ciagel Kec.Kibin','Lebak','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3792','JAJA ','SUNARJA ','AB00110','Jajasunarja52email.com','3602141701760002','49.909.869.9-401.000','085210377746','1976-01-17','Male','3','3','35','87','','2','1','','','0','0','0','2021-06-16','','married','','K/3','Kp.Cijoro Barat Rt/Rw 004/001 Ds.Muara Ciujung Timur Kec.Rangkas Bitung','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3793','MEDI ','','AB00111','034beno@gmail.com','3604160503850002','70.239.349.7-401.000','081316761693','1985-06-05','Male','3','3','35','87','','2','1','','','0','0','0','2021-06-16','','single','','TK/0','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3794','ANDRI ','WIBOWO ','AB00112','andrie.wibowo71@gmail.com ','1408042509870002','81.265.194.1-405.000','085329421884','1987-09-25','Male','3','3','35','87','','2','1','','','0','0','0','2021-11-16','','married','','K/0','Kp.Pengkolan Rt/Rw 007/002 Ds.Purabaya Kec.Purabaya','Sukabumi','Jawa Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3795','YAHYA',' SUPARJO ','AB00113','Yahyasuprjo1309@gmail.com','3672071309890001','71.455.672.7-417.000','085210759988','1989-09-13','Male','3','3','35','87','','2','1','','','0','0','0','2021-12-10','','married','','K/2','Link.Ciora Gede Rt/Rw 005/002 Ds.Kotasari Kec.Gerogol','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3796','DADANG ','SUGIANTO','AB00114','abythea19@gmail.com ','3509221911890004','85.443.126.9-042.000','081224074130','1989-11-19','Male','3','3','35','87','','2','1','','','0','0','0','2022-02-08','','married','','K/2','Kp.Saribudi Rt/Rw 001/009 Ds.Banyurasa Kec.Sukahening','Tasikmalaya','Jawa Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3797','RIDWAN ','SAIDI ','AB00115','Ridwanzea16@gmail.com','3215102506900002','71.458.236.8-408.000','087864745161','1990-06-25','Male','3','3','35','87','','2','1','','','0','0','0','2022-02-23','','married','','K/2','Kavling Bumi Mandiri Rt/Rw 004/005 Ds.Karangsatria Kec.Tambun Utara','Bekasi','Jawa Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:19','2024-04-23 17:15:19');
INSERT INTO employees VALUES('3798','M. ALI ','SODIKIN','AB00144','hilyaazahra89@gmail.com','3604161606970003','94.080.082.4-454.000','0881010749831','1997-08-16','Male','3','3','35','71','','2','1','','','0','0','0','2023-01-18','','married','','K/1','Kp.Cijeruk Rt/Rw 005/001 Ds.Cijeruk Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3799','UTAMA ','WIJAYA','AB00190','0199tamawijaya@gmail.com','3601121408980004','61.948.790.3-419.000','082175199923','1998-08-14','Male','3','3','35','88','','2','1','','','0','0','0','2023-09-21','','single','','TK/0','Kp.Laba Rt/Rw 003/008 Ds.Cigondang Kec.Labuan','Pandeglang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3800','ERLAN','','AB00195','erlanamelia01@gmail.com','1671060108820013','82.058.817.6-301.000','081268030399','1982-08-01','Male','3','3','35','89','','2','1','','','0','0','0','2023-09-26','','married','','K/1','Jl.Swadaya Murni Rt/Rw 021/009 Ds.Sako Kec.Sako','Palembang','Sumatera Selatan','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3801','MUJIB ','MUSTAIN','AB00201','mujib.mustain@yahoo.com','3320072403880006','75.827.759.4-516.000','081228259398','1988-03-24','Male','3','3','35','90','','2','1','','','0','0','0','2023-11-19','','married','','K/0','DK Tembiluk Rt/Rw 015/004 Ds.Jambu Kec.Jambu','Jepara','Jawa Timur','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3802','MUHAMAD ','JUPRI','AB00167','0','3604110412950001','39.140.302.9-454.000','085939419245','1995-12-04','Male','3','3','35','71','','2','1','','','0','0','0','2023-06-07','','single','','TK/0','Kp.Pasir Binong Rt/Rw 014/005 Ds.Kendayakan Kec.Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3803','ASEP ACHYAR',' UTISMAN','AB00118','asepachyarsutisman@gmail.com ','3604161708680001','79.408.717.1-401.000','089643151668','1968-08-17','Male','3','3','35','91','','2','1','','','0','0','0','2019-06-01','','married','','K/3','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3804','DAMANHURI','','AB00119','damane1378@gmail.com','3604161101830001','79.408.796.5-401.000','082298339997','1983-01-11','Male','3','3','35','92','','2','1','','','0','0','0','2018-10-01','','married','','K/2','Kp. Barabuntung Rt/Rw. 06/02 Ds.Cijeruk Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3805','SARKANI','','AB00120','kanisarkani982@gmail.com','3604160706770003','70.226.770.9-401.000','085211821475','1976-04-06','Male','3','3','35','93','','2','1','','','0','0','0','2018-10-01','','married','','K/2','Kp.Panyingkiran Rt/Rw 001/007 Ds.Situsaeur Kec.Karangpawitan','Garut','Jawa Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3806','SAEFUDIN','','AB00121','Seapudin1970@gmail.com','3604301108700003','78.387.097.5-401.000','087771446771','1970-08-11','Male','3','3','35','92','','2','1','','','0','0','0','2021-09-15','','married','','K/1','Kp.Kamurang Pal Rt/Rw 003/002 Ds.Grogol Indah Kec.Anyar','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3807','KEMIS ','','AB00122','themozt046@gmail.com','3604161902860001','70.233.178.6-401.000','081251096886','1986-02-19','Male','3','3','35','','','2','1','','','0','0','0','2021-11-08','','single','','TK/0','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3808','BUDI ','MUHAROM','AB00123','dhiosaputra968@gmail.com','3603122708790001','68.939.630.7.418.000','082320775526','1979-08-27','Male','3','3','35','71','','2','1','','','0','0','0','2021-11-17','','married','','K/2','Jl.Cimanuk No.17 B Rt/Rw 003/015 Ds.Pataruman Kec.Tarogong Kidul','Garut','Jawa Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3809','HERU SUMAS','ADITYA','AB00124','Herusumas65@gmail.com','3604150702940005','70.233.149.7-401.000','081290562157','1994-02-07','Male','3','3','35','71','','2','1','','','0','0','0','2022-03-02','','married','','K/1','Kp.Baru Rt/Rw 010/003 Ds.Julang Kec.Cikande','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:20','2024-04-23 17:15:20');
INSERT INTO employees VALUES('3810','PARSAORAN','GULTOM','AB00152','gultom.parsaoran1986@gmail.com','1408042308860002','70.454.691.0-212.000','\'081227693124','1986-08-23','STAFF','3','3','36','51','','2','1','','','0','0','0','2020-08-01','','married','','K/2','Jl Sawo Gang Duku Rt/Rw 04/04 Ds. Menganti Kec. Kesugihan','Cilacap','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3811','SANTOSO','','AB00125','santoso.rms55@gmail.com','3604091206730002','79.408.671.0-401.000','081311342428','1973-06-12','Male','3','3','36','','','2','1','','','0','0','0','2019-06-01','','married','','K/1','TCP Blok E2 No.12 Rt/Rw 005/005 Ds.Citerep Kec.Ciruas','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3812','SAFIYUDIN','','AB00126','0','3604062005760001','-','085311580122','1974-05-20','Male','3','3','36','53','','2','1','','','0','0','0','2022-01-05','','married','','K/3','Kp.Cakar Rt/Rw 008/003 Ds.Melati Kec.Waringinkurung','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3813','SAPRUDIN','','AB00127','ariep321022@gmail.com','3604330911800001','43.663.200.4-454.000','085946793917','1980-11-09','Male','3','3','36','53','','2','1','','','0','0','0','2022-01-05','','married','','K/2','Kp.Tegal Rata Rt/Rw 006/002 Ds.Gunung Sari Kec. Gunung Sari','Sumedang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3814','DADY ','ROSYADI ','AB00129','dadyrosyadi14@gmail.com','3211182311890006','76.021.501.2-446.000','08952790225','1989-11-23','Male','3','3','36','54','','2','1','','','0','0','0','2021-03-20','','married','','K/2','Link Pasanggrahan Rt/Rw 001/006 Ds.Pasanggrahan baru kec.Sumedang selatan','Sumedang','Jawa Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3815','MUCHTAR ','','AB00130','muchtar1766@gmail.com','3672081711660002','59.126.272.0-417.000','087771748372','1966-11-17','Male','3','3','36','54','','2','1','','','0','0','0','2019-01-07','','married','','K/2','Link Kedawung Rt/Rw 001/007 Ds.Taman Baru Kec.Citangkil','Cilegon','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3816','RAHMATTULOH','','AB00131','SANUNRAHMAT@gmail.com','3604161911900002','70.239.362.0-401.000','081317516084','1990-11-19','Male','3','3','36','54','','2','1','','','0','0','0','2021-09-09','','married','','K/2','Kp.Ciwajik Rt/Rw 003/002 Ds.Kibin Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3817','DIMAS CANDRA ','GIRISONA','AB00132','dimaschandragirisona@gmail.com','3604100907850141','63.206.235.2-401.000','081293317538','1985-07-09','Male','3','3','36','54','','2','1','','','0','0','0','2022-02-08','','single','','TK/0','Perum Persada Banten Blok G.05 No.29 Ds.Teritih Kec.Walantaka','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3818','MOCHAMAD ','SU\'UDI','AB00196','moch.suudi08@gmail.com','3604110803910001','80.005.153.4-401.000','081310908261','1991-03-08','Male','3','3','36','55','','2','1','','','0','0','0','2023-10-04','','single','','TK/0','Kp.Tegal Maja Rt/Rw 005/007 Ds.Tegal Maja Kec.Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3819','PARYANTO','','AB00133','blegohkelana123@gmail.com','1807121802790001','79.408.712.2-321.000','081218061895','1979-02-18','Male','3','3','36','54','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Pugung Raharjo Rt/Rw 028/006 Ds.Pugung Raharjo Kec.Sekampung Udik Lampung Timur - Lampung','Lampung','Sumatera Selatan','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3820','ERIK EXTRADA ','','AB00134','eextrada05@gmail.com','3604162003930002','96.274.207.8-454.000','089529917134','1993-03-20','Male','3','3','36','54','','2','1','','','0','0','0','2021-07-10','','married','','K/1','Kp.Kadingding Rt/Rw 006/002 Ds.Kibin Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3821','NANANG FARID ','ARIYANTO','AB00199','0','3514143010770004','08.740.723.5-624.000','081335306888','1977-10-30','Male','3','3','36','54','','2','1','','','0','0','0','2023-10-13','','married','','K/3','Bekacak Rt/Rw 001/003 Ds.Kolursari Kec.Bangil','Pasuruan','Jawa Timur','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:21','2024-04-23 17:15:21');
INSERT INTO employees VALUES('3822','AMIN','','AB00135','djadiputra514@gmail.cpm','1812032203760001','79.408.752.8-401.000','085216957457','1975-03-22','Male','3','3','36','56','','2','1','','','0','0','0','2019-06-01','','married','','K/2','Karta Sari Rt/Rw 010/003 Ds.Karta Sari Kec.Tulang Bawang Udik Kab.Tulang Bawang','Lampung','Sumatera Selatan','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3823','ANTONI','','AB00136','antonichebungsu@gmail.co','3604160107830006','\'70.239.255.6-401.000','083842150483','1983-07-01','Male','3','3','36','57','','2','1','','','0','0','0','2017-09-02','','married','','K/3','Kp.Beberan Kompa Rt/Rw 006/003 Ds.Teras Kec.Carenang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3824','ARIS  ','SUSANTO','AB00137','arissusanto2938@gmail.com','3301222605920004','92.066.037.0-522.000','083826968420','1992-05-26','Male','3','3','36','57','','2','1','','','0','0','0','2021-12-02','','married','','K/0','Jl.Nusa Ori Rt/Rw 005/008 Ds.Kutawaru Kec.Cilacap Tengah','Cilacap','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3825','SUDARWAN','','AB00173','0','3603012807950003','82.919.122.0-451.000','081296697862','1995-07-28','Male','3','3','36','57','','2','1','','','0','0','0','2023-06-02','','married','','K/1','Kp.Sukajadi Rt/Rw 003/007 Ds.Sukajadi Kec.Cibaliung','Pandeglang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3826','MANAP','','AB00179','Msabymanap01@gmail.com','3603310111850008','94.873.198.9-451.000','083808510377','1985-11-01','Male','3','3','36','57','','2','1','','','0','0','0','2023-07-07','','married','','K/2','Kp.Barengkok Rt/Rw 003/003 Ds.Solear Kec.Solear','Tangerang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3827','MUHAMMAD RIDWAN ','AMIN','AB00138','ridwan4892@gmail.com','3604020804920303','85.267.634.5-401.000','082122270017','1992-04-08','Male','3','3','36','55','','2','1','','','0','0','0','2022-01-05','','married','','K/1','Sumur Pecung Rt/Rw 003/001 Ds.Sumur Pecung Kec.Serang','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3828','MOH SUDARI ','WIBOWO','AB00139','mohsudari698@gmail.com','3604111505740002','79.408.696.7-401.000','081319698280','1974-05-15','Male','3','3','36','58','','2','1','','','0','0','0','2019-06-01','','married','','K/3','Perumahan Ciujung Damai Blok C.42 No.7 Rt/Rw 006/002 Ds.Kendayakan Kec.Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3829','A.HAFIDULLAH','','AB00140','ahmadhafid548@gmail.com','3604111812890001','83.760.733.2-401.000','085215799454','1989-12-18','Male','3','3','36','54','','2','1','','','0','0','0','2022-05-24','','married','','K/0','Kp.Pabrik Rt/Rw 001/001 Ds.Tegal Maja Kec.Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3830','WAHYU DWI ','SAPUTRA','AB00141','wahyuwahyul2003@gmail.com','3301052406030003','-','085229332286','2003-05-24','Male','3','3','36','59','','2','1','','','0','0','0','2022-08-22','','single','','TK/0','Dusun Sitara Kulon Rt/Rw 003/005 Ds.Jetis Kec.Nusawungu','Cilacap','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3831','SAHRONI','','AB00142','sahroniaduai409@gmail.com','3604161202790003','79.408.780.9-401.000','081291845422','1979-02-12','Male','3','3','36','54','','2','1','','','0','0','0','2022-10-05','','married','','K/2','Kp.Paya Lebak Rt/Rw 014/003 Ds.Ciagel Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3832','BINTANG ','CHANENSYA','AB00143','zeyyyyuss@gmail.com','3604166905040001','61.328.993.3-401.000','081212259113','2004-05-29','Male','3','3','36','59','','2','1','','','0','0','0','2022-10-18','','single','','TK/0','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3833','KAMSARUDIN','','AB00148','ilhamrakaboom92@gmail.com','3604162009850001','0','082122189601','1985-09-20','Male','3','3','36','53','','2','1','','','0','0','0','2023-02-06','','married','','K/3','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:22','2024-04-23 17:15:22');
INSERT INTO employees VALUES('3834','ZULKIFLI','','AB00146','falskipli@gmail.com','3604111202920003','80.636.079.8-401.000','088293046543','1992-02-12','Male','3','3','70','104','','2','1','','','0','0','0','2023-01-20','','single','','TK/0','Kp.Pabuaran Rt/Rw 002/005 Ds.Kragilan Kec.Kragilan','Serang','Banten','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-23 17:15:23','2024-04-23 17:15:23');
INSERT INTO employees VALUES('3835','Ahmad ','Saebani','AH-002','','1401011509720003','','082282030706','1972-09-15','Male','6','8','108','434','','2','1','','','0','0','0','2024-03-18','','married','','K/3','Perum BTN Tualang Regency Blok B29 Rt.001 Rw.003 Kel. Perawang Barat Kec. Tualang ','Siak','Riau','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employees VALUES('3836','Mahmudin','','AH-003','','1408040912760001','','082170909430','1976-12-09','Male','6','8','101','423','','2','1','','','0','0','0','2024-03-18','','married','','K/2','Jl. Indah Kasih Gg. Utama Rt.011 Rw.006 Kel. Perawang Kec. Tualang','Siak','Riau','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employees VALUES('3837','Novel ','Ramadhan ','AH-004','novel.ramadhan@timas.com','3320071003920004','85.841.148.1-301.000','081225312572','1992-03-10','Male','6','8','','','','2','1','','','0','0','0','2024-03-18','','married','','K/1',' DK TEMBILIK DESA JAMBU RT/RW 03/01 KEC.MLONGGO Jepara','Jepar','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employees VALUES('3838','Wahyudin','','AH-005','wahyudin@timas.com','1671102001870005','26.455.178.9-222.000','081364934014','1987-01-20','Male','6','8','103','426','','2','1','','','0','0','0','2024-03-25','','married','','K/1','Rusunawa Marunda Blok A 6 Kerapu No.108 Kel. Marunda Kec. Cilincing','Jakarta Utara','DKI Jakarta','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employees VALUES('3839','Ivori Gavin ','Tampubolon ','AH-006','Ivori.gavin@timas.com','1408042604770007','Non NPWP','082176647091','1977-04-26','Male','6','8','107','432','','2','1','','','0','0','0','2024-03-26','','divorce','','TK/0','Jl.Raya KM.5-Perawang RT/RW:006/005 kel.perawang','Siak','Riau','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employees VALUES('3840','Wawan ','Saputra','AH-007','wawansaputera43@gmail.com','1610140403000002','74.429.460.4-321.000','085378093647','1999-12-05','Male','6','8','104','428','','2','1','','','0','0','0','2024-03-26','','single','','TK/0','Dusun I Rt.00 Rw.00 Kel. Ibul Dalam Kec. Rambang Kuang','Ogan Komering Ilir','Sumatera Selatan','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:33','2024-04-25 11:51:33');
INSERT INTO employees VALUES('3841','Eko Febri ','Praesetyo ','AH-008','','1802141502970001','35.829.044.3-117.000','','1997-02-15','Male','6','8','109','436','','2','1','','','0','0','0','2024-03-25','','single','','TK/0','Dusun II Wates Rt.005 Rw.002 Kel. Wates Kec. Bumi Ratu Nuban','Lampung Tengah','Lampung','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('3842','Pardomuan ','Tampubolon ','AH-009','','1272010704750002','','','1975-04-07','Male','6','8','105','430','','2','1','','','0','0','0','2024-03-25','','married','','K/3','Gang Made No. 26 BLK Rt.009 Rw.003 Kel. Kebun Sayur Kec. Siantar Timur','Pematang Siantar','Suamatera Utara','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('3843','Jupri ','Purba','AH-011','','1401212807920001','70.084.871.6-219.000','','1992-07-28','Male','6','8','105','430','','2','1','','','0','0','0','2024-03-25','','married','','K/1','Jl. Pemda Gg. Makmur Rt.002 Rw.008 Kel.Pangkalan Kerinci Kota Kec. Pangkalan Kerinci Kab. Pelalawan','Pelalawan','Riau','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('3844','Alfajri','','AH-012','','1403090210810005','','','1981-10-02','Male','6','8','109','436','','2','1','','','0','0','0','2024-03-25','','married','','K/3','Jorong Simpuruik Rt.000 Rw.000 Kel. Simpuruik Kec. Sungai Tarab','Tanah Datar','Sumatera Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('3845','Rio Riki ','Subagio ','AH-013','','1472021311960021','74.887.554.9-204.000','','1996-11-13','Male','6','8','109','436','','2','1','','','0','0','0','2024-03-25','','married','','K/1','Jl. Jeruk Gg. Cermai No.01 Rt.007 Rw.000 Kel. Rimba Sekampung Kec. Dumai Kota','Dumai','Riau','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('3846','Erizon','','AH-014','','1307130808750004','','','1975-08-08','Male','6','8','103','427','','2','1','','','0','0','0','2024-03-26','','married','','K/3','Atas Rt.- Rw.- Kel. Sungai Belantik Kec. Akabiluru','Lima Puluh Kota','Sumatera Barat','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('3847','Darwis','','AH-015','','1671061204680010','','','1968-04-12','Male','6','8','107','','','2','1','','','0','0','0','2024-04-01','','married','','K/3','Jl. R Sukampto Lr. Masjid Rt.038 Rw.008 Kel. 8 Ilir Kec. Ilir Timur II','Palembang','Sumatera Selatan','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('3848','Indi','','AH-016','','1602081812960001','','','1996-12-18','Male','6','8','103','427','','2','1','','','0','0','0','2024-03-19','','married','','K/1','Dusun II Rt.006 Rw.003 Kel.Terusan Menang Kec. Sirah Pulau Padang','Ogan Komering Ilir','Sumatera Selatan','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('3849','Heriyanto','','AH-017','','1602082201810001','','','1981-01-22','Male','6','8','104','429','','2','1','','','0','0','0','2024-04-15','','married','','K/2','Desa Terate Rt.002 Rw.000 Kel. Terate Kec. Sirah Pulau Padang','Ogan Komering Ilir','Sumatera Selatan','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('3850','Andy ','Setyawan ','AH-018','','3275112607730006','20.216.966.0-521.000','082225666729','1973-07-26','Male','6','8','67','425','','2','1','','','0','0','0','2024-04-22','','married','','K/3','Dukuh Zambrud Blok S2 /12 Rt.002 Rw.011 Kel. Padurenan Kec. Mustika Jaya','Bekasi','Bekasi','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('3851','Mustajwid','','AH-019','','3302071209780003','','','1979-09-12','Male','6','8','108','435','','2','1','','','0','0','0','2024-04-22','','married','','TK/0','Borogangin Rt.004 Rw.001 Kel. Bogangin Kec. Sumpuh','Banyu Mas','Jawa Tengah','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-25 11:51:34','2024-04-25 11:51:34');
INSERT INTO employees VALUES('4280','Siswandi','','AG00005','siswandi@timas.com','3501110203630005','98.644.482.6-125.000','','1963-03-02','Male','4','7','76','132','','2','1','','','0','0','0','2023-10-21','','married','','K/2','Dusun II, Jl Karya Kebon Sayur Batang Kuis, Kab Deli Serdang, Medan','MEDAN','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employees VALUES('4281','Hamzah','Sayap','AG00008','hamzah.sayap@timas.com','3201262605860002','47.614.247.6-434.000','0821-2384-9896','1986-05-27','Male','4','7','82','206','','2','1','','','0','0','0','2023-10-15','','married','','K/2','PERUM PURI LESTARI BLOK F13 NO.3 RT/RW:004/016 KEL.SUKAJAYA,KEC.CIBITUNG BEKASI-JABAR','JABAR','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employees VALUES('4282','Berri','Pratama','AG00009','berri.karya@timas.com','1671032801880003','73.507.215.9-306.000','081272221353','1988-01-28','Male','4','7','82','207','','2','1','','','0','0','0','2023-10-21','','married','','K/2','JL.SENTOSA LORONG ASLINO.604 RT/RW:013/004 KEL.SENTOSA KEC.SEBERANG ULU DUA,PALEMBANG - SUMSEL','SUMSEL','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employees VALUES('4283','Yohana','Rede','AG00010','yohana.rede@timas.com','6473015701910003','','082152091791','1991-01-17','Female','4','7','90','246','','2','1','','','0','0','0','2023-10-16','','single','','TK/0','JL.AKI BALAK 056/000 KEL.KARANG ANYER KOTA.TARAKAN','TARAKAN','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employees VALUES('4284','Moh.','Ridwan Virgiawan','AG00011','','6473012708930001','','085352523311','1993-08-27','Male','4','7','90','246','','2','1','','','0','0','0','2023-10-12','','married','','K/2','JL. BALAK NO.24 019/000 KEL.KARANG ANYAR PANTAI KEC.TARAKAN BARAT','BARAT','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employees VALUES('4285','Linda','Waty','AG00012','linda.waty@timas.com','6473014609970001','50.766.993.5-723.000','082351538060','1997-09-06','Female','4','7','82','208','','2','1','','','0','0','0','2023-10-21','','single','','TK/0','JL.AKI BALAK 059/999 KEL.KARANG ANYAR KEC.TARAKAN BARAT KOTA TARAKAN','TARAKAN','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employees VALUES('4286','Arisman','','AG00013','','6473011406730004','15.026.810.0-723.000','','1973-06-14','Male','4','7','','122','','2','1','','','0','0','0','2023-11-01','','married','','K/3','JL.DR.SUTOMO NO 40 006/- KEL.KARANG BALIK KEC.TARAKAN BARAT KOTA TARAKAN KALIMANTAN UTARA','UTARA','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employees VALUES('4287','Junior','Dedi Sukanto S','AG00014','','1405020707770008','77.922.690.1-222.000','082177037320','1977-07-07','Male','4','7','74','118','','2','1','','','0','0','0','2023-11-01','','married','','K/3','BLP Blok G No. 34 Rt.003 Rw.010 Kel. Pangkalan Kerinci Kota KEC. Pangkalan Kerinci Kab. Pelalawan','PELALAWAN','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employees VALUES('4288','Tuppal','Pangaribuan','AG00015','','1222010909990001','43.955.916.2-222.000','085274712534','1999-09-09','Male','4','7','86','219','','2','1','','','0','0','0','2023-11-01','','single','','TK/0','Lingkungan Rawa Badak Rt.008 Rw.007 Kel. Pangkalan Kerincci Timur Kec. Pagkalan Kerinci Kab.Pelalawan','PELALAWAN','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employees VALUES('4289','Dahlan','','AG00016','','1213082403950005','74.891.897.6-118.000','081295528930','1995-03-24','Male','4','7','86','220','','2','1','','','0','0','0','2023-11-01','','single','','TK/0','Tamiang, Rt.- Rw.- Kel. Tamiang Kec Kota Nopan Kab. Mandailing Natal','NATAL','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:40','2024-04-29 16:18:40');
INSERT INTO employees VALUES('4290','Adam','Malik','AG00017','','6473010804910004','','081350930996','1991-04-08','Male','4','7','','122','','2','1','','','0','0','0','2023-11-02','','married','','K/2','JL. GAJAH MADA 003/000 KEL KARANG PEJO KEC.TARAKAN BARAT KOTA TARAKAN','TARAKAN','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employees VALUES('4291','Erizon','','AG00018','erizon.guci@timas.com','1408040704670003','48.005.759.5-222.000','081263822242','1967-04-07','Male','4','7','73','110','','2','1','','','0','0','0','2023-10-21','','married','','K/2','Ampang Kaluak Jorong Surau Lauik Rt.00o Rw.000 Ke. Panampuang Kec. Ampek Angkek Kab. Agam','AGAM','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employees VALUES('4292','Gus','Amin','AG00019','','1601140610780004','','','1978-10-06','Male','4','7','','','','2','1','','','0','0','0','2023-10-21','','married','','K/2','Jl padat Karya kel Sekar Jaya Air Pauh','PAUH','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employees VALUES('4293','Karina','Andria Putri','AG00020','karina.putri@timas.com','3271044206040005','60.194.083.6-404.000','','2004-06-02','Female','4','7','71','105','','2','1','','','0','0','0','2023-11-03','','single','','TK/0','BATUHULUNG 001/001 KEL.NALUMBANG JAYA KE.BOGOR BARAT KOTA.BOGOR','BOGOR','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employees VALUES('4294','Syahtullah','','AG00021','','7401011212820003','','','1982-12-12','Male','4','7','91','241','','2','1','','','0','0','0','2023-11-03','','single','','TK/0','JL.PROPINSI KM48 007/000 KEL.BABULU DARAT KEC.BABULU','BABULU','','100','','','','','','','','0','','','','General','0','0','0','','0.00','0','0','0','0','1','','2024-04-29 16:18:41','2024-04-29 16:18:41');
INSERT INTO employees 