@extends('layout.main')
@section('content')
    <section>

        <div class="container-fluid"><span id="general_result"></span></div>


        <div class="container-fluid mb-3">
            @can('store-tax')
                <button type="button" class="btn btn-info" name="create_record" id="create_record"><i class="fa fa-plus"></i>
                    {{ __('Add Tax List') }}</button>
            @endcan
            @can('delete-tax')
                <button type="button" class="btn btn-danger" name="bulk_delete" id="bulk_delete"><i
                        class="fa fa-minus-circle"></i> {{ __('Bulk delete') }}</button>
            @endcan
        </div>


        <div class="table-responsive">
            <table id="tax-table" class="table ">
                <thead>
                    <tr>
                        <th class="not-exported"></th>
                        <th>{{ __('Company Name') }}</th>
                        <th>{{ __('Min Salary per Year') }}</th>
                        <th>{{ __('Max Salary per Year') }}</th>
                        <th>{{ __('Tax Percentage') }}</th>
                        <th class="not-exported">{{ trans('file.action') }}</th>
                    </tr>
                </thead>

            </table>
        </div>
    </section>



    <div id="formModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title">{{ __('Add tax') }}</h5>
                    <button type="button" data-dismiss="modal" id="close" aria-label="Close" class="close"><i
                            class="dripicons-cross"></i></button>
                </div>

                <div class="modal-body">
                    <span id="form_result"></span>
                    <form method="post" id="sample_form" class="form-horizontal">

                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ trans('file.Company') }}</label>
                                    <select name="company_id" id="company_id" class="form-control selectpicker dynamic"
                                        data-live-search="true" data-live-search-style="contains"
                                        data-first_name="first_name" data-last_name="last_name"
                                        title='{{ __('Selecting', ['key' => trans('file.Company')]) }}...'>
                                        @foreach ($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->company_name }}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ __('Min Salary per Year') }}</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ config('variable.currency') }}</span>
                                        </div>
                                        <input type="number" name="min_salary" id="min_salary" class="form-control"
                                            value=""step=".01">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ __('Max Salary per Year') }}</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ config('variable.currency') }}</span>
                                        </div>
                                        <input type="number" name="max_salary" id="max_salary" class="form-control"
                                            value=""step=".01">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ __('Tax Percentage') }}</label>
                                    <div class="input-group">
                                        <input type="number" name="percentage" id="percentage" class="form-control"
                                            value=""step=".01">
                                        <div class="input-group-append">
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="container">
                                <div class="form-group" align="center">
                                    <input type="hidden" name="action" id="action" />
                                    <input type="hidden" name="hidden_id" id="hidden_id" />
                                    <input type="submit" name="action_button" id="action_button" class="btn btn-warning"
                                        value={{ trans('file.Add') }} />
                                </div>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>





    <div class="modal fade" id="tax_modal" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel">{{ __('Tax List Info') }}</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-md-12">

                            <div class="table-responsive">

                                <table class="table  table-bordered">

                                    <tr>
                                        <th>{{ __('Company Name') }}</th>
                                        <td id="company_name_id"></td>
                                    </tr>

                                    <tr>
                                        <th>{{ __('Min Salary per Year') }}</th>
                                        <td id="min_salary_id"></td>
                                    </tr>

                                    <tr>
                                        <th>{{ __('Max Salary per Year') }}</th>
                                        <td id="max_salary_id"></td>
                                    </tr>

                                    <tr>
                                        <th>{{ __('Tax Percentage') }}</th>
                                        <td id="percentage_id"></td>
                                    </tr>

                                </table>

                            </div>

                        </div>
                    </div>


                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('file.Close') }}</button>
            </div>
        </div>
    </div>


    <div id="confirmModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title">{{ trans('file.Confirmation') }}</h2>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h4 align="center">{{ __('Are you sure you want to remove this data?') }}</h4>
                </div>
                <div class="modal-footer">
                    <button type="button" name="ok_button" id="ok_button"
                        class="btn btn-danger">{{ trans('file.OK') }}'
                    </button>
                    <button type="button" class="close btn-default"
                        data-dismiss="modal">{{ trans('file.Cancel') }}</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        (function($) {
            "use strict";

            $(document).ready(function() {

                let date = $('.date');
                date.datepicker({
                    format: '{{ env('Date_Format_JS') }}',
                    autoclose: true,
                    todayHighlight: true
                });


                let table_table = $('#tax-table').DataTable({
                    initComplete: function() {
                        this.api().columns([4]).every(function() {
                            let column = this;
                            let select = $('<select><option value=""></option></select>')
                                .appendTo($(column.footer()).empty())
                                .on('change', function() {
                                    let val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                    );

                                    column
                                        .search(val ? '^' + val + '$' : '', true, false)
                                        .draw();
                                });

                            column.data().unique().sort().each(function(d, j) {
                                select.append('<option value="' + d + '">' + d +
                                    '</option>');
                                $('select').selectpicker('refresh');
                            });
                        });
                    },
                    responsive: true,
                    fixedHeader: {
                        header: true,
                        footer: true
                    },
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('tax.index') }}",
                    },

                    columns: [{
                            data: 'id',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'company_name',
                            name: 'company_name',

                        },
                        {
                            data: 'min_salary',
                            name: 'min_salary',
                            render: function(data) {
                                if ('{{ config('variable.currency_format') == 'suffix' }}') {
                                    return data + ' {{ config('variable.currency') }}';
                                } else {
                                    return '{{ config('variable.currency') }} ' + data;

                                }
                            }
                        },
                        {
                            data: 'max_salary',
                            name: 'max_salary',
                            render: function(data) {
                                if ('{{ config('variable.currency_format') == 'suffix' }}') {
                                    return data + ' {{ config('variable.currency') }}';
                                } else {
                                    return '{{ config('variable.currency') }} ' + data;

                                }
                            }
                        },
                        {
                            data: 'percentage',
                            name: 'percentage',
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false
                        }
                    ],


                    "order": [],
                    'language': {
                        'lengthMenu': '_MENU_ {{ __('records per page') }}',
                        "info": '{{ trans('file.Showing') }} _START_ - _END_ (_TOTAL_)',
                        "search": '{{ trans('file.Search') }}',
                        'paginate': {
                            'previous': '{{ trans('file.Previous') }}',
                            'next': '{{ trans('file.Next') }}'
                        }
                    },
                    'columnDefs': [{
                            "orderable": false,
                            'targets': [0, 5],
                        },
                        {
                            'render': function(data, type, row, meta) {
                                if (type == 'display') {
                                    data =
                                        '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                                }

                                return data;
                            },
                            'checkboxes': {
                                'selectRow': true,
                                'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                            },
                            'targets': [0]
                        }
                    ],


                    'select': {
                        style: 'multi',
                        selector: 'td:first-child'
                    },
                    'lengthMenu': [
                        [10, 25, 50, -1],
                        [10, 25, 50, "All"]
                    ],
                    dom: '<"row"lfB>rtip',
                    buttons: [{
                            extend: 'pdf',
                            text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                            exportOptions: {
                                columns: ':visible:Not(.not-exported)',
                                rows: ':visible'
                            },
                        },
                        {
                            extend: 'csv',
                            text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                            exportOptions: {
                                columns: ':visible:Not(.not-exported)',
                                rows: ':visible'
                            },
                        },
                        {
                            extend: 'print',
                            text: '<i title="print" class="fa fa-print"></i>',
                            exportOptions: {
                                columns: ':visible:Not(.not-exported)',
                                rows: ':visible'
                            },
                        },
                        {
                            extend: 'colvis',
                            text: '<i title="column visibility" class="fa fa-eye"></i>',
                            columns: ':gt(0)'
                        },
                    ],
                });
                new $.fn.dataTable.FixedHeader(table_table);
            });


            $('#create_record').on('click', function() {

                $('.modal-title').text('{{ __('Tax List Info') }}');
                $('#action_button').val('{{ trans('file.Add') }}');
                $('#action').val('{{ trans('file.Add') }}');
                $('#formModal').modal('show');
            });

            $('#sample_form').on('submit', function(event) {
                event.preventDefault();
                if ($('#action').val() == '{{ trans('file.Add') }}') {

                    $.ajax({
                        url: "{{ route('tax.store') }}",
                        method: "POST",
                        data: new FormData(this),
                        contentType: false,
                        cache: false,
                        processData: false,
                        dataType: "json",
                        success: function(data) {
                            let html = '';
                            if (data.errors) {
                                html = '<div class="alert alert-danger">';
                                for (let count = 0; count < data.errors.length; count++) {
                                    html += '<p>' + data.errors[count] + '</p>';
                                }
                                html += '</div>';
                            }
                            if (data.success) {
                                html = '<div class="alert alert-success">' + data.success +
                                    '</div>';
                                $('#sample_form')[0].reset();
                                $('select').selectpicker('refresh');
                                $('.date').datepicker('update');
                                $('#tax-table').DataTable().ajax.reload();
                            }
                            $('#form_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        }
                    })
                }

                if ($('#action').val() == '{{ trans('file.Edit') }}') {
                    $.ajax({
                        url: "{{ route('tax.update') }}",
                        method: "POST",
                        data: new FormData(this),
                        contentType: false,
                        cache: false,
                        processData: false,
                        dataType: "json",
                        success: function(data) {
                            let html = '';
                            if (data.errors) {
                                html = '<div class="alert alert-danger">';
                                for (let count = 0; count < data.errors.length; count++) {
                                    html += '<p>' + data.errors[count] + '</p>';
                                }
                                html += '</div>';
                            }
                            if (data.success) {
                                html = '<div class="alert alert-success">' + data.success +
                                    '</div>';
                                setTimeout(function() {
                                    $('#formModal').modal('hide');
                                    $('.date').datepicker('update');
                                    $('select').selectpicker('refresh');
                                    $('#tax-table').DataTable().ajax.reload();
                                    $('#sample_form')[0].reset();
                                }, 2000);

                            }
                            $('#form_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        }
                    });
                }
            });

            $(document).on('click', '.show_new', function() {

                let id = $(this).attr('id');
                $('#form_result').html('');

                let target = '{{ route('tax.index') }}/' + id;

                $.ajax({
                    url: target,
                    dataType: "json",
                    success: function(result) {

                        $('#company_name_id').html(result.data.company.company_name);
                        if ('{{ config('variable.currency_format') == 'suffix' }}') {
                            $('#min_salary_id').html(result.data.min_salary_formatted + ' {{ config('variable.currency') }}');
                            $('#max_salary_id').html(result.data.max_salary_formatted + ' {{ config('variable.currency') }}');
                        } else {
                            $('#min_salary_id').html('{{ config('variable.currency') }} ' + result.data.min_salary_formatted );
                            $('#max_salary_id').html('{{ config('variable.currency') }} ' + result.data.max_salary_formatted );
                        }
                        $('#percentage_id').html(result.data.percentage + ' %');

                        $('#tax_modal').modal('show');
                        $('.modal-title').text("{{ __('Tax List Info') }}");
                    }
                });
            });


            $(document).on('click', '.edit', function() {

                let id = $(this).attr('id');
                $('#form_result').html('');

                let target = "{{ route('tax.index') }}/" + id + '/edit';


                $.ajax({
                    url: target,
                    dataType: "json",
                    success: function(html) {
                        console.log(html.data);

                        $('#name').val(html.data.name);
                        $('#company_name').val(html.data.company.name);
                        $('#min_salary').val(html.data.min_salary);
                        $('#max_salary').val(html.data.max_salary);
                        $('#percentage').val(html.data.percentage);
                        $('#company_id').selectpicker('val', html.data.company_id);

                        $('#hidden_id').val(html.data.id);
                        $('.modal-title').text('{{ trans('file.Edit') }}');
                        $('#action_button').val('{{ trans('file.Edit') }}');
                        $('#action').val('{{ trans('file.Edit') }}');
                        $('#formModal').modal('show');
                    }
                })
            });


            let delete_id;

            $(document).on('click', '.delete', function() {
                delete_id = $(this).attr('id');
                $('#confirmModal').modal('show');
                $('.modal-title').text('{{ __('DELETE Record') }}');
                $('#ok_button').text('{{ trans('file.OK') }}');

            });


            $(document).on('click', '#bulk_delete', function() {

                let id = [];
                let table = $('#tax-table').DataTable();
                id = table.rows({
                    selected: true
                }).ids().toArray();
                if (id.length > 0) {
                    if (confirm('{{ __('Delete Selection', ['key' => __('Tax List')]) }}')) {
                        $.ajax({
                            url: '{{ route('mass_delete_tax') }}',
                            method: 'POST',
                            data: {
                                taxIdArray: id
                            },
                            success: function(data) {
                                let html = '';
                                if (data.success) {
                                    html = '<div class="alert alert-success">' + data.success +
                                        '</div>';
                                }
                                if (data.error) {
                                    html = '<div class="alert alert-danger">' + data.error +
                                        '</div>';
                                }
                                table.ajax.reload();
                                table.rows('.selected').deselect();
                                if (data.errors) {
                                    html = '<div class="alert alert-danger">' + data.error +
                                        '</div>';
                                }
                                $('#general_result').html(html).slideDown(300).delay(5000).slideUp(
                                    300);

                            }

                        });
                    }
                } else {

                }
            });


            $('#close').on('click', function() {
                $('#sample_form')[0].reset();
                $('select').selectpicker('refresh');
                $('.date').datepicker('update');
                $('#tax-table').DataTable().ajax.reload();
            });

            $('#ok_button').on('click', function() {
                let target = "{{ route('tax.index') }}/" + delete_id + '/delete';
                $.ajax({
                    url: target,
                    beforeSend: function() {
                        $('#ok_button').text('{{ trans('file.Deleting...') }}');
                    },
                    success: function(data) {
                        let html = '';
                        if (data.success) {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                        }
                        if (data.error) {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        setTimeout(function() {
                            $('#general_result').html(html).slideDown(300).delay(5000)
                                .slideUp(300);
                            $('#confirmModal').modal('hide');
                            $('#tax-table').DataTable().ajax.reload();
                        }, 2000);
                    }
                })
            });

        })(jQuery);
    </script>
@endpush
