
    $('#salary_kehadiran_table').DataTable().clear().destroy();

    var table_table = $('#salary_kehadiran_table').DataTable({
        initComplete: function () {
            this.api().columns([0]).every(function () {
                var column = this;
                var select = $('<select><option value=""></option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex(
                            $(this).val()
                        );

                        column
                            .search(val ? '^' + val + '$' : '', true, false)
                            .draw();
                    });

                column.data().unique().sort().each(function (d, j) {
                    select.append('<option value="' + d + '">' + d + '</option>');
                    $('select').selectpicker('refresh');
                });
            });
        },
        responsive: true,
        fixedHeader: {
            header: true,
            footer: true
        },
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('salary_kehadiran.show',$employee->id) }}",
        },

        columns: [

            {
                data: 'month_year',
                name: 'month_year',
            },
            {
                data: 'payslip_type',
                name: 'payslip_type',
            },
            {
                data: 'salary_kehadiran_formatted',
                name: 'salary_kehadiran_formatted',
                render: function (data) {
                    if ('{{config('variable.currency_format') =='suffix'}}') {
                        return data + ' {{config('variable.currency')}}';
                    } else {
                        return '{{config('variable.currency')}} ' + data;

                    }
                }
            },
            {
                data: 'action',
                name: 'action',
                orderable: false
            }
        ],


        "order": [],
        'language': {
            'lengthMenu': '_MENU_ {{__('records per page')}}',
            "info": '{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)',
            "search": '{{trans("file.Search")}}',
            'paginate': {
                'previous': '{{trans("file.Previous")}}',
                'next': '{{trans("file.Next")}}'
            }
        },
        'columnDefs': [
            {
                "orderable": false,
                'targets': [0, 3],
            },
        ],


        {{-- 'select': {style: 'multi', selector: 'td:first-child'}, --}}
        'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
    });
    new $.fn.dataTable.FixedHeader(table_table);


    $('#create_salary_kehadiran_record').click(function () {

        $('.modal-title').text('{{__('Tambah Besaran Uang Kehadiran')}}');
        $('#salary_kehadiran_action_button').val('{{trans('file.Add')}}');
        $('#salary_kehadiran_action').val('{{trans('file.Add')}}');
        $('#salaryKehadiranformModal').modal('show');
    });

    $('#salary_kehadiran_sample_form').on('submit', function (event) {
        event.preventDefault();
        if ($('#salary_kehadiran_action').val() == '{{trans('file.Add')}}') {

            $.ajax({
                url: "{{ route('salary_kehadiran.store',$employee) }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                cache: false,
                processData: false,
                dataType: "json",
                success: function (data) {
                    var html = '';
                    if (data.errors) {
                        html = '<div class="alert alert-danger">';
                        for (var count = 0; count < data.errors.length; count++) {
                            html += '<p>' + data.errors[count] + '</p>';
                        }
                        html += '</div>';
                    }
                    if (data.check_month_year) {
                        html = '<div class="alert alert-danger">' + data.check_month_year + '</div>';
                    }
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                        $('#salary_kehadiran_sample_form')[0].reset();
                        $('select').selectpicker('refresh');
                        $('#salary_kehadiran_table').DataTable().ajax.reload();
                    }
                    $('#salary_kehadiran_form_result').html(html).slideDown(300).delay(5000).slideUp(300);
                }
            });
        }

        if ($('#salary_kehadiran_action').val() == '{{trans('file.Edit')}}') {
            $.ajax({
                url: "{{ route('salary_kehadiran.update') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                cache: false,
                processData: false,
                dataType: "json",
                success: function (data) {
                    var html = '';
                    if (data.errors) {
                        html = '<div class="alert alert-danger">';
                        for (var count = 0; count < data.errors.length; count++) {
                            html += '<p>' + data.errors[count] + '</p>';
                        }
                        html += '</div>';
                    }
                    if (data.check_month_year) {
                        html = '<div class="alert alert-danger">' + data.check_month_year + '</div>';
                    }

                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                        setTimeout(function () {
                            $('#salaryKehadiranformModal').modal('hide');
                            $('select').selectpicker('refresh');
                            $('#salary_kehadiran_table').DataTable().ajax.reload();
                            $('#salary_kehadiran_sample_form')[0].reset();
                        }, 2000);

                    }
                    $('#salary_kehadiran_form_result').html(html).slideDown(300).delay(5000).slideUp(300);
                }
            });
        }
    });


    $(document).on('click', '.salary_kehadiran_table_edit', function () {

        var id = $(this).data("id");
        var target = "{{ route('salary_kehadiran.index') }}/" + id + '/edit';

        $.ajax({
            url: target,
            dataType: "json",
            success: function (html) {
                $('#employee_id').val(html.data.employee_id);
                $('#month_year').val(html.data.month_year);
                $('#payslip_type_edit').selectpicker('val', html.data.payslip_type);
                $('#salary_kehadiran_edit').val(html.data.salary_kehadiran);

                $('#salary_kehadiran_hidden_id').val(html.data.id);
                $('.modal-title').text('{{trans('file.Edit')}}');
                $('#salary_kehadiran_action_button').val('{{trans('file.Edit')}}');
                $('#salary_kehadiran_action').val('{{trans('file.Edit')}}');
                $('#salaryKehadiranformModal').modal('show');
            }
        })
    });


    {{-- let allowance_delete_id; --}}

    $(document).on('click', '.salary_kehadiran_delete', function () {
    salary_kehadiran_delete_id = $(this).data("id");
        $('.modal-title').text('{{__('DELETE Record')}}');
        $('.basic-ok').text('{{trans('file.OK')}}');
        {{-- $('.confirmModal').modal('show'); --}}
        $('#confirmModal').modal('show');
    });


    $('.salary_kehadiran-close').click(function () {
        $('#salary_kehadiran_sample_form')[0].reset();
        $('select').selectpicker('refresh');
        $('.confirmModal').modal('hide');
        $('#salary_kehadiran_table').DataTable().ajax.reload();
    });

    $('.basic-ok').click(function () {
        let target = "{{ route('salary_kehadiran.index') }}/" + salary_kehadiran_delete_id + '/delete';
        $.ajax({
            url: target,
            beforeSend: function () {
                $('.basic-ok').text('{{trans('file.Deleting...')}}');
            },
            success: function (data) {
                setTimeout(function () {
                    $('#confirmModal').modal('hide');
                    $('#salary_kehadiran_table').DataTable().ajax.reload();
                }, 2000);
            }
        })
    });
