<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Export Pay Slip</title>
    <style>
    </style>
</head>

<body>
    <table STYLE="border:">
        <thead>
            @if($company != null)
                <tr><th colspan="23" style="text-align:center; vertical-align: middle;">{{ $company['name'] }}</th></tr>
                <tr><th colspan="23" style="text-align:center; vertical-align: middle;">{{ $company['department'] }}</th></tr>
                <tr></tr>
            @else
            @endif
            <tr><th>{{ $selected_date }}</th></tr>
            <tr>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">No</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Nama Karyawan</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Status</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Tanggungan</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Jabatan</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Departemen</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Perusahaan</th>
                <th colspan="5" style="text-align:center; vertical-align: middle;">Penghasilan</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">PPH</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">BPJS Kesehatan</th>
                <th colspan="4" style="text-align:center; vertical-align: middle;">BPJS Ketenagakerjaan</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Utang</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Statutory<br />Deduction</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Absensi</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Gaji Bersih</th>
                <th rowspan="2" style="text-align:center; vertical-align: middle;">Status Pembayaran</th>
            </tr>
            <tr>
                <th style="text-align:center; vertical-align: middle;">Gaji Pokok</th>
                <th style="text-align:center; vertical-align: middle;">Tunjangan</th>
                <th style="text-align:center; vertical-align: middle;">Komisi</th>
                <th style="text-align:center; vertical-align: middle;">Lembur</th>
                <th style="text-align:center; vertical-align: middle;">Other <br />Payment</th>
                <th style="text-align:center; vertical-align: middle;">BPJS Pensiun</th>
                <th style="text-align:center; vertical-align: middle;">BPJS JHT</th>
                <th style="text-align:center; vertical-align: middle;">BPJS JKK</th>
                <th style="text-align:center; vertical-align: middle;">BPJS JKM</th>
            </tr>
        <thead>
        <tbody>
            @php $no = 1; @endphp
            @foreach($employees as $employee)
                <tr>
                    <td style="text-align:center;;">{{ $no }}</td>
                    <td>{{ $employee->first_name }} {{ $employee->last_name }}</td>
                    <td style="text-align:center;">{{ $employee->marital_status }}</td>
                    <td style="text-align:center;">{{ $employee->dependent }}</td>
                    <td>{{ $employee->designation->designation_name }}</td>
                    <td>{{ $employee->department->department_name }}</td>
                    <td>{{ $employee->company->company_name }}</td>
                    <td>
                    @php
                        foreach ($employee->salaryBasic as $salaryBasic) {
							if ($salaryBasic->first_date <= $first_date) {
								$basicsalary = $salaryBasic->basic_salary; //basic salary
								$basicsalary =  $basicsalary;
							}
						}
                    @endphp
                        {{ $basicsalary }}
                    </td>
                    <td>
                        @php
                            $prev_month = \Carbon\Carbon::createFromFormat('Y-m-d', $first_date)->subMonth();
                            $cut_off_start = $prev_month->day(16);
                            $cut_off_end = \Carbon\Carbon::createFromFormat('Y-m-d', $first_date)->day(15);
                            $attendances = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end);
                            $work_days = $attendances->count();
                            $number_cut = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end)->whereIn('status', ['TA1', 'TA2', 'TA3'])->where('is_checked', 0)->count();
                            if($work_days == 0) {
                                $salary_cut_amount = 0;
                            } else {
                                $salary_cut_amount = $basicsalary/$work_days*$number_cut;
                            }
                            $type              = "getAmount";
                            $allowance_amount = 0;
			                if (!$employee->allowances->isEmpty()) {
				                foreach ($employee->allowances as $item) {
					                if ($item->first_date <= $first_date) {
						                foreach ($employee->allowances as $value) {
							                if ($value->first_date <= $first_date) {
								                $allowance_amount += $value->allowance_amount*$work_days;
							                }
						                }
					                }
				                }
			                }
                        @endphp
                        {{ $allowance_amount }}
                    </td>
                    <td>
                        {{ $employee->commissions->sum('commission_amount') }}
                    </td>
                    <td>
                        {{ $employee->overtimes->sum('overtime_amount') }}
                    </td>
                    <td>
                        {{ $employee->otherPayments->sum('other_payment_amount') }}
                    </td>
                    <td>
                        @php
                            $jht = App\BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
                            $pensiun = App\BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
                            $jkk = App\BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
                            $jkm = App\BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
                            $nilai_jht = $basicsalary*$jht->employee/100;
                            $nilai_jkk = $basicsalary*$jkk->employee/100;
                            $nilai_jkm = $basicsalary*$jkm->employee/100;
                            $nilai_pensiun = $basicsalary*$pensiun->employee/100;
                            $pension_amount = $nilai_jht+$nilai_pensiun;
                            $biaya_jabatan = $basicsalary*5/100;
                            $net_salary_year = ($basicsalary-$biaya_jabatan-$pension_amount)*12;
                            if($net_salary_year > $employee->ptkp) {
                                $pkp_yearly = $net_salary_year-$employee->ptkp;
                                $tax = App\Tax::where('min_salary', '<=', $pkp_yearly)->where('max_Salary', '>=', $pkp_yearly)->first();
                                $pph_percentage = $tax->percentage;
                            } else {
                                $pkp_yearly = $net_salary_year;
                                $pph_percentage = 0;
                            }
                            $pph_yearly = $pph_percentage*$pkp_yearly/100;
                            $pph_monthly = $pph_yearly/12;
                        @endphp
                        {{$pph_monthly}}
                    </td>
                    <td>
                        @php
                             $bpjskes = App\BPJSKes::where('company_id', $employee->company_id)->where('name', 'Kesehatan')->first();
                             $nilai_kes = $basicsalary*$bpjskes->employee/100;
                        @endphp
                        {{ $nilai_kes }}
                    </td>
                    <td>
                        {{ $basicsalary*$pensiun->employee/100 }}
                    </td>
                    <td>
                        {{ $nilai_jht }}
                    </td>
                    <td>
                        {{ $nilai_jkk }}
                    </td>
                    <td>
                        {{ $nilai_jkm }}
                    </td>
                    <td>
                        @if($employee->loans->isEmpty())
                            0
                        @else
                           $employee->loans->monthly_payable 
                        @endif
                    </td>
                    <td>
                        @php
                            $deduction_amount = 0;
			                if (!$employee->deductions->isEmpty()) {
				                foreach ($employee->deductions as $item) {
					                if ($item->first_date <= $first_date) {
						                $deduction_amount = 0;
						                foreach ($employee->deductions as $value) {
							                if ($value->first_date <= $first_date) {
								                if ($item->first_date == $value->first_date) {
									                $deduction_amount += $value->deduction_amount;
								                }
							                }
						                }
					                }
				                }
			                }
                        @endphp
                        {{ $deduction_amount }}
                    </td>
                    <td>
                        @php
                            $number_cut = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end)->whereIn('status', ['TA1', 'TA2', 'TA3'])->where('is_checked', 0)->count();
                            if($work_days == 0) {
                                $salary_cut_amount = 0;
                            } else {
                                $salary_cut_amount = $basicsalary/$work_days*$number_cut;
                            }
                        @endphp
                        {{ number_format($salary_cut_amount, '0', ',', '') }}
                    </td>
                    <td>
                        {{ number_format($basicsalary - $pph_monthly + $allowance_amount + $employee->commissions->sum('commission_amount') - $employee->loans->sum('monthly_payable') - $deduction_amount - $pension_amount - $nilai_jkk - $nilai_jkm - $nilai_kes - $salary_cut_amount + $employee->otherPayments->sum('other_payment_amount') + $employee->overtimes->sum('overtime_amount'), '0', ',', '') }}
                    </td>
                    <td>
                        @if(!$employee->payslips->isEmpty())
                            Paid
                        @else
                            Unpaid
                        @endif
                    </td>
                </tr>
                @php $no++; @endphp
            @endforeach
        </tbody>
    </table>
</body>

</html>
