@extends('layout.main')
@section('content')
    <section>
        <div class="container-fluid">
            <div class="card mb-4">
                <div class="card-header with-border">
                    <h3 class="card-title text-center"> {{ __('Full Report Attendance') }} </h3>
                </div>
                <div class="card-body">
                    <a href="{{ route('report_attendance.export') }}"> <button class="btn btn-success"><i
                                class="fa fa-file"></i>
                            {{ __('Download Excel') }}
                        </button> </a>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table id="report_attendance-table" class="table ">
            </table>
        </div>

    </section>
    <script type="text/javascript">
        (function($) {
            "use strict";

            fill_datatable();

            function fill_datatable() {
                $.ajax({
                    url: "{{ route('full_report_attendance.header') }}",
                    data: {
                        date: "{{ $date }}",
                        "_token": "{{ csrf_token() }}",
                    },
                    success: function(data) {
                        var lastMonth = getLastMonth()
                        var columns = [];
                        columns.push({
                            "data": "employee_name",
                            "title": "Employee"
                        })
                        columns.push({
                            "data": "remaining_leave_last_month",
                            "title": "Remaining Leaves " + lastMonth
                        })
                        columns.push({
                            "data": "department",
                            "title": "Department"
                        })
                        for (var i in data['dates']) {
                            columns.push({
                                "data": data['dates'][i],
                                "title": data['dates'][i]
                            })
                        }
                        columns.push({
                            "data": "total_s",
                            "title": "Total S"
                        })
                        columns.push({
                            "data": "total_i",
                            "title": "Total I"
                        })
                        columns.push({
                            "data": "total_c",
                            "title": "Total C"
                        })
                        columns.push({
                            "data": "total_m",
                            "title": "Total M"
                        })
                        columns.push({
                            "data": "total_c1",
                            "title": "Total C1"
                        })
                        columns.push({
                            "data": "total_c2",
                            "title": "Total C2"
                        })
                        columns.push({
                            "data": "total_c3",
                            "title": "Total C3"
                        })
                        columns.push({
                            "data": "total_c4",
                            "title": "Total C4"
                        })
                        columns.push({
                            "data": "total_dl",
                            "title": "Total DL"
                        })
                        columns.push({
                            "data": "total_ik1",
                            "title": "Total IK1"
                        })
                        columns.push({
                            "data": "total_ik2",
                            "title": "Total IK2"
                        })
                        columns.push({
                            "data": "total_it1",
                            "title": "Total IT1"
                        })
                        columns.push({
                            "data": "total_it2",
                            "title": "Total IT2"
                        })
                        columns.push({
                            "data": "total_ip",
                            "title": "Total IP"
                        })
                        columns.push({
                            "data": "total_ta1",
                            "title": "Total TA1"
                        })
                        columns.push({
                            "data": "total_ta2",
                            "title": "Total TA2"
                        })
                        columns.push({
                            "data": "total_ta3",
                            "title": "Total TA3"
                        })
                        columns.push({
                            "data": "total_dis",
                            "title": "Total DIS"
                        })
                        columns.push({
                            "data": "total_pg",
                            "title": "Total PG"
                        })
                        columns.push({
                            "data": "remaining_leave",
                            "title": "Remaining Leaves"
                        })
                        let holidays = data['holidays'];
                        let table_table = $('#report_attendance-table').DataTable({
                            processing: true,
                            serverSide: true,
                            ajax: {
                                url: "{{ url('timesheet/full_report_attendances/data') }}",
                                type: 'POST',
                                data: {
                                    company_id: "{{ $companies }}",
                                    date: "{{ $date }}",
                                    "_token": "{{ csrf_token() }}"
                                },
                            },
                            columns: columns,
                            createdRow: (row, data, dataIndex, cells) => {
                                holidays.forEach(element => {
                                    $(cells[element]).css('background-color', '#FFFF00')
                                });
                            },
                            'language': {
                                'lengthMenu': '_MENU_ {{ __('records per page') }}',
                                "info": '{{ trans('file.Showing') }} _START_ - _END_ (_TOTAL_)',
                                "search": '{{ trans('file.Search') }}',
                                'paginate': {
                                    'previous': '{{ trans('file.Previous') }}',
                                    'next': '{{ trans('file.Next') }}'
                                }
                            },
                            'lengthMenu': [
                                [10, 25, 50, -1],
                                [10, 25, 50, "All"]
                            ],
                            scrollY: "400px",
                            scrollX: true,
                            scrollCollapse: true,
                            paging: false,
                            dom: 'Bfrtip',
                            buttons: [{
                                text: 'Excel',
                                extend: 'excelHtml5'
                            }]
                        });
                    }
                });
            }

            function getLastMonth() {
                const monthNames = ["January", "February", "March", "April", "May", "June",
                    "July", "August", "September", "October", "November", "December"
                ];

                var date = "{{ $date }}";
                let d;
                if (date == undefined) {
                    d = new Date();
                } else {
                    var dates = date.split("-");
                    d = new Date(parseInt(dates[0]), parseInt(dates[1], 10) - 1, parseInt(dates[2], 10));
                }
                if (d.getMonth == 0) {
                    return "December";
                }
                return monthNames[d.getMonth() - 1];
            }
        })(jQuery);
    </script>
@endsection
