<?php if(auth()->user()->can('store-details-employee') || auth()->user()->id == $employee->id): ?>
    <div class="modal-body">
        <span id="setting_form_result"></span>
        <form method="post" id="setting_sample_form" class="form-horizontal"
            action="<?php echo e(route('general_setting.store', $employee->id)); ?>">

            <?php echo csrf_field(); ?>
            <div class="row">

                <div class="col-md-12 form-group">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="is_bpjs_tk" name="is_bpjs_tk" value="1">
                        <label class="form-check-label" for="is_bpjs_tk">
                            <?php echo e(__('Include BPJS TK')); ?>

                        </label>
                    </div>
                </div>
                <div class="col-md-12 form-group">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox"value="1" id="is_bpjs_kes"
                            name="is_bpjs_kes">
                        <label class="form-check-label" for="is_bpjs_kes">
                            <?php echo e(__('Include BPJS KES')); ?>

                        </label>
                    </div>
                </div>
                <div class="col-md-12 form-group">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="1" id="is_tax" name="is_tax">
                        <label class="form-check-label" for="is_tax">
                            <?php echo e(__('Include Tax')); ?>

                        </label>
                    </div>
                </div>

                <div class="form-group row">
                    <div class="form-group row mb-0">
                        <div class="col-md-6 offset-md-4">
                            <button type="submit" class="btn btn-primary">
                                <?php echo e(trans('file.Save')); ?>

                            </button>
                        </div>
                    </div>
                </div>


            </div>
        </form>
    </div>
<?php endif; ?>

<script type="text/javascript">
    $(document).ready(function() {
        if ("<?php echo e($employee->setting != null && $employee->setting->is_bpjs_tk_include); ?>") {
            $('#is_bpjs_tk').prop('checked', true);
        } else {
            $('#is_bpjs_tk').prop('checked', false);
        }
        if ("<?php echo e($employee->setting != null && $employee->setting->is_bpjs_kes_include); ?>") {
            $('#is_bpjs_kes').prop('checked', true);
        } else {
            $('#is_bpjs_kes').prop('checked', false);
        }
        if ("<?php echo e($employee->setting != null && $employee->setting->is_tax_include); ?>") {
            $('#is_tax').prop('checked', true);
        } else {
            $('#is_tax').prop('checked', false);
        }
        $(".alert").slideDown(300).delay(5000).slideUp(300);
    });

    var formSetting = $('#setting_sample_form');


    formSetting.submit(function(event) {
        event.preventDefault();
        $.ajax({
            type: formSetting.attr('method'),
            url: formSetting.attr('action'),
            data: formSetting.serialize(),
            success: function(data) {
                var html = '';
                if (data.errors) {
                    html = '<div class="alert alert-danger">';
                    for (var count = 0; count < data.errors.length; count++) {
                        html += '<p>' + data.errors[count] + '</p>';
                    }
                    html += '</div>';
                }
                if (data.success) {
                    html = '<div class="alert alert-success">' + data.success + '</div>';
                }
                $('#setting_form_result').html(html);

            }
        });
    });
</script>
<?php /**PATH C:\laragon\www\hr-management-rulli-2\resources\views/employee/general_setting/index.blade.php ENDPATH**/ ?>