<?php $__env->startSection('content'); ?>

    <section>
        <span id="form_result_home"></span>
        <div class="container-fluid">
            <div class="card mb-4">
                <div class="card-header with-border">
                    <h3 class="card-title text-center"> <?php echo e(__(' Attendance')); ?> </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <form method="post" id="filter_form" class="form-horizontal">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <?php if(Auth::user()->can('attendances')): ?>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo e(trans('file.Company')); ?> *</label>
                                                <select name="company_id" id="company_id"
                                                    class="form-control selectpicker dynamic" required
                                                    data-live-search="true" data-live-search-style="contains"
                                                    data-first_name="first_name" data-last_name="last_name"
                                                    data-dependent="department_name"
                                                    title='<?php echo e(__('Selecting', ['key' => trans('file.Company')])); ?>...'>
                                                    <?php ($i = 0); ?>
                                                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($company->id); ?>" <?php if($i == 0): ?> selected <?php endif; ?>><?php echo e($company->company_name); ?>

                                                        </option>
                                                    <?php ($i++); ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-6 form-group">
                                            <label><?php echo e(trans('file.Department')); ?></label>
                                            <select name="department_id" id="department_id"
                                                class="selectpicker form-control department_wise_employees"
                                                data-live-search="true" data-live-search-style="contains"
                                                data-first_name="first_name" data-last_name="last_name"
                                                title="<?php echo e(__('Selecting', ['key' => trans('file.Department')])); ?>...">
                                            </select>
                                        </div>
                                    <?php else: ?>
                                        <input type="hidden" name="employee_id" id="employee_id"
                                            value="<?php echo e(Auth::user()->id); ?>"> 
                                    <?php endif; ?>

                                    <div class="col-md-6 form-group">
                                        <label><?php echo e(__('Month Year')); ?> *</label>
                                        <input class="form-control month_year" id="month_year" name="month_year"
                                            type="text">
                                    </div>

                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="form-actions">
                                                <button type="submit" class="filtering btn btn-primary"><i
                                                        class="fa fa-search"></i> <?php echo e(trans('file.Search')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <button id="btn-add" class="btn btn-success"><i class="fa fa-plus"></i>
                                <?php echo e(__('Add Raw Attendances')); ?>

                            </button>
                            <button id="btn-process" class="btn btn-info"><i class="fa fa-wrench"></i>
                                <?php echo e(__('Process Raw Attendances')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table id="raw_attendance-table" class="table ">
                <thead>
                    <tr>
                        <th></th>
                        <th><?php echo e(__('Employee')); ?></th>
                        <th><?php echo e(__('Attendance Date')); ?></th>
                        <th><?php echo e(__('Attendance Time')); ?></th>
                        <th class="not-exported"><?php echo e(trans('file.action')); ?></th>
                    </tr>
                </thead>
            </table>
        </div>

    </section>

    <div id="formModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title"><?php echo e(__('Add Raw Attendance')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <span id="form_result"></span>
                    <form method="post" id="sample_form" class="form-horizontal" enctype="multipart/form-data">

                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo e(trans('file.Company')); ?></label>
                                    <select name="company_id" id="company_add_id"
                                        class="form-control selectpicker dynamic_add" data-live-search="true"
                                        data-live-search-style="contains" data-dependent="department_name"
                                        title='<?php echo e(__('Selecting', ['key' => trans('file.Company')])); ?>...'>
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->company_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo e(trans('file.Department')); ?></label>
                                    <select name="department_id" id="department_add_id"
                                        class="selectpicker form-control employee" data-live-search="true"
                                        data-live-search-style="contains" data-first_name="first_name"
                                        data-last_name="last_name"
                                        title='<?php echo e(__('Selecting', ['key' => trans('file.Department')])); ?>...'>

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo e(trans('file.Employee')); ?></label>
                                    <select name="employee_id" id="employee_add_id" class="selectpicker form-control"
                                        data-live-search="true" data-live-search-style="contains"
                                        title='<?php echo e(__('Selecting', ['key' => trans('file.Employee')])); ?>...'>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 form-group">
                                <label><?php echo e(__('Attendance Date')); ?></label>
                                <input class="form-control date" id="attendance_date" name="attendance_date"
                                    type="text">
                            </div>
                            <div class="col-md-6 form-group">
                                <label><?php echo e(__('Attendance Time')); ?></label>
                                <input type="text" name="attendance_time" id="attendance_time"
                                    class="form-control time" placeholder="<?php echo e(__('Attendance Time')); ?>">
                            </div>

                            <div class="container">
                                <div class="form-group" align="center">
                                    <input type="hidden" name="action" id="action" />
                                    <input type="hidden" name="hidden_id" id="hidden_id" />
                                    <input type="submit" name="action_button" id="action_button"
                                        class="btn btn-warning w-100" value="<?php echo e(trans('file.Add')); ?>" />
                                </div>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>

    
    

    <script type="text/javascript">
        (function($) {
            "use strict";
            $(document).ready(function() {

                let date = $('.date');
                date.datepicker({
                    format: '<?php echo e(env('Date_Format_JS')); ?>',
                    autoclose: true,
                    todayHighlight: true,
                    endDate: new Date()
                });

                $('.time').clockpicker({
                    placement: 'top',
                    align: 'left',
                    donetext: 'done',
                    twelvehour: true,
                });
            });

            fill_datatable();

            function fill_datatable(company_id = '', department_id = '',
                filter_month_year = '') {

                let table_table = $('#raw_attendance-table').DataTable({
                    responsive: true,
                    fixedHeader: {
                        header: true,
                    },
                    processing: true,
                    serverSide: true,
                    deferRender: false,
                    ajax: {
                        url: "<?php echo e(route('raw_attendances.index')); ?>",
                        data: {
                            filter_month_year: filter_month_year,
                            company_id: company_id,
                            department_id: department_id,
                            "_token": "<?php echo e(csrf_token()); ?>"
                        }
                    },

                    columns: [{
                            data: null,
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'employee_name',
                            name: 'employee_name'
                        },
                        {
                            data: 'attendance_date',
                            name: 'attendance_date',
                        },
                        {
                            data: 'attendance_time',
                            name: 'attendance_time'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false
                        }
                    ],


                    "order": [],
                    'language': {
                        'lengthMenu': '_MENU_ <?php echo e(__('records per page')); ?>',
                        "info": '<?php echo e(trans('file.Showing')); ?> _START_ - _END_ (_TOTAL_)',
                        "search": '<?php echo e(trans('file.Search')); ?>',
                        'paginate': {
                            'previous': '<?php echo e(trans('file.Previous')); ?>',
                            'next': '<?php echo e(trans('file.Next')); ?>'
                        }
                    },

                    'columnDefs': [{

                            "orderable": true,
                            // 'targets': [0, 10],
                        },
                        {
                            'render': function(data, type, row, meta) {
                                if (type == 'display') {
                                    data =
                                        '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                                }

                                return data;
                            },
                            'checkboxes': {
                                'selectRow': true,
                                'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                            },
                            'targets': [0]
                        }
                    ],


                    'select': {
                        style: 'multi',
                        selector: 'td:first-child'
                    },
                    'lengthMenu': [
                        [10, 25, 50, -1],
                        [10, 25, 50, "All"]
                    ],
                    dom: '<"row"lfB>rtip',
                    buttons: [{
                            extend: 'pdf',
                            text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                            exportOptions: {
                                columns: ':visible:Not(.not-exported)',
                                rows: ':visible'
                            },
                            footer: true
                        },
                        {
                            extend: 'csv',
                            text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                            exportOptions: {
                                columns: ':visible:Not(.not-exported)',
                                rows: ':visible'
                            },
                            footer: true
                        },
                        {
                            extend: 'print',
                            text: '<i title="print" class="fa fa-print"></i>',
                            exportOptions: {
                                columns: ':visible:Not(.not-exported)',
                                rows: ':visible'
                            },
                            footer: true
                        },
                        {
                            extend: 'colvis',
                            text: '<i title="column visibility" class="fa fa-eye"></i>',
                            columns: ':gt(0)'
                        },
                    ],
                });
                new $.fn.dataTable.FixedHeader(table_table);
            }

            function datatable_sum(dt_selector, columnNo) {
                var rows = dt_selector.rows().indexes();
                var rowsdataCol = dt_selector.cells(rows, columnNo, {
                    page: 'current'
                }).data();

                var totalMinutes = 0;
                for (let i = 0; i < rowsdataCol.length; i++) {
                    if (rowsdataCol[i] != "---") {
                        var timeArray = rowsdataCol[i].split(":");
                        totalMinutes += parseInt(timeArray[0] * 60) + parseInt(timeArray[1]);
                    }
                }
                var hours = Math.trunc(totalMinutes / 60);
                var minutes = totalMinutes % 60;

                var result = digitCheck(hours) + ':' + digitCheck(minutes);
                $(dt_selector.column(columnNo).footer()).html(result);
            }

            function digitCheck(data) {
                if (data < 10) {
                    var result = '0' + data;
                } else {
                    var result = data;
                }
                return result;
            }

            $('#sample_form').on('submit', function(event) {
                event.preventDefault();
                if ($('#action').val() == '<?php echo e(trans('file.Add')); ?>') {

                    $.ajax({
                        url: "<?php echo e(route('raw_attendances.store')); ?>",
                        method: "POST",
                        data: new FormData(this),
                        contentType: false,
                        cache: false,
                        processData: false,
                        dataType: "json",
                        success: function(data) {
                            let html = '';
                            if (data.errors) {
                                html = '<div class="alert alert-danger">';
                                for (let count = 0; count < data.errors.length; count++) {
                                    html += '<p>' + data.errors[count] + '</p>';
                                }
                                html += '</div>';
                            }
                            if (data.success) {
                                html = '<div class="alert alert-success">' + data.success +
                                    '</div>';
                                $('#sample_form')[0].reset();
                                $('select').selectpicker('refresh');
                                $('.date').datepicker('update');
                                $('#raw_attendance-table').DataTable().ajax.reload();
                            }
                            $('#form_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        }
                    })
                }

                if ($('#action').val() == '<?php echo e(trans('file.Edit')); ?>') {
                    $.ajax({
                        url: "<?php echo e(route('raw_attendances.update')); ?>",
                        method: "POST",
                        data: new FormData(this),
                        contentType: false,
                        cache: false,
                        processData: false,
                        dataType: "json",
                        success: function(data) {
                            let html = '';
                            if (data.errors) {
                                html = '<div class="alert alert-danger">';
                                for (let count = 0; count < data.errors.length; count++) {
                                    html += '<p>' + data.errors[count] + '</p>';
                                }
                                html += '</div>';
                            }
                            if (data.success) {
                                html = '<div class="alert alert-success">' + data.success +
                                    '</div>';
                                setTimeout(function() {
                                    $('#formModal').modal('hide');
                                    $('.date').datepicker('update');
                                    $('select').selectpicker('refresh');
                                    $('#raw_attendance-table').DataTable().ajax.reload();
                                    $('#sample_form')[0].reset();
                                }, 2000);

                            }
                            $('#form_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        }
                    });
                }
            });

            $(document).on('click', '.edit', function() {

                let id = $(this).attr('id');
                $('#form_result').html('');

                let target = "<?php echo e(url('timesheet/raw_attendances')); ?>/" + id;

                $.ajax({
                    url: target,
                    dataType: "json",
                    success: function(html) {
                        console.log(html)

                        $('#company_add_id').selectpicker('val', html.data.employee.company_id);
                        $('#company_add_id').attr('disabled', true);

                        let all_departments = '';
                        $.each(html.departments, function(index, value) {
                            all_departments += '<option value=' + value['id'] + '>' + value[
                                'department_name'] + '</option>';
                        });
                        $('#department_add_id').empty().append(all_departments);
                        $('#department_add_id').selectpicker('refresh');
                        $('#department_add_id').selectpicker('val', html.data.employee.department_id);
                        $('#department_add_id').selectpicker('refresh');
                        $('#department_add_id').attr('disabled', true);

                        let all_employees = '';
                        $.each(html.employees, function(index, value) {
                            all_employees += '<option value=' + value['id'] + '>' + value[
                                'first_name'] + ' ' + value['last_name'] + '</option>';
                        });
                        $('#employee_add_id').empty().append(all_employees);
                        $('#employee_add_id').selectpicker('refresh');
                        $('#employee_add_id').selectpicker('val', html.data.employee_id);
                        $('#employee_add_id').selectpicker('refresh');
                        $('#employee_add_id').attr('disabled', true);

                        $('#attendance_date').val(html.data.attendance_date);
                        $('#attendance_date').attr('disabled', true);

                        $('#attendance_time').val(html.data.formatted_attendance_time);

                        $('#hidden_id').val(html.data.id);
                        $('.modal-title').text('<?php echo e(trans('file.Edit')); ?>');
                        $('#action_button').val('<?php echo e(trans('file.Edit')); ?>');
                        $('#action').val('<?php echo e(trans('file.Edit')); ?>');
                        $('#formModal').modal('show');
                    }
                })
            });

            $('#filter_form').on('submit', function(e) {
                e.preventDefault();
                var filter_month_year = $('#month_year').val();
                let company_id = $('#company_id').val();
                let department_id = $('#department_id').val();
                $('#raw_attendance-table').DataTable().destroy();
                fill_datatable(company_id, department_id, filter_month_year);
            });

            $('.dynamic').change(function() {
                if ($(this).val() !== '') {
                    let value = $(this).val();
                    let dependent = $(this).data('dependent');
                    let _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "<?php echo e(route('dynamic_department')); ?>",
                        method: "POST",
                        data: {
                            value: value,
                            _token: _token,
                            dependent: dependent
                        },
                        success: function(result) {
                            $('select').selectpicker("destroy");
                            $('#department_id').html(result);
                            $('select').selectpicker();

                        }
                    });
                }
            });

            $('.dynamic_add').change(function() {
                if ($(this).val() !== '') {
                    let value = $(this).val();
                    let dependent = $(this).data('dependent');
                    let _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "<?php echo e(route('dynamic_department')); ?>",
                        method: "POST",
                        data: {
                            value: value,
                            _token: _token,
                            dependent: dependent
                        },
                        success: function(result) {
                            $('select').selectpicker("destroy");
                            $('#department_add_id').html(result);
                            $('select').selectpicker();

                        }
                    });
                }
            });

            $('.employee').change(function() {
                if ($(this).val() !== '') {
                    let value = $(this).val();
                    let first_name = $(this).data('first_name');
                    let last_name = $(this).data('last_name');
                    let _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "<?php echo e(route('dynamic_employee_department')); ?>",
                        method: "POST",
                        data: {
                            value: value,
                            _token: _token,
                            first_name: first_name,
                            last_name: last_name
                        },
                        success: function(result) {
                            $('select').selectpicker("destroy");
                            $('#employee_add_id').html(result);
                            $('select').selectpicker();

                        }
                    });
                }
            });

            let month_year = $('.month_year');
            month_year.datepicker({
                format: "MM-yyyy",
                startView: "months",
                minViewMode: 1,
                autoclose: true,
            }).datepicker("setDate", new Date());

            $('#btn-process').click(function() {
                $.ajax({
                    url: "<?php echo e(route('raw_attendances.process')); ?>",
                    method: "POST",
                    data: {
                        date: $('#month_year').val(),
                        company_id: $('#company_id').val(),
                    },
                    success: function(result) {
                        console.log(result['success']);
                        var html = '';
                        // alert(result['success']);
                        html = '<div class="alert alert-success">' + result['success'] + '</div>';
                        $('#form_result_home').html(html).slideDown(300).delay(2000).slideUp(300);
                        setTimeout(function(){
                            html = '';
                            $('#form_result_home').html(html)
                        }, 5000); // 1000 = 1 sec
                    }
                });
            });

            $('#btn-add').click(function() {
                $('.modal-title').text('<?php echo e(__('Add Raw Attendance')); ?>');
                $('#action_button').val('<?php echo e(trans('file.Add')); ?>');
                $('#action').val('<?php echo e(trans('file.Add')); ?>');
                $('#company_add_id').attr('disabled', false);
                $('#department_add_id').attr('disabled', false);
                $('#employee_add_id').attr('disabled', false);
                $('#attendance_date').attr('disabled', false);
                $('#formModal').modal('show');
            });

        })(jQuery);
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u1606895/public_html/hr-timas/resources/views/timesheet/raw_attendance/index.blade.php ENDPATH**/ ?>