$('#employee_leave-table').DataTable().clear().destroy();
var date = $('.date');
date.datepicker({
format: '<?php echo e(env('Date_Format_JS')); ?>',
autoclose: true,
todayHighlight: true
});







        let table_table = $('#employee_leave-table').DataTable({
            responsive: true,
            fixedHeader: {
                header: true,
                footer: true
            },
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?php echo e(route('employee_leave.index',$employee->id)); ?>",
            },

            columns: [
                {
                    data: null,
                    render: function (data) {
return data.leave_type + "<br><td><div class = 'badge badge-success'>"+data.status+"</div></td><br>" + "<b><i>Reason:</i></b>" + data.leave_reason;

                    }

                },

                {
                    data: 'department',
                    name: 'department',

                },

                {
                    data: null,
                    render: function ( data) {

                        return moment(data.start_date).format('DD-MM-YYYY') + ' to ' + moment(data.end_date).format('DD-MM-YYYY')
                            + "<br>" +' Total '+ data.total_days + ' Days ' ;


                    }

                },
                {
                    data: 'created_at',
                    name: 'created_at',  
                    render: function (data) {
                        // Clean the extra '--' and parse the date
                        let cleanedDate = data.replace('--', ' ');
    
                        // Format the date to d-m-Y H:i:s
                        return moment(cleanedDate).format('DD-MM-YYYY HH:mm:ss');
                    }
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false
                }
            ],


            "order": [],
            'language': {
                'lengthMenu': '_MENU_ <?php echo e(__('records per page')); ?>',
                "info": '<?php echo e(trans("file.Showing")); ?> _START_ - _END_ (_TOTAL_)',
                "search": '<?php echo e(trans("file.Search")); ?>',
                'paginate': {
                    'previous': '<?php echo e(trans("file.Previous")); ?>',
                    'next': '<?php echo e(trans("file.Next")); ?>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    'targets': [0, 4],
                },
        ],


            'select': {style: 'multi', selector: 'td:first-child'},
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],

        });
        new $.fn.dataTable.FixedHeader(table_table);

$(document).on('click', '.show_leave', function () {

    let id = $(this).attr('id');

    let target = '<?php echo e(route('employee_leave.details')); ?>/' + id;

    $.ajax({
        url: target,
        dataType: "json",
        success: function (result) {

            $('#leave_leave_type_id').html(result.leave_type_name);
            $('#leave_company_id_show').html(result.company_name);
$('#leave_employee_id_show').html(result.employee_name);

            $('#leave_department_id_show').html(result.department);
            
            var start_date = moment(result.start_date_name).format('DD-MM-YYYY')
            $('#leave_start_date_id').html(start_date);

            var end_date = moment(result.end_date_name).format('DD-MM-YYYY')
            $('#leave_end_date_id').html(end_date);
            
            let cleanedDate = result.data.created_at.replace('--', ' ');
            var created_date = moment(cleanedDate).format('DD-MM-YYYY HH:mm:ss');
            $('#leave_applied_date_id').html(created_date);
            
            $('#leave_total_days_id').html(result.data.total_days);
            $('#leave_status_id').html(result.data.status);
            $('#leave_leave_reason_id').html(result.data.leave_reason);
            $('#leave_remarks_id').html(result.data.remarks);

            if (result.data.is_half==1)
                $('#leave_is_half_id').html('Yes');
            else{
                $('#leave_is_half_id').html('No');
            }
            if (result.data.is_notify==1)
                $('#leave_is_notify_id').html('On');
            else{
                $('#leave_is_notify_id').html('Off');
            }





            $('#leave_model').modal('show');
            $('.modal-title').text("<?php echo e(__('Leave Info')); ?>");
        }
    });
});


<?php /**PATH /home/u1606895/public_html/hr-timas/resources/views/employee/leave/index_js.blade.php ENDPATH**/ ?>