
<?php $__env->startSection('content'); ?>
<?php
	$employees = App\Employee::all();
	$staffNumbers = null;
	foreach ($employees as $employee) {
		if (preg_match('/^([A-Za-z]+)(\d+)$/', $employee->staff_id, $matches)) {
			$prefix = $matches[1];
			$number = (int)$matches[2];

			if ($staffNumbers === null || $number > $staffNumbers) {
				$staffNumbers = $number;
			}
		}
	}
	$staffNumbers = $staffNumbers+1;
?>
    <section>

        <div class="container-fluid"><span id="general_result"></span></div>


        <div class="container-fluid mb-3">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('store-details-employee')): ?>
                <button type="button" class="btn btn-info" name="create_record" id="create_record"><i class="fa fa-plus"></i>
                    <?php echo e(__('Add Employee')); ?></button>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('modify-details-employee')): ?>
                <button type="button" class="btn btn-danger" name="bulk_delete" id="bulk_delete"><i
                        class="fa fa-minus-circle"></i> <?php echo e(__('Bulk delete')); ?></button>
            <?php endif; ?>
            <button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#collapseExample"
                aria-expanded="false" aria-controls="collapseExample">
                <i class="fa fa-filter" aria-hidden="true"></i> Filter
            </button>
            <a href="<?php echo e(route('employees.exportLeaves')); ?>">
                <button id="btn-export-leaves" class="btn btn-success" type="button">
                    <i class="fa fa-download" aria-hidden="true"></i> Export Employee Leaves
                </button>
            </a>
        </div>
        <div class="col-12">
            <!-- Filtering -->
            <div class="collapse" id="collapseExample">
                <div class="card card-body">
                    <form action="" method="GET" id="filter_form">
                        <div class="row">
                            <!-- Company -->
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="text-bold"><strong><?php echo e(trans('file.Company')); ?></strong></label>
                                    <select name="company_id" id="company_id_filter"
                                        class="form-control selectpicker dynamic" data-live-search="true"
                                        data-live-search-style="contains" data-shift_name="shift_name"
                                        data-dependent="department_name"
                                        title="<?php echo e(__('Selecting', ['key' => trans('file.Company')])); ?>...">
                                        <option value=""></option>
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->company_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <!--/ Company-->

                            <!-- Department-->
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="text-bold"><b><?php echo e(trans('file.Department')); ?></b></label>
                                    <select name="department_id" id="department_id_filter"
                                        class="selectpicker form-control designationFilter" data-live-search="true"
                                        data-live-search-style="contains" data-designation_name="designation_name"
                                        title="<?php echo e(__('Selecting', ['key' => trans('file.Department')])); ?>...">
                                    </select>
                                </div>
                            </div>
                            <!--/ Department-->

                            <!-- Designation -->
                            <div class="col-md-3 form-group">
                                <label class="text-bold"><b><?php echo e(trans('file.Designation')); ?></b></label>
                                <select name="designation_id" id="designation_id_filter" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="<?php echo e(__('Selecting', ['key' => trans('file.Designation')])); ?>...">
                                </select>
                            </div>
                            <!--/ Designation -->

                            <!-- Office Shift -->
                            <div class="col-md-2 form-group">
                                <label class="text-bold"><b><?php echo e(__('Office Shift')); ?></b></label>
                                <select name="office_shift_id" id="office_shift_id_filter" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="<?php echo e(__('Selecting Office Shift')); ?>...">
                                </select>
                            </div>
                            <!--/ Office Shift -->

                            <div class="col-md-1">
                                <label class="text-bold"></label><br>
                                <button type="button" class="btn btn-dark" id="filterSubmit">
                                    <i class="fa fa-arrow-right" aria-hidden="true"></i> &nbsp; GET
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!--/ Filtering -->
        </div>


        <div class="table-responsive">
            <table id="employee-table" class="table ">
                <thead>
                    <tr>
                        <th class="not-exported"></th>
                        <th><?php echo e(trans('file.Employee')); ?></th>
                        <th><?php echo e(trans('file.Company')); ?></th>
                        <th><?php echo e(trans('file.Contact')); ?></th>
                        <th><?php echo e(trans('file.Status')); ?></th>
                        <th class="not-exported"><?php echo e(trans('file.action')); ?></th>
                    </tr>
                </thead>

            </table>
        </div>
    </section>



    <div id="formModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title"><?php echo e(__('Add Employee')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <span id="form_result"></span>
                    <form method="post" id="sample_form" class="form-horizontal" enctype="multipart/form-data">

                        <?php echo csrf_field(); ?>
						<div class="row" id="company_selection">
							<div class="col-md-6">
                                <div class="form-group">
                                    <label class="text-bold"><?php echo e(trans('file.Company')); ?> <span
                                            class="text-danger">*</span></label>
                                    <select name="company_id" id="company_id" required
                                        class="form-control selectpicker dynamic" data-live-search="true"
                                        data-live-search-style="contains" data-shift_name="shift_name"
                                        data-dependent="department_name"
                                        title="<?php echo e(__('Selecting', ['key' => trans('file.Company')])); ?>...">
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->company_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="text-bold"><?php echo e(trans('file.Department')); ?> <span
                                            class="text-danger">*</span></label>
                                    <select name="department_id" id="department_id" required
                                        class="selectpicker form-control designation" data-live-search="true"
                                        data-live-search-style="contains" data-designation_name="designation_name"
                                        title="<?php echo e(__('Selecting', ['key' => trans('file.Department')])); ?>...">
                                    </select>
                                </div>
                            </div>


                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(trans('file.Position')); ?> <span
                                        class="text-danger">*</span></label>
                                <select name="designation_id" id="designation_id" required
                                    class="selectpicker form-control" data-live-search="true"
                                    data-live-search-style="contains"
                                    title="<?php echo e(__('Selecting', ['key' => trans('file.Designation')])); ?>...">
                                </select>
                            </div>

                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(trans('file.Office_Shift')); ?> <span
                                        class="text-danger">*</span></label>
                                <select name="office_shift_id" id="office_shift_id" required
                                    class="selectpicker form-control" data-live-search="true"
                                    data-live-search-style="contains"
                                    title="<?php echo e(__('Selecting', ['key' => trans('file.Office_Shift')])); ?>...">
                                </select>
                            </div>
							<div class="container">
                                <div class="form-group" align="center">
									<button onclick="next_step()" class="btn btn-primary"><?php echo e(__('Next')); ?></button>
								</div>
							</div>
						</div>
						
                        <div class="row d-none" id="biodata">
                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(__('First Name')); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="text" name="first_name" id="first_name"
                                    placeholder="<?php echo e(__('First Name')); ?>" required class="form-control">
                            </div>
                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(__('Last Name')); ?> 
                                    <!-- <span class="text-danger">*</span> -->
                                </label>
                                <input type="text" name="last_name" id="last_name"
                                    placeholder="<?php echo e(__('Last Name')); ?>" class="form-control">
                            </div>
                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(__('Staff Id')); ?> <span class="text-danger">*</span></label>
                                <div class="input-group">
									<input type="text" name="staff_letters" id="staff_letters" placeholder="Company Code"
										   required class="form-control" pattern="[A-Za-z]+">

									<input type="number" name="staff_numbers" id="staff_numbers" placeholder="Staff Numbers"
										   required class="form-control" value="<?php echo e($staffNumbers); ?>">
								</div>
                            </div>
                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(trans('file.Email')); ?></label>
                                <input type="email" name="email" id="email" placeholder="example@example.com"
                                    class="form-control">
                            </div>
							
                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(__('Nomor KTP')); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="text" name="identity_number" id="identity_number"
                                    placeholder="<?php echo e(__('Nomor Identitas')); ?>" required class="form-control"
                                    value="<?php echo e(old('identity_number')); ?>" pattern="[0-9]{16}">
                            </div>
                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(__('NPWP')); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="text" name="npwp" id="npwp"
                                    placeholder="<?php echo e(__('Nomor NPWP')); ?>" required class="form-control"
                                    value="<?php echo e(old('npwp')); ?>" pattern="[0-9]{16}">
                            </div>

                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(__('Date Of Birth')); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="text" name="date_of_birth" id="date_of_birth" required
                                    autocomplete="off" class="form-control date" value="">
                            </div>

                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(trans('file.Gender')); ?> <span
                                        class="text-danger">*</span></label>
                                <select name="gender" id="gender" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="<?php echo e(__('Selecting', ['key' => trans('file.Gender')])); ?>..." required>
                                    <option value="Male"><?php echo e(trans('file.Male')); ?></option>
                                    <option value="Female"><?php echo e(trans('file.Female')); ?></option>
                                </select>
                            </div>
							
                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(__('Marital Status')); ?> <span
                                        class="text-danger">*</span></label>
                                <select name="marital_status" id="marital_status" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="<?php echo e(__('Selecting', ['key' => __('Marital Status')])); ?>..." required>
                                    <option value="single"><?php echo e(trans('file.Single')); ?></option>
                                    <option value="married"><?php echo e(trans('file.Married')); ?></option>
                                    <option value="divorced"><?php echo e(__('Divorced')); ?></option>
                                </select>
                            </div>
							
                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(__('Religion')); ?> <span
                                        class="text-danger">*</span></label>
                                <select name="religion" id="religion" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="<?php echo e(__('Selecting', ['key' => __('Religion')])); ?>..." required>
                                    <option value="islam"><?php echo e(__('Islam')); ?></option>
                                    <option value="kristen"><?php echo e(__('Kristen')); ?></option>
                                    <option value="katholik"><?php echo e(__('Katholik')); ?></option>
                                    <option value="hindu"><?php echo e(__('Hindu')); ?></option>
                                    <option value="budha"><?php echo e(__('Budha')); ?></option>
                                    <option value="konghucu"><?php echo e(__('Konghucu')); ?></option>
                                    <option value="lainnya"><?php echo e(__('Lainnya')); ?></option>
                                    <option value="kepercayaan"><?php echo e(__('Kepercayaan terhadap Tuhan YME')); ?></option>
                                </select>
                            </div>

                            <!-- <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(trans('file.Role')); ?> <span
                                        class="text-danger">*</span></label>
                                <select name="role_users_id" id="role_users_id" required
                                    class="selectpicker form-control" data-live-search="true"
                                    data-live-search-style="contains"
                                    title="<?php echo e(__('Selecting', ['key' => trans('file.Role')])); ?>...">
                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                </select>
                            </div> -->

                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(__('Attendance Type')); ?> <span
                                        class="text-danger">*</span></label>
                                <select name="attendance_type" id="attendance_type" required
                                    class="selectpicker form-control" data-live-search="true"
                                    data-live-search-style="contains" title="<?php echo e(__('Select Attendance Type...')); ?>">
                                    <!--<option value="general"><?php echo e(__('General')); ?></option>-->
                                    <option value="ip_based"><?php echo e(__('IP Based')); ?></option>
                                </select>
                            </div>

                            <div class="col-md-6 form-group">
                                <label class="text-bold"><?php echo e(__('Date Of Joining')); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="text" name="joining_date" id="joining_date" class="form-control date">
                            </div>

                            <div class="col-md-6 form-group">
                                <label for="profile_photo" class=""><strong><?php echo e(__('Image')); ?></strong></label>
                                <input type="file" id="profile_photo"
                                    class="form-control <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="profile_photo"
                                    placeholder="<?php echo e(__('Upload', ['key' => trans('file.Photo')])); ?>">
                            </div>


                            <!-- <div class="col-md-6">
                                <div class="form-group">
                                    <label class="text-bold"><?php echo e(__('Position')); ?><span
                                            class="text-danger">*</span></label>
                                    <input type="number" name="position" id="position" class="form-control"
                                        placeholder="<?php echo e(__('Position')); ?>">
                                </div>
                            </div> -->

                            <div class="col-md-12 form-group">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="is_dispensation"
                                        id="is_dispensation" value="1">
                                    <label class="custom-control-label text-bold"
                                        for="is_dispensation"><?php echo e(__('Dispensation')); ?></label>
                                </div>
                            </div>

                            

                            <div class="container">
                                <div class="form-group" align="center">
                                    <input type="hidden" name="action" id="action" />
                                    <input type="hidden" name="hidden_id" id="hidden_id" />
                                    <button type="" id="prev_button" class="btn btn-warning" onclick="prev_step()"><?php echo e(__('Back')); ?></button>
                                    <input type="submit" name="action_button" id="action_button"
                                        class="btn btn-warning" value="<?php echo e(trans('file.Add')); ?>" />
                                </div>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>


    <div id="confirmModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title"><?php echo e(trans('file.Confirmation')); ?></h2>
                    <button type="button" class="employee-close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h4 align="center" style="margin:0;"><?php echo e(__('Are you sure you want to remove this data?')); ?></h4>
                </div>
                <div class="modal-footer">
                    <button type="button" name="ok_button" id="ok_button"
                        class="btn btn-danger"><?php echo e(trans('file.OK')); ?></button>
                    <button type="button" class="close btn-default"
                        data-dismiss="modal"><?php echo e(trans('file.Cancel')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <!-- //Inactive Modal -->
    <div id="confirmModalActive" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form id="inactive-form">
                    <div class="modal-header">
                        <h2 class="modal-title"><?php echo e(trans('file.Confirmation')); ?></h2>
                        <button type="button" class="employee-close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body" style="text-align: center;">
                        <h4 align="center" style="margin:0;"><?php echo e(__('Are you sure you want to set inactive this data?')); ?></h4>
                        <textarea id="reason" name="reason" rows="4" cols="50" placeholder="reason"></textarea>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" id="inactive_id" value="">
                        <button type="button" name="inactive_button" id="inactive_button"
                            class="btn btn-danger"><?php echo e(trans('file.OK')); ?></button>
                        <button type="button" class="close btn-default"
                            data-dismiss="modal"><?php echo e(trans('file.Cancel')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="confirmModalAcc" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title"><?php echo e(trans('file.Confirmation')); ?></h2>
                    <button type="button" class="employee-close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h4 align="center" style="margin:0;"><?php echo e(__('Are you sure you want to accept this data?')); ?></h4>
                </div>
                <div class="modal-footer">
                    <button type="button" name="ok_button" id="ok_button_acc"
                        class="btn btn-danger"><?php echo e(trans('file.OK')); ?></button>
                    <button type="button" class="close btn-default"
                        data-dismiss="modal"><?php echo e(trans('file.Cancel')); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cleave.js/1.6.0/cleave.min.css">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/cleave.js/1.6.0/cleave.min.js"></script>
    <script type="text/javascript">
		var nomor_identitas = new Cleave('#identity_number', {
            blocks: [16], // Jumlah digit KTP
            numericOnly: true, // Hanya menerima input angka
            delimiter: ' ', // Karakter pemisah, misalnya spasi
        });
		
		var npwp = new Cleave('#npwp', {
            blocks: [16], // Jumlah digit NPWP
            numericOnly: true, // Hanya menerima input angka
            delimiter: ' ', // Karakter pemisah, misalnya spasi
        });
        $(document).ready(function() {

            if (window.location.href.indexOf('#formModal') != -1) {
                $('#formModal').modal('show');
            }

            var date = $('.date');
            date.datepicker({
                format: '<?php echo e(env('Date_Format_JS')); ?>',
                autoclose: true,
                todayHighlight: true
            });

            var table_table = $('#employee-table').DataTable({
                initComplete: function() {
                    this.api().columns([2, 4]).every(function() {
                        var column = this;
                        var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );

                                column
                                    .search(val ? '^' + val + '$' : '', true, false)
                                    .draw();
                            });

                        column.data().unique().sort().each(function(d, j) {
                            select.append('<option value="' + d + '">' + d +
                                '</option>');
                            $('select').selectpicker('refresh');
                        });
                    });
                },
                responsive: true,
                fixedHeader: {
                    header: true,
                    footer: true
                },
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('employees.index')); ?>",
                    type: 'GET',
                    data: function(d) {
                        d.company_id = $("#company_id_filter").val();
                        d.department_id = $('#department_id_filter').val();
                        d.designation_id = $('#designation_id_filter').val();
                        d.office_shift_id = $('#office_shift_id_filter').val();
                    }
                },

                columns: [

                    {
                        data: 'id',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name',

                    },
                    {
                        data: 'company',
                        name: 'company',
                    },
                    {
                        data: 'contacts',
                        name: 'contacts',
                    },
                    {
                        data: 'status',
                        name: 'status',
                        render: function(data) {
                            if (data == '1') {
                                return "<td><div class = 'badge badge-success'><?php echo e(__('Active')); ?></div>"
                            } else {
                                return "<td><div class = 'badge badge-danger'><?php echo e(__('Inactive')); ?></div>"
                            }
                        }
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false
                    }
                ],


                "order": [],
                'language': {
                    'lengthMenu': '_MENU_ <?php echo e(__('records per page')); ?>',
                    "info": '<?php echo e(trans('file.Showing')); ?> _START_ - _END_ (_TOTAL_)',
                    "search": '<?php echo e(trans('file.Search')); ?>',
                    'paginate': {
                        'previous': '<?php echo e(trans('file.Previous')); ?>',
                        'next': '<?php echo e(trans('file.Next')); ?>'
                    }
                },
                'columnDefs': [{
                        "orderable": false,
                        'targets': [0, 4],
                        "className": "text-left"
                    },
                    {
                        'render': function(data, type, row, meta) {
                            if (type == 'display') {
                                data =
                                    '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label class="text-bold"></label></div>';
                            }

                            return data;
                        },
                        'checkboxes': {
                            'selectRow': true,
                            'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label class="text-bold"></label></div>'
                        },
                        'targets': [0]
                    }
                ],


                'select': {
                    style: 'multi',
                    selector: 'td:first-child'
                },
                'lengthMenu': [
                    [10, 25, 50, -1],
                    [10, 25, 50, "All"]
                ],
                dom: '<"row"lfB>rtip',
                buttons: [{
                        extend: 'pdf',
                        text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                        exportOptions: {
                            columns: ':visible:Not(.not-exported)',
                            rows: ':visible'
                        },
                    },
                    {
                        extend: 'csv',
                        text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                        exportOptions: {
                            columns: ':visible:Not(.not-exported)',
                            rows: ':visible'
                        },
                    },
                    // {
                    //     extend: 'csv',
                    //     text: '<i title="export for device" class="fa fa-tablet"></i>',
                    //     className: 'export-for-device',
                    //     exportOptions: {
                    //         columns: [1,2],
                    //         rows: ':visible',
                    //         format: {
                    //             body: function ( data, row, column, node ) {
                    //                 if (column === 0) {
                    //                     var id = data.match(/<span>Staff Id: (.*?)<\/span>/)[1];
                    //                     name = data.match(/<[a][^>]*>(.+?)<\/[a]>/)[1];
                    //                     return id;
                    //                 }
                    //                 else {
                    //                     return name;
                    //                 }
                    //             }
                    //         }
                    //     },
                    //     customize: function (csv) {
                    //         var csvRows = csv.split('\n');
                    //         csvRows[0] = csvRows[0].replace(['"Employee"', '"Company"'], ['"Staff Id"','"Name"']);
                    //         return csvRows.join('\n');
                    //     }
                    // },
                    {
                        extend: 'print',
                        text: '<i title="print" class="fa fa-print"></i>',
                        exportOptions: {
                            columns: ':visible:Not(.not-exported)',
                            rows: ':visible'
                        },
                    },
                    {
                        extend: 'colvis',
                        text: '<i title="column visibility" class="fa fa-eye"></i>',
                        columns: ':gt(0)'
                    },
                ],
            });
            new $.fn.dataTable.FixedHeader(table_table);

        });


        //-------------- Filter -----------------------

        $('#filterSubmit').on("click", function(e) {
            $('#employee-table').DataTable().draw(true);
            //$('#filter_form')[0].reset();
            //$('select').selectpicker('refresh');
        });
        //--------------/ Filter ----------------------


        $('#create_record').click(function() {

            $('.modal-title').text("Add Employee");
            $('#action_button').val('<?php echo e(trans('file.Add')); ?>');
            $('#action').val('<?php echo e(trans('file.Add')); ?>');
            $('#formModal').modal('show');
        });

		function next_step() {
		  $('#company_selection').addClass('d-none');
		  $('#biodata').removeClass('d-none');
		  $('#biodata').addClass('d-flex flex-row');
		}
		
		function prev_step() {
		  $('#company_selection').removeClass('d-none');
		  $('#biodata').addClass('d-none');
		  $('#biodata').removeClass('d-flex flex-row');
		}

        $('#sample_form').on('submit', function(event) {
            event.preventDefault();
            // var attendance_type = $("#attendance_type").val();
            // console.log(attendance_type);
			var staff_number = parseInt($('#staff_numbers').val());
            $.ajax({
                url: "<?php echo e(route('employees.store')); ?>",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                cache: false,
                processData: false,
                dataType: "json",
                success: function(data) {
                    console.log(data);
                    var html = '';
                    if (data.errors) {
                        html = '<div class="alert alert-danger">';
                        for (var count = 0; count < data.errors.length; count++) {
                            html += '<p>' + data.errors[count] + '</p>';
                        }
                        html += '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                        $('#sample_form')[0].reset();
						$('#staff_numbers').val(staff_number+1);
                        $('select').selectpicker('refresh');
                        $('.date').datepicker('update');
                        $('#employee-table').DataTable().ajax.reload();
                    }
                    $('#form_result').html(html).slideDown(300).delay(2000).slideUp(300);
                }
            });
        });


        let employee_delete_id;

        $(document).on('click', '.delete', function() {
            employee_delete_id = $(this).attr('id');
            $('#confirmModal').modal('show');
            $('.modal-title').text('<?php echo e(__('DELETE Record')); ?>');
            $('#ok_button').text('<?php echo e(trans('file.OK')); ?>');

        });

        let employee_acc_id;

        $(document).on('click', '.accept', function() {
            employee_acc_id = $(this).attr('id');
            $('#confirmModalAcc').modal('show');
            $('.modal-title').text('<?php echo e(__('ACCEPT Record')); ?>');
            $('#ok_button_acc').text('<?php echo e(trans('file.OK')); ?>');

        });


        $(document).on('click', '#bulk_delete', function() {

            var id = [];
            let table = $('#employee-table').DataTable();
            id = table.rows({
                selected: true
            }).ids().toArray();
            if (id.length > 0) {
                if (confirm('<?php echo e(__('Delete Selection', ['key' => trans('file.Employee')])); ?>')) {
                    $.ajax({
                        url: '<?php echo e(route('mass_delete_employees')); ?>',
                        method: 'POST',
                        data: {
                            employeeIdArray: id
                        },
                        success: function(data) {
                            if (data.success) {
                                html = '<div class="alert alert-success">' + data.success + '</div>';
                            }
                            if (data.error) {
                                html = '<div class="alert alert-danger">' + data.error + '</div>';
                            }
                            table.ajax.reload();
                            table.rows('.selected').deselect();
                            $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);

                        }

                    });
                }
            } else {
                alert('<?php echo e(__('Please select atleast one checkbox')); ?>');
            }
        });


        $('#close').click(function() {
            $('#sample_form')[0].reset();
            $('select').selectpicker('refresh');
            $('.date').datepicker('update');
            $('#employee-table').DataTable().ajax.reload();
        });

        $('#ok_button').click(function() {
            let target = "<?php echo e(route('employees.index')); ?>/" + employee_delete_id + '/delete';
            $.ajax({
                url: target,
                beforeSend: function() {
                    $('#ok_button').text('<?php echo e(trans('file.Deleting...')); ?>');
                },
                success: function(data) {
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    setTimeout(function() {
                        $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        $('#confirmModal').modal('hide');
                        $('#employee-table').DataTable().ajax.reload();
                    }, 2000);
                }
            })
        });

        $('#ok_button_acc').click(function() {
            let target = "<?php echo e(route('employees.index')); ?>/" + employee_acc_id + '/accept';
            $.ajax({
                url: target,
                beforeSend: function() {
                    $('#ok_button').text('<?php echo e(__('Accepting')); ?>');
                },
                success: function(data) {
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    setTimeout(function() {
                        $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        $('#confirmModalAcc').modal('hide');
                        $('#employee-table').DataTable().ajax.reload();
                    }, 2000);
                }
            })
        });




        $('#confirm_pass').on('input', function() {

            if ($('input[name="password"]').val() != $('input[name="password_confirmation"]').val())
                $("#divCheckPasswordMatch").html('<?php echo e(__('Password does not match! please type again')); ?>');
            else
                $("#divCheckPasswordMatch").html('<?php echo e(__('Password matches!')); ?>');

        });


        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let dependent = $(this).data('dependent');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_department')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {

                        $('select').selectpicker("destroy");
                        $('#department_id').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });


        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let dependent = $(this).data('shift_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_office_shifts')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#office_shift_id').html(result);
                        $('select').selectpicker();
                    }
                });
            }
        });

        $('.following_company').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let dependent = $(this).data('following_company');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_employee')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#following_employee_id').html(result);
                        $('select').selectpicker();
                    }
                });
            }
        });

        $('.designation').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let designation_name = $(this).data('designation_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_designation_department')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        designation_name: designation_name
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#designation_id').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });


        // Login Type Change
        // $('#login_type').change(function() {
        //     var login_type = $('#login_type').val();
        //     if (login_type=='ip') {
        //         data = '<label class="text-bold"><?php echo e(__('IP Address')); ?> <span class="text-danger">*</span></label>';
        //         data += '<input type="text" name="ip_address" id="ip_address" placeholder="Type IP Address" required class="form-control">';
        //         $('#ipField').html(data)
        //     }else{
        //         $('#ipField').empty();
        //     }
        // });



        //--------  Filter  ---------

        // Company--> Department
        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                let value = $('#company_id_filter').val();
                let dependent = $(this).data('dependent');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_department')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {

                        $('select').selectpicker("destroy");
                        $('#department_id_filter').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });

        //Department--> Designation
        $('.designationFilter').change(function() {
            if ($(this).val() !== '') {
                // let value = $(this).val();
                // let value = $('#company_id_filter').val();
                let value = $('#department_id_filter').val();
                let designation_name = $(this).data('designation_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_designation_department')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        designation_name: designation_name
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#designation_id_filter').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });

        //Company--> Office Shift
        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                // let value = $(this).val();
                let value = $('#company_id_filter').val();
                let dependent = $(this).data('shift_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_office_shifts')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#office_shift_id_filter').html(result);
                        $('select').selectpicker();
                    }
                });
            }
        });

        //Set Inactive
        $(document).on('click', '.inactive', function() {
            employee_delete_id = $(this).attr('id');
            $('#confirmModalActive').modal('show');
            $('.modal-title').text('<?php echo e(__('Inactive Record')); ?>');
            $('#inactive_id').val(employee_delete_id);
            $('#inactive_button').text('<?php echo e(trans('file.OK')); ?>');

        });

        $(document).on('click', '#inactive_button', function() {
            let employee_id = $('#inactive_id').val();
            let _token = $('input[name="_token"]').val();

            let target = "<?php echo e(url('staff/employees/inactive')); ?>";
            $.ajax({
                url: target,
                method: "POST",
                data: {
                    id: employee_id,
                    _token: _token,
                    reason: $('#reason').val()
                },
                beforeSend: function() {
                    $('#inactive_button').text('<?php echo e(trans('file.Processing...')); ?>');
                },
                success: function(data) {
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    setTimeout(function() {
                        $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        $('#confirmModalActive').modal('hide');
                        $('#employee-table').DataTable().ajax.reload();
                    }, 2000);
                }
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\hr-timas\resources\views/employee/index.blade.php ENDPATH**/ ?>