SET foreign_key_checks = 0;

CREATE TABLE `announcements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `summary` text DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `added_by` varchar(40) DEFAULT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `announcements_company_id_foreign` (`company_id`),
  KEY `announcements_department_id_foreign` (`department_id`),
  KEY `announcements_added_by_foreign` (`added_by`),
  CONSTRAINT `announcements_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `announcements_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `appraisals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `department_id` bigint(20) unsigned NOT NULL,
  `designation_id` bigint(20) unsigned NOT NULL,
  `customer_experience` varchar(191) NOT NULL,
  `marketing` varchar(191) DEFAULT NULL,
  `administration` varchar(191) DEFAULT NULL,
  `professionalism` varchar(191) DEFAULT NULL,
  `integrity` varchar(191) DEFAULT NULL,
  `attendance` varchar(191) DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `date` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `asset_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `category_name` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `asset_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO asset_categories VALUES('1','','ATK','2024-02-07 15:05:23','2024-02-07 15:05:23');
INSERT INTO asset_categories VALUES('2','','PANTRY','2024-02-07 15:05:44','2024-02-07 15:05:44');
INSERT INTO asset_categories VALUES('3','','OFFICE','2024-02-07 15:05:57','2024-02-07 15:05:57');



CREATE TABLE `assets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_name` varchar(50) NOT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `asset_code` varchar(80) NOT NULL,
  `assets_category_id` bigint(20) unsigned NOT NULL,
  `Asset_note` mediumtext DEFAULT NULL,
  `manufacturer` varchar(191) NOT NULL,
  `serial_number` varchar(191) NOT NULL,
  `invoice_number` varchar(191) NOT NULL,
  `asset_image` varchar(191) DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `warranty_date` date NOT NULL,
  `status` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_company_id_foreign` (`company_id`),
  KEY `assets_employee_id_foreign` (`employee_id`),
  KEY `assets_assets_category_id_foreign` (`assets_category_id`),
  CONSTRAINT `assets_assets_category_id_foreign` FOREIGN KEY (`assets_category_id`) REFERENCES `asset_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `attendance_date` date NOT NULL,
  `clock_in` varchar(191) NOT NULL,
  `clock_out` varchar(191) NOT NULL,
  `total_work` varchar(191) NOT NULL DEFAULT '00:00',
  `is_underwork` tinyint(1) NOT NULL,
  `status` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attendances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `attendances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `award_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `award_name` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO award_types VALUES('1','PANJAT PINANG','2024-02-06 16:14:17','2024-02-06 16:14:17');
INSERT INTO award_types VALUES('2','LOMBA ADZAN','2024-02-06 16:14:32','2024-02-06 16:14:32');



CREATE TABLE `awards` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `award_information` mediumtext DEFAULT NULL,
  `award_date` date NOT NULL,
  `gift` varchar(40) DEFAULT NULL,
  `cash` varchar(40) DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `award_type_id` bigint(20) unsigned DEFAULT NULL,
  `award_photo` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `awards_company_id_foreign` (`company_id`),
  KEY `awards_department_id_foreign` (`department_id`),
  KEY `awards_employee_id_foreign` (`employee_id`),
  KEY `awards_award_type_id_foreign` (`award_type_id`),
  CONSTRAINT `awards_award_type_id_foreign` FOREIGN KEY (`award_type_id`) REFERENCES `award_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO awards VALUES('1','TINGKATKAN LAGI YA','2024-08-17','TERIMA KASIH','0','1','21','2041','2','','2024-02-06 16:15:42','2024-02-06 16:15:42');



CREATE TABLE `bpjs_kes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `company` decimal(8,2) NOT NULL,
  `employee` decimal(8,2) NOT NULL,
  `min_salary` double NOT NULL,
  `max_salary` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bpjs_kes_company_id_foreign` (`company_id`),
  CONSTRAINT `bpjs_kes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO bpjs_kes VALUES('1','1','Kesehatan','4.00','1.00','0','999999999','2024-02-06 13:27:55','2024-02-06 13:27:55');



CREATE TABLE `bpjs_tk` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `general` decimal(8,2) NOT NULL,
  `company` decimal(8,2) NOT NULL,
  `employee` decimal(8,2) NOT NULL,
  `type` enum('pensiun','jht','jkm','jkk') DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bpjs_tk_company_id_foreign` (`company_id`),
  CONSTRAINT `bpjs_tk_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO bpjs_tk VALUES('1','1','Jaminan Pensiun','0.00','2.00','1.00','pensiun','2024-02-06 13:26:08','2024-02-06 13:26:08');
INSERT INTO bpjs_tk VALUES('2','1','Jaminan Hari Tua','0.00','3.70','2.00','jht','2024-02-06 13:26:30','2024-02-06 13:26:30');
INSERT INTO bpjs_tk VALUES('3','1','Jaminan Kematian','0.30','0.00','0.00','jkm','2024-02-06 13:26:47','2024-02-06 13:26:47');
INSERT INTO bpjs_tk VALUES('4','1','Jaminan Kecelakaan Kerja','0.24','0.00','0.00','jkk','2024-02-06 13:27:11','2024-02-06 13:27:11');



CREATE TABLE `c_m_s` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `home` longtext DEFAULT NULL,
  `about` longtext DEFAULT NULL,
  `contact` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `calendarables` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `candidate_interview` (
  `interview_id` bigint(20) unsigned NOT NULL,
  `candidate_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`interview_id`,`candidate_id`),
  KEY `candidate_interview_candidate_id_foreign` (`candidate_id`),
  CONSTRAINT `candidate_interview_candidate_id_foreign` FOREIGN KEY (`candidate_id`) REFERENCES `job_candidates` (`id`),
  CONSTRAINT `candidate_interview_interview_id_foreign` FOREIGN KEY (`interview_id`) REFERENCES `job_interviews` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) NOT NULL,
  `last_name` varchar(191) NOT NULL,
  `email` varchar(191) DEFAULT NULL,
  `contact_no` varchar(15) NOT NULL,
  `username` varchar(64) NOT NULL,
  `profile` varchar(191) DEFAULT NULL,
  `company_name` varchar(191) NOT NULL,
  `gender` varchar(40) NOT NULL,
  `website` varchar(40) DEFAULT NULL,
  `address1` mediumtext DEFAULT NULL,
  `address2` mediumtext DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `zip` varchar(191) DEFAULT NULL,
  `country` tinyint(4) DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `clients_id_foreign` FOREIGN KEY (`id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `companies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(191) NOT NULL,
  `company_type` varchar(191) NOT NULL,
  `trading_name` varchar(191) DEFAULT NULL,
  `registration_no` varchar(191) DEFAULT NULL,
  `contact_no` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `tax_no` varchar(191) DEFAULT NULL,
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `company_logo` varchar(191) DEFAULT NULL,
  `start_cut_off_date` tinyint(4) NOT NULL,
  `end_cut_off_date` tinyint(4) NOT NULL,
  `leave_amount` int(11) NOT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companies_location_id_foreign` (`location_id`),
  CONSTRAINT `companies_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `locations` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO companies VALUES('1','HEAD OFFICE','corporation','HO','','0213522828','hrga@timas.com','','01.335.995.5-073.000','1','','1','31','21','','2024-02-05 15:36:37','2024-02-06 13:58:26');
INSERT INTO companies VALUES('2','RAPP','corporation','','','082373325808','afriyon@timas.com','','192837465647382','2','509447849_1707280943.jpg','21','20','25','','2024-02-05 16:55:38','2024-02-07 11:42:23');
INSERT INTO companies VALUES('3','FABRICATION SHOP','corporation','FS','','0213522828','hrga.workshop@timas.com','','01.335.995.5-073.000','3','','21','20','25','','2024-02-05 19:43:02','2024-02-05 19:44:00');
INSERT INTO companies VALUES('4','TIMAS MULTI KONSTRUKSI','corporation','TMK','','0213522828','hrga@timas.com','','01.850.021.5-028.000','1','','1','31','21','','2024-02-05 19:47:20','2024-02-05 19:47:20');
INSERT INTO companies VALUES('5','TIMAS OCEANSTAR INDONESIA','corporation','TOI','','02129921828','hrga@timas.com','','96.332.046.0-076.000','1','','1','31','21','','2024-02-05 19:49:32','2024-02-05 19:49:32');
INSERT INTO companies VALUES('6','TIMAS SAMUDERA INDONESIA','corporation','TSI','','02129921828','hrga@timas.com','','01.335.995.5-073.000','1','','1','31','21','','2024-02-05 19:51:36','2024-02-05 19:51:36');
INSERT INTO companies VALUES('7','PRI','corporation','PRI','','0213522828','hrga@timas.com','','01.335.995.5-073.000','4','','21','20','25','','2024-02-05 19:55:10','2024-02-05 19:55:10');
INSERT INTO companies VALUES('8','TPPI','corporation','TUBAN','','0213522828','hrga@timas.com','','01.335.995.5-073.000','5','','21','20','25','','2024-02-05 19:57:07','2024-02-05 19:57:07');
INSERT INTO companies VALUES('9','THE PLAZA','corporation','TP','','02129921828','hrga@timas.com','','01.850.021.5-028.000','1','','1','31','21','','2024-02-05 20:07:23','2024-02-05 20:07:23');



CREATE TABLE `complaints` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `complaint_title` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `complaint_from` bigint(20) unsigned NOT NULL,
  `complaint_against` bigint(20) unsigned NOT NULL,
  `complaint_date` date NOT NULL,
  `status` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `complaints_company_id_foreign` (`company_id`),
  KEY `complaints_complaint_from_foreign` (`complaint_from`),
  KEY `complaints_complaint_against_foreign` (`complaint_against`),
  CONSTRAINT `complaints_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `complaints_complaint_against_foreign` FOREIGN KEY (`complaint_against`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `complaints_complaint_from_foreign` FOREIGN KEY (`complaint_from`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO countries VALUES('1','US','United States');
INSERT INTO countries VALUES('2','CA','Canada');
INSERT INTO countries VALUES('3','AF','Afghanistan');
INSERT INTO countries VALUES('4','AL','Albania');
INSERT INTO countries VALUES('5','DZ','Algeria');
INSERT INTO countries VALUES('6','DS','American Samoa');
INSERT INTO countries VALUES('7','AD','Andorra');
INSERT INTO countries VALUES('8','AO','Angola');
INSERT INTO countries VALUES('9','AI','Anguilla');
INSERT INTO countries VALUES('10','AQ','Antarctica');
INSERT INTO countries VALUES('11','AG','Antigua and/or Barbuda');
INSERT INTO countries VALUES('12','AR','Argentina');
INSERT INTO countries VALUES('13','AM','Armenia');
INSERT INTO countries VALUES('14','AW','Aruba');
INSERT INTO countries VALUES('15','AU','Australia');
INSERT INTO countries VALUES('16','AT','Austria');
INSERT INTO countries VALUES('17','AZ','Azerbaijan');
INSERT INTO countries VALUES('18','BS','Bahamas');
INSERT INTO countries VALUES('19','BH','Bahrain');
INSERT INTO countries VALUES('20','BD','Bangladesh');
INSERT INTO countries VALUES('21','BB','Barbados');
INSERT INTO countries VALUES('22','BY','Belarus');
INSERT INTO countries VALUES('23','BE','Belgium');
INSERT INTO countries VALUES('24','BZ','Belize');
INSERT INTO countries VALUES('25','BJ','Benin');
INSERT INTO countries VALUES('26','BM','Bermuda');
INSERT INTO countries VALUES('27','BT','Bhutan');
INSERT INTO countries VALUES('28','BO','Bolivia');
INSERT INTO countries VALUES('29','BA','Bosnia and Herzegovina');
INSERT INTO countries VALUES('30','BW','Botswana');
INSERT INTO countries VALUES('31','BV','Bouvet Island');
INSERT INTO countries VALUES('32','BR','Brazil');
INSERT INTO countries VALUES('33','IO','British lndian Ocean Territory');
INSERT INTO countries VALUES('34','BN','Brunei Darussalam');
INSERT INTO countries VALUES('35','BG','Bulgaria');
INSERT INTO countries VALUES('36','BF','Burkina Faso');
INSERT INTO countries VALUES('37','BI','Burundi');
INSERT INTO countries VALUES('38','KH','Cambodia');
INSERT INTO countries VALUES('39','CM','Cameroon');
INSERT INTO countries VALUES('40','CV','Cape Verde');
INSERT INTO countries VALUES('41','KY','Cayman Islands');
INSERT INTO countries VALUES('42','CF','Central African Republic');
INSERT INTO countries VALUES('43','TD','Chad');
INSERT INTO countries VALUES('44','CL','Chile');
INSERT INTO countries VALUES('45','CN','China');
INSERT INTO countries VALUES('46','CX','Christmas Island');
INSERT INTO countries VALUES('47','CC','Cocos (Keeling) Islands');
INSERT INTO countries VALUES('48','CO','Colombia');
INSERT INTO countries VALUES('49','KM','Comoros');
INSERT INTO countries VALUES('50','CG','Congo');
INSERT INTO countries VALUES('51','CK','Cook Islands');
INSERT INTO countries VALUES('52','CR','Costa Rica');
INSERT INTO countries VALUES('53','HR','Croatia (Hrvatska)');
INSERT INTO countries VALUES('54','CU','Cuba');
INSERT INTO countries VALUES('55','CY','Cyprus');
INSERT INTO countries VALUES('56','CZ','Czech Republic');
INSERT INTO countries VALUES('57','DK','Denmark');
INSERT INTO countries VALUES('58','DJ','Djibouti');
INSERT INTO countries VALUES('59','DM','Dominica');
INSERT INTO countries VALUES('60','DO','Dominican Republic');
INSERT INTO countries VALUES('61','TP','East Timor');
INSERT INTO countries VALUES('62','EC','Ecudaor');
INSERT INTO countries VALUES('63','EG','Egypt');
INSERT INTO countries VALUES('64','SV','El Salvador');
INSERT INTO countries VALUES('65','GQ','Equatorial Guinea');
INSERT INTO countries VALUES('66','ER','Eritrea');
INSERT INTO countries VALUES('67','EE','Estonia');
INSERT INTO countries VALUES('68','ET','Ethiopia');
INSERT INTO countries VALUES('69','FK','Falkland Islands (Malvinas)');
INSERT INTO countries VALUES('70','FO','Faroe Islands');
INSERT INTO countries VALUES('71','FJ','Fiji');
INSERT INTO countries VALUES('72','FI','Finland');
INSERT INTO countries VALUES('73','FR','France');
INSERT INTO countries VALUES('74','FX','France, Metropolitan');
INSERT INTO countries VALUES('75','GF','French Guiana');
INSERT INTO countries VALUES('76','PF','French Polynesia');
INSERT INTO countries VALUES('77','TF','French Southern Territories');
INSERT INTO countries VALUES('78','GA','Gabon');
INSERT INTO countries VALUES('79','GM','Gambia');
INSERT INTO countries VALUES('80','GE','Georgia');
INSERT INTO countries VALUES('81','DE','Germany');
INSERT INTO countries VALUES('82','GH','Ghana');
INSERT INTO countries VALUES('83','GI','Gibraltar');
INSERT INTO countries VALUES('84','GR','Greece');
INSERT INTO countries VALUES('85','GL','Greenland');
INSERT INTO countries VALUES('86','GD','Grenada');
INSERT INTO countries VALUES('87','GP','Guadeloupe');
INSERT INTO countries VALUES('88','GU','Guam');
INSERT INTO countries VALUES('89','GT','Guatemala');
INSERT INTO countries VALUES('90','GN','Guinea');
INSERT INTO countries VALUES('91','GW','Guinea-Bissau');
INSERT INTO countries VALUES('92','GY','Guyana');
INSERT INTO countries VALUES('93','HT','Haiti');
INSERT INTO countries VALUES('94','HM','Heard and Mc Donald Islands');
INSERT INTO countries VALUES('95','HN','Honduras');
INSERT INTO countries VALUES('96','HK','Hong Kong');
INSERT INTO countries VALUES('97','HU','Hungary');
INSERT INTO countries VALUES('98','IS','Iceland');
INSERT INTO countries VALUES('99','IN','India');
INSERT INTO countries VALUES('100','ID','Indonesia');
INSERT INTO countries VALUES('101','IR','Iran (Islamic Republic of)');
INSERT INTO countries VALUES('102','IQ','Iraq');
INSERT INTO countries VALUES('103','IE','Ireland');
INSERT INTO countries VALUES('104','IL','Israel');
INSERT INTO countries VALUES('105','IT','Italy');
INSERT INTO countries VALUES('106','CI','Ivory Coast');
INSERT INTO countries VALUES('107','JM','Jamaica');
INSERT INTO countries VALUES('108','JP','Japan');
INSERT INTO countries VALUES('109','JO','Jordan');
INSERT INTO countries VALUES('110','KZ','Kazakhstan');
INSERT INTO countries VALUES('111','KE','Kenya');
INSERT INTO countries VALUES('112','KI','Kiribati');
INSERT INTO countries VALUES('113','KP','Korea, Democratic People\'s Republic of');
INSERT INTO countries VALUES('114','KR','Korea, Republic of');
INSERT INTO countries VALUES('115','KW','Kuwait');
INSERT INTO countries VALUES('116','KG','Kyrgyzstan');
INSERT INTO countries VALUES('117','LA','Lao People\'s Democratic Republic');
INSERT INTO countries VALUES('118','LV','Latvia');
INSERT INTO countries VALUES('119','LB','Lebanon');
INSERT INTO countries VALUES('120','LS','Lesotho');
INSERT INTO countries VALUES('121','LR','Liberia');
INSERT INTO countries VALUES('122','LY','Libyan Arab Jamahiriya');
INSERT INTO countries VALUES('123','LI','Liechtenstein');
INSERT INTO countries VALUES('124','LT','Lithuania');
INSERT INTO countries VALUES('125','LU','Luxembourg');
INSERT INTO countries VALUES('126','MO','Macau');
INSERT INTO countries VALUES('127','MK','Macedonia');
INSERT INTO countries VALUES('128','MG','Madagascar');
INSERT INTO countries VALUES('129','MW','Malawi');
INSERT INTO countries VALUES('130','MY','Malaysia');
INSERT INTO countries VALUES('131','MV','Maldives');
INSERT INTO countries VALUES('132','ML','Mali');
INSERT INTO countries VALUES('133','MT','Malta');
INSERT INTO countries VALUES('134','MH','Marshall Islands');
INSERT INTO countries VALUES('135','MQ','Martinique');
INSERT INTO countries VALUES('136','MR','Mauritania');
INSERT INTO countries VALUES('137','MU','Mauritius');
INSERT INTO countries VALUES('138','TY','Mayotte');
INSERT INTO countries VALUES('139','MX','Mexico');
INSERT INTO countries VALUES('140','FM','Micronesia, Federated States of');
INSERT INTO countries VALUES('141','MD','Moldova, Republic of');
INSERT INTO countries VALUES('142','MC','Monaco');
INSERT INTO countries VALUES('143','MN','Mongolia');
INSERT INTO countries VALUES('144','MS','Montserrat');
INSERT INTO countries VALUES('145','MA','Morocco');
INSERT INTO countries VALUES('146','MZ','Mozambique');
INSERT INTO countries VALUES('147','MM','Myanmar');
INSERT INTO countries VALUES('148','NA','Namibia');
INSERT INTO countries VALUES('149','NR','Nauru');
INSERT INTO countries VALUES('150','NP','Nepal');
INSERT INTO countries VALUES('151','NL','Netherlands');
INSERT INTO countries VALUES('152','AN','Netherlands Antilles');
INSERT INTO countries VALUES('153','NC','New Caledonia');
INSERT INTO countries VALUES('154','NZ','New Zealand');
INSERT INTO countries VALUES('155','NI','Nicaragua');
INSERT INTO countries VALUES('156','NE','Niger');
INSERT INTO countries VALUES('157','NG','Nigeria');
INSERT INTO countries VALUES('158','NU','Niue');
INSERT INTO countries VALUES('159','NF','Norfork Island');
INSERT INTO countries VALUES('160','MP','Northern Mariana Islands');
INSERT INTO countries VALUES('161','NO','Norway');
INSERT INTO countries VALUES('162','OM','Oman');
INSERT INTO countries VALUES('163','PK','Pakistan');
INSERT INTO countries VALUES('164','PW','Palau');
INSERT INTO countries VALUES('165','PA','Panama');
INSERT INTO countries VALUES('166','PG','Papua New Guinea');
INSERT INTO countries VALUES('167','PY','Paraguay');
INSERT INTO countries VALUES('168','PE','Peru');
INSERT INTO countries VALUES('169','PH','Philippines');
INSERT INTO countries VALUES('170','PN','Pitcairn');
INSERT INTO countries VALUES('171','PL','Poland');
INSERT INTO countries VALUES('172','PT','Portugal');
INSERT INTO countries VALUES('173','PR','Puerto Rico');
INSERT INTO countries VALUES('174','QA','Qatar');
INSERT INTO countries VALUES('175','RE','Reunion');
INSERT INTO countries VALUES('176','RO','Romania');
INSERT INTO countries VALUES('177','RU','Russian Federation');
INSERT INTO countries VALUES('178','RW','Rwanda');
INSERT INTO countries VALUES('179','KN','Saint Kitts and Nevis');
INSERT INTO countries VALUES('180','LC','Saint Lucia');
INSERT INTO countries VALUES('181','VC','Saint Vincent and the Grenadines');
INSERT INTO countries VALUES('182','WS','Samoa');
INSERT INTO countries VALUES('183','SM','San Marino');
INSERT INTO countries VALUES('184','ST','Sao Tome and Principe');
INSERT INTO countries VALUES('185','SA','Saudi Arabia');
INSERT INTO countries VALUES('186','SN','Senegal');
INSERT INTO countries VALUES('187','SC','Seychelles');
INSERT INTO countries VALUES('188','SL','Sierra Leone');
INSERT INTO countries VALUES('189','SG','Singapore');
INSERT INTO countries VALUES('190','SK','Slovakia');
INSERT INTO countries VALUES('191','SI','Slovenia');
INSERT INTO countries VALUES('192','SB','Solomon Islands');
INSERT INTO countries VALUES('193','SO','Somalia');
INSERT INTO countries VALUES('194','ZA','South Africa');
INSERT INTO countries VALUES('195','GS','South Georgia South Sandwich Islands');
INSERT INTO countries VALUES('196','ES','Spain');
INSERT INTO countries VALUES('197','LK','Sri Lanka');
INSERT INTO countries VALUES('198','SH','St. Helena');
INSERT INTO countries VALUES('199','PM','St. Pierre and Miquelon');
INSERT INTO countries VALUES('200','SD','Sudan');
INSERT INTO countries VALUES('201','SR','Suriname');
INSERT INTO countries VALUES('202','SJ','Svalbarn and Jan Mayen Islands');
INSERT INTO countries VALUES('203','SZ','Swaziland');
INSERT INTO countries VALUES('204','SE','Sweden');
INSERT INTO countries VALUES('205','CH','Switzerland');
INSERT INTO countries VALUES('206','SY','Syrian Arab Republic');
INSERT INTO countries VALUES('207','TW','Taiwan');
INSERT INTO countries VALUES('208','TJ','Tajikistan');
INSERT INTO countries VALUES('209','TZ','Tanzania, United Republic of');
INSERT INTO countries VALUES('210','TH','Thailand');
INSERT INTO countries VALUES('211','TG','Togo');
INSERT INTO countries VALUES('212','TK','Tokelau');
INSERT INTO countries VALUES('213','TO','Tonga');
INSERT INTO countries VALUES('214','TT','Trinidad and Tobago');
INSERT INTO countries VALUES('215','TN','Tunisia');
INSERT INTO countries VALUES('216','TR','Turkey');
INSERT INTO countries VALUES('217','TM','Turkmenistan');
INSERT INTO countries VALUES('218','TC','Turks and Caicos Islands');
INSERT INTO countries VALUES('219','TV','Tuvalu');
INSERT INTO countries VALUES('220','UG','Uganda');
INSERT INTO countries VALUES('221','UA','Ukraine');
INSERT INTO countries VALUES('222','AE','United Arab Emirates');
INSERT INTO countries VALUES('223','GB','United Kingdom');
INSERT INTO countries VALUES('224','UM','United States minor outlying islands');
INSERT INTO countries VALUES('225','UY','Uruguay');
INSERT INTO countries VALUES('226','UZ','Uzbekistan');
INSERT INTO countries VALUES('227','VU','Vanuatu');
INSERT INTO countries VALUES('228','VA','Vatican City State');
INSERT INTO countries VALUES('229','VE','Venezuela');
INSERT INTO countries VALUES('230','VN','Vietnam');
INSERT INTO countries VALUES('231','VG','Virigan Islands (British)');
INSERT INTO countries VALUES('232','VI','Virgin Islands (U.S.)');
INSERT INTO countries VALUES('233','WF','Wallis and Futuna Islands');
INSERT INTO countries VALUES('234','EH','Western Sahara');
INSERT INTO countries VALUES('235','YE','Yemen');
INSERT INTO countries VALUES('236','YU','Yugoslavia');
INSERT INTO countries VALUES('237','ZR','Zaire');
INSERT INTO countries VALUES('238','ZM','Zambia');
INSERT INTO countries VALUES('239','ZW','Zimbabwe');



CREATE TABLE `departments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `department_name` varchar(191) NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_head` bigint(20) unsigned DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `departments_company_id_foreign` (`company_id`),
  KEY `departments_department_head_foreign` (`department_head`),
  CONSTRAINT `departments_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `departments_department_head_foreign` FOREIGN KEY (`department_head`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO departments VALUES('2','ENGINEERING','1','','','2024-02-05 16:10:01','2024-02-05 16:10:01');
INSERT INTO departments VALUES('3','FINANCE','1','','','2024-02-05 16:55:21','2024-02-05 16:55:21');
INSERT INTO departments VALUES('4','ACC & TAX','1','','','2024-02-05 16:55:34','2024-02-05 16:55:34');
INSERT INTO departments VALUES('5','ACCOUNT PAYABLE','1','','','2024-02-05 16:56:06','2024-02-05 16:56:06');
INSERT INTO departments VALUES('7','INFORMATION TECHNOLOGY','1','','','2024-02-05 16:56:41','2024-02-05 16:56:41');
INSERT INTO departments VALUES('9','LEGAL & INSURANCE','1','','','2024-02-05 16:57:51','2024-02-05 16:57:51');
INSERT INTO departments VALUES('10','ASSET MANAGEMENT','1','','','2024-02-05 16:58:28','2024-02-05 16:58:28');
INSERT INTO departments VALUES('12','PROCUREMENT','1','','','2024-02-05 16:58:45','2024-02-05 16:58:45');
INSERT INTO departments VALUES('13','QMR','1','','','2024-02-05 16:58:59','2024-02-05 16:58:59');
INSERT INTO departments VALUES('14','CONTENT CREATIVE & BRANDING','1','','','2024-02-05 16:59:24','2024-02-05 16:59:24');
INSERT INTO departments VALUES('15','BUSINESS DEVELOPMENT','1','','','2024-02-05 16:59:53','2024-02-05 16:59:53');
INSERT INTO departments VALUES('16','FABRICATION SHOP','1','','','2024-02-05 17:00:09','2024-02-05 17:00:09');
INSERT INTO departments VALUES('17','HR & GA','2','','','2024-02-05 17:00:13','2024-02-05 17:00:13');
INSERT INTO departments VALUES('18','PMT','1','','','2024-02-05 17:01:00','2024-02-05 17:01:00');
INSERT INTO departments VALUES('19','PROJECT SERVICE','1','','','2024-02-05 17:01:19','2024-02-05 17:01:19');
INSERT INTO departments VALUES('20','HSSE','1','','','2024-02-05 17:01:27','2024-02-05 17:01:27');
INSERT INTO departments VALUES('21','HR & GA','1','','','2024-02-05 17:01:38','2024-02-05 17:01:38');
INSERT INTO departments VALUES('23','QA/QC','1','','','2024-02-05 17:01:46','2024-02-05 17:01:46');
INSERT INTO departments VALUES('24','AUDITOR','1','','','2024-02-05 17:02:09','2024-02-05 17:02:09');
INSERT INTO departments VALUES('25','ENGINEERING','2','','','2024-02-05 17:46:57','2024-02-05 17:46:57');
INSERT INTO departments VALUES('27','CSE','3','','','2024-02-05 19:45:18','2024-02-05 19:45:18');
INSERT INTO departments VALUES('28','PMT','3','','','2024-02-05 19:46:00','2024-02-05 19:46:00');
INSERT INTO departments VALUES('29','HR & GA','3','','','2024-02-05 19:46:15','2024-02-05 19:46:15');
INSERT INTO departments VALUES('30','FINANCE','3','','','2024-02-05 19:47:15','2024-02-05 19:47:15');
INSERT INTO departments VALUES('31','QA & QC','3','','','2024-02-05 19:47:22','2024-02-05 19:47:22');
INSERT INTO departments VALUES('32','PPC','3','','','2024-02-05 19:47:28','2024-02-05 19:47:28');
INSERT INTO departments VALUES('33','ENGINEERING','3','','','2024-02-05 19:47:48','2024-02-05 19:47:48');
INSERT INTO departments VALUES('34','HSSE','3','','','2024-02-05 19:47:56','2024-02-05 19:47:56');
INSERT INTO departments VALUES('35','PRODUCTION','3','','','2024-02-05 19:48:06','2024-02-05 19:48:06');
INSERT INTO departments VALUES('36','LOGISTIC','3','','','2024-02-05 19:48:20','2024-02-05 19:48:20');
INSERT INTO departments VALUES('37','WAREHOUSE OFFSHORE','3','','','2024-02-05 19:48:37','2024-02-05 19:48:37');
INSERT INTO departments VALUES('38','ELECTRIC','2','','','2024-02-06 09:02:25','2024-02-06 09:02:25');
INSERT INTO departments VALUES('39','HEAVY EQUIPMENT','2','','','2024-02-06 09:02:48','2024-02-06 09:02:48');
INSERT INTO departments VALUES('40','HSSE','2','','','2024-02-06 09:02:57','2024-02-06 09:02:57');
INSERT INTO departments VALUES('41','INFORMATION TECHNOLOGY','2','','','2024-02-06 09:03:25','2024-02-06 09:03:25');
INSERT INTO departments VALUES('42','MATERIAL HANDLING','2','','','2024-02-06 09:04:15','2024-02-06 09:04:15');
INSERT INTO departments VALUES('43','MECHANICAL','2','','','2024-02-06 09:04:44','2024-02-06 09:04:44');
INSERT INTO departments VALUES('44','PAINTING','2','','','2024-02-06 09:04:51','2024-02-06 09:04:51');
INSERT INTO departments VALUES('45','PIPING','2','','','2024-02-06 09:05:01','2024-02-06 09:05:01');
INSERT INTO departments VALUES('46','PMT','2','','','2024-02-06 09:05:12','2024-02-06 09:05:12');
INSERT INTO departments VALUES('47','PPC','2','','','2024-02-06 09:05:29','2024-02-06 09:05:29');
INSERT INTO departments VALUES('48','PROCUREMENT','2','','','2024-02-06 09:06:25','2024-02-06 09:06:25');
INSERT INTO departments VALUES('49','QA/QC','2','','','2024-02-06 09:06:34','2024-02-06 09:06:34');
INSERT INTO departments VALUES('50','RIGGING','2','','','2024-02-06 09:06:41','2024-02-06 09:06:41');
INSERT INTO departments VALUES('51','SCAFFOLDING','2','','','2024-02-06 09:06:48','2024-02-06 09:06:48');
INSERT INTO departments VALUES('52','SDCC','2','','','2024-02-06 09:07:00','2024-02-06 09:07:00');
INSERT INTO departments VALUES('53','STRUCTURE','2','','','2024-02-06 09:07:11','2024-02-06 09:07:11');
INSERT INTO departments VALUES('55','WAREHOUSE','2','','','2024-02-06 09:07:36','2024-02-06 09:07:36');
INSERT INTO departments VALUES('56','WELDING','2','','','2024-02-06 09:07:43','2024-02-06 09:07:43');
INSERT INTO departments VALUES('57','HR & GA','3','','','2024-02-20 20:50:17','2024-02-20 20:50:17');
INSERT INTO departments VALUES('58','HR & GA','4','','','2024-02-20 20:51:39','2024-02-20 20:51:39');
INSERT INTO departments VALUES('59','FINANCE','4','','','2024-02-20 20:51:49','2024-02-20 20:51:49');
INSERT INTO departments VALUES('60','HR & GA','5','','','2024-02-20 20:51:56','2024-02-20 20:51:56');
INSERT INTO departments VALUES('61','FINANCE','5','','','2024-02-20 20:52:03','2024-02-20 20:52:03');
INSERT INTO departments VALUES('62','HR & GA','6','','','2024-02-20 20:52:09','2024-02-20 20:52:09');
INSERT INTO departments VALUES('63','FINANCE','6','','','2024-02-20 20:52:15','2024-02-20 20:52:15');
INSERT INTO departments VALUES('64','HR & GA','7','','','2024-02-20 20:52:21','2024-02-20 20:52:21');
INSERT INTO departments VALUES('65','FINANCE','7','','','2024-02-20 20:52:27','2024-02-20 20:52:27');
INSERT INTO departments VALUES('66','HR & GA','8','','','2024-02-20 20:52:32','2024-02-20 20:52:32');
INSERT INTO departments VALUES('67','FINANCE','8','','','2024-02-20 20:52:38','2024-02-20 20:52:38');



CREATE TABLE `designations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `designation_name` text NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `designations_company_id_foreign` (`company_id`),
  KEY `designations_department_id_foreign` (`department_id`),
  CONSTRAINT `designations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `designations_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO designations VALUES('1','HR & GA Officer','1','','','2024-02-05 15:51:46','2024-02-05 17:48:57');
INSERT INTO designations VALUES('2','FINANCE MANAGER','1','3','','2024-02-05 17:44:56','2024-02-05 17:44:56');
INSERT INTO designations VALUES('3','HR & GA Staff','1','21','','2024-02-05 17:45:07','2024-02-05 17:45:07');
INSERT INTO designations VALUES('4','PROCESS IMPROVEMENT STAFF','1','13','','2024-02-05 17:45:26','2024-02-05 17:45:26');
INSERT INTO designations VALUES('5','Staff','2','17','','2024-02-05 18:08:41','2024-02-05 18:08:41');
INSERT INTO designations VALUES('6','STAFF','3','30','','2024-02-20 20:53:37','2024-02-20 20:53:37');
INSERT INTO designations VALUES('7','STAFF','3','36','','2024-02-20 20:54:00','2024-02-20 20:54:00');
INSERT INTO designations VALUES('8','STAFF','3','27','','2024-02-20 20:54:10','2024-02-20 20:54:10');
INSERT INTO designations VALUES('9','STAFF','3','33','','2024-02-20 20:54:23','2024-02-20 20:54:23');
INSERT INTO designations VALUES('10','STAFF','3','29','','2024-02-20 20:54:40','2024-02-20 20:54:40');
INSERT INTO designations VALUES('11','STAFF','3','34','','2024-02-20 20:54:51','2024-02-20 20:54:51');
INSERT INTO designations VALUES('12','STAFF','3','28','','2024-02-20 20:55:08','2024-02-20 20:55:08');
INSERT INTO designations VALUES('13','STAFF','3','32','','2024-02-20 20:55:25','2024-02-20 20:55:25');
INSERT INTO designations VALUES('14','STAFF','3','35','','2024-02-20 20:55:35','2024-02-20 20:55:35');
INSERT INTO designations VALUES('15','STAFF','4','59','','2024-02-20 20:55:45','2024-02-20 20:55:45');
INSERT INTO designations VALUES('16','STAFF','4','58','','2024-02-20 20:55:54','2024-02-20 20:55:54');
INSERT INTO designations VALUES('17','STAFF','5','61','','2024-02-20 20:56:11','2024-02-20 20:56:11');
INSERT INTO designations VALUES('18','STAFF','5','60','','2024-02-20 20:56:24','2024-02-20 20:56:24');
INSERT INTO designations VALUES('19','STAFF','6','63','','2024-02-20 20:56:33','2024-02-20 20:56:33');
INSERT INTO designations VALUES('20','STAFF','6','62','','2024-02-20 20:56:51','2024-02-20 20:56:51');
INSERT INTO designations VALUES('21','STAFF','7','65','','2024-02-20 20:57:09','2024-02-20 20:57:09');
INSERT INTO designations VALUES('22','STAFF','7','64','','2024-02-20 20:57:18','2024-02-20 20:57:18');
INSERT INTO designations VALUES('23','STAFF','8','67','','2024-02-20 20:57:27','2024-02-20 20:57:27');
INSERT INTO designations VALUES('24','STAFF','8','66','','2024-02-20 20:57:35','2024-02-20 20:57:35');



CREATE TABLE `document_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `document_type` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_types_company_id_foreign` (`company_id`),
  CONSTRAINT `document_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO document_types VALUES('1','','KTP','2024-02-26 09:00:15','2024-02-26 09:00:15');
INSERT INTO document_types VALUES('2','','NPWP','2024-02-26 09:00:24','2024-02-26 09:00:24');



CREATE TABLE `employee_bank_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `account_name` varchar(191) DEFAULT NULL,
  `account_number` varchar(191) NOT NULL,
  `bank_name` varchar(191) NOT NULL,
  `bank_code` varchar(191) NOT NULL,
  `bank_branch` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_bank_accounts_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_bank_accounts_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_bank_accounts VALUES('1','2030','Afrianto Simbolon','1080023316657','Mandiri','008','Pangkalan Kerinci','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_bank_accounts VALUES('2','2031','Diahayu Paramudita','1110011516339','Mandiri','008','Pangkalan Kerinci','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_bank_accounts VALUES('3','2032','Putri Arta Manullang','1080022774229','Mandiri','008','Pangkalan Kerinci','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_bank_accounts VALUES('4','2033','Berri Pratama Putra','1210010254708','Mandiri','008','Pangkalan Kerinci','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_bank_accounts VALUES('5','2034','Isra Alfarizi','1070016073647','Mandiri','008','Pangkalan Kerinci','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_bank_accounts VALUES('6','2035','Rezki Saputra Noflin','1080022904990','Mandiri','008','Pangkalan Kerinci','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_bank_accounts VALUES('7','2036','Grant Samuel Samosir','1080018832536','Mandiri','008','Pangkalan Kerinci','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_bank_accounts VALUES('8','2037','Ade Syaputri','1080018832536','Mandiri','008','Pangkalan Kerinci','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_bank_accounts VALUES('9','2038','Aidil Raka','1080019712794','Mandiri','008','Pangkalan Kerinci','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_bank_accounts VALUES('10','2039','Sunarya Sunarya','1080018832536','Mandiri','008','Pangkalan Kerinci','2024-02-05 16:23:27','2024-02-05 16:23:27');
INSERT INTO employee_bank_accounts VALUES('11','2043','Afrianto Simbolon','1080023316657','Mandiri','008','Pangkalan Kerinci','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employee_bank_accounts VALUES('12','2044','Diahayu Paramudita','1110011516339','Mandiri','008','Pangkalan Kerinci','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employee_bank_accounts VALUES('13','2045','Putri Arta Manullang','1080022774229','Mandiri','008','Pangkalan Kerinci','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employee_bank_accounts VALUES('14','2046','Berri Pratama Putra','1210010254708','Mandiri','008','Pangkalan Kerinci','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employee_bank_accounts VALUES('15','2047','Isra Alfarizi','1070016073647','Mandiri','008','Pangkalan Kerinci','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employee_bank_accounts VALUES('16','2048','ALDO NATANIEL','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_bank_accounts VALUES('17','2049','HERI IRAWAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_bank_accounts VALUES('18','2050','RADEN FRANS HIDAYAT , SH','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_bank_accounts VALUES('19','2051','YENITA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_bank_accounts VALUES('20','2052','SARWAT','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_bank_accounts VALUES('21','2053','AMINULLOH','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_bank_accounts VALUES('22','2054','IJAH HADIJAH ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_bank_accounts VALUES('23','2055','DIDI RIYADI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_bank_accounts VALUES('24','2056','KASIM','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_bank_accounts VALUES('25','2057','JAKA ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_bank_accounts VALUES('26','2058','AHMAD YANI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('27','2059','ASWANI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('28','2060','WAWAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('29','2061','FIRLIADI AL HAPSI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('30','2062','SITI RATNA AINUN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('31','2063','ANTON FRANS','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('32','2064','SUGINO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('33','2065','NANANG NASRUR','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('34','2066','ETHANA HARITS BRYANO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('35','2067','SAEFUL FARIZ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('36','2068','HERRY SURYONO, S. KOM','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('37','2069','SUHEL ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_bank_accounts VALUES('38','2070','ANDRI KURNIAWAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('39','2071','MUHAMAD SULKHI SETIAWAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('40','2072','MUHAMAD IRFAN AL AMIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('41','2073','RIZKI RAMADHONA.W','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('42','2074','JEFRI SILALAHI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('43','2075','MOH HASYIM','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('44','2076','ALFI SYAHRIMADONA ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('45','2077','MARYONO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('46','2078','AHMAD HABIBI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('47','2079','RIFQI DHAIFULLAH','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('48','2080','DWI YUNIAR','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('49','2081','MOH. ARIFIN RUMAJI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('50','2082','WAHYU BUDIANTO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_bank_accounts VALUES('51','2083','IWAN SISWANDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('52','2084','VIVIT ERI HIDAYAT ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('53','2085','ANDRI PUJI SETIAWAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('54','2086','RENDY KERISNA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('55','2087','JAYA HERYANA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('56','2088','TARMIDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('57','2089','UMAR SUMARDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('58','2090','NANA SUCIATNA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('59','2091','SUROTO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('60','2092','ISMATULLAH ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('61','2093','MUHAMMAD PAHLEFI ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('62','2094','RUDI HARTONO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_bank_accounts VALUES('63','2095','ENDANG SAPUTRA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('64','2096','DARWIN SILALAHI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('65','2097','SAENIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('66','2098','NOR SAID','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('67','2099','RINTO SAMOSIR','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('68','2100','GENTHA OMAR PANJI WIJAYA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('69','2101','YUSUP RAMDHANI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('70','2102','SUYADI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('71','2103','REZA DIAN PERMANA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('72','2104','MUHLIS DONDI MIHARDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('73','2105','SANEN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('74','2106','AZIZ AMIRUDIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('75','2107','INGGA MULYANA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_bank_accounts VALUES('76','2108','SOFAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('77','2109','ERIK YULIADI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('78','2110','ANGGARA SAPUTRA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('79','2111','JHON ALBERT ARITONANG','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('80','2112','BAMBANG IRAWAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('81','2113','DEDI RASDIANTO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('82','2114','SASTRO WIJOYO BUTAR BUTAR','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('83','2115','SUHERI BIN IWAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('84','2116','SUANDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('85','2117','SUNDA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('86','2118','IMATULLAH','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('87','2119','MOCHAMAD HAERONI ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('88','2120','SUPARMAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_bank_accounts VALUES('89','2121','OSBIN MALAU','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('90','2122','YULIANTO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('91','2123','MAMAT','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('92','2124','ERWAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('93','2125','MATSAPIK','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('94','2126','WIGIHARDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('95','2127','SOLEMAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('96','2128','AKYADI BIN RIPAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('97','2129','DUDI ROHMAN ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('98','2130','SUPARNO ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('99','2131','SAEPUDIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('100','2132','YUSUF ADE SUPRIATNA ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('101','2133','SAEPULOH','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_bank_accounts VALUES('102','2134','NURAKHMAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('103','2135','PURWANTO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('104','2136','M MUSA EFENDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('105','2137','AGUS SOFYAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('106','2138','SUKARDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('107','2139','SUYATO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('108','2140','ELI HERMANSYAH ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('109','2141','RIKI PURWANTO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('110','2142','PARYONO ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('111','2143','IDDRISNO NAIBAHO ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('112','2144','RAHIMUDIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('113','2145','TOLHAS JONIER HUTASOIT ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_bank_accounts VALUES('114','2146','ROY RENOLD SIBURIAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('115','2147','DIAN HADIANSYAH ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('116','2148','JUNAIDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('117','2149','NIKMATULLAH','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('118','2150','IRWAN WAHYUDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('119','2151','AJISLIM SILABAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('120','2152','MANSYUR','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('121','2153','SOHADI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('122','2154','CHARLY NABABAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('123','2155','IMBRAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('124','2156','ANDRY FIRMANSYAH','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('125','2157','MUHAMAD JUPRI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('126','2158','SUHEMI ANDRIANSYAH','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_bank_accounts VALUES('127','2159','M.KAMAN SANUSI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('128','2160','WILLI AFRILIAN ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('129','2161','HERI SUARNO ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('130','2162','DASRON SINAGA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('131','2163','MUHAMMAD KAHFI ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('132','2164','ROHMAT','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('133','2165','JULI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('134','2166','JAJA SUNARJA ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('135','2167','MEDI ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('136','2168','ANDRI WIBOWO ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('137','2169','YAHYA SUPARJO ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('138','2170','DADANG SUGIANTO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('139','2171','RIDWAN SAIDI ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_bank_accounts VALUES('140','2172','M. ALI SODIKIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('141','2173','UTAMA WIJAYA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('142','2174','M. FAUZY','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('143','2175','ERLAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('144','2176','ASEP ACHYAR SUTISMAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('145','2177','DAMANHURI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('146','2178','SARKANI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('147','2179','SAEFUDIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('148','2180','KEMIS ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('149','2181','BUDI MUHAROM','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('150','2182','HERU SUMAS ADITYA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('151','2183','PARSAORAN GULTOM','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('152','2184','SANTOSO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_bank_accounts VALUES('153','2185','SAFIYUDIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('154','2186','SAPRUDIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('155','2187','MUCHTAR ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('156','2188','DADY ROSYADI ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('157','2189','RAHMATTULOH','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('158','2190','DIMAS CANDRA GIRISONA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('159','2191','PARYANTO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('160','2192','ERIK EXTRADA ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('161','2193','NANANG FARID ARIYANTO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('162','2194','MOCHAMAD SU\'UDI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('163','2195','AMIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('164','2196','ANTONI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('165','2197','MUHAMMAD RIDWAN AMIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_bank_accounts VALUES('166','2198','ARIS SUSANTO ','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_bank_accounts VALUES('167','2199','SUDARWAN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_bank_accounts VALUES('168','2200','MANAP','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_bank_accounts VALUES('169','2201','WAHYU DWI SAPUTRA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_bank_accounts VALUES('170','2202','MOH SUDARI WIBOWO','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_bank_accounts VALUES('171','2203','A.HAFIDULLAH','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_bank_accounts VALUES('172','2204','SAHRONI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_bank_accounts VALUES('173','2205','BINTANG CHANENSYA','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_bank_accounts VALUES('174','2206','KAMSARUDIN','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_bank_accounts VALUES('175','2207','ZULKIFLI','23432453','Bank Mandiri','8888','Cikande ','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_bank_accounts VALUES('176','2215','Tes bank title','23432453','tes bank name','tes bank code','test bank branch','2024-02-23 07:52:33','2024-02-23 07:52:33');
INSERT INTO employee_bank_accounts VALUES('184','2226','Mandiri','-1424382721','Agus Budi','123','Duta Merlin','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO employee_bank_accounts VALUES('185','2227','Mandiri','-4307303','Budi Yanto','123','Duta Merlin','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO employee_bank_accounts VALUES('186','2228','Mandiri','1415768115','Dwi Ayu Lestari ','123','Duta Merlin','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO employee_bank_accounts VALUES('187','2229','Mandiri','-1459123763','Ayu Cahya','123','Duta Merlin','2024-02-26 08:46:54','2024-02-26 08:46:54');
INSERT INTO employee_bank_accounts VALUES('188','2230','Mandiri','-39048345','Muhammad Bayu','123','Duta Merlin','2024-02-26 08:46:54','2024-02-26 08:46:54');



CREATE TABLE `employee_contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `relation` varchar(50) NOT NULL,
  `is_primary` tinyint(4) DEFAULT 0,
  `is_dependent` tinyint(4) DEFAULT 0,
  `contact_name` varchar(191) NOT NULL,
  `work_phone` varchar(191) DEFAULT NULL,
  `work_phone_ext` varchar(191) DEFAULT NULL,
  `personal_phone` varchar(191) DEFAULT NULL,
  `home_phone` varchar(191) DEFAULT NULL,
  `work_email` varchar(191) DEFAULT NULL,
  `personal_email` varchar(191) DEFAULT NULL,
  `address1` varchar(191) DEFAULT NULL,
  `address2` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `zip` varchar(191) DEFAULT NULL,
  `country_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_contacts_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_contacts_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_contacts VALUES('1','2211','parent','0','0','YUSNIAR PASARIBU','','','082288398124','','','yusniarpasaribu@gmail.com','Jl. Sekolah','','PEKANBARU','RIAU','28282','100','2024-02-07 08:47:26','2024-02-07 08:47:26');



CREATE TABLE `employee_documents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `document_type_id` bigint(20) unsigned DEFAULT NULL,
  `document_type` varchar(191) DEFAULT NULL,
  `document_title` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  `expiry_date` date NOT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_documents_employee_id_foreign` (`employee_id`),
  KEY `employee_documents_document_type_id_foreign` (`document_type_id`),
  CONSTRAINT `employee_documents_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_documents_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_documents VALUES('1','2211','','','','','1277021701970003.1707270713.jpg','2045-01-17','','2024-02-07 08:51:53','2024-02-07 08:51:53');
INSERT INTO employee_documents VALUES('2','2215','','','','test','1231313.1708650050.jpg','2026-10-28','','2024-02-23 08:00:50','2024-02-23 08:00:50');
INSERT INTO employee_documents VALUES('3','2212','1','','3171024308950002','','3171024308950002.1708913262.jpg','2029-02-26','','2024-02-26 09:07:42','2024-02-26 09:07:42');
INSERT INTO employee_documents VALUES('4','2212','2','','660026105026000','','660026105026000.1708913325.jpg','2029-02-26','','2024-02-26 09:08:45','2024-02-26 09:08:45');



CREATE TABLE `employee_immigrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `document_type_id` bigint(20) unsigned DEFAULT NULL,
  `document_type` varchar(191) DEFAULT NULL,
  `document_number` varchar(191) NOT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  `issue_date` date NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `eligible_review_date` date DEFAULT NULL,
  `country_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_immigrations_employee_id_foreign` (`employee_id`),
  KEY `employee_immigrations_document_type_id_foreign` (`document_type_id`),
  CONSTRAINT `employee_immigrations_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_immigrations_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_interview` (
  `interview_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`interview_id`,`employee_id`),
  KEY `employee_interview_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_interview_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `employee_interview_interview_id_foreign` FOREIGN KEY (`interview_id`) REFERENCES `job_interviews` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_meeting` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `meeting_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`meeting_id`),
  KEY `employee_meeting_meeting_id_foreign` (`meeting_id`),
  CONSTRAINT `employee_meeting_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_meeting_meeting_id_foreign` FOREIGN KEY (`meeting_id`) REFERENCES `meetings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_meeting VALUES('2041','1');
INSERT INTO employee_meeting VALUES('2042','2');



CREATE TABLE `employee_project` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `project_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`project_id`),
  KEY `employee_project_project_id_foreign` (`project_id`),
  CONSTRAINT `employee_project_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_project_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_qualificaitons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `education_level_id` bigint(20) unsigned DEFAULT NULL,
  `education_level` varchar(191) DEFAULT NULL,
  `institution_name` varchar(191) NOT NULL,
  `from_year` date DEFAULT NULL,
  `to_year` date DEFAULT NULL,
  `language_skill_id` bigint(20) unsigned DEFAULT NULL,
  `general_skill_id` bigint(20) unsigned DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_qualificaitons_employee_id_foreign` (`employee_id`),
  KEY `employee_qualificaitons_education_level_id_foreign` (`education_level_id`),
  KEY `employee_qualificaitons_language_skill_id_foreign` (`language_skill_id`),
  KEY `employee_qualificaitons_general_skill_id_foreign` (`general_skill_id`),
  CONSTRAINT `employee_qualificaitons_education_level_id_foreign` FOREIGN KEY (`education_level_id`) REFERENCES `qualification_education_levels` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_qualificaitons_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_qualificaitons_general_skill_id_foreign` FOREIGN KEY (`general_skill_id`) REFERENCES `qualification_skills` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_qualificaitons_language_skill_id_foreign` FOREIGN KEY (`language_skill_id`) REFERENCES `qualification_languages` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `is_bpjs_tk_include` tinyint(1) NOT NULL,
  `is_bpjs_kes_include` tinyint(1) NOT NULL,
  `is_tax_include` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_settings_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_settings_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=190 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_settings VALUES('1','2030','1','0','1','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_settings VALUES('2','2031','1','0','1','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_settings VALUES('3','2032','1','0','1','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_settings VALUES('4','2033','1','0','1','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_settings VALUES('5','2034','1','0','1','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_settings VALUES('6','2035','1','1','1','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_settings VALUES('7','2036','1','1','1','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_settings VALUES('8','2037','1','0','1','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_settings VALUES('9','2038','1','1','1','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employee_settings VALUES('10','2039','1','0','1','2024-02-05 16:23:27','2024-02-05 16:23:27');
INSERT INTO employee_settings VALUES('11','2043','1','0','1','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employee_settings VALUES('12','2044','1','0','1','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employee_settings VALUES('13','2045','1','0','1','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employee_settings VALUES('14','2046','1','0','1','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employee_settings VALUES('15','2047','1','0','1','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employee_settings VALUES('16','2048','1','1','1','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_settings VALUES('17','2049','1','1','1','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_settings VALUES('18','2050','1','1','1','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_settings VALUES('19','2051','1','1','1','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_settings VALUES('20','2052','1','1','1','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_settings VALUES('21','2053','1','1','1','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_settings VALUES('22','2054','1','1','1','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_settings VALUES('23','2055','1','1','1','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_settings VALUES('24','2056','1','1','1','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_settings VALUES('25','2057','1','1','1','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employee_settings VALUES('26','2058','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('27','2059','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('28','2060','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('29','2061','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('30','2062','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('31','2063','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('32','2064','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('33','2065','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('34','2066','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('35','2067','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('36','2068','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('37','2069','1','1','1','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employee_settings VALUES('38','2070','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('39','2071','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('40','2072','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('41','2073','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('42','2074','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('43','2075','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('44','2076','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('45','2077','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('46','2078','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('47','2079','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('48','2080','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('49','2081','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('50','2082','1','1','1','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employee_settings VALUES('51','2083','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('52','2084','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('53','2085','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('54','2086','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('55','2087','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('56','2088','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('57','2089','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('58','2090','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('59','2091','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('60','2092','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('61','2093','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('62','2094','1','1','1','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employee_settings VALUES('63','2095','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('64','2096','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('65','2097','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('66','2098','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('67','2099','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('68','2100','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('69','2101','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('70','2102','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('71','2103','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('72','2104','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('73','2105','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('74','2106','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('75','2107','1','1','1','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employee_settings VALUES('76','2108','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('77','2109','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('78','2110','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('79','2111','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('80','2112','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('81','2113','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('82','2114','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('83','2115','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('84','2116','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('85','2117','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('86','2118','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('87','2119','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('88','2120','1','1','1','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employee_settings VALUES('89','2121','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('90','2122','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('91','2123','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('92','2124','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('93','2125','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('94','2126','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('95','2127','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('96','2128','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('97','2129','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('98','2130','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('99','2131','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('100','2132','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('101','2133','1','1','1','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employee_settings VALUES('102','2134','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('103','2135','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('104','2136','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('105','2137','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('106','2138','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('107','2139','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('108','2140','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('109','2141','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('110','2142','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('111','2143','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('112','2144','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('113','2145','1','1','1','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employee_settings VALUES('114','2146','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('115','2147','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('116','2148','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('117','2149','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('118','2150','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('119','2151','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('120','2152','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('121','2153','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('122','2154','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('123','2155','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('124','2156','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('125','2157','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('126','2158','1','1','1','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employee_settings VALUES('127','2159','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('128','2160','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('129','2161','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('130','2162','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('131','2163','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('132','2164','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('133','2165','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('134','2166','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('135','2167','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('136','2168','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('137','2169','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('138','2170','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('139','2171','1','1','1','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employee_settings VALUES('140','2172','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('141','2173','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('142','2174','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('143','2175','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('144','2176','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('145','2177','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('146','2178','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('147','2179','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('148','2180','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('149','2181','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('150','2182','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('151','2183','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('152','2184','1','1','1','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employee_settings VALUES('153','2185','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('154','2186','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('155','2187','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('156','2188','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('157','2189','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('158','2190','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('159','2191','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('160','2192','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('161','2193','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('162','2194','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('163','2195','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('164','2196','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('165','2197','1','1','1','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employee_settings VALUES('166','2198','1','1','1','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_settings VALUES('167','2199','1','1','1','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_settings VALUES('168','2200','1','1','1','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_settings VALUES('169','2201','1','1','1','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_settings VALUES('170','2202','1','1','1','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_settings VALUES('171','2203','1','1','1','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_settings VALUES('172','2204','1','1','1','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_settings VALUES('173','2205','1','1','1','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_settings VALUES('174','2206','1','1','1','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_settings VALUES('175','2207','1','1','1','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employee_settings VALUES('176','2215','1','0','1','2024-02-23 07:52:33','2024-02-23 07:52:33');
INSERT INTO employee_settings VALUES('184','2226','1','1','1','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO employee_settings VALUES('185','2227','1','1','1','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO employee_settings VALUES('186','2228','1','1','1','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO employee_settings VALUES('187','2229','1','1','1','2024-02-26 08:46:54','2024-02-26 08:46:54');
INSERT INTO employee_settings VALUES('188','2230','1','1','1','2024-02-26 08:46:54','2024-02-26 08:46:54');
INSERT INTO employee_settings VALUES('189','2212','1','1','1','2024-02-26 08:56:16','2024-02-26 08:56:16');



CREATE TABLE `employee_support_ticket` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `support_ticket_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`support_ticket_id`),
  KEY `employee_support_ticket_support_ticket_id_foreign` (`support_ticket_id`),
  CONSTRAINT `employee_support_ticket_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_support_ticket_support_ticket_id_foreign` FOREIGN KEY (`support_ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_task` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `task_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`task_id`),
  KEY `employee_task_task_id_foreign` (`task_id`),
  CONSTRAINT `employee_task_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_task_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_training_list` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `training_list_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`training_list_id`),
  KEY `employee_training_list_training_list_id_foreign` (`training_list_id`),
  CONSTRAINT `employee_training_list_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_training_list_training_list_id_foreign` FOREIGN KEY (`training_list_id`) REFERENCES `training_lists` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_work_experience` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `company_name` varchar(191) NOT NULL,
  `from_year` date DEFAULT NULL,
  `to_year` date DEFAULT NULL,
  `post` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_work_experience_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_work_experience_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employee_work_experience VALUES('1','2211','PT Timas Suplindo','2020-02-08','2021-03-31','','','2024-02-07 08:59:32','2024-02-07 09:01:53');
INSERT INTO employee_work_experience VALUES('2','2212','PT. Astra World','2023-01-02','2024-02-26','','','2024-02-26 09:11:53','2024-02-26 09:11:53');



CREATE TABLE `employees` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `staff_id` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `identity_number` varchar(191) NOT NULL,
  `npwp` varchar(16) DEFAULT NULL,
  `contact_no` varchar(15) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `gender` varchar(191) DEFAULT NULL,
  `office_shift_id` bigint(20) unsigned DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `designation_id` bigint(20) unsigned DEFAULT NULL,
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `role_users_id` bigint(20) unsigned DEFAULT NULL,
  `status_id` bigint(20) unsigned DEFAULT NULL,
  `following_company_id` bigint(20) unsigned DEFAULT NULL,
  `following_employee_id` bigint(20) unsigned DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `exit_date` date DEFAULT NULL,
  `marital_status` varchar(191) DEFAULT NULL,
  `religion` varchar(191) DEFAULT NULL,
  `dependent` varchar(191) NOT NULL,
  `address` text DEFAULT NULL,
  `city` varchar(64) DEFAULT NULL,
  `state` varchar(64) DEFAULT NULL,
  `country` varchar(64) DEFAULT NULL,
  `zip_code` varchar(24) DEFAULT NULL,
  `cv` varchar(64) DEFAULT NULL,
  `skype_id` varchar(64) DEFAULT NULL,
  `fb_id` varchar(64) DEFAULT NULL,
  `twitter_id` varchar(64) DEFAULT NULL,
  `linkedIn_id` varchar(64) DEFAULT NULL,
  `whatsapp_id` varchar(64) DEFAULT NULL,
  `basic_salary` double DEFAULT 0,
  `payslip_type` varchar(191) DEFAULT NULL,
  `attendance_type` varchar(191) DEFAULT NULL,
  `total_leave` int(11) DEFAULT 0,
  `remaining_leave` int(11) DEFAULT 0,
  `last_year_leave` double NOT NULL,
  `pension_type` varchar(50) DEFAULT NULL,
  `pension_amount` double(8,2) DEFAULT 0.00,
  `is_dispensation` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  `is_payroll` tinyint(1) NOT NULL,
  `is_ceo` tinyint(1) NOT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employees_office_shift_id_foreign` (`office_shift_id`),
  KEY `employees_company_id_foreign` (`company_id`),
  KEY `employees_department_id_foreign` (`department_id`),
  KEY `employees_designation_id_foreign` (`designation_id`),
  KEY `employees_location_id_foreign` (`location_id`),
  KEY `employees_role_users_id_foreign` (`role_users_id`),
  KEY `employees_status_id_foreign` (`status_id`),
  KEY `employees_following_company_id_foreign` (`following_company_id`),
  KEY `employees_following_employee_id_foreign` (`following_employee_id`),
  CONSTRAINT `employees_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_designation_id_foreign` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_following_company_id_foreign` FOREIGN KEY (`following_company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_following_employee_id_foreign` FOREIGN KEY (`following_employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `locations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_office_shift_id_foreign` FOREIGN KEY (`office_shift_id`) REFERENCES `office_shifts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_role_users_id_foreign` FOREIGN KEY (`role_users_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employees_status_id_foreign` FOREIGN KEY (`status_id`) REFERENCES `statuses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2232 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employees VALUES('2030','AFRIANTO','SIMBOLON','AE03029','afrianto.simbolon@timas.com','1405020804980006','2147483647','082280107578','1998-04-08','','1','1','13','4','','2','1','','','2022-02-16','','single','islam','TK/0','JL.PEMDA GG.MAKMUR RT/RW 002/008 KEL.PKL KERINCI KOTA-PKL KERINCI-PELALAWAN-RIAU','PELALAWAN','RIAU','','12345','','','','','','','0','','ip_based','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 16:23:26','2024-02-05 18:00:57');
INSERT INTO employees VALUES('2031','Diahayu','Paramudita','AE00779','diahayu.paramudita@timas.com','1308056207950001','','085363049624','1995-07-22','Female','1','','','','','2','1','','','2021-08-20','','Single ','','TK/0','Sawah Mudik Jr. III Koto Tinggi Rt.00 Rw.000 Kel. Sundata Kec. Lubuk Sikaping Kab. Pesaman Sumbar','PASAMAN','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','0','fraud','2024-02-05 16:23:26','2024-02-05 18:11:53');
INSERT INTO employees VALUES('2032','Putri','Arta Manullang','AE02752','putri.manullang@timas.com','1471104904990001','','081212121212','1999-04-09','Male','1','','','','','2','1','','','2021-11-06','','Single ','','TK/0','Jl. Indrapuri Rt.003 Rw.005 Kel. BencahlesungKec. Tenayan Raya Kota Pekanbaru','KOTA PEKANBARU','RIAU','','12345','','','','','','','5000000','Monthly','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 16:23:26','2024-02-05 18:31:50');
INSERT INTO employees VALUES('2033','Berri','Pratama Putra','AE02769','berri@timas.com','1671032801880003','','081272221353','1988-01-28','Male','1','','','','','2','1','','','2021-11-08','','Married','','K/2','Jl.Sentosa Lr.Asli no 604 RT/RW:04/013 Kec SU II Palembang','KOT PALEMBANG','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employees VALUES('2034','Isra','Alfarizi','AE02566','isra.alfarizi@timas.com','1276020812960002','','085349913025','1996-12-08','Male','1','','','','','2','1','','','2021-08-05','','Single ','','TK/0','Jl. Kt Yosudarso Lk. 10 Rt.003 Rw.003 Kel. Tanjung Marulak Kec. Rambutan Kota Tebing Tinggi','KOTA TEBING TINGGI','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employees VALUES('2035','Rezki','Saputra Noflin','AE02774','rezki.noflin@timas.com','1403133007970230','','081368094492','1997-07-30','Male','1','','','','','2','1','','','2021-11-07','','Single ','','TK/0','Jl.Garuda RT/RW:002/003 Kel.Titian Antui kec.Pinggir,Bengkalis-Riau','BENGKALIS','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employees VALUES('2036','Grant','Samuel Samosir','AE00435','grant.samosir@timas.com','1202152211970001','','081368094492','1997-11-22','Male','1','','','','','2','1','','','2021-08-05','','Single ','','TK/0','Pasar Muara Rt.- Rw.- Kel. Huta Nagodang Kec. Muara Kab. Tapanuli Utara','TAPANULI UTARA','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employees VALUES('2037','Ade','Syaputri','AE02606','ade.syaputri@timas.com','1471065509900021','','081261583678','1990-09-15','Female','1','','','','','2','1','','','2021-09-01','','Single ','','TK/0','Jl. Nelayan Rt.001 Rw.010 Kel. Sri MerantiKec. Rumbai Kota Pekanbaru','PEKANBARU','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employees VALUES('2038','Aidil','Raka','AE01059','aidil@timas.com','1307021505940003','','082284658586','1994-05-15','Male','1','','','','','2','1','','','2021-08-16','','Married','','K/1','Tiakap Rt.- Rw.- Kel. Guguak VIII Koto Kec. Guguak Kab Lima Puluh Kota ','PAYAKUMBUH','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO employees VALUES('2039','SUNARYA','SUNARYA','AE09103','sunarya@timas.com','3206360710940003','','081368094492','1994-10-07','MALE','1','','','','','2','1','','','2023-05-08','','Married','','K/1','KP.CIPULUS RT/RW.002/003 KEL.BUGEL KEC.CIAWI KAB.TASIK MALAYA','JABAR','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 16:23:27','2024-02-05 16:23:27');
INSERT INTO employees VALUES('2040','RAMADHANI PUTRA','DEWANTO','AA9104','ramadhani.dewanto@timas.com','3174061803990001','2147483647','','1999-03-18','Male','1','1','13','4','','2','','','','2023-06-02','','single','islam','','','','','','','','','','','','','0','','ip_based','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 17:53:39','2024-02-05 17:53:39');
INSERT INTO employees VALUES('2041','DWITAMI','Wulandari','AA9105','dwitami.wulandari@timas.com','3171024308950002','2147483647','0859595894649','1995-08-03','Female','1','1','21','3','','2','1','','','2024-02-05','','single','islam','K/0','','','','100','','','','','','','','0','','ip_based','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 18:08:42','2024-02-07 10:10:51');
INSERT INTO employees VALUES('2042','Dwitami','Wulandari','AA9106','dwitami.wulandari@timas.com','3171024308950002','2147483647','089765432123','1995-08-03','Female','1','1','21','3','','6','1','','','2024-02-05','','single','islam','K/3','','','','','','','','','','','','0','','ip_based','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 18:15:19','2024-02-06 14:17:32');
INSERT INTO employees VALUES('2043','AFRIANTO','SIMBOLON','AE03029','afrianto.simbolon@timas.com','1405020804980006','','082280107578','1998-04-08','MALE','1','','','','','2','1','','','2022-02-16','','Single ','','TK/0','JL.PEMDA GG.MAKMUR RT/RW 002/008 KEL.PKL KERINCI KOTA-PKL KERINCI-PELALAWAN-RIAU','PELALAWAN','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employees VALUES('2044','Diahayu','Paramudita','AE00779','diahayu.paramudita@timas.com','1308056207950001','','085363049624','1995-07-22','Female','1','','','','','2','1','','','2021-08-20','','Single ','','TK/0','Sawah Mudik Jr. III Koto Tinggi Rt.00 Rw.000 Kel. Sundata Kec. Lubuk Sikaping Kab. Pesaman Sumbar','PASAMAN','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employees VALUES('2045','Putri','Arta Manullang','AE02752','putri.manullang@timas.com','1471104904990001','','081212121212','1999-04-09','Male','1','','','','','2','1','','','2021-11-06','','Single ','','TK/0','Jl. Indrapuri Rt.003 Rw.005 Kel. BencahlesungKec. Tenayan Raya Kota Pekanbaru','KOTA PEKANBARU','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employees VALUES('2046','Berri','Pratama Putra','AE02769','berri@timas.com','1671032801880003','','081272221353','1988-01-28','Male','1','','','','','2','1','','','2021-11-08','','Married','','K/2','Jl.Sentosa Lr.Asli no 604 RT/RW:04/013 Kec SU II Palembang','KOT PALEMBANG','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employees VALUES('2047','Arif Rahman','SR','AE02566','isra.alfarizi@timas.com','1276020812960002','','085349913025','1996-12-08','Male','1','','','','','2','1','','','2021-08-05','','Single ','','TK/0','Jl. Kt Yosudarso Lk. 10 Rt.003 Rw.003 Kel. Tanjung Marulak Kec. Rambutan Kota Tebing Tinggi','KOTA TEBING TINGGI','RIAU','','12345','','','','','','','0','','General','0','0','0','','0.00','0','1','0','0','1','','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO employees VALUES('2048','Aldo','Nataniel','AA00295','aldo.nataniel@timas.com','3201242804830006','2147483647','081315084746','1983-04-28','Male','1','1','21','3','','2','1','3','2048','2022-08-01','','married','islam','K/3','Jl.Sukajaya8 No.53 Rt/Rw 002/005 Kel.Tajur Kec.Kota Bogor Timur Bogor - Jawa Barat','Bogor','Jawa Barat','','6767','','','','','','','0','','ip_based','12','12','0','','0.00','0','1','0','0','1','','2024-02-06 09:52:01','2024-02-06 14:37:40');
INSERT INTO employees VALUES('2049','Heri','Irawan','AB00003','heriirawan081@gmail.com','3604160406880002','','081385768634','1988-06-04','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Perum Puri Teratai Blok G-06/01 Rt/Rw 004/003 Kel.Situ Teratai Kec.Cikande Kab.Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','0','FRAUD','2024-02-06 09:52:01','2024-02-06 15:52:22');
INSERT INTO employees VALUES('2050','Raden','Frans Hidayat , Sh','AB00007','franhidayat994@gmail.com','3604162202880001','2147483647','085959187871','1988-02-22','Male','1','1','21','3','','2','1','','','2019-06-01','','','katholik','TK/0','Kp Warung Salikur Rt/Rw 003/001. Ds. Sukamaju. Kec.Kibin. Serang-Banten','Serang','Banten','3','6767','','','','','','','10000000','Monthly','general','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:01','2024-02-06 13:39:31');
INSERT INTO employees VALUES('2051','Yenita','','AB00008','yenitazby@gmail.com','3601244403940005','2147483647','082117981448','1994-03-04','Female','1','1','21','3','','2','1','','','2015-05-25','','married','islam','K/0','Kp.Taman Rt/Rw 002/005 Ds.Pasir Gadung Kec.Patia Pandeglang-Banten','Pandeglang','Banten','100','6767','','','','','','','0','','ip_based','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:01','2024-02-13 11:46:20');
INSERT INTO employees VALUES('2052','Sarwat','','AB00009','sarwat aja43@gmail,com','3604160502730004','2147483647','082312953978','1973-02-05','Male','1','1','21','3','','2','1','','','2019-06-01','','','islam','K/2','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin Serang-Banten','Serang','Banten','100','6767','','','','','','','0','','ip_based','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:01','2024-02-16 14:13:33');
INSERT INTO employees VALUES('2053','Aminulloh','','AB00011','aminullohhifza@gmail.com','3604160904890001','2147483647','081911291115','1989-04-09','Male','1','1','21','3','','2','1','','','2018-01-24','','married','islam','K/2','Kp.Ciwajik Rt/Rw 002/002 Ds.Kibin Kec.Kibin Serang-Banten','Serang','Banten','100','6767','','','','','','','0','','ip_based','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:01','2024-02-19 16:40:33');
INSERT INTO employees VALUES('2054','Ijah','Hadijah','AB00012','ijahadijah269@gmail.com','3604256206810001','2147483647','081282911305','1981-06-22','Female','1','1','21','3','','2','1','','','2019-06-01','','married','islam','K/0','Kp.Rangkas Rt/Rw.002/001 Ds. Nyompok Kec. Kopo Serang-Banten','Serang','Banten','100','6767','','','','','','','0','','ip_based','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:01','2024-02-20 08:24:56');
INSERT INTO employees VALUES('2055','Didi','Riyadi','AB00013','didi.riyadi130486@gmail.com','3604161304860004','123123123123123','085216193958','1986-04-13','Male','1','1','21','3','','2','1','','','2019-01-24','','married','islam','K/1','Kp.Pasir Sembung Rt/Rw 015/005 Ds.Gembor Kec.Binuang Serang-Banten','Serang','Banten','100','6767','','','','','','','0','','ip_based','0','0','0','','0.00','1','0','0','0','1','','2024-02-06 09:52:01','2024-02-20 13:59:36');
INSERT INTO employees VALUES('2056','Kasim','','AB00014','kasimalbantani01@gmail.com','3604161204000001','123456776666666','081385348526','1979-10-01','Male','3','3','30','6','','2','1','','','2021-11-20','','married','islam','K/2','Kp.Ciwajik Rt/Rw 002/002 Ds.Kibin Kec.Kibin Serang-Banten','Serang','Banten','100','6767','','','','','','','0','','ip_based','0','0','0','','0.00','1','0','0','0','1','','2024-02-06 09:52:01','2024-02-21 13:22:04');
INSERT INTO employees VALUES('2057','Jaka','','AB00015','Jaka362514@gmail.com','3604160102920006','','089651594719','1992-02-01','Male','1','','','','','2','1','','','2022-06-15','','Married','','K-1','Kp.Pasir Tegal Rt/Rw 007/002 Ds.Ketos Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO employees VALUES('2058','Ahmad','Yani','AB00016','tama223tama@gmail.com','3604182411920001','','088213714381','1992-11-24','Male','1','','','','','2','1','','','2022-09-19','','Married','','K-1','Kp. Kibin Rt/Rw 014/005 Kel/Ds. Gembor Kec. Binuang Kab. Serang - Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2059','Aswani','','AB00017','Aswanitambak@gmail.com','3604161010850004','','081398144345','1989-10-10','Male','1','','','','','2','1','','','2022-09-21','','Married','','K-3','Kp. Palembangan Rt/Rw 006/005 Kel/Ds. Dukuh Kec. Kragilan Kab. Serang - Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2060','Wawan','','AB00160','wkang3446@gmail.com','3604161209790002','','085219877292','1979-09-12','Male','1','','','','','2','1','','','2023-04-05','','Married','','K-3','Kp.Tambak Pasir Rt/Rw 002/001 Ds.Tambak Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2061','Firliadi','Al Hapsi','AB00176','Firliadi@gmail.com','1609120107020062','','083813123640','2002-07-01','Male','1','','','','','2','1','','','2023-07-05','','Single','','TK-0','Kp.Pasir Sembung Rt/Rw 018/005 Ds.Gembor Kec.Binuang Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2062','Siti','Ratna Ainun','AB00018','ratna.ainun89@yahoo.com','3275015805890020','','08128602800','1989-05-18','Female','1','','','','','2','1','','','2010-10-24','','Married','','TK-0','Griya Asri Cluster Bintaro Blok D-11/12 Rt/Rw 006/008 Ds.Cikande Kec.Cikande Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2063','Anton','Frans','AB00001','anton.frans@timas.com','3273080308750002','','08121205315','1975-08-03','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Jl.Bukit Jarian Dlm No.29/166-D Rt/Rw 005/011 Ds.Hegarmanah Kec.Cidadap Bandung','Bandung','Jawa Barat','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2064','Sugino','','AB00019','Sugino.aldy@yahoo.com','3604301407620003','','082110895855','1970-07-14','Male','1','','','','','2','1','','','2016-09-09','','Married','','K-3','Kp.Kamurang Rt/Rw 004/001 Ds.Kosambironyok Kec.Anyar Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2065','Nanang','Nasrur','AB00020','qc_nanang@yahoo.com','1812022607820001','','081289244442','1982-07-27','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Kp.Kadingding 008/002 Ds.Tambak Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2066','Ethana','Harits Bryano','AB00021','haritsbryano@gmail.com','3578050203940002','','081285964246','1994-03-02','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-0','Jl. KH.M Kholil GM-2 Rt/Rw 084/009 Kel.Tropodo Kec.Waru Sidoarjo - Jawa Timur ','Sidoarjo','Jawa Timur','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2067','Saeful','Fariz','AB00022','Saefulfariz7@gmail.com','3604161804880003','','089618507555','1988-04-18','Male','1','','','','','2','1','','','2018-10-06','','Married','','K-1','Kp.Gorda Rt/Rw 003/003 Ds.Nambo Ilir Kec.Kibin Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2068','Herry','Suryono, S. Kom','AB00023','herry.suryono34@gmail.com','3672081809770002','','081288195056','1977-09-18','Male','1','','','','','2','1','','','2020-03-21','','Married','','K-2','Link. Kubang Welut Rt/Rw 002/004 Ds.Samangraya Kec.Citangkil Cilegon-Banten ','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2069','Suhel','','AB00024','Suhel.binanusantara68@gmail.com','3604081906680001','','085218729994','1968-06-19','Male','1','','','','','2','1','','','2020-07-06','','Married','','K-2','Kp.Sumur Wuluh Rt/Rw 008/003 Ds.Margasari Kec.Pulo Ampel Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO employees VALUES('2070','Andri','Kurniawan','AB00025','andrikrnwn70@gmail.com','2171120505879018','','082122231380','1987-05-05','Male','1','','','','','2','1','','','2021-08-03','','Married','','K-1','Jl.Petojo Enclek 3 No.11 Rt/Rw 012/007 Ds.Petojo Selatan Kec.Gambir Jakarta Pusat ','Jakarta Pusat','DKI Jakarta','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2071','Muhamad','Sulkhi Setiawan','AB00183','Msulhie@gmail.com','3604131208930003','','087786489560','1993-08-12','Male','1','','','','','2','1','','','2023-07-20','','Married','','K-2','Link. Leuweung Sawo Rt/Rw 003/009 Ds.Kotabumi Kec.Purwakarta Cilegon-Banten','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2072','Muhamad','Irfan Al Amin','AB00189','irfanalamin9@gmail.com','3672081202950003','','087771325958','1995-02-12','Male','1','','','','','2','1','','','2023-09-06','','Single','','TK-0','Link.Kapudenok Masjid Rt/Rw 001/001 Ds.Lebak Denok Kec.Citangkil Cilegon-Banten','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2073','Rizki','Ramadhona.W','AB00197','rizkiramadhona@yahoo.com','3172022605870002','','081284939394','1987-05-26','Male','1','','','','','2','1','','','2023-10-09','','Married','','K-1','Jl.Lurus GG.1 No.47 Rt/Rw 007/006 Ds.Kebon Bawang Kec.Tanjung Priok Jakarta Utara - DKI Jakarta','Jakarta Utara','DKI Jakarta','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2074','Jefri','Silalahi','AB00002','jefriisilalahi2018@gmail.com','3604072709750003','','082178680320','1975-09-27','Male','1','','','','','2','1','','','2020-08-21','','Married','','K-3','Jl.Sultan Syarif Qasim Rt/Rw 010/007 Ds.Perawang Barat Kec.Tualang Siak - Riau','Siak','Riau','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2075','Moh','Hasyim','AB00030','moh.hasyim@timas.con','3318020509850001','','082312027157','1985-09-05','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-1','Talun Rt/Rw 004/003 Ds.Talun Kec.Kayen Kab.Pati - Jawa Tengah ','Pati','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2076','Alfi','Syahrimadona ','AB00031','alfi.syahrimadona@gmail.com','3301230204910001','','081227235553','1991-04-02','Male','1','','','','','2','1','','','2017-10-09','','Married','','K-1','Jl.Setia Budi No.12 Rt.Rw 001/004 Ds.Kebonmanis Kec.Cilacap Utara Kab.Cilacap Jawa Tengah ','Cilacap','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2077','Maryono','','AB00033','maryonokoyek1975@gmail.com','3604102910750076','','081398051559','1975-10-29','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','Puri Citra Blok D4 No.05 Rt/Rw 024/006 Pipitan - Walantaka','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2078','Ahmad','Habibi','AB00034','ahmadhabibi3425@gmail.com','3604062707790003','','087876874679','1979-07-27','Male','1','','','','','2','1','','','2022-08-30','','Married','','K-3','Lebak indah Blok C4 No.16 RT005 RW007 Ds. Lebakwana Kec. Kramatwatu Kab. Serang','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2079','Rifqi','Dhaifullah','AB00198','rifqidhaifullah18@gmail.com','3604091810980001','','085960618570','1998-10-18','Male','1','','','','','2','1','','','2023-10-18','','Single','','TK-0','TCP Blok G.8 No.38 Rt/Rw 003/005 Ds.Pelawad Kec.Ciruas Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2080','Dwi','Yuniar','AB00162','Dwi.yuniar@gmail.com','1671074106930011','','087801061993','1993-06-01','Male','1','','','','','2','1','','','2023-03-30','','Single','','TK-0','Jl.Tri Sukses No.2322 Rt/Rw 041/012 Ds.Srijaya Kec.Alang-alang Lebar Palembang - Sumatera Selatan','Palembang','Sumatera Selatan','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2081','Moh.','Arifin Rumaji','AB00004','muharifinrumaji@gmail.com','3604100307680087','','081311014239','1968-07-03','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Puri Citra Blok C3 No.2 Rt/Rw 023/006 Ds.Pipitan Kec.Walantaka Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2082','Wahyu','Budianto','AB00036','wahyu.belahkulon97@gmail.com','3604053110700001','','089697438880','1970-10-31','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-1','Komp.GSI Blok B.21 No.2 Rt/Rw 003/004. Margatani. Kramatwatu. Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO employees VALUES('2083','Iwan','Siswandi','AB00005','isiswandi15@gmail.com','3601342003740004','','087808291233','1975-03-08','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','Perum.Kampoeng Raya Residence Blok C. No.2 Rt/Rw 004/023 Kel.Serang Kec.Serang Kota.Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2084','Vivit','Eri Hidayat ','AB00037','pradiptaerik@gmail.com','3172032110831001','','085718080847','1983-10-21','Male','1','','','','','2','1','','','2016-10-10','','Married','','K-2','Komp.Uka Blok H no.33 Rt/Rw 001/008 Tugu Utara Kec.Koja Jakarta Utara ','Jakarta Utara','DKI Jakarta','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2085','Andri','Puji Setiawan','AB00038','Andripujiset@gmail.com','3604051510970004','','081285858716','1997-10-15','Male','1','','','','','2','1','','','2022-10-18','','Single','','TK-0','Bukit Pelamunan Permai Blok A7/12 Rt/Rw 010/003 Kel.Pelamunan Kec.Kramatwatu Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2086','Rendy','Kerisna','AB00188','rendy_kerisna@rocket.com','3602060807920001','','085717662532','1992-07-08','Male','1','','','','','2','1','','','2023-08-21','','Married','','K-2','Kp.Dukuh Rt/Rw 004/001 Ds.Leuwidamar Kec.Leuwidamar Lebak-Banten','Lebak','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2087','Jaya','Heryana','AB00042','jay891143@gmail.com','3604112605760003','','083877606993','1976-05-26','Male','1','','','','','2','1','','','2014-07-15','','Married','','K-2','Kp. Pabuaran Rt/Rw 007/004 Ds. Sentul Kec. Kragilan Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2088','Tarmidi','','AB00043','tarmidileo160@gmail.com','3604171012700001','','087788085051','1970-12-10','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','Kp. Pasir Laban Rt/Rw 003/005 Teras. Carenang Banten - 42195','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2089','Umar','Sumardi','AB00044','tohaf21@gmail.com','3604161002770006','','081389238664','1977-02-10','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-1','Kp. Panembong curug Rt/Rw 003/002 Nambo Ilir. Kab. Kibin. Kab Serang - 42185','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2090','Nana','Suciatna','AB00045','sigabjalakrawi@gmail.com','3604250710750005','','087886095475','1975-10-07','Male','1','','','','','2','1','','','2011-08-22','','Married','','K-2','Perum Pesona Alam Kragilan Rt/Rw 011/002 D. Pematang Kec. Kragilan Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2091','Suroto','','AB00046','12suroto44@gmail,com','3603322401770001','','085930285855','1977-01-24','Male','1','','','','','2','1','','','2013-02-27','','Married','','K-2','Kp.Cipaeh Sambidoyong Rt/rw 002/002 Onyam. Gunung Kaler. Tangerang','Tangerang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2092','Ismatullah','','AB00047','Imatalvaro822@gmail com','3673032209840001','','083848584016','1984-09-22','Male','1','','','','','2','1','','','2021-07-01','','Married','','K-1','Kp.Ampel Rt/Rw 002/001 Ds.Pangampelan Kec.Walantaka Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2093','Muhammad','Pahlefi ','AB00048','muhammadpahlefi648@gmail.com','3604170204950004','','082310436085','1995-04-02','Male','1','','','','','2','1','','','2021-10-22','','Single','','TK-0','Kp.Kasepatan Kompa Rt/Rw 006/004 Ds.Teras Kec.Carenang Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2094','Rudi','Hartono','AB00147','rudipaster242@gmail.com','3604111406780002','','081310193667','1978-06-14','Male','1','','','','','2','1','','','2023-02-01','','Married','','K-2','BCP 2 Blok E 28 No.23 Rt/Rw 030/005 Ds.Ranjeng Kec.Ciruas Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO employees VALUES('2095','Endang','Saputra','AB00155','saputraendang020@gmail.com','3604160308870003','','085717635769','1987-08-03','Male','1','','','','','2','1','','','2023-02-21','','Married','','K-2','Kp.Tambak Baru Rt/Rw 001/001 Ds.Kibin Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2096','Darwin','Silalahi','AB00187','Darwin.silalahi@gmail.com','1209080107940023','','081282099356','1993-04-15','Male','1','','','','','2','1','','','2023-08-16','','Married','','K-2','Perum Banten Metro Polis Residence Blok E.4 No.24 Rt/Rw 024/005 Ds.Nagara Kec.Kibin Seerang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2097','Saenin','','AB00006','Saeninssenin44@gmail.com','3604111010690001','','085284371675','1969-10-10','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','Komp Ciujung Damai Blok C.42 No.1 Rt/Rw 006/007 Kendayakan Kragilan - Serang','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2098','Nor','Said','AB00049','nursaidikram@gmail.com','3604091207760005','','085219428892','1976-07-12','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','BCP Vlok C 5 No.09 Rt/Rw 025/004 Ds.Ranjeng Kec.Ciruas Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2099','Rinto','Samosir','AB00051','samosir.rinto68@gmail.com','3604163004840001','','081280512987','1984-04-30','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','Griya Asri Bintaro Blok D-10/14 Rt/Rw 006/008 Ds.Cikande Kec.Cikande Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2100','Gentha','Omar Panji Wijaya','AB00052','genthapanji@gmail.com','3306072810900002','','081291231530','1990-10-28','Male','1','','','','','2','1','','','2018-08-01','','Married','','K-2','Puri Teratai Blok G-01/34 Rt/Rw 004/003 Ds.Situ Terate Kec.Cikande Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2101','Yusup','Ramdhani','AB00053','yusuframdani21@gmail.com','3604091407820007','','081314162709','1982-07-14','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Grand Mutiara Residance Rt/Rw 003/004 Ds.Kiara Kec.Walantaka Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2102','Suyadi','','AB00054','suyadiadi406@gmail.com','3604071802750002','','08988665264','1975-02-18','Male','1','','','','','2','1','','','2021-09-24','','Married','','K-3','Kp.Wadasari Rt/Rw 010/004 Ds.Karangkepuh Kec.Bojonegara Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2103','Reza','Dian Permana','AB00055','rezarazzor130191@gmail.com','3672081301970002','','087778482858','1991-01-13','Male','1','','','','','2','1','','','2021-10-01','','Married','','K-2','Link.Seneja Rt/Rw 002/001 Ds.Sukamaja Kec.Jombang Cilegon-Banten ','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2104','Muhlis','Dondi Mihardi','AB00056','muhlisdm69@gmail.com','3672052006820001','','081268345411','1982-06-20','Male','1','','','','','2','1','','','2022-05-09','','Married','','K-2','Link Kenanga Rt/Rw 005/004 Ds.Masigit Kec.Jombang Cilegon-Banten','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2105','Sanen','','AB00057','sanen205@gmail.com','3604151012890002','','082312182233','1989-12-10','Male','1','','','','','2','1','','','2022-05-09','','Married','','K-2','Kp.Sukamaju Rt/Rw 003/003 Ds.Nambo Udik Kec.Cikande Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2106','Aziz','Amirudin','AB00058','azizamir844@gmail.com','3318020704930002','','082312727937','1993-04-07','Male','1','','','','','2','1','','','2022-05-09','','Married','','K-1','Kp.Legoknangka Rt/Rw 002/002 Ds.Sodong Kec.Saketi Pandeglang-Banten','Pandeglang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2107','Ingga','Mulyana','AB00059','Inggamulyana24@gmail.com','3301212406970002','','085712610091','1997-06-24','Male','1','','','','','2','1','','','2022-05-12','','Married','','K-1','Jl.Kendeng No.64 Rt/Rw 005/014 Ds.Sidanegara Kec.Cilacap Tengah Cilacap - Jawa Tengah','Cilacap','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO employees VALUES('2108','Sofan','','AB00060','Sofanopan66@gmail.com','3604083904880001','','085939070852','1988-04-29','Male','1','','','','','2','1','','','2022-05-12','','Married','','K-2','Kp.Ragas Grenyang Rt/Rw 016/009 Ds.Argawana Kec.Puloampel Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2109','Erik','Yuliadi','AB00062','yuliadierik@gmail.com ','3604152907780001','','081281143405','1978-07-29','Male','1','','','','','2','1','','','2022-05-09','','Married','','K-2','Griya Asri Cluster Cendana Blok B.9/11 Rt/Rw 005/008 Ds.Cikande Kec.Cikande Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2110','Anggara','Saputra','AB00063','anggarasaputra8227@gmail.com ','1572011807960002','','081271442155','1996-07-05','Male','1','','','','','2','1','','','2022-05-09','','Married','','K-1','Wonorejo III Rt/Rw 001/008 Ds.Pesawaran Indah Kec.Way Ratai Pesawaran - Lampung','Pesawaran','Lampung','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2111','Jhon','Albert Aritonang','AB00064','eliskaaritonang78@gmail.com','3604030808690003','','081297238758','1969-08-08','Male','1','','','','','2','1','','','2022-09-02','','Married','','K-3','Taman Angsoka Permai Rt/Rw 003/008 Ds.Kasemen Kec.Kasemen Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2112','Bambang','Irawan','AB00065','Bambangibenkibenk.gmail.com','3672082508880001','','057808546949','1988-08-25','Male','1','','','','','2','1','','','2022-09-12','','Married','','K-2','Link.Delingseng Rt/Rw 001/001 Ds.Kebonsari Kec.Citangkil Cilegon-Banten','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2113','Dedi','Rasdianto','AB00066','dedisuhar@gmail.com','3672050907760001','','082115136397','1979-03-13','Male','1','','','','','2','1','','','2022-09-12','','Married','','K-3','Link.Leuweung Sawo Blok Bango Rt/Rw 004/009 Kel.Kotabumi Kec.Purwakarta Cilegon-Banten','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2114','Sastro','Wijoyo Butar Butar','AB00067','sastrowijoyo174@gmail.com','3672082503840008','','081388977156','1984-03-25','Male','1','','','','','2','1','','','2022-10-06','','Married','','K-3','Komp.TWI FWA 172 No.04 Rt/Rw 005/007 Kel.Warnasari Kec.Citangkil Cilegon-Banten','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2115','Suheri','Bin Iwan','AB00171','Suheri@gmail.com','3603121904810007','','08311465229','1981-04-19','Male','1','','','','','2','1','','','2023-06-07','','Married','','K-2','Jl.Cempaka VI Blok HL.16 Bumi Indah Rt/Rw 004/008 Kel.Sukamantri Kec.Pasar Kemis Tangerang-Banten','Tangerang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2116','Suandi','','AB00166','Suandi@gmail.com','3604171005860002','','085693396879','1986-05-10','Male','1','','','','','2','1','','','2023-06-07','','Married','','K-3','Kp.Mandaya Rt/Rw 007/002 Ds.Panenjoan Kec.Carenang Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2117','Sunda','','AB00170','Sunda@gmail.com','3604260709880002','','081285804910','1988-09-07','Male','1','','','','','2','1','','','2023-06-08','','Married','','K-3','Kp.Koang Rt/Rw 022/004 Ds.Pangawinan Kec.Bandung Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2118','Imatullah','','AB00068','imatullah150200@gmail.com','3604161010010001','','083127321344','2000-12-15','Male','1','','','','','2','1','','','2021-10-02','','Single','','TK-0','Kp.Ciwajik Rt/Rw 002/002 Ds.Kibin Kec.Kibin Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2119','Mochamad','Haeroni ','AB00069','muhroni507@gmail.com','3604191602850002','','085312974597','1985-02-16','Male','1','','','','','2','1','','','2021-09-15','','Single','','TK-0','Kp.Cilame Rt/Rw 001/003 Ds.Tambiluk Kec.Petir Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2120','Suparman','','AB00070','suparmanjon123@gmail.com','3604162007770003','','045217991932','1977-07-20','Male','1','','','','','2','1','','','2021-11-12','','Married','','K-2','Kp.Gorda Asem Rt/Rw 001/003 Kel.Nambo Ilir Kec.Kibin Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO employees VALUES('2121','Osbin','Malau','AB00071','pudanrevan@gmail.com','3604151307860002','','081294751486','1986-07-13','Male','1','','','','','2','1','','','2022-10-05','','Married','','K-2','Perum Cikande Permai Blok N.8 No.16 Rt/Rw 001/004 Ds.Cikande Permai Kec.Cikande Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2122','Yulianto','','AB00072','juliantoarepac@gmail.com','3501111607860005','','081288713060','1986-07-16','Male','1','','','','','2','1','','','2017-06-07','','Married','','K-2','Nglembu Rt/Rw 004/007 Ds Pagerejo Kec Ngadirojo Pacitan Jawa timur','Pacitan','Jawa Timur','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2123','Mamat','','AB00073','widyainayah30@gmail.com','3604091111700001','','085228044525','1970-11-11','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','TCP Vlok K.3 No.10 Rt/Rw 003/004 Kel.Pelawad Kec.Ciruas Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2124','Erwan','','AB00074','erwanerwan752@gmail.com','3604091309670002','','085216368976','1967-09-13','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','BCP Blok C5 No.13 Rt/Rw 025/004 Ds.Ranjeng Kec.Ciruas  Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2125','Matsapik','','AB00075','matsapikm@gmail.com','3673031508800005','','081210084545','1980-08-15','Male','1','','','','','2','1','','','2021-06-19','','Married','','K-2','DK Glempang Rt/Rw 005/002 Ds.Adisana Kec.Bumiayu Brebes-Jawa Tengah ','Brebes','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2126','Wigihardi','','AB00076','wigihardi76@gmail.com','3604160204760012','','081316820811','1976-04-02','Male','1','','','','','2','1','','','2021-07-12','','Married','','K-2','Glonggong Rt/Rw 001/002 Ds.Glonggong Kec.Jakenan Pati-Jawa Tengah ','Pati','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2127','Soleman','','AB00077','Solesoleman257@gmail.com ','3602281004970001','','085691866423','1998-08-09','Male','1','','','','','2','1','','','2021-07-17','','Single','','TK-0','Kp.Leuwi Urug Rt/Rw 011/003 Ds.Peucangpari Kec.Cigemblong Lebak-Banten ','Lebak','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2128','Akyadi','Bin Ripan','AB00078','yadidi87@gmail.com','3603072504840004','','088214759053','1984-04-25','Male','1','','','','','2','1','','','2021-08-20','','Married','','K-2','Kp.Pagenjahan Rt/Rw 001/003 Ds.Pagenjahan Kec.Kronjo Tangerang - Banten ','Tangerang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2129','Dudi','Rohman ','AB00079','do3dy.88@gmail.com','3601260410880001','','085773412324','1988-10-04','Male','1','','','','','2','1','','','2021-09-02','','Married','','K-1','Kp.Sukagalih Rt/Rw 003/004 Ds.Karyasari Kec.Cikedal Pandeglang - Banten','Pandeglang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2130','Suparno','','AB00080','suparno01245678@gmail.com','3314111203730008','','082142522143','1973-03-12','Male','1','','','','','2','1','','','2021-09-04','','Married','','K-3','Ngepos Rt/Rw 002/009 Ds.Jetak Kec.Sidoharjo Sragen - Jawa Tengah ','Sragen','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2131','Saepudin','','AB00081','saepudinpudin837@gmail.com','3604261506890002','','081316935415','1989-06-15','Male','1','','','','','2','1','','','2021-12-02','','Married','','K-1','Kp.Harendong Lembur Rt/Rw 010/003 Ds.Jawilan Kec.Jawilan Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2132','Yusuf','Ade Supriatna ','AB00082','Yusufadesupriatna123gmail.com','3672021202780004','','087871466946','1978-02-12','Male','1','','','','','2','1','','','2021-12-18','','Married','','K-3','Link.Ciwedus Rt/Rw 003/002 Ds.Ciwedus Kec.Cilegon Cilegon-Banten','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2133','Saepuloh','','AB00083','Saepuls315@gmail.com','3201171204870011','','085782972766','1987-04-12','Male','1','','','','','2','1','','','2021-12-21','','Married','','K-2','Kp.Pabuaran Rt/Rw 002/003 Ds.Gunung Bunder I Kec.Pamijahan Bogor - Jawa Barat','Bogor','Jawa Barat','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO employees VALUES('2134','Nurakhman','','AB00084','Nu_achman@yahoo.com','3604161405720001','','081310748372','1972-05-14','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Kp.Maja Rt/Rw 002/004 Ds.Kibin Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2135','Purwanto','','AB00085','purwanto321969@gmail.com','3604110302690001','','085217374535','1969-02-03','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','Perum Ciujung Damai C40 No.12. Rt/Rw 007/002 Ds.Kendayakan Kec.Kragilan Serang - Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2136','M','Musa Efendi','AB00086','mmusaefendi@gmail.com','3604161606750001','','081399092269','1975-06-16','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Kp.Citawa Rt/Rw 003/003 Ds.Kibin Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2137','Agus','Sofyan','AB00087','agaysofyan21@gmail.com','3604162108780002','','081387866051','1978-08-21','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Perum Puri Tambak Gemilang Blk B3 No.4 Rt/Rw 15/3 Ds.Ciagel Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2138','Sukardi','','AB00088','SSUKARDI135@GMAIL.COM','3604161202680002','','081297238970','1968-02-12','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Perm.Banten Metropolis Residence Blok A.14 No.0 Rt/Rw 023/005 Ds.Nagara Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2139','Suyato','','AB00089','suyatoondel41317@gmail.com','3312200907690001','','082210476846','1969-07-09','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-1','Dusun Jegoh Rt/Rw 03/04 Ds.Rejosari Kec.Jatisrana Kab Wonogiri - Jawa Tengah ','Monogiri','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2140','Eli','Hermansyah ','AB00090','elihermansyahhermansyah@gmail.com','3212232211790002','','087775845142','1979-11-22','Male','1','','','','','2','1','','','2021-06-17','','Married','','K-1','Dusun Bedeng Satu Rt/Rw 010/002 Ds. Bugis Tua Kec.Anjatan Indramayu - Jawa Barat ','Indramayu','Jawa Barat','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2141','Riki','Purwanto','AB00091','rikipurwanto46890@gmail.com','1403091909810002','','081268966927','1981-09-19','Male','1','','','','','2','1','','','2021-06-19','','Married','','K-2','Jl.KH.Ahmad Dahlan GG Syuhada Rt/Rw 003/007 Ds.Balik alam Kec.Mandau Bengkalis - Riau','Bengkalis','Riau','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2142','Paryono','','AB00092','Yonoparyono02@gmail.com','3604111902870002','','085313652724','1987-02-19','Male','1','','','','','2','1','','','2021-07-01','','Married','','K-0','Perum Graha Cisait Blok B2 No.02 Ds.Cisait Kec.Gragilan Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2143','Iddrisno','Naibaho ','AB00093','idrisnaibaho88@gmail.com','3604091906880004','','0813857920052','1988-06-19','Male','1','','','','','2','1','','','2021-11-17','','Single','','TK-0','TCP Blok G-3 No.4 Rt/Rw 001/005 Ds.Pelawad Kec.Ciruas Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2144','Rahimudin','','AB00094','rahimudin7788@gmail.com','3604092506770002','','081278188622','1977-06-25','Male','1','','','','','2','1','','','2021-11-17','','Married','','K-2','Kp.Kebon Ratu Rt/Rw 008/004 Ds.Kebon Ratu Kec.Ciruas Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2145','Tolhas','Jonier Hutasoit ','AB00097','tolhasjunier@.gmail.comm','1273012812660001','','085210714897','1986-12-28','Male','1','','','','','2','1','','','2021-11-17','','Married','','K-1','Perum Puri Mas Blok D6 No.07 Rt/Rw 002/004 Ds.Sititerate Kec.Cikande Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO employees VALUES('2146','Roy','Renold Siburian','AB00098','roysiburian17@gmail.com','3604021701900003','','08212935520','1990-01-17','Male','1','','','','','2','1','','','2021-11-17','','Married','','K-0','Peru Bumi Nagara Lestari Blok A.03 No.26 Rt/Rw 026/005 Ds.Nagara Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2147','Dian','Hadiansyah ','AB00099','Dian.h@gmail.com','3604300603820002','','085920671630','1982-04-05','Male','1','','','','','2','1','','','2021-11-17','','Married','','K-2','Kp.Kamurang Pal Rt/Rw 003/002 Ds.Grogol Indah Kec.Anyar Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2148','Junaidi','','AB00095','Junaidicase@gmail.com','3604321606840001','','081906274160','1984-06-16','Male','1','','','','','2','1','','','2022-01-05','','Married','','K-2','Kp.Kosambilandak Rt/Rw 010/002 Ds.Batukuda Kec.Mancak Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2149','Nikmatullah','','AB00100','Nickkutubuku@gmail.com','3672010906900001','','085693592382','1990-06-08','Male','1','','','','','2','1','','','2022-01-05','','Married','','K-2','Link.Cipaot Rt/Rw 001/002 Ds.Bulakan Kec.Cibeber Cilegon-Banten','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2150','Irwan','Wahyudi','AB00101','irwanwahyudi469@gmail.com','3604081909920002','','081315128489','1992-09-19','Male','1','','','','','2','1','','','2022-01-05','','Married','','K-1','Kp.Peres Rt/Rw 001/002 Ds.Pulo Panjang Kec.Ampel Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2151','Ajislim','Silaban','AB00102','ajislimsilabansilaban@gmail.com','3604090202950009','','082353311506','1995-02-02','Male','1','','','','','2','1','','','2022-01-18','','Single','','TK-0','Komp.Griya Reang Indah Blok D.3 No.6 Rt/Rw 003/010 Ds.Banjar Sari Kec.Cipocok Jaya Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2152','Mansyur','','AB00153','ajaikal898@gmail.com','3604100505730701','','\'083127195698','1973-05-05','Male','1','','','','','2','1','','','2023-02-10','','Married','','K-3','Kp.Cibetik Rt/Rw 008/003 Ds.Pangampelan Kec.Walantaka Serang Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2153','Sohadi','','AB00172','sohadi@gmail.com','3604160211930001','','083890898941','1993-11-02','Male','1','','','','','2','1','','','2023-06-07','','Married','','K-1','Kp.Warakas Rt/Rw 011/003 Ds.Lamaran Kec.Binuang Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2154','Charly','Nababan','AB00165','Charly.n@gmail.com','3604042606830053','','081379456337','1983-06-26','Male','1','','','','','2','1','','','2023-06-07','','Married','','K-2','Komp.Taman Mutiara Indah Blok G.5 No.42 Rt/Rw 002/018 Ds.Kaligandu Kec.Serang Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2155','Imbran','','AB00169','Imbran@gmail.com','3604160101800006','','082123656003','1980-01-01','Male','1','','','','','2','1','','','2023-06-07','','Married','','K-3','Kp.Karenggan Rt/Rw 004/001 Ds.Sukamanju Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2156','Andry','Firmansyah','AB00154','andry_firmansyah17@yahoo.com','3604111704940001','','085288846363','1994-04-17','Male','1','','','','','2','1','','','2023-02-10','','Married','','K-1','Kp.Pasir Binong Rt/Rw 014/005 Ds.Kendayakan Kec.Kragilan Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2157','Muhamad','Jupri','AB00167','Jupri.m@gmail.com','3604110412950001','','085939419245','1995-12-04','Male','1','','','','','2','1','','','2023-06-07','','Single','','TK-0','Kp.Pasir Binong Rt/Rw 014/005 Ds.Kendayakan Kec.Kragilan Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2158','Suhemi','Andriansyah','AB00168','suhemi@gmail.com','3604161905030001','','083119047028','2003-05-19','Male','1','','','','','2','1','','','2023-06-07','','Single','','TK-0','Kp.Rangkong Rt/Rw 009/001 Ds.Kibin Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO employees VALUES('2159','M.Kaman','Sanusi','AB00103','Kamansanusi6@gmail.com','3604112504720004','','081283600132','1972-04-25','Male','1','','','','','2','1','','','2019-06-01','','Single','','TK-1','Kp.Baru Pasar Rt/Rw 002/003 Ds.Kragilan Kec.Kragilan Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2160','Willi','Afrilian ','AB00104','willydoer1207@gmail.com','3303053004820002','','085959568233','1982-04-30','Male','1','','','','','2','1','','','2021-10-04','','Single','','TK-0','Purbalingga Kulon Rt/Rw 003/001 Ds.Purbalingga Kulon Kec.Purbalingga Purbalingga - Jawa Tengah ','Purbalingga','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2161','Heri','Suarno ','AB00105','Herisuarno@gmail.com','3604090806750001','','081291318134','1975-06-08','Male','1','','','','','2','1','','','2021-09-15','','Married','','K-2','Dusun Waringin Harjo Rt/Rw 004/004 Ds.Agon Kec.Kalianda Lampung Selatan - Lampung','Lampung Selatan','Lampung','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2162','Dasron','Sinaga','AB00106','Sinagadasron9@gmail.com','3276090512870001','','085215579970','1987-12-18','Male','1','','','','','2','1','','','2022-01-18','','Married','','K-1','Perum BCP 2 Blok K2A No.3 Rt/Rw 042/006 Ds.Ranjeng Kec.Ciruas Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2163','Muhammad','Kahfi ','AB00107','muhammadkhf20@gmail.com','3604112004980001','','083871952889','1998-04-20','Male','1','','','','','2','1','','','2021-10-02','','Single','','TK-0','Komp.Ciujung Damai Blok.C 44 No.11 Rt/Rw 007/002 Ds.Kendayakan Kec.Kragilan Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2164','Rohmat','','AB00108','dyah.fu19@gmail.com','3604091306780002','','081315415696','1978-06-13','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','Jl.Cikulur Masjid Rt/Rw 002/004 Ds.Serang Kec.Serang - Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2165','Juli','','AB00109','heriyadijuli18@gmail.com ','3604161211900004','','085216916646','1990-11-12','Male','1','','','','','2','1','','','2021-06-16','','Married','','K-1','Kp.Ciagel Rt/Rw 003/001 Ds.Ciagel Kec.Kibin Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2166','Jaja','Sunarja ','AB00110','Jajasunarja52email.com','3602141701760002','','085210377746','1976-01-17','Male','1','','','','','2','1','','','2021-06-16','','Married','','K-3','Kp.Cijoro Barat Rt/Rw 004/001 Ds.Muara Ciujung Timur Kec.Rangkas Bitung Lebak - Banten ','Lebak','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2167','Medi','','AB00111','034beno@gmail.com','3604160503850002','','081316761693','1985-06-05','Male','1','','','','','2','1','','','2021-06-16','','Single','','TK-0','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2168','Andri','Wibowo ','AB00112','andrie.wibowo71@gmail.com ','1408042509870002','','085329421884','1987-09-25','Male','1','','','','','2','1','','','2021-11-16','','Married','','K-1','Kp.Pengkolan Rt/Rw 007/002 Ds.Purabaya Kec.Purabaya Sukabumi - Jawa Barat','Sukabumi','Jawa Barat','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2169','Yahya','Suparjo ','AB00113','Yahyasuprjo1309@gmail.com','3672071309890001','','085210759988','1989-09-13','Male','1','','','','','2','1','','','2021-12-10','','Married','','K-2','Link.Ciora Gede Rt/Rw 005/002 Ds.Kotasari Kec.Gerogol Cilegon-Banten','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2170','Dadang','Sugianto','AB00114','abythea19@gmail.com ','3509221911890004','','081224074130','1989-11-19','Male','1','','','','','2','1','','','2022-02-08','','Married','','K-2','Kp.Saribudi Rt/Rw 001/009 Ds.Banyurasa Kec.Sukahening Tasikmalaya - Jawa Barat','Tasikmalaya','Jawa Barat','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2171','Ridwan','Saidi ','AB00115','Ridwanzea16@gmail.com','3215102506900002','','087864745161','1990-06-25','Male','1','','','','','2','1','','','2022-02-23','','Married','','K-2','Kavling Bumi Mandiri Rt/Rw 004/005 Ds.Karangsatria Kec.Tambun Utara Bekasi-Jawa Barat','Bekasi','Jawa Barat','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO employees VALUES('2172','M.','Ali Sodikin','AB00144','hilyaazahra89@gmail.com','3604161606970003','','0881010749831','1997-08-16','Male','1','','','','','2','1','','','2023-01-18','','Married','','K-1','Kp.Cijeruk Rt/Rw 005/001 Ds.Cijeruk Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2173','Utama','Wijaya','AB00190','0199tamawijaya@gmail.com','3601121408980004','','082175199923','1998-08-14','Male','1','','','','','2','1','','','2023-09-21','','Single','','TK-0','Kp.Laba Rt/Rw 003/008 Ds.Cigondang Kec.Labuan Pandeglang-Banten','Pandeglang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2174','M.','Fauzy','AB00194','ajie.bae30102015@gmail.com','1671060509870012','','082184373178','1987-09-05','Male','1','','','','','2','1','','','2023-09-26','','Married','','K-1','Jl.Yos Sudarso LR.Pasma Putra No.42 Rt/Rw 023/005 Ds.Tiga Ilir Kec.Ilir Timur Dua Palembang - Sumatera Selatan','Palembang','Sumatera Selatan','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2175','Erlan','','AB00195','erlanamelia01@gmail.com','1671060108820013','','081268030399','1982-08-01','Male','1','','','','','2','1','','','2023-09-26','','Married','','K-1','Jl.Swadaya Murni Rt/Rw 021/009 Ds.Sako Kec.Sako Palembang - Sumatera Selatan','Palembang','Sumatera Selatan','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2176','Asep','Achyar Sutisman','AB00118','asepachyarsutisman@gmail.com ','3604161708680001','','089643151668','1968-08-17','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2177','Damanhuri','','AB00119','damane1378@gmail.com','3604161101830001','','082298339997','1983-01-11','Male','1','','','','','2','1','','','2018-10-01','','Married','','K-2','Kp. Barabuntung Rt/Rw. 06/02 Ds.Cijeruk Kec.Kibin. Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2178','Sarkani','','AB00120','kanisarkani982@gmail.com','3604160706770003','','085211821475','1976-04-06','Male','1','','','','','2','1','','','2018-10-01','','Married','','K-2','Kp.Panyingkiran Rt/Rw 001/007 Ds.Situsaeur Kec.Karangpawitan Garut -Jawa Barat ','Garut','Jawa Barat','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2179','Saefudin','','AB00121','Seapudin1970@gmail.com','3604301108700003','','087771446771','1970-08-11','Male','1','','','','','2','1','','','2021-09-15','','Married','','K-1','Kp.Kamurang Pal Rt/Rw 003/002 Ds.Grogol Indah Kec.Anyar Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2180','Kemis','','AB00122','themozt046@gmail.com','3604161902860001','','081251096886','1986-02-19','Male','1','','','','','2','1','','','2021-11-08','','Single','','TK-0','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2181','Budi','Muharom','AB00123','dhiosaputra968@gmail.com','3603122708790001','','082320775526','1979-08-27','Male','1','','','','','2','1','','','2021-11-17','','Married','','K-2','Jl.Cimanuk No.17 B Rt/Rw 003/015 Ds.Pataruman Kec.Tarogong Kidul Garut - Jawa Barat ','Garut','Jawa Barat','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2182','Heru','Sumas Aditya','AB00124','Herusumas65@gmail.com','3604150702940005','','081290562157','1994-02-07','Male','1','','','','','2','1','','','2022-03-02','','Married','','K-1','Kp.Baru Rt/Rw 010/003 Ds.Julang Kec.Cikande Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2183','Parsaoran','Gultom','AA00279','gultom.parsaoran1986@gmail.com','1408042308860002','','\'081227693124','1986-08-23','Male','1','','','','','2','1','','','1970-01-01','','Married','','K-2','Jl Sawo Gang Duku Rt/Rw 04/04 Ds. Menganti Kec. Kesugihan Cilacap - Jawa Tengah','Cilacap','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2184','Santoso','','AB00125','santoso.rms55@gmail.com','3604091206730002','','081311342428','1973-06-12','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-1','TCP Blok E2 No.12 Rt/Rw 005/005 Ds.Citerep Kec.Ciruas Serang - Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO employees VALUES('2185','Safiyudin','','AB00126','safiyudin@gmail.com','3604062005760001','','085311580122','1974-05-20','Male','1','','','','','2','1','','','2022-01-05','','Married','','K-3','Kp.Cakar Rt/Rw 008/003 Ds.Melati Kec.Waringinkurung Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2186','Saprudin','','AB00127','ariep321022@gmail.com','3604330911800001','','085946793917','1980-11-09','Male','1','','','','','2','1','','','2022-01-05','','Married','','K-2','Kp.Tegal Rata Rt/Rw 006/002 Ds.Gunung Sari Kec. Gunung Sari Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2187','Muchtar','','AB00130','muchtar1766@gmail.com','3672081711660002','','087771748372','1966-11-17','Male','1','','','','','2','1','','','2019-01-07','','Married','','K-2','Link Kedawung Rt/Rw 001/007 Ds.Taman Baru Kec.Citangkil Kab.Cilegon - Banten','Cilegon','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2188','Dady','Rosyadi ','AB00129','dadyrosyadi14@gmail.com','3211182311890006','','08952790225','1989-11-23','Male','1','','','','','2','1','','','2021-03-20','','Married','','K-2','Link Pasanggrahan Rt/Rw 001/006 Ds.Pasanggrahan baru kec.Sumedang selatan Sumedang - Jawa Barat ','Sumedang','Jawa Barat','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2189','Rahmattuloh','','AB00131','SANUNRAHMAT@gmail.com','3604161911900002','','081317516084','1990-11-19','Male','1','','','','','2','1','','','2021-09-09','','Married','','K-2','Kp.Ciwajik Rt/Rw 003/002 Ds.Kibin Kec.Kibin Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2190','Dimas','Candra Girisona','AB00132','dimaschandragirisona@gmail.com','3604100907850141','','081293317538','1985-07-09','Male','1','','','','','2','1','','','2022-02-08','','Single','','TK-0','Perum Persada Banten Blok G.05 No.29 Ds.Teritih Kec.Walantaka Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2191','Paryanto','','AB00133','blegohkelana123@gmail.com','1807121802790001','','081218061895','1979-02-18','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Pugung Raharjo Rt/Rw 028/006 Ds.Pugung Raharjo Kec.Sekampung Udik Lampung Timur - Lampung','Lampung Timur','Lampung','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2192','Erik','Extrada ','AB00134','eextrada05@gmail.com','3604162003930002','','089529917134','1993-03-20','Male','1','','','','','2','1','','','2021-07-10','','Married','','K-1','Kp.Kadingding Rt/Rw 006/002 Ds.Kibin Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2193','Nanang','Farid Ariyanto','AB00199','nanang.farid@gmail.com','3514143010770004','','081335306888','1977-10-30','Male','1','','','','','2','1','','','2023-10-13','','Married','','K-3','Bekacak Rt/Rw 001/003 Ds.Kolursari Kec.Bangil Pasuruan - Jawa Timur','Pasuruan','Jawa Timur','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2194','Mochamad','Su\'Udi','AB00196','moch.suudi08@gmail.com','3604110803910001','','081310908261','1991-03-08','Male','1','','','','','2','1','','','2023-10-04','','Single','','TK-0','Kp.Tegal Maja Rt/Rw 005/007 Ds.Tegal Maja Kec.Kragilan Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2195','Amin','','AB00135','djadiputra514@gmail.cpm','1812032203760001','','085216957457','1975-03-22','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-2','Karta Sari Rt/Rw 010/003 Ds.Karta Sari Kec.Tulang Bawang Udik Kab.Tulang Bawang Barat - Lampung ','Tulang Bawang Barat','Lampung','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2196','Antoni','','AB00136','antonichebungsu@gmail.co','3604160107830006','','083842150483','1983-07-01','Male','1','','','','','2','1','','','2017-09-02','','Married','','K-3','Kp.Beberan Kompa Rt/Rw 006/003 Ds.Teras Kec.Carenang Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2197','Muhammad','Ridwan Amin','AB00138','ridwan4892@gmail.com','3604020804920303','','082122270017 / ','1992-04-08','Male','1','','','','','2','1','','','2022-01-05','','Married','','K-1','Sumur Pecung Rt/Rw 003/001 Ds.Sumur Pecung Kec.Serang Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO employees VALUES('2198','Aris','Susanto ','AB00137','arissusanto2938@gmail.com','3301222605920004','','083826968420','1992-05-26','Male','1','','','','','2','1','','','2021-12-02','','Married','','K-0','Jl.Nusa Ori Rt/Rw 005/008 Ds.Kutawaru Kec.Cilacap Tengah Cilacap - Jawa Tengah','Cilacap','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employees VALUES('2199','Sudarwan','','AB00173','sudarwan@gmail.com','3603012807950003','','081296697862','1995-07-28','Male','1','','','','','2','1','','','2023-06-02','','Married','','K-1','Kp.Sukajadi Rt/Rw 003/007 Ds.Sukajadi Kec.Cibaliung Pandeglang-Banten','Pandeglang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employees VALUES('2200','Manap','','AB00179','Msabymanap01@gmail.com','3603310111850008','','083808510377','1985-11-01','Male','1','','','','','2','1','','','2023-07-07','','Married','','K-2','Kp.Barengkok Rt/Rw 003/003 Ds.Solear Kec.Solear Tangerang-Banten','Tangerang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employees VALUES('2201','Wahyu','Dwi Saputra','AB00141','wahyuwahyul2003@gmail.com','3301052406030003','','085229332286','2003-05-24','Male','1','','','','','2','1','','','2022-08-22','','Single','','TK-0','Dusun Sitara Kulon Rt/Rw 003/005 Ds.Jetis Kec.Nusawungu  Cilacap - Jawa Tengah','Cilacap','Jawa Tengah','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employees VALUES('2202','Moh','Sudari Wibowo','AB00139','mohsudari698@gmail.com','3604111505740002','','081319698280','1974-05-15','Male','1','','','','','2','1','','','2019-06-01','','Married','','K-3','Perumahan Ciujung Damai Blok C.42 No.7 Rt/Rw 006/002 Ds.Kendayakan Kec.Kragilan  Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employees VALUES('2203','A.Hafidullah','','AB00140','ahmadhafid548@gmail.com','3604111812890001','','085215799454','1989-12-18','Male','1','','','','','2','1','','','2022-05-24','','Married','','K-0','Kp.Pabrik Rt/Rw 001/001 Ds.Tegal Maja Kec.Kragilan Serang-Banten ','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employees VALUES('2204','Sahroni','','AB00142','sahroniaduai409@gmail.com','3604161202790003','','081291845422','1979-02-12','Male','1','','','','','2','1','','','2022-10-05','','Married','','K-2','Kp.Paya Lebak Rt/Rw 014/003 Ds.Ciagel Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employees VALUES('2205','Bintang','Chanensya','AB00143','zeyyyyuss@gmail.com','3604166905040001','','081212259113','2004-05-29','Male','1','','','','','2','1','','','2022-10-18','','Single','','TK-0','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employees VALUES('2206','Kamsarudin','','AB00148','ilhamrakaboom92@gmail.com','3604162009850001','','082122189601','1985-09-20','Male','1','','','','','2','1','','','2023-02-06','','Married','','K-3','Kp.Citawa Rt/Rw 009/002 Ds.Tambak Kec.Kibin Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employees VALUES('2207','Zulkifli','','AB00146','falskipli@gmail.com','3604111202920003','','088293046543','1992-02-12','Male','1','','','','','2','1','','','2023-01-20','','Single','','TK-0','Kp.Pabuaran Rt/Rw 002/005 Ds.Kragilan Kec.Kragilan Serang-Banten','Serang','Banten','','6767','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO employees VALUES('2209','AZMANDA','AZMANDA','AA9107','azmanda@timas.com','9988778862617171','2147483647','','1996-07-08','Male','1','1','21','3','','2','','','','2024-02-06','','married','islam','','','','','','','','','','','','','0','','ip_based','0','0','0','','0.00','0','1','0','0','0','RESIGN','2024-02-06 11:53:47','2024-02-06 15:53:24');
INSERT INTO employees VALUES('2210','testing','new','AAB9108','admin@rekret.com','3453453453453454','2147483647','','2024-02-06','Male','2','2','17','5','','2','','','','2024-02-06','','single','kristen','','','','','','','','','','','','','0','','ip_based','0','0','0','','0.00','0','999999','0','0','1','','2024-02-06 12:04:06','2024-02-06 12:04:06');
INSERT INTO employees VALUES('2211','ARIF RAHMAN SETIA','RAMADANI','AE00570','arif.rahman@timas.com','1277021701970003','2147483647','082373325808','1997-01-17','Male','2','2','46','5','','2','1','2','','2021-07-27','','single','islam','TK/0','Komp. PT. RAPP TS 1, FMM 488, Pangkalan Kerinci','PELALAWAN','RIAU','100','28381','','arifrahmat.sr','Arif Rahman Setia Ramadani','arifrahmatsr_','Arif Rahman Setia Ramadani','082373325808','0','','ip_based','999','999','0','','0.00','0','1','0','0','1','','2024-02-07 08:33:46','2024-02-07 13:23:12');
INSERT INTO employees VALUES('2212','DWITAMI','Wulandari','AA9105','dwitami.wulandari@timas.com','3171024308950002','123659874512365','0859595894649','1995-08-03','Female','1','1','21','3','','2','1','','','2024-02-05','','single','islam','K/0','','','','100','','','','','','','','0','','ip_based','0','0','0','','0.00','0','0','0','0','1','FRAUD','2024-02-07 10:07:30','2024-02-26 08:48:48');
INSERT INTO employees VALUES('2213','DWITAMI','WULANDARI','AE9109','dwitami.wulandari@timas.com','3171024308950002','660026105026000','','1995-08-03','Female','4','7','65','21','','2','','','','2024-02-20','','single','islam','','','','','','','','','','','','','0','','ip_based','0','0','0','','0.00','0','0','0','0','1','','2024-02-20 21:02:03','2024-02-20 21:02:03');
INSERT INTO employees VALUES('2215','first','last','2000','test007@gmail.com','321632839','0000000000000001','4536267','2000-01-24','Male','1','1','21','','','2','1','','','2023-01-24','','Single','','K/1','dummy address','dummy city','dummy state','','6767','','','','','','','0','','General','0','0','0','','0.00','1','20','0','0','1','','2024-02-23 07:52:33','2024-02-23 07:52:33');
INSERT INTO employees VALUES('2223','Dede','Rohayah','AA9110','dede.rohayah@timas.com','3171024308960002','317102430896000','','1992-12-16','Female','1','1','21','3','','2','','','','2011-01-03','','married','islam','','','','','','','','','','','','','0','','ip_based','0','0','0','','0.00','0','0','0','0','1','','2024-02-23 16:19:48','2024-02-23 16:19:48');
INSERT INTO employees VALUES('2226','Agus ','Budi','AB00555','agus.budi@timas.com','-1706646400','-1571239548','1880147703','2000-01-24','Male','1','3','27','8','','2','1','','','2023-01-24','','Married','','K/0','jl. Cideng timur ','Jakarta Pusat','DKI Jakarta ','100','10160','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO employees VALUES('2227','Budi ','Yanto','AB00556','budi.yanto@timas.com','-1986497702','261899850','1880147704','2000-01-25','Male','1','3','33','9','','2','1','','','2023-01-24','','Married','','K/1','jl. Cideng timur no 1','Jakarta Pusat','DKI Jakarta ','100','10160','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO employees VALUES('2228','Dwi Ayu ','Lestari ','AB00557','dwi.lestari@timas.com','3171024308950000','-807308789','1880147705','2000-01-26','Female ','1','3','36','7','','2','1','','','2023-01-24','','Single','','TK/0','jl. Cideng barat no 1','Jakarta Pusat','DKI Jakarta ','100','10160','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO employees VALUES('2229','Ayu ','Cahya','AB00558','ayu.cahya@timas.com','237248568','-920310086','1880147706','2000-01-27','Female ','1','3','34','11','','2','1','','','2023-01-24','','Married','','K/0','jl. Cideng barat no 2','Jakarta Pusat','DKI Jakarta ','100','10160','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-26 08:46:54','2024-02-26 08:46:54');
INSERT INTO employees VALUES('2230','Muhammad ','Bayu ','AB00559','muhammad.bayu@timas.com','665775940','-1193880734','1880147707','2000-01-28','Male','1','3','28','12','','2','1','','','2023-01-24','','Married','','k/2','jl. Cideng barat no 3','Jakarta Pusat','DKI Jakarta ','100','10160','','','','','','','0','','General','0','0','0','','0.00','1','1','0','0','1','','2024-02-26 08:46:54','2024-02-26 08:46:54');
INSERT INTO employees VALUES('2231','Faleidas AMC','Pereira','AA9111','lulu.faleidas@timas.com','3932647894512652','662978456849536','','1990-10-13','Female','1','1','21','3','','2','','','','2017-01-02','','single','katholik','','','','','','','','','','','','','0','','ip_based','0','0','0','','0.00','0','0','0','0','1','','2024-02-26 10:23:09','2024-02-26 10:23:09');



CREATE TABLE `events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `department_id` bigint(20) unsigned NOT NULL,
  `event_title` varchar(191) NOT NULL,
  `event_note` mediumtext NOT NULL,
  `event_date` date NOT NULL,
  `event_time` varchar(191) NOT NULL,
  `status` varchar(30) NOT NULL,
  `is_notify` tinyint(4) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `events_company_id_foreign` (`company_id`),
  KEY `events_department_id_foreign` (`department_id`),
  CONSTRAINT `events_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `events_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `expense_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_types_company_id_foreign` (`company_id`),
  CONSTRAINT `expense_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `file_manager_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `allowed_extensions` mediumtext NOT NULL,
  `max_file_size` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `file_managers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `added_by` bigint(20) unsigned DEFAULT NULL,
  `file_name` varchar(191) NOT NULL,
  `file_size` varchar(191) DEFAULT NULL,
  `file_extension` varchar(191) DEFAULT NULL,
  `external_link` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_managers_department_id_foreign` (`department_id`),
  KEY `file_managers_added_by_foreign` (`added_by`),
  CONSTRAINT `file_managers_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `file_managers_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_bank_cashes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_name` varchar(50) NOT NULL,
  `account_balance` varchar(191) NOT NULL,
  `initial_balance` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `branch_code` varchar(191) NOT NULL,
  `bank_branch` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_deposits` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `account_id` bigint(20) unsigned DEFAULT NULL,
  `amount` varchar(30) NOT NULL,
  `category` varchar(30) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `payment_method_id` bigint(20) unsigned DEFAULT NULL,
  `payer_id` bigint(20) unsigned DEFAULT NULL,
  `deposit_reference` varchar(191) NOT NULL,
  `deposit_file` varchar(191) DEFAULT NULL,
  `deposit_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_deposits_company_id_foreign` (`company_id`),
  KEY `finance_deposits_account_id_foreign` (`account_id`),
  KEY `finance_deposits_payment_method_id_foreign` (`payment_method_id`),
  KEY `finance_deposits_payer_id_foreign` (`payer_id`),
  CONSTRAINT `finance_deposits_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_deposits_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_deposits_payer_id_foreign` FOREIGN KEY (`payer_id`) REFERENCES `finance_payers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_deposits_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_expenses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `account_id` bigint(20) unsigned DEFAULT NULL,
  `amount` varchar(30) NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `payment_method_id` bigint(20) unsigned DEFAULT NULL,
  `payee_id` bigint(20) unsigned DEFAULT NULL,
  `expense_reference` varchar(191) NOT NULL,
  `expense_file` varchar(191) DEFAULT NULL,
  `expense_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_expenses_company_id_foreign` (`company_id`),
  KEY `finance_expenses_account_id_foreign` (`account_id`),
  KEY `finance_expenses_payment_method_id_foreign` (`payment_method_id`),
  KEY `finance_expenses_payee_id_foreign` (`payee_id`),
  KEY `finance_expenses_category_id_foreign` (`category_id`),
  CONSTRAINT `finance_expenses_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_expenses_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expense_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_expenses_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_expenses_payee_id_foreign` FOREIGN KEY (`payee_id`) REFERENCES `finance_payees` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_expenses_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_payees` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payee_name` varchar(50) NOT NULL,
  `contact_no` varchar(15) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_payers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payer_name` varchar(50) NOT NULL,
  `contact_no` varchar(15) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `account_id` bigint(20) unsigned DEFAULT NULL,
  `amount` varchar(30) NOT NULL,
  `category` varchar(30) NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `payment_method_id` bigint(20) unsigned DEFAULT NULL,
  `payee_id` bigint(20) unsigned DEFAULT NULL,
  `payer_id` bigint(20) unsigned DEFAULT NULL,
  `expense_reference` varchar(191) DEFAULT NULL,
  `expense_file` varchar(191) DEFAULT NULL,
  `expense_date` date DEFAULT NULL,
  `deposit_reference` varchar(191) DEFAULT NULL,
  `deposit_file` varchar(191) DEFAULT NULL,
  `deposit_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_transactions_company_id_foreign` (`company_id`),
  KEY `finance_transactions_account_id_foreign` (`account_id`),
  KEY `finance_transactions_payment_method_id_foreign` (`payment_method_id`),
  KEY `finance_transactions_payee_id_foreign` (`payee_id`),
  KEY `finance_transactions_payer_id_foreign` (`payer_id`),
  KEY `finance_transactions_category_id_foreign` (`category_id`),
  CONSTRAINT `finance_transactions_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transactions_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expense_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transactions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transactions_payee_id_foreign` FOREIGN KEY (`payee_id`) REFERENCES `finance_payees` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transactions_payer_id_foreign` FOREIGN KEY (`payer_id`) REFERENCES `finance_payers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transactions_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_transfers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `from_account_id` bigint(20) unsigned DEFAULT NULL,
  `to_account_id` bigint(20) unsigned DEFAULT NULL,
  `amount` varchar(30) NOT NULL,
  `reference` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `payment_method_id` bigint(20) unsigned DEFAULT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_transfers_company_id_foreign` (`company_id`),
  KEY `finance_transfers_from_account_id_foreign` (`from_account_id`),
  KEY `finance_transfers_to_account_id_foreign` (`to_account_id`),
  KEY `finance_transfers_payment_method_id_foreign` (`payment_method_id`),
  CONSTRAINT `finance_transfers_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transfers_from_account_id_foreign` FOREIGN KEY (`from_account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transfers_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transfers_to_account_id_foreign` FOREIGN KEY (`to_account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `general_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_title` varchar(191) NOT NULL,
  `site_logo` varchar(191) DEFAULT NULL,
  `time_zone` varchar(191) DEFAULT NULL,
  `currency` varchar(191) DEFAULT NULL,
  `currency_format` varchar(191) DEFAULT NULL,
  `default_payment_bank` varchar(191) DEFAULT NULL,
  `date_format` varchar(191) DEFAULT NULL,
  `theme` varchar(191) DEFAULT NULL,
  `footer` varchar(191) DEFAULT NULL,
  `footer_link` varchar(191) DEFAULT NULL,
  `cron_job_attendance_time` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO general_settings VALUES('1','HR System','logo.png','Asia/Jakarta','Rp','prefix','1','Y-m-d','default.css','Rekret','https://rekret.com','10','2020-07-26 02:00:00','2023-02-05 16:28:54');



CREATE TABLE `goal_trackings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `goal_type_id` bigint(20) unsigned NOT NULL,
  `subject` varchar(191) NOT NULL,
  `target_achievement` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `start_date` varchar(191) NOT NULL,
  `end_date` varchar(191) NOT NULL,
  `progress` int(11) NOT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `goal_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `goal_type` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `holidays` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_name` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `is_publish` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `holidays_company_id_foreign` (`company_id`),
  KEY `holidays_department_id_foreign` (`department_id`),
  CONSTRAINT `holidays_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `holidays_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `indicators` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `designation_id` bigint(20) unsigned NOT NULL,
  `department_id` bigint(20) unsigned NOT NULL,
  `customer_experience` varchar(191) NOT NULL,
  `marketing` varchar(191) NOT NULL,
  `administrator` varchar(191) NOT NULL,
  `professionalism` varchar(191) NOT NULL,
  `integrity` varchar(191) NOT NULL,
  `attendance` varchar(191) NOT NULL,
  `added_by` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `invoice_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(20) unsigned DEFAULT NULL,
  `project_id` bigint(20) unsigned DEFAULT NULL,
  `item_name` varchar(191) NOT NULL,
  `item_tax_type` varchar(191) NOT NULL,
  `item_tax_rate` varchar(191) NOT NULL,
  `item_qty` bigint(20) NOT NULL DEFAULT 0,
  `item_unit_price` bigint(20) NOT NULL,
  `item_sub_total` double NOT NULL,
  `sub_total` double NOT NULL,
  `discount_type` tinyint(4) DEFAULT NULL,
  `discount_figure` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_discount` double NOT NULL,
  `grand_total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_items_invoice_id_foreign` (`invoice_id`),
  KEY `invoice_items_project_id_foreign` (`project_id`),
  CONSTRAINT `invoice_items_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `invoice_items_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `invoices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(191) NOT NULL,
  `client_id` bigint(20) unsigned DEFAULT NULL,
  `project_id` bigint(20) unsigned DEFAULT NULL,
  `invoice_date` date NOT NULL,
  `invoice_due_date` date NOT NULL,
  `sub_total` double NOT NULL,
  `discount_type` tinyint(4) DEFAULT NULL,
  `discount_figure` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_discount` double NOT NULL,
  `grand_total` double NOT NULL,
  `invoice_note` mediumtext DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoices_client_id_foreign` (`client_id`),
  KEY `invoices_project_id_foreign` (`project_id`),
  CONSTRAINT `invoices_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`) ON DELETE SET NULL,
  CONSTRAINT `invoices_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `ip_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `ip_address` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `job_candidates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `full_name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `phone` varchar(191) NOT NULL,
  `address` text DEFAULT NULL,
  `cover_letter` longtext NOT NULL,
  `fb_id` varchar(191) DEFAULT NULL,
  `linkedin_id` varchar(191) DEFAULT NULL,
  `cv` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `remarks` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `job_candidates_job_id_foreign` (`job_id`),
  CONSTRAINT `job_candidates_job_id_foreign` FOREIGN KEY (`job_id`) REFERENCES `job_posts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `job_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_category` mediumtext NOT NULL,
  `url` char(36) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `job_interviews` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `added_by` bigint(20) unsigned DEFAULT NULL,
  `interview_place` varchar(191) NOT NULL,
  `interview_date` date NOT NULL,
  `interview_time` time NOT NULL,
  `description` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `job_interviews_job_id_foreign` (`job_id`),
  KEY `job_interviews_added_by_foreign` (`added_by`),
  CONSTRAINT `job_interviews_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `job_interviews_job_id_foreign` FOREIGN KEY (`job_id`) REFERENCES `job_posts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `job_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `job_category_id` bigint(20) unsigned NOT NULL,
  `job_title` varchar(191) NOT NULL,
  `job_type` varchar(191) NOT NULL,
  `no_of_vacancy` int(11) NOT NULL,
  `job_url` varchar(191) NOT NULL,
  `gender` varchar(30) NOT NULL,
  `min_experience` varchar(20) NOT NULL,
  `short_description` mediumtext NOT NULL,
  `long_description` longtext NOT NULL,
  `closing_date` date NOT NULL,
  `status` tinyint(4) NOT NULL,
  `is_featured` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `job_posts_job_category_id_foreign` (`job_category_id`),
  KEY `job_posts_company_id_foreign` (`company_id`),
  CONSTRAINT `job_posts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `job_posts_job_category_id_foreign` FOREIGN KEY (`job_category_id`) REFERENCES `job_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `leave_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `leave_type` varchar(50) NOT NULL,
  `allocated_day` int(11) DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_types_company_id_foreign` (`company_id`),
  CONSTRAINT `leave_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO leave_types VALUES('1','Manual','','','2024-02-05 15:24:40','2024-02-05 15:24:40');



CREATE TABLE `leaves` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `leave_type_id` bigint(20) unsigned DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `department_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `total_days` int(11) NOT NULL,
  `leave_reason` mediumtext DEFAULT NULL,
  `remarks` varchar(191) DEFAULT NULL,
  `status` varchar(40) NOT NULL,
  `is_half` tinyint(4) DEFAULT 0,
  `is_notify` tinyint(4) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leaves_company_id_foreign` (`company_id`),
  KEY `leaves_employee_id_foreign` (`employee_id`),
  KEY `leaves_leave_type_id_foreign` (`leave_type_id`),
  KEY `leaves_department_id_foreign` (`department_id`),
  CONSTRAINT `leaves_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `leaves_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `leaves_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL,
  CONSTRAINT `leaves_leave_type_id_foreign` FOREIGN KEY (`leave_type_id`) REFERENCES `leave_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `locations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_name` varchar(191) NOT NULL,
  `location_head` bigint(20) unsigned DEFAULT NULL,
  `address1` varchar(191) DEFAULT NULL,
  `address2` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` int(10) unsigned DEFAULT NULL,
  `zip` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `locations_location_head_foreign` (`location_head`),
  KEY `locations_country_foreign` (`country`),
  CONSTRAINT `locations_country_foreign` FOREIGN KEY (`country`) REFERENCES `countries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `locations_location_head_foreign` FOREIGN KEY (`location_head`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO locations VALUES('1','Jakarta','2050','Tanah Abang II no 81','','Jakarta Pusat','DKI Jakarta','100','10160','2024-02-05 15:35:54','2024-02-06 14:06:23');
INSERT INTO locations VALUES('2','Pangkalan Kerinci','','RAPP Mill','Pangkalan Kerinci','Pelalawan','Riau','100','28301','2024-02-05 16:53:35','2024-02-05 16:53:35');
INSERT INTO locations VALUES('3','Serang','','Jl KM 72 Serang','','Serang','Banten','100','0','2024-02-05 19:43:39','2024-02-05 19:43:39');
INSERT INTO locations VALUES('4','Tarakan','','Kalimatan Utara','','','','100','0','2024-02-05 19:51:26','2024-02-05 19:51:26');
INSERT INTO locations VALUES('5','Tuban','','Jawa Timur','','','','100','0','2024-02-05 19:53:34','2024-02-05 19:53:34');



CREATE TABLE `log_report_attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `report_attendance_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `log_report_attendances_user_id_foreign` (`user_id`),
  KEY `log_report_attendances_report_attendance_id_foreign` (`report_attendance_id`),
  CONSTRAINT `log_report_attendances_report_attendance_id_foreign` FOREIGN KEY (`report_attendance_id`) REFERENCES `report_attendances` (`id`) ON DELETE SET NULL,
  CONSTRAINT `log_report_attendances_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `mail_receivers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mail_receivers_employee_id_foreign` (`employee_id`),
  CONSTRAINT `mail_receivers_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO mail_receivers VALUES('1','2210','2024-02-06 16:00:17','2024-02-06 16:00:17');
INSERT INTO mail_receivers VALUES('2','2041','2024-02-06 16:52:56','2024-02-06 16:52:56');



CREATE TABLE `meetings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `meeting_title` varchar(191) NOT NULL,
  `meeting_note` mediumtext NOT NULL,
  `meeting_date` date NOT NULL,
  `meeting_time` varchar(191) NOT NULL,
  `status` varchar(30) NOT NULL,
  `is_notify` tinyint(4) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meetings_company_id_foreign` (`company_id`),
  CONSTRAINT `meetings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO meetings VALUES('1','1','RIA RICIS GUGAT CERAI ?!!','Tolong di bawa beberapa informasi terkait perceraian Ria Ricis dari beberapa sumber yang valid. Saya mau kamu tampilkan dalam Slide Power Point','2024-02-06','10:00PM','ongoing','','2024-02-06 15:53:41','2024-02-06 15:53:41');
INSERT INTO meetings VALUES('2','1','RIA RICIS GUGAT CERAI ?!!','Tolong di bawa beberapa informasi terkait perceraian Ria Ricis dari beberapa sumber yang valid. Saya mau kamu tampilkan dalam Slide Power Point','2024-02-07','10:00PM','ongoing','1','2024-02-06 15:55:16','2024-02-06 15:55:16');



CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES('1','2014_10_12_100000_create_password_resets_table','1');
INSERT INTO migrations VALUES('2','2019_08_19_000000_create_failed_jobs_table','1');
INSERT INTO migrations VALUES('3','2020_02_09_103616_create_role_users_table','1');
INSERT INTO migrations VALUES('4','2020_02_10_00000_create_users_table','1');
INSERT INTO migrations VALUES('5','2020_02_12_091317_create_locations_table','1');
INSERT INTO migrations VALUES('6','2020_02_12_091344_create_companies_table','1');
INSERT INTO migrations VALUES('7','2020_02_12_091353_create_departments_table','1');
INSERT INTO migrations VALUES('8','2020_02_12_091742_create_statuses_table','1');
INSERT INTO migrations VALUES('9','2020_02_12_091824_create_office_shifts_table','1');
INSERT INTO migrations VALUES('10','2020_02_12_091936_create_designations_table','1');
INSERT INTO migrations VALUES('11','2020_02_12_092121_create_leave_types_table','1');
INSERT INTO migrations VALUES('12','2020_02_13_100750_create_employees_table','1');
INSERT INTO migrations VALUES('13','2020_02_14_092309_create_leaves_table','1');
INSERT INTO migrations VALUES('14','2020_02_20_115449_create_general_settings_table','1');
INSERT INTO migrations VALUES('15','2020_02_23_054028_create_permission_tables','1');
INSERT INTO migrations VALUES('16','2020_02_23_184712_add_columns_to_permission_table','1');
INSERT INTO migrations VALUES('17','2020_03_19_132718_add_employee_id_on_locations_table','2');
INSERT INTO migrations VALUES('18','2020_03_20_162201_create_announcements_table','2');
INSERT INTO migrations VALUES('19','2020_03_20_201357_create_policies_table','2');
INSERT INTO migrations VALUES('20','2020_03_22_113701_create_holidays_table','2');
INSERT INTO migrations VALUES('21','2020_03_23_100213_create_award_types_table','3');
INSERT INTO migrations VALUES('22','2020_03_23_100248_create_awards_table','3');
INSERT INTO migrations VALUES('23','2020_03_23_123604_create_transfers_table','3');
INSERT INTO migrations VALUES('24','2020_03_23_144135_create_resignations_table','3');
INSERT INTO migrations VALUES('25','2020_03_23_150510_create_travel_types_table','3');
INSERT INTO migrations VALUES('26','2020_03_23_152610_create_travels_table','3');
INSERT INTO migrations VALUES('27','2020_03_23_154228_create_promotions_table','3');
INSERT INTO migrations VALUES('28','2020_03_23_194844_create_complaints_table','3');
INSERT INTO migrations VALUES('29','2020_03_24_134301_create_warnings_type_table','3');
INSERT INTO migrations VALUES('30','2020_03_24_134304_create_warnings_table','3');
INSERT INTO migrations VALUES('31','2020_03_24_143012_create_termination_types_table','3');
INSERT INTO migrations VALUES('32','2020_03_24_143038_create_terminations_table','3');
INSERT INTO migrations VALUES('33','2020_04_06_185530_create_training_types_table','3');
INSERT INTO migrations VALUES('34','2020_04_06_190352_create_trainers_table','3');
INSERT INTO migrations VALUES('35','2020_04_07_083717_create_training_lists_table','3');
INSERT INTO migrations VALUES('36','2020_04_07_103503_create_employee_training_list_table','3');
INSERT INTO migrations VALUES('37','2020_04_08_095050_create_events_table','3');
INSERT INTO migrations VALUES('38','2020_04_08_163144_create_meetings_table','3');
INSERT INTO migrations VALUES('39','2020_04_08_163906_create_employee_meeting_table','3');
INSERT INTO migrations VALUES('40','2020_05_05_212429_create_document_types_table','3');
INSERT INTO migrations VALUES('41','2020_04_09_063646_create_finance_bank_cashes_table','4');
INSERT INTO migrations VALUES('42','2020_04_09_154642_create_finance_payees_table','4');
INSERT INTO migrations VALUES('43','2020_04_09_201357_create_finance_payers_table','4');
INSERT INTO migrations VALUES('44','2020_04_10_064405_create_payment_methods_table','4');
INSERT INTO migrations VALUES('45','2020_04_10_094429_create_expense_types_table','4');
INSERT INTO migrations VALUES('46','2020_04_10_121829_create_finance_deposits_table','4');
INSERT INTO migrations VALUES('47','2020_04_11_084040_create_finance_expenses_table','4');
INSERT INTO migrations VALUES('48','2020_04_11_164442_create_finance_transactions_table','4');
INSERT INTO migrations VALUES('49','2020_04_13_071336_create_finance_transfers_table','4');
INSERT INTO migrations VALUES('50','2020_04_13_135659_create_asset_categories_table','5');
INSERT INTO migrations VALUES('51','2020_04_13_160310_create_assets_table','5');
INSERT INTO migrations VALUES('52','2020_04_15_103730_create_file_manager_settings_table','5');
INSERT INTO migrations VALUES('53','2020_04_15_193003_create_file_managers_table','5');
INSERT INTO migrations VALUES('54','2020_04_18_094856_create_support_tickets_table','5');
INSERT INTO migrations VALUES('55','2020_04_21_052227_create_ticket_comments_table','5');
INSERT INTO migrations VALUES('56','2020_04_21_172758_create_employee_support_ticket_table','5');
INSERT INTO migrations VALUES('57','2020_04_24_070148_create_countries_table','5');
INSERT INTO migrations VALUES('58','2020_04_24_071350_create_clients_table','5');
INSERT INTO migrations VALUES('59','2020_04_25_083125_create_projects_table','5');
INSERT INTO migrations VALUES('60','2020_04_25_092544_create_employee_project_table','5');
INSERT INTO migrations VALUES('61','2020_04_27_132031_create_project_discussions_table','5');
INSERT INTO migrations VALUES('62','2020_04_27_202219_create_project_bugs_table','5');
INSERT INTO migrations VALUES('63','2020_04_28_095459_create_project_files_table','5');
INSERT INTO migrations VALUES('64','2020_04_28_172850_create_tasks_table','5');
INSERT INTO migrations VALUES('65','2020_04_28_183034_create_employee_task_table','5');
INSERT INTO migrations VALUES('66','2020_04_29_164820_create_task_discussions_table','5');
INSERT INTO migrations VALUES('67','2020_04_29_185015_create_task_files_table','5');
INSERT INTO migrations VALUES('68','2020_05_01_093124_create_tax_types_table','5');
INSERT INTO migrations VALUES('69','2020_05_02_100902_create_invoices_table','5');
INSERT INTO migrations VALUES('70','2020_05_02_110310_create_invoice_items_table','5');
INSERT INTO migrations VALUES('71','2020_05_06_085438_create_employee_immigrations_table','6');
INSERT INTO migrations VALUES('72','2020_05_07_191655_create_employee_contacts_table','6');
INSERT INTO migrations VALUES('73','2020_05_08_181821_create_employee_documents_table','6');
INSERT INTO migrations VALUES('74','2020_05_12_200437_create_qualification_education_levels_table','6');
INSERT INTO migrations VALUES('75','2020_05_16_204859_create_qualification_languages_table','6');
INSERT INTO migrations VALUES('76','2020_05_17_181817_create_qualification_skills_table','6');
INSERT INTO migrations VALUES('77','2020_05_17_191414_create_employee_qualificaitons_table','6');
INSERT INTO migrations VALUES('78','2020_05_18_191844_create_employee_work_experience_table','6');
INSERT INTO migrations VALUES('79','2020_05_19_170527_create_employee_bank_accounts_table','6');
INSERT INTO migrations VALUES('80','2020_05_22_201218_create_salary_allowances_table','6');
INSERT INTO migrations VALUES('81','2020_05_23_184036_create_salary_commissions_table','6');
INSERT INTO migrations VALUES('82','2020_05_24_085740_create_salary_deductions_table','6');
INSERT INTO migrations VALUES('83','2020_05_24_103950_create_salary_other_payments_table','6');
INSERT INTO migrations VALUES('84','2020_05_24_163618_create_salary_overtimes_table','6');
INSERT INTO migrations VALUES('85','2020_05_26_134431_create_salary_loans_table','6');
INSERT INTO migrations VALUES('86','2020_06_11_104501_create_payslips_table','7');
INSERT INTO migrations VALUES('87','2020_06_17_055449_create_calendarables_table','7');
INSERT INTO migrations VALUES('88','2020_06_19_083329_create_job_categories_table','7');
INSERT INTO migrations VALUES('89','2020_06_19_152528_create_job_employers_table','7');
INSERT INTO migrations VALUES('90','2020_06_22_052056_create_attendances_table','7');
INSERT INTO migrations VALUES('91','2020_07_05_010713_create_job_posts_table','7');
INSERT INTO migrations VALUES('92','2020_07_06_162706_create_job_candidates_table','7');
INSERT INTO migrations VALUES('93','2020_07_07_144320_create_job_interviews_table','7');
INSERT INTO migrations VALUES('94','2020_07_07_160007_create_candidate_interview_table','7');
INSERT INTO migrations VALUES('95','2020_07_07_160428_create_employee_interview_table','7');
INSERT INTO migrations VALUES('96','2020_07_25_003500_create_official_documents_table','7');
INSERT INTO migrations VALUES('97','2020_04_18_203257_create_notifications_table','8');
INSERT INTO migrations VALUES('98','2020_10_16_202848_create_c_m_s_table','9');
INSERT INTO migrations VALUES('99','2018_08_29_200844_create_languages_table','10');
INSERT INTO migrations VALUES('100','2018_08_29_205156_create_translations_table','10');
INSERT INTO migrations VALUES('101','2021_01_08_072901_create_goal_types_table','10');
INSERT INTO migrations VALUES('102','2021_01_08_165133_create_indicators_table','10');
INSERT INTO migrations VALUES('103','2021_01_09_081319_create_appraisals_table','10');
INSERT INTO migrations VALUES('104','2021_01_10_080158_create_goal_trackings_table','10');
INSERT INTO migrations VALUES('105','2021_03_28_184255_create_ip_settings_table','11');
INSERT INTO migrations VALUES('106','2021_04_05_103029_create_salary_basics_table','12');
INSERT INTO migrations VALUES('107','2023_02_02_084627_create_raw_attendances_table','13');
INSERT INTO migrations VALUES('108','2023_02_05_090809_remove_some_columns_attendances','14');
INSERT INTO migrations VALUES('109','2023_02_05_155637_remove_ip_from_attendances','15');
INSERT INTO migrations VALUES('110','2023_02_08_110401_add_dependent_to_employees','16');
INSERT INTO migrations VALUES('111','2023_02_08_112404_add_identity_number_to_employees','17');
INSERT INTO migrations VALUES('113','2023_02_08_132908_create_table_employee_settings','18');
INSERT INTO migrations VALUES('115','2023_02_09_145414_create_bpjs_table','19');
INSERT INTO migrations VALUES('116','2023_02_09_171342_create_bpjs_kes_table','20');
INSERT INTO migrations VALUES('117','2023_02_09_173033_create_taxes_table','21');
INSERT INTO migrations VALUES('118','2023_02_09_184108_create_ptkp_table','22');
INSERT INTO migrations VALUES('120','2023_02_15_154007_add_is_payroll_and_is_ceo_to_roles','23');
INSERT INTO migrations VALUES('121','2023_02_16_093419_change_dependent_column_type_employees_table','24');
INSERT INTO migrations VALUES('122','2023_02_15_133334_add_is_payroll_and_is_ceo_column_to_employees_table','25');
INSERT INTO migrations VALUES('123','2023_02_17_074147_add_salary_column_to_bpjs_kes_table','25');
INSERT INTO migrations VALUES('124','2023_03_04_233821_add_cut_off_date_to_companies_table','26');
INSERT INTO migrations VALUES('125','2023_03_05_144216_add_cron_job_attendance_time_to_general_settings_table','27');
INSERT INTO migrations VALUES('126','2023_03_05_151917_add_following_attendance_to_employees','28');
INSERT INTO migrations VALUES('127','2023_03_05_172328_create_reimbursement_types_table','29');
INSERT INTO migrations VALUES('128','2023_03_05_173609_create_reimbursements_table','30');
INSERT INTO migrations VALUES('129','2023_03_05_183603_add_status_to_reimbursements_table','31');
INSERT INTO migrations VALUES('130','2023_03_05_184455_add_description_to_reimbursements_table','32');
INSERT INTO migrations VALUES('131','2023_03_05_185007_add_attachment_to_reimbursements_table','33');
INSERT INTO migrations VALUES('132','2023_03_05_191642_add_employee_id_to_reimbursements_table','34');
INSERT INTO migrations VALUES('133','2023_03_18_164052_add_range_in_out_to_office_shifts_table','35');
INSERT INTO migrations VALUES('134','2023_03_18_184359_add_min_work_hour_to_office_shifts_table','36');
INSERT INTO migrations VALUES('135','2023_03_18_185212_add_dispensation_and_position_to_employees_table','37');
INSERT INTO migrations VALUES('136','2023_03_31_043700_add_is_underwork_to_attendances_table','38');
INSERT INTO migrations VALUES('137','2023_03_27_111907_add_status_to_attendances_table','39');
INSERT INTO migrations VALUES('138','2023_04_04_152204_create_report_attendances_table','40');
INSERT INTO migrations VALUES('139','2023_04_04_172924_add_attendance_date_to_report_attendances','41');
INSERT INTO migrations VALUES('140','2023_04_04_191751_set_nullable_status_to_report_attendances','42');
INSERT INTO migrations VALUES('141','2023_04_10_153124_add_last_year_leave_to_employees','43');
INSERT INTO migrations VALUES('142','2023_04_10_205922_create_table_mail_receivers','44');
INSERT INTO migrations VALUES('143','2023_04_11_092333_create_log_report_attendances_table','45');
INSERT INTO migrations VALUES('144','2023_04_14_130059_add_leave_amount_to_companies','46');



CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO model_has_roles VALUES('1','App\\User','1');
INSERT INTO model_has_roles VALUES('1','App\\User','8');
INSERT INTO model_has_roles VALUES('1','App\\User','28');
INSERT INTO model_has_roles VALUES('1','App\\User','29');
INSERT INTO model_has_roles VALUES('1','App\\User','30');
INSERT INTO model_has_roles VALUES('1','App\\User','31');
INSERT INTO model_has_roles VALUES('1','App\\User','36');
INSERT INTO model_has_roles VALUES('1','App\\User','40');
INSERT INTO model_has_roles VALUES('1','App\\User','44');
INSERT INTO model_has_roles VALUES('1','App\\User','46');
INSERT INTO model_has_roles VALUES('1','App\\User','47');
INSERT INTO model_has_roles VALUES('1','App\\User','48');
INSERT INTO model_has_roles VALUES('1','App\\User','162');
INSERT INTO model_has_roles VALUES('1','App\\User','177');
INSERT INTO model_has_roles VALUES('1','App\\User','1991');
INSERT INTO model_has_roles VALUES('2','App\\User','12');
INSERT INTO model_has_roles VALUES('2','App\\User','13');
INSERT INTO model_has_roles VALUES('2','App\\User','14');
INSERT INTO model_has_roles VALUES('2','App\\User','15');
INSERT INTO model_has_roles VALUES('2','App\\User','24');
INSERT INTO model_has_roles VALUES('2','App\\User','25');
INSERT INTO model_has_roles VALUES('2','App\\User','27');
INSERT INTO model_has_roles VALUES('2','App\\User','32');
INSERT INTO model_has_roles VALUES('2','App\\User','33');
INSERT INTO model_has_roles VALUES('2','App\\User','34');
INSERT INTO model_has_roles VALUES('2','App\\User','37');
INSERT INTO model_has_roles VALUES('2','App\\User','38');
INSERT INTO model_has_roles VALUES('2','App\\User','41');
INSERT INTO model_has_roles VALUES('2','App\\User','42');
INSERT INTO model_has_roles VALUES('2','App\\User','43');
INSERT INTO model_has_roles VALUES('2','App\\User','49');
INSERT INTO model_has_roles VALUES('2','App\\User','50');
INSERT INTO model_has_roles VALUES('2','App\\User','52');
INSERT INTO model_has_roles VALUES('2','App\\User','53');
INSERT INTO model_has_roles VALUES('2','App\\User','54');
INSERT INTO model_has_roles VALUES('2','App\\User','57');
INSERT INTO model_has_roles VALUES('2','App\\User','58');
INSERT INTO model_has_roles VALUES('2','App\\User','59');
INSERT INTO model_has_roles VALUES('2','App\\User','60');
INSERT INTO model_has_roles VALUES('2','App\\User','61');
INSERT INTO model_has_roles VALUES('2','App\\User','64');
INSERT INTO model_has_roles VALUES('2','App\\User','65');
INSERT INTO model_has_roles VALUES('2','App\\User','67');
INSERT INTO model_has_roles VALUES('2','App\\User','68');
INSERT INTO model_has_roles VALUES('2','App\\User','72');
INSERT INTO model_has_roles VALUES('2','App\\User','75');
INSERT INTO model_has_roles VALUES('2','App\\User','76');
INSERT INTO model_has_roles VALUES('2','App\\User','77');
INSERT INTO model_has_roles VALUES('2','App\\User','78');
INSERT INTO model_has_roles VALUES('2','App\\User','79');
INSERT INTO model_has_roles VALUES('2','App\\User','80');
INSERT INTO model_has_roles VALUES('2','App\\User','82');
INSERT INTO model_has_roles VALUES('2','App\\User','83');
INSERT INTO model_has_roles VALUES('2','App\\User','84');
INSERT INTO model_has_roles VALUES('2','App\\User','85');
INSERT INTO model_has_roles VALUES('2','App\\User','86');
INSERT INTO model_has_roles VALUES('2','App\\User','87');
INSERT INTO model_has_roles VALUES('2','App\\User','88');
INSERT INTO model_has_roles VALUES('2','App\\User','90');
INSERT INTO model_has_roles VALUES('2','App\\User','91');
INSERT INTO model_has_roles VALUES('2','App\\User','92');
INSERT INTO model_has_roles VALUES('2','App\\User','93');
INSERT INTO model_has_roles VALUES('2','App\\User','94');
INSERT INTO model_has_roles VALUES('2','App\\User','95');
INSERT INTO model_has_roles VALUES('2','App\\User','96');
INSERT INTO model_has_roles VALUES('2','App\\User','97');
INSERT INTO model_has_roles VALUES('2','App\\User','98');
INSERT INTO model_has_roles VALUES('2','App\\User','99');
INSERT INTO model_has_roles VALUES('2','App\\User','100');
INSERT INTO model_has_roles VALUES('2','App\\User','101');
INSERT INTO model_has_roles VALUES('2','App\\User','102');
INSERT INTO model_has_roles VALUES('2','App\\User','103');
INSERT INTO model_has_roles VALUES('2','App\\User','104');
INSERT INTO model_has_roles VALUES('2','App\\User','105');
INSERT INTO model_has_roles VALUES('2','App\\User','106');
INSERT INTO model_has_roles VALUES('2','App\\User','109');
INSERT INTO model_has_roles VALUES('2','App\\User','110');
INSERT INTO model_has_roles VALUES('2','App\\User','111');
INSERT INTO model_has_roles VALUES('2','App\\User','112');
INSERT INTO model_has_roles VALUES('2','App\\User','113');
INSERT INTO model_has_roles VALUES('2','App\\User','114');
INSERT INTO model_has_roles VALUES('2','App\\User','115');
INSERT INTO model_has_roles VALUES('2','App\\User','116');
INSERT INTO model_has_roles VALUES('2','App\\User','117');
INSERT INTO model_has_roles VALUES('2','App\\User','118');
INSERT INTO model_has_roles VALUES('2','App\\User','119');
INSERT INTO model_has_roles VALUES('2','App\\User','120');
INSERT INTO model_has_roles VALUES('2','App\\User','121');
INSERT INTO model_has_roles VALUES('2','App\\User','122');
INSERT INTO model_has_roles VALUES('2','App\\User','123');
INSERT INTO model_has_roles VALUES('2','App\\User','124');
INSERT INTO model_has_roles VALUES('2','App\\User','125');
INSERT INTO model_has_roles VALUES('2','App\\User','126');
INSERT INTO model_has_roles VALUES('2','App\\User','127');
INSERT INTO model_has_roles VALUES('2','App\\User','128');
INSERT INTO model_has_roles VALUES('2','App\\User','129');
INSERT INTO model_has_roles VALUES('2','App\\User','130');
INSERT INTO model_has_roles VALUES('2','App\\User','132');
INSERT INTO model_has_roles VALUES('2','App\\User','133');
INSERT INTO model_has_roles VALUES('2','App\\User','134');
INSERT INTO model_has_roles VALUES('2','App\\User','135');
INSERT INTO model_has_roles VALUES('2','App\\User','136');
INSERT INTO model_has_roles VALUES('2','App\\User','137');
INSERT INTO model_has_roles VALUES('2','App\\User','138');
INSERT INTO model_has_roles VALUES('2','App\\User','139');
INSERT INTO model_has_roles VALUES('2','App\\User','140');
INSERT INTO model_has_roles VALUES('2','App\\User','141');
INSERT INTO model_has_roles VALUES('2','App\\User','142');
INSERT INTO model_has_roles VALUES('2','App\\User','143');
INSERT INTO model_has_roles VALUES('2','App\\User','144');
INSERT INTO model_has_roles VALUES('2','App\\User','145');
INSERT INTO model_has_roles VALUES('2','App\\User','146');
INSERT INTO model_has_roles VALUES('2','App\\User','147');
INSERT INTO model_has_roles VALUES('2','App\\User','148');
INSERT INTO model_has_roles VALUES('2','App\\User','149');
INSERT INTO model_has_roles VALUES('2','App\\User','151');
INSERT INTO model_has_roles VALUES('2','App\\User','152');
INSERT INTO model_has_roles VALUES('2','App\\User','153');
INSERT INTO model_has_roles VALUES('2','App\\User','154');
INSERT INTO model_has_roles VALUES('2','App\\User','155');
INSERT INTO model_has_roles VALUES('2','App\\User','156');
INSERT INTO model_has_roles VALUES('2','App\\User','157');
INSERT INTO model_has_roles VALUES('2','App\\User','159');
INSERT INTO model_has_roles VALUES('2','App\\User','160');
INSERT INTO model_has_roles VALUES('2','App\\User','161');
INSERT INTO model_has_roles VALUES('2','App\\User','167');
INSERT INTO model_has_roles VALUES('2','App\\User','169');
INSERT INTO model_has_roles VALUES('2','App\\User','181');
INSERT INTO model_has_roles VALUES('2','App\\User','182');
INSERT INTO model_has_roles VALUES('2','App\\User','294');
INSERT INTO model_has_roles VALUES('2','App\\User','369');
INSERT INTO model_has_roles VALUES('2','App\\User','436');
INSERT INTO model_has_roles VALUES('2','App\\User','437');
INSERT INTO model_has_roles VALUES('2','App\\User','438');
INSERT INTO model_has_roles VALUES('2','App\\User','439');
INSERT INTO model_has_roles VALUES('2','App\\User','441');
INSERT INTO model_has_roles VALUES('2','App\\User','442');
INSERT INTO model_has_roles VALUES('2','App\\User','443');
INSERT INTO model_has_roles VALUES('2','App\\User','444');
INSERT INTO model_has_roles VALUES('2','App\\User','445');
INSERT INTO model_has_roles VALUES('2','App\\User','447');
INSERT INTO model_has_roles VALUES('2','App\\User','448');
INSERT INTO model_has_roles VALUES('2','App\\User','449');
INSERT INTO model_has_roles VALUES('2','App\\User','450');
INSERT INTO model_has_roles VALUES('2','App\\User','451');
INSERT INTO model_has_roles VALUES('2','App\\User','452');
INSERT INTO model_has_roles VALUES('2','App\\User','453');
INSERT INTO model_has_roles VALUES('2','App\\User','454');
INSERT INTO model_has_roles VALUES('2','App\\User','455');
INSERT INTO model_has_roles VALUES('2','App\\User','456');
INSERT INTO model_has_roles VALUES('2','App\\User','457');
INSERT INTO model_has_roles VALUES('2','App\\User','458');
INSERT INTO model_has_roles VALUES('2','App\\User','459');
INSERT INTO model_has_roles VALUES('2','App\\User','460');
INSERT INTO model_has_roles VALUES('2','App\\User','461');
INSERT INTO model_has_roles VALUES('2','App\\User','462');
INSERT INTO model_has_roles VALUES('2','App\\User','463');
INSERT INTO model_has_roles VALUES('2','App\\User','464');
INSERT INTO model_has_roles VALUES('2','App\\User','465');
INSERT INTO model_has_roles VALUES('2','App\\User','466');
INSERT INTO model_has_roles VALUES('2','App\\User','467');
INSERT INTO model_has_roles VALUES('2','App\\User','468');
INSERT INTO model_has_roles VALUES('2','App\\User','469');
INSERT INTO model_has_roles VALUES('2','App\\User','470');
INSERT INTO model_has_roles VALUES('2','App\\User','471');
INSERT INTO model_has_roles VALUES('2','App\\User','472');
INSERT INTO model_has_roles VALUES('2','App\\User','473');
INSERT INTO model_has_roles VALUES('2','App\\User','474');
INSERT INTO model_has_roles VALUES('2','App\\User','475');
INSERT INTO model_has_roles VALUES('2','App\\User','476');
INSERT INTO model_has_roles VALUES('2','App\\User','477');
INSERT INTO model_has_roles VALUES('2','App\\User','478');
INSERT INTO model_has_roles VALUES('2','App\\User','501');
INSERT INTO model_has_roles VALUES('2','App\\User','503');
INSERT INTO model_has_roles VALUES('2','App\\User','504');
INSERT INTO model_has_roles VALUES('2','App\\User','505');
INSERT INTO model_has_roles VALUES('2','App\\User','506');
INSERT INTO model_has_roles VALUES('2','App\\User','507');
INSERT INTO model_has_roles VALUES('2','App\\User','508');
INSERT INTO model_has_roles VALUES('2','App\\User','509');
INSERT INTO model_has_roles VALUES('2','App\\User','510');
INSERT INTO model_has_roles VALUES('2','App\\User','511');
INSERT INTO model_has_roles VALUES('2','App\\User','512');
INSERT INTO model_has_roles VALUES('2','App\\User','513');
INSERT INTO model_has_roles VALUES('2','App\\User','514');
INSERT INTO model_has_roles VALUES('2','App\\User','515');
INSERT INTO model_has_roles VALUES('2','App\\User','516');
INSERT INTO model_has_roles VALUES('2','App\\User','517');
INSERT INTO model_has_roles VALUES('2','App\\User','518');
INSERT INTO model_has_roles VALUES('2','App\\User','519');
INSERT INTO model_has_roles VALUES('2','App\\User','525');
INSERT INTO model_has_roles VALUES('2','App\\User','526');
INSERT INTO model_has_roles VALUES('2','App\\User','527');
INSERT INTO model_has_roles VALUES('2','App\\User','528');
INSERT INTO model_has_roles VALUES('2','App\\User','529');
INSERT INTO model_has_roles VALUES('2','App\\User','542');
INSERT INTO model_has_roles VALUES('2','App\\User','543');
INSERT INTO model_has_roles VALUES('2','App\\User','544');
INSERT INTO model_has_roles VALUES('2','App\\User','1993');
INSERT INTO model_has_roles VALUES('2','App\\User','1994');
INSERT INTO model_has_roles VALUES('2','App\\User','1995');
INSERT INTO model_has_roles VALUES('2','App\\User','2017');
INSERT INTO model_has_roles VALUES('2','App\\User','2030');
INSERT INTO model_has_roles VALUES('2','App\\User','2040');
INSERT INTO model_has_roles VALUES('2','App\\User','2041');
INSERT INTO model_has_roles VALUES('2','App\\User','2048');
INSERT INTO model_has_roles VALUES('2','App\\User','2050');
INSERT INTO model_has_roles VALUES('2','App\\User','2051');
INSERT INTO model_has_roles VALUES('2','App\\User','2052');
INSERT INTO model_has_roles VALUES('2','App\\User','2053');
INSERT INTO model_has_roles VALUES('2','App\\User','2054');
INSERT INTO model_has_roles VALUES('2','App\\User','2055');
INSERT INTO model_has_roles VALUES('2','App\\User','2056');
INSERT INTO model_has_roles VALUES('2','App\\User','2209');
INSERT INTO model_has_roles VALUES('2','App\\User','2210');
INSERT INTO model_has_roles VALUES('2','App\\User','2211');
INSERT INTO model_has_roles VALUES('2','App\\User','2212');
INSERT INTO model_has_roles VALUES('2','App\\User','2213');
INSERT INTO model_has_roles VALUES('2','App\\User','2224');
INSERT INTO model_has_roles VALUES('3','App\\User','39');
INSERT INTO model_has_roles VALUES('4','App\\User','11');
INSERT INTO model_has_roles VALUES('4','App\\User','23');
INSERT INTO model_has_roles VALUES('4','App\\User','26');
INSERT INTO model_has_roles VALUES('4','App\\User','45');
INSERT INTO model_has_roles VALUES('4','App\\User','55');
INSERT INTO model_has_roles VALUES('4','App\\User','62');
INSERT INTO model_has_roles VALUES('4','App\\User','63');
INSERT INTO model_has_roles VALUES('4','App\\User','70');
INSERT INTO model_has_roles VALUES('4','App\\User','71');
INSERT INTO model_has_roles VALUES('4','App\\User','73');
INSERT INTO model_has_roles VALUES('4','App\\User','74');
INSERT INTO model_has_roles VALUES('4','App\\User','81');
INSERT INTO model_has_roles VALUES('4','App\\User','89');
INSERT INTO model_has_roles VALUES('4','App\\User','107');
INSERT INTO model_has_roles VALUES('4','App\\User','108');
INSERT INTO model_has_roles VALUES('4','App\\User','150');
INSERT INTO model_has_roles VALUES('4','App\\User','446');
INSERT INTO model_has_roles VALUES('4','App\\User','1992');
INSERT INTO model_has_roles VALUES('6','App\\User','9');
INSERT INTO model_has_roles VALUES('6','App\\User','10');
INSERT INTO model_has_roles VALUES('6','App\\User','56');
INSERT INTO model_has_roles VALUES('6','App\\User','131');
INSERT INTO model_has_roles VALUES('6','App\\User','163');
INSERT INTO model_has_roles VALUES('6','App\\User','164');
INSERT INTO model_has_roles VALUES('6','App\\User','165');
INSERT INTO model_has_roles VALUES('6','App\\User','166');
INSERT INTO model_has_roles VALUES('6','App\\User','440');
INSERT INTO model_has_roles VALUES('6','App\\User','535');
INSERT INTO model_has_roles VALUES('6','App\\User','536');
INSERT INTO model_has_roles VALUES('6','App\\User','537');
INSERT INTO model_has_roles VALUES('6','App\\User','538');
INSERT INTO model_has_roles VALUES('6','App\\User','539');
INSERT INTO model_has_roles VALUES('6','App\\User','540');
INSERT INTO model_has_roles VALUES('6','App\\User','541');
INSERT INTO model_has_roles VALUES('6','App\\User','1093');
INSERT INTO model_has_roles VALUES('6','App\\User','2042');
INSERT INTO model_has_roles VALUES('6','App\\User','2208');
INSERT INTO model_has_roles VALUES('6','App\\User','2214');



CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO notifications VALUES('00f693f4-0160-4f1c-b0d9-a9e634aa6e31','App\\Notifications\\EmployeeCreatedNotification','App\\User','2029','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 15:59:47','2024-02-05 15:59:47');
INSERT INTO notifications VALUES('077511a1-b83a-4c0c-a253-1d41c8138c75','App\\Notifications\\EmployeeCreatedNotification','App\\User','2029','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 18:15:19','2024-02-05 18:15:19');
INSERT INTO notifications VALUES('0961820b-8f57-4010-825d-1bb982544eca','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-26 15:30:58','2024-02-26 08:46:54','2024-02-26 15:30:58');
INSERT INTO notifications VALUES('0f595fb8-7418-4d88-8bf0-bcbf9ac370ea','App\\Notifications\\EmployeeTravelStatus','App\\User','2211','{\"data\":\"Your travel request status is --- approved\",\"link\":\"\\/profile#Employee_travel\"}','','2024-02-07 13:15:22','2024-02-07 13:15:22');
INSERT INTO notifications VALUES('18c39f53-2418-4005-9b92-5214fe61fc31','App\\Notifications\\EmployeeCreatedNotification','App\\User','2029','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 18:08:42','2024-02-05 18:08:42');
INSERT INTO notifications VALUES('19057d43-193c-481f-bf0c-5d30ee645abb','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO notifications VALUES('1b43469c-6797-4960-af32-f0b2782c0b4e','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-06 16:40:11','2024-02-06 12:04:06','2024-02-06 16:40:11');
INSERT INTO notifications VALUES('27244df0-c97d-42e8-b36b-617a27525c44','App\\Notifications\\EmployeeTransferNotify','App\\User','2211','{\"data\":\"You have been transferred.Click for details.\",\"link\":\"\\/profile#Employee_transfer\"}','','2024-02-07 13:23:12','2024-02-07 13:23:12');
INSERT INTO notifications VALUES('329e2b56-fdc9-4442-8a9f-20ae51c5c13e','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-06 16:40:11','2024-02-06 09:52:13','2024-02-06 16:40:11');
INSERT INTO notifications VALUES('32e610a5-3772-4b53-86d2-54b3d9ec607f','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-06 16:40:11','2024-02-05 17:53:39','2024-02-06 16:40:11');
INSERT INTO notifications VALUES('34568f83-2e0b-480a-86cb-14b613143e6d','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-06 12:04:06','2024-02-06 12:04:06');
INSERT INTO notifications VALUES('37ae14d3-4bb5-448e-a8c0-cd121e4ca1e5','App\\Notifications\\EmployeeCreatedNotification','App\\User','2029','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO notifications VALUES('3a07e3d8-2a1d-4a11-8a6b-ec8f9800a038','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/public\\/index.php\\/staff\\/employees\"}','2024-02-07 13:23:34','2024-02-07 08:33:46','2024-02-07 13:23:34');
INSERT INTO notifications VALUES('489662e4-e443-4e44-85bc-b89924f044c0','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-23 16:45:45','2024-02-23 16:22:01','2024-02-23 16:45:45');
INSERT INTO notifications VALUES('4e2005e1-8558-4b2d-9bd0-b0722d932500','App\\Notifications\\EmployeeCreatedNotification','App\\User','2029','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/public\\/index.php\\/staff\\/employees\"}','','2024-02-07 08:33:46','2024-02-07 08:33:46');
INSERT INTO notifications VALUES('5c66e5da-2317-4d7c-9607-ce08c2de33e1','App\\Notifications\\EmployeeCreatedNotification','App\\User','2029','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO notifications VALUES('5dd10ccc-8874-4676-aec0-eb67e49b29ac','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-23 14:07:01','2024-02-23 14:07:01');
INSERT INTO notifications VALUES('60f585ef-9044-477b-bf27-2710a85c4b2e','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-05 17:34:04','2024-02-05 16:23:27','2024-02-05 17:34:04');
INSERT INTO notifications VALUES('61b1a204-d810-424e-a7db-04286e1f5a5a','App\\Notifications\\EmployeeCreatedNotification','App\\User','2029','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 17:53:39','2024-02-05 17:53:39');
INSERT INTO notifications VALUES('65605cbb-0ebe-4974-b95f-1e1390a13677','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-06 16:40:11','2024-02-06 11:53:47','2024-02-06 16:40:11');
INSERT INTO notifications VALUES('6ca78b61-d636-424d-a95f-3e3a633fdde0','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-23 15:14:28','2024-02-20 21:02:03','2024-02-23 15:14:28');
INSERT INTO notifications VALUES('6ec0ee92-ed5d-49c0-ac10-9f120e6e0e63','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-23 16:45:45','2024-02-23 16:19:48','2024-02-23 16:45:45');
INSERT INTO notifications VALUES('6ed198d8-9c9a-4800-87db-d24d978af61c','App\\Notifications\\EmployeeCreatedNotification','App\\User','2029','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 16:23:27','2024-02-05 16:23:27');
INSERT INTO notifications VALUES('70be09e8-075f-4ba4-9471-b4e0e27919fb','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-23 19:20:08','2024-02-23 19:19:22','2024-02-23 19:20:08');
INSERT INTO notifications VALUES('73d5cd91-a9ca-4d43-a419-a832db8f101e','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-07 10:07:30','2024-02-07 10:07:30');
INSERT INTO notifications VALUES('774d0f9f-342d-47e3-9516-e9b1bcf56900','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-23 19:19:22','2024-02-23 19:19:22');
INSERT INTO notifications VALUES('7991dd79-703f-45ec-9976-685f617552c9','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 18:15:19','2024-02-05 18:15:19');
INSERT INTO notifications VALUES('7dfea486-73c0-48f7-8a74-0009362f836b','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 16:23:27','2024-02-05 16:23:27');
INSERT INTO notifications VALUES('80b0e98e-9ea5-4afa-adbe-7501b9b52118','App\\Notifications\\EmployeeAwardNotify','App\\User','2041','{\"data\":\"Congratulation! An Award has been given to you\",\"link\":\"\\/profile#Employee_Core_hr\"}','2024-02-06 16:20:13','2024-02-06 16:15:42','2024-02-06 16:20:13');
INSERT INTO notifications VALUES('82281c6b-aa1d-4162-ab93-0b4c97876706','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-06 11:53:47','2024-02-06 11:53:47');
INSERT INTO notifications VALUES('8277c4d0-428b-410f-a6c6-cb69bc217579','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-23 15:14:28','2024-02-23 07:52:33','2024-02-23 15:14:28');
INSERT INTO notifications VALUES('839529e9-4e25-4b4d-9c25-7cb44643b1bf','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-05 16:21:03','2024-02-05 15:59:47','2024-02-05 16:21:03');
INSERT INTO notifications VALUES('879848bf-8a30-41c7-a730-4a980a49df54','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 17:53:39','2024-02-05 17:53:39');
INSERT INTO notifications VALUES('88f5e8f6-8a86-44bf-9e93-bfbcf9689c23','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-07 13:23:34','2024-02-07 10:07:30','2024-02-07 13:23:34');
INSERT INTO notifications VALUES('8d3aef95-d1bc-4b5f-9f11-0e44fd275023','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-23 15:14:28','2024-02-23 14:07:01','2024-02-23 15:14:28');
INSERT INTO notifications VALUES('8f186332-b7d9-4385-8fa0-b3a8be616ee5','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-26 15:30:58','2024-02-26 10:23:09','2024-02-26 15:30:58');
INSERT INTO notifications VALUES('9ba144ae-a6a4-4390-a2be-004cd7c8bfd4','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-23 16:19:48','2024-02-23 16:19:48');
INSERT INTO notifications VALUES('b6021a63-aa4f-4d57-9279-87cfae363316','App\\Notifications\\EmployeeCreatedNotification','App\\User','2029','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-06 11:53:47','2024-02-06 11:53:47');
INSERT INTO notifications VALUES('bb361825-4f3a-4d1b-b7d7-878319d2eb74','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO notifications VALUES('cd04e6c2-eb78-47b5-9c85-f9db76b549a3','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-26 10:23:09','2024-02-26 10:23:09');
INSERT INTO notifications VALUES('cea7b62d-f882-49ca-8c40-a386ca00152c','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-06 16:40:11','2024-02-05 19:16:27','2024-02-06 16:40:11');
INSERT INTO notifications VALUES('d10493e7-7287-4ade-a00e-f35ae756c4db','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-23 16:22:01','2024-02-23 16:22:01');
INSERT INTO notifications VALUES('e558f8bd-5d3e-4525-acd0-7c2934abceb0','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-06 16:40:11','2024-02-05 18:15:19','2024-02-06 16:40:11');
INSERT INTO notifications VALUES('e9de85df-6eb4-4638-a777-fc31a3df4b22','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-26 08:46:54','2024-02-26 08:46:54');
INSERT INTO notifications VALUES('ea5ef902-f7b6-4098-9cb5-3a69d0afa816','App\\Notifications\\EmployeeCreatedNotification','App\\User','2029','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-06 12:04:06','2024-02-06 12:04:06');
INSERT INTO notifications VALUES('ec603728-3078-4250-8173-2ba954a2037c','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-20 21:02:03','2024-02-20 21:02:03');
INSERT INTO notifications VALUES('eed2db28-492d-4f6c-a5c5-cc6a136f0dbe','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/public\\/index.php\\/staff\\/employees\"}','','2024-02-07 08:33:46','2024-02-07 08:33:46');
INSERT INTO notifications VALUES('f337296a-9971-4c49-a45d-33c8d6e4dbbc','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 15:59:47','2024-02-05 15:59:47');
INSERT INTO notifications VALUES('f37309c3-ba43-4304-b901-1d9f27f221d7','App\\Notifications\\EmployeeCreatedNotification','App\\User','1','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','2024-02-06 16:40:11','2024-02-05 18:08:42','2024-02-06 16:40:11');
INSERT INTO notifications VALUES('fcb48d0e-98a3-4bd3-bb68-ea4018c8b920','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-23 07:52:33','2024-02-23 07:52:33');
INSERT INTO notifications VALUES('ff82c0be-2506-4fba-827c-da6cc3a44b74','App\\Notifications\\EmployeeCreatedNotification','App\\User','1991','{\"data\":\"New employee has been created\",\"link\":\"https:\\/\\/hr-timas.rekret.com\\/staff\\/employees\"}','','2024-02-05 18:08:42','2024-02-05 18:08:42');



CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `oauth_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `secret` varchar(100) DEFAULT NULL,
  `provider` varchar(255) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `office_shifts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shift_name` varchar(191) NOT NULL,
  `default_shift` varchar(191) DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `sunday_in` varchar(191) DEFAULT NULL,
  `sunday_out` varchar(191) DEFAULT NULL,
  `saturday_in` varchar(191) DEFAULT NULL,
  `saturday_out` varchar(191) DEFAULT NULL,
  `friday_in` varchar(191) DEFAULT NULL,
  `friday_out` varchar(191) DEFAULT NULL,
  `thursday_in` varchar(191) DEFAULT NULL,
  `thursday_out` varchar(191) DEFAULT NULL,
  `wednesday_in` varchar(191) DEFAULT NULL,
  `wednesday_out` varchar(191) DEFAULT NULL,
  `tuesday_in` varchar(191) DEFAULT NULL,
  `tuesday_out` varchar(191) DEFAULT NULL,
  `monday_in` varchar(191) DEFAULT NULL,
  `monday_out` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `sunday_range_in` varchar(191) NOT NULL,
  `sunday_range_out` varchar(191) NOT NULL,
  `saturday_range_in` varchar(191) NOT NULL,
  `saturday_range_out` varchar(191) NOT NULL,
  `friday_range_in` varchar(191) NOT NULL,
  `friday_range_out` varchar(191) NOT NULL,
  `thursday_range_in` varchar(191) NOT NULL,
  `thursday_range_out` varchar(191) NOT NULL,
  `wednesday_range_in` varchar(191) NOT NULL,
  `wednesday_range_out` varchar(191) NOT NULL,
  `tuesday_range_in` varchar(191) NOT NULL,
  `tuesday_range_out` varchar(191) NOT NULL,
  `monday_range_in` varchar(191) NOT NULL,
  `monday_range_out` varchar(191) NOT NULL,
  `min_work_hour` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `office_shifts_company_id_foreign` (`company_id`),
  CONSTRAINT `office_shifts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO office_shifts VALUES('1','morning shift','','1','','','','','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','2024-02-05 15:55:43','2024-02-05 15:55:43','','','','','','','','','','','','','','','5');
INSERT INTO office_shifts VALUES('2','Morning shift','','2','07:00AM','05:30PM','07:00AM','05:30PM','07:00AM','05:30PM','07:00AM','05:30PM','07:00AM','05:30PM','07:00AM','05:30PM','07:00AM','05:30PM','2024-02-05 18:12:45','2024-02-05 18:12:45','','','','','','','','','','','','','','','5');
INSERT INTO office_shifts VALUES('3','Morning Shift','','3','','','08:00AM','01:00PM','08:00AM','04:00PM','08:00AM','04:00PM','08:00AM','04:00PM','08:00AM','04:00PM','08:00AM','04:00PM','2024-02-20 20:40:12','2024-02-20 20:40:12','','','','','','','','','','','','','','','9');
INSERT INTO office_shifts VALUES('4','Moning shift','','7','','','07:00AM','05:00PM','07:00AM','05:00PM','07:00AM','05:00PM','07:00AM','05:00PM','07:00AM','05:00PM','07:00PM','05:00PM','2024-02-20 20:41:52','2024-02-20 20:41:52','','','','','','','','','','','','','','','9');
INSERT INTO office_shifts VALUES('5','Morning Shift','','9','','','','','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','2024-02-20 20:43:33','2024-02-20 20:43:33','','','','','','','','','','','','','','','9');
INSERT INTO office_shifts VALUES('6','Morning Shift','','8','','','07:00AM','05:00PM','07:00AM','05:00PM','07:00AM','05:00PM','07:00AM','05:00PM','07:00AM','05:00PM','07:00AM','05:00PM','2024-02-20 20:45:17','2024-02-20 20:45:17','','','','','','','','','','','','','','','9');
INSERT INTO office_shifts VALUES('7','Morning Shift','','4','','','','','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','2024-02-20 20:46:38','2024-02-20 20:46:38','','','','','','','','','','','','','','','9');
INSERT INTO office_shifts VALUES('8','Morning Shift','','6','','','','','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','2024-02-20 20:47:43','2024-02-20 20:47:43','','','','','','','','','','','','','','','9');
INSERT INTO office_shifts VALUES('9','Morning Shift','','5','','','','','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','08:00AM','05:00PM','2024-02-20 20:48:58','2024-02-20 20:48:58','','','','','','','','','','','','','','','9');



CREATE TABLE `official_documents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `document_type_id` bigint(20) unsigned DEFAULT NULL,
  `added_by` bigint(20) unsigned DEFAULT NULL,
  `document_title` varchar(191) NOT NULL,
  `identification_number` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  `expiry_date` date NOT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `official_documents_company_id_foreign` (`company_id`),
  KEY `official_documents_document_type_id_foreign` (`document_type_id`),
  KEY `official_documents_added_by_foreign` (`added_by`),
  CONSTRAINT `official_documents_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `official_documents_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `official_documents_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO password_resets VALUES('new@gmail.com','$2y$10$day4AQ4g8sFvMwhMrTxpJuLXZCpVF2IK9kVS.6qZxeR6b7CVt2eGy','2020-10-06 11:22:35');
INSERT INTO password_resets VALUES('yeremia.salmoon@rudolf.co.id','$2y$10$QGA9grIFTz.d6xaMDjoVvOBse85JJYx3et39qvhrvwPDdsgSWERLG','2023-06-05 11:32:57');
INSERT INTO password_resets VALUES('heri.irawan@timas.com ','$2y$10$F5/UezNEc2LZFsPx8sADSeohM4L.NPFuXxpIC8jV1COMv1NP7HAt6','2023-11-29 10:51:33');
INSERT INTO password_resets VALUES('framces@rekret.com','$2y$10$jNelpVZuC3k59vIpL3PyZux7TIS.rS4w2o0Ff7HMmrb54b6g5c91q','2023-11-29 21:16:54');
INSERT INTO password_resets VALUES('dwitami.wulandari@timas.com','$2y$10$JTCkan9tlKLdJpw4aV6UX.wyT3md/w75gLyZVNUG6QULOkOuHBCvK','2024-02-26 10:24:05');



CREATE TABLE `payment_methods` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `method_name` varchar(40) NOT NULL,
  `payment_percentage` varchar(100) DEFAULT NULL,
  `account_number` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_methods_company_id_foreign` (`company_id`),
  CONSTRAINT `payment_methods_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payslips` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payslip_key` char(36) NOT NULL,
  `payslip_number` varchar(191) DEFAULT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `payment_type` varchar(191) NOT NULL,
  `basic_salary` double NOT NULL,
  `net_salary` double NOT NULL,
  `allowances` text NOT NULL,
  `commissions` text NOT NULL,
  `loans` text NOT NULL,
  `deductions` text NOT NULL,
  `overtimes` text NOT NULL,
  `other_payments` text NOT NULL,
  `pension_type` varchar(50) DEFAULT NULL,
  `pension_amount` double NOT NULL,
  `hours_worked` int(11) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `month_year` varchar(15) NOT NULL,
  `pph` text DEFAULT NULL,
  `bpjs_kesehatan` text DEFAULT NULL,
  `bpjs_pensiun` text DEFAULT NULL,
  `bpjs_jht` text DEFAULT NULL,
  `bpjs_jkk` text DEFAULT NULL,
  `bpjs_jkm` text DEFAULT NULL,
  `attendance_cut` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payslips_employee_id_foreign` (`employee_id`),
  CONSTRAINT `payslips_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=329 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES('1','user','web','','');
INSERT INTO permissions VALUES('2','view-user','web','','');
INSERT INTO permissions VALUES('3','edit-user','web','','');
INSERT INTO permissions VALUES('4','delete-user','web','','');
INSERT INTO permissions VALUES('5','last-login-user','web','','');
INSERT INTO permissions VALUES('6','role-access-user','web','','');
INSERT INTO permissions VALUES('7','details-employee','web','','');
INSERT INTO permissions VALUES('8','view-details-employee','web','','');
INSERT INTO permissions VALUES('9','store-details-employee','web','','');
INSERT INTO permissions VALUES('10','modify-details-employee','web','','');
INSERT INTO permissions VALUES('11','customize-setting','web','','');
INSERT INTO permissions VALUES('12','role-access','web','','');
INSERT INTO permissions VALUES('13','general-setting','web','','');
INSERT INTO permissions VALUES('14','view-general-setting','web','','');
INSERT INTO permissions VALUES('15','store-general-setting','web','','');
INSERT INTO permissions VALUES('16','mail-setting','web','','');
INSERT INTO permissions VALUES('17','view-mail-setting','web','','');
INSERT INTO permissions VALUES('18','store-mail-setting','web','','');
INSERT INTO permissions VALUES('19','language-setting','web','','');
INSERT INTO permissions VALUES('20','core_hr','web','','');
INSERT INTO permissions VALUES('21','view-calendar','web','','');
INSERT INTO permissions VALUES('22','promotion','web','','');
INSERT INTO permissions VALUES('23','view-promotion','web','','');
INSERT INTO permissions VALUES('24','store-promotion','web','','');
INSERT INTO permissions VALUES('25','edit-promotion','web','','');
INSERT INTO permissions VALUES('26','delete-promotion','web','','');
INSERT INTO permissions VALUES('27','award','web','','');
INSERT INTO permissions VALUES('28','view-award','web','','');
INSERT INTO permissions VALUES('29','store-award','web','','');
INSERT INTO permissions VALUES('30','edit-award','web','','');
INSERT INTO permissions VALUES('31','delete-award','web','','');
INSERT INTO permissions VALUES('32','transfer','web','','');
INSERT INTO permissions VALUES('33','view-transfer','web','','');
INSERT INTO permissions VALUES('34','store-transfer','web','','');
INSERT INTO permissions VALUES('35','edit-transfer','web','','');
INSERT INTO permissions VALUES('36','delete-transfer','web','','');
INSERT INTO permissions VALUES('37','travel','web','','');
INSERT INTO permissions VALUES('38','view-travel','web','','');
INSERT INTO permissions VALUES('39','store-travel','web','','');
INSERT INTO permissions VALUES('40','edit-travel','web','','');
INSERT INTO permissions VALUES('41','delete-travel','web','','');
INSERT INTO permissions VALUES('42','resignation','web','','');
INSERT INTO permissions VALUES('43','view-resignation','web','','');
INSERT INTO permissions VALUES('44','store-resignation','web','','');
INSERT INTO permissions VALUES('45','edit-resignation','web','','');
INSERT INTO permissions VALUES('46','delete-resignation','web','','');
INSERT INTO permissions VALUES('47','complaint','web','','');
INSERT INTO permissions VALUES('48','view-complaint','web','','');
INSERT INTO permissions VALUES('49','store-complaint','web','','');
INSERT INTO permissions VALUES('50','edit-complaint','web','','');
INSERT INTO permissions VALUES('51','delete-complaint','web','','');
INSERT INTO permissions VALUES('52','warning','web','','');
INSERT INTO permissions VALUES('53','view-warning','web','','');
INSERT INTO permissions VALUES('54','store-warning','web','','');
INSERT INTO permissions VALUES('55','edit-warning','web','','');
INSERT INTO permissions VALUES('56','delete-warning','web','','');
INSERT INTO permissions VALUES('57','termination','web','','');
INSERT INTO permissions VALUES('58','view-termination','web','','');
INSERT INTO permissions VALUES('59','store-termination','web','','');
INSERT INTO permissions VALUES('60','edit-termination','web','','');
INSERT INTO permissions VALUES('61','delete-termination','web','','');
INSERT INTO permissions VALUES('62','timesheet','web','','');
INSERT INTO permissions VALUES('63','attendance','web','','');
INSERT INTO permissions VALUES('64','view-attendance','web','','');
INSERT INTO permissions VALUES('65','edit-attendance','web','','');
INSERT INTO permissions VALUES('66','office_shift','web','','');
INSERT INTO permissions VALUES('67','view-office_shift','web','','');
INSERT INTO permissions VALUES('68','store-office_shift','web','','');
INSERT INTO permissions VALUES('69','edit-office_shift','web','','');
INSERT INTO permissions VALUES('70','delete-office_shift','web','','');
INSERT INTO permissions VALUES('71','holiday','web','','');
INSERT INTO permissions VALUES('72','view-holiday','web','','');
INSERT INTO permissions VALUES('73','store-holiday','web','','');
INSERT INTO permissions VALUES('74','edit-holiday','web','','');
INSERT INTO permissions VALUES('75','delete-holiday','web','','');
INSERT INTO permissions VALUES('76','leave','web','','');
INSERT INTO permissions VALUES('77','view-holiday','web','','');
INSERT INTO permissions VALUES('78','store-holiday','web','','');
INSERT INTO permissions VALUES('79','edit-holiday','web','','');
INSERT INTO permissions VALUES('80','delete-holiday','web','','');
INSERT INTO permissions VALUES('81','payment-module','web','','');
INSERT INTO permissions VALUES('82','view-payslip','web','','');
INSERT INTO permissions VALUES('83','make-payment','web','','');
INSERT INTO permissions VALUES('84','make-bulk_payment','web','','');
INSERT INTO permissions VALUES('85','view-paylist','web','','');
INSERT INTO permissions VALUES('86','set-salary','web','','');
INSERT INTO permissions VALUES('87','hr_report','web','','');
INSERT INTO permissions VALUES('88','report-payslip','web','','');
INSERT INTO permissions VALUES('89','report-attendance','web','','');
INSERT INTO permissions VALUES('90','report-training','web','','');
INSERT INTO permissions VALUES('91','report-project','web','','');
INSERT INTO permissions VALUES('92','report-task','web','','');
INSERT INTO permissions VALUES('93','report-employee','web','','');
INSERT INTO permissions VALUES('94','report-account','web','','');
INSERT INTO permissions VALUES('95','report-deposit','web','','');
INSERT INTO permissions VALUES('96','report-expense','web','','');
INSERT INTO permissions VALUES('97','report-transaction','web','','');
INSERT INTO permissions VALUES('98','recruitment','web','','');
INSERT INTO permissions VALUES('99','job_employer','web','','');
INSERT INTO permissions VALUES('100','view-job_employer','web','','');
INSERT INTO permissions VALUES('101','store-job_employer','web','','');
INSERT INTO permissions VALUES('102','edit-job_employer','web','','');
INSERT INTO permissions VALUES('103','delete-job_employer','web','','');
INSERT INTO permissions VALUES('104','job_post','web','','');
INSERT INTO permissions VALUES('105','view-job_post','web','','');
INSERT INTO permissions VALUES('106','store-job_post','web','','');
INSERT INTO permissions VALUES('107','edit-job_post','web','','');
INSERT INTO permissions VALUES('108','delete-job_post','web','','');
INSERT INTO permissions VALUES('109','job_candidate','web','','');
INSERT INTO permissions VALUES('110','view-job_candidate','web','','');
INSERT INTO permissions VALUES('111','store-job_candidate','web','','');
INSERT INTO permissions VALUES('112','delete-job_candidate','web','','');
INSERT INTO permissions VALUES('113','job_interview','web','','');
INSERT INTO permissions VALUES('114','view-job_interview','web','','');
INSERT INTO permissions VALUES('115','store-job_interview','web','','');
INSERT INTO permissions VALUES('116','delete-job_interview','web','','');
INSERT INTO permissions VALUES('117','project-management','web','','');
INSERT INTO permissions VALUES('118','project','web','','');
INSERT INTO permissions VALUES('119','view-project','web','','');
INSERT INTO permissions VALUES('120','store-project','web','','');
INSERT INTO permissions VALUES('121','edit-project','web','','');
INSERT INTO permissions VALUES('122','delete-project','web','','');
INSERT INTO permissions VALUES('123','task','web','','');
INSERT INTO permissions VALUES('124','view-task','web','','');
INSERT INTO permissions VALUES('125','store-task','web','','');
INSERT INTO permissions VALUES('126','edit-task','web','','');
INSERT INTO permissions VALUES('127','delete-task','web','','');
INSERT INTO permissions VALUES('128','client','web','','');
INSERT INTO permissions VALUES('129','view-client','web','','');
INSERT INTO permissions VALUES('130','store-client','web','','');
INSERT INTO permissions VALUES('131','edit-client','web','','');
INSERT INTO permissions VALUES('132','delete-client','web','','');
INSERT INTO permissions VALUES('133','invoice','web','','');
INSERT INTO permissions VALUES('134','view-invoice','web','','');
INSERT INTO permissions VALUES('135','store-invoice','web','','');
INSERT INTO permissions VALUES('136','edit-invoice','web','','');
INSERT INTO permissions VALUES('137','delete-invoice','web','','');
INSERT INTO permissions VALUES('138','ticket','web','','');
INSERT INTO permissions VALUES('139','view-ticket','web','','');
INSERT INTO permissions VALUES('140','store-ticket','web','','');
INSERT INTO permissions VALUES('141','edit-ticket','web','','');
INSERT INTO permissions VALUES('142','delete-ticket','web','','');
INSERT INTO permissions VALUES('143','import-module','web','','');
INSERT INTO permissions VALUES('144','import-attendance','web','','');
INSERT INTO permissions VALUES('145','import-employee','web','','');
INSERT INTO permissions VALUES('146','file_module','web','','');
INSERT INTO permissions VALUES('147','file_manager','web','','');
INSERT INTO permissions VALUES('148','view-file_manager','web','','');
INSERT INTO permissions VALUES('149','store-file_manager','web','','');
INSERT INTO permissions VALUES('150','edit-file_manager','web','','');
INSERT INTO permissions VALUES('151','delete-file_manager','web','','');
INSERT INTO permissions VALUES('152','view-file_config','web','','');
INSERT INTO permissions VALUES('153','official_document','web','','');
INSERT INTO permissions VALUES('154','view-official_document','web','','');
INSERT INTO permissions VALUES('155','store-official_document','web','','');
INSERT INTO permissions VALUES('156','edit-official_document','web','','');
INSERT INTO permissions VALUES('157','delete-official_document','web','','');
INSERT INTO permissions VALUES('158','event-meeting','web','','');
INSERT INTO permissions VALUES('159','meeting','web','','');
INSERT INTO permissions VALUES('160','view-meeting','web','','');
INSERT INTO permissions VALUES('161','store-meeting','web','','');
INSERT INTO permissions VALUES('162','edit-meeting','web','','');
INSERT INTO permissions VALUES('163','delete-meeting','web','','');
INSERT INTO permissions VALUES('164','event','web','','');
INSERT INTO permissions VALUES('165','view-event','web','','');
INSERT INTO permissions VALUES('166','store-event','web','','');
INSERT INTO permissions VALUES('167','edit-event','web','','');
INSERT INTO permissions VALUES('168','delete-event','web','','');
INSERT INTO permissions VALUES('169','role','web','','');
INSERT INTO permissions VALUES('170','view-role','web','','');
INSERT INTO permissions VALUES('171','store-role','web','','');
INSERT INTO permissions VALUES('172','edit-role','web','','');
INSERT INTO permissions VALUES('173','delete-role','web','','');
INSERT INTO permissions VALUES('174','assign-module','web','','');
INSERT INTO permissions VALUES('175','assign-role','web','','');
INSERT INTO permissions VALUES('176','assign-ticket','web','','');
INSERT INTO permissions VALUES('177','assign-project','web','','');
INSERT INTO permissions VALUES('178','assign-task','web','','');
INSERT INTO permissions VALUES('179','finance','web','','');
INSERT INTO permissions VALUES('180','account','web','','');
INSERT INTO permissions VALUES('181','view-account','web','','');
INSERT INTO permissions VALUES('182','store-account','web','','');
INSERT INTO permissions VALUES('183','edit-account','web','','');
INSERT INTO permissions VALUES('184','delete-account','web','','');
INSERT INTO permissions VALUES('185','view-transaction','web','','');
INSERT INTO permissions VALUES('186','view-balance_transfer','web','','');
INSERT INTO permissions VALUES('187','store-balance_transfer','web','','');
INSERT INTO permissions VALUES('188','expense','web','','');
INSERT INTO permissions VALUES('189','view-expense','web','','');
INSERT INTO permissions VALUES('190','store-expense','web','','');
INSERT INTO permissions VALUES('191','edit-expense','web','','');
INSERT INTO permissions VALUES('192','delete-expense','web','','');
INSERT INTO permissions VALUES('193','deposit','web','','');
INSERT INTO permissions VALUES('194','view-deposit','web','','');
INSERT INTO permissions VALUES('195','store-deposit','web','','');
INSERT INTO permissions VALUES('196','edit-deposit','web','','');
INSERT INTO permissions VALUES('197','delete-deposit','web','','');
INSERT INTO permissions VALUES('198','payer','web','','');
INSERT INTO permissions VALUES('199','view-payer','web','','');
INSERT INTO permissions VALUES('200','store-payer','web','','');
INSERT INTO permissions VALUES('201','edit-payer','web','','');
INSERT INTO permissions VALUES('202','delete-payer','web','','');
INSERT INTO permissions VALUES('203','payee','web','','');
INSERT INTO permissions VALUES('204','view-payee','web','','');
INSERT INTO permissions VALUES('205','store-payee','web','','');
INSERT INTO permissions VALUES('206','edit-payee','web','','');
INSERT INTO permissions VALUES('207','delete-payee','web','','');
INSERT INTO permissions VALUES('208','training_module','web','','');
INSERT INTO permissions VALUES('209','trainer','web','','');
INSERT INTO permissions VALUES('210','view-trainer','web','','');
INSERT INTO permissions VALUES('211','store-trainer','web','','');
INSERT INTO permissions VALUES('212','edit-trainer','web','','');
INSERT INTO permissions VALUES('213','delete-trainer','web','','');
INSERT INTO permissions VALUES('214','training','web','','');
INSERT INTO permissions VALUES('215','view-training','web','','');
INSERT INTO permissions VALUES('216','store-training','web','','');
INSERT INTO permissions VALUES('217','edit-training','web','','');
INSERT INTO permissions VALUES('218','delete-training','web','','');
INSERT INTO permissions VALUES('219','access-module','web','','');
INSERT INTO permissions VALUES('220','access-variable_type','web','','');
INSERT INTO permissions VALUES('221','access-variable_method','web','','');
INSERT INTO permissions VALUES('222','access-language','web','','');
INSERT INTO permissions VALUES('223','announcement','web','','');
INSERT INTO permissions VALUES('224','store-announcement','web','','');
INSERT INTO permissions VALUES('225','edit-announcement','web','','');
INSERT INTO permissions VALUES('226','delete-announcement','web','','');
INSERT INTO permissions VALUES('227','company','web','','');
INSERT INTO permissions VALUES('228','view-company','web','','');
INSERT INTO permissions VALUES('229','store-company','web','','');
INSERT INTO permissions VALUES('230','edit-company','web','','');
INSERT INTO permissions VALUES('231','delete-company','web','','');
INSERT INTO permissions VALUES('232','department','web','','');
INSERT INTO permissions VALUES('233','view-department','web','','');
INSERT INTO permissions VALUES('234','store-department','web','','');
INSERT INTO permissions VALUES('235','edit-department','web','','');
INSERT INTO permissions VALUES('236','delete-department','web','','');
INSERT INTO permissions VALUES('237','designation','web','','');
INSERT INTO permissions VALUES('238','view-designation','web','','');
INSERT INTO permissions VALUES('239','store-designation','web','','');
INSERT INTO permissions VALUES('240','edit-designation','web','','');
INSERT INTO permissions VALUES('241','delete-designation','web','','');
INSERT INTO permissions VALUES('242','location','web','','');
INSERT INTO permissions VALUES('243','view-location','web','','');
INSERT INTO permissions VALUES('244','store-location','web','','');
INSERT INTO permissions VALUES('245','edit-location','web','','');
INSERT INTO permissions VALUES('246','delete-location','web','','');
INSERT INTO permissions VALUES('247','policy','web','','');
INSERT INTO permissions VALUES('248','store-policy','web','','');
INSERT INTO permissions VALUES('249','edit-policy','web','','');
INSERT INTO permissions VALUES('250','delete-policy','web','','');
INSERT INTO permissions VALUES('251','view-cms','web','','');
INSERT INTO permissions VALUES('252','store-cms','web','','');
INSERT INTO permissions VALUES('253','store-user','web','','');
INSERT INTO permissions VALUES('254','delete-attendance','web','','');
INSERT INTO permissions VALUES('255','view-leave','web','','');
INSERT INTO permissions VALUES('256','store-leave','web','','');
INSERT INTO permissions VALUES('257','edit-leave','web','','');
INSERT INTO permissions VALUES('258','delete-leave','web','','');
INSERT INTO permissions VALUES('259','cms','web','','');
INSERT INTO permissions VALUES('260','performance','web','','');
INSERT INTO permissions VALUES('261','goal-type','web','','');
INSERT INTO permissions VALUES('262','view-goal-type','web','','');
INSERT INTO permissions VALUES('263','store-goal-type','web','','');
INSERT INTO permissions VALUES('264','edit-goal-type','web','','');
INSERT INTO permissions VALUES('265','delete-goal-type','web','','');
INSERT INTO permissions VALUES('266','goal-tracking','web','','');
INSERT INTO permissions VALUES('267','view-goal-tracking','web','','');
INSERT INTO permissions VALUES('268','store-goal-tracking','web','','');
INSERT INTO permissions VALUES('269','edit-goal-tracking','web','','');
INSERT INTO permissions VALUES('270','delete-goal-tracking','web','','');
INSERT INTO permissions VALUES('271','indicator','web','','');
INSERT INTO permissions VALUES('272','view-indicator','web','','');
INSERT INTO permissions VALUES('273','store-indicator','web','','');
INSERT INTO permissions VALUES('274','edit-indicator','web','','');
INSERT INTO permissions VALUES('275','delete-indicator','web','','');
INSERT INTO permissions VALUES('276','appraisal','web','','');
INSERT INTO permissions VALUES('277','view-appraisal','web','','');
INSERT INTO permissions VALUES('278','store-appraisal','web','','');
INSERT INTO permissions VALUES('279','edit-appraisal','web','','');
INSERT INTO permissions VALUES('280','delete-appraisal','web','','');
INSERT INTO permissions VALUES('281','assets-and-category','web','','');
INSERT INTO permissions VALUES('282','category','web','','');
INSERT INTO permissions VALUES('283','view-assets-category','web','','');
INSERT INTO permissions VALUES('284','store-assets-category','web','','');
INSERT INTO permissions VALUES('285','edit-assets-category','web','','');
INSERT INTO permissions VALUES('286','delete-assets-category','web','','');
INSERT INTO permissions VALUES('287','assets','web','','');
INSERT INTO permissions VALUES('288','view-assets','web','','');
INSERT INTO permissions VALUES('289','store-assets','web','','');
INSERT INTO permissions VALUES('290','edit-assets','web','','');
INSERT INTO permissions VALUES('291','delete-assets','web','','');
INSERT INTO permissions VALUES('292','daily-attendances','web','','');
INSERT INTO permissions VALUES('293','date-wise-attendances','web','','');
INSERT INTO permissions VALUES('294','monthly-attendances','web','','');
INSERT INTO permissions VALUES('295','set-permission','web','','');
INSERT INTO permissions VALUES('296','get-leave-notification','web','','');
INSERT INTO permissions VALUES('297','report-pension','web','','');
INSERT INTO permissions VALUES('299','view-bpjs-tk','web','2023-02-09 15:15:19','2023-02-09 15:15:19');
INSERT INTO permissions VALUES('300','store-bpjs-tk','web','2023-02-09 15:25:01','2023-02-09 15:25:01');
INSERT INTO permissions VALUES('301','delete-bpjs-tk','web','2023-02-09 15:25:07','2023-02-09 15:25:07');
INSERT INTO permissions VALUES('302','edit-bpjs-tk','web','2023-02-09 15:25:13','2023-02-09 15:25:13');
INSERT INTO permissions VALUES('303','view-bpjs-kes','web','2023-02-09 17:15:16','2023-02-09 17:15:16');
INSERT INTO permissions VALUES('304','store-bpjs-kes','web','2023-02-09 17:15:22','2023-02-09 17:15:22');
INSERT INTO permissions VALUES('305','edit-bpjs-kes','web','2023-02-09 17:15:39','2023-02-09 17:15:39');
INSERT INTO permissions VALUES('306','delete-bpjs-kes','web','2023-02-09 17:15:44','2023-02-09 17:15:44');
INSERT INTO permissions VALUES('307','view-tax','web','2023-02-09 17:31:58','2023-02-09 17:31:58');
INSERT INTO permissions VALUES('308','store-tax','web','2023-02-09 17:32:07','2023-02-09 17:32:07');
INSERT INTO permissions VALUES('310','edit-tax','web','2023-02-09 17:32:25','2023-02-09 17:32:25');
INSERT INTO permissions VALUES('311','delete-tax','web','2023-02-09 17:32:31','2023-02-09 17:32:31');
INSERT INTO permissions VALUES('312','view-ptkp','web','2023-02-09 18:42:02','2023-02-09 18:42:02');
INSERT INTO permissions VALUES('313','store-ptkp','web','2023-02-09 18:42:09','2023-02-09 18:42:09');
INSERT INTO permissions VALUES('314','edit-ptkp','web','2023-02-09 18:42:14','2023-02-09 18:42:14');
INSERT INTO permissions VALUES('315','delete-ptkp','web','2023-02-09 18:42:20','2023-02-09 18:42:20');
INSERT INTO permissions VALUES('316','view-reimbursement','web','','');
INSERT INTO permissions VALUES('317','edit-reimbursement','web','','');
INSERT INTO permissions VALUES('318','store-reimbursement','web','','');
INSERT INTO permissions VALUES('319','delete-reimbursement','web','','');
INSERT INTO permissions VALUES('320','view-mail-receiver','web','','');
INSERT INTO permissions VALUES('321','edit-mail-receiver','web','','');
INSERT INTO permissions VALUES('322','store-mail-receiver','web','','');
INSERT INTO permissions VALUES('323','delete-mail-receiver','web','','');
INSERT INTO permissions VALUES('324','view-log-report-attendance','web','','');
INSERT INTO permissions VALUES('325','view-dashboard','web','','');
INSERT INTO permissions VALUES('326','view-organization','web','','');
INSERT INTO permissions VALUES('327','view-announcement','web','','');
INSERT INTO permissions VALUES('328','view-company-policy','web','','');



CREATE TABLE `policies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `description` longtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `added_by` varchar(40) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `policies_company_id_foreign` (`company_id`),
  KEY `policies_added_by_foreign` (`added_by`),
  CONSTRAINT `policies_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `project_bugs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `title` mediumtext NOT NULL,
  `bug_attachment` varchar(191) DEFAULT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_bugs_user_id_foreign` (`user_id`),
  KEY `project_bugs_project_id_foreign` (`project_id`),
  CONSTRAINT `project_bugs_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `project_bugs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `project_discussions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `project_discussion` mediumtext NOT NULL,
  `discussion_attachment` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_discussions_user_id_foreign` (`user_id`),
  KEY `project_discussions_project_id_foreign` (`project_id`),
  CONSTRAINT `project_discussions_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `project_discussions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `project_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `file_title` varchar(191) NOT NULL,
  `file_attachment` varchar(191) NOT NULL,
  `file_description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_files_user_id_foreign` (`user_id`),
  KEY `project_files_project_id_foreign` (`project_id`),
  CONSTRAINT `project_files_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `project_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `projects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `client_id` bigint(20) unsigned DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `project_priority` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `summary` mediumtext DEFAULT NULL,
  `project_status` varchar(40) NOT NULL DEFAULT 'not started',
  `project_note` longtext DEFAULT NULL,
  `project_progress` varchar(191) DEFAULT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `added_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `projects_client_id_foreign` (`client_id`),
  KEY `projects_company_id_foreign` (`company_id`),
  KEY `projects_added_by_foreign` (`added_by`),
  CONSTRAINT `projects_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `projects_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`) ON DELETE SET NULL,
  CONSTRAINT `projects_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `promotions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `promotion_title` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `promotion_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `promotions_company_id_foreign` (`company_id`),
  KEY `promotions_employee_id_foreign` (`employee_id`),
  CONSTRAINT `promotions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `promotions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `ptkp` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `value` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ptkp_company_id_foreign` (`company_id`),
  CONSTRAINT `ptkp_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO ptkp VALUES('1','1','TK/0','54000000','2024-02-05 16:13:58','2024-02-05 16:13:58');
INSERT INTO ptkp VALUES('2','1','K/0','58500000','2024-02-05 16:14:12','2024-02-05 16:14:12');
INSERT INTO ptkp VALUES('3','1','K/1','63000000','2024-02-05 16:14:51','2024-02-05 16:14:51');
INSERT INTO ptkp VALUES('4','1','K/2','67500000','2024-02-05 16:15:06','2024-02-05 16:15:06');
INSERT INTO ptkp VALUES('5','1','K/3','72000000','2024-02-05 16:15:25','2024-02-05 16:15:25');
INSERT INTO ptkp VALUES('6','2','TK/0','54000000','2024-02-07 08:36:00','2024-02-07 08:36:00');
INSERT INTO ptkp VALUES('7','2','K/0','58500000','2024-02-07 08:36:26','2024-02-07 08:38:34');
INSERT INTO ptkp VALUES('8','2','K/1','63000000','2024-02-07 08:37:15','2024-02-07 08:38:19');
INSERT INTO ptkp VALUES('9','2','K/2','67500000','2024-02-07 08:37:28','2024-02-07 08:40:10');
INSERT INTO ptkp VALUES('10','2','K/3','72000000','2024-02-07 08:39:08','2024-02-07 08:39:59');
INSERT INTO ptkp VALUES('11','3','TK/0','54000000','2024-02-21 09:43:49','2024-02-21 09:43:49');
INSERT INTO ptkp VALUES('12','3','K/0','58500000','2024-02-21 09:44:09','2024-02-21 09:44:09');
INSERT INTO ptkp VALUES('13','3','K/1','63000000','2024-02-21 09:44:24','2024-02-21 09:44:24');
INSERT INTO ptkp VALUES('14','3','K/2','67500000','2024-02-21 09:44:42','2024-02-21 09:44:42');
INSERT INTO ptkp VALUES('15','3','K/3','72000000','2024-02-21 09:45:01','2024-02-21 09:45:01');



CREATE TABLE `qualification_education_levels` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qualification_education_levels_company_id_foreign` (`company_id`),
  CONSTRAINT `qualification_education_levels_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `qualification_languages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qualification_languages_company_id_foreign` (`company_id`),
  CONSTRAINT `qualification_languages_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `qualification_skills` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qualification_skills_company_id_foreign` (`company_id`),
  CONSTRAINT `qualification_skills_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `raw_attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `attendance_date` date NOT NULL,
  `attendance_time` time NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_attendances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `raw_attendances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO raw_attendances VALUES('1','2041','2024-02-05','17:25:00','2024-02-06 16:08:28','2024-02-06 16:08:28');



CREATE TABLE `reimbursement_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `reimbursements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `reimbursement_type_id` bigint(20) unsigned DEFAULT NULL,
  `amount` double NOT NULL,
  `description` varchar(191) NOT NULL,
  `attachment` varchar(191) NOT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reimbursements_reimbursement_type_id_foreign` (`reimbursement_type_id`),
  KEY `reimbursements_employee_id_foreign` (`employee_id`),
  CONSTRAINT `reimbursements_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL,
  CONSTRAINT `reimbursements_reimbursement_type_id_foreign` FOREIGN KEY (`reimbursement_type_id`) REFERENCES `reimbursement_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `report_attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `attendance_date` date NOT NULL,
  `office_shift_id` int(11) DEFAULT 0,
  `work_time` time DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `is_checked` tinyint(1) NOT NULL,
  `is_underwork` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `report_attendances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `report_attendances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `resignations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `notice_date` date DEFAULT NULL,
  `resignation_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `resignations_company_id_foreign` (`company_id`),
  KEY `resignations_department_id_foreign` (`department_id`),
  KEY `resignations_employee_id_foreign` (`employee_id`),
  CONSTRAINT `resignations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resignations_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resignations_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO role_has_permissions VALUES('7','6');
INSERT INTO role_has_permissions VALUES('8','6');
INSERT INTO role_has_permissions VALUES('9','6');
INSERT INTO role_has_permissions VALUES('10','6');
INSERT INTO role_has_permissions VALUES('20','6');
INSERT INTO role_has_permissions VALUES('21','6');
INSERT INTO role_has_permissions VALUES('22','6');
INSERT INTO role_has_permissions VALUES('23','6');
INSERT INTO role_has_permissions VALUES('24','6');
INSERT INTO role_has_permissions VALUES('25','6');
INSERT INTO role_has_permissions VALUES('26','6');
INSERT INTO role_has_permissions VALUES('27','6');
INSERT INTO role_has_permissions VALUES('28','6');
INSERT INTO role_has_permissions VALUES('29','6');
INSERT INTO role_has_permissions VALUES('30','6');
INSERT INTO role_has_permissions VALUES('31','6');
INSERT INTO role_has_permissions VALUES('32','6');
INSERT INTO role_has_permissions VALUES('33','6');
INSERT INTO role_has_permissions VALUES('34','6');
INSERT INTO role_has_permissions VALUES('35','6');
INSERT INTO role_has_permissions VALUES('36','6');
INSERT INTO role_has_permissions VALUES('42','6');
INSERT INTO role_has_permissions VALUES('43','6');
INSERT INTO role_has_permissions VALUES('44','6');
INSERT INTO role_has_permissions VALUES('46','6');
INSERT INTO role_has_permissions VALUES('47','6');
INSERT INTO role_has_permissions VALUES('48','6');
INSERT INTO role_has_permissions VALUES('49','6');
INSERT INTO role_has_permissions VALUES('50','6');
INSERT INTO role_has_permissions VALUES('51','6');
INSERT INTO role_has_permissions VALUES('52','6');
INSERT INTO role_has_permissions VALUES('53','6');
INSERT INTO role_has_permissions VALUES('54','6');
INSERT INTO role_has_permissions VALUES('55','6');
INSERT INTO role_has_permissions VALUES('56','6');
INSERT INTO role_has_permissions VALUES('57','6');
INSERT INTO role_has_permissions VALUES('58','6');
INSERT INTO role_has_permissions VALUES('59','6');
INSERT INTO role_has_permissions VALUES('60','6');
INSERT INTO role_has_permissions VALUES('61','6');
INSERT INTO role_has_permissions VALUES('62','6');
INSERT INTO role_has_permissions VALUES('71','6');
INSERT INTO role_has_permissions VALUES('72','6');
INSERT INTO role_has_permissions VALUES('73','6');
INSERT INTO role_has_permissions VALUES('74','6');
INSERT INTO role_has_permissions VALUES('75','6');
INSERT INTO role_has_permissions VALUES('76','6');
INSERT INTO role_has_permissions VALUES('98','6');
INSERT INTO role_has_permissions VALUES('104','6');
INSERT INTO role_has_permissions VALUES('105','6');
INSERT INTO role_has_permissions VALUES('106','6');
INSERT INTO role_has_permissions VALUES('107','6');
INSERT INTO role_has_permissions VALUES('108','6');
INSERT INTO role_has_permissions VALUES('109','6');
INSERT INTO role_has_permissions VALUES('110','6');
INSERT INTO role_has_permissions VALUES('112','6');
INSERT INTO role_has_permissions VALUES('113','6');
INSERT INTO role_has_permissions VALUES('114','6');
INSERT INTO role_has_permissions VALUES('115','6');
INSERT INTO role_has_permissions VALUES('116','6');
INSERT INTO role_has_permissions VALUES('145','6');
INSERT INTO role_has_permissions VALUES('223','6');
INSERT INTO role_has_permissions VALUES('224','6');
INSERT INTO role_has_permissions VALUES('225','6');
INSERT INTO role_has_permissions VALUES('226','6');
INSERT INTO role_has_permissions VALUES('227','6');
INSERT INTO role_has_permissions VALUES('228','6');
INSERT INTO role_has_permissions VALUES('229','6');
INSERT INTO role_has_permissions VALUES('230','6');
INSERT INTO role_has_permissions VALUES('231','6');
INSERT INTO role_has_permissions VALUES('232','6');
INSERT INTO role_has_permissions VALUES('233','6');
INSERT INTO role_has_permissions VALUES('234','6');
INSERT INTO role_has_permissions VALUES('235','6');
INSERT INTO role_has_permissions VALUES('236','6');
INSERT INTO role_has_permissions VALUES('237','6');
INSERT INTO role_has_permissions VALUES('238','6');
INSERT INTO role_has_permissions VALUES('239','6');
INSERT INTO role_has_permissions VALUES('240','6');
INSERT INTO role_has_permissions VALUES('241','6');
INSERT INTO role_has_permissions VALUES('242','6');
INSERT INTO role_has_permissions VALUES('243','6');
INSERT INTO role_has_permissions VALUES('244','6');
INSERT INTO role_has_permissions VALUES('245','6');
INSERT INTO role_has_permissions VALUES('246','6');
INSERT INTO role_has_permissions VALUES('247','6');
INSERT INTO role_has_permissions VALUES('248','6');
INSERT INTO role_has_permissions VALUES('249','6');
INSERT INTO role_has_permissions VALUES('250','6');
INSERT INTO role_has_permissions VALUES('255','6');
INSERT INTO role_has_permissions VALUES('256','6');
INSERT INTO role_has_permissions VALUES('257','6');
INSERT INTO role_has_permissions VALUES('258','6');
INSERT INTO role_has_permissions VALUES('296','6');



CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `is_payroll` tinyint(1) NOT NULL,
  `is_ceo` tinyint(1) NOT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES('1','admin','web','Can access and change everything','1','1','1','','');
INSERT INTO roles VALUES('2','employee','web','Default access','0','0','1','2020-07-26 20:50:45','2020-07-26 20:50:45');
INSERT INTO roles VALUES('3','client','web','When you create a client, this role and associated.','0','0','1','2020-10-08 10:10:23','2020-10-08 10:10:23');
INSERT INTO roles VALUES('4','Manager','web','Can Manage','0','0','1','2021-02-24 17:24:58','2021-02-24 17:24:58');
INSERT INTO roles VALUES('6','HR','web','Manage Employee','0','0','1','2021-09-05 10:12:28','2023-02-16 11:50:27');



CREATE TABLE `salary_allowances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(191) NOT NULL,
  `first_date` date DEFAULT NULL,
  `allowance_title` varchar(191) NOT NULL,
  `allowance_amount` varchar(191) NOT NULL,
  `is_taxable` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_allowances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_allowances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `salary_basics` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(191) NOT NULL,
  `first_date` date DEFAULT NULL,
  `payslip_type` varchar(191) NOT NULL,
  `basic_salary` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_basics_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_basics_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=190 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO salary_basics VALUES('1','2030','5000000','','Monthly','3500000','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO salary_basics VALUES('2','2031','5000000','','Monthly','3500000','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO salary_basics VALUES('3','2032','5000000','','Monthly','3500000','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO salary_basics VALUES('4','2033','5000000','','Monthly','3500000','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO salary_basics VALUES('5','2034','5000000','','Monthly','3500000','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO salary_basics VALUES('6','2035','5000000','','Monthly','3500000','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO salary_basics VALUES('7','2036','5000000','','Monthly','3500000','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO salary_basics VALUES('8','2037','5000000','','Monthly','3500000','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO salary_basics VALUES('9','2038','5000000','','Monthly','3500000','2024-02-05 16:23:26','2024-02-05 16:23:26');
INSERT INTO salary_basics VALUES('10','2039','5000000','','Monthly','3500000','2024-02-05 16:23:27','2024-02-05 16:23:27');
INSERT INTO salary_basics VALUES('11','2032','February-2024','2024-02-01','Monthly','5000000','2024-02-05 18:31:50','2024-02-05 18:31:50');
INSERT INTO salary_basics VALUES('12','2043','5000000','','Monthly','3500000','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO salary_basics VALUES('13','2044','5000000','','Monthly','3500000','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO salary_basics VALUES('14','2045','5000000','','Monthly','3500000','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO salary_basics VALUES('15','2046','5000000','','Monthly','3500000','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO salary_basics VALUES('16','2047','5000000','','Monthly','3500000','2024-02-05 19:16:27','2024-02-05 19:16:27');
INSERT INTO salary_basics VALUES('17','2048','January-2023','','Monthly','5000000','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO salary_basics VALUES('18','2049','January-2023','','Monthly','5000000','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO salary_basics VALUES('19','2050','January-2023','2023-01-01','Monthly','10000000','2024-02-06 09:52:01','2024-02-06 13:39:31');
INSERT INTO salary_basics VALUES('20','2051','January-2023','','Monthly','5000000','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO salary_basics VALUES('21','2052','January-2023','','Monthly','5000000','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO salary_basics VALUES('22','2053','January-2023','','Monthly','5000000','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO salary_basics VALUES('23','2054','January-2023','','Monthly','5000000','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO salary_basics VALUES('24','2055','January-2023','','Monthly','5000000','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO salary_basics VALUES('25','2056','January-2023','','Monthly','5000000','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO salary_basics VALUES('26','2057','January-2023','','Monthly','5000000','2024-02-06 09:52:01','2024-02-06 09:52:01');
INSERT INTO salary_basics VALUES('27','2058','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('28','2059','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('29','2060','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('30','2061','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('31','2062','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('32','2063','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('33','2064','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('34','2065','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('35','2066','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('36','2067','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('37','2068','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('38','2069','January-2023','','Monthly','5000000','2024-02-06 09:52:02','2024-02-06 09:52:02');
INSERT INTO salary_basics VALUES('39','2070','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('40','2071','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('41','2072','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('42','2073','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('43','2074','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('44','2075','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('45','2076','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('46','2077','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('47','2078','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('48','2079','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('49','2080','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('50','2081','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('51','2082','January-2023','','Monthly','5000000','2024-02-06 09:52:03','2024-02-06 09:52:03');
INSERT INTO salary_basics VALUES('52','2083','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('53','2084','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('54','2085','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('55','2086','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('56','2087','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('57','2088','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('58','2089','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('59','2090','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('60','2091','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('61','2092','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('62','2093','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('63','2094','January-2023','','Monthly','5000000','2024-02-06 09:52:04','2024-02-06 09:52:04');
INSERT INTO salary_basics VALUES('64','2095','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('65','2096','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('66','2097','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('67','2098','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('68','2099','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('69','2100','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('70','2101','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('71','2102','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('72','2103','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('73','2104','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('74','2105','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('75','2106','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('76','2107','January-2023','','Monthly','5000000','2024-02-06 09:52:05','2024-02-06 09:52:05');
INSERT INTO salary_basics VALUES('77','2108','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('78','2109','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('79','2110','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('80','2111','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('81','2112','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('82','2113','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('83','2114','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('84','2115','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('85','2116','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('86','2117','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('87','2118','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('88','2119','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('89','2120','January-2023','','Monthly','5000000','2024-02-06 09:52:06','2024-02-06 09:52:06');
INSERT INTO salary_basics VALUES('90','2121','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('91','2122','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('92','2123','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('93','2124','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('94','2125','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('95','2126','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('96','2127','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('97','2128','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('98','2129','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('99','2130','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('100','2131','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('101','2132','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('102','2133','January-2023','','Monthly','5000000','2024-02-06 09:52:07','2024-02-06 09:52:07');
INSERT INTO salary_basics VALUES('103','2134','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('104','2135','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('105','2136','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('106','2137','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('107','2138','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('108','2139','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('109','2140','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('110','2141','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('111','2142','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('112','2143','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('113','2144','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('114','2145','January-2023','','Monthly','5000000','2024-02-06 09:52:08','2024-02-06 09:52:08');
INSERT INTO salary_basics VALUES('115','2146','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('116','2147','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('117','2148','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('118','2149','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('119','2150','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('120','2151','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('121','2152','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('122','2153','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('123','2154','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('124','2155','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('125','2156','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('126','2157','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('127','2158','January-2023','','Monthly','5000000','2024-02-06 09:52:09','2024-02-06 09:52:09');
INSERT INTO salary_basics VALUES('128','2159','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('129','2160','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('130','2161','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('131','2162','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('132','2163','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('133','2164','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('134','2165','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('135','2166','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('136','2167','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('137','2168','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('138','2169','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('139','2170','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('140','2171','January-2023','','Monthly','5000000','2024-02-06 09:52:10','2024-02-06 09:52:10');
INSERT INTO salary_basics VALUES('141','2172','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('142','2173','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('143','2174','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('144','2175','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('145','2176','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('146','2177','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('147','2178','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('148','2179','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('149','2180','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('150','2181','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('151','2182','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('152','2183','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('153','2184','January-2023','','Monthly','5000000','2024-02-06 09:52:11','2024-02-06 09:52:11');
INSERT INTO salary_basics VALUES('154','2185','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('155','2186','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('156','2187','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('157','2188','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('158','2189','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('159','2190','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('160','2191','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('161','2192','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('162','2193','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('163','2194','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('164','2195','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('165','2196','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('166','2197','January-2023','','Monthly','5000000','2024-02-06 09:52:12','2024-02-06 09:52:12');
INSERT INTO salary_basics VALUES('167','2198','January-2023','','Monthly','5000000','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO salary_basics VALUES('168','2199','January-2023','','Monthly','5000000','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO salary_basics VALUES('169','2200','January-2023','','Monthly','5000000','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO salary_basics VALUES('170','2201','January-2023','','Monthly','5000000','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO salary_basics VALUES('171','2202','January-2023','','Monthly','5000000','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO salary_basics VALUES('172','2203','January-2023','','Monthly','5000000','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO salary_basics VALUES('173','2204','January-2023','','Monthly','5000000','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO salary_basics VALUES('174','2205','January-2023','','Monthly','5000000','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO salary_basics VALUES('175','2206','January-2023','','Monthly','5000000','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO salary_basics VALUES('176','2207','January-2023','','Monthly','5000000','2024-02-06 09:52:13','2024-02-06 09:52:13');
INSERT INTO salary_basics VALUES('177','2215','January-2023','','Monthly','2000','2024-02-23 07:52:33','2024-02-23 07:52:33');
INSERT INTO salary_basics VALUES('185','2226','January-2023','','Monthly','5000000','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO salary_basics VALUES('186','2227','January-2023','','Monthly','5000000','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO salary_basics VALUES('187','2228','January-2023','','Monthly','5000000','2024-02-26 08:46:53','2024-02-26 08:46:53');
INSERT INTO salary_basics VALUES('188','2229','January-2023','','Monthly','5000000','2024-02-26 08:46:54','2024-02-26 08:46:54');
INSERT INTO salary_basics VALUES('189','2230','January-2023','','Monthly','5000000','2024-02-26 08:46:54','2024-02-26 08:46:54');



CREATE TABLE `salary_commissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(191) NOT NULL,
  `commission_title` varchar(191) NOT NULL,
  `first_date` date DEFAULT NULL,
  `commission_amount` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_commissions_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_commissions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `salary_deductions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(50) NOT NULL,
  `first_date` date DEFAULT NULL,
  `deduction_title` varchar(191) NOT NULL,
  `deduction_amount` varchar(191) NOT NULL,
  `deduction_type` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_deductions_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_deductions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `salary_loans` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(50) NOT NULL,
  `first_date` date DEFAULT NULL,
  `loan_title` varchar(191) NOT NULL,
  `loan_amount` varchar(191) NOT NULL,
  `loan_type` varchar(191) NOT NULL,
  `loan_time` varchar(191) NOT NULL,
  `amount_remaining` varchar(191) NOT NULL,
  `time_remaining` varchar(191) NOT NULL,
  `monthly_payable` varchar(50) NOT NULL,
  `reason` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_loans_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_loans_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `salary_other_payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(50) NOT NULL DEFAULT '',
  `first_date` date DEFAULT NULL,
  `other_payment_title` varchar(191) NOT NULL,
  `other_payment_amount` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_other_payments_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_other_payments_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO salary_other_payments VALUES('1','2050','February-2024','2024-02-01','SHUTDOWN','1000000','2024-02-06 13:20:11','2024-02-06 13:20:11');
INSERT INTO salary_other_payments VALUES('2','2050','February-2024','2024-02-01','RAPELAN GAJI','500000','2024-02-06 13:20:32','2024-02-06 13:20:32');



CREATE TABLE `salary_overtimes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(50) NOT NULL,
  `first_date` date DEFAULT NULL,
  `overtime_title` varchar(191) NOT NULL,
  `no_of_days` varchar(191) NOT NULL,
  `overtime_hours` varchar(191) NOT NULL,
  `overtime_rate` varchar(191) NOT NULL,
  `overtime_amount` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_overtimes_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_overtimes_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `statuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO statuses VALUES('1','full-time','2024-02-05 16:23:04','2024-02-05 16:23:04');



CREATE TABLE `support_tickets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `ticket_code` varchar(15) NOT NULL,
  `subject` varchar(191) NOT NULL,
  `ticket_priority` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `ticket_remarks` mediumtext DEFAULT NULL,
  `ticket_status` varchar(40) NOT NULL,
  `ticket_note` varchar(191) DEFAULT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `ticket_attachment` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `support_tickets_ticket_code_unique` (`ticket_code`),
  KEY `support_tickets_company_id_foreign` (`company_id`),
  KEY `support_tickets_department_id_foreign` (`department_id`),
  KEY `support_tickets_employee_id_foreign` (`employee_id`),
  CONSTRAINT `support_tickets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `support_tickets_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL,
  CONSTRAINT `support_tickets_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `task_discussions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `task_discussion` mediumtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_discussions_user_id_foreign` (`user_id`),
  KEY `task_discussions_task_id_foreign` (`task_id`),
  CONSTRAINT `task_discussions_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `task_discussions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `task_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `file_title` varchar(191) NOT NULL,
  `file_attachment` varchar(191) NOT NULL,
  `file_description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_files_user_id_foreign` (`user_id`),
  KEY `task_files_task_id_foreign` (`task_id`),
  CONSTRAINT `task_files_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `task_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `tasks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task_name` varchar(191) NOT NULL,
  `project_id` bigint(20) unsigned NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `task_hour` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `task_status` varchar(40) NOT NULL DEFAULT 'not started',
  `task_note` mediumtext DEFAULT NULL,
  `task_progress` varchar(191) DEFAULT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `added_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tasks_project_id_foreign` (`project_id`),
  KEY `tasks_company_id_foreign` (`company_id`),
  KEY `tasks_added_by_foreign` (`added_by`),
  CONSTRAINT `tasks_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `tax_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `rate` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `taxes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `min_salary` double NOT NULL,
  `max_salary` double NOT NULL,
  `percentage` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `taxes_company_id_foreign` (`company_id`),
  CONSTRAINT `taxes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO taxes VALUES('1','1','5000000','500000000','3.00','2024-02-06 13:30:50','2024-02-06 13:30:50');



CREATE TABLE `termination_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `termination_title` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `terminations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `terminated_employee` bigint(20) unsigned NOT NULL,
  `termination_type` bigint(20) unsigned DEFAULT NULL,
  `termination_date` date NOT NULL,
  `notice_date` date NOT NULL,
  `status` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `terminations_company_id_foreign` (`company_id`),
  KEY `terminations_terminated_employee_foreign` (`terminated_employee`),
  KEY `terminations_termination_type_foreign` (`termination_type`),
  CONSTRAINT `terminations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `terminations_terminated_employee_foreign` FOREIGN KEY (`terminated_employee`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `terminations_termination_type_foreign` FOREIGN KEY (`termination_type`) REFERENCES `termination_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `ticket_comments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ticket_comments` mediumtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_comments_ticket_id_foreign` (`ticket_id`),
  KEY `ticket_comments_user_id_foreign` (`user_id`),
  CONSTRAINT `ticket_comments_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ticket_comments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `trainers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) NOT NULL,
  `last_name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `contact_no` varchar(15) NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `address` mediumtext DEFAULT NULL,
  `expertise` mediumtext NOT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `trainers_company_id_foreign` (`company_id`),
  CONSTRAINT `trainers_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `training_lists` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `training_cost` varchar(191) NOT NULL,
  `status` varchar(30) NOT NULL,
  `remarks` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `trainer_id` bigint(20) unsigned DEFAULT NULL,
  `training_type_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `training_lists_company_id_foreign` (`company_id`),
  KEY `training_lists_trainer_id_foreign` (`trainer_id`),
  KEY `training_lists_training_type_id_foreign` (`training_type_id`),
  CONSTRAINT `training_lists_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `training_lists_trainer_id_foreign` FOREIGN KEY (`trainer_id`) REFERENCES `trainers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `training_lists_training_type_id_foreign` FOREIGN KEY (`training_type_id`) REFERENCES `training_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `training_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `transfers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `from_department_id` bigint(20) unsigned DEFAULT NULL,
  `to_department_id` bigint(20) unsigned DEFAULT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `transfer_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfers_company_id_foreign` (`company_id`),
  KEY `transfers_from_department_id_foreign` (`from_department_id`),
  KEY `transfers_to_department_id_foreign` (`to_department_id`),
  KEY `transfers_employee_id_foreign` (`employee_id`),
  CONSTRAINT `transfers_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transfers_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transfers_from_department_id_foreign` FOREIGN KEY (`from_department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transfers_to_department_id_foreign` FOREIGN KEY (`to_department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO transfers VALUES('1','Promosi menjadi general manager','2','17','46','2211','2024-02-12','2024-02-07 13:23:12','2024-02-07 13:23:12');



CREATE TABLE `travel_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `arrangement_type` varchar(191) NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `travel_types_company_id_foreign` (`company_id`),
  CONSTRAINT `travel_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO travel_types VALUES('1','Metode apa ?','','2024-02-07 08:11:31','2024-02-07 08:11:31');



CREATE TABLE `travels` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `travel_type` bigint(20) unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `purpose_of_visit` varchar(191) DEFAULT NULL,
  `place_of_visit` varchar(191) DEFAULT NULL,
  `expected_budget` varchar(20) DEFAULT NULL,
  `actual_budget` varchar(20) DEFAULT NULL,
  `travel_mode` varchar(20) NOT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `travels_company_id_foreign` (`company_id`),
  KEY `travels_employee_id_foreign` (`employee_id`),
  KEY `travels_travel_type_foreign` (`travel_type`),
  CONSTRAINT `travels_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `travels_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `travels_travel_type_foreign` FOREIGN KEY (`travel_type`) REFERENCES `travel_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO travels VALUES('1','Membahasa hal hal yang sangat tidak normal demi keberlangsungan berbangsa dan bernegeara.','2','2211','1','2024-02-05','2024-02-07','Kunjungan anomali','Head Office','7000000','5500000','By Plane','approved','2024-02-07 13:15:22','2024-02-07 13:15:22');



CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `username` varchar(64) NOT NULL,
  `email` varchar(64) DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(191) NOT NULL,
  `profile_photo` varchar(191) DEFAULT NULL,
  `profile_bg` varchar(191) DEFAULT NULL,
  `role_users_id` bigint(20) unsigned NOT NULL,
  `company_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `contact_no` varchar(15) DEFAULT NULL,
  `last_login_ip` varchar(32) DEFAULT NULL,
  `last_login_date` timestamp(2) NULL DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `users_role_users_id_foreign` (`role_users_id`),
  CONSTRAINT `users_role_users_id_foreign` FOREIGN KEY (`role_users_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2232 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO users VALUES('1','Super','Authority','timas_suplindo','superadmin@gmail.com','','$2y$10$D12jIhNBhyT3D/SmCfAcg.tNmgaYyhAvtVU2WHJxXNqUE3A2GG1Jm','admin_1707284230.jpg','','1','','1','1234','103.113.77.126','2024-02-26 15:30:42.00','Gox06425CLCzzAXSZpX53m4FXrwKZ101qQ5VscmfRhDadrw1cFTomXlowDH0','','2024-02-07 12:38:44','');
INSERT INTO users VALUES('9','Darma','Lin','darma','darmalin@rekret.com','','$2y$10$22XUN.vnJaJseVeOuCJECuFRQHdAampab4B9HePA4e.WdV2ScN1Bi','staff_1616582111.jpg','','6','','1','387292822','127.0.0.1','2023-02-28 19:03:58.00','','2020-07-27 02:51:54','2023-06-14 22:44:54','');
INSERT INTO users VALUES('11','Fram','Ces1','framces','framces@rekret.com','','$2y$10$nJ0kVYLeinYgFPl/e0Xx3uJz3nNINCiaYMvN9YKQiZwUrFUEd1lB6','','','4','','1','67278232','103.113.77.126','2024-02-06 11:33:52.00','','2020-07-27 03:03:25','2023-07-04 12:32:31','');
INSERT INTO users VALUES('51','Admin','Admin','admin','admin@gmail.com','','$2y$10$D12jIhNBhyT3D/SmCfAcg.tNmgaYyhAvtVU2WHJxXNqUE3A2GG1Jm','gosofunab_1648442766.jpg','','1','','1','1211334234','182.253.56.96','2024-02-25 13:33:58.00','','2022-03-28 11:46:07','2023-06-20 10:17:11','');
INSERT INTO users VALUES('300','','','AA00153','nita.cynthia@timas.com','','$2y$10$0nT8caoJYpQA9D.FYBQZpe1oKcB6HGFoV/hYlQxBK0yFdfGOM.1hW','','','2','','1','087884247982','','','','2023-08-17 23:08:11','2023-08-17 23:08:11','');
INSERT INTO users VALUES('301','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$847RQzE0eHRj5gNjmEg4Le1OChNBBB5u0g7KiU8byiCJ7VS7STmrK','','','2','','1','085945207276','','','','2023-08-17 23:08:11','2023-08-17 23:08:11','');
INSERT INTO users VALUES('302','','','AA00155','mahfudin.nur@timas.com','','$2y$10$0lF0IDAEIfvyDYyhl6wzNuCzV.xJru3UvcxAqWX21dYyfqliMvszi','','','2','','1','0817382906','','','','2023-08-17 23:08:11','2023-08-17 23:08:11','');
INSERT INTO users VALUES('307','','','AF0008','adi.yulianto@timas.com','','$2y$10$p.pTa1yXUdX95QbZk3oRbOFFz467KVXmFUq6FA/yG8r75Zb2.fNUe','','','2','','1','081217657221','','','','2023-08-17 23:08:12','2023-08-17 23:08:12','');
INSERT INTO users VALUES('308','','','AF0009','dany.sitompul@timas.com','','$2y$10$wvI0N/1cHRMdv9Q.49FcOumfmqZQLNYznmuG/EEYtZEofll0I4Af6','','','2','','1','082137543713','','','','2023-08-17 23:08:12','2023-08-17 23:08:12','');
INSERT INTO users VALUES('324','','','AA00152','adi.sutardi@timas.com','','$2y$10$BrKnrmp7GCNOMT2WKbIliOZmn2kXt358ZqdpKqh2Y0.p2G/7x/hre','','','2','','1','087827757751','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('325','','','AA00153','nita.cynthia@timas.com','','$2y$10$CbcDe2sb2wKCXTkCnJmn/.Bav1F0SHXo4MgzKuQiDYLStoZSHw.ny','','','2','','1','087884247982','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('326','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$0pnnFV/LhoflaKFKMhGVUe8LcpTLnZt1ok.KLopXs0ONRyTk8OICu','','','2','','1','085945207276','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('327','','','AA00155','mahfudin.nur@timas.com','','$2y$10$EFdbtdBhU8/NajfqkQhYOO/1ag4xvUgRCITKUWtPtiNjlIePeKxWO','','','2','','1','0817382906','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('328','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$70EKdwQssTbDliRbUuU8YO7ctf04/G3QHu04/olt1ND9chR8IpwTm','','','2','','1','081380806655','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('329','','','AF0005','wahyudin@timas.com ','','$2y$10$8ugQlG7yJ2WRv4QtHt8WHu5.xy.OQG3smYl4AnsyJX2adQjf2nLhK','','','2','','1','081364934014','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('330','','','AF0006','jimmer@timas.com','','$2y$10$ABs4Ay2VUyBZyq2dQPPqKeGk33IXAkEZB.vvoP199dbjP9ath1wQe','','','2','','1','081231047970','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('331','','','AF0007','aulia.gandi@timas.com ','','$2y$10$lhqcwlslhMbZRTPxAi9qnezxBr0AzzSBykTqIPg0UXhe16DBpQFce','','','2','','1','081354168025','','','','2023-08-17 23:10:12','2023-08-17 23:10:12','');
INSERT INTO users VALUES('332','','','AF0008','adi.yulianto@timas.com','','$2y$10$1bZMeCSlHg.RAZHXHIULsefnc6YogKzcgByJaRCw.seMJtur3gRi.','','','2','','1','081217657221','','','','2023-08-17 23:10:12','2023-08-17 23:10:12','');
INSERT INTO users VALUES('333','','','AF0009','dany.sitompul@timas.com','','$2y$10$W8tbvIGvShWpRZsrf0m03.3ZgAMNz9APcn8AGASZd3ZhVyR/11veG','','','2','','1','082137543713','','','','2023-08-17 23:10:12','2023-08-17 23:10:12','');
INSERT INTO users VALUES('334','','','AE03029','asd@gmail.com','','$2y$10$rTRgMxlFl01It48Lh99odeDixMX1Bvw/qIUJorDba2gTZ1l3A7E5K','','','2','','1','082280107578','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('335','','','AE00779','asd1@gmail.com','','$2y$10$rvH9RPEdlw1ek.wsYkuCle6IfG.Cax3ZY9leeZ7fVvG/2JxgZfSpW','','','2','','1','085363049624','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('336','','','AE02752','asd2@gmail.com','','$2y$10$zINWouInl/RC2p0JvhkwKupmrn1ssevpdRhvzL/jMF8zElb0jSTPm','','','2','','1','0','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('337','','','AE02769','asd3@gmail.com','','$2y$10$I21gMtRf9tdTJ8yp.qtsbOwBvJIOdeRZAkTU2TS7BhhxrJqsATDXS','','','2','','1','081272221353','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('338','','','AE02566','asd4@gmail.com','','$2y$10$C8YjevtJJ8OOJO36P27V1eTqj2OgvReVJi/szhrOnhcVZdFlmHQbu','','','2','','1','085349913025','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('339','','','AD00006','asd5@gmail.com','','$2y$10$bo7QQhL3YUuYfSesIYhVdu6PVnLZRipHMH2nyTAMWN2Kul8zG8Wta','','','2','','1','081296091501','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('340','','','AD00007','asd6@gmail.com','','$2y$10$uQlPcqvkF6T2Ryt6pq6fturf9fNXkmxhUihP2Qu/2nydXIPErkgtq','','','2','','1','081365253854','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('341','','','AD00008','asd7@gmail.com','','$2y$10$Snj83R8SlbMzn6JrPqOqeufCcd1yyX2FfVRq..YjH8AX5jQQXaV22','','','2','','1','082174107553','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('342','','','AD00030','asd8@gmail.com','','$2y$10$lNiuk7HCWGCstMW.T3sTnuuyqSGEv1rZ.DasLzIStryyvxpv2OIKq','','','2','','1','082169158099','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('343','','','AD00031','asd9@gmail.com','','$2y$10$rGh2PMntQkKzh5/pmctRauLd47p8Aognz.sq019CqSy4.y2jIJ6wC','','','2','','1','\'085271515545','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('344','','','AB00003','heri.irawan@timas.com ','','$2y$10$K6MSrF82HjoWn0QEhlWrz.JSzab8Z2hBzdhzzz5Wp1WFCj5J28y.u','','','2','','1','081385768634','103.113.77.126','2023-12-18 11:22:15.00','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('345','','','AB00007','franhidayat994@gmail.com','','$2y$10$4yDJGjuqTu68nzW3rifihOUVYfC/eCkRlc.XFsoE64utP3o7m1/la','','','2','','1','085959187871','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('346','','','AB00008','yenitazby@gmail.com','','$2y$10$h5iy9hTCab6jyJP/UloCieYoBFLzqId10VWLT1vchWAKp4RmC5OyK','','','2','','1','082117981448','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('347','','','AB00009','Sarwat aja43@gmail,com','','$2y$10$BTgHfI4r3JweShrijFMujOpzmxeEv7tbRolJto9lkhGuR/4AzoFm.','','','2','','1','082312953978','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('348','','','AB00010','indrawati101069@gmail.com','','$2y$10$PeI6SKW8QfmqCf6VPYH/e.c8EMlgbIzrk94fCTnnQ4TiUcCkGGPVK','','','2','','1','0895803204677','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('349','','','AA00152','adi.sutardi@timas.com','','$2y$10$vfUmUk1pqyqG6/Sr9Y4vSOrGfFKJR8T000ycVrHhRxgVtYQ0XTWLi','','','2','','1','087827757751','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('350','','','AA00153','nita.cynthia@timas.com','','$2y$10$Ngej44V.qNSzz/aOPOWbmeuBDLek5JdbzVhjkCLr3J3Yo3wAVfuYq','','','2','','1','087884247982','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('351','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$9Bf09IGwcLBnZJeWFOGkI.Y0XsNK2lbhP9kmbhLRvqA0NXevWy9TO','','','2','','1','085945207276','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('352','','','AA00155','mahfudin.nur@timas.com','','$2y$10$Za5pq2Lny35HsaKElipdmuV.KT9aUdx0dCeZSYvy84/N7qdH8.kd.','','','2','','1','0817382906','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('353','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$hqWbrGMe6ageu9xzP0Pd0.NHkLmk7Gi4pEB5IlHxeZBswjYno/RJ.','','','2','','1','081380806655','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('354','','','AF0005','wahyudin@timas.com ','','$2y$10$mrYl6lqmgV2WtMxX9gaPFuavAaagCaeud9Lgs1wBkCDPSepvHRd.6','','','2','','1','081364934014','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('355','','','AF0006','jimmer@timas.com','','$2y$10$Srwp6UTx3ncVwhrZs61fGuz/vlWq9rjTox3sLT67g2syyv5EkKdLO','','','2','','1','081231047970','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('356','','','AF0007','aulia.gandi@timas.com ','','$2y$10$2tx5Vy9eRjodzdh1cw8XsO4MQraQq5WCPgErG9tT9yHA7fx14uC.i','','','2','','1','081354168025','','','','2023-08-17 23:12:07','2023-08-17 23:12:07','');
INSERT INTO users VALUES('357','','','AF0008','adi.yulianto@timas.com','','$2y$10$vFd3r02qrVOyXSZgohACbeGVkXivCQOvk5SZr/.NeWkADgMB35M2W','','','2','','1','081217657221','','','','2023-08-17 23:12:07','2023-08-17 23:12:07','');
INSERT INTO users VALUES('358','','','AF0009','dany.sitompul@timas.com','','$2y$10$vqD0OEGQTxp5tNn1UbeDo.s3H2j6LFugVCCiH6Edsl2Uzw9LSLGLG','','','2','','1','082137543713','','','','2023-08-17 23:12:07','2023-08-17 23:12:07','');
INSERT INTO users VALUES('359','','','AE03029','asd@gmail.com','','$2y$10$ahHJV1qznWCR569bW/JMHOh6YMTD/Aw44fdhgP49CPOly3BNC1lUe','','','2','','1','082280107578','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('360','','','AE00779','asd1@gmail.com','','$2y$10$Hi9QDCoKIMEeq.ivfRRIxu5fFSxwV74v7L7kaZpygGVX69tirtxJi','','','2','','1','085363049624','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('361','','','AE02752','asd2@gmail.com','','$2y$10$iR6QXqQZOQE72yA8vHuVSu.EJ0PCqYVUelLZfEQlG6n.QiBdZUmVa','','','2','','1','0','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('362','','','AE02769','asd3@gmail.com','','$2y$10$NtAQQsjQIfyTuP.FA1XHW.Y3lZ7W9CpeXIQJ555jWqERo7nqyYXGq','','','2','','1','081272221353','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('363','','','AE02566','asd4@gmail.com','','$2y$10$SEKMG2tTpzA45mF2wYY4we18NrPksP8T0vY1UQIVswvC.pdYDmZS6','','','2','','1','085349913025','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('364','','','AD00006','asd5@gmail.com','','$2y$10$Bxrf72xfpl9SEnsYSi8Xr.jEaGTIJTeOT/IAFo3JEqCBqWlTzQAvS','','','2','','1','081296091501','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('365','','','AD00007','asd6@gmail.com','','$2y$10$KhTlIw3VlcQ.hIkrg5UxbOvvoMU/q1AprFgxwnxAQCj/BonbPfhOm','','','2','','1','081365253854','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('366','','','AD00008','asd7@gmail.com','','$2y$10$HQi47IZPxs46Q4.dWBOtOeL7UwexYXa6xG8jr6KzXIGKe20cCgEuC','','','2','','1','082174107553','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('367','','','AD00030','asd8@gmail.com','','$2y$10$6d.67KKm3RF0rEvv.7HMD.PUF8nSiHX056dOy2B54RCbXnZxKIZUC','','','2','','1','082169158099','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('368','','','AD00031','asd9@gmail.com','','$2y$10$qeJ66TrvG2l57tPywO6.4uF6dSEpgP3bL7/3sGKfNs7q3BWr1VM1a','','','2','','1','\'085271515545','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('369','Heri','Irawan','ab00003','heri.irawan@timas.com','','$2y$10$FxtkblBLjBuy6KsTbvp17enOdrcsN.UDpYi9EQz5rZueTpSN7dEk6','','','2','','1','081385768634','','','','2023-08-17 23:14:29','2023-08-18 11:11:41','');
INSERT INTO users VALUES('370','','','AB00007','franhidayat994@gmail.com','','$2y$10$4rXj9zflza/MswveQnAIVOqATYZ.XFu7J0QlgBOUujvYNKAmuFUE.','','','2','','1','085959187871','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('371','','','AB00008','yenitazby@gmail.com','','$2y$10$kbEa6tFBlHPv5mbrXetUhu1ms33oU5QjEPMKFyF3vLGqpqxvB7M7S','','','2','','1','082117981448','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('372','','','AB00009','Sarwat aja43@gmail,com','','$2y$10$Ypz0nmtHF2N7wGBWA//8Iet0IrD.QXugL8paVXXQ/3eGrNvVlJTba','','','2','','1','082312953978','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('373','','','AB00010','indrawati101069@gmail.com','','$2y$10$jlsf3o/qFLonbOkPrESOAOdPCqXRXSt2iqCnTD86qOeSTGwrq/P2K','','','2','','1','0895803204677','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('374','','','AA00152','adi.sutardi@timas.com','','$2y$10$pFZZJ5OvdGN1eyN1NRqLN.b9xzGzcLcu.saHgZmkRotFlkWbuVe6m','','','2','','1','087827757751','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('375','','','AA00153','nita.cynthia@timas.com','','$2y$10$AF5ZXrJyYs5FODw96fJBWe3e59iOMQA3oPdmgnzH5ZhjIBNvaC2W.','','','2','','1','087884247982','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('376','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$4r6f66Z58RZshiQ0/QzuE.dgkbk.SKJD9QRJFk7eYzX6YbpnNaJ/y','','','2','','1','085945207276','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('377','','','AA00155','mahfudin.nur@timas.com','','$2y$10$bcOpB7bAoa.dJjlZOoR1vOmfjQlRkFAIE7IZLvVZPKNTS1eueKCkm','','','2','','1','0817382906','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('378','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$CpkAN8R9XBsTdI5g1MV2TuxjjapPaXa0SucSzHBiMjcpE22otC442','','','2','','1','081380806655','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('379','','','AF0005','wahyudin@timas.com ','','$2y$10$FxwfKs7fvqJjaXoYwJue7.gzKsCujsyXNXBYcFvl878kdlm/AbfUq','','','2','','1','081364934014','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('380','','','AF0006','jimmer@timas.com','','$2y$10$fiqB5U15ZIJgV1poQkop3.Xze5m7sYde.VznXoU4hCuXTqT9Xyt9a','','','2','','1','081231047970','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('381','','','AF0007','aulia.gandi@timas.com ','','$2y$10$HsX8BAH7L0FzTHwm/ekdKuhCebq4LJ0Gd1nsgiaUA0aSN4VYSeDo2','','','2','','1','081354168025','','','','2023-08-17 23:14:30','2023-08-17 23:14:30','');
INSERT INTO users VALUES('382','','','AF0008','adi.yulianto@timas.com','','$2y$10$cRs8TGe9KqbT.cJtJb62F.7kFZTdFYedK9cHvKknKsxSwatdNJjC.','','','2','','1','081217657221','','','','2023-08-17 23:14:30','2023-08-17 23:14:30','');
INSERT INTO users VALUES('383','','','AF0009','dany.sitompul@timas.com','','$2y$10$4r3YWsmfpAb11X9LvsDog.fOLxBsuhG4sX4Vqwm0j4CYxOyltbWpe','','','2','','1','082137543713','','','','2023-08-17 23:14:30','2023-08-17 23:14:30','');
INSERT INTO users VALUES('384','','','AE03029','asd@gmail.com','','$2y$10$cvgMr2WrWXj7tA1SWMROxeFdfqxtFDyjZuqKascYDLIkl9VcRQZay','','','2','','1','082280107578','','','','2023-08-17 23:15:51','2023-08-17 23:15:51','');
INSERT INTO users VALUES('385','','','AE00779','asd1@gmail.com','','$2y$10$1E9j0NOdpa0Ar2tj6lSiPepEUCMcZ2HcC/Iac22NtJgq8find3Og6','','','2','','1','085363049624','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('386','','','AE02752','asd2@gmail.com','','$2y$10$X5gRaw1W7MQYhkEMncWuLO2EpgHN8743ZAgCfGQx3xaV4VdpF1XY2','','','2','','1','0','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('387','','','AE02769','asd3@gmail.com','','$2y$10$UMIgvXCQXiwucYqmk7J6suKUkUIKeK.7gOOcaXsWM3Pm7XfxZFfU.','','','2','','1','081272221353','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('388','','','AE02566','asd4@gmail.com','','$2y$10$.83pKmgh3iGeK.C2b2qEVuRaIMFOJt1E1RKDNm7PWjlBQmZeTxsMW','','','2','','1','085349913025','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('389','','','AD00006','asd5@gmail.com','','$2y$10$ZXdUbOe3O7aHeZ2PqzMzsenGYTltVLNuUpdQyEwaV9w7p1u2zHZo2','','','2','','1','081296091501','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('390','','','AD00007','asd6@gmail.com','','$2y$10$3mAiKDxRGPgMYrbmc/.W9OlzpVBJ.oGO.KTm7JqJAthCKL67maEy2','','','2','','1','081365253854','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('391','','','AD00008','asd7@gmail.com','','$2y$10$aPAWN4jz82TM5vUvgmfz7.9NMpuAc..BX5QTB7hGIaDP4DTSJceDO','','','2','','1','082174107553','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('392','','','AD00030','asd8@gmail.com','','$2y$10$.XbTZ4V.S2DkL/vvw0RypesP7s9fi359uy9bItvj6g3guFInTJPlO','','','2','','1','082169158099','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('393','','','AD00031','asd9@gmail.com','','$2y$10$YksWLxHUqm4cTaJT9uWM..M9hWtcmajS0YqliiegPJLa6SVv6K9VW','','','2','','1','\'085271515545','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('394','','','AB00003','heri.irawan@timas.com ','','$2y$10$fkzIyJ6e.VtwkhPQDJflfedSbHGzNtRmcnUjncILEZkF8ARaqw9nG','','','2','','1','081385768634','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('395','','','AB00007','franhidayat994@gmail.com','','$2y$10$jHaiFvbthXbJyyqMghk3qOewG6coRF5umrccbEV.jrWod1LuhJaGG','','','2','','1','085959187871','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('396','','','AB00008','yenitazby@gmail.com','','$2y$10$LvB5Xqcc3El.68dcCM.uteOJNu4C.4JhAZTJDFgOECadgFIDfGu8u','','','2','','1','082117981448','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('397','','','AB00009','Sarwat aja43@gmail,com','','$2y$10$3omFWmDh0o.2gJ06jtL2zOdWCs4wxmE892Wi0.HJG3jKZ62bTF/s2','','','2','','1','082312953978','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('398','','','AB00010','indrawati101069@gmail.com','','$2y$10$VIw6YwAvD3ORtH3iN2mu3OmlZ9CwJy5v1w26qn70qBi2dyKBgBFbi','','','2','','1','0895803204677','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('399','','','AA00152','adi.sutardi@timas.com','','$2y$10$UOIpIY.mT8KPvEsHCUaR6ulPq67a98rj8U106Up4MREgrn7tFY8yi','','','2','','1','087827757751','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('400','','','AA00153','nita.cynthia@timas.com','','$2y$10$HZtCtCuhIWRFBx4Ql9iEHO5KUibGItv/EItSdGhIX37rDfGQgD3nO','','','2','','1','087884247982','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('401','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$rNy5LNUHApZsPPYrGWg4tO8zPZDTR.4YpRiE94GyVvlqikpdeHWpm','','','2','','1','085945207276','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('402','','','AA00155','mahfudin.nur@timas.com','','$2y$10$hj9K2hixN5ChTlCRYXQmh.Leyymq3c3jXejZnRNvEXygmV2lAfeEi','','','2','','1','0817382906','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('403','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$twq3N6d8eyj5hCKwcUlWD.DXVS6m19mCYffzyfuHvqYsT4gLMec8u','','','2','','1','081380806655','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('404','','','AF0005','wahyudin@timas.com ','','$2y$10$MGSF2VSDrvvptgqLg58lpObG2VcGO1aQnVR3erWLRPGAv7ECYUOgq','','','2','','1','081364934014','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('405','','','AF0006','jimmer@timas.com','','$2y$10$/KhcMNUDzeISA3DYKM9Q6.oo/9dbCDpGapAAG03dRkv/X5mC6AnA.','','','2','','1','081231047970','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('406','','','AF0007','aulia.gandi@timas.com ','','$2y$10$5YzXWo3y2cqNWRKi9UC7vOVEfGnylmVXxEZ7FZwhACTutmMp4deJG','','','2','','1','081354168025','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('407','','','AF0008','adi.yulianto@timas.com','','$2y$10$WjVpNkszMZqp9tcd6rfhCOvlZqOi/zWIsZBDrPBLbt7BCUkbdvcES','','','2','','1','081217657221','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('408','','','AF0009','dany.sitompul@timas.com','','$2y$10$xhz.0bO5ewD80kzgVMqeQ.r2K4kCMXXyuzOvaC2Aeon/RHgvLHavO','','','2','','1','082137543713','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('410','','','testusername','test007@gmail.com','','$2y$10$U572g7earzb2vnjwNcfBHeNjuM1zTmJ7HoYs3GfXYfCU1yDoePQGq','','','2','','1','4536267','','','','2023-08-17 23:19:22','2023-08-17 23:19:22','');
INSERT INTO users VALUES('411','','','AE03029','asd@gmail.com','','$2y$10$VvA59ebSL2KnM5Fg0lMZQu961OfUiztM5FZHY.QptIQQnt/XbRe/G','','','2','','1','675728954','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('412','','','AE00779','asd1@gmail.com','','$2y$10$Lg1nNj5.tJ.b6pFicxqhvOkm7GdkbbnwekFC0noNWJo4y4vFEPiuq','','','2','','1','-536296296','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('413','','','AE02752','asd2@gmail.com','','$2y$10$4LiiUuyBHVrwoxo4IxVxrOLJL.iFnfUcgpY.YYyHn3BUtCyLdMwEu','','','2','','1','0','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('414','','','AE02769','asd3@gmail.com','','$2y$10$E.Lf.29ZsceMtRmhYN9t/.3592wP1mz.X1SJhyp4otJq0lWU3dYPi','','','2','','1','-332157271','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('415','','','AE02566','asd4@gmail.com','','$2y$10$41AqPGUvQOBZnTFhid7e3uidJoFIhd/cbcklpAMI01HvIAlYv3naG','','','2','','1','-549432895','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('416','','','AD00006','asd5@gmail.com','','$2y$10$EnFCwp4VeRZlXuHWq88wSOWm2JSnkYJfqHEl3AjApLO1/pQsIFC4u','','','2','','1','-308287123','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('417','','','AD00007','asd6@gmail.com','','$2y$10$7PZLBZRbNSN.4kVWqv6Wo.2SyRXzcwQ87arJnyw/70LmKCGwI5OBO','','','2','','1','-239124770','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('418','','','AD00008','asd7@gmail.com','','$2y$10$bZADehmywU0K2xT0s4ntB.p.13EZ/JlbdEvEvF9Vhd7t0eGN2K3Ua','','','2','','1','569728929','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('419','','','AD00030','asd8@gmail.com','','$2y$10$qylrc9Hya1054BDuwLClIOr8BWry2Y0IM//25BWHHB/tkquvJ8FS2','','','2','','1','564779475','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('420','','','AD00031','asd9@gmail.com','','$2y$10$.5pPSywaPxnja1ZGviAkk.1J3AeRxs5sI0EYJw6jV/bJ6O/DMYlFm','','','2','','1','\'085271515545','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('421','','','AB00003','heri.irawan@timas.com','','$2y$10$ddxgA.HGX4Kf.35F5WOHk.aaUctyJBPuvp3Z/8VY5ic1tjcLAwK6a','','','2','','1','-218609990','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('422','','','AB00007','franhidayat994@gmail.com','','$2y$10$xSBUQTXBKMgUNnohNFhCGe4eKZkwKKM5Q/FiLNBIGFGCA47HEFaGy','','','2','','1','59841951','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('423','','','AB00008','yenitazby@gmail.com','','$2y$10$zADFU8n85pzMEyhZOW.HK.qUdLpHcvvbVihuws5GmsZKM57cF4KVe','','','2','','1','513602824','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('424','','','AB00009','Sarwat aja43@gmail,com','','$2y$10$WZz6IMPcJivx9PolQm.waOZHt.04gYsMk.C3OT/OFMGv3q/aAazIe','','','2','','1','708575354','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('425','','','AB00010','indrawati101069@gmail.com','','$2y$10$0/YA260ZMPi76nbA6lakLuZHsEvSmiLa8RVY99mJsBj6jQpn7DisW','','','2','','1','-1844960187','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('426','','','AA00152','adi.sutardi@timas.com','','$2y$10$Q8VLLNdUDinvbGrZMjJNE.Cdwqeile0i1f09uz9wA9W/JkLq0Kas.','','','2','','1','1928411831','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('427','','','AA00153','nita.cynthia@timas.com','','$2y$10$D3DdhHkJ5UpOipl97l02IegBOd4qkxhyhWeLiKOGFsa9SU5eWgpS6','','','2','','1','1984902062','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('428','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$t/VT436WhXqK0mv7CNU1re/TzQ/i2nyk8VH3BfCoUzcfkjyFCpoDW','','','2','','1','45861356','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('429','','','AA00155','mahfudin.nur@timas.com','','$2y$10$MAzw9EMIcT2sOx5Q3QCeE.AEtlbiEP6R8gcmjEg9MQHrtp0qkRraK','','','2','','1','817382906','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('430','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$/6/9nzVIWh2vgGLLpDs7ouubjCDibTb8ZHniU1sm8uHLzKrPH9CyK','','','2','','1','-223571969','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('431','','','AF0005','wahyudin@timas.com','','$2y$10$Tz/24jS4BMngNM5Smi380.q/WXXhAdtnXWsTOJEzm7pR7GDPeQCJK','','','2','','1','-239444610','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('432','','','AF0006','jimmer@timas.com','','$2y$10$c0NEgs0hlhtAKTA4yYdQV.r41lziPW94F41d9K8dF7naXfk1mAsO.','','','2','','1','-373330654','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('433','','','AF0007','aulia.gandi@timas.com','','$2y$10$TWR7AkDwm3MSzXT/ufTs7.ae8CtD.0tULRvo/ptWQX41exmrmpkmG','','','2','','1','-250210599','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('434','','','AF0008','adi.yulianto@timas.com','','$2y$10$fRJocuou0Y8ylbgoBLJSk.VUtwhod.1/bGB04MWgsY/klBhzPj7ye','','','2','','1','-386721403','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('435','','','AF0009','dany.sitompul@timas.com','','$2y$10$.3lu3CEWowb.sKupMXNT7uBubBRMZA6rvPh/KoDZ2xJ/lrcf4apum','','','2','','1','533165089','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('438','Faleides','Pereira','ad3032','lulu.faleidas@timas.com','','$2y$10$Dgm8CBQa2ETv4CFtTlSs5eIivBZR6iqBusKLuZNhl5RD48rpPno8a','','','2','','1','085310424558','','','','2023-08-18 11:31:14','2023-08-18 11:31:14','');
INSERT INTO users VALUES('439','Daniel','Amaya','ag3033','daniel.amaya@timas.com','','$2y$10$YRpVvUmHOixCwGQvxut5teRwY/Fk.A5nrVk9kxEa/qdxy0rCFRA4.','','','2','','1','081122334455','','','','2023-08-18 11:39:58','2023-08-18 11:39:58','');
INSERT INTO users VALUES('440','Tristanto','TRISTANTO','aa3032','','','$2y$10$Qja0SfmAeZjoINaKGyhn5O7/.fBSopV.ds1HiT.UUkKSrNpadpMqG','','','6','','1','081213308381','103.113.77.126','2023-09-04 09:44:16.00','','2023-08-21 14:38:45','2023-08-23 05:28:50','');
INSERT INTO users VALUES('441','Tristanto','TRISTANTO','aa3032','','','$2y$10$TS.RQiFxYvIGWRL0ulShceNcxfZ8QY2I0BMoXqI/Q7.frx9YiQv9u','','','6','','1','081213308381','','','','2023-08-21 14:38:50','2023-08-21 14:38:50','');
INSERT INTO users VALUES('442','Tristanto','TRISTANTO','aa3032','','','$2y$10$BIUSLVxWqvlIiNU39M14eeKYWFr9cxQU3v4Bx4MM90pEG7yarU/li','','','6','','1','081213308381','','','','2023-08-21 14:39:03','2023-08-21 14:39:03','');
INSERT INTO users VALUES('443','Tristanto','TRISTANTO','aa3032','','','$2y$10$lomxOrAfQ4zrTImovKeTQenogcXyOTyH.LDfj2cXxZCawBkZEeGS2','','','6','','1','081213308381','','','','2023-08-21 14:39:07','2023-08-21 14:39:07','');
INSERT INTO users VALUES('444','Tristanto','TRISTANTO','aa3032','','','$2y$10$ckfiUz1VGM1svWKePFxSx.4kEV6siH1zxYaaxEdJk40ghd8SHA/pu','','','6','','1','081213308381','','','','2023-08-21 14:39:08','2023-08-21 14:39:08','');
INSERT INTO users VALUES('445','Tristanto','TRISTANTO','aa3032','','','$2y$10$Ln0AF.CUnWDeK4GyaYhqK.kqMeB4ryP9tVzzF6tWvdnH.2jMaHWc6','','','6','','1','081213308381','','','','2023-08-21 14:39:08','2023-08-21 14:39:08','');
INSERT INTO users VALUES('446','MERY YULITHA','RAFAEL','aa3033','','','$2y$10$ArPR5LGnzzYZVYAYOL92Ou/V7vYm5pDtJqGOrOUvxuKE7BGmMkKta','','','4','','1','081280003889','103.113.77.126','2023-09-04 10:34:48.00','','2023-08-21 14:50:56','2023-08-22 17:42:35','');
INSERT INTO users VALUES('447','LIANAWATI','GUNAWAN','aa3034','lianawati.gunawan@timas.com','','$2y$10$UObVwz4YPEgSB.BUTl.nGOBBc0frCw9PKIUll.m/HshcW5NNO4g5S','','','2','','1','0817170800','202.169.50.228','2023-08-23 10:06:20.00','','2023-08-21 14:56:29','2023-08-21 14:56:29','');
INSERT INTO users VALUES('448','CAHYONO','CAHYONO','aa3035','cahyono@timas.com','','$2y$10$0ScCX3zY2lLi3/SylDe.YuiUpK4uKY9KvWDKllX0Gn29H3MvWN35i','','','2','','1','081316738896','103.113.77.126','2023-10-24 11:33:12.00','','2023-08-21 15:00:15','2023-08-21 15:00:15','');
INSERT INTO users VALUES('449','Ahmad','Rifai','aa3035','ahmad.rifai@timas.com','','$2y$10$V9caZS0XkgxHQVNxE1G3JOH94k5PJV1bUukcDmZ.rPx29KHLHFQ..','','','2','','1','085882918919','','','','2023-08-21 15:00:47','2023-08-21 15:00:47','');
INSERT INTO users VALUES('450','LILIANY','VERISTIANNY','aa3036','','','$2y$10$sikAL.xTCuqupQj8NzhLaucCgdYaX6acRVPOV2gankH1YF8v5aa/S','','','2','','1','08128026989','','','','2023-08-21 15:05:33','2023-08-21 15:05:33','');
INSERT INTO users VALUES('451','Yudi','Prasetyo','aa3036','yudi.prasetyo@timas.com','','$2y$10$CQHhfgYM1DaISuxV7UIcFuoVELVssx/rBwe10H2Phhmdf1EbEy8hm','','','2','','1','0896-1464-8126','','','','2023-08-21 15:06:39','2023-08-21 15:06:39','');
INSERT INTO users VALUES('452','SAIDIN','SAIDIN','aa3037','','','$2y$10$jeIOk.i7Wn/vl29TvDv8yesrFVRBEAgpqCfExksAGHTj6CUhM/JeW','','','2','','1','081282908558','','','','2023-08-21 15:10:58','2023-08-21 15:10:58','');
INSERT INTO users VALUES('453','Ahmad','Rifai','aa3038','ahmad.rifai@timas.com','','$2y$10$t3XOjRgLklIxBLxpq2uuK.J6NZk5/DC1fNMyZl/GDG1ZhaPOS1gty','','','2','','1','0858-8291-8919','','','','2023-08-21 15:13:31','2023-08-21 15:13:31','');
INSERT INTO users VALUES('454','Yudi','Prasetyo','aa3039','yudi.prasetyo@timas.com','','$2y$10$kYBarbMYcr53q5nw89kzsOvbILSNsAWJWg5Bu0IXoCjjnwOYIa5Pu','','','2','','1','0896-1464-8126','','','','2023-08-21 15:23:13','2023-08-21 15:23:13','');
INSERT INTO users VALUES('455','Yudi','Prasetyo','aa3039','yudi.prasetyo@timas.com','','$2y$10$n36h6oasvy/WZ4TeNN6YL.9Qk7sPigrsxFQE21Jnun7qortTRHo/q','','','2','','1','0896-1464-8126','','','','2023-08-21 15:23:28','2023-08-21 15:23:28','');
INSERT INTO users VALUES('456','MUHLIS','MUHLIS','aa3040','','','$2y$10$Nh8W2FkW1S5Ym5Mhl6.LheONXz5cSrO1X1J16UiC.Ok/tXUOBVYFK','','','2','','1','0852-6745-2855','','','','2023-08-21 15:25:55','2023-08-21 15:25:55','');
INSERT INTO users VALUES('457','Ritci','Ritci','aa3041','ritchi.arie@timas.com','','$2y$10$R39ntotCgtCevG9yk4n/4eq3IOia/ldtnpzX/vNyJyqZpNJN8Pzp6','','','2','','1','0812-8001-5590','','','','2023-08-21 15:29:19','2023-08-21 15:29:19','');
INSERT INTO users VALUES('458','PRANADA','SIMANJUNTAK','aa3042','','','$2y$10$iWwEUOlBfcirgdzQaMvCke/V2bqEx9VQcUgrAkkNUdvGr53JW3J8G','','','2','','1','0852-7135-0358','','','','2023-08-21 15:33:56','2023-08-21 18:50:04','');
INSERT INTO users VALUES('459','Sarifudin','Sarifudin','aa3043','sarifudin@timas.com','','$2y$10$.pVe7wVbSqRWWpqe6CLLDeFRXAP2Fxxb.anJB5FM5z7Ea8ZW08p4O','','','2','','1','0819-1104-2777','','','','2023-08-21 15:43:40','2023-08-21 15:43:40','');
INSERT INTO users VALUES('460','JUMALI','JUMALI','aa3043','','','$2y$10$eSTNkYrZgHrSo0.frNICPOYMokYvkIvggV7J0RIeTGoQn3sP8XtDa','','','2','','1','0853-3235-1166','','','','2023-08-21 15:48:47','2023-08-21 15:48:47','');
INSERT INTO users VALUES('461','Nurziha','Laila','aa3044','nurziha.laila@timas.com','','$2y$10$0tAcYBp7/Ddm2qoOG1ddW.2Ency3bzQ4se18ppcDXTtFzr8NQUaCG','','','2','','1','0813-8950-4887','','','','2023-08-21 15:52:29','2023-08-21 15:52:29','');
INSERT INTO users VALUES('462','Nurziha','Laila','aa3044','nurziha.laila@timas.com','','$2y$10$jKPgXHP8sr94uHu2kyxosuU1LK/FNsBRI/JCA0p6LrnsRoyOKGLy2','','','2','','1','0813-8950-4887','','','','2023-08-21 15:54:06','2023-08-21 15:54:06','');
INSERT INTO users VALUES('464','Sulistyo','Indarto','aa3046','sulistyo.indarto@timas.com','','$2y$10$wijKbQbe41apdLoj.xJXTeawSr/0.mNJKpZL6WsZZmOF0PWYY/IfC','','','2','','1','0812-9413-3838','','','','2023-08-21 16:02:44','2023-08-21 16:02:44','');
INSERT INTO users VALUES('465','Edward','Austa','aa3047','edward.austa@timas.com','','$2y$10$YQlnWllwJ1Tdj9Lv.GbzJuFWvw9H6.R4.TrQLoTvBDJnZ2Prb3VZ2','','','2','','1','0813-6214-6495','','','','2023-08-21 16:05:04','2023-08-21 16:05:04','');
INSERT INTO users VALUES('466','Bambang','Paijo','aa3048','','','$2y$10$IOsb1AzJA2iBCbEUkK020uaItYxzb7E3pkrAWT9Z1zHeNZsUcWOy2','','','2','','1','0838-9277-0953','','','','2023-08-21 16:07:28','2023-08-21 16:07:28','');
INSERT INTO users VALUES('467','Eksa','Pratama','aa3049','','','$2y$10$vHCpgr6duqvbDw6ObDxLX.o8prImnW9oUvcZuNWzp6WUoqbdZIONG','','','2','','1','0823-1118-7978','','','','2023-08-21 16:13:27','2023-08-21 16:13:27','');
INSERT INTO users VALUES('470','Amimi','Amimi','aa3050','','','$2y$10$2YLVJ2KM/VD1DgsHnra3QOLgg74WdxiNYhUFubwOaiB9Qo/FYzWLO','','','2','','1','0838-3175-3507','','','','2023-08-21 16:18:24','2023-08-21 16:18:24','');
INSERT INTO users VALUES('471','Ramadhani Putra','Dewanto','aa3051','','','$2y$10$jGJnYZtJgnYD69XXNWvyY.aDlZQdOeUphdXbk6THaPIeh6HAKqgIq','','','2','','1','08112233445','','','','2023-08-21 16:44:41','2023-08-21 16:44:41','');
INSERT INTO users VALUES('472','Djamintas','Simbolon','aa3052','','','$2y$10$f.iSe7CM2dAeGQsYzmrW1ulcSks3uNAxZhHqDQSmxxBJykjgWnsFO','','','2','','1','0813112233344','','','','2023-08-21 16:49:33','2023-08-21 16:49:33','');
INSERT INTO users VALUES('473','BUDI RUBIYANTO','SUMARNO','aa3053','','','$2y$10$P5RBKi.KqsPX8iBJwwdK6uvNfhK161BBoN4knGOZXr/HCMzPkOzCS','','','2','','1','08782324242424','','','','2023-08-21 16:55:31','2023-08-21 16:55:31','');
INSERT INTO users VALUES('474','RENNI SEPTI','WULANDARI','aa3054','','','$2y$10$lTlMhJmE1PVEB.1WlKqUwOi8zM6BXAbmKoo.s47Ty2.e2uD067Vre','','','2','','1','081314151617','','','','2023-08-21 17:00:23','2023-08-21 17:00:23','');
INSERT INTO users VALUES('475','HARRY','SYAUKANI','aa3055','','','$2y$10$cYZDwWcnJLRgMzTsWRdrQeFMqWfoVM5XTuettfO02WhK6HjvzrAea','','','2','','1','081212131313','','','','2023-08-21 17:06:35','2023-08-21 20:22:11','');
INSERT INTO users VALUES('476','ELYASTA WINANTA','PUTRA','aa3056','','','$2y$10$h5UlNWN/WFWICTZiQrRD..HvfaFrovsb/WUJxmyMrYNn9EsiU1ITy','','','2','','1','085657585960','','','','2023-08-21 17:10:33','2023-08-21 17:10:33','');
INSERT INTO users VALUES('477','DHANI FAYUMI','ASYHAR','aa3057','','','$2y$10$yty1ILZaTQToGglq3TyzeezLXSMXuuqTlu6Qtgt3sElnUDEHpXB2O','','','2','','1','081199887766','','','','2023-08-21 17:14:31','2023-08-21 17:14:31','');
INSERT INTO users VALUES('478','ALFINA IDELIA DOLOK','SARIBU','aa3058','','','$2y$10$DbqSIC8D7h1CgVYZbSHm.OpfwveMM5ZLEzG9xp17k6s863NkWBX.e','','','2','','1','0896979899100','','','','2023-08-21 17:18:17','2023-08-21 17:18:17','');
INSERT INTO users VALUES('479','','','AE03029','asd@gmail.com','','$2y$10$JJ6zJXfnnBx6tHyi8c6qiuvaXj6rganDJoOhBs5tMM1TUrLx9UwFW','','','2','','','082280107578','','','','2023-08-21 20:29:06','2023-08-21 20:29:06','');
INSERT INTO users VALUES('490','','','AB00007','franhidayat994@gmail.com','','$2y$10$S1EJPDxcnQ9XU6R7dGDKbu9aIVo0PGAFfKo0YkYIegNrzrKYvui42','','','2','','','085959187871','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('491','','','AB00008','yenitazby@gmail.com','','$2y$10$wEJNboR8fmOD27eD1ybi8OYDlWR6P1Pgq0dI2Ix61nrgeEK75kJNy','','','2','','','082117981448','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('492','','','AB00009','Sarwat aja43@gmail,com','','$2y$10$hBsnAgPE2hIsXJYcTLqRRec4MApPbY0mkzy5fUpH7eJ3x4OMf3c5a','','','2','','','082312953978','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('493','','','AB00010','indrawati101069@gmail.com','','$2y$10$JHf9tMjNWh5yzgDsjQt1D.bjUrW8wIUpWBB/ooKVGoCSF66tlpnSi','','','2','','','0895803204677','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('494','','','AA00152','adi.sutardi@timas.com','','$2y$10$AYY3z/MjftWPqH3x8V570OkZWxP4gz9O54gck96vyv1tzafKgn5q6','','','2','','','087827757751','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('495','','','AA00153','nita.cynthia@timas.com','','$2y$10$aL.YkRTZ3EWF.vsw/P/cFe/y6LflB5j05sQOP7wGhC3uNFsPf.Arm','','','2','','','087884247982','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('496','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$jo3r0hGOb9l4B4T0eEvi0OkwTUDXvsUP8tfaYM/epGZaj.kXoL.kW','','','2','','','085945207276','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('497','','','AA00155','mahfudin.nur@timas.com','','$2y$10$55cfmmzWiNu6hPiIxRQkiejxXZ1G94GNhm4qoH9ghAMMm89tmhfXK','','','2','','','0817382906','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('498','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$1SUmCw7xQGAEmThM2w2kRON1yY0mBj2EvXFyiqABUioBfx5HP0nMm','','','2','','','081380806655','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('499','','','AF0005','wahyudin@timas.com ','','$2y$10$5IwvRYJZLsPlMGnfE/9SDuG2Hi3znw7jJNWi9ErhH5BP46L0Iiw4y','','','2','','','081364934014','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('500','','','AF0006','jimmer@timas.com','','$2y$10$m3rPA28PxV0Z3iEPrRKYA.4wrV5ehf5kPqgbhUU8kgbmQ9hAlvpSO','','','2','','','081231047970','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('501','Aulia Gandi','Wahono','af0007','aulia.gandi@timas.com','','$2y$10$OzB/2rUW6gI8Z3jeIqL39ePby7.3UElyLaBS8gfQIlAr2XZ4ax2.6','','','2','','1','081354168025','','','','2023-08-21 20:29:07','2023-08-23 09:01:34','');
INSERT INTO users VALUES('502','','','AF0008','adi.yulianto@timas.com','','$2y$10$uWS6yVUlUdbJqAbFakt8BOm3L1/vCP7lPItGl1A3ulXbWIRZJdP/m','','','2','','','081217657221','','','','2023-08-21 20:29:08','2023-08-21 20:29:08','');
INSERT INTO users VALUES('503','Dany Sanjaya','Sitompul','af0009','dany.sitompul@timas.com','','$2y$10$1oRse/DUax8TOHsSvdjbnOqlpZj.C3sT4xVcyGrWGe5SKH8nfpPbO','','','2','','1','082137543713','','','','2023-08-21 20:29:08','2023-08-22 09:04:39','');
INSERT INTO users VALUES('504','Erna','Widiastuti','aa3059','','','$2y$10$Cl8NJfREBbmi9qzk.E.NLurMXSFDxUQ7Fkra4wIchmSPw10o754g2','','','2','','1','0813-8982-7202','','','','2023-08-22 08:42:23','2023-08-22 08:42:23','');
INSERT INTO users VALUES('505','Riswandi','Riswandi','aa3060','','','$2y$10$4pntnKANjV9ialQpt198AuJHFsUc3Sn8Sz638Pldv34btsG6j0W6C','','','2','','1','0813-1993-1982','','','','2023-08-22 08:46:28','2023-08-22 08:46:28','');
INSERT INTO users VALUES('506','Didin','Supidin','aa3061','','','$2y$10$9fLb84b4s0yScdrbiiKrMeLH6GZiMLQC6HHWVQ0MaGgZP/edZdnqu','','','2','','1','081918171615','','','','2023-08-22 08:50:19','2023-08-22 08:50:19','');
INSERT INTO users VALUES('507','Aep','Saepuloh','aa3062','','','$2y$10$6kSqcE4UR67AbejLLnW6T.Pebi3.I6kdvSCRuPpsGL74J2KkVGF22','','','2','','1','0813121098765','','','','2023-08-22 08:52:45','2023-08-22 08:52:45','');
INSERT INTO users VALUES('508','Yanti','Yanti','aa3063','','','$2y$10$EefwhhkxO8zLJMVlapp37Oye98PrApHDUhVrKUPzohQCTZ3Q.945W','','','2','','1','081311571739','','','','2023-08-22 08:58:07','2023-08-22 08:58:07','');
INSERT INTO users VALUES('509','Agus San','Alwi','aa3064','','','$2y$10$rzOmsmGgTkJLdxx9XKYP3OZ2xg0VdmL12gL0lyv2Kp/Q8exPcHWha','','','2','','1','0815-1441-7416','','','','2023-08-22 09:12:57','2023-08-22 09:12:57','');
INSERT INTO users VALUES('510','Eka','Fitriasari','aa3065','','','$2y$10$oz5NIhne2QdqxXyvbUS7juBgYaLwS9RA4q4X6DKwdMn9npVvf.u6C','','','2','','1','0877-7091-2922','','','','2023-08-22 09:18:46','2023-08-22 09:18:46','');
INSERT INTO users VALUES('511','ISRO','MIROJ','aa3066','','','$2y$10$dz/Kzkq9nafHcq73ZwEmdOdMqMl0yVABEnA53JMcXsWS3i.u7AmPi','','','2','','1','0818-0772-7240','','','','2023-08-22 09:27:11','2023-08-22 09:27:11','');
INSERT INTO users VALUES('512','Denny','Ronald','aa3067','','','$2y$10$2CPOPUDcC07BNnOtiSeOnOX2CKpFs9InQkPPczJpyez9960lShKQO','','','2','','1','08595959595959','103.113.77.126','2024-02-05 16:27:09.00','','2023-08-22 09:33:19','2023-08-22 09:33:19','');
INSERT INTO users VALUES('519','Roy','Rendra','aa3074','','','$2y$10$imZTtsCVV5d8Oykj5yKQLuird3A4MfWAmj3PauM.HX9nvFkkoNque','','','2','','1','0817-714-615','','','','2023-08-22 10:09:14','2023-08-22 10:09:14','');
INSERT INTO users VALUES('520','VALENTINA ','EVANI','AA00059','valentina.evani@timas.com','','$2y$10$X6aU8colIDwdSADovRKn6.htIqVvEvfT.uEnTlZzM/UgGayU3mAIW','','','2','','','085771527008','','','','2023-08-22 10:44:39','2023-08-22 10:44:39','');
INSERT INTO users VALUES('521','MOCH','RUSWANDI ','AA00067','moch.ruswandi@timas.com','','$2y$10$JyclGyF4t9jpqFi8tCsG6eFtE6yNTJEnFSKzgrIC70mz.f/ea1NZ6','','','2','','','081383337805','','','','2023-08-22 10:44:39','2023-08-22 10:44:39','');
INSERT INTO users VALUES('525','NAWIN','NAWIN','aa3075','','','$2y$10$KbtpdCXM/Z6K72eeAZQOaut0d2lUEAUL/zskruCMSXiAvV2gqQfmW','','','2','','1','085716782136','','','','2023-08-23 05:01:22','2023-08-23 05:01:22','');
INSERT INTO users VALUES('526','SONNY','HARI MUKTI','aa3076','sonny.hari@timas.com','','$2y$10$iR2EXLCdPHFyw4SEH1p4OucdNIRDFr17sohR8sMGB9GuFiNa4WWci','','','2','','1','081233445566','','','','2023-09-11 08:54:00','2023-09-11 08:54:00','');
INSERT INTO users VALUES('529','DEDE','ROHAYAH','aa00075','dede.rohayah@timas.com','','$2y$10$uyaV8Ri9Y9ieQo9YzbXgYOmTE6RkW5g1Ky3vN72MApqxBfJ5MD6Iq','','','2','','1','083876767760','202.169.50.228','2023-09-11 10:24:04.00','','2023-09-11 08:58:39','2023-12-06 10:36:17','');
INSERT INTO users VALUES('530','SENNY AGUS','WIDIYANTI','AA00074','senny.agus@timas.com','','$2y$10$aSm1OeY4VQqVkCV3p/Ktj.bNNg/C6pJIUvVQqpjliPEzqzJVHnKSe','','','2','','1','081212131314','','','','2023-09-11 08:58:39','2023-09-11 08:58:39','');
INSERT INTO users VALUES('531','OKTA JULIANT DWI','SANGAJI','AA00076','okta.juliant@timas.com','','$2y$10$uF0qasKervc2wmI3allh6uPWm21flsTmOCTe5cDfP.hh1EGx9gGFS','','','2','','1','089797979797','','','','2023-09-11 08:58:39','2023-09-11 08:58:39','');
INSERT INTO users VALUES('532','AGUS ','PUJIONO','AA00077','agus.puijono@timas.com','','$2y$10$DaZuKZRvKxsB7q203tQz6O4A96SwYa23hRpLd79I5S0heyDd41iDS','','','2','','1','081313121212','','','','2023-09-11 08:58:39','2023-09-11 08:58:39','');
INSERT INTO users VALUES('533','TAYA ','MINANTI ','AA00078','taya.minanti@timas.com','','$2y$10$OTTGmcUUY9MRxg6LQDVso.qxOv0IFbsac0nWZhrndHmZrlgZVIqJq','','','2','','1','081297922112','','','','2023-09-11 08:58:39','2023-09-11 08:58:39','');
INSERT INTO users VALUES('535','HR','HO','hr-ho','hr-ho@gmail.com','','$2y$10$nLxlgVnMhLY./vQuhJhRB.ex314o1EzecVmp7sr/yMOFK8T0GmOKO','','','6','[11]','1','9128390193010','103.113.77.126','2023-11-29 15:59:03.00','','2023-10-30 17:04:04','2023-10-30 17:04:04','');
INSERT INTO users VALUES('536','HR','Plaza','hr-plaza','hr-plaza@gmail.com','','$2y$10$1OyvlHiLgKF5yXYh5wSXsuswPO3qWGCf5iBb7mSzVL//Hzm2nBRGS','','','6','[12]','1','8120273029100','103.113.77.126','2024-02-05 15:29:25.00','','2023-10-30 17:04:45','2023-10-30 17:04:45','');
INSERT INTO users VALUES('537','HR','Fab Shop','hr-shop','hr-shop@gmail.com','','$2y$10$7THUrbzEUBEZjKfp7ZcAhuhrBGC0cr4KqHk5WAo/M7659I69F4IGi','','','6','[13]','1','91027309213021','180.242.68.218','2024-02-22 13:04:08.00','','2023-10-30 17:06:43','2023-10-30 17:06:43','');
INSERT INTO users VALUES('538','HR','Crewing','hr-crew','hr-crew@gmail.com','','$2y$10$oZoKcG4lc7N4/WNV9pt/KukKcVEZwYA.4XEynAVuN7fIygq1Y/nny','','','6','[14]','1','81927391239','103.113.77.126','2023-10-31 10:31:12.00','','2023-10-30 17:07:34','2023-10-30 17:07:34','');
INSERT INTO users VALUES('539','HR','Duri','hr-duri','hr-duri@gmail.com','','$2y$10$xXLh8hX43qjKFaiDGehUM.aQAbNmGz7Di/vwnoXr8tczg5I2/H.5y','','','6','[15]','1','8321487803803','180.241.218.158','2023-11-13 13:14:40.00','','2023-10-30 17:08:09','2023-10-30 17:08:09','');
INSERT INTO users VALUES('540','HR','RAPP','hr-rapp','hr-rapp@gmail.com','','$2y$10$lbd/qG/Or88N52C0xrj7SOJ8QEQA7KvA046XfJi2VbxkTvRKxT8du','','','6','[16]','1','8132974932','27.121.84.42','2024-02-21 13:08:41.00','','2023-10-30 17:08:32','2023-10-30 17:08:32','');
INSERT INTO users VALUES('541','HR','PRI','hr-pri','hr-pri@gmail.com','','$2y$10$J.a03IOTKILAvuCfiEvpceCh3Zv322M0mcPEHzuX4epHO5Egbss9G','','','6','[17]','1','85937945394','103.113.77.126','2023-10-31 10:31:57.00','','2023-10-30 17:09:19','2023-10-30 17:09:19','');
INSERT INTO users VALUES('544','Dwitami','Wulandari','aa00276','dwitami.wulandari@timas.com','','$2y$10$6FNH2hBvhB/5N/5BUna3OuEXA1tsGehlayjPZMKZMPFMbjDyQ0Xie','','','2','','1','085959589646','103.113.77.126','2024-02-20 08:12:15.00','','2023-10-31 17:01:20','2023-10-31 17:01:20','');
INSERT INTO users VALUES('1093','HR','Rekret','hr-rek','hr-rek@gmail.com','','$2y$10$1frw5rtuq8eOE2qKuSxu1u4DbmizG.sBT/Dxs.n1MeQlFoB3HmyU6','','','6','[2, 3, 10]','1','','182.253.87.84','2023-11-21 08:31:14.00','','2023-11-20 14:11:40','2023-11-20 14:11:40','');
INSERT INTO users VALUES('1826','Aldo','Nataniel','Aldo Nataniel','aldo.nataniel@timas.com','','$2y$10$Iz8E40ggD1euugXE/rnsSOSTgQTqDZTYOsFiMR/3iPuMdCXHltEny','','','2','','1','081315084746','','','','2023-12-04 15:21:17','2023-12-04 15:21:17','');
INSERT INTO users VALUES('1827','Heri','Irawan','Heri Irawan','heriirawan081@gmail.com','','$2y$10$E4c.tXWoeQR.49r1FNh2puD2p41oe5UJHBrkCkswwxPste2GgfCJy','','','2','','1','081385768634','','','','2023-12-04 15:21:17','2023-12-04 15:21:17','');
INSERT INTO users VALUES('1828','Raden','Frans Hidayat , Sh','Raden Frans Hidayat , Sh','franhidayat994@gmail.com','','$2y$10$HVEkyrfhi4WOKDjA7OyY1OcE9eVaLQ6MmEwzRxMUx8GcMoEA6eDse','','','2','','1','085959187871','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1829','Yenita','','Yenita','yenitazby@gmail.com','','$2y$10$85.MeBC294.al5uOH9sAoeZcb3VULTBEKr5hUfoRkFYYshLni8Iyq','','','2','','1','082117981448','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1830','Sarwat','','Sarwat','Sarwat aja43@gmail,com','','$2y$10$RyFoYKeABpG4sF0FKo/Ur.0H15gsTUZFK0qbWGXUvEDT32DxW/ICS','','','2','','1','082312953978','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1831','Aminulloh','','Aminulloh','aminullohhifza@gmail.com','','$2y$10$nJtKknJz2./bz0ZmpbAxq.vJoDt5wZJNnPtHduC7g2fbZ1QPxkbFa','','','2','','1','081911291115','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1832','Ijah','Hadijah ','Ijah Hadijah ','ijahadijah269@gmail.com','','$2y$10$IXy4mGXMp7ekDwT1xHYZLujynGNkV7tw1mBe0wq77enjzveAxElti','','','2','','1','081282911305','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1833','Didi','Riyadi','Didi Riyadi','didi.riyadi130486@gmail.com','','$2y$10$C5e1.uZnvaJ8YJzatd4HDuksSe08MR9kRPLm0vlgA9hJJB0WRgyk2','','','2','','1','085216193958','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1834','Kasim','','Kasim','kasimalbantani01@gmail.com ','','$2y$10$65H1gli6JAVanTOOkuv6h.w7nP2qQjWLS2IjEwrgiIQzp.2JbmYIm','','','2','','1','081385348526','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1835','Jaka','','Jaka ','Jaka362514@gmail.com','','$2y$10$3IX4m2Ncy1y9vxj/Ux6FWupFq8CcyDP/xnJJ0P4Uc6VfH2B.aVaLO','','','2','','1','089651594719','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1836','Ahmad','Yani','Ahmad Yani','tama223tama@gmail.com','','$2y$10$FJlYH4c9LkWNLrxKHqRjuu03t9Sy5lwbcGSSyKwg.cfJ4uk91DO9i','','','2','','1','088213714381','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1837','Aswani','','Aswani','Aswanitambak@gmail.com','','$2y$10$naZWU.dFdai8d/gtB6Hj0eoapX.ybSHmbCGjjc79r1oWPU0qPN1Pm','','','2','','1','081398144345','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1838','Wawan','','Wawan','wkang3446@gmail.com','','$2y$10$hez4avV3SpuvSZol8OiMGO1fyWnUwj.UTBEP9jUErzk3K.6sYOkTG','','','2','','1','085219877292','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1839','Firliadi','Al Hapsi','Firliadi Al Hapsi','Firliadi@gmail.com','','$2y$10$q23c0OK/jvaa0KRk4phA4uM2U.U7Hw1veBgEfrS0OryAVmu0c/R9q','','','2','','1','083813123640','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1840','Siti','Ratna Ainun','Siti Ratna Ainun','ratna.ainun89@yahoo.com','','$2y$10$h1lSNBDY.61CKdo/La2IsOvtFnnqeIhU0ejqMDErMubfp.sfauPJC','','','2','','1','08128602800','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1841','Anton','Frans','Anton Frans','anton.frans@timas.com','','$2y$10$1P3LfIgrLaLLoHKXRVVG2Oxjk3y8AyGu7PZQdb5RV77FL5DY5R/xK','','','2','','1','08121205315','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1842','Sugino','','Sugino','Sugino.aldy@yahoo.com','','$2y$10$9a7uZL8qIOR3qIGMNI9rGuE6JD9fwDtyxcWSB5OPiu77WfKn5aRie','','','2','','1','082110895855','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1843','Nanang','Nasrur','Nanang Nasrur','qc_nanang@yahoo.com','','$2y$10$F.wdnlwwusNS9ZmBAoh8GuPXWELzHQXDPgWZvu/pjxsiyvhLrREKa','','','2','','1','081289244442','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1844','Ethana','Harits Bryano','Ethana Harits Bryano','haritsbryano@gmail.com','','$2y$10$ufdjd7iedU.IcNrFrWpvWOxqjrW6QHfpjQLhrVS5VlQBRoxj7Q6LW','','','2','','1','081285964246','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1845','Saeful','Fariz','Saeful Fariz','Saefulfariz7@gmail.com','','$2y$10$u8VNgJ2CN3WE4a.tDk1IGODS8U8Jb2vIacZ9.MSKShBX6ej.BSntW','','','2','','1','089618507555','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1846','Herry','Suryono, S. Kom','Herry Suryono, S. Kom','herry.suryono34@gmail.com','','$2y$10$x9BEOEKBDcDgHt4WguVys.jVLWxK/1Ne7cevvspuRZkThD.Vlo/J2','','','2','','1','081288195056','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1847','Suhel','','Suhel ','Suhel.binanusantara68@gmail.com','','$2y$10$powj2/QemqwUpP1wDZQMYOCWWUwAHGJIj3PaESoFuH5AB9RenfLLC','','','2','','1','085218729994','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1848','Andri','Kurniawan','Andri Kurniawan','andrikrnwn70@gmail.com','','$2y$10$Hvvkcv5ciwlSCeJaGKod3.gpJSnA6K5ixWSuIOl9DRNpS28jteXEm','','','2','','1','082122231380','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1849','Muhamad','Sulkhi Setiawan','Muhamad Sulkhi Setiawan','Msulhie@gmail.com','','$2y$10$UHGEu/7jUmAKKVKyJ8aMsuqCMZSGdLTotF8wpG2YQQMGTcs1NTMB.','','','2','','1','087786489560','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1850','Muhamad','Irfan Al Amin','Muhamad Irfan Al Amin','irfanalamin9@gmail.com','','$2y$10$wudb8HN9c7t1tmZoOmoBPOMxW0mxTCj/dIJIKzPtnpIqRdudeFpyG','','','2','','1','087771325958','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1851','Rizki','Ramadhona.W','Rizki Ramadhona.W','rizkiramadhona@yahoo.com','','$2y$10$iv2FO0s3kRbvfREV0sd2e.hXu5wK7uGYllB2hX1Hr8BwW2KN/PulK','','','2','','1','081284939394','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1852','Jefri','Silalahi','Jefri Silalahi','jefriisilalahi2018@gmail.com','','$2y$10$6qDsZZiD27JJIA0jfBEl4.Nj/1SAMRIFvEdpnL6ZILdOK0NZEt3EK','','','2','','1','082178680320','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1853','Moh','Hasyim','Moh Hasyim','moh.hasyim@timas.con','','$2y$10$kzDRNzPQiJruVZofRV85X.mbTiKAPqG0I.0I8IfD6VS30sB2DrcLa','','','2','','1','082312027157','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1854','Alfi','Syahrimadona ','Alfi Syahrimadona ','alfi.syahrimadona@gmail.com','','$2y$10$jRp0dpbEx2OgB.GcZUWnjeFOmdgwQEg5xcUtvdEtQlVNKw2eFcwMi','','','2','','1','081227235553','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1855','Maryono','','Maryono','maryonokoyek1975@gmail.com','','$2y$10$ICzbVyAvQzN55NXcNBqeBOnyTuBrlgvQwI57ivUk2mHN6g7ZdUHku','','','2','','1','081398051559','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1856','Ahmad','Habibi','Ahmad Habibi','ahmadhabibi3425@gmail.com','','$2y$10$/MwtVDfuLG2woyStZW77auwfp5mWg.MbnQ3AqmrILKWTR8aD/Ica2','','','2','','1','087876874679','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1857','Rifqi','Dhaifullah','Rifqi Dhaifullah','rifqidhaifullah18@gmail.com','','$2y$10$ivVLBNLjsQgyzGaGKCHkpe6M/rEcbhhpSinPXKp7YKDUVbcraW3Ya','','','2','','1','085960618570','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1858','Dwi','Yuniar','Dwi Yuniar','Dwi.yuniar@gmail.com','','$2y$10$pk/rmVG5saCoFQPj11Z4WuQ8p9egdekXWsij8Lkh1qWEcWoe0peuC','','','2','','1','087801061993','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1859','Moh.','Arifin Rumaji','Moh. Arifin Rumaji','muharifinrumaji@gmail.com','','$2y$10$wEWE.VVQ0wdfisFMTtJDDOxw1XyREKStCalR7mYe7SM5XNqg6pL/a','','','2','','1','081311014239','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1860','Wahyu','Budianto','Wahyu Budianto','wahyu.belahkulon97@gmail.com','','$2y$10$IAXye58/wbDx.dAeEX5.pOox9YHfS/dhfjtvIyxxYsGk/QK6f8U3G','','','2','','1','089697438880','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1861','Iwan','Siswandi','Iwan Siswandi','isiswandi15@gmail.com','','$2y$10$3lfeBIMEgn5OaG/565lxRu84RskusBiDEcf.Kl/.XNwneDZ0c4.Se','','','2','','1','087808291233','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1862','Vivit','Eri Hidayat ','Vivit Eri Hidayat ','pradiptaerik@gmail.com','','$2y$10$AL7QDjlNJEjdnQ25mQOquO5dxfLOQ7ulXC26eR1osT3.9gEXipkh6','','','2','','1','085718080847','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1863','Andri','Puji Setiawan','Andri Puji Setiawan','Andripujiset@gmail.com','','$2y$10$MPomJWlAWSxpOerj9.un6e5BcWyYHdELFfJey.iQWIJMMr94bbjyC','','','2','','1','081285858716','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1864','Rendy','Kerisna','Rendy Kerisna','rendy_kerisna@rocket.com','','$2y$10$nV46oWsF8TKOQ33S.dVv6u4ZuSYryDjRAdU02LjTu4D7OwY17d5Nu','','','2','','1','085717662532','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1865','Jaya','Heryana','Jaya Heryana','jay891143@gmail.com','','$2y$10$IQP.ELInxHxK.WmwMm217uiXAKvGRkaScxD.KVL4e0m/52D1hcZAG','','','2','','1','083877606993','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1866','Tarmidi','','Tarmidi','tarmidileo160@gmail.com','','$2y$10$KjVmssPfrOZK6E5.vWv7aut6QMAOmiF/57wNRGohO7Bw1v936KiIS','','','2','','1','087788085051','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1867','Umar','Sumardi','Umar Sumardi','tohaf21@gmail.com','','$2y$10$m29pbi8QSRWtJJkfnfCyFuUGpF0D3gbJf.acW.2rdJQnLzWnL3ZVe','','','2','','1','081389238664','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1868','Nana','Suciatna','Nana Suciatna','sigabjalakrawi@gmail.com','','$2y$10$rnn52VfYyTwavrmnzdqA8.5w28TG/AyYL8m8DA9lOKR5omojympnC','','','2','','1','087886095475','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1869','Suroto','','Suroto','12suroto44@gmail,com','','$2y$10$yfWKql7LoNc1cwt65qksP.GhzKAOt7AQiXiQ5eHbJ7R3GVinqp5kK','','','2','','1','085930285855','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1870','Ismatullah','','Ismatullah ','Imatalvaro822@gmail com','','$2y$10$lQ2w6q/UNsbYYQ89HWWWgeMyC5.SoSmtmU30TW4g9tFQG/ZvSAOlq','','','2','','1','083848584016','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1871','Muhammad','Pahlefi ','Muhammad Pahlefi ','muhammadpahlefi648@gmail.com','','$2y$10$xwCm3nvl/EVta/.qzbnxIOp6amZWJZguEHek6Mg/4OtZmZqriGPK6','','','2','','1','082310436085','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1872','Rudi','Hartono','Rudi Hartono','rudipaster242@gmail.com','','$2y$10$7nE4GGnvDCZqpsTrTTa71uO3K8NzP0.ijWo4SW8hP/Q6jmfxZJ5uW','','','2','','1','081310193667','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1873','Endang','Saputra','Endang Saputra','saputraendang020@gmail.com','','$2y$10$6CsjUDNZDcz3Ae6/yNHbO.XC4TbynKAs0P1OrlJ0HsUT53M/5imdK','','','2','','1','085717635769','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1874','Darwin','Silalahi','Darwin Silalahi','Darwin.silalahi@gmail.com','','$2y$10$Aiu5weYROOB0jK0XkhC5GOO2liQ8yNiYZ5BVvWZWdBqQi6LH8nDUm','','','2','','1','081282099356','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1875','Saenin','','Saenin','Saeninssenin44@gmail.com','','$2y$10$/QWn6Ij0QsnZrYB9KX4x.urggbeJFl5nnysPgjxHkHkDTJn44CfcS','','','2','','1','085284371675','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1876','Nor','Said','Nor Said','nursaidikram@gmail.com','','$2y$10$1wgb1Jt4v3Q5pmOqipRk3eag5Z6EO2nfaW4nLE8RY3n.X2VO8jSoK','','','2','','1','085219428892','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1877','Rinto','Samosir','Rinto Samosir','samosir.rinto68@gmail.com','','$2y$10$K1E5gKA7HExl.4iCm2YpEu7ADtyQBtgm75tlpn7uThudUUCGn89Ve','','','2','','1','081280512987','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1878','Gentha','Omar Panji Wijaya','Gentha Omar Panji Wijaya','genthapanji@gmail.com','','$2y$10$hwXFBAfqgb0LN8ATqzvua.W7hrZ.rpxAajIbK.VY2AYDcyhGaWQn.','','','2','','1','081291231530','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1879','Yusup','Ramdhani','Yusup Ramdhani','yusuframdani21@gmail.com','','$2y$10$bGAAXeBS.82s5LBJ2CrpVO3tWmRMV1QNCRwMThRoZlpsCRIb5qPJ.','','','2','','1','081314162709','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1880','Suyadi','','Suyadi','suyadiadi406@gmail.com','','$2y$10$drq.MBlMUtJykIgIb.xZUeSr5jT3853BoNH7.fQWLnQ1.i6YHH9B2','','','2','','1','08988665264','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1881','Reza','Dian Permana','Reza Dian Permana','rezarazzor130191@gmail.com','','$2y$10$3u1jia4FZfK0VMzD1lkSzO0R4wO5yfhphypUrTo3E2/QW49QBgaiq','','','2','','1','087778482858','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1882','Muhlis','Dondi Mihardi','Muhlis Dondi Mihardi','muhlisdm69@gmail.com','','$2y$10$j91UqY5UkuSpcS5zjT.g/.KSmvlyMzjEtwd9b6wODjALWPhg1PQqa','','','2','','1','081268345411','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1883','Sanen','','Sanen','sanen205@gmail.com','','$2y$10$Mq69rGVZEdvD9z5S5msk9eHMj.bm8Spzs85Ne8o6Lb.SkBX8HlghG','','','2','','1','082312182233','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1884','Aziz','Amirudin','Aziz Amirudin','azizamir844@gmail.com','','$2y$10$Tvkeq/r7NugqhBKNlNxbWeVgIACQ4OjxFdVvwlaIMBbCMAeIrpEPS','','','2','','1','082312727937','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1885','Ingga','Mulyana','Ingga Mulyana','Inggamulyana24@gmail.com','','$2y$10$TS0tI1ozCR/O6DcbilKSiO7cWVaVs0/qRZEe85Oz40KPDs9BdtTkC','','','2','','1','085712610091','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1886','Sofan','','Sofan','Sofanopan66@gmail.com','','$2y$10$AWtcsYNf/21sIhZtp3sU.eyFc.u7UUGuwm/KLzd/RugxO1YkJAZ1m','','','2','','1','085939070852','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1887','Erik','Yuliadi','Erik Yuliadi','yuliadierik@gmail.com ','','$2y$10$06g0ypU2SJLW6/44292Ie.dciAH7yL9XL.TMQJRRauQf8jy7SEmRy','','','2','','1','081281143405','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1888','Anggara','Saputra','Anggara Saputra','anggarasaputra8227@gmail.com ','','$2y$10$fUABNWMH/snKfKjWQIiuUuA8laTLBraOTyWpt17MnhRRCsHHvbZSa','','','2','','1','081271442155','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1889','Jhon','Albert Aritonang','Jhon Albert Aritonang','eliskaaritonang78@gmail.com','','$2y$10$Ukt33JJkGaZO4r14Cr3uV.VHIwzr7PPrr3RnxZxyAP3ES0WdW21yO','','','2','','1','081297238758','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1890','Bambang','Irawan','Bambang Irawan','Bambangibenkibenk.gmail.com','','$2y$10$N6Mztp.r5FLrWmnTghPK6OTmA0lXn4HTObRfaW3ceHCEpHeEpIeqC','','','2','','1','057808546949','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1891','Dedi','Rasdianto','Dedi Rasdianto','dedisuhar@gmail.com','','$2y$10$2V8TNV/GXjFIa5mbIZ2NH.2WfDa.THAUvUlE/NQ7.EEhd3zVRcNRS','','','2','','1','082115136397','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1892','Sastro','Wijoyo Butar Butar','Sastro Wijoyo Butar Butar','sastrowijoyo174@gmail.com','','$2y$10$4/AMOyac1xQ4rFHu92vpteSSjVF4f8gGYhaUE5bxYi.UCUlVDcuSG','','','2','','1','081388977156','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1893','Suheri','Bin Iwan','Suheri Bin Iwan','Suheri@gmail.com','','$2y$10$6D2i2AqbGJ.R5fCODJ3IPOFSTaxE2IwW/loZM.3QYoFS.dSA1wjPG','','','2','','1','08311465229','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1894','Suandi','','Suandi','Suandi@gmail.com','','$2y$10$wJL/R08TK7A4JDAtEGJNDuXQq4LufMr1Ph7EodMuGJL.Y6AmY4cM.','','','2','','1','085693396879','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1895','Sunda','','Sunda','Sunda@gmail.com','','$2y$10$yfNnBkikfgq50hyjpsH09OWJ/gUgIHXh4iEvCCc/cdLVdczv8.Ij6','','','2','','1','081285804910','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1896','Imatullah','','Imatullah','imatullah150200@gmail.com','','$2y$10$HFXeH/dGeLIlZcxVaiLf8.uKUnbryyU7gZY85VXOlR9hQqr/9ulEG','','','2','','1','083127321344','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1897','Mochamad','Haeroni ','Mochamad Haeroni ','muhroni507@gmail.com','','$2y$10$KSTvtdBXS3SefJEerjBZvuyS53Pgipxa3tIw8Pj6UMIfZ0nGpKrB.','','','2','','1','085312974597','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1898','Suparman','','Suparman','suparmanjon123@gmail.com','','$2y$10$E41yQaIrWHTx8k3iJzJYaOdtzdTWHdXfjoHtgsvYMPTkNySEpqoKy','','','2','','1','045217991932','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1899','Osbin','Malau','Osbin Malau','pudanrevan@gmail.com','','$2y$10$hi/4QQJDnsBQyrgjHrClPuIa954x3h4iZYvls9zPMrVz7Yijga8wK','','','2','','1','081294751486','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1900','Yulianto','','Yulianto','juliantoarepac@gmail.com','','$2y$10$o5uVQAnY/QvjG5.ADpB89ePiXtjFmGUfjBWY8jq3HnJR3.Lqx1AeG','','','2','','1','081288713060','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1901','Mamat','','Mamat','widyainayah30@gmail.com','','$2y$10$d6StstC0tdnes0JkRky4geZUDA67QTeOsfowGHSyhhNDjYxaf6yua','','','2','','1','085228044525','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1902','Erwan','','Erwan','erwanerwan752@gmail.com','','$2y$10$HpHIEAQYLHJJJF/ucip3e.eA2101xnxdVTTcV28.vcELkT5YLq4y2','','','2','','1','085216368976','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1903','Matsapik','','Matsapik','matsapikm@gmail.com','','$2y$10$kBJYPlATGrsFzkdXrcW/aOX5dMuWenRAJysrU6Q9rpaI6ZZhwnSPy','','','2','','1','081210084545','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1904','Wigihardi','','Wigihardi','wigihardi76@gmail.com','','$2y$10$d0afuY7J4/99Y9FRKHF/LODM/zFgnIzCP7YIqLTYgnAOV0PNX4D56','','','2','','1','081316820811','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1905','Soleman','','Soleman','Solesoleman257@gmail.com ','','$2y$10$SnQe//M/IdvzOJ5p4dUhJ.SLpPuaYj9B3FmdRwoUmB7/58NnX3oUu','','','2','','1','085691866423','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1906','Akyadi','Bin Ripan','Akyadi Bin Ripan','yadidi87@gmail.com','','$2y$10$u334Pe09oSccr5jUF/dlK.zXV8Sv6TKsClu4ErX1nQSrQqiImAYti','','','2','','1','088214759053','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1907','Dudi','Rohman ','Dudi Rohman ','do3dy.88@gmail.com','','$2y$10$mbojNWiWas6c1VmsWcSnbu1v8u3aj/MxpDGZ2K7d5xFBVuNEzAxIa','','','2','','1','085773412324','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1908','Suparno','','Suparno ','suparno01245678@gmail.com','','$2y$10$W8Y0AQ19CUW0/9fKXcmj2uEubjwmm.7S79GxNAKKJp1BTruiJx8Nq','','','2','','1','082142522143','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1909','Saepudin','','Saepudin','saepudinpudin837@gmail.com','','$2y$10$Mbq6ODoSqmJbUqB1r1JAfOll0FZKMnzW6ECGFOICrhyZ8Vyla9PGm','','','2','','1','081316935415','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1910','Yusuf','Ade Supriatna ','Yusuf Ade Supriatna ','Yusufadesupriatna123gmail.com','','$2y$10$rYaur/IqHC8l.1BIpbZ20ub8gtvWWF/qX0gpQBYcR7HdSaJgQQMyO','','','2','','1','087871466946','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1911','Saepuloh','','Saepuloh','Saepuls315@gmail.com','','$2y$10$p1v6jINSqejgF/xjACnqA.u./nUwDVMp.a8JIaFugxW0s4fiJA.la','','','2','','1','085782972766','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1912','Nurakhman','','Nurakhman','Nu_achman@yahoo.com','','$2y$10$PyDSV8X5niIt7vYRwdCwO.jeACy2rArdnY8U4tus3LgCsGaXTatrm','','','2','','1','081310748372','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1913','Purwanto','','Purwanto','purwanto321969@gmail.com','','$2y$10$FUFmvb8FtDRlUEoByhwus.B2FgsZsuYu6ZnOJbudTl8jLhkLc4MbW','','','2','','1','085217374535','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1914','M','Musa Efendi','M Musa Efendi','mmusaefendi@gmail.com','','$2y$10$H/6m1WaPtmlOtxE0iyClGuDHtZx8DofTTRg1FsPpOpXgyzoRqb8Am','','','2','','1','081399092269','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1915','Agus','Sofyan','Agus Sofyan','agaysofyan21@gmail.com','','$2y$10$74WJdWt7Yj7PyUPFSjYKFe5EzJEag6kAFNdo0vy5AWVhPHaEA2yRC','','','2','','1','081387866051','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1916','Sukardi','','Sukardi','SSUKARDI135@GMAIL.COM','','$2y$10$mtf0Mn6TOcT8V0NM865/M.hOTMdOIh.cK4ACY1ieY93al6/RHMhh2','','','2','','1','081297238970','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1917','Suyato','','Suyato','suyatoondel41317@gmail.com','','$2y$10$5WX3S7KKDK9u..6A8h99i.IL3cxoQyTWnAA0I3aMVYlktxsX8kupS','','','2','','1','082210476846','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1918','Eli','Hermansyah ','Eli Hermansyah ','elihermansyahhermansyah@gmail.com','','$2y$10$cq.IFRDCUSAqN40247Ni/.rw6wBwjqsBaaHyyuUZyWTWe0p6zUF6u','','','2','','1','087775845142','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1919','Riki','Purwanto','Riki Purwanto','rikipurwanto46890@gmail.com','','$2y$10$GGa39qIPoA89mBXCKQz6Q.The77Fkcxn0K2Lf6cYs0CoKjB2wH47u','','','2','','1','081268966927','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1920','Paryono','','Paryono ','Yonoparyono02@gmail.com','','$2y$10$DnjNfCkAa0RlvNpfhAdlnuxO1UtwEgaouobwmAm6MSkdXW96foP86','','','2','','1','085313652724','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1921','Iddrisno','Naibaho ','Iddrisno Naibaho ','idrisnaibaho88@gmail.com','','$2y$10$l.RgiS1cqXqTkVjST3m4vuiCBovAu9Dwy1bnk2TSfIEUNNn.nZc5m','','','2','','1','0813857920052','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1922','Rahimudin','','Rahimudin','rahimudin7788@gmail.com','','$2y$10$eXuvULjx6MvZUFmsFg2sN.f/qAmxZl7DrnVLEjVaj9Rs7iqjKlEcG','','','2','','1','081278188622','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1923','Tolhas','Jonier Hutasoit ','Tolhas Jonier Hutasoit ','tolhasjunier@.gmail.comm','','$2y$10$twKUMfi6yFtRW1YYlrzNbevsyWZf7Ajs8YRDoy1Y8jq6is2bmR2Vu','','','2','','1','085210714897','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1924','Roy','Renold Siburian','Roy Renold Siburian','roysiburian17@gmail.com','','$2y$10$H.MzrcQnFECBc8ZxbAwAQuPPUlenfiNP3VppQBK5GfnHoviEL/k7C','','','2','','1','08212935520','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1925','Dian','Hadiansyah ','Dian Hadiansyah ','Dian.h@gmail.com','','$2y$10$ScC.O70djE4pknAsI.A2duwuCIT.mr4VnrHGZBEIx.WKdbs1XlRva','','','2','','1','085920671630','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1926','Junaidi','','Junaidi','Junaidicase@gmail.com','','$2y$10$C.oJWSGvfWKj3XcbDGJ/AexXqt8euXVyx/osgDpvPQX.fhwL3fLnW','','','2','','1','081906274160','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1927','Nikmatullah','','Nikmatullah','Nickkutubuku@gmail.com','','$2y$10$kwB0aQn0882k4fbBkIqPR.7z6Q/e5xOH0HQhlJEHzvqcNEf4Bd8W.','','','2','','1','085693592382','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1928','Irwan','Wahyudi','Irwan Wahyudi','irwanwahyudi469@gmail.com','','$2y$10$ENbP0fAcJAeBac/01sUxl.pXUuKXcl6TwqDv0JYsvBBp7tvtXF1He','','','2','','1','081315128489','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1929','Ajislim','Silaban','Ajislim Silaban','ajislimsilabansilaban@gmail.com','','$2y$10$dVnMVs46zjwpruwik7hJyebdXRTDzEIT2RSHFzqAUwsnYGHoVXiGy','','','2','','1','082353311506','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1930','Mansyur','','Mansyur','ajaikal898@gmail.com','','$2y$10$.u0H/3GD0bLRYwxfKScGCOHWznR5UvHxTwe2z/Pw/nmucHAmNPfF6','','','2','','1','\'083127195698','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1931','Sohadi','','Sohadi','sohadi@gmail.com','','$2y$10$N8yZkaPLgDf7N5WoHb8un.m.XOJjUn9qsrR6AyKnmXMJpaa68yk8a','','','2','','1','083890898941','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1932','Charly','Nababan','Charly Nababan','Charly.n@gmail.com','','$2y$10$opVSxwK6wnzXhxHJkSbln.d8tmiIqZQMVto8732uFK/dQqs0gZ6CO','','','2','','1','081379456337','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1933','Imbran','','Imbran','Imbran@gmail.com','','$2y$10$7lnqIvSEGscJWpNNibHiLe.GCZjw3Y4LxWw1W5tZfaCh8mXuOOWbC','','','2','','1','082123656003','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1934','Andry','Firmansyah','Andry Firmansyah','andry_firmansyah17@yahoo.com','','$2y$10$uN4bCVzu6jyZ03lp53zfWO0hpTDRsHErC7cpkPGudVokSVPCvKQPu','','','2','','1','085288846363','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1935','Muhamad','Jupri','Muhamad Jupri','Jupri.m@gmail.com','','$2y$10$0T7UWIzaw/VChaJtgxfqZej6Kgi4wyV7daBGQnkemBtZYzMp8b6Gi','','','2','','1','085939419245','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1936','Suhemi','Andriansyah','Suhemi Andriansyah','suhemi@gmail.com','','$2y$10$xkqkuXQazBaxfUbS5yz6Fu6NuYzrsNqaR5zexD7KMdQNkVonJjXpS','','','2','','1','083119047028','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1937','M.Kaman','Sanusi','M.Kaman Sanusi','Kamansanusi6@gmail.com','','$2y$10$j9jrGn8dwQubwcgcl2jKoeNFURk.nkermxeGHaFW8i/zPzQj8heoS','','','2','','1','081283600132','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1938','Willi','Afrilian ','Willi Afrilian ','willydoer1207@gmail.com','','$2y$10$gTThRcke.hGV4.AVqiDuR.DckzBic7xk8fN0MAjtUSmSR.VPSQ6IW','','','2','','1','085959568233','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1939','Heri','Suarno ','Heri Suarno ','Herisuarno@gmail.com','','$2y$10$.NpKYrLcAVtwofGQmOiCaua6USpfHNaZncM.ZtB4TNzm14XDLkEea','','','2','','1','081291318134','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1940','Dasron','Sinaga','Dasron Sinaga','Sinagadasron9@gmail.com','','$2y$10$aYq9irPu7TJiOJqReEjgO.5axiHbQxmS07I8QMOMiVUU3X4tB1xoi','','','2','','1','085215579970','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1941','Muhammad','Kahfi ','Muhammad Kahfi ','muhammadkhf20@gmail.com','','$2y$10$jkG0Do2C5xTLbeNRzz918.T0pI.E.kfMXJxh2UxYaxywt49uCTtH.','','','2','','1','083871952889','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1942','Rohmat','','Rohmat','dyah.fu19@gmail.com','','$2y$10$MiB28664rBiIZ35xGRNjNe.YqudifSYCJWIoJYHhu6sq.HMlKao0W','','','2','','1','081315415696','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1943','Juli','','Juli','heriyadijuli18@gmail.com ','','$2y$10$fXzcCR1l21/oqc.RfKizd.z5t/VrB.8EKJL32TIthzxAsfYOtJH8.','','','2','','1','085216916646','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1944','Jaja','Sunarja ','Jaja Sunarja ','Jajasunarja52email.com','','$2y$10$ciHGGB66klXMa2RadOZ7ZuXFdWTOpfvj0T4Yx9/UWsaV5exjP.Up6','','','2','','1','085210377746','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1945','Medi','','Medi ','034beno@gmail.com','','$2y$10$C.r53uio1gupqT9EVQ3ziexgGiLaoKI5j7RiSdbVTgdtNTEKZ66WO','','','2','','1','081316761693','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1946','Andri','Wibowo ','Andri Wibowo ','andrie.wibowo71@gmail.com ','','$2y$10$BJ/UIVkQiQW8jQhXX6ii2OYgDO1cmQCb7Om3sYym.9iTAUk1jOFh6','','','2','','1','085329421884','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1947','Yahya','Suparjo ','Yahya Suparjo ','Yahyasuprjo1309@gmail.com','','$2y$10$sz6f2Dtam3g1KAmcWKvRSuDAJUsyVv/m54vmUgwdTxu24TX6XqyW2','','','2','','1','085210759988','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1948','Dadang','Sugianto','Dadang Sugianto','abythea19@gmail.com ','','$2y$10$N4xbbMWr4t4124vXAFLsweJIVPLswsVI2u52LvZ74LsM2Q/AOl86K','','','2','','1','081224074130','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1949','Ridwan','Saidi ','Ridwan Saidi ','Ridwanzea16@gmail.com','','$2y$10$6CoxGfudY73M9H3to.2gQOYPK1IJfwTRL.mTLmXNg4COYCtPj6e4K','','','2','','1','087864745161','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1950','M.','Ali Sodikin','M. Ali Sodikin','hilyaazahra89@gmail.com','','$2y$10$s.cuIPvZULeQC.BiA0cUxOpIKvsmNvRKAnPHRzmYR3kSlKBSlL4nu','','','2','','1','0881010749831','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1951','Utama','Wijaya','Utama Wijaya','0199tamawijaya@gmail.com','','$2y$10$vLKkRhz8If04Zsx339VoyufUHh5XTVWrFc1NtJcEKfvEHtM9INam.','','','2','','1','082175199923','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1952','M.','Fauzy','M. Fauzy','ajie.bae30102015@gmail.com','','$2y$10$K1j3iSGW2vAtt010Gz3x2u3Qx7FOt3wKb5XgkIislm0gNTRBOKxia','','','2','','1','082184373178','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1953','Erlan','','Erlan','erlanamelia01@gmail.com','','$2y$10$OoJ8YCmB7ru2j/WrRNJA3u0LKXDw00xxPOHg3Hk0VrFKEE2t/scjS','','','2','','1','081268030399','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1954','Asep','Achyar Sutisman','Asep Achyar Sutisman','asepachyarsutisman@gmail.com ','','$2y$10$R66ntef23NY3CxyIDqDQ.uS0Ao/LgqdJWrmDw/X2UjjAdOP1GvESm','','','2','','1','089643151668','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1955','Damanhuri','','Damanhuri','damane1378@gmail.com','','$2y$10$Ay.XySCykutyrROwhxtT7eSLjMVcj3MOXJJltB9gWG198z6ds2FdC','','','2','','1','082298339997','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1956','Sarkani','','Sarkani','kanisarkani982@gmail.com','','$2y$10$wi3KHAytpWJXuxBe8c5lRuD6B8q6Kfh4/mMozFzjktwdYVYqRTnIm','','','2','','1','085211821475','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1957','Saefudin','','Saefudin','Seapudin1970@gmail.com','','$2y$10$hxWiOhBnWXOSv1cmqLGCPudoN5FWdwxdUpMEK79AMWHlB.idPC.xe','','','2','','1','087771446771','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1958','Kemis','','Kemis ','themozt046@gmail.com','','$2y$10$pwyWGcZZZMjSely9EQZ.0e3ZseDdCVddF7IEWlhSOi8OH8mFKIjdq','','','2','','1','081251096886','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1959','Budi','Muharom','Budi Muharom','dhiosaputra968@gmail.com','','$2y$10$66W020UaGJ9F6kRQ6VQVg.cTx60DdJM4ckyRIE656HphShV7KoflO','','','2','','1','082320775526','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1960','Heru','Sumas Aditya','Heru Sumas Aditya','Herusumas65@gmail.com','','$2y$10$WPj35qYJdZdhKv13ymkF/.JxrJbimAJZrTSIgwzSYrjTN9zVWdHcW','','','2','','1','081290562157','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1961','Parsaoran','Gultom','Parsaoran Gultom','gultom.parsaoran1986@gmail.com','','$2y$10$vcnpCyhMNsMC1fQvb.C4F.LH16vXfmEhcCHCDaAd1WAQfQgivHd.u','','','2','','1','\'081227693124','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1962','Santoso','','Santoso','santoso.rms55@gmail.com','','$2y$10$90hxqLE9woX6WSaU6qQBm.90yXeGT9EzH5yN.pXuX03xMWOBcsRhS','','','2','','1','081311342428','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1963','Safiyudin','','Safiyudin','safiyudin@gmail.com','','$2y$10$vZDeBZDapHNNqj2/xlyH/uqgtB20eTji0q8bCBxc1HU3BOtpDMHy.','','','2','','1','085311580122','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1964','Saprudin','','Saprudin','ariep321022@gmail.com','','$2y$10$LgTmOZjiXbFkLHKBz43aNO/AFVhTyw.zMP/71G.l7bBfJTzFeZ3h.','','','2','','1','085946793917','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1965','Muchtar','','Muchtar ','muchtar1766@gmail.com','','$2y$10$KS4yb.jWi/Dqfn8l3FGPZOnuA4Dl7QCVj2uKRIEsgxF1I/70sC3kW','','','2','','1','087771748372','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1966','Dady','Rosyadi ','Dady Rosyadi ','dadyrosyadi14@gmail.com','','$2y$10$1Y21ySDu0m8kUulmFkbkpebDmoJ7ddRFtkuAGFCvlgXV2szD0ZCSi','','','2','','1','08952790225','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1967','Rahmattuloh','','Rahmattuloh','SANUNRAHMAT@gmail.com','','$2y$10$HjhNsxKBTJ1/SyCO6e6fV.lEtBzTwGYNFePzyOiqXeviZy.D9xFRe','','','2','','1','081317516084','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1968','Dimas','Candra Girisona','Dimas Candra Girisona','dimaschandragirisona@gmail.com','','$2y$10$mlkiljdYzW4TuwSSqOf8LuHMhQ/u0a3LnH2oQBVpvRa0IKgX9dBgy','','','2','','1','081293317538','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1969','Paryanto','','Paryanto','blegohkelana123@gmail.com','','$2y$10$FP6gkZGk9BYkjxd6RcZZgO7aIw.T.mzq9.fE9A/IUbO35tnDRbgUy','','','2','','1','081218061895','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1970','Erik','Extrada ','Erik Extrada ','eextrada05@gmail.com','','$2y$10$nPG4WCokqwJT8HwoNjifsO.AZhdIH4VPYnb90.M8uT4ZsK.AHw3yW','','','2','','1','089529917134','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1971','Nanang','Farid Ariyanto','Nanang Farid Ariyanto','nanang.farid@gmail.com','','$2y$10$XfOtImDU6/Wn.G9p6TkIFOZF7Oldr6/WVkFmlvPyn8Ir5K9R37L3e','','','2','','1','081335306888','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1972','Mochamad','Su\'Udi','Mochamad Su\'Udi','moch.suudi08@gmail.com','','$2y$10$UNTaY1FLZh1tBgju9nRxeua0Db875uLK8dkgEL9c8Bv/QnjBstI.y','','','2','','1','081310908261','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1973','Amin','','Amin','djadiputra514@gmail.cpm','','$2y$10$aeXM4zT2Cw4g5TdpXfBSme8K6.J6K1okgZKopYKEGc0HOdYCebRUW','','','2','','1','085216957457','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1974','Antoni','','Antoni','antonichebungsu@gmail.co','','$2y$10$HCFENBJiusHTtO3vLzAJduazQabmh.hVeAeIh0NOQRetn7YUCKM1a','','','2','','1','083842150483','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1975','Muhammad','Ridwan Amin','Muhammad Ridwan Amin','ridwan4892@gmail.com','','$2y$10$Eq1n4y.6JBCrILqNvrDdseRm0buR4aw6j5/ybXQpwckq1Fu4QHATm','','','2','','1','082122270017 / ','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1976','Aris','Susanto ','Aris Susanto ','arissusanto2938@gmail.com','','$2y$10$lIF0QrOhEaj6mrBgZVfkwu40cdV19wLRXyiRnVs6oOV/3C2W/FoLu','','','2','','1','083826968420','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1977','Sudarwan','','Sudarwan','sudarwan@gmail.com','','$2y$10$M.cMyeq2PhlCKYDYnpQNmeZxFjUCPHE340Wh2ZbhGxgf6Skfi0hLm','','','2','','1','081296697862','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1978','Manap','','Manap','Msabymanap01@gmail.com','','$2y$10$AGwqlQQONVHRa1qFLGpwteZ1NktiL9cUjLLo1o/AcO4/lUNKR980O','','','2','','1','083808510377','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1979','Wahyu','Dwi Saputra','Wahyu Dwi Saputra','wahyuwahyul2003@gmail.com','','$2y$10$ryGicewTzq2UaRhJGuGs6eluJgmRd3PpGFMJwQUGJkHOjEdIsdPiG','','','2','','1','085229332286','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1980','Moh','Sudari Wibowo','Moh Sudari Wibowo','mohsudari698@gmail.com','','$2y$10$fb7FjixAIuPGtfdBGueyWuCrzMeOdK23ThpNSNWpvPN2B/scqE2vK','','','2','','1','081319698280','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1981','A.Hafidullah','','A.Hafidullah','ahmadhafid548@gmail.com','','$2y$10$RojSdczfso4CJHfOoEY.LOl3A9UqInr7qu/m1HQC4gvi4hfUF9yXS','','','2','','1','085215799454','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1982','Sahroni','','Sahroni','sahroniaduai409@gmail.com','','$2y$10$L3yBkejC4t/74gOegOoRaeGLaXoT3nywq7wF.VenGe8ayqduux3ZC','','','2','','1','081291845422','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1983','Bintang','Chanensya','Bintang Chanensya','zeyyyyuss@gmail.com','','$2y$10$TKuOO9XHLgjkMV3hDTTzrO/26.mrkdGLLUZZgzECRX1o8/RE76rvO','','','2','','1','081212259113','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1984','Kamsarudin','','Kamsarudin','ilhamrakaboom92@gmail.com','','$2y$10$tZHTyxoITRztmz.CEAmFTOr2dpaByHHydHGCxSjQi3cggNV6cUrLq','','','2','','1','082122189601','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1985','Zulkifli','','Zulkifli','falskipli@gmail.com','','$2y$10$VFHWeUH0euVG3wQ2nK.5N.FK3zlIhWYfp9IVIH2sKvxuxdXtIsj/O','','','2','','1','088293046543','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1986','VALENTINA ','EVANI','AA00059','valentina.evani@timas.com','','$2y$10$wyfrYCj6OB9rveLSo/7WG.Aw0ftwBi74GwgTBngiJ3pdBuLyU76km','','','2','','1','085771527008','','','','2023-12-06 09:50:38','2023-12-06 09:50:38','');
INSERT INTO users VALUES('1987','MOCH','RUSWANDI ','AA00067','moch.ruswandi@timas.com','','$2y$10$0Gjbtuym6YoBqYbjE0EBQOWB0lMrWpJtj6.F0v.Q2nX7PuYx5nKeK','','','2','','1','081383337805','','','','2023-12-06 09:50:38','2023-12-06 09:50:38','');
INSERT INTO users VALUES('1988','AMUDI ','SIMORANGKIR ','AA00070','amudi.simorangkir@timas.com','','$2y$10$w9SV3jxcN424cRvR/k.7WuK997rtufHmEUMVNnpAq4RDcDNbF8jF.','','','2','','1','085283855286','','','','2023-12-06 09:50:38','2023-12-06 09:50:38','');
INSERT INTO users VALUES('1989','DENDI ','MARYANDI','AA00071','dendi.maryandi@timas.com','','$2y$10$Znn0CZpiSRlTEUv6smI8Gu9pkVLkU.rSNWKCZNtUf1NNMdL7r0bBu','','','2','','1','0817828753','','','','2023-12-06 09:50:39','2023-12-06 09:50:39','');
INSERT INTO users VALUES('1990','REGINA ','NOFIANUS ','AA00057','regina.egy@timas.com','','$2y$10$aEtCv69aQ/8QSYRb3IjnH.bfO1.2ltDI7BqSJxnn1N5eUXCcE0.0e','','','2','','1','081291666391','','','','2023-12-06 09:50:39','2023-12-06 09:50:39','');
INSERT INTO users VALUES('1991','Admin','Payroll','admin_payroll','admin_payroll@gmail.com','','$2y$10$x/hZFnRMPufWc/FmuUGIueKRymrNed.8k8aQBhXIs.doGw/AfKiau','','','1','','1','','118.99.110.173','2023-12-12 12:40:13.00','','2023-12-12 12:38:02','2023-12-12 12:38:02','');
INSERT INTO users VALUES('1992','Richard F','Papilaya','aa3077','richard.papilaya@timas.com','','$2y$10$FgLLb0v03eBisJTm6WNbM.rBGfHQzucBy0VJ05Q8J9R9jY3K.q//u','','','4','','1','081288776655','202.169.50.228','2023-12-18 11:07:26.00','','2023-12-18 10:31:55','2024-02-05 11:03:29','');
INSERT INTO users VALUES('1993','Arif Rahman','SR','aa3078','arif.rahman@timas.com','','$2y$10$W9jN9YB5AgsU/tZiPyslBetSuOhVtRJNQwsk/z2yADrM0F2zyxLF2','','','2','','1','082373325808','','','','2024-02-05 10:04:34','2024-02-05 10:56:47','');
INSERT INTO users VALUES('1994','AZMANDA','AZMANDA','ae00555','azmanda@timas.com','','$2y$10$KU/cROQZQmWL2HQ57JaMuO7vIlnyDA.bbx8tp8N4MQAtnpQx07NX2','','','2','','1','085712340987','103.113.77.126','2024-02-05 11:11:06.00','','2024-02-05 10:28:57','2024-02-05 11:02:47','');
INSERT INTO users VALUES('1995','Richard F','Papilaya','aa3079','richard.papilaya@timas.com','','$2y$10$7w9T2w4Kh1T/ACE0zMDCQ.4eX4vUwq.vKLZ09XHWU1arqRMsfCHNq','','','2','','1','','','','','2024-02-05 14:43:11','2024-02-05 14:43:11','');
INSERT INTO users VALUES('1996','AFRIANTO','SIMBOLON','AE03029','afrianto.simbolon@timas.com','','$2y$10$EsLblGp85ZrgHfGehUPGFO2cX2C2FIekGKZ9tWk67koY3SZZ6C4U.','','','2','','1','082280107578','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('1997','Diahayu','Paramudita','AE00779','diahayu.paramudita@timas.com','','$2y$10$g4E0gBKvKRmHyhqqdBRryu/NqQDEIZYXFBCVAmnnAnMPsQcAqUD9u','','','2','','1','085363049624','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('1998','Putri','Arta Manullang','AE02752','putri.manullang@timas.com','','$2y$10$i9ivKl5xjSXcvVGHfJ3F3uPvwble035c8It8peJcs8qkIDDPp20aC','','','2','','1','081212121212','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('1999','Berri','Pratama Putra','AE02769','berri@timas.com','','$2y$10$vjK37Nl4FcPzozVEJDR3nOu4/Ie3dXKfPf.T5HFGmFAPEXZfM.BEi','','','2','','1','081272221353','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2000','Isra','Alfarizi','AE02566','isra.alfarizi@timas.com','','$2y$10$azz7/h0fkrMRboKTlGzRgeuD1a2KaAQ/0CxF9FAydTt21PgtPlPaO','','','2','','1','085349913025','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2001','Rezki','Saputra Noflin','AE02774','rezki.noflin@timas.com','','$2y$10$tTcqc34HjhAaLo7ams/Vkec/sLaAigsIzbsSG2Hd6AnZZgyLOFSUS','','','2','','1','081368094492','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2002','Grant','Samuel Samosir','AE00435','grant.samosir@timas.com','','$2y$10$vY.UJFofz4VhTcggEmOr7eUbWSyVNjg30BHTBYEk9mOMSsPHoHfM.','','','2','','1','081368094492','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2003','Ade','Syaputri','AE02606','ade.syaputri@timas.com','','$2y$10$ZG95u6uHCJLYKl/MWvujJuch3ZkgwuYaIUMtOgAhA9.TUoVRhkBl.','','','2','','1','081261583678','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2004','Aidil','Raka','AE01059','aidil@timas.com','','$2y$10$5npeOk7L0C5d2WnaC4V07e6ofRP8RpA3l7TTuptnOGGdkrVp/OW2O','','','2','','1','082284658586','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2005','SUNARYA','SUNARYA','AE09103','sunarya@timas.com','','$2y$10$88DWPr1mI8zt.aQb9j3PzOc48kPPkx1EElVP/9gXYrI6co3MtEG/G','','','2','','1','081368094492','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2006','AFRIANTO','SIMBOLON','AE03029','afrianto.simbolon@timas.com','','$2y$10$kkgiIdwNTaeGLSLGGYbZi.1cVyyY9kHvlxyunzKlVN/h.fBnHTaky','','','2','','1','082280107578','','','','2024-02-05 14:59:06','2024-02-05 14:59:06','');
INSERT INTO users VALUES('2007','Diahayu','Paramudita','AE00779','diahayu.paramudita@timas.com','','$2y$10$NcaMgCpwa2Xg6zN5XiVVBe/wAzxnzCoeg7MU2gY5YyYgpf.bwnBp6','','','2','','1','085363049624','','','','2024-02-05 14:59:06','2024-02-05 14:59:06','');
INSERT INTO users VALUES('2008','Putri','Arta Manullang','AE02752','putri.manullang@timas.com','','$2y$10$Clpialz4u5WN91TSc7tlnOV/hRkd4lsTHmnpEq.8HANZF9Jaf8JCi','','','2','','1','081212121212','','','','2024-02-05 14:59:06','2024-02-05 14:59:06','');
INSERT INTO users VALUES('2009','Berri','Pratama Putra','AE02769','berri@timas.com','','$2y$10$fIYfBAyLnAvUR39FMgIDTuz0qNuZeI24d6vjSicsSTj9j39mbl/vC','','','2','','1','081272221353','','','','2024-02-05 14:59:06','2024-02-05 14:59:06','');
INSERT INTO users VALUES('2010','Isra','Alfarizi','AE02566','isra.alfarizi@timas.com','','$2y$10$LwwA1WyRm7EA9h30Y.j6K.LEMg1lF5e00IOJvGpa5FPHyKZyvCGy6','','','2','','1','085349913025','','','','2024-02-05 14:59:06','2024-02-05 14:59:06','');
INSERT INTO users VALUES('2011','Rezki','Saputra Noflin','AE02774','rezki.noflin@timas.com','','$2y$10$eJNfrZ/1ZFqSwJJ9qnx35.fa.EN.fN6zOwhgIRVnZU5sxQDU/atoe','','','2','','1','081368094492','','','','2024-02-05 14:59:07','2024-02-05 14:59:07','');
INSERT INTO users VALUES('2012','Grant','Samuel Samosir','AE00435','grant.samosir@timas.com','','$2y$10$qh61/HDyego7wyaykSBi..RaYO9GcFe2ENRJmjDniHz3lEeLNeE86','','','2','','1','081368094492','','','','2024-02-05 14:59:07','2024-02-05 14:59:07','');
INSERT INTO users VALUES('2013','Ade','Syaputri','AE02606','ade.syaputri@timas.com','','$2y$10$XiJyJQcTeddOSDTjtXkChuaWBl5klsmpxdfZQ7U5RHq1PHeHIsofW','','','2','','1','081261583678','','','','2024-02-05 14:59:07','2024-02-05 14:59:07','');
INSERT INTO users VALUES('2014','Aidil','Raka','AE01059','aidil@timas.com','','$2y$10$.1UAhlMLKZUmChLDcCA3w.L5ep12q0SLt1s7r2py1M8qzrmOCD4ji','','','2','','1','082284658586','','','','2024-02-05 14:59:07','2024-02-05 14:59:07','');
INSERT INTO users VALUES('2015','SUNARYA','SUNARYA','AE09103','sunarya@timas.com','','$2y$10$F/Py.0xknDaL03CM3VdvA.DZ7HsSKGYIGaN711zAmy2c7gAVPAsVm','','','2','','1','081368094492','','','','2024-02-05 14:59:07','2024-02-05 14:59:07','');
INSERT INTO users VALUES('2016','EDWIN','SITORUS','AE02989','edwin.sitorus@timas.com','','$2y$10$.1h9jILsaqpRMquCI3BWeu1A9/Uhg/EdRjjxSdZd5Zy4KUw3Kbzo6','','','2','','1','0','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2017','ZULHENDRI','ZULHENDRI','ae02997','zulhendri.zulhendri@timas.com','','$2y$10$v9kTEGtDGSASGIKVnAVnbeZGMOmr.GViG.dpH.IPvB6g9lrnqhkwi','','','2','','1','0812344556778','','','','2024-02-05 15:17:02','2024-02-05 15:20:54','');
INSERT INTO users VALUES('2018','Bezalel','Pandiangan','AE00967','bezalel.pandiangan@timas.com','','$2y$10$mJNTjuBNiPSUlslj/0QDBuqTgUXwTP26LI0FnxWHnJgZWyRgJwAeC','','','2','','1','085210328729','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2019','Junansi','Gultom','AE00267','junansi.gultom@timas.com','','$2y$10$ZeCWD8msag2Z3xPuUZ2t/eMtkVUMGrXWWDmFFt6jjYZbhcZ/x4kdi','','','2','','1','0821276948993','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2020','Hiskia','Munthe','AE00831','hiskia.munthe@timas.com','','$2y$10$PlFCRYPJVKn5spgo1CKdqOsIa2cLk2eZAi5KeM0kj7YNnZ16PSl2y','','','2','','1','082383461485','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2021','Irfandy','Manurung','AE00366','irfandy.manurung@timas.com','','$2y$10$g2EH.Bs0cWMNNgzmYLCtseQLok.hsHWSXqsuuvSOMoEOAZrrepD8i','','','2','','1','082176705093','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2022','Wilgianti','Wilgianti','AE05152','wilgianti.wilgianti@timas.com','','$2y$10$szyRkhMjf81qHr1VvNKnb.CIQoQva6UfuePiljNMXmJrhW6PGlMxO','','','2','','1','0','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2023','Amin','Rosidin','AE00253','amin.rosidin@timas.com','','$2y$10$jz/ivHMwMH4h4bja.iniPOSIKIVhOEEttsnWx2eV5PchjL7ZfLU4i','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2024','Sartono','Sartono','AE02403','sartono.sartono@timas.com','','$2y$10$2aFFtqU0IN3pBDKdAANXPeougov5L2qQA.bvauXtF9GfzmP2KSf5i','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2025','Didi','Prabowo','AE02571','didi.prabowo@timas.com','','$2y$10$0rxsqJlN5rv1jZyRbAqHy.bgnWVY7nfjc7eyf/FDBSUdooVaROF96','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2026','Engkus','Kusnadi','AE02396','engkus.kusnadi@timas.com','','$2y$10$G8ItREGj.8jt9ArtXgOtZe.WQu5Gb7Cw4ZA6Afu1iU2zTY1O4Xp2e','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2027','Dayat','Dayat','AE02650','dayat.dayat@timas.com','','$2y$10$wQR2d9LXPN92BeLvOV/i4OdMABzGl24hspt3DcZD.wB0vJX98iPrS','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2028','Aten','Wawan Kusuma','AE02061','aten.wawan kusuma@timas.com','','$2y$10$WJiBDqeSpwalFEs6vuAt9.t0HfeFb/d1QT5g9qz6Qiu5EfXq7ZiEO','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2030','AFRIANTO','SIMBOLON','ae03029','afrianto.simbolon@timas.com','','$2y$10$PIjeevmjNJ2hCVTyEnnHo.KFWHufrtA6sduXgQETfjFlBEmd1/M7m','','','2','','1','082280107578','','','','2024-02-05 16:23:26','2024-02-05 18:00:57','');
INSERT INTO users VALUES('2031','Diahayu','Paramudita','AE00779','diahayu.paramudita@timas.com','','$2y$10$rZFZhI6znEcusPI5haYvEuMLHwYRhRRaUzD6zCyylR6/B8O6BlRqK','','','2','','1','085363049624','','','','2024-02-05 16:23:26','2024-02-05 16:23:26','');
INSERT INTO users VALUES('2032','Putri','Arta Manullang','AE02752','putri.manullang@timas.com','','$2y$10$.KKRGVCI/CSySaznB2IQE.6dtYC0nGdnd87MeEthOdwt52GXzcWeu','','','2','','1','081212121212','','','','2024-02-05 16:23:26','2024-02-05 16:23:26','');
INSERT INTO users VALUES('2033','Berri','Pratama Putra','AE02769','berri@timas.com','','$2y$10$bE4LfO9P1ROBLXMrSADii.CPrbz/EYIrqJTRh7hbmYdpnBC2yqTdC','','','2','','1','081272221353','','','','2024-02-05 16:23:26','2024-02-05 16:23:26','');
INSERT INTO users VALUES('2034','Isra','Alfarizi','AE02566','isra.alfarizi@timas.com','','$2y$10$yrVwsGX7dJZML.gqUBqf7.WgLnokBfvFqCgOwLtXelmPLXTYyS1aW','','','2','','1','085349913025','','','','2024-02-05 16:23:26','2024-02-05 16:23:26','');
INSERT INTO users VALUES('2035','Rezki','Saputra Noflin','AE02774','rezki.noflin@timas.com','','$2y$10$AUUfZmzJKBLl4p.ywcODoONaR5f29HUsuqvzEHlQFBMCjj2tQkSsi','','','2','','1','081368094492','','','','2024-02-05 16:23:26','2024-02-05 16:23:26','');
INSERT INTO users VALUES('2036','Grant','Samuel Samosir','AE00435','grant.samosir@timas.com','','$2y$10$LLdR13B5lIEQFiPIDs4Qie638soOqPYrnW6fI8WARCGyKZWdf9kRu','','','2','','1','081368094492','','','','2024-02-05 16:23:26','2024-02-05 16:23:26','');
INSERT INTO users VALUES('2037','Ade','Syaputri','AE02606','ade.syaputri@timas.com','','$2y$10$oNJVDKN4Z72vVatqzUW87eDo.BmXwKCf6mRXGRIVMOypM9F1Re3gC','','','2','','1','081261583678','','','','2024-02-05 16:23:26','2024-02-05 16:23:26','');
INSERT INTO users VALUES('2038','Aidil','Raka','AE01059','aidil@timas.com','','$2y$10$a8E97zE.3dTd5Bcnjf8r.ecIwM//4Zho2FTyw/Y0O5i3k.jQTM4sW','','','2','','1','082284658586','','','','2024-02-05 16:23:26','2024-02-05 16:23:26','');
INSERT INTO users VALUES('2039','SUNARYA','SUNARYA','AE09103','sunarya@timas.com','','$2y$10$2Q0vvG8g6kn1dDh01sT9meOM1SMT3Ch1CeO6KNV0oAnGjMB1cig.a','','','2','','1','081368094492','','','','2024-02-05 16:23:27','2024-02-05 16:23:27','');
INSERT INTO users VALUES('2040','RAMADHANI PUTRA','DEWANTO','aa9104','ramadhani.dewanto@timas.com','','$2y$10$.cqazrSX0w9cez0D43.3yukWB2W2BN3ZBV0jDuAT2pgvkQheGY3NW','','','2','','1','','103.113.77.126','2024-02-05 18:03:08.00','','2024-02-05 17:53:39','2024-02-05 17:53:39','');
INSERT INTO users VALUES('2041','DWITAMI','Wulandari','aa9105','dwitami.wulandari@timas.com','','$2y$10$3sJu.Gk84FGBmSfrt5mht.Mrs.vy6WBSae2wedjsdbu5qaGZPV/iu','','','2','','1','0859595894649','103.113.77.126','2024-02-26 10:24:43.00','','2024-02-05 18:08:42','2024-02-07 10:10:51','');
INSERT INTO users VALUES('2042','Dwitami','Wulandari','aa9106','dwitami.wulandari@timas.com','','$2y$10$21d2FP6mENRJkdbuPsO2feozDaFYbDK5z82r5j.unAnTUSRyEYasa','','','6','','1','089765432123','','','','2024-02-05 18:15:19','2024-02-06 14:17:32','');
INSERT INTO users VALUES('2043','AFRIANTO','SIMBOLON','AE03029','afrianto.simbolon@timas.com','','$2y$10$f9bmrn9xoy.sTuG1omkxZu2z/lfYFoB.o5iEkDbTZF3f6mrEo9cI2','','','2','','1','082280107578','','','','2024-02-05 19:16:27','2024-02-05 19:16:27','');
INSERT INTO users VALUES('2044','Diahayu','Paramudita','AE00779','diahayu.paramudita@timas.com','','$2y$10$EVwc3xpIcCEWAzY/Rol5N.ankdZvGZA0m4iLh6TeSPXV4Z1M6wgJa','','','2','','1','085363049624','','','','2024-02-05 19:16:27','2024-02-05 19:16:27','');
INSERT INTO users VALUES('2045','Putri','Arta Manullang','AE02752','putri.manullang@timas.com','','$2y$10$k7ON6ikpx7vNTQat9b/AAeBEOAOjpWRNOt0Uay.8vqZK1YJyRIIuy','','','2','','1','081212121212','','','','2024-02-05 19:16:27','2024-02-05 19:16:27','');
INSERT INTO users VALUES('2046','Berri','Pratama Putra','AE02769','berri@timas.com','','$2y$10$9mpbs6vCMtvRSAg9ZXY5vuR6xRpsHfvIpARodvnR6R8NaJyGjZkNm','','','2','','1','081272221353','','','','2024-02-05 19:16:27','2024-02-05 19:16:27','');
INSERT INTO users VALUES('2047','Arif Rahman','SR','AE02566','isra.alfarizi@timas.com','','$2y$10$G2blN/VAC1PmNlpJzvMB6ejrA2T6a5tLxW7nexKCR/83mW5iFqP2e','','','2','','1','085349913025','','','','2024-02-05 19:16:27','2024-02-05 19:16:27','');
INSERT INTO users VALUES('2048','Aldo','Nataniel','aldo nataniel','aldo.nataniel@timas.com','','$2y$10$DOQoDRPyn5TRKn3gMHO0nef5DvyVArY/gJCRSNhbvUUrZpcj4DYvy','','','2','','1','081315084746','','','','2024-02-06 09:52:01','2024-02-06 14:37:40','');
INSERT INTO users VALUES('2049','Heri','Irawan','Heri Irawan','heriirawan081@gmail.com','','$2y$10$oLfyBZXH4Zp5sOzznsCWueob/GG7gFOcOn2JUlDju3kehtC2vdO76','','','2','','1','081385768634','','','','2024-02-06 09:52:01','2024-02-06 09:52:01','');
INSERT INTO users VALUES('2050','Raden','Frans Hidayat , Sh','raden frans hidayat , sh','franhidayat994@gmail.com','','$2y$10$Tn5uieHwhhaNqNgvYYXqouzaqwbiP4Vm6rQg2b9IKVtVMQ71hEJcK','','','2','','1','085959187871','','','','2024-02-06 09:52:01','2024-02-06 13:22:39','');
INSERT INTO users VALUES('2051','Yenita','','yenita','yenitazby@gmail.com','','$2y$10$45Wcd6ZPjl9J9XOkFGqw0eZgOtb7PJc2C2v1fc0cA/PrDRxuztMHm','','','2','','1','082117981448','','','','2024-02-06 09:52:01','2024-02-13 11:46:20','');
INSERT INTO users VALUES('2052','Sarwat','','sarwat','sarwat aja43@gmail,com','','$2y$10$EsGugDwZwnl2CeOKpFTd.eJsGET0pn4dAnQkMKWxWGc7WEU1atKgq','','','2','','1','082312953978','','','','2024-02-06 09:52:01','2024-02-16 14:13:33','');
INSERT INTO users VALUES('2053','Aminulloh','','aminulloh','aminullohhifza@gmail.com','','$2y$10$GCkHBdUqWwnUZ.2lF8uZs.61AusuRHPafsHvLhAWKybSL3Eq9BJIi','','','2','','1','081911291115','','','','2024-02-06 09:52:01','2024-02-19 16:40:33','');
INSERT INTO users VALUES('2054','Ijah','Hadijah','ijah hadijah','ijahadijah269@gmail.com','','$2y$10$QEBjiQ757GKWfnMh5XqlBOFYi55L9HgInDA.YCPO08OoSLEAEsp6u','','','2','','1','081282911305','','','','2024-02-06 09:52:01','2024-02-20 08:24:56','');
INSERT INTO users VALUES('2055','Didi','Riyadi','didi riyadi','didi.riyadi130486@gmail.com','','$2y$10$u8oxFsV95RYhhzLYDLTO9.kg1m3DS0STGb7NuMfOe/jszFON/LFcG','','','2','','1','085216193958','','','','2024-02-06 09:52:01','2024-02-20 13:59:36','');
INSERT INTO users VALUES('2056','Kasim','','kasim','kasimalbantani01@gmail.com','','$2y$10$LUtPyMFVt0HaFgh8x7TnyuJorrgw6MpnedwNoTI.reP6DLsfBSGXK','','','2','','1','081385348526','','','','2024-02-06 09:52:01','2024-02-21 13:22:04','');
INSERT INTO users VALUES('2057','Jaka','','Jaka ','Jaka362514@gmail.com','','$2y$10$Jm5L55OQwrv7ZXmUXV3nr.ukTlXBYKbxE05dejYzTvNk0k2swq1ze','','','2','','1','089651594719','','','','2024-02-06 09:52:01','2024-02-06 09:52:01','');
INSERT INTO users VALUES('2058','Ahmad','Yani','Ahmad Yani','tama223tama@gmail.com','','$2y$10$.2GFMBO2eo6FGK6zzhD0LOj2OHTU6zboDP4vVRGRnDrA6/RARWaC.','','','2','','1','088213714381','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2059','Aswani','','Aswani','Aswanitambak@gmail.com','','$2y$10$fYEYuYOKvqRUgDKUQy2SS.r8Bpj2ICfOIZhPqDMDQMIAsSSlJ8Une','','','2','','1','081398144345','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2060','Wawan','','Wawan','wkang3446@gmail.com','','$2y$10$P4LFEhF3oeS3pRsMlwnWh.0XwcdnBTHcenZJOv4e2JGu.qDFFPK/e','','','2','','1','085219877292','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2061','Firliadi','Al Hapsi','Firliadi Al Hapsi','Firliadi@gmail.com','','$2y$10$6wpgqBGYl/kVepfGIdbGQe5.H9qykxvPYMH6IOHgpMXrqFTMBt1i6','','','2','','1','083813123640','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2062','Siti','Ratna Ainun','Siti Ratna Ainun','ratna.ainun89@yahoo.com','','$2y$10$I.OQvBmfSmVB0QvTyNzZHu0723oGgxrM3eMYp0b2fygAYVCq2Gdoa','','','2','','1','08128602800','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2063','Anton','Frans','Anton Frans','anton.frans@timas.com','','$2y$10$JPQkFaMm3YGl7dma.Efty.9WWMSthfHMTqz7/0WKlVdl5Yljfyi8q','','','2','','1','08121205315','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2064','Sugino','','Sugino','Sugino.aldy@yahoo.com','','$2y$10$4wJcYQ1iLYy0wgE2Qd0Bc.uEy6lzDnVe5dFFd.b1Eu3YAN2h4PkyG','','','2','','1','082110895855','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2065','Nanang','Nasrur','Nanang Nasrur','qc_nanang@yahoo.com','','$2y$10$0mPo.pTWIEoygWGP8xdeUuZe7ySzMoja0zQ2F4YfSeP8N0MX62A7S','','','2','','1','081289244442','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2066','Ethana','Harits Bryano','Ethana Harits Bryano','haritsbryano@gmail.com','','$2y$10$Li4eOnwrRevOIjvQEiLRKuDf5cxnRkIR9Oc8iEdMqrmQJqrhragIG','','','2','','1','081285964246','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2067','Saeful','Fariz','Saeful Fariz','Saefulfariz7@gmail.com','','$2y$10$CcinGZln1wdS0Jx9GrbDgeSgha3w8QTAox1cf5M/BpFNeB.i8D4s6','','','2','','1','089618507555','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2068','Herry','Suryono, S. Kom','Herry Suryono, S. Kom','herry.suryono34@gmail.com','','$2y$10$OulMhSqcit3yab./rrYrGujGLMVWZTgPBoWHS4YtiqDhoxEcRY1we','','','2','','1','081288195056','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2069','Suhel','','Suhel ','Suhel.binanusantara68@gmail.com','','$2y$10$Kjn4iwSuTymXW9tN/QTox.9xp2C4Jauj1fAAmgVPVuw5m3GkZXsGa','','','2','','1','085218729994','','','','2024-02-06 09:52:02','2024-02-06 09:52:02','');
INSERT INTO users VALUES('2070','Andri','Kurniawan','Andri Kurniawan','andrikrnwn70@gmail.com','','$2y$10$/aqv5OnOpTtH7epdrQJOG.PVef1BgpRorSekO8/1QhH.OtjuO51OG','','','2','','1','082122231380','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2071','Muhamad','Sulkhi Setiawan','Muhamad Sulkhi Setiawan','Msulhie@gmail.com','','$2y$10$LoudZNg.KXidSBOeDUIaUeUNNvKjHSoupinMxgXS8NI.15aDebHMS','','','2','','1','087786489560','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2072','Muhamad','Irfan Al Amin','Muhamad Irfan Al Amin','irfanalamin9@gmail.com','','$2y$10$nyp0rG2rgnvrTC.5uEvRTuQ3dpFPmZvRfiVlF9F4in7bwjilGxLBe','','','2','','1','087771325958','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2073','Rizki','Ramadhona.W','Rizki Ramadhona.W','rizkiramadhona@yahoo.com','','$2y$10$ub7wCWTjBZ6uEHl9NInaouNo8yvMgQhy0w7.9qZvhd/I/CYsvgWqO','','','2','','1','081284939394','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2074','Jefri','Silalahi','Jefri Silalahi','jefriisilalahi2018@gmail.com','','$2y$10$wQaCq9u9zxrYFERPHPBDP.1g2116x934skye6qCwlw4h5fVhUKNdu','','','2','','1','082178680320','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2075','Moh','Hasyim','Moh Hasyim','moh.hasyim@timas.con','','$2y$10$rJXRN72mkHmvytG9y5bk7uyokamqLj6Cu1c9s8r3cROgxyNRX1LmG','','','2','','1','082312027157','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2076','Alfi','Syahrimadona ','Alfi Syahrimadona ','alfi.syahrimadona@gmail.com','','$2y$10$EHMnaOlChTtxF732saMXsOm414xFu50BVtvBZlZOlEcaNgNo0rHeS','','','2','','1','081227235553','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2077','Maryono','','Maryono','maryonokoyek1975@gmail.com','','$2y$10$THY2Km5naaVvARkCgfn6C.5X2ul2JDFUzSbPKACTYBnYHybzfrTJW','','','2','','1','081398051559','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2078','Ahmad','Habibi','Ahmad Habibi','ahmadhabibi3425@gmail.com','','$2y$10$X/OnXkPhdi33PLSVYhoEMOmuqac1N0yVfvnXJNhft0lTyPOPW0dva','','','2','','1','087876874679','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2079','Rifqi','Dhaifullah','Rifqi Dhaifullah','rifqidhaifullah18@gmail.com','','$2y$10$UgMYIzDFIOMfjenwJrAjNOe5Tnp0C4.DLlWJ3NQLRJVXv7pgbrT5O','','','2','','1','085960618570','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2080','Dwi','Yuniar','Dwi Yuniar','Dwi.yuniar@gmail.com','','$2y$10$DchNhdq0hzm/4T2LoBd/4.o7zfSfrXp3fkdm/77c62n5RkWH4WRgm','','','2','','1','087801061993','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2081','Moh.','Arifin Rumaji','Moh. Arifin Rumaji','muharifinrumaji@gmail.com','','$2y$10$qtvW9U05O7FnbjviHqsLH.2/UtZWG.v0VcMcFild.DAy6u0vMdFJ2','','','2','','1','081311014239','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2082','Wahyu','Budianto','Wahyu Budianto','wahyu.belahkulon97@gmail.com','','$2y$10$Vus5xW8ORTREnz/yf97YL.fG4xApRGHn8EGnU.lx9JLniQ6A/Flou','','','2','','1','089697438880','','','','2024-02-06 09:52:03','2024-02-06 09:52:03','');
INSERT INTO users VALUES('2083','Iwan','Siswandi','Iwan Siswandi','isiswandi15@gmail.com','','$2y$10$yXt/hbn1Yl.SKlOYDFM.Geyu.o3XQwdaxVaiJi0KLFZVu2JmgLHV.','','','2','','1','087808291233','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2084','Vivit','Eri Hidayat ','Vivit Eri Hidayat ','pradiptaerik@gmail.com','','$2y$10$M5FncTYMGUTdtIZ4NUAaL.uIbnDA/katrkIWKguI3T1ZEy2B/Hc3y','','','2','','1','085718080847','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2085','Andri','Puji Setiawan','Andri Puji Setiawan','Andripujiset@gmail.com','','$2y$10$BE9YaekaVCnt83JpIgy7MuzySLsh0Cg8TE1MKQY6eCsO0gUCOoUa6','','','2','','1','081285858716','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2086','Rendy','Kerisna','Rendy Kerisna','rendy_kerisna@rocket.com','','$2y$10$c7rfjPd.Y2Jyr4E1e9Lng.7R57zow7Z1TSQJDZRgiU4KBrbsyNwQK','','','2','','1','085717662532','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2087','Jaya','Heryana','Jaya Heryana','jay891143@gmail.com','','$2y$10$hoDNan/wpyBFwlKC90W5dugpuwUDolBB8VbGiF0SqtAYrnVq6rL5e','','','2','','1','083877606993','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2088','Tarmidi','','Tarmidi','tarmidileo160@gmail.com','','$2y$10$xLEP49k08obKI1AQrSWeuOB3bKXZOqdawV9aiqFar0e//1AxyxhKK','','','2','','1','087788085051','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2089','Umar','Sumardi','Umar Sumardi','tohaf21@gmail.com','','$2y$10$ZM8AKTYurKIZWMVv1I7yked11S4L6Y2A8HLe1dUU4JyR80J3LDIY.','','','2','','1','081389238664','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2090','Nana','Suciatna','Nana Suciatna','sigabjalakrawi@gmail.com','','$2y$10$zKQpATviah8lPPVAZhhBRuOSFtuL467RhxzQooUU7Pwr4ylTG.xki','','','2','','1','087886095475','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2091','Suroto','','Suroto','12suroto44@gmail,com','','$2y$10$RWqmCeHyS5SMEutfsiEX3.MYS49RNIrYPaoft5q0sDXT8eCku6eby','','','2','','1','085930285855','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2092','Ismatullah','','Ismatullah ','Imatalvaro822@gmail com','','$2y$10$QegAxgyBP5zRNpvWq7hiEeIMi68UfFZo53MQWm3ccpwvi6KoP6fAa','','','2','','1','083848584016','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2093','Muhammad','Pahlefi ','Muhammad Pahlefi ','muhammadpahlefi648@gmail.com','','$2y$10$yQe/rpqocohM6v9/WsSwouuRMtarXezOFYcydhUg7DZN.U/t.f50m','','','2','','1','082310436085','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2094','Rudi','Hartono','Rudi Hartono','rudipaster242@gmail.com','','$2y$10$mrVbB4Bf9rWONXumjxW5eOSSkAehFCr19emLzM/XqARsfbIPhy0ni','','','2','','1','081310193667','','','','2024-02-06 09:52:04','2024-02-06 09:52:04','');
INSERT INTO users VALUES('2095','Endang','Saputra','Endang Saputra','saputraendang020@gmail.com','','$2y$10$fgPaGGb4KBZrI5IAZipgeOLoOoNDs/EMbBsl/ggaN/ENqWIZvcVr.','','','2','','1','085717635769','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2096','Darwin','Silalahi','Darwin Silalahi','Darwin.silalahi@gmail.com','','$2y$10$RsqmJ.kTk4Y9ClZQUiOe5u8YeZH1g9khKC/kxcxMUrQWVDOE09jRO','','','2','','1','081282099356','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2097','Saenin','','Saenin','Saeninssenin44@gmail.com','','$2y$10$ZqOYI0tz.jy3ALde1.rgQep46xDaysPrQGeDs4SEhWnC/QJlORhFK','','','2','','1','085284371675','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2098','Nor','Said','Nor Said','nursaidikram@gmail.com','','$2y$10$XlsMrSnoNlZflYMtfpHsBOeJUDnycqNE6dqsJTv.7Rlx43I/1k.PG','','','2','','1','085219428892','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2099','Rinto','Samosir','Rinto Samosir','samosir.rinto68@gmail.com','','$2y$10$D9qVOQhpO8Zplk.wfDrS5e.rcf.EgZzghOtJVqH0/AG0socn8KEeS','','','2','','1','081280512987','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2100','Gentha','Omar Panji Wijaya','Gentha Omar Panji Wijaya','genthapanji@gmail.com','','$2y$10$k.ghinH1wvOUBnJGNIWslOdLi.Fl0N/qynHJTzWKXIO9i6/Tvw5xK','','','2','','1','081291231530','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2101','Yusup','Ramdhani','Yusup Ramdhani','yusuframdani21@gmail.com','','$2y$10$0ro0g8bL0RzFSJtDb7i3/uoWJPOpziABVI0mrw5SbNjPX7Ly9xxQe','','','2','','1','081314162709','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2102','Suyadi','','Suyadi','suyadiadi406@gmail.com','','$2y$10$qb.zOeb.Clq3L0U3ovknAO4GUkOsislmdEFwsrPwx8OUm.HVGxoOK','','','2','','1','08988665264','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2103','Reza','Dian Permana','Reza Dian Permana','rezarazzor130191@gmail.com','','$2y$10$igQwfnLGp59YE2.WGw3iru7GdDbV2TCwR.fIoBhHcqHVmGxEB98Oa','','','2','','1','087778482858','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2104','Muhlis','Dondi Mihardi','Muhlis Dondi Mihardi','muhlisdm69@gmail.com','','$2y$10$aHpc2KoisKDd.zECybeYIuo7A5ACIL0CbALFr2pkOdBhRdZv8ItIK','','','2','','1','081268345411','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2105','Sanen','','Sanen','sanen205@gmail.com','','$2y$10$YefXlBPNIE6JkCJbpFYP3.jVJ2m.JE.svc3T.U6vDOZuGRJSMJYFW','','','2','','1','082312182233','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2106','Aziz','Amirudin','Aziz Amirudin','azizamir844@gmail.com','','$2y$10$AomwMbhcEg3ZwN.8n.1UVeMgF104blP/.SE5T/yGzT9fd8Kiky/fq','','','2','','1','082312727937','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2107','Ingga','Mulyana','Ingga Mulyana','Inggamulyana24@gmail.com','','$2y$10$kE1EDG2NMrCLo8j25XEW6.SKcpbph4IcqJ/hrvSRAiWE0mm2SW66W','','','2','','1','085712610091','','','','2024-02-06 09:52:05','2024-02-06 09:52:05','');
INSERT INTO users VALUES('2108','Sofan','','Sofan','Sofanopan66@gmail.com','','$2y$10$dTSY3rtWV8O4Fg.KIAyKcugSJhmIyF2WE5n7oRtaNG3j4bFmFDxwu','','','2','','1','085939070852','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2109','Erik','Yuliadi','Erik Yuliadi','yuliadierik@gmail.com ','','$2y$10$41AGEoMY1O9tXBq3pp2P7uou7YmCDCjLMqpk0GBuca7zh0fszP2Qy','','','2','','1','081281143405','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2110','Anggara','Saputra','Anggara Saputra','anggarasaputra8227@gmail.com ','','$2y$10$/ZBL6YS2k2mhk/9y8a9OfuOBP7IJoEP64G9H4afjKYO3fdqNjEFby','','','2','','1','081271442155','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2111','Jhon','Albert Aritonang','Jhon Albert Aritonang','eliskaaritonang78@gmail.com','','$2y$10$uzBFpcTw4wXR334NlsDisO8VAo723PB4xKYdd/IE0Uc9LCuI9AGmW','','','2','','1','081297238758','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2112','Bambang','Irawan','Bambang Irawan','Bambangibenkibenk.gmail.com','','$2y$10$ZyD.QTav/IJXBbHfyPhBA.3Zaqsc5A/jZG1.IJU.QoWyk4XCLVCgW','','','2','','1','057808546949','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2113','Dedi','Rasdianto','Dedi Rasdianto','dedisuhar@gmail.com','','$2y$10$f23p0nr.Y9SBhHD6/vVBaOQ.MlVZuNpXtTdgYGBEfQH4MTreQ/HNi','','','2','','1','082115136397','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2114','Sastro','Wijoyo Butar Butar','Sastro Wijoyo Butar Butar','sastrowijoyo174@gmail.com','','$2y$10$jEiPUgY9.TeL5Y4FLeLjdeTBu7CXabyUpibr8ZDHq3aBjRB388a7y','','','2','','1','081388977156','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2115','Suheri','Bin Iwan','Suheri Bin Iwan','Suheri@gmail.com','','$2y$10$Zj5oWB51VQlxZJ.3oiEjb.1ZtsWYqEiM6Qxbv6r.AEpoeEExdd2q2','','','2','','1','08311465229','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2116','Suandi','','Suandi','Suandi@gmail.com','','$2y$10$xDxvEefFAMF7idp2Mto12OXE1lvX2c4rZzvw5CTiANKJHVuDK/CLG','','','2','','1','085693396879','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2117','Sunda','','Sunda','Sunda@gmail.com','','$2y$10$.G/sRfRbBqG84ix3QwYi2e/BADufBpIPfcKTS3fFrRG//ELT5zKgi','','','2','','1','081285804910','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2118','Imatullah','','Imatullah','imatullah150200@gmail.com','','$2y$10$2I0Hct9Rq7sj62s4kcgk3u7phQOLfguM80.qwnnjwwOvvdYRaaWV2','','','2','','1','083127321344','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2119','Mochamad','Haeroni ','Mochamad Haeroni ','muhroni507@gmail.com','','$2y$10$8xUyLZxWkPYtbwre4odqQ.HQfAeyCzwN9GiUtxDcrRNTEXZFEU86.','','','2','','1','085312974597','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2120','Suparman','','Suparman','suparmanjon123@gmail.com','','$2y$10$XujT0ySYK9RLvPDdpxPbdeGlIgPbyF1.ZqizXVPzXgKYDGCkel/SO','','','2','','1','045217991932','','','','2024-02-06 09:52:06','2024-02-06 09:52:06','');
INSERT INTO users VALUES('2121','Osbin','Malau','Osbin Malau','pudanrevan@gmail.com','','$2y$10$2qFLZspBZAFnn2geCC4UYODaxZGM/AaZZnUwuYbA/LC0/3ICcMthW','','','2','','1','081294751486','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2122','Yulianto','','Yulianto','juliantoarepac@gmail.com','','$2y$10$9fVWDuBa4HG7Lj/c0nuhhuQsg7IQLIBbT2EL0Mly7ugXhHnnVyuZy','','','2','','1','081288713060','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2123','Mamat','','Mamat','widyainayah30@gmail.com','','$2y$10$9qHUpjIUGUYPe7HdAYJBreRr7cNvRh9Z3Qai91aXrh6jeIBZBBu/6','','','2','','1','085228044525','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2124','Erwan','','Erwan','erwanerwan752@gmail.com','','$2y$10$v7B2FddQEaJtauu5CdzC0e4bMC9.t4UVZSdON/ZTykdtKvVTmzKh6','','','2','','1','085216368976','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2125','Matsapik','','Matsapik','matsapikm@gmail.com','','$2y$10$Zp1ma6U26yqc2wxahnTa4.G80K0kV8y2Z3fQ3e9XgFtzcqv4zZcrG','','','2','','1','081210084545','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2126','Wigihardi','','Wigihardi','wigihardi76@gmail.com','','$2y$10$cP9.SkiRIPBAClaMO2h.7O/mvcxJ1inHs0c5UyyYCezk3l9NwYyxK','','','2','','1','081316820811','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2127','Soleman','','Soleman','Solesoleman257@gmail.com ','','$2y$10$Xc47omzrV7SFsAR5strepeaHrQdLT07VBk9RC5ncOPli/hlnn47gy','','','2','','1','085691866423','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2128','Akyadi','Bin Ripan','Akyadi Bin Ripan','yadidi87@gmail.com','','$2y$10$yVz39P.PVO3sOi/w1LXUhuhpudWxz5RcPbkG63y7q.XdTdD4jA.4.','','','2','','1','088214759053','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2129','Dudi','Rohman ','Dudi Rohman ','do3dy.88@gmail.com','','$2y$10$Tp9r.KhTgwQvZFQSo0jQIOmGz3jvCKM9uDAtdkEP6RLTpxxdVE/0y','','','2','','1','085773412324','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2130','Suparno','','Suparno ','suparno01245678@gmail.com','','$2y$10$37AivE16xn/YJUxQo2PR5.7oPxjNbr6SbgRzhaUEbXNkd/6QfAGna','','','2','','1','082142522143','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2131','Saepudin','','Saepudin','saepudinpudin837@gmail.com','','$2y$10$C0j1Z5HJT4RRxrGhbu.Ju.NBEnC5QbkQTisDR4eBZ4N4Ci9RGZktK','','','2','','1','081316935415','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2132','Yusuf','Ade Supriatna ','Yusuf Ade Supriatna ','Yusufadesupriatna123gmail.com','','$2y$10$4jp1M.wDdvQZpxSXdtPDUOCjQsDj3DQUvZOfaz7VilKHrPOZ0R9Ae','','','2','','1','087871466946','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2133','Saepuloh','','Saepuloh','Saepuls315@gmail.com','','$2y$10$CHk82l7wnQLauCGzsG4fiuykqxgEar3Gag88kxpXlVWy8e8WdKJGG','','','2','','1','085782972766','','','','2024-02-06 09:52:07','2024-02-06 09:52:07','');
INSERT INTO users VALUES('2134','Nurakhman','','Nurakhman','Nu_achman@yahoo.com','','$2y$10$ME4GNnsJn/GY2qEsXJE9KOdYeP839BFn72y9jmJfcx4ozmb8SVY4C','','','2','','1','081310748372','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2135','Purwanto','','Purwanto','purwanto321969@gmail.com','','$2y$10$c2DZH8YlHSLuAddCCf.D8ugjQwHnjcjQpXva94ZcWSQ930Pc1PYdm','','','2','','1','085217374535','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2136','M','Musa Efendi','M Musa Efendi','mmusaefendi@gmail.com','','$2y$10$DElX/audWjAjICI3oUwRpunCbTxQF64PhS63utYFKLzYwlveO0xam','','','2','','1','081399092269','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2137','Agus','Sofyan','Agus Sofyan','agaysofyan21@gmail.com','','$2y$10$dwbbs2408dc0rA4dPKZgvuYvXriDGjYOQAr1boz/mCih5T5DyJE2i','','','2','','1','081387866051','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2138','Sukardi','','Sukardi','SSUKARDI135@GMAIL.COM','','$2y$10$HBV1ZP9fJklCuTMdQkWrrelu2p6AecSE0HAnrQTi.SxR924skorhy','','','2','','1','081297238970','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2139','Suyato','','Suyato','suyatoondel41317@gmail.com','','$2y$10$W4kuOVfqQAM.qUKi7ynxQerxJqDz.InjuR55UCE53jcf6v7cyX6fu','','','2','','1','082210476846','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2140','Eli','Hermansyah ','Eli Hermansyah ','elihermansyahhermansyah@gmail.com','','$2y$10$DERbgwReVgFNcBpK6pP1yOC9bcT9U05fyp5JxOMduLk/DfLOe9sMK','','','2','','1','087775845142','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2141','Riki','Purwanto','Riki Purwanto','rikipurwanto46890@gmail.com','','$2y$10$CQwg07LZ45T4N/8FE7I0t...pSEjZDuemT2u0xakVPhGg4RLeZ8re','','','2','','1','081268966927','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2142','Paryono','','Paryono ','Yonoparyono02@gmail.com','','$2y$10$4bysg/aLl6PUDVYxjoNUZOFz.zSmlZCBVIG7NWBZmLxRaNmOxHqM6','','','2','','1','085313652724','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2143','Iddrisno','Naibaho ','Iddrisno Naibaho ','idrisnaibaho88@gmail.com','','$2y$10$n.nxWWNSyre5UBTtg2G4e.qNd63wQwLEgrISvSKcj5IUe2tUEDNji','','','2','','1','0813857920052','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2144','Rahimudin','','Rahimudin','rahimudin7788@gmail.com','','$2y$10$yQ3MQ7SmG969QWoKGUyrh.U1PW1a.ugVtvTM7b3.DYNGo6qEpONZ2','','','2','','1','081278188622','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2145','Tolhas','Jonier Hutasoit ','Tolhas Jonier Hutasoit ','tolhasjunier@.gmail.comm','','$2y$10$rgEI7KwFBADnHz1DmXWZduKUPXBf0eCPrCKkhiC6Z4SfQhWE8qtTu','','','2','','1','085210714897','','','','2024-02-06 09:52:08','2024-02-06 09:52:08','');
INSERT INTO users VALUES('2146','Roy','Renold Siburian','Roy Renold Siburian','roysiburian17@gmail.com','','$2y$10$amyD3TC/hiKpN8CzYl04xOH9cZ2.DtlKrBvR4/xRrZLApSOI1rYnm','','','2','','1','08212935520','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2147','Dian','Hadiansyah ','Dian Hadiansyah ','Dian.h@gmail.com','','$2y$10$Cl2qB10SxpbNBZJtfzSLUeAytembVu35TWngfAJ8gM9eP4iHiOHlm','','','2','','1','085920671630','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2148','Junaidi','','Junaidi','Junaidicase@gmail.com','','$2y$10$PHYQK74Rvfm7lJeRkdXMTuYycr2SIVC4iTtVNMHKTxHaehTQWw3ya','','','2','','1','081906274160','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2149','Nikmatullah','','Nikmatullah','Nickkutubuku@gmail.com','','$2y$10$56jNYyyVQivTDC2nYRiakuabIpIKQzwhc.sncM31wpCq.EbmfyhIu','','','2','','1','085693592382','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2150','Irwan','Wahyudi','Irwan Wahyudi','irwanwahyudi469@gmail.com','','$2y$10$V3NFzCohclUa7cb3mQ/MpOjqWTaNR8Btxwt19Goks5sXdCPgBqreK','','','2','','1','081315128489','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2151','Ajislim','Silaban','Ajislim Silaban','ajislimsilabansilaban@gmail.com','','$2y$10$sy/tvRZLk/5jRiIL0Z1wEej.rtk85XtufHQ0rETqtGkFSsm83ThxW','','','2','','1','082353311506','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2152','Mansyur','','Mansyur','ajaikal898@gmail.com','','$2y$10$MeG9WGLmDlXjGZ.vv45kr.XTdTZuDqwrxJJqgnjGWUFQI4vPZxTvO','','','2','','1','\'083127195698','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2153','Sohadi','','Sohadi','sohadi@gmail.com','','$2y$10$gKoNoa/g6hGj9iBMIY3I0u0u6jMS0HJ9FgOLRO4S9KayqDZQtkzge','','','2','','1','083890898941','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2154','Charly','Nababan','Charly Nababan','Charly.n@gmail.com','','$2y$10$6k98HcGh/BSCtmajTN2LfOI9S4IWqbt/Ifl1WvmpvIcjAia4frT.O','','','2','','1','081379456337','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2155','Imbran','','Imbran','Imbran@gmail.com','','$2y$10$OGuIOEMq9X1N7vA4TIGeaO1YJE0R7V5z1vMBZ.QRhiQ21eOjN.N6i','','','2','','1','082123656003','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2156','Andry','Firmansyah','Andry Firmansyah','andry_firmansyah17@yahoo.com','','$2y$10$bwMIyzTD7wSoFmeIyCa39e1/0OWHTz8nr6E/CWEGQDOgyfyICIlXe','','','2','','1','085288846363','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2157','Muhamad','Jupri','Muhamad Jupri','Jupri.m@gmail.com','','$2y$10$kQO3JNqpAm11E5bjDwNlnOJHcqi3Zxtx4.u1YsIuDK.dMHpitKNOe','','','2','','1','085939419245','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2158','Suhemi','Andriansyah','Suhemi Andriansyah','suhemi@gmail.com','','$2y$10$i6Lt4Rv2bQZHVVh43R1hEuCKS2qnUT/.f1cmtD8yMXYjXjSyyh6bm','','','2','','1','083119047028','','','','2024-02-06 09:52:09','2024-02-06 09:52:09','');
INSERT INTO users VALUES('2159','M.Kaman','Sanusi','M.Kaman Sanusi','Kamansanusi6@gmail.com','','$2y$10$2hHcKOV7BbycAsP8Wl/fYOPEsBjQFs.NqCQmcxXqeFLLOh9VlPXQa','','','2','','1','081283600132','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2160','Willi','Afrilian ','Willi Afrilian ','willydoer1207@gmail.com','','$2y$10$J5.7Z.V7v2gGug6xuw9F.ug5v/UYWv8QrWYrWT3AUB/S6hnTf54vK','','','2','','1','085959568233','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2161','Heri','Suarno ','Heri Suarno ','Herisuarno@gmail.com','','$2y$10$rN3xcdlq8i8IP8Gk8s.qI.V1uNR8qdTRRVE3PSSH3rgo28Z5OMOeC','','','2','','1','081291318134','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2162','Dasron','Sinaga','Dasron Sinaga','Sinagadasron9@gmail.com','','$2y$10$Oxc/9Tf9JDr/gncKQcRJGOMFkyQlqBiMssqgJi9MaIYQloC7jxrTG','','','2','','1','085215579970','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2163','Muhammad','Kahfi ','Muhammad Kahfi ','muhammadkhf20@gmail.com','','$2y$10$.CLect8nRcN5jogXICKWzuQYJ87mfWma5LmqlkEyVDyR0f/rfLt3.','','','2','','1','083871952889','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2164','Rohmat','','Rohmat','dyah.fu19@gmail.com','','$2y$10$6j/Y1PhcDdkYrJEmtCZAau3Cgr.g7WqvO2XOLlAJpOr4e/5gxAIfm','','','2','','1','081315415696','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2165','Juli','','Juli','heriyadijuli18@gmail.com ','','$2y$10$oC0xcPY1qxA44nTAjc/fcOU7FD3vEFV4uoDDROq9cjwLVirh4KKGm','','','2','','1','085216916646','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2166','Jaja','Sunarja ','Jaja Sunarja ','Jajasunarja52email.com','','$2y$10$FoNE0uXd6UMaLsx.S93XE.no2y/j3wFFCY9w61MZ07VCRjVRIZMoW','','','2','','1','085210377746','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2167','Medi','','Medi ','034beno@gmail.com','','$2y$10$m.IGFoanL/CmO6DLw7NrsuqSlPOsS2g1QhyITQsupYhKRii7QFQVm','','','2','','1','081316761693','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2168','Andri','Wibowo ','Andri Wibowo ','andrie.wibowo71@gmail.com ','','$2y$10$Uu0WfAxiqgIwgjNjC0a4V.p9FTVcfmGhPvfbgk.nDMASfcmqWPcyW','','','2','','1','085329421884','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2169','Yahya','Suparjo ','Yahya Suparjo ','Yahyasuprjo1309@gmail.com','','$2y$10$UxW1zWVOoZrI51BL/x35J.65qFztbw2NcLYat7orRciJxiMFA4aMm','','','2','','1','085210759988','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2170','Dadang','Sugianto','Dadang Sugianto','abythea19@gmail.com ','','$2y$10$B6EKCl7BInSMhzxfOa9YqeF4LlmNkB7MKl8Dd/SA55ySxMaTTIsXm','','','2','','1','081224074130','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2171','Ridwan','Saidi ','Ridwan Saidi ','Ridwanzea16@gmail.com','','$2y$10$OgCTjqmksKPgSvKCAKbsieoNitMBFSUtpiJgibH9va4P69N/i4RWK','','','2','','1','087864745161','','','','2024-02-06 09:52:10','2024-02-06 09:52:10','');
INSERT INTO users VALUES('2172','M.','Ali Sodikin','M. Ali Sodikin','hilyaazahra89@gmail.com','','$2y$10$eGHDSBt/sqws5Xo823qZk.dTBmcdIYZ53mxZYs0b8XMtekD9smCXq','','','2','','1','0881010749831','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2173','Utama','Wijaya','Utama Wijaya','0199tamawijaya@gmail.com','','$2y$10$Sj4F7Wd7uWItOeOLXEBF8OnNw4L3pKkaOFV1xMvrq/sDzocGv6xfa','','','2','','1','082175199923','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2174','M.','Fauzy','M. Fauzy','ajie.bae30102015@gmail.com','','$2y$10$WwcU9btyTC6qfCbdMVUCGOLZe6zlqrMmXaT5xqhP3VOnXRdOUTk.K','','','2','','1','082184373178','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2175','Erlan','','Erlan','erlanamelia01@gmail.com','','$2y$10$vWwAYOdBEkyS6gWRjKtTeOFmL5MXsxidGOJwpkenveq1BQQT19Xdy','','','2','','1','081268030399','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2176','Asep','Achyar Sutisman','Asep Achyar Sutisman','asepachyarsutisman@gmail.com ','','$2y$10$nFeB8fzp9mO7GfaZ1s/U3epy9nG9QGeEkQc6Q1zrbL0/dp7q/HYRy','','','2','','1','089643151668','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2177','Damanhuri','','Damanhuri','damane1378@gmail.com','','$2y$10$6cHs7Rxaz3Q6WyPFsk6RquUuYO2U3s20MhSmIS0TxhUFUIuR0tHWq','','','2','','1','082298339997','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2178','Sarkani','','Sarkani','kanisarkani982@gmail.com','','$2y$10$tHqY6htWGGQG5xgHNHlBYuO7dvdPei8jQGzXn5cMUF6JlgguZJmFy','','','2','','1','085211821475','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2179','Saefudin','','Saefudin','Seapudin1970@gmail.com','','$2y$10$VGhmyAN.6Hk14QhYpBUUsuvEyVT.O4GfLZRrildo8iHSGCiU6k5K2','','','2','','1','087771446771','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2180','Kemis','','Kemis ','themozt046@gmail.com','','$2y$10$2.JKu3qkuh1QXb2nah45Ved0zdYbLj404NVX/n5B7bLtbXd.eey5O','','','2','','1','081251096886','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2181','Budi','Muharom','Budi Muharom','dhiosaputra968@gmail.com','','$2y$10$6zGpeK0Aec0RrdXVlqqGT.4Vh7Zz77P2km1j3mPoDEG57fmPDyObq','','','2','','1','082320775526','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2182','Heru','Sumas Aditya','Heru Sumas Aditya','Herusumas65@gmail.com','','$2y$10$//cu/N.UrUoXsIDtFi2jcunlz4IoJnwLiNFGmse2HU1toq9CtIu66','','','2','','1','081290562157','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2183','Parsaoran','Gultom','Parsaoran Gultom','gultom.parsaoran1986@gmail.com','','$2y$10$QJOC.KRJ2iwy.W3oRLpHuusDMZ4HI9CiBtGAuEL6K04rCqrbgHZNK','','','2','','1','\'081227693124','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2184','Santoso','','Santoso','santoso.rms55@gmail.com','','$2y$10$N0wc13mt7YUYyTlgmT4j9.wQckIo0XbXrqGwq3FSca6MY6WrUL5hG','','','2','','1','081311342428','','','','2024-02-06 09:52:11','2024-02-06 09:52:11','');
INSERT INTO users VALUES('2185','Safiyudin','','Safiyudin','safiyudin@gmail.com','','$2y$10$6POzsjiMEfel4hw02kQ7SO65t1umilAXDawuQes5Ou/E3IatT0t5y','','','2','','1','085311580122','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2186','Saprudin','','Saprudin','ariep321022@gmail.com','','$2y$10$gGNaznRZ8rjQ8mjy78w/0eD5vN1byulvsmrqp/2462N2/2rQDiBSy','','','2','','1','085946793917','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2187','Muchtar','','Muchtar ','muchtar1766@gmail.com','','$2y$10$2R92RwYQNypwBZyFui94WuJpdJ0gqk7US87Bz1WFBMasqadeX9QQW','','','2','','1','087771748372','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2188','Dady','Rosyadi ','Dady Rosyadi ','dadyrosyadi14@gmail.com','','$2y$10$1IK74ieaOmjiToZahr3ARO4Jz4ztX2rJMTYjFujMHxJQmCwesOtw6','','','2','','1','08952790225','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2189','Rahmattuloh','','Rahmattuloh','SANUNRAHMAT@gmail.com','','$2y$10$1YVst9.zDKws1tDCZ1nZqeXm7UYNw8O1ZM/jS7mZUpMTuZm.A45Ta','','','2','','1','081317516084','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2190','Dimas','Candra Girisona','Dimas Candra Girisona','dimaschandragirisona@gmail.com','','$2y$10$1UUwHEgv3AsNEKkWn7gew.2g12DDoeeuVcN5dqIZbVkD8l8KZta3q','','','2','','1','081293317538','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2191','Paryanto','','Paryanto','blegohkelana123@gmail.com','','$2y$10$4RKWD1FjEfvs.mN8jRQ73uyabvEykmBfqNyZkd.ok8mIrNlklJczO','','','2','','1','081218061895','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2192','Erik','Extrada ','Erik Extrada ','eextrada05@gmail.com','','$2y$10$5y.B5R9LZTXitF6RV0GHBeZ.T.b8iJO4oabXXPYc28ORKPa91s2dq','','','2','','1','089529917134','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2193','Nanang','Farid Ariyanto','Nanang Farid Ariyanto','nanang.farid@gmail.com','','$2y$10$RbZiwRwV1oAVnzaCCyidHOhbI6GKLMvej8sKp5tBwzLXpjBMN5DtO','','','2','','1','081335306888','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2194','Mochamad','Su\'Udi','Mochamad Su\'Udi','moch.suudi08@gmail.com','','$2y$10$R8941AEpVf/oOc2oUVzYCOe5tVSs0phPY85ShFzz.LoqnN4RLU8NG','','','2','','1','081310908261','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2195','Amin','','Amin','djadiputra514@gmail.cpm','','$2y$10$xJnDhE3h96.V9X9Jyp.DduW1rbJx49igaq/QyNnLdG6KrcV./FoM6','','','2','','1','085216957457','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2196','Antoni','','Antoni','antonichebungsu@gmail.co','','$2y$10$EfnJhOs5ylM5.7pC8fkco.7XiBlm0wBl6EahQCW9pWqChy2fvjMdu','','','2','','1','083842150483','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2197','Muhammad','Ridwan Amin','Muhammad Ridwan Amin','ridwan4892@gmail.com','','$2y$10$zFdragjNm9KQjkY6G8O7CutTCHd.tBB.l0SrzDe8ep3FDkcD3PRBy','','','2','','1','082122270017 / ','','','','2024-02-06 09:52:12','2024-02-06 09:52:12','');
INSERT INTO users VALUES('2198','Aris','Susanto ','Aris Susanto ','arissusanto2938@gmail.com','','$2y$10$dHMhcQNVE8cq1WrUt3uI6.0v.u2TcGUKOmqkgpaeiisTn4FXcHlNW','','','2','','1','083826968420','','','','2024-02-06 09:52:13','2024-02-06 09:52:13','');
INSERT INTO users VALUES('2199','Sudarwan','','Sudarwan','sudarwan@gmail.com','','$2y$10$xeIWXqTh5eAH.kdzTaK4tOBJJScQyBGPVZG5U.8.V.teVPQ9hbb2y','','','2','','1','081296697862','','','','2024-02-06 09:52:13','2024-02-06 09:52:13','');
INSERT INTO users VALUES('2200','Manap','','Manap','Msabymanap01@gmail.com','','$2y$10$wdrXx3gqrnEXPT0TVrikV.ZsqOhMyYg5bK6eyaiGw8y.Sr8qPxrly','','','2','','1','083808510377','','','','2024-02-06 09:52:13','2024-02-06 09:52:13','');
INSERT INTO users VALUES('2201','Wahyu','Dwi Saputra','Wahyu Dwi Saputra','wahyuwahyul2003@gmail.com','','$2y$10$TW62hAmib..pSGesM9bave5uNoC.T5p18vBmQqsE7f2RBpetervfC','','','2','','1','085229332286','','','','2024-02-06 09:52:13','2024-02-06 09:52:13','');
INSERT INTO users VALUES('2202','Moh','Sudari Wibowo','Moh Sudari Wibowo','mohsudari698@gmail.com','','$2y$10$4vRX71UymNB7SknnxuvBxuBhNcYUsqq/r2hr.lpgx5hDTwWsYY/f6','','','2','','1','081319698280','','','','2024-02-06 09:52:13','2024-02-06 09:52:13','');
INSERT INTO users VALUES('2203','A.Hafidullah','','A.Hafidullah','ahmadhafid548@gmail.com','','$2y$10$H8mrXkr5wD1IUdS3iPbca.Fyf77ZwgTaeVLVmaOIk0oQrXRg1VDeO','','','2','','1','085215799454','','','','2024-02-06 09:52:13','2024-02-06 09:52:13','');
INSERT INTO users VALUES('2204','Sahroni','','Sahroni','sahroniaduai409@gmail.com','','$2y$10$2.X932VG1xraXphYDaRIp.9G1fKqKBUY4R7d8GSCb1IYAi8jZHrB2','','','2','','1','081291845422','','','','2024-02-06 09:52:13','2024-02-06 09:52:13','');
INSERT INTO users VALUES('2205','Bintang','Chanensya','Bintang Chanensya','zeyyyyuss@gmail.com','','$2y$10$6Z40bX0EymhQOetFbGQZp.3nCai055BEZf5tK9/uW/cgCi6jwXaea','','','2','','1','081212259113','','','','2024-02-06 09:52:13','2024-02-06 09:52:13','');
INSERT INTO users VALUES('2206','Kamsarudin','','Kamsarudin','ilhamrakaboom92@gmail.com','','$2y$10$vyt2hqRESOs2NELzHUQqWOukY3HKhque9ClMJlKun0SkBJda.3MAy','','','2','','1','082122189601','','','','2024-02-06 09:52:13','2024-02-06 09:52:13','');
INSERT INTO users VALUES('2207','Zulkifli','','Zulkifli','falskipli@gmail.com','','$2y$10$Ni8/TzdF1qbkg2whaBYm5eKxKzJXYxRYIl3QNgSMg4zPXZBJpwNAC','','','2','','1','088293046543','','','','2024-02-06 09:52:13','2024-02-06 09:52:13','');
INSERT INTO users VALUES('2208','Admin 1','RAPP SITE','newhr-rapp','newhr@timas.com','','$2y$10$.YN0AtCzfwXx8qPsW6rN0.mvBLp4ZR0LT4u0BCg2zL9bkUsN/z3Gq','newhr-rapp_1707275948.png','','6','[2]','1','085266258124','27.121.84.42','2024-02-21 13:10:46.00','','2024-02-06 10:07:13','2024-02-07 10:19:08','');
INSERT INTO users VALUES('2209','AZMANDA','AZMANDA','aa9107','azmanda@timas.com','','$2y$10$U6QERweQlC2xuQkaKxxl5ORLPdAgcdZPZ1gvJy5rToO9Onm8.LQLm','','','2','','1','','103.113.77.126','2024-02-06 14:08:55.00','','2024-02-06 11:53:47','2024-02-06 11:53:47','');
INSERT INTO users VALUES('2210','testing','new','aab9108','admin@rekret.com','','$2y$10$5X5S0isnCSUTqiXzSQYFd.7S3DJaFKEvZwM7GhlyqYmp87h1dMKke','','','2','','1','','','','','2024-02-06 12:04:06','2024-02-06 12:04:06','');
INSERT INTO users VALUES('2211','ARIF RAHMAN SETIA','RAMADANI','ae00570','arif.rahman@timas.com','','$2y$10$ytRtu2ZC2idbYb7n.GGw1eLroJ49Cm8XKrJ25WDMRAz5dfqwiJJb2','ae00570_1707272587.jpg','','2','','1','082373325808','103.113.77.126','2024-02-07 15:04:56.00','','2024-02-07 08:33:46','2024-02-07 09:23:07','');
INSERT INTO users VALUES('2212','DWITAMI','Wulandari','aa9105','dwitami.wulandari@timas.com','','$2y$10$goayYO/4B3mlOK/HnsrK.eBbY.gwpcvqEtIvKVUwpke9SG2iuwXSq','aa9105_1707275574.PNG','','2','','1','0859595894649','','','','2024-02-07 10:07:30','2024-02-23 14:02:24','');
INSERT INTO users VALUES('2213','DWITAMI','WULANDARI','ae9109','dwitami.wulandari@timas.com','','$2y$10$8qCmxZgQ8mMnVzt96ukA7uTJSk935i/YnS6WPC06IXWK/WQgdbaCe','','','2','','1','','','','','2024-02-20 21:02:03','2024-02-20 21:02:03','');
INSERT INTO users VALUES('2214','HR','FABRICATION SHOP','hr - fabshop','','','$2y$10$rLzPWVZS1LQZNhKcVhXq.ecmv9byEaKxzG8nSU6qIF9pJTn/ipsR6','','','6','[3]','1','','103.113.77.126','2024-02-26 08:36:33.00','','2024-02-22 13:09:41','2024-02-22 13:09:41','');
INSERT INTO users VALUES('2215','first','last','testusername','test007@gmail.com','','$2y$10$mxrviB.IIKpP6TbPofnckuW7bAvdCaocAZ3IZCv.wtwjGlCULEXTu','','','2','','1','4536267','','','','2024-02-23 07:52:33','2024-02-23 07:52:33','');
INSERT INTO users VALUES('2223','Dede','Rohayah','aa9110','dede.rohayah@timas.com','','$2y$10$QJjWEjWtHBalswjERTF1lOrtWKmotUKM.dn3pTDOVfhoYg/JED1W6','','','2','','1','','','','','2024-02-23 16:19:48','2024-02-23 16:19:48','');
INSERT INTO users VALUES('2226','Agus ','Budi','AB00555','agus.budi@timas.com','','$2y$10$6ZqWVwW1PweWTBqML7sP8uIy49OL2X34jh8rsPaLzi.b6HyTW0qr.','','','2','','1','1880147703','182.253.56.96','2024-02-26 17:14:44.00','','2024-02-26 08:46:53','2024-02-26 08:46:53','');
INSERT INTO users VALUES('2227','Budi ','Yanto','AB00556','budi.yanto@timas.com','','$2y$10$hM9jHh5DNcnMsOhkPrea/ujGLieEv61LNOEhjEBKncZvip6GwpQ/a','','','2','','1','1880147704','','','','2024-02-26 08:46:53','2024-02-26 08:46:53','');
INSERT INTO users VALUES('2228','Dwi Ayu ','Lestari ','AB00557','dwi.lestari@timas.com','','$2y$10$AGv7SQVwtom7gUQGfUVLQeoAILeqxwrOpRe0KVAt9xqLwLCO8F5mG','','','2','','1','1880147705','','','','2024-02-26 08:46:53','2024-02-26 08:46:53','');
INSERT INTO users VALUES('2229','Ayu ','Cahya','AB00558','ayu.cahya@timas.com','','$2y$10$1i89VFPglACG4acAz1HpduGg31DeQs2Ue5svShRrbWBwRh6itrg1m','','','2','','1','1880147706','','','','2024-02-26 08:46:54','2024-02-26 08:46:54','');
INSERT INTO users VALUES('2230','Muhammad ','Bayu ','AB00559','muhammad.bayu@timas.com','','$2y$10$urrYbWIzkhr6pQgU1ueeeO3/eFcQSHywx3oN3.HZWw1pACLslL/.G','','','2','','1','1880147707','','','','2024-02-26 08:46:54','2024-02-26 08:46:54','');
INSERT INTO users VALUES('2231','Faleidas AMC','Pereira','aa9111','lulu.faleidas@timas.com','','$2y$10$YtXE/2880Dq1jX58tuia6OzJfse02.X4t/2wq/WaDXuBWrW9ZbVXq','','','2','','1','','103.113.77.126','2024-02-26 11:04:33.00','','2024-02-26 10:23:09','2024-02-26 10:23:09','');



CREATE TABLE `warnings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `warning_to` bigint(20) unsigned NOT NULL,
  `warning_type` bigint(20) unsigned DEFAULT NULL,
  `warning_date` date NOT NULL,
  `status` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warnings_company_id_foreign` (`company_id`),
  KEY `warnings_warning_to_foreign` (`warning_to`),
  KEY `warnings_warning_type_foreign` (`warning_type`),
  CONSTRAINT `warnings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `warnings_warning_to_foreign` FOREIGN KEY (`warning_to`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `warnings_warning_type_foreign` FOREIGN KEY (`warning_type`) REFERENCES `warnings_type` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `warnings_type` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warning_title` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


SET foreign_key_checks = 1;