<?php

namespace App\Console\Commands;

use App\Attendance;
use App\company;
use App\Mail\DailyReportAttendanceMail;
use App\MailReceiver;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class DailyReportAttendance extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mail:dailyReportAttendance';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send mail about daily report attendance';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $yesterday = Carbon::yesterday();
        $companies = company::get();

        foreach ($companies as $company) {
            $attendances = Attendance::whereHas('employee', function ($query) use ($company) {
                return $query->where('company_id', $company->id);
            })->with('employee.department')->whereDate('attendance_date', '=', $yesterday)->get();

            $receivers = MailReceiver::whereHas('employee', function ($query) use ($company) {
                return $query->where('company_id', '=', $company->id);
            })->get()->pluck('employee.email');

            Mail::to($receivers)->send(new DailyReportAttendanceMail($attendances));
        }
    }
}
