<?php

namespace App\Console\Commands;

use App\Employee;
use App\Mail\EmployeeContractReminderMail;
use App\MailReceiver;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class EmployeeContractReminder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mail:employeeContract';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send mail when employee contract in last three months';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $now = Carbon::now();
        $employeeContracts = Employee::with('company')->where('status_id', 5)->whereDate('exit_date', '<', $now->addMonths(3))->get();

        foreach ($employeeContracts as $employee) {
            $receivers = MailReceiver::whereHas('employee', function ($query) use ($employee) {
                return $query->where('company_id', '=', $employee->company_id);
            })->get()->pluck('employee.email');
            
            Mail::to($receivers)->send(new EmployeeContractReminderMail($employee, $employee->company->company_logo));
        }
    }
}
