<?php

namespace App\Console\Commands;

use App\Employee;
use Carbon\Carbon;
use Illuminate\Console\Command;

class NewYearLeave extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'leave:newYear';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Add new yearly leave';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $date = Carbon::now()->subYear()->addMonth(); //Feb Last Year
        $employees = Employee::with('company')->whereDate('joining_date', '<', $date)->get();
        foreach ($employees as $employee) {
            $employee->last_year_leave = $employee->remaining_leave;
            $employee->remaining_leave = $employee->remaining_leave + $employee->company->leave_amount;
            $employee->save();
        }
    }
}
