<?php

namespace App\Console\Commands;

use App\Employee;
use Illuminate\Console\Command;

class ResetLastYearLeave extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'leave:resetLastYear';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Reset last year leave every july';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $employees = Employee::get();
        foreach ($employees as $employee) {
            if($employee->last_year_leave > 0){
                $employee->remaining_leave = $employee->remaining_leave - $employee->last_year_leave;
                $employee->last_year_leave = 0;
                $employee->save();
            }
        }
    }
}
