<?php

namespace App\Exports;

use App\Company;
use App\Department;
use App\Employee;
use App\Holiday;
use App\leave;
use App\ReportAttendance;
use App\SalaryBasic;
use App\Payslip;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class PayslipExport implements FromView, ShouldAutoSize, WithStyles
{

    public function view(): View
    {
        $request = request();
        $selected_date = request('month', now()->format('F-Y'));
		$first_date = date('Y-m-d', strtotime('first day of ' . $selected_date));
		$last_date = date('Y-m-d', strtotime('last day of ' . $selected_date));
        $salary_basic_employees = SalaryBasic::where('first_date', '<=', $first_date)->distinct()->pluck('employee_id');
        $paid_employees = Payslip::where('month_year', $selected_date)->pluck('employee_id');
        $query = Employee::with([
		    'salaryBasic' => function ($query) {
			    $query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
		    },
		    'allowances' => function ($query) {
			    $query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
		    },
		    'commissions' => function ($query) use ($first_date) {
			    $query->where('first_date', $first_date);
		    },
		    'loans' => function ($query) use ($first_date) {
			    $query->where('first_date', '<=', $first_date)
                ->where('amount_remaining', '!=', 0)
				    ->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
		    },
		    'deductions' => function ($query) {
			    $query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
		    },
		    'otherPayments' => function ($query) use ($first_date) {
			    $query->where('first_date', $first_date);
		    },
		    'overtimes' => function ($query) use ($selected_date) {
			    $query->where('month_year', $selected_date);
		    },
		    'payslips' => function ($query) use ($selected_date) {
			    $query->where('month_year', $selected_date);
		    },
		    'designation', 'department', 'user', 'setting',
			'employeeAttendance' => function ($query) use ($first_date, $last_date) {
				$query->whereBetween('attendance_date', [$first_date, $last_date]);
			},
            'user:id,username', 'company.Location.country',
			'department:id,department_name', 'designation:id,designation_name',
	    ])
		->select('employees.id', 'employees.company_id', 'employees.marital_status', 'employees.first_name', 'employees.last_name', 'employees.basic_salary', 'employees.basic_salary_custom', 'employees.payslip_type', 'employees.designation_id', 'employees.department_id', 'employees.pension_type', 'employees.pension_amount', 'employees.dependent', 'ptkp.value as ptkp')
        ->leftjoin('ptkp', [
            'employees.company_id' => 'ptkp.company_id',
            'employees.dependent' => 'ptkp.name'
        ])
		->whereIntegerInRaw('employees.id', $salary_basic_employees)
		->where('employees.is_active', 1)
		->where('employees.exit_date', NULL);
        if (!empty($request->filter_company && $request->filter_department)) {
            $employees = $query->where('employees.company_id', $request->filter_company)->where('employees.department_id', $request->filter_department)->get();
            $company['name'] = Company::find($request->filter_company)->company_name;
            $company['department'] = Department::find($request->filter_department)->department_name;
        } elseif (!empty($request->filter_company)) {
            $employees = $query->where('employees.company_id', $request->filter_company)->get();
            $company['name'] = Company::find($request->filter_company)->company_name;
            $company['department'] = 'ALl Department';
        } else {
            $employees = $query->get();
            $company = null;
        }
        
        // return view('payslip.report_attendances.export', compact('dates', 'datas', 'last_month', 'holidays'));
        return view('salary.pay_list.export_payslip', compact('selected_date', 'first_date', 'employees', 'company'));
    }

    public function styles(Worksheet $sheet)
    {
        $request = request();
        $lastRow = $sheet->getHighestRow();
        $lastColumn = $sheet->getHighestColumn();
        if(!empty($request->filter_company && $request->filter_department)) {
            $range = 'A5:' . $lastColumn . $lastRow;
        } elseif(!empty($request->filter_company)) {
            $range = 'A5:' . $lastColumn . $lastRow;
        } else {
            $range = 'A2:' . $lastColumn . $lastRow;
        }
        return [
            // Style the first row as bold text.
            1    => ['font' => ['bold' => true]],
            2    => ['font' => ['bold' => true]],
            $range => [
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => ['argb' => '000000'], // Black color
                    ],
                ],
            ],
        ];
    }

}
