<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Employee;
use App\leave;
use App\LeaveType;
use App\Notifications\EmployeeLeaveNotification; //Mail
use App\Notifications\LeaveNotification; //Database
use App\Notifications\LeaveNotificationToAdmin; //Database
use App\User;

use App\company;
use App\Holiday;
use App\department;
use App\office_shift;

use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Response;

class LeaveController extends Controller
{
    public function index() {
		$leave = Leave::where('employee_id', Auth::user()->id)->get();
		return Response::json($leave, 200);
	}

    public function list_approval(Request $request)
	{
		// Get the currently authenticated user
		$logged_user = auth()->user();
		$employee = Employee::find($logged_user->id);
        
        if($employee->supervisor == 0 && $employee->dept_head == 0)
        {
            $paginatedLeaves = array();
            return Response::json($paginatedLeaves, 200);
        }
        
		// Default pagination values
		$perPage = $request->input('limit', 10); // Default to 10 items per page
		$page = $request->input('page', 1); // Default to page 1

		// Start building the query with relationships
		$leave = Leave::with('employee', 'department', 'LeaveType');

		// Supervisor specific logic
		if (isset($employee->supervisor) && $employee->supervisor == 1) {
			$leave = $leave->whereHas('employee', function($query) {
				$query->where('dept_head', 0)->where('supervisor', 0)->where('coo', 0);
			})->where('department_id', $employee->department_id);
		}

		// Dept Head specific logic
		if (isset($employee->dept_head) && $employee->dept_head == 1) {
			$leave = $leave->whereHas('employee', function($query) {
				$query->where('dept_head', 0)->where('coo', 0);
			})->where('department_id', $employee->department_id);
		}

		// COO specific logic
		if (isset($employee->coo) && $employee->coo == 1) {
			$leave = $leave->whereHas('employee', function($query) {
				$query->where('coo', 0);
			})->where('company_id', $employee->company_id);
		}
    
		// Apply pagination
		$paginatedLeaves = $leave->paginate($perPage, ['*'], 'page', $page);

		// Return the paginated response as JSON
		return Response::json($paginatedLeaves, 200);
	}

    public function add(Request $request) {
		$validator = Validator::make(
			$request->only('leave_type', 'start_date', 'end_date', 'total_days'),
			[
				'leave_type' => 'required',
				'total_days' => 'required',
				'start_date' => 'required',
				'end_date' => 'required|after_or_equal:start_date'
			]
		);
		if ($validator->fails()) {
			return response()->json(['success' => false, 'errors' => $validator->errors()->all()]);
		}

		$leave = LeaveType::findOrFail($request->leave_type);
		$employee = Employee::find(Auth::user()->id);
		$employee2 = leave::where('employee_id', $employee->id)
				->where('leave_type_id', $request->leave_type);
		
		if ($employee2->exists()) {
			$total = 0;
			$employee_leaves = $employee2->get();

			foreach ($employee_leaves as $employee_leave) {
				$total = $total + $employee_leave->total_days;
			}
			$total = $total + $request->diff_date_hidden;

			if ($leave->allocated_day != null && $leave->allocated_day < $total) {
				return response()->json(['success' => false, 'errors' => __('Allocated quota for this leave type is less then requested days for this employee')]);
			}
		} else {
			if ($leave->allocated_day != null && $leave->allocated_day < $request->diff_date_hidden) {
				return response()->json(['success' => false, 'errors' => __('Allocated quota for this leave type is less then requested days,You can select manual')]);
			}
		}


		$data = [];
		$data['employee_id'] = $employee->id;
		$data['company_id'] = $employee->company_id;
		$data['department_id'] = $employee->department_id;
		$data['leave_type_id'] = $request->leave_type;
		$data['leave_reason'] = $request->leave_reason;
		$data['remarks'] = $request->remarks;
		$data['status'] = 'pending';
		$data['is_half'] = $request->is_half;
		$data['is_notify'] = $request->is_notify;
		$data['start_date'] = $request->start_date;
		$data['end_date'] = $request->end_date;
		$data['total_days'] = $total;

		//Employee Remaining Leave --- Start
		$employee_leave_info = Employee::find($employee->id);
		if ($request->total_days > $employee_leave_info->remaining_leave) {
			return response()->json(['success' => false, 'errors' => "The employee's remaining leaves are insufficient"]);
		}
		//Employee Remaining Leave  --- End


		$leave = leave::create($data);

		if ($leave->is_notify == 1) {
			$text = "A new leave-notification has been requested by ". $employee_leave_info->first_name ." ".$employee_leave_info->last_name;
			$notifiable = User::findOrFail($data['employee_id']);
			$notifiable->notify(new LeaveNotification($text)); //To Employee

			//Get All HR
			$companyId = $employee_leave_info->company_id;
			$HR_user = User::whereJsonContains('company_ids', $companyId)->get();
			if($HR_user->count() > 0)
			{
				foreach($HR_user as $hr){
					$hr->notify(new LeaveNotification($text));
					
					if(!empty($hr->email))
					{
						Notification::route('mail', $hr->email)
						->notify(new EmployeeLeaveNotification(
							$leave->employee->full_name,
							$leave->total_days,
							$leave->start_date,
							$leave->end_date,
							$leave->leave_reason,
						));
					}
				}
			}

		} elseif ((Auth::user()->role_users_id != 1) && ($leave->is_notify == NULL)) {
			//get-leave-notification - 294
			$role_ids = DB::table('role_has_permissions')->where('permission_id', 294)->get()->pluck('role_id');
			$role_ids[] = 1;

			$notifiable = User::whereIn('role_users_id', $role_ids)->get();
			foreach ($notifiable as $item) {
				$item->notify(new LeaveNotificationToAdmin());
			}

			//Mail
			$department = department::with('DepartmentHead:id,email')->where('id', $request->department_id)->first();

			//Get All HR
			$companyId = $employee_leave_info->company_id;
			$HR_user = User::whereJsonContains('company_ids', $companyId)->get();
			if($HR_user->count() > 0)
			{
				foreach($HR_user as $hr){
					if(!empty($hr->email))
					{
						$text = "A new leave-notification has been requested by ". $employee_leave_info->first_name ." ".$employee_leave_info->last_name;
						$notifiable = User::findOrFail($hr->id);
						$notifiable->notify(new LeaveNotification($text)); //To HR
						Notification::route('mail', $hr->email)
						->notify(new EmployeeLeaveNotification(
							$leave->employee->full_name,
							$leave->total_days,
							$leave->start_date,
							$leave->end_date,
							$leave->leave_reason,
						));
					}
				}
			}

			if(!empty($department->DepartmentHead->email))
			{
				$text = "A new leave-notification has been requested by ". $employee_leave_info->first_name ." ".$employee_leave_info->last_name;
				$notifiable = User::findOrFail($department->department_head);
				$notifiable->notify(new LeaveNotification($text)); //To Department Head
				Notification::route('mail', $department->DepartmentHead->email)
					->notify(new EmployeeLeaveNotification(
						$leave->employee->full_name,
						$leave->total_days,
						$leave->start_date,
						$leave->end_date,
						$leave->leave_reason,
					));
			}

			if(!empty($department->supervisor)) {
				$text = "A new leave-notification has been requested by ". $employee_leave_info->first_name ." ".$employee_leave_info->last_name;
				$notifiable = User::findOrFail($department->supervisor);
				$notifiable->notify(new LeaveNotification($text)); //To Supervisor
			}
		}

		return response()->json(['success' => true, 'message' => __('Data Added successfully.')]);
	}
	
	public function update(Request $request)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('edit-leave')) {
			$id = $request->id;
			$validator = Validator::make(
				$request->only(
                    'id',
					'employee_id',
					'status',
				),
				[   'id' => 'required',
					'employee_id' => 'required',
					'status' => 'required',
				]
			);
			if ($validator->fails()) {
				return response()->json(['errors' => $validator->errors()->all()]);
			}

			# Checking Supervior and manager
			if ($request->status) {
				$current_employee = Employee::find($logged_user->id);
				$requester_employee = Employee::find($request->employee_id);
				$checking_leave = leave::find($id);

				if(!$logged_user->hasRole('admin')) {
					if($current_employee->dept_head == 1 && $checking_leave->status != "first level approval" && $requester_employee->supervisor != 1)
					{
						return response()->json(['error' => __('Manager allowed to approved first level approval and supervisor request')]);
					}
					elseif($current_employee->supervisor == 1 && ($checking_leave->status != "pending" || $checking_leave->status == "first level approval"))
					{
					    return response()->json(['error' => __('Supervisor only allowed to first level approval')]);
					}
				}
				$data['status'] = $request->status;
			}

			$employee = leave::where('id', '!=', $id)
					->where('employee_id', $request->employee_id)->first();
			$leave = LeaveType::findOrFail($employee->leave_type_id);

			####CALCULATE TOTAL LEAVE DAYS###########
			$karyawan = Employee::find($request->employee_id);
			$start_date = Carbon::parse($employee->start_date);
			$end_date = Carbon::parse($employee->end_date);
			$office_shift = office_shift::find($karyawan->office_shift_id); // Asumsikan ada satu shift yang digunakan
			$workdays = [];
			if ($office_shift->monday_in) {
				$workdays[] = Carbon::MONDAY;
			}
			if ($office_shift->tuesday_in) {
				$workdays[] = Carbon::TUESDAY;
			}
			if ($office_shift->wednesday_in) {
				$workdays[] = Carbon::WEDNESDAY;
			}
			if ($office_shift->thursday_in) {
				$workdays[] = Carbon::THURSDAY;
			}
			if ($office_shift->friday_in) {
				$workdays[] = Carbon::FRIDAY;
			}
			if ($office_shift->saturday_in) {
				$workdays[] = Carbon::SATURDAY;
			}
			if ($office_shift->sunday_in) {
				$workdays[] = Carbon::SUNDAY;
			}

			// Ambil data hari libur nasional
			$holidays = Holiday::where(function ($query) use ($start_date, $end_date) {
				$query->whereBetween('start_date', [$start_date, $end_date])
					->orWhereBetween('end_date', [$start_date, $end_date])
					->orWhere(function ($query) use ($start_date, $end_date) {
						$query->where('start_date', '<=', $start_date)
							->where('end_date', '>=', $end_date);
					});
			})->get();

			$total_leave_days = 0;

			for ($date = $start_date; $date->lte($end_date); $date->addDay()) {
				if (in_array($date->dayOfWeek, $workdays)) {
					// Cek apakah tanggal ini merupakan hari libur nasional
					$isHoliday = $holidays->contains(function ($holiday) use ($date) {
						return $date->between($holiday->start_date, $holiday->end_date);
					});

					if (!$isHoliday) {
						$total_leave_days++;
					}
				}
			}
			########END CALCULATE TOTAL LEAVE##########
			
            $total_leave_days = $checking_leave->total_days; 
            
			if (!empty($employee)) {
				$total = 0;
				$employee_leaves = $employee->get();

				foreach ($employee_leaves as $employee_leave) {
					$total = $total + $employee_leave->total_days;
				}
				$total = $total + $total_leave_days;

				if ($leave->allocated_day != null && $leave->allocated_day < $total) {
					return response()->json(['limit' => __('Allocated quota for this leave type is less then requested days for this employee')]);
				}
			} else {
				if ($leave->allocated_day != null && $leave->allocated_day < $request->diff_date_hidden) {
					return response()->json(['limit' => __('Allocated quota for this leave type is less then requested days,You can select manual')]);
				}
			}

			$data = [];
			$data['employee_id'] = $request->employee_id;
			$data['status'] = $request->status ?? 'pending';

			//Employee Remaining Leave --- Start
			$employee_leave_info = Employee::find($request->employee_id);
			if ($total_leave_days > $employee_leave_info->remaining_leave && $employee->leave_type_id == 3 && $employee->leave_type_id == 5) {
				return response()->json(['remaining_leave' => "The employee's remaining leaves are insufficient"]);
			} elseif ($request->status == 'approved') {
				if($checking_leave->leave_type_id == 3 || $checking_leave->leave_type_id == 5)
				{
					$employee_leave_info->remaining_leave = $employee_leave_info->remaining_leave - $total_leave_days;
				}
				$employee_leave_info->update();
			}
			//Employee Remaining Leave  --- End

			leave::find($id)->update($data);

			$text = "Your notification has been ". $data['status'];
			$notifiable = User::findOrFail($data['employee_id']);
			$notifiable->notify(new LeaveNotification($text)); //To Employee
			return response()->json(['success' => __('Data is successfully updated')]);
		}
		return response()->json(['success' => __('You are not authorized')]);
	}

//     public function update(Request $request)
// 	{
// 		$logged_user = auth()->user();

// 		if ($logged_user->can('edit-leave')) {
// 			$id = $request->id;
// 			$validator = Validator::make(
// 				$request->only(
//                     'id',
// 					'employee_id',
// 					'status',
// 				),
// 				[   'id' => 'required',
// 					'employee_id' => 'required',
// 					'status' => 'required',
// 				]
// 			);
// 			if ($validator->fails()) {
// 				return response()->json(['errors' => $validator->errors()->all()]);
// 			}
// 			$data = [];
// 			$data['employee_id'] = $request->employee_id;
// 			$data['status'] = $request->status ?? 'pending';

// 			leave::find($id)->update($data);
// 			$text = "Your notification has been ". $data['status'];
// 			$notifiable = User::findOrFail($data['employee_id']);
// 			$notifiable->notify(new LeaveNotification($text)); //To Employee
// 			return response()->json(['success' => __('Data is successfully updated')]);
// 		}
// 		return response()->json(['success' => __('You are not authorized')]);
// 	}
    
    public function leave_type(Request $request) {
		$leave_types = LeaveType::all();
		return response([ 'data' => $leave_types, 'success' => true], 200);
	}
}
