<?php

namespace App\Http\Controllers\API;

use Auth;
use App\User;
use App\Http\Controllers\Controller;
use App\Notifications\EmployeeLeaveNotification; //Mail
use App\Notifications\LeaveNotification; //Database
use App\Notifications\LeaveNotificationToAdmin; //Database
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\DB;

class NotificationController extends Controller
{
    public function index(Request $request)
    {
        // Default pagination values
        $perPage = $request->input('limit', 10); // Default to 10 notifications per page
        $page = $request->input('page', 1); // Default to page 1
    
        // Get the unread notifications count
        $notification = array();
        if (Auth::user()->unreadNotifications->count()) {
            $notification['unread'] = Auth::user()->unreadNotifications->count();
        } else {
            $notification['unread'] = 0;
        }
    
        // Paginate the notifications
        $notifications = Auth::user()->notifications()->paginate($perPage, ['*'], 'page', $page);
    
        // Add the paginated notifications to the response
        $notification['notifications'] = $notifications;
    
        // Return the response as JSON
        return response()->json($notification, 200);
    }
}
