<?php

namespace App\Http\Controllers\API;

use Auth;
use App\company;
use App\department;
use App\Employee;
use App\Travel;
use App\TravelType;
use App\User;
use App\Http\Controllers\Controller;
use App\Notifications\EmployeeTravelStatus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Response;

class TravelController extends Controller
{
    public function index()
	{
		$travel = Travel::where('employee_id', Auth::user()->id)->get();
		return Response::json($travel, 200);
	}

	public function list_approval(Request $request)
	{
		// Get the currently authenticated user
		$logged_user = auth()->user();
		$employee = Employee::find($logged_user->id);
        
        if($employee->supervisor == 0 && $employee->dept_head == 0)
        {
            $paginatedLeaves = array();
            return Response::json($paginatedLeaves, 200);
        }
        
		// Default pagination values
		$perPage = $request->input('limit', 10); // Default to 10 items per page
		$page = $request->input('page', 1); // Default to page 1

		// Start building the query with relationships
		$travel = Travel::with('employee', 'employee.company', 'travelType');

		// Supervisor-specific logic
		if (isset($employee->supervisor) && $employee->supervisor == 1) {
			$travel = $travel->whereHas('employee', function($query) use ($employee) {
				$query->where('dept_head', 0)->where('supervisor', 0)->where('coo', 0)
					->where('department_id', $employee->department_id);
			});
		}

		// Dept Head-specific logic
		if (isset($employee->dept_head) && $employee->dept_head == 1) {
			$travel = $travel->whereHas('employee', function($query) use ($employee) {
				$query->where('dept_head', 0)->where('coo', 0)
					->where('department_id', $employee->department_id);
			});
		}

		// COO-specific logic
		if (isset($employee->coo) && $employee->coo == 1) {
			$travel = $travel->whereHas('employee', function($query) use ($employee) {
				$query->where('coo', 0)
					->where('company_id', $employee->company_id);
			});
		}

		// Apply pagination
		$paginatedTravel = $travel->paginate($perPage, ['*'], 'page', $page);

		// Return the paginated response as JSON
		return Response::json($paginatedTravel, 200);
	}

    public function update(Request $request)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('edit-travel')) {
			$id = $request->id;

			$validator = Validator::make(
				$request->only(
                    'id',
                    'employee_id',
                ),
                [
                    'id' => 'required',
                    'employee_id' => 'required',
                ]
			);


			if ($validator->fails()) {
				return response()->json(['errors' => $validator->errors()->all()]);
			}

			$current_employee = Employee::find($logged_user->id);
			$requester_employee = Employee::find($request->employee_id);
            if(!$logged_user->hasRole('admin')) {
                if($current_employee->dept_head == 1 && $checking_leave->status != "first level approval" && $requester_employee->supervisor != 1)
                {
                    return response()->json(['limit' => __('Manager allowed to approved first level approval and supervisor request')]);
                }
                elseif($current_employee->supervisor == 1 && ($checking_leave->status != "pending" || $checking_leave->status == "first level approval"))
				{
				    return response()->json(['error' => __('Supervisor only allowed to first level approval')]);
				}
            }

			$data = [];
            $data['employee_id'] = $request->employee_id;
			$data['status'] = $request->status ?? 'pending';

			Travel::find($id)->update($data);

			if ($data['status'] != 'pending') {
				$notifiable = User::findOrFail($data['employee_id']);

				$notifiable->notify(new EmployeeTravelStatus($data['status']));
			}

			return response()->json(['success' => __('Data is successfully updated')]);
		} else {

			return response()->json(['success' => __('You are not authorized')]);
		}
	}

	public function store(Request $request) {

	}

	public function travel_type() {
		
	}
}
