<?php

namespace App\Http\Controllers;

use App\company;
use App\department;
use App\Employee;
use App\Holiday;
use App\leave;
use App\LeaveType;
use App\office_shift;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Validator;

//Notification
use App\Notifications\EmployeeLeaveNotification; //Mail
use App\Notifications\LeaveNotification; //Database
use App\Notifications\LeaveNotificationToAdmin; //Database
use App\User;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class LeaveController extends Controller
{

	public function index()
	{
		$logged_user = auth()->user();
		$companyId = null;
        if ($logged_user->role_users_id == 6) {
            $companyId = json_decode($logged_user->company_ids);
        }
        else
		{
			$companyId[] = $logged_user->company_ids;
		}
        
        if ($logged_user->role_users_id == 1)
        {
            $companies = company::select('id', 'company_name')->get();
        }
        else
        {
            $companies = company::select('id', 'company_name')->whereIn('id', $companyId)->get();   
        }

		$leave_types = LeaveType::select('id', 'leave_type', 'allocated_day')->get();
		$leave = leave::with('employee', 'department', 'LeaveType');
		
		$employee = Employee::find($logged_user->id);
		if($logged_user->role_users_id != 1)
		{
    		if ($companyId) {
    			$leave = $leave->whereIn('company_id', $companyId);
    		}
    		
    		if ($logged_user->role_users_id == 6) {
    			$leave = $leave->whereIn('company_id', $companyId);
    		}
    
    		if(isset($employee->supervisor) AND ($employee->supervisor == 1)) {
    			$leave = $leave->whereHas('employee', function($query) {
    				$query->where('dept_head', 0)->where('supervisor', 0)->where('coo', 0);
    			})->where('department_id', $employee->department_id);
    		}
    
    		if(isset($employee->dept_head) AND ($employee->dept_head == 1)) {
    			$leave = $leave->whereHas('employee', function($query) {
    				$query->where('dept_head', 0)->where('coo', 0);
    			})->where('department_id', $employee->department_id);
    		}
    
    		if(isset($employee->coo) AND ($employee->coo == 1)) {
    			$leave = $leave->whereHas('employee', function($query) {
    				$query->where('coo', 0);
    			})->where('company_id', $employee->company_id);
    		}
		}
        
        $leave = $leave->orderBy('created_at', 'DESC');
        
		if ($logged_user->can('view-leave')) {
			if (request()->ajax()) {
				return datatables()->of($leave->get())
				->setRowId(function ($row) {
					return $row->id;
				})
				->addColumn('leave_type', function ($row) {
					return $row->LeaveType->leave_type ?? '';
				})
				->addColumn('department', function ($row) {
					return $row->department->department_name ?? '';
				})
				->addColumn('employee', function ($row) {
					return $row->employee->full_name ?? '';
				})
				->addColumn('action', function ($data) {
					$button = '<button type="button" name="show" id="' . $data->id . '" class="show_new btn btn-success btn-sm"><i class="dripicons-preview"></i></button>';
					$button .= '&nbsp;&nbsp;';
					if (auth()->user()->can('edit-leave')) {
						$button .= '<button type="button" name="edit" id="' . $data->id . '" class="edit btn btn-primary btn-sm"><i class="dripicons-pencil"></i></button>';
						$button .= '&nbsp;&nbsp;';
					}
					if (auth()->user()->can('delete-leave')) {
						$button .= '<button type="button" name="delete" id="' . $data->id . '" class="delete btn btn-danger btn-sm"><i class="dripicons-trash"></i></button>';
					}
					return $button;
				})
				->rawColumns(['action'])
				->make(true);
			}

			return view('timesheet.leave.index', compact('companies', 'leave_types', 'employee'));
		}

		return abort('403', __('You are not authorized'));
	}

	public function store(Request $request)
	{
		if (auth()->user()->can('store-leave') || auth()->user()) {
			$user = auth()->user();

			$validator = Validator::make(
				$request->only('leave_type', 'company_id', 'department_id', 'employee_id', 'start_date', 'end_date', 'status'),
				[
					'company_id' => 'required',
					// 'department_id' => 'required',
					// 'employee_id' => 'required',
					'leave_type' => 'required',
					'status' => 'required',
					'start_date' => 'required',
					'end_date' => 'required|after_or_equal:start_date'
				]
			);

			if ($validator->fails()) {
				return response()->json(['errors' => $validator->errors()->all()]);
			}

			$leave = LeaveType::findOrFail($request->leave_type);

			####CALCULATE TOTAL LEAVE DAYS###########
			if(!empty($request->employee_id))
			{
				$karyawan = Employee::find($request->employee_id);
			}
			else
			{
				if(empty($request->department_id))
				{
					$karyawan = Employee::where('company_id', $request->company_id)->where('is_active', 1)->get();
				}
				else
				{
					$karyawan = Employee::where('company_id', $request->company_id)->where('department_id', $request->department_id)->where('is_active', 1)->get();
				}
			}

			$start_date = Carbon::parse($request->start_date);
    		$end_date = Carbon::parse($request->end_date);
			
			if(empty($request->employee_id))
			{
				$total_leave_days = 0;

				#for all eemployee
				foreach($karyawan as $karyawan)
				{
					$office_shift = office_shift::find($karyawan->office_shift_id); // Asumsikan ada satu shift yang digunakan
					$workdays = [];
					if ($office_shift->monday_in) {
						$workdays[] = Carbon::MONDAY;
					}
					if ($office_shift->tuesday_in) {
						$workdays[] = Carbon::TUESDAY;
					}
					if ($office_shift->wednesday_in) {
						$workdays[] = Carbon::WEDNESDAY;
					}
					if ($office_shift->thursday_in) {
						$workdays[] = Carbon::THURSDAY;
					}
					if ($office_shift->friday_in) {
						$workdays[] = Carbon::FRIDAY;
					}
					if ($office_shift->saturday_in) {
						$workdays[] = Carbon::SATURDAY;
					}
					if ($office_shift->sunday_in) {
						$workdays[] = Carbon::SUNDAY;
					}

					// Ambil data hari libur nasional
					$holidays = Holiday::where(function ($query) use ($start_date, $end_date) {
						$query->whereBetween('start_date', [$start_date, $end_date])
							->orWhereBetween('end_date', [$start_date, $end_date])
							->orWhere(function ($query) use ($start_date, $end_date) {
								$query->where('start_date', '<=', $start_date)
									->where('end_date', '>=', $end_date);
							});
					})->get();

					for ($date = $start_date; $date->lte($end_date); $date->addDay()) {
						if (in_array($date->dayOfWeek, $workdays)) {
							// Cek apakah tanggal ini merupakan hari libur nasional
							$isHoliday = $holidays->contains(function ($holiday) use ($date) {
								return $date->between($holiday->start_date, $holiday->end_date);
							});

							if (!$isHoliday) {
								$total_leave_days++;
							}
						}
					}

					########END CALCULATE TOTAL LEAVE##########
					$employee = leave::where('employee_id', $karyawan->id)
						->where('leave_type_id', $request->leave_type);

					if ($employee->exists()) {
						$total = 0;
						$employee_leaves = $employee->get();

						foreach ($employee_leaves as $employee_leave) {
							$total = $total + $employee_leave->total_days;
						}
						$total = $total + $total_leave_days;

						if ($leave->allocated_day != null && $leave->allocated_day < $total) {
							// return response()->json(['limit' => __('Allocated quota for this leave type is less then requested days for this employee')]);
							continue;
						}
					} else {
						if ($leave->allocated_day != null && $leave->allocated_day < $request->diff_date_hidden) {
							// return response()->json(['limit' => __('Allocated quota for this leave type is less then requested days,You can select manual')]);
							continue;
						}
					}

					$data = [];

					$data['employee_id'] = $karyawan->id;
					$data['company_id'] = $karyawan->company_id;
					$data['department_id'] = $karyawan->department_id;
					$data['leave_type_id'] = $request->leave_type;
					$data['leave_reason'] = $request->leave_reason;
					$data['remarks'] = $request->remarks;
					$data['status'] = $request->status;
					$data['is_half'] = $request->is_half;
					$data['is_notify'] = $request->is_notify;
					$data['start_date'] = $request->start_date;
					$data['end_date'] = $request->end_date;
					$data['total_days'] = $total_leave_days;

					//Employee Remaining Leave --- Start
					$employee_leave_info = Employee::find($data['employee_id']);
					if ($total_leave_days > $employee_leave_info->remaining_leave) {
						// return response()->json(['remaining_leave' => "The employee's remaining leaves are insufficient"]);
						continue;
					} elseif ($request->status == 'approved') {
						// HANYA kurangi untuk tipe cuti yang memotong kuota (sesuaikan ID)
						if (in_array($request->leave_type, [3, 5])) {
							$employee_leave_info->remaining_leave = $employee_leave_info->remaining_leave - $total_leave_days;
							$employee_leave_info->update();
						}
					}
					//Employee Remaining Leave  --- End

					$leave = leave::create($data);
				}
			}
			else
			{
				#per employee request
				$office_shift = office_shift::find($karyawan->office_shift_id); // Asumsikan ada satu shift yang digunakan
				$workdays = [];
				if ($office_shift->monday_in) {
					$workdays[] = Carbon::MONDAY;
				}
				if ($office_shift->tuesday_in) {
					$workdays[] = Carbon::TUESDAY;
				}
				if ($office_shift->wednesday_in) {
					$workdays[] = Carbon::WEDNESDAY;
				}
				if ($office_shift->thursday_in) {
					$workdays[] = Carbon::THURSDAY;
				}
				if ($office_shift->friday_in) {
					$workdays[] = Carbon::FRIDAY;
				}
				if ($office_shift->saturday_in) {
					$workdays[] = Carbon::SATURDAY;
				}
				if ($office_shift->sunday_in) {
					$workdays[] = Carbon::SUNDAY;
				}

				// Ambil data hari libur nasional
				$holidays = Holiday::where(function ($query) use ($start_date, $end_date) {
					$query->whereBetween('start_date', [$start_date, $end_date])
						->orWhereBetween('end_date', [$start_date, $end_date])
						->orWhere(function ($query) use ($start_date, $end_date) {
							$query->where('start_date', '<=', $start_date)
								->where('end_date', '>=', $end_date);
						});
				})->get();

				$total_leave_days = 0;

				for ($date = $start_date; $date->lte($end_date); $date->addDay()) {
					if (in_array($date->dayOfWeek, $workdays)) {
						// Cek apakah tanggal ini merupakan hari libur nasional
						$isHoliday = $holidays->contains(function ($holiday) use ($date) {
							return $date->between($holiday->start_date, $holiday->end_date);
						});

						if (!$isHoliday) {
							$total_leave_days++;
						}
					}
				}
				########END CALCULATE TOTAL LEAVE##########
				$employee = leave::where('employee_id', $request->employee_id)
					->where('leave_type_id', $request->leave_type);

				if ($employee->exists()) {
					$total = 0;
					$employee_leaves = $employee->get();

					foreach ($employee_leaves as $employee_leave) {
						$total = $total + $employee_leave->total_days;
					}
					$total = $total + $total_leave_days;

					if ($leave->allocated_day != null && $leave->allocated_day < $total) {
						return response()->json(['limit' => __('Allocated quota for this leave type is less then requested days for this employee')]);
					}
				} else {
					if ($leave->allocated_day != null && $leave->allocated_day < $request->diff_date_hidden) {
						return response()->json(['limit' => __('Allocated quota for this leave type is less then requested days,You can select manual')]);
					}
				}

				$data = [];

				$data['employee_id'] = $request->employee_id;
				$data['company_id'] = $request->company_id;
				$data['department_id'] = $request->department_id;
				$data['leave_type_id'] = $request->leave_type;
				$data['leave_reason'] = $request->leave_reason;
				$data['remarks'] = $request->remarks;
				$data['status'] = $request->status;
				$data['is_half'] = $request->is_half;
				$data['is_notify'] = $request->is_notify;
				$data['start_date'] = $request->start_date;
				$data['end_date'] = $request->end_date;
				$data['total_days'] = $total_leave_days;

				//Employee Remaining Leave --- Start
				$employee_leave_info = Employee::find($request->employee_id);
				if ($total_leave_days > $employee_leave_info->remaining_leave) {
					return response()->json(['remaining_leave' => "The employee's remaining leaves are insufficient"]);
				} elseif ($request->status == 'approved') {
					// HANYA kurangi untuk tipe cuti yang memotong kuota (sesuaikan ID)
					if (in_array($request->leave_type, [3, 5])) {
						$employee_leave_info->remaining_leave = $employee_leave_info->remaining_leave - $total_leave_days;
						$employee_leave_info->update();
					}
				}
				//Employee Remaining Leave  --- End

				$leave = leave::create($data);

				$text = "Cuti Bersama notification for ". $employee_leave_info->first_name ." ".$employee_leave_info->last_name;
				$notifiable = User::findOrFail($data['employee_id']);
				$notifiable->notify(new LeaveNotification($text)); //To Employee
			}

			if(!empty($request->employee_id))
			{
				if ($leave->is_notify == 1) {
					$text = "A new leave-notification has been requested by ". $employee_leave_info->first_name ." ".$employee_leave_info->last_name;
					$notifiable = User::findOrFail($data['employee_id']);
					$notifiable->notify(new LeaveNotification($text)); //To Employee
	
					//Get All HR
					$companyId = $employee_leave_info->company_id;
					$HR_user = User::whereJsonContains('company_ids', $companyId)->get();
					if($HR_user->count() > 0)
					{
						foreach($HR_user as $hr){
							$hr->notify(new LeaveNotification($text));
							
							if(!empty($hr->email))
							{
								Notification::route('mail', $hr->email)
								->notify(new EmployeeLeaveNotification(
									$leave->employee->full_name,
									$leave->total_days,
									$leave->start_date,
									$leave->end_date,
									$leave->leave_reason,
								));
							}
						}
					}
	
				} elseif ((Auth::user()->role_users_id != 1) && ($leave->is_notify == NULL)) {
					//get-leave-notification - 294
					$role_ids = DB::table('role_has_permissions')->where('permission_id', 294)->get()->pluck('role_id');
					$role_ids[] = 1;
	
					$notifiable = User::whereIn('role_users_id', $role_ids)->get();
					foreach ($notifiable as $item) {
						$item->notify(new LeaveNotificationToAdmin());
					}
	
					//Mail
					$department = department::with('DepartmentHead:id,email')->where('id', $request->department_id)->first();
					//Get All HR
					$companyId = $employee_leave_info->company_id;
					$HR_user = User::whereJsonContains('company_ids', $companyId)->get();
					if($HR_user->count() > 0)
					{
						foreach($HR_user as $hr){
							$text = "A new leave-notification has been requested by ". $employee_leave_info->first_name ." ".$employee_leave_info->last_name;
							$notifiable = User::findOrFail($hr->id);
							$notifiable->notify(new LeaveNotification($text)); //To HR
							if(!empty($hr->email))
							{
								Notification::route('mail', $hr->email)
								->notify(new EmployeeLeaveNotification(
									$leave->employee->full_name,
									$leave->total_days,
									$leave->start_date,
									$leave->end_date,
									$leave->leave_reason,
								));
							}
						}
					}
	
					if(!empty($department->DepartmentHead))
					{
						$text = "A new leave-notification has been requested by ". $employee_leave_info->first_name ." ".$employee_leave_info->last_name;
						$notifiable = User::findOrFail($department->department_head);
						$notifiable->notify(new LeaveNotification($text)); //To Department Head
						if(!empty($department->DepartmentHead->email)) {
							Notification::route('mail', $department->DepartmentHead->email)
								->notify(new EmployeeLeaveNotification(
									$leave->employee->full_name,
									$leave->total_days,
									$leave->start_date,
									$leave->end_date,
									$leave->leave_reason,
								));
						}
					}
	
					if(!empty($department->supervisor)) {
						$text = "A new leave-notification has been requested by ". $employee_leave_info->first_name ." ".$employee_leave_info->last_name;
						$notifiable = User::findOrFail($department->supervisor);
						$notifiable->notify(new LeaveNotification($text)); //To Supervisor
					}
				}
			}

			return response()->json(['success' => __('Data Added successfully.')]);
		}
		return response()->json(['success' => __('You are not authorized')]);
	}

	public function show($id)
	{
		if (request()->ajax()) {
			$data = leave::findOrFail($id);
			$company_name = $data->company->company_name ?? '';
			$employee_name = $data->employee->full_name;
			$department = $data->department->department_name ?? '';
			$leave_type_name = $data->LeaveType->leave_type ?? '';

			$start_date_name = $data->start_date;
			$end_date_name = $data->end_date;

			return response()->json([
				'data' => $data, 'employee_name' => $employee_name, 'company_name' => $company_name, 'department' => $department, 'leave_type_name' => $leave_type_name,
				'start_date_name' => $start_date_name, 'end_date_name' => $end_date_name
			]);
		}
	}

	public function edit($id)
	{
		if (request()->ajax()) {
			$data = leave::findOrFail($id);

			$departments = department::select('id', 'department_name')
				->where('company_id', $data->company_id)->get();

			$employees = Employee::select('id', 'first_name', 'last_name')->where('department_id', $data->department_id)->where('is_active', 1)->where('exit_date', NULL)->get();

			return response()->json(['data' => $data, 'employees' => $employees, 'departments' => $departments]);
		}
	}

	public function update(Request $request)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('edit-leave')) {
			$id = $request->hidden_id;

			$validator = Validator::make(
				$request->only(
					'leave_type',
					'company_id',
					'department_id',
					'employee_id',
					'start_date',
					'end_date',
					'leave_reason',
					'remarks',
					'status',
					'is_half',
					'is_notify',
					'diff_date_hidden',
					'leave_type_hidden',
					'employee_id_hidden'
				),
				[
					'company_id' => 'required',
					'department_id' => 'required',
					'employee_id' => 'required',
					'leave_type' => 'required',
					'status' => 'required',
					'start_date' => 'required',
					'end_date' => 'required|after_or_equal:start_date',
					'diff_date_hidden' => 'nullable|numeric'
				]
			);

			if ($validator->fails()) {
				return response()->json(['errors' => $validator->errors()->all()]);
			}

			$data = [];
			global $employee_id;

			$data['leave_reason'] = $request->leave_reason;
			$data['remarks'] = $request->remarks;
			$data['is_half'] = $request->is_half;
			$data['is_notify'] = $request->is_notify;
			$data['start_date'] = $request->start_date;
			$data['end_date'] = $request->end_date;

			if ($request->diff_date_hidden != null) {
				$data['total_days'] = $request->diff_date_hidden;
			}

			if ($request->employee_id) {
				$employee_id = $request->employee_id;
				$data['employee_id'] = $employee_id;
			} else {
				$employee_id = $request->employee_id_hidden;
			}
			if ($request->company_id) {
				$data['company_id'] = $request->company_id;
			}

			if ($request->department_id) {
				$data['department_id'] = $request->department_id;
			}

			// Ambil status sebelumnya untuk kontrol pengurangan kuota hanya saat transisi
			$leaveBefore = leave::findOrFail($id);

			if ($request->status) {
				$logged_user = auth()->user();
				$current_employee = Employee::find($logged_user->id);
				$requester_employee = Employee::find($request->employee_id);
				$checking_leave = leave::find($id);

				if(!$logged_user->hasRole('admin')) {
					if($current_employee->dept_head == 1 && $checking_leave->status != "first level approval" && $requester_employee->supervisor != 1)
					{
						return response()->json(['limit' => __('Manager allowed to approved first level approval and supervisor request')]);
					}
				}
				$data['status'] = $request->status;
			}

			// Hitung total hari (sesuai kode lama)
			$total_leave_days = 0;

			if ($request->leave_type) {
				$leave = LeaveType::findOrFail($request->leave_type);

				####CALCULATE TOTAL LEAVE DAYS###########
				$karyawan = Employee::find($request->employee_id);
				$start_date = Carbon::parse($request->start_date);
				$end_date = Carbon::parse($request->end_date);
				$office_shift = office_shift::find($karyawan->office_shift_id); // Asumsikan ada satu shift yang digunakan
				$workdays = [];
				if ($office_shift->monday_in) {
					$workdays[] = Carbon::MONDAY;
				}
				if ($office_shift->tuesday_in) {
					$workdays[] = Carbon::TUESDAY;
				}
				if ($office_shift->wednesday_in) {
					$workdays[] = Carbon::WEDNESDAY;
				}
				if ($office_shift->thursday_in) {
					$workdays[] = Carbon::THURSDAY;
				}
				if ($office_shift->friday_in) {
					$workdays[] = Carbon::FRIDAY;
				}
				if ($office_shift->saturday_in) {
					$workdays[] = Carbon::SATURDAY;
				}
				if ($office_shift->sunday_in) {
					$workdays[] = Carbon::SUNDAY;
				}

				// Ambil data hari libur nasional
				$holidays = Holiday::where(function ($query) use ($start_date, $end_date) {
					$query->whereBetween('start_date', [$start_date, $end_date])
						->orWhereBetween('end_date', [$start_date, $end_date])
						->orWhere(function ($query) use ($start_date, $end_date) {
							$query->where('start_date', '<=', $start_date)
								->where('end_date', '>=', $end_date);
						});
				})->get();

				for ($date = $start_date; $date->lte($end_date); $date->addDay()) {
					if (in_array($date->dayOfWeek, $workdays)) {
						// Cek apakah tanggal ini merupakan hari libur nasional
						$isHoliday = $holidays->contains(function ($holiday) use ($date) {
							return $date->between($holiday->start_date, $holiday->end_date);
						});

						if (!$isHoliday) {
							$total_leave_days++;
						}
					}
				}
				########END CALCULATE TOTAL LEAVE##########

				$employee = leave::where('id', '!=', $id)
					->where('employee_id', $employee_id)->where('leave_type_id', $request->leave_type);

				if ($employee->exists()) {
					$total = 0;
					$employee_leaves = $employee->get();

					foreach ($employee_leaves as $employee_leave) {
						$total = $total + $employee_leave->total_days;
					}
					$total = $total + $total_leave_days;

					if ($leave->allocated_day != null && $leave->allocated_day < $total) {
						return response()->json(['limit' => __('Allocated quota for this leave type is less then requested days for this employee')]);
					}
				} else {
					if ($leave->allocated_day != null && $leave->allocated_day < $request->diff_date_hidden) {
						return response()->json(['limit' => __('Allocated quota for this leave type is less then requested days,You can select manual')]);
					}
				}
				$data['leave_type_id'] = $request->leave_type;
			} else {
				$leave = LeaveType::findOrFail($request->leave_type_hidden);
				$employee = leave::where('id', '!=', $id)
					->where('employee_id', $employee_id)->where('leave_type_id', $request->leave_type_hidden);

				if ($employee->exists()) {
					$total = 0;
					$employee_leaves = $employee->get();

					foreach ($employee_leaves as $employee_leave) {
						$total = $total + $employee_leave->total_days;
					}
					$total = $total + $total_leave_days;

					if ($leave->allocated_day != null && $leave->allocated_day < $total) {
						return response()->json(['limit' => __('Allocated quota for this leave type is less then requested days for this employee')]);
					}
				} else {
					if ($leave->allocated_day != null && $leave->allocated_day < $request->diff_date_hidden) {
						return response()->json(['limit' => __('Allocated quota for this leave type is less then requested days,You can select manual')]);
					}
				}
				$data['leave_type_id'] = $request->leave_type_hidden;
			}

			//Employee Remaining Leave --- Start
			$employee_leave_info = Employee::find($employee_id);

			// Perbaikan kondisi: hanya blokir jika tipe cuti memotong kuota DAN hari yang diminta > sisa kuota
			if ($total_leave_days > $employee_leave_info->remaining_leave && in_array($data['leave_type_id'], [3, 5])) {
				return response()->json(['remaining_leave' => "The employee's remaining leaves are insufficient"]);
			}

			// Kurangi / kembalikan kuota HANYA saat transisi status
			$wasApproved = $leaveBefore->status === 'approved';
			$willApproved = ($request->status === 'approved');

			if (in_array($data['leave_type_id'], [3, 5])) {
				if (!$wasApproved && $willApproved) {
					// PENDING/LAINNYA -> APPROVED : kurangi
					$employee_leave_info->remaining_leave = $employee_leave_info->remaining_leave - $total_leave_days;
					$employee_leave_info->update();
				} elseif ($wasApproved && !$willApproved) {
					// APPROVED -> dibatalkan/non-approved : kembalikan sesuai total sebelumnya
					$employee_leave_info->remaining_leave = $employee_leave_info->remaining_leave + $leaveBefore->total_days;
					$employee_leave_info->update();
				}
				// Catatan: bila tetap approved tapi tanggal diubah, tidak dilakukan penyesuaian delta
				// (tidak diubah di sini sesuai permintaan hanya memperbaiki isu pengurangan 1 hari / double-deduct)
			}
			//Employee Remaining Leave  --- End

			leave::find($id)->update($data);

			if ($data['is_notify'] != NULL) {
				$text = "A leave-notification has been updated";
				$notifiable = User::findOrFail($data['employee_id']);
				$notifiable->notify(new LeaveNotification($text)); //To Employee
			}
			return response()->json(['success' => __('Data is successfully updated')]);
		}
		return response()->json(['success' => __('You are not authorized')]);
	}

	public function destroy($id)
	{
		if (!env('USER_VERIFIED')) {
			return response()->json(['error' => 'This feature is disabled for demo!']);
		}
		$logged_user = auth()->user();

		if ($logged_user->can('delete-leave')) {
			// Get Leave
			$leave_data = leave::whereId($id)->first();
			if($leave_data->leave_type_id == 3 || $leave_data->leave_type_id == 5)
			{
				$employee_leave_info = Employee::find($leave_data->employee_id);
				$employee_leave_info->remaining_leave = $employee_leave_info->remaining_leave + $leave_data->total_days;
				$employee_leave_info->update();
			}

			leave::whereId($id)->delete();

			return response()->json(['success' => __('Data is successfully deleted')]);
		}
		return response()->json(['success' => __('You are not authorized')]);
	}

	public function delete_by_selection(Request $request)
	{
		if (!env('USER_VERIFIED')) {
			return response()->json(['error' => 'This feature is disabled for demo!']);
		}
		$logged_user = auth()->user();

		if ($logged_user->can('delete-leave')) {

			$leave_id = $request['leaveIdArray'];
			foreach($leave_id as $id)
			{
				$leave_data = leave::whereId($id)->first();
				if($leave_data->leave_type_id == 3 || $leave_data->leave_type_id == 5)
				{
					$employee_leave_info = Employee::find($leave_data->employee_id);
					$employee_leave_info->remaining_leave = $employee_leave_info->remaining_leave + $leave_data->total_days;
					$employee_leave_info->update();
				}
			}
			
			$leave = leave::whereIntegerInRaw('id', $leave_id);
			if ($leave->delete()) {
				return response()->json(['success' => __('Multi Delete', ['key' => trans('file.Leave')])]);
			} else {
				return response()->json(['error' => 'Error, selected leaves can not be deleted']);
			}
		}

		return response()->json(['success' => __('You are not authorized')]);
	}

	public function calendarableDetails($id)
	{
		if (request()->ajax()) {
			$data = Leave::with(
				'company:id,company_name',
				'LeaveType:id,leave_type',
				'employee:id,first_name,last_name'
			)->findOrFail($id);

			$new = [];

			$new['Company'] = $data->company->company_name;
			$new['Employee'] = $data->employee->full_name;
			$new['Arrangement Type'] = $data->LeaveType->leave_type;
			$new['Start Date'] = $data->start_date;
			$new['End Date'] = $data->end_date;
			$new['Leave Reason'] = $data->leave_reason;
			$new['Remarks'] = $data->remarks;
			$new['Status'] = 'Approved';

			return response()->json(['data' => $new]);
		}
	}
}
