<?php

namespace App\Http\Controllers;

use App\company;
use App\Employee;
use App\Http\Controllers\Controller;
use App\LogReportAttendance;
use Illuminate\Http\Request;

class LogReportAttendanceController extends Controller
{
    public function index()
    {
        $logged_user = auth()->user();
        $companyId = null;
        if ($logged_user->role_users_id == 6) {
            $companyId = json_decode($logged_user->company_ids);
        }
        $companies = company::select('id', 'company_name')->get();

        if ($logged_user->can('view-log-report-attendance')) {
            if (request()->ajax()) {
                $logs = LogReportAttendance::with(['reportAttendance', 'reportAttendance.employee', 'user']);
                if ($companyId) {
                    $logs = $logs->whereHas('reportAttendance.employee.company', function ($q) use ($companyId) {
                        return $q->whereIn('company_id', $companyId);
                    });
                }
                return datatables()->of($logs->get())
                    ->setRowId(function ($log) {
                        return $log->id;
                    })
                    ->addColumn('log', function ($row) {
                        return ucwords($row->type) . ' attendance ' . $row->reportAttendance->employee->first_name . ' ' . $row->reportAttendance->employee->last_name . ' at date ' . $row->reportAttendance->attendance_date;
                    })
                    ->addColumn('updated_by', function ($row) {
                        return $row->user->first_name . ' ' . $row->user->last_name;
                    })
                    ->addColumn('updated_at', function ($row) {
                        return $row->created_at;
                    })
                    ->make(true);
            }

            return view('timesheet.log_report_attendance.index', compact('companies'));
        }

        return abort('403', __('You are not authorized'));
    }
}
