<?php

namespace App\Http\Controllers;

use App\company;
use App\department;
use App\Employee;
use App\Exports\ReportAttendanceExport;
use App\Holiday;
use App\Http\Controllers\Controller;
use App\leave;
use App\LogReportAttendance;
use App\ReportAttendance;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class ReportAttendanceController extends Controller
{
    public function reportAttendance(Request $request)
    {
        $logged_user = auth()->user();
        $companyId = null;
		if ($logged_user->role_users_id == 6) {
			$companyId = json_decode($logged_user->company_ids);
			
			$companies = company::select('id', 'company_name')->whereIn('id', $companyId)->get();
		}
		else if($logged_user->role_users_id == 1) {
			$companies = company::select('id', 'company_name')->get();
			if(!empty($request->company_id))
			{
				$companyId = array($request->company_id);
			}
			else
			{
				$companyId = array($companies[0]->id);
			}
		}
        // $companies = company::select('id', 'company_name')->get();

        $startDate = $request->start_date ? Carbon::parse($request->start_date)->format('Y-m-d') : Carbon::now()->startOfMonth();
        $endDate = $request->end_date ? Carbon::parse($request->end_date)->format('Y-m-d') : Carbon::now()->endOfMonth();
        $period = CarbonPeriod::create($startDate, $endDate);

        $dates = [];
        foreach ($period as $date) {
            $dates[] =  $date->format('d-m-Y');
        }

        if ($logged_user->can('report-attendance')) {
            if (request()->ajax()) {
                if ($request->is_employee == null) {
                    $departments = new department;
                    if ($request->company_id) {
                        $departments = $departments->where('company_id', $request->company_id);
                    }
                    $departments = $departments->get();
                    $datatables = datatables()->of($departments);
                    $datatables->setRowId(function ($row) {
                        return $row->id;
                    });
                    $datatables->addColumn('department', function ($row) {
                        return $row->department_name;
                    });

                    foreach ($dates as $date) {
                        $datatables->addColumn($date, function ($row) use ($date) {
                            $date = Carbon::parse($date);
                            return ReportAttendance::whereHas(
                                "employee",
                                function ($query) use ($row) {
                                    $query->where('department_id', $row->id);
                                },
                            )->where('attendance_date', $date)->get()->count();
                        });
                    }
                    return $datatables->make(true);
                } else {
                    $employees = Employee::where('department_id', $request->department_id)
                                ->where('is_active', 1)
                                ->orderByRaw('position = 0, position')->get();
                    $datatables = datatables()->of($employees);
                    $datatables->setRowId(function ($row) {
                        return $row->id;
                    });
                    $datatables->addColumn('employee_name', function ($row) {
                        return $row->first_name . ' ' . $row->last_name;
                    });
                    $datatables->addColumn('remaining_leave', function ($row) {
                        return $row->remaining_leave;
                    });
                    $datatables->addColumn('department', function ($row) {
                        return $row->department->department_name;
                    });

                    foreach ($dates as $date) {
                        $formattedDate = Carbon::parse($date)->format('Y-m-d');
                        $day = Carbon::parse($date)->format('l');

                        $datatables->addColumn($date, function ($employee) use ($formattedDate, $day) {
                            if (Carbon::parse($formattedDate)->greaterThanOrEqualTo(Carbon::now())) {
                                return '-';
                            }

                            $reportAttendance = $employee->reportAttendances->where('attendance_date', $formattedDate)->first();
                            $attendance = $employee->employeeAttendance->where('attendance_date', $formattedDate)->first();

                            if ($reportAttendance) {
                                $tooltip = '';
                                if ($attendance) {
                                    if ($attendance->clock_in != '' && $attendance->clock_out != '') {
                                        $tooltip = 'Clock In: ' . $attendance->clock_in . ', ' . 'Clock Out: ' . $attendance->clock_out;
                                    } else if ($attendance->clock_in != '') {
                                        $tooltip = 'Clock In: ' . $attendance->clock_in;
                                    } else if ($attendance->clock_out != '') {
                                        $tooltip = 'Clock Out: ' . $attendance->clock_out;
                                    }
                                }

                                if ($reportAttendance->status) {
                                    if ($reportAttendance->is_checked) {
                                        return '<span class="text-success" data-toggle="tooltip" data-placement="top" title="' . $tooltip . '">' . $reportAttendance->status . '</span>';
                                    } else {
                                        return '<span class="text-danger" data-toggle="tooltip" data-placement="top" title="' . $tooltip . '">' . $reportAttendance->status . '</span>';
                                    }
                                } else {
                                    $time = Carbon::parse($reportAttendance->work_time)->format('H:i');
                                    if ($reportAttendance->is_underwork) {
                                        return '<span class="text-danger" data-toggle="tooltip" data-placement="top" title="' . $tooltip . '">' . $time . '</span>';
                                    } else {
                                        return '<span class="text-success" data-toggle="tooltip" data-placement="top" title="' . $tooltip . '">' . $time . '</span>';
                                    }
                                }
                            } else {
                                $holiday = Holiday::where([
                                    ['start_date', '<=', $formattedDate],
                                    ['end_date', '>=', $formattedDate]
                                ])->first();
                                if ($day == 'Saturday' || $day == 'Sunday' || $holiday) {
                                    return '-';
                                } else {
                                    if ($employee->is_dispensation) {
                                        return '<span class="text-success">DIS</span>';
                                    }
                                    $leave = leave::with('leaveType')->where([
                                        ['employee_id', '=', $employee->id],
                                        ['start_date', '<=', $formattedDate],
                                        ['end_date', '>=', $formattedDate]
                                    ])->first();
                                    if ($leave) {
                                        $status = '';
                                        $leaveType = $leave->leaveType->id;
                                        switch ($leaveType) {
                                            case 1:
                                                $status = 'S';
                                                break;
                                            case 2:
                                                $status = 'I';
                                                break;
                                            case 3:
                                                if ($leave->is_half) {
                                                    $status = 'C1';
                                                } else {
                                                    $status = 'C';
                                                }
                                                break;
                                            case 4:
                                                $status = 'M';
                                                break;
                                            case 5:
                                                $status = 'C1';
                                                break;
                                            case 6:
                                                $status = 'C2';
                                                break;
                                            case 7:
                                                $status = 'C3';
                                                break;
                                            case 8:
                                                $status = 'C4';
                                                break;
                                            case 9:
                                                $status = 'DL';
                                                break;
                                            case 10:
                                                $status = 'IK1';
                                                break;
                                            case 11:
                                                $status = 'IK2';
                                                break;
                                            case 12:
                                                $status = 'IT1';
                                                break;
                                            case 13:
                                                $status = 'IT2';
                                                break;
                                            case 14:
                                                $status = 'IP';
                                                break;
                                            case 15:
                                                $status = 'TA1';
                                                break;
                                            case 16:
                                                $status = 'TA2';
                                                break;
                                            case 17:
                                                $status = 'DIS';
                                                break;
                                            case 18:
                                                $status = 'PG';
                                                break;
                                            default:
                                                $status =  '-';
                                        }
                                        return '<span class="text-primary">' . $status . '</span>';
                                    } else {
                                        $status = 'TA3';
                                        return '<span class="text-danger">' . $status . '</span>';
                                    }
                                }
                            }
                        });
                    }
                    $datatables->rawColumns($dates);
                    return $datatables->make(true);
                }
            }

            return view('timesheet.report_attendances.index', compact('companies'));
        }
        return response()->json(['success' => __('You are not authorized')]);
    }

    public function reportAttendanceHeader(Request $request)
    {
        $logged_user = auth()->user();
        if ($logged_user->can('report-attendance')) {
            $startDate = $request->start_date ? Carbon::parse($request->start_date)->format('Y-m-d') : Carbon::now()->startOfMonth();
            $endDate = $request->end_date ? Carbon::parse($request->end_date)->format('Y-m-d') : Carbon::now()->endOfMonth();

            $period = CarbonPeriod::create($startDate, $endDate);
            $dates = [];
            $holidays = [];

            if ($request->is_employee == null) {
                $index = 1;
            } else {
                $index = 3;
            }

            $fixedHolidays = Holiday::where('is_publish', 1)->get();
            foreach ($period as $key => $date) {
                $dates[] =  $date->format('d-m-Y');
                if ($date->isWeekend()) {
                    $holidays[] = $key + $index;
                } else {
                    foreach ($fixedHolidays as $fixedHoliday) {
                        if ($date->betweenIncluded(Carbon::parse($fixedHoliday->start_date), Carbon::parse($fixedHoliday->end_date))) {
                            $holidays[] = $key + $index;
                        }
                    }
                }
            }
            return response()->json([
                'dates' => $dates,
                'holidays' => $holidays,
            ]);
        }
        return response()->json(['success' => __('You are not authorized')]);
    }

    public function fullReportAttendance($company, $date)
    {
        $logged_user = auth()->user();

        if($company > 0)
        {
            $companies = company::select('id', 'company_name')->where('id', $company)->first();
            $companies = $companies->id;
        }
        else
        {
            // $companies = company::select('id', 'company_name')->get();
            $companies = 0;
        }

        if ($logged_user->can('report-attendance')) {
            return view('timesheet.report_attendances.full', compact('companies', 'date'));
        }
        return response()->json(['success' => __('You are not authorized')]);
    }

    public function fullReportAttendanceData(Request $request)
    {
        $logged_user = auth()->user();

        $company_id = 0;
        if($request->company_id > 0)
        {
            $company_id = $request->company_id;
            $companies = company::select('id', 'company_name')->where('id', $request->company_id)->get();
        }
        else
        {
            $companies = company::select('id', 'company_name')->get();
        }
        
        if ($request->date) {
            $startDate = Carbon::parse($request->date)->startOfMonth();
            $endDate = Carbon::parse($request->date)->endOfMonth();
        } else {
            $startDate = Carbon::now()->startOfMonth();
            $endDate = Carbon::now()->endOfMonth();
        }
        $period = CarbonPeriod::create($startDate, $endDate);
        $now = Carbon::now();

        $dates = [];
        foreach ($period as $date) {
            $dates[] =  $date->format('d-m-Y');
        }

        if ($logged_user->can('report-attendance')) {
            if (request()->ajax()) {

                if($request->company_id > 0)
                {
                    $employees = Employee::with([
                        "employeeAttendance" => function ($query) use ($startDate, $endDate) {
                            $query->whereBetween('attendance_date', [$startDate, $endDate]);
                        },
                        'officeShift',
                        'department',
                        'employeeLeave'
                    ])
                    ->where('company_id', $company_id)
                    ->where('is_active', 1)
                    ->orderByRaw('position = 0, position');    
                }
                else
                {
                    $employees = Employee::with([
                        "employeeAttendance" => function ($query) use ($startDate, $endDate) {
                            $query->whereBetween('attendance_date', [$startDate, $endDate]);
                        },
                        'officeShift',
                        'department',
                        'employeeLeave'
                    ])
                    ->where('is_active', 1)
                    ->orderByRaw('position = 0, position');
                }

                $datatables = datatables()->of($employees);
                $datatables->setRowId(function ($row) {
                    return $row->id;
                });
                $datatables->addColumn('employee_name', function ($row) {
                    return $row->first_name . ' ' . $row->last_name;
                });
                $datatables->addColumn('remaining_leave_last_month', function ($row) {
                    $totalLeaves = $row->remaining_leave;
                    $thisMonthLeaves = leave::where('employee_id', $row->id)->whereMonth('start_date', Carbon::now()->month)->sum('total_days');
                    return $totalLeaves + $thisMonthLeaves;
                });
                $datatables->addColumn('department', function ($row) {
                    if(isset($row->department->department_name))
                    {
                        return $row->department->department_name;    
                    }
                    else
                    {
                        return "-";
                    }
                });

                //Kondite
                $datatables->addColumn('total_s', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 1)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                    return $count;
                });
                $datatables->addColumn('total_i', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 2)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                    return $count;
                });
                $datatables->addColumn('total_c', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 3)->where('is_half', '!=', 1)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                    return $count;
                });
                $datatables->addColumn('total_m', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 4)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                $datatables->addColumn('total_c1', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 3)->where('is_half', 1)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                    foreach ($row->employeeLeave->where('leave_type_id', 5)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                    return $count;
                });
                $datatables->addColumn('total_c2', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 6)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                $datatables->addColumn('total_c3', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 7)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                $datatables->addColumn('total_c4', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 8)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                $datatables->addColumn('total_dl', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 9)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                $datatables->addColumn('total_ik1', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 10)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                $datatables->addColumn('total_ik2', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 11)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                $datatables->addColumn('total_it1', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 12)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                $datatables->addColumn('total_it2', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 13)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                $datatables->addColumn('total_ip', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 14)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                $datatables->addColumn('total_ta1', function ($row) use ($startDate, $endDate) {
                    return ReportAttendance::where([['employee_id', '=', $row->id], ['status', '=', 'TA1']])->whereBetween('attendance_date', [$startDate, $endDate])->get()->count();
                });
                $datatables->addColumn('total_ta2', function ($row) use ($startDate, $endDate) {
                    return ReportAttendance::where([['employee_id', '=', $row->id], ['status', '=', 'TA2']])->whereBetween('attendance_date', [$startDate, $endDate])->get()->count();
                });
                $datatables->addColumn('total_ta3', function ($row) use ($startDate, $endDate, $now) {
                    //All date
                    $filterEndDate = $endDate;
                    if ($endDate->greaterThan($now)) {
                        $filterEndDate = $now;
                    }
                    $count = $startDate->diffInDaysFiltered(
                        function (Carbon $date) {
                            return !$date->isWeekend();
                        },
                        $filterEndDate
                    );
                    //Attendance report count
                    $attendCount = ReportAttendance::where('employee_id', $row->id)->whereBetween('attendance_date', [$startDate, $endDate])->get()->count();
                    //Leaves count
                    $leaveCount = 0;
                    foreach ($row->employeeLeave as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $leaveCount += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                    //Total
                    if (!$row->is_dispensation) {
                        return $count - $attendCount - $leaveCount;
                    } else {
                        return 0;
                    }
                });
                $datatables->addColumn('total_dis', function ($row) use ($startDate, $endDate, $now) {
                    //All date
                    $filterEndDate = $endDate;
                    if ($endDate->greaterThan($now)) {
                        $filterEndDate = $now;
                    }
                    $count = $startDate->diffInDaysFiltered(
                        function (Carbon $date) {
                            return !$date->isWeekend();
                        },
                        $filterEndDate
                    );
                    //Attendance report count
                    $attendCount = ReportAttendance::where('employee_id', $row->id)->whereBetween('attendance_date', [$startDate, $endDate])->get()->count();
                    //Leaves count
                    $leaveCount = 0;
                    foreach ($row->employeeLeave as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }

                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $leaveCount += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                    //Total
                    if ($row->is_dispensation) {
                        return $count - $attendCount - $leaveCount;
                    } else {
                        return 0;
                    }
                });
                $datatables->addColumn('total_pg', function ($row) use ($startDate, $endDate) {
                    $count = 0;
                    foreach ($row->employeeLeave->where('leave_type_id', 18)->all() as $leave) {
                        $startLeave = Carbon::parse($leave->start_date);
                        $endLeave = Carbon::parse($leave->end_date);
                        if ($startLeave->lessThan($startDate)) {
                            $startLeave = $startDate;
                        }
                        if ($endLeave->greaterThan($endDate)) {
                            $endLeave = $endDate;
                        }
                        if ($startLeave->lessThanOrEqualTo($endLeave)) {
                            $count += $startLeave->diffInDaysFiltered(function (Carbon $date) {
                                return !$date->isWeekend();
                            }, $endLeave->addDay('1'));
                        }
                    }
                });
                foreach ($dates as $date) {
                    $formattedDate = Carbon::parse($date)->format('Y-m-d');
                    $day = Carbon::parse($date)->format('l');

                    $datatables->addColumn($date, function ($employee) use ($formattedDate, $day) {
                        if (Carbon::parse($formattedDate)->greaterThanOrEqualTo(Carbon::now())) {
                            return '-';
                        }

                        $attendance = $employee->reportAttendances->where('attendance_date', $formattedDate)->first();

                        if ($attendance) {
                            if ($attendance->status) {
                                if ($attendance->is_checked) {
                                    return '<span class="text-success">' . $attendance->status . '</span>';
                                } else {
                                    return '<span class="text-danger">' . $attendance->status . '</span>';
                                }
                            } else {
                                $time = Carbon::parse($attendance->work_time)->format('H:i');
                                if ($attendance->is_underwork) {
                                    return '<span class="text-danger">' . $time . '</span>';
                                } else {
                                    return '<span class="text-success">' . $time . '</span>';
                                }
                            }
                        } else {
                            $holiday = Holiday::where([
                                ['start_date', '<=', $formattedDate],
                                ['end_date', '>=', $formattedDate]
                            ])->first();
                            if ($day == 'Saturday' || $day == 'Sunday' || $holiday) {
                                return '-';
                            } else {
                                if ($employee->is_dispensation) {
                                    return '<span class="text-success">DIS</span>';
                                }
                                $leave = leave::with('leaveType')->where([
                                    ['employee_id', '=', $employee->id],
                                    ['start_date', '<=', $formattedDate],
                                    ['end_date', '>=', $formattedDate]
                                ])->first();
                                if ($leave) {
                                    $status = '';
                                    $leaveType = $leave->leaveType->id;
                                    switch ($leaveType) {
                                        case 1:
                                            $status = 'S';
                                            break;
                                        case 2:
                                            $status = 'I';
                                            break;
                                        case 3:
                                            if ($leave->is_half) {
                                                $status = 'C1';
                                            } else {
                                                $status = 'C';
                                            }
                                            break;
                                        case 4:
                                            $status = 'M';
                                            break;
                                        case 5:
                                            $status = 'C1';
                                            break;
                                        case 6:
                                            $status = 'C2';
                                            break;
                                        case 7:
                                            $status = 'C3';
                                            break;
                                        case 8:
                                            $status = 'C4';
                                            break;
                                        case 9:
                                            $status = 'DL';
                                            break;
                                        case 10:
                                            $status = 'IK1';
                                            break;
                                        case 11:
                                            $status = 'IK2';
                                            break;
                                        case 12:
                                            $status = 'IT1';
                                            break;
                                        case 13:
                                            $status = 'IT2';
                                            break;
                                        case 14:
                                            $status = 'IP';
                                            break;
                                        case 15:
                                            $status = 'TA1';
                                            break;
                                        case 16:
                                            $status = 'TA2';
                                            break;
                                        case 17:
                                            $status = 'DIS';
                                            break;
                                        case 18:
                                            $status = 'PG';
                                            break;
                                        default:
                                            $status =  '-';
                                    }
                                    return '<span class="text-primary">' . $status . '</span>';
                                } else {
                                    $status = 'TA3';
                                    return '<span class="text-danger">' . $status . '</span>';
                                }
                            }
                        }
                    });
                }
                $datatables->addColumn('remaining_leave', function ($row) {
                    return $row->remaining_leave;
                });
                $datatables->rawColumns($dates);
                return $datatables->make(true);
            }

            return view('timesheet.report_attendances.full', compact('companies'));
        }
        return response()->json(['success' => __('You are not authorized')]);
    }

    public function fullReportAttendanceHeader(Request $request)
    {
        $logged_user = auth()->user();
        if ($logged_user->can('report-attendance')) {
            if ($request->date) {
                $startDate = Carbon::parse($request->date)->startOfMonth();
                $endDate = Carbon::parse($request->date)->endOfMonth();
            } else {
                $startDate = Carbon::now()->startOfMonth();
                $endDate = Carbon::now()->endOfMonth();
            }

            $period = CarbonPeriod::create($startDate, $endDate);
            $dates = [];
            $holidays = [];

            $fixedHolidays = Holiday::where('is_publish', 1)->get();
            foreach ($period as $key => $date) {
                $dates[] =  $date->format('d-m-Y');
                if ($date->isWeekend()) {
                    $holidays[] = $key + 3;
                } else {
                    foreach ($fixedHolidays as $fixedHoliday) {
                        if ($date->betweenIncluded(Carbon::parse($fixedHoliday->start_date), Carbon::parse($fixedHoliday->end_date))) {
                            $hollidays[] = $key + 3;
                        }
                    }
                }
            }
            return response()->json([
                'dates' => $dates,
                'holidays' => $holidays
            ]);
        }
        return response()->json(['success' => __('You are not authorized')]);
    }

    public function export()
    {
        return Excel::download(new ReportAttendanceExport, 'Report Attendances.xlsx');
    }

    public function checkAttendance(Request $request)
    {
        $logged_user = auth()->user();

        if ($logged_user->can('report-attendance')) {
            if ($request->is_checked) {
                $attendance_date = Carbon::create($request->attendance_date)->format('Y-m-d');
                $match = [
                    'employee_id' => $request->employee_id,
                    'attendance_date' => $attendance_date,
                ];
                $reportAttendance = ReportAttendance::updateOrCreate(
                    $match,
                    [
                        'employee_id' => $request->employee_id,
                        'attendance_date' => $attendance_date,
                        'status' => $request->status,
                        'is_checked' => $request->is_checked
                    ]
                );

                LogReportAttendance::create([
                    'user_id' => $logged_user->id,
                    'report_attendance_id' => $reportAttendance->id,
                    'type' => 'check',
                ]);
            }

            return response()->json(['success' => __('Data is successfully updated')]);
        }

        return response()->json(['success' => __('You are not authorized')]);
    }
}
