<?php

namespace App\Http\Controllers;

use App\Employee;
use App\SalaryTunjanganKehadiran;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SalaryTunjanganKehadiranController extends Controller
{
	public function show(Employee $employee)
    {
        $logged_user = auth()->user();
        if ($logged_user->can('view-details-employee'))
        {
            if (request()->ajax())
            {
                $tunjangan_kehadiran = SalaryTunjanganKehadiran::with('payslipMonthYear')
                                            ->where('employee_id', $employee->id)
                                            ->orderByRaw('DATE_FORMAT(first_date, "%y-%m")')
                                            ->get();

                return datatables()->of($tunjangan_kehadiran)
                ->setRowId(function ($row)
                {
                    return $row->id;
                })
                ->addColumn('action', function ($row)
                {
                    if (auth()->user()->can('modify-details-employee'))
                    {
                        $paid = 0;
                        foreach ($row->payslipMonthYear as $key => $value) {
                            if ($row->month_year == $value->month_year) {
                                $paid = 1;
                            }
                        }
                        if ($paid==1) {
                            $button = '<button type="button" name="edit" data-id="'.$row->id.'" disabled class="salary_kehadiran_edit btn btn-primary btn-sm" title="Can not edit"><i class="dripicons-pencil"></i></button>';
                            $button .= '&nbsp;&nbsp;';
                            $button .= '<button type="button" name="delete" data-id="'.$row->id.'" disabled class="salary_kehadiran_delete btn btn-danger btn-sm" title="Can not delete"><i class="dripicons-trash"></i></button>';
                        }else {
                            $button = '<button type="button" name="edit" data-id="'.$row->id.'" class="salary_kehadiran_table_edit btn btn-primary btn-sm" title="Edit"><i class="dripicons-pencil"></i></button>';
                            $button .= '&nbsp;&nbsp;';
                            $button .= '<button type="button" name="delete" data-id="'.$row->id.'" class="salary_kehadiran_table_delete btn btn-danger btn-sm" title="Delete"><i class="dripicons-trash"></i></button>';
                        }

                        return $button;
                    } else
                    {
                        return '';
                    }
                })
                ->rawColumns(['action'])
                ->make(true);
            }
            return view('employee.salary.tunjangan_kehadiran.index',compact('employee'));
        }
        return response()->json(['success' => __('You are not authorized')]);

    }


    public function store(Request $request, Employee $employee)
    {
        $logged_user = auth()->user();
		if ($logged_user->can('store-details-employee'))
		{
            $validator = Validator::make($request->only('month_year', 'payslip_type','salary_kehadiran'),[
                'month_year' => 'required',
                'payslip_type' => 'required',
                'salary_kehadiran' => 'required|numeric',
            ]);

            if ($validator->fails())
            {
                return response()->json(['errors' => $validator->errors()->all()]);
            }

            $check_month_year = SalaryTunjanganKehadiran::where('month_year',$request->month_year)->where('employee_id',$employee->id)->exists();
            if ($check_month_year==true) {
                return response()->json(['check_month_year' => "Salary has already been assigned for this month."]);
            }

            $first_date = date('Y-m-d', strtotime('first day of ' . $request->month_year));

            $salary_basic = new SalaryTunjanganKehadiran();
            $salary_basic->employee_id  = $employee->id;
            $salary_basic->month_year   = $request->month_year;
            $salary_basic->first_date   = $first_date;
            $salary_basic->payslip_type = $request->payslip_type;
            $salary_basic->salary_kehadiran = $request->salary_kehadiran;
            $salary_basic->save();

            return response()->json(['success' => __('Data Added successfully.')]);
        }
        return response()->json(['success' => __('You are not authorized')]);
    }

    public function edit($id)
    {
        if (request()->ajax())
		{
			$data = SalaryTunjanganKehadiran::findOrFail($id);

			return response()->json(['data' => $data]);
		}
    }


    public function update(Request $request)
    {
        $logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee'))
		{
			$id = $request->hidden_id;

			$validator = Validator::make($request->only('month_year', 'payslip_type','salary_kehadiran'),[
                'month_year' => 'required',
                'payslip_type' => 'required',
                'salary_kehadiran' => 'required|numeric',
            ]);

			if ($validator->fails())
			{
				return response()->json(['errors' => $validator->errors()->all()]);
			}

            $check_month_year = SalaryTunjanganKehadiran::where('month_year',$request->month_year)
                                    ->where('employee_id',$request->employee_id)
                                    ->where('id','!=',$id)
                                    ->exists();

            if ($check_month_year==true) {
                return response()->json(['check_month_year' => "Salary has already been assigned for this month."]);
            }

            $first_date = date('Y-m-d', strtotime('first day of ' . $request->month_year));

            $salary_basic = SalaryTunjanganKehadiran::find($id);
            $salary_basic->month_year   = $request->month_year;
            $salary_basic->first_date   = $first_date;
            $salary_basic->payslip_type = $request->payslip_type;
            $salary_basic->salary_kehadiran = $request->salary_kehadiran;
            $salary_basic->update();

			return response()->json(['success' => __('Data is successfully updated')]);
		}

		return response()->json(['success' => __('You are not authorized')]);
    }


    public function destroy($id)
    {
        $logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee'))
		{
			$salary_basic = SalaryTunjanganKehadiran::find($id);
            $salary_basic->delete();

			return response()->json(['success' => __('Data is successfully deleted')]);
		}

		return response()->json(['success' => __('You are not authorized')]);
    }
}
