<?php

namespace App\Imports;

use App\Attendance;
use App\Employee;
use App\leave;
use App\office_shift;
use App\RawAttendance;
use App\ReportAttendance;
use Carbon\Carbon;
use DateTime;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class AttendancesImport implements ToCollection, WithHeadingRow, ShouldQueue, WithChunkReading, WithBatchInserts, WithValidation
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function collection(Collection $rows)
    {
        $rows = $rows->sortBy('id_karyawan');
        $skip = false;
        foreach ($rows as $key => $row) {
            if (is_string($row['tanggal'])) {
                $date = $row['tanggal'];
            } else {
                $date = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['tanggal'])->format('Y-m-d');
            }
            if (is_string($row['jam'])) {
                $time = $row['jam'];
            } else {
                $time = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['jam'])->format('H:i:s');
            }

            $employee = Employee::with(['officeShift'])->find($row['id_karyawan']);

            $day = Carbon::parse($date)->format('l');

            switch ($day) {
                case 'Sunday':
                    $clockInRange = $employee->officeShift::first()->sunday_range_in;
                    $clockOutRange = $employee->officeShift::first()->sunday_range_out;
                    $clockIn = $employee->officeShift::first()->sunday_in;
                    $clockOut = $employee->officeShift::first()->sunday_out;
                    break;
                case 'Monday':
                    $clockInRange = $employee->officeShift::first()->monday_range_in;
                    $clockOutRange = $employee->officeShift::first()->monday_range_out;
                    $clockIn = $employee->officeShift::first()->monday_in;
                    $clockOut = $employee->officeShift::first()->monday_out;
                    break;
                case 'Tuesday':
                    $clockInRange = $employee->officeShift::first()->tuesday_range_in;
                    $clockOutRange = $employee->officeShift::first()->tuesday_range_out;
                    $clockIn = $employee->officeShift::first()->tuesday_in;
                    $clockOut = $employee->officeShift::first()->tuesday_out;
                    break;
                case 'Wednesday':
                    $clockInRange = $employee->officeShift::first()->wednesday_range_in;
                    $clockOutRange = $employee->officeShift::first()->wednesday_range_out;
                    $clockIn = $employee->officeShift::first()->wednesday_in;
                    $clockOut = $employee->officeShift::first()->wednesday_out;
                    break;
                case 'Thursday':
                    $clockInRange = $employee->officeShift::first()->thursday_range_in;
                    $clockOutRange = $employee->officeShift::first()->thursday_range_out;
                    $clockIn = $employee->officeShift::first()->thursday_in;
                    $clockOut = $employee->officeShift::first()->thursday_out;
                    break;
                case 'Friday':
                    $clockInRange = $employee->officeShift::first()->friday_range_in;
                    $clockOutRange = $employee->officeShift::first()->friday_range_out;
                    $clockIn = $employee->officeShift::first()->friday_in;
                    $clockOut = $employee->officeShift::first()->friday_out;
                    break;
                default:
                    $clockInRange = $employee->officeShift::first()->saturday_range_in;
                    $clockOutRange = $employee->officeShift::first()->saturday_range_out;
                    $clockIn = $employee->officeShift::first()->saturday_in;
                    $clockOut = $employee->officeShift::first()->saturday_out;
            }

            $match = [
                'employee_id' => $row['id_karyawan'],
                'attendance_date' => $date,
            ];
            $matchRaw = [
                'employee_id' => $row['id_karyawan'],
                'attendance_date' => $date,
                'attendance_time' => $time
            ];
            $matchAttendance = [
                'employee_id' => $row['id_karyawan'],
                'attendance_date' => $date,
            ];

            RawAttendance::updateOrCreate($matchRaw, [
                'employee_id' => $row['id_karyawan'],
                'attendance_date' => $date,
                'attendance_time' => $time
            ]);

            $clockInRange = Carbon::createFromTimeString($clockInRange);
            $clockOutRange = Carbon::createFromTimeString($clockOutRange);
            $clockIn = Carbon::createFromTimeString($clockIn);
            $clockOut = Carbon::createFromTimeString($clockOut);
            $minWorkTime = Employee::with('officeShift')->find($row['id_karyawan'])->officeShift->min_work_hour;

            if ($skip) {
                $skip = false;
                continue;
            }

            $in = $row;
            if (is_string($in['jam'])) {
                $inTimeString = $in['jam'];
            } else {
                $inTimeString = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($in['jam'])->format('H:i:s');
            }
            if (isset($rows[$key + 1])) {
                $out = $rows[$key + 1];
                $match = [
                    'employee_id' => $in['id_karyawan'],
                    'attendance_date' => $date,
                ];
                if (is_string($out['jam'])) {
                    $outTimeString = $out['jam'];
                } else {
                    $outTimeString = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($out['jam'])->format('H:i:s');
                }
                if (is_string($out['tanggal'])) {
                    $outDate = $out['tanggal'];
                } else {
                    $outDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($out['tanggal'])->format('Y-m-d');
                }
                $inTime = Carbon::createFromTimeString($inTimeString);
                $outTime = Carbon::createFromTimeString($outTimeString);
                $workTime = '00:00';
                $employeeClockIn = Carbon::createFromTimeString($inTimeString)->format('H:i');
                $employeeClockOut = Carbon::createFromTimeString($outTimeString)->format('H:i');
                $status = null;
                $isUnderwork = false;

                if ($in['id_karyawan'] == $out['id_karyawan']) {
                    if ($date == $outDate) {
                        $workTime = $outTime->diff($inTime)->format('%H:%I');
                    } else {
                        $diffSec = $outTime->diffInSeconds($inTime);
                        $workTime = Carbon::createFromTimeString('00:00')->subSeconds($diffSec)->format('H:i');
                        if ($inTime->greaterThan($clockIn)) {
                            $employeeClockOut = $employeeClockIn;
                            $employeeClockIn = '';
                            $status = 'TA1';
                            $workTime = '00:00';
                        } else if ($inTime->greaterThanOrEqualTo($clockInRange) && $inTime->lessThan($clockIn)) {
                            if ($outTime->greaterThanOrEqualTo($clockInRange)) {
                                $status = 'TA2';
                                $workTime = '00:00';
                                $employeeClockOut = '';
                            } else {
                                $skip = true;
                            }
                        } else if ($outTime->greaterThanOrEqualTo($clockInRange)) {
                            $status = 'TA2';
                        } else {
                            $employeeClockOut = Carbon::createFromTimeString($outTimeString)->format('H:i');
                            $skip = true;
                        }
                    }
                } else {
                    $status = 'TA2';
                }

                if (Carbon::createFromTimeString($workTime)->hour < $minWorkTime) {
                    $isUnderwork = true;
                }

                Attendance::updateOrCreate($matchAttendance, [
                    'employee_id' => $in['id_karyawan'],
                    'attendance_date' => $date,
                    'clock_in' => $employeeClockIn,
                    'clock_out' => $employeeClockOut,
                    'total_work' => $workTime
                ]);

                ReportAttendance::updateOrCreate($match, [
                    'employee_id' => $in['id_karyawan'],
                    'attendance_date' => $date,
                    'work_time' => $workTime,
                    'status' => $status,
                    'is_underwork' => $isUnderwork
                ]);
            } else {
                $checkAttendance = Attendance::where([['employee_id', '=', $in['id_karyawan']], ['attendance_date', '=', $date]])->first();
                if ($checkAttendance != null) {
                    return;
                }

                $time = Carbon::createFromTimeString($inTimeString);
                $workTime = '00:00';
                $employeeClockIn = '';
                $employeeClockOut = '';
                $status = null;
                $isUnderwork = false;

                if ($time->greaterThan($clockIn)) {
                    $employeeClockOut = $time->format('H:i');
                    $status = 'TA1';
                } else {
                    $employeeClockIn = $time->format('H:i');
                    $status = 'TA2';
                }

                Attendance::updateOrCreate($matchAttendance, [
                    'employee_id' => $in['id_karyawan'],
                    'attendance_date' => $date,
                    'clock_in' => $employeeClockIn,
                    'clock_out' => $employeeClockOut,
                    'total_work' => $workTime
                ]);

                ReportAttendance::updateOrCreate($match, [
                    'employee_id' => $in['id_karyawan'],
                    'attendance_date' => $date,
                    'work_time' => $workTime,
                    'status' => $status,
                    'is_underwork' => $isUnderwork
                ]);
            }
        }
    }


    public function rules(): array
    {
        return [
            'id_karyawan' => 'required',
            'tanggal' => 'required',
            'jam' => 'required',
        ];
    }

    public function chunkSize(): int
    {
        return 500;
    }

    public function batchSize(): int
    {
        return 500;
    }
}
