<?php


namespace App\Imports;

use App\company;
use App\department;
use App\designation;
use App\Employee;
use App\EmployeeBankAccount;
use App\EmployeeSetting;
use App\GeneralSetting;
use App\office_shift;
use App\SalaryBasic;
use App\status;
use App\User;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class EmployeeImport implements ToCollection, WithHeadingRow, ShouldQueue, WithChunkReading
{
	public function collection(Collection $rows)
	{
		foreach ($rows as $row) {
			$officeShiftId = office_shift::where('shift_name', $row['shift_name'])->select('id')->first()->id;
			$companyId = company::where('company_name', $row['company_name'])->select('id')->first()->id;
			$departmentId = department::where('department_name', $row['department_name'])->where('company_id', $companyId)->select('id')->first()->id;
			$designationId = designation::where('designation_name', $row['designation_name'])->where('company_id', $companyId)->where('department_id', $departmentId)->select('id')->first()->id;
			$statusId = status::where('status_title', $row['status'])->select('id')->first()->id;

			if (is_string($row['joining_date'])) {
				$joiningDate = $row['joining_date'];
			} else {
				$joiningDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['joining_date'])->format('Y-m-d');
			}

			if (is_string($row['date_of_birth'])) {
				$birthDate = $row['date_of_birth'];
			} else {
				$birthDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['date_of_birth'])->format('Y-m-d');
			}

			if ($row['username'] != null && $row['username'] != '') {
				$user = User::create([
					'username' => $row['username'],
					'email' => $row['email'],
					'password' => Hash::make($row['password']),
					'contact_no' => $row['contact_no'],
					'role_users_id' => 2
				]);

				$employee = Employee::create([
					'id' => $user->id,
					'first_name' => $row['first_name'],
					'last_name' => $row['last_name'],
					'staff_id' => $row['staff_id'],
					'email' => $row['email'],
					'identity_number' => $row['identity_number'],
					'contact_no' => $row['contact_no'],
					'date_of_birth' => $birthDate,
					'gender' => $row['gender'],
					'office_shift_id' => $officeShiftId,
					'company_id' => $companyId,
					'department_id' => $departmentId,
					'designation_id' => $designationId,
					'role_users_id' => 2,
					'status_id' => $statusId,
					'joining_date' => $joiningDate,
					'marital_status' => $row['marital_status'],
					'dependent' => $row['dependent'],
					'address' => $row['address'],
					'city' => $row['city'],
					'state' => $row['state'],
					'zip_code' => $row['zip'],
					'attendance_type' => 'general',
					'position' => $row['position'],
					'is_dispensation' => $row['dispensation'],
					'is_active' => 1,
				]);
			} else {
				$employee = Employee::create([
					'first_name' => $row['first_name'],
					'last_name' => $row['last_name'],
					'staff_id' => $row['staff_id'],
					'email' => $row['email'],
					'identity_number' => $row['identity_number'],
					'contact_no' => $row['contact_no'],
					'date_of_birth' => $birthDate,
					'gender' => $row['gender'],
					'office_shift_id' => $officeShiftId,
					'company_id' => $companyId,
					'department_id' => $departmentId,
					'designation_id' => $designationId,
					'role_users_id' => 2,
					'status_id' => $statusId,
					'joining_date' => $joiningDate,
					'marital_status' => $row['marital_status'],
					'dependent' => $row['dependent'],
					'address' => $row['address'],
					'city' => $row['city'],
					'state' => $row['state'],
					'zip_code' => $row['zip'],
					'attendance_type' => 'general',
					'position' => $row['position'],
					'is_dispensation' => $row['dispensation'],
					'is_active' => 1,
				]);
			}


			if ($row['basic_salary_month_year'] != null && $row['basic_salary_month_year'] != '') {
				$firstDate = date('Y-m-d', strtotime('first day of ' . $row['basic_salary_month_year']));
				SalaryBasic::create([
					'employee_id' => $employee->id,
					'month_year' => $row['basic_salary_month_year'],
					'first_date' => $firstDate,
					'payslip_type' => $row['basic_salary_payslip'],
					'basic_salary' => $row['basic_salary']
				]);
			}

			if ($row['bank_account_title'] != null && $row['bank_account_title'] != '') {
				EmployeeBankAccount::create([
					'employee_id' => $employee->id,
					'account_title' => $row['bank_account_title'],
					'account_number' => $row['bank_account_number'],
					'bank_name' => $row['bank_name'],
					'bank_code' => $row['bank_code'],
					'bank_branch' => $row['bank_branch'],
				]);
			}

			EmployeeSetting::create([
				'employee_id' => $employee->id,
				'is_bpjs_tk_include' => $row['include_bpjs_tk'],
				'is_bpjs_kes_include' => $row['include_bpjs_kes'],
				'is_tax_include' => $row['include_tax'],
			]);
		}
	}
	public function chunkSize(): int
	{
		return 500;
	}
}
