<?php

namespace App\Mail;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DailyReportAttendanceMail extends Mailable
{
    use Queueable, SerializesModels;
    protected $attendances;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($attendances)
    {
        $this->attendances = $attendances;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.daily_report_attendance', ['date' => Carbon::yesterday()->format(env('Date_Format')), 'attendances' => $this->attendances]);
    }
}
