<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PTKP extends Model
{
    use HasFactory;

    protected $fillable = ['company_id', 'name', 'value'];
    protected $table = 'ptkp';
    protected $appends = ['value_formatted'];

    public function company()
    {
        return $this->belongsTo(company::class);
    }

    public function getValueFormattedAttribute()
    {
        return number_format($this->attributes['value'], 0, ',', '.');
    }
}
