<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReportAttendance extends Model
{
    use HasFactory;

    protected $fillable = ['employee_id', 'attendance_date', 'work_time', 'office_shift_id', 'status', 'is_checked', 'is_underwork'];

    public function employee()
	{
		return $this->belongsTo(Employee::class);
	}

    public function officeShift()
	{
		return $this->hasOne('App\office_shift', 'id', 'office_shift_id');
	}
}
