<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SalaryOtherPayment extends Model
{
    //
	protected $guarded=[];
	protected $appends = ['other_payment_amount_formatted'];

	public function employee(){
		return $this->hasOne('App\Employee','id','employee_id');
	}
	public function getOtherPaymentAmountFormattedAttribute()
	{
		return number_format($this->attributes['other_payment_amount'], 0, ',', '.');
	}
}
