<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFollowingAttendanceToEmployees extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->unsignedBigInteger('following_company_id')->nullable()->after('status_id');
            $table->unsignedBigInteger('following_employee_id')->nullable()->after('following_company_id');
            
            $table->foreign('following_company_id')->references('id')->on('companies')->nullOnDelete();
            $table->foreign('following_employee_id')->references('id')->on('employees')->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->dropColumn(['following_company_id', 'following_employee_id']);
        });
    }
}
