<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRangeInOutToOfficeShiftsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('office_shifts', function (Blueprint $table) {
            $table->string('sunday_range_in');
            $table->string('sunday_range_out');
            $table->string('saturday_range_in');
            $table->string('saturday_range_out');
            $table->string('friday_range_in');
            $table->string('friday_range_out');
            $table->string('thursday_range_in');
            $table->string('thursday_range_out');
            $table->string('wednesday_range_in');
            $table->string('wednesday_range_out');
            $table->string('tuesday_range_in');
            $table->string('tuesday_range_out');
            $table->string('monday_range_in');
            $table->string('monday_range_out');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('out_to_office_shifts', function (Blueprint $table) {
            $table->dropColumn([
                'sunday_range_in',
                'sunday_range_out',
                'saturday_range_in',
                'saturday_range_out',
                'friday_range_in',
                'friday_range_out',
                'thursday_range_in',
                'thursday_range_out',
                'wednesday_range_in',
                'wednesday_range_out',
                'tuesday_range_in',
                'tuesday_range_out',
                'monday_range_in',
                'monday_range_out',
            ]);
        });
    }
}
