SET foreign_key_checks = 0;

CREATE TABLE `announcements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `summary` text DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `added_by` varchar(40) DEFAULT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `announcements_company_id_foreign` (`company_id`),
  KEY `announcements_department_id_foreign` (`department_id`),
  KEY `announcements_added_by_foreign` (`added_by`),
  CONSTRAINT `announcements_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `announcements_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `appraisals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `department_id` bigint(20) unsigned NOT NULL,
  `designation_id` bigint(20) unsigned NOT NULL,
  `customer_experience` varchar(191) NOT NULL,
  `marketing` varchar(191) DEFAULT NULL,
  `administration` varchar(191) DEFAULT NULL,
  `professionalism` varchar(191) DEFAULT NULL,
  `integrity` varchar(191) DEFAULT NULL,
  `attendance` varchar(191) DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `date` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `asset_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `category_name` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `asset_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `assets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_name` varchar(50) NOT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `asset_code` varchar(80) NOT NULL,
  `assets_category_id` bigint(20) unsigned NOT NULL,
  `Asset_note` mediumtext DEFAULT NULL,
  `manufacturer` varchar(191) NOT NULL,
  `serial_number` varchar(191) NOT NULL,
  `invoice_number` varchar(191) NOT NULL,
  `asset_image` varchar(191) DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `warranty_date` date NOT NULL,
  `status` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_company_id_foreign` (`company_id`),
  KEY `assets_employee_id_foreign` (`employee_id`),
  KEY `assets_assets_category_id_foreign` (`assets_category_id`),
  CONSTRAINT `assets_assets_category_id_foreign` FOREIGN KEY (`assets_category_id`) REFERENCES `asset_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `attendance_date` date NOT NULL,
  `clock_in` varchar(191) NOT NULL,
  `clock_out` varchar(191) NOT NULL,
  `total_work` varchar(191) NOT NULL DEFAULT '00:00',
  `is_underwork` tinyint(1) NOT NULL,
  `status` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attendances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `attendances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `award_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `award_name` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `awards` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `award_information` mediumtext DEFAULT NULL,
  `award_date` date NOT NULL,
  `gift` varchar(40) DEFAULT NULL,
  `cash` varchar(40) DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `award_type_id` bigint(20) unsigned DEFAULT NULL,
  `award_photo` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `awards_company_id_foreign` (`company_id`),
  KEY `awards_department_id_foreign` (`department_id`),
  KEY `awards_employee_id_foreign` (`employee_id`),
  KEY `awards_award_type_id_foreign` (`award_type_id`),
  CONSTRAINT `awards_award_type_id_foreign` FOREIGN KEY (`award_type_id`) REFERENCES `award_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL,
  CONSTRAINT `awards_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `bpjs_kes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `company` decimal(8,2) NOT NULL,
  `employee` decimal(8,2) NOT NULL,
  `min_salary` double NOT NULL,
  `max_salary` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bpjs_kes_company_id_foreign` (`company_id`),
  CONSTRAINT `bpjs_kes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `bpjs_tk` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `general` decimal(8,2) NOT NULL,
  `company` decimal(8,2) NOT NULL,
  `employee` decimal(8,2) NOT NULL,
  `type` enum('pensiun','jht','jkm','jkk') DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bpjs_tk_company_id_foreign` (`company_id`),
  CONSTRAINT `bpjs_tk_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `c_m_s` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `home` longtext DEFAULT NULL,
  `about` longtext DEFAULT NULL,
  `contact` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `calendarables` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `candidate_interview` (
  `interview_id` bigint(20) unsigned NOT NULL,
  `candidate_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`interview_id`,`candidate_id`),
  KEY `candidate_interview_candidate_id_foreign` (`candidate_id`),
  CONSTRAINT `candidate_interview_candidate_id_foreign` FOREIGN KEY (`candidate_id`) REFERENCES `job_candidates` (`id`),
  CONSTRAINT `candidate_interview_interview_id_foreign` FOREIGN KEY (`interview_id`) REFERENCES `job_interviews` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) NOT NULL,
  `last_name` varchar(191) NOT NULL,
  `email` varchar(191) DEFAULT NULL,
  `contact_no` varchar(15) NOT NULL,
  `username` varchar(64) NOT NULL,
  `profile` varchar(191) DEFAULT NULL,
  `company_name` varchar(191) NOT NULL,
  `gender` varchar(40) NOT NULL,
  `website` varchar(40) DEFAULT NULL,
  `address1` mediumtext DEFAULT NULL,
  `address2` mediumtext DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `zip` varchar(191) DEFAULT NULL,
  `country` tinyint(4) DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `clients_id_foreign` FOREIGN KEY (`id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `companies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(191) NOT NULL,
  `company_type` varchar(191) NOT NULL,
  `trading_name` varchar(191) DEFAULT NULL,
  `registration_no` varchar(191) DEFAULT NULL,
  `contact_no` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `tax_no` varchar(191) DEFAULT NULL,
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `company_logo` varchar(191) DEFAULT NULL,
  `start_cut_off_date` tinyint(4) NOT NULL,
  `end_cut_off_date` tinyint(4) NOT NULL,
  `leave_amount` int(11) NOT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companies_location_id_foreign` (`location_id`),
  CONSTRAINT `companies_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `locations` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO companies VALUES('1','HEAD OFFICE','corporation','HO','','0213522828','hrga@timas.com','','01.335.995.5-073.000','1','','1','31','21','','2024-02-05 15:36:37','2024-02-05 15:36:37');



CREATE TABLE `complaints` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `complaint_title` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `complaint_from` bigint(20) unsigned NOT NULL,
  `complaint_against` bigint(20) unsigned NOT NULL,
  `complaint_date` date NOT NULL,
  `status` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `complaints_company_id_foreign` (`company_id`),
  KEY `complaints_complaint_from_foreign` (`complaint_from`),
  KEY `complaints_complaint_against_foreign` (`complaint_against`),
  CONSTRAINT `complaints_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `complaints_complaint_against_foreign` FOREIGN KEY (`complaint_against`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `complaints_complaint_from_foreign` FOREIGN KEY (`complaint_from`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO countries VALUES('1','US','United States');
INSERT INTO countries VALUES('2','CA','Canada');
INSERT INTO countries VALUES('3','AF','Afghanistan');
INSERT INTO countries VALUES('4','AL','Albania');
INSERT INTO countries VALUES('5','DZ','Algeria');
INSERT INTO countries VALUES('6','DS','American Samoa');
INSERT INTO countries VALUES('7','AD','Andorra');
INSERT INTO countries VALUES('8','AO','Angola');
INSERT INTO countries VALUES('9','AI','Anguilla');
INSERT INTO countries VALUES('10','AQ','Antarctica');
INSERT INTO countries VALUES('11','AG','Antigua and/or Barbuda');
INSERT INTO countries VALUES('12','AR','Argentina');
INSERT INTO countries VALUES('13','AM','Armenia');
INSERT INTO countries VALUES('14','AW','Aruba');
INSERT INTO countries VALUES('15','AU','Australia');
INSERT INTO countries VALUES('16','AT','Austria');
INSERT INTO countries VALUES('17','AZ','Azerbaijan');
INSERT INTO countries VALUES('18','BS','Bahamas');
INSERT INTO countries VALUES('19','BH','Bahrain');
INSERT INTO countries VALUES('20','BD','Bangladesh');
INSERT INTO countries VALUES('21','BB','Barbados');
INSERT INTO countries VALUES('22','BY','Belarus');
INSERT INTO countries VALUES('23','BE','Belgium');
INSERT INTO countries VALUES('24','BZ','Belize');
INSERT INTO countries VALUES('25','BJ','Benin');
INSERT INTO countries VALUES('26','BM','Bermuda');
INSERT INTO countries VALUES('27','BT','Bhutan');
INSERT INTO countries VALUES('28','BO','Bolivia');
INSERT INTO countries VALUES('29','BA','Bosnia and Herzegovina');
INSERT INTO countries VALUES('30','BW','Botswana');
INSERT INTO countries VALUES('31','BV','Bouvet Island');
INSERT INTO countries VALUES('32','BR','Brazil');
INSERT INTO countries VALUES('33','IO','British lndian Ocean Territory');
INSERT INTO countries VALUES('34','BN','Brunei Darussalam');
INSERT INTO countries VALUES('35','BG','Bulgaria');
INSERT INTO countries VALUES('36','BF','Burkina Faso');
INSERT INTO countries VALUES('37','BI','Burundi');
INSERT INTO countries VALUES('38','KH','Cambodia');
INSERT INTO countries VALUES('39','CM','Cameroon');
INSERT INTO countries VALUES('40','CV','Cape Verde');
INSERT INTO countries VALUES('41','KY','Cayman Islands');
INSERT INTO countries VALUES('42','CF','Central African Republic');
INSERT INTO countries VALUES('43','TD','Chad');
INSERT INTO countries VALUES('44','CL','Chile');
INSERT INTO countries VALUES('45','CN','China');
INSERT INTO countries VALUES('46','CX','Christmas Island');
INSERT INTO countries VALUES('47','CC','Cocos (Keeling) Islands');
INSERT INTO countries VALUES('48','CO','Colombia');
INSERT INTO countries VALUES('49','KM','Comoros');
INSERT INTO countries VALUES('50','CG','Congo');
INSERT INTO countries VALUES('51','CK','Cook Islands');
INSERT INTO countries VALUES('52','CR','Costa Rica');
INSERT INTO countries VALUES('53','HR','Croatia (Hrvatska)');
INSERT INTO countries VALUES('54','CU','Cuba');
INSERT INTO countries VALUES('55','CY','Cyprus');
INSERT INTO countries VALUES('56','CZ','Czech Republic');
INSERT INTO countries VALUES('57','DK','Denmark');
INSERT INTO countries VALUES('58','DJ','Djibouti');
INSERT INTO countries VALUES('59','DM','Dominica');
INSERT INTO countries VALUES('60','DO','Dominican Republic');
INSERT INTO countries VALUES('61','TP','East Timor');
INSERT INTO countries VALUES('62','EC','Ecudaor');
INSERT INTO countries VALUES('63','EG','Egypt');
INSERT INTO countries VALUES('64','SV','El Salvador');
INSERT INTO countries VALUES('65','GQ','Equatorial Guinea');
INSERT INTO countries VALUES('66','ER','Eritrea');
INSERT INTO countries VALUES('67','EE','Estonia');
INSERT INTO countries VALUES('68','ET','Ethiopia');
INSERT INTO countries VALUES('69','FK','Falkland Islands (Malvinas)');
INSERT INTO countries VALUES('70','FO','Faroe Islands');
INSERT INTO countries VALUES('71','FJ','Fiji');
INSERT INTO countries VALUES('72','FI','Finland');
INSERT INTO countries VALUES('73','FR','France');
INSERT INTO countries VALUES('74','FX','France, Metropolitan');
INSERT INTO countries VALUES('75','GF','French Guiana');
INSERT INTO countries VALUES('76','PF','French Polynesia');
INSERT INTO countries VALUES('77','TF','French Southern Territories');
INSERT INTO countries VALUES('78','GA','Gabon');
INSERT INTO countries VALUES('79','GM','Gambia');
INSERT INTO countries VALUES('80','GE','Georgia');
INSERT INTO countries VALUES('81','DE','Germany');
INSERT INTO countries VALUES('82','GH','Ghana');
INSERT INTO countries VALUES('83','GI','Gibraltar');
INSERT INTO countries VALUES('84','GR','Greece');
INSERT INTO countries VALUES('85','GL','Greenland');
INSERT INTO countries VALUES('86','GD','Grenada');
INSERT INTO countries VALUES('87','GP','Guadeloupe');
INSERT INTO countries VALUES('88','GU','Guam');
INSERT INTO countries VALUES('89','GT','Guatemala');
INSERT INTO countries VALUES('90','GN','Guinea');
INSERT INTO countries VALUES('91','GW','Guinea-Bissau');
INSERT INTO countries VALUES('92','GY','Guyana');
INSERT INTO countries VALUES('93','HT','Haiti');
INSERT INTO countries VALUES('94','HM','Heard and Mc Donald Islands');
INSERT INTO countries VALUES('95','HN','Honduras');
INSERT INTO countries VALUES('96','HK','Hong Kong');
INSERT INTO countries VALUES('97','HU','Hungary');
INSERT INTO countries VALUES('98','IS','Iceland');
INSERT INTO countries VALUES('99','IN','India');
INSERT INTO countries VALUES('100','ID','Indonesia');
INSERT INTO countries VALUES('101','IR','Iran (Islamic Republic of)');
INSERT INTO countries VALUES('102','IQ','Iraq');
INSERT INTO countries VALUES('103','IE','Ireland');
INSERT INTO countries VALUES('104','IL','Israel');
INSERT INTO countries VALUES('105','IT','Italy');
INSERT INTO countries VALUES('106','CI','Ivory Coast');
INSERT INTO countries VALUES('107','JM','Jamaica');
INSERT INTO countries VALUES('108','JP','Japan');
INSERT INTO countries VALUES('109','JO','Jordan');
INSERT INTO countries VALUES('110','KZ','Kazakhstan');
INSERT INTO countries VALUES('111','KE','Kenya');
INSERT INTO countries VALUES('112','KI','Kiribati');
INSERT INTO countries VALUES('113','KP','Korea, Democratic People\'s Republic of');
INSERT INTO countries VALUES('114','KR','Korea, Republic of');
INSERT INTO countries VALUES('115','KW','Kuwait');
INSERT INTO countries VALUES('116','KG','Kyrgyzstan');
INSERT INTO countries VALUES('117','LA','Lao People\'s Democratic Republic');
INSERT INTO countries VALUES('118','LV','Latvia');
INSERT INTO countries VALUES('119','LB','Lebanon');
INSERT INTO countries VALUES('120','LS','Lesotho');
INSERT INTO countries VALUES('121','LR','Liberia');
INSERT INTO countries VALUES('122','LY','Libyan Arab Jamahiriya');
INSERT INTO countries VALUES('123','LI','Liechtenstein');
INSERT INTO countries VALUES('124','LT','Lithuania');
INSERT INTO countries VALUES('125','LU','Luxembourg');
INSERT INTO countries VALUES('126','MO','Macau');
INSERT INTO countries VALUES('127','MK','Macedonia');
INSERT INTO countries VALUES('128','MG','Madagascar');
INSERT INTO countries VALUES('129','MW','Malawi');
INSERT INTO countries VALUES('130','MY','Malaysia');
INSERT INTO countries VALUES('131','MV','Maldives');
INSERT INTO countries VALUES('132','ML','Mali');
INSERT INTO countries VALUES('133','MT','Malta');
INSERT INTO countries VALUES('134','MH','Marshall Islands');
INSERT INTO countries VALUES('135','MQ','Martinique');
INSERT INTO countries VALUES('136','MR','Mauritania');
INSERT INTO countries VALUES('137','MU','Mauritius');
INSERT INTO countries VALUES('138','TY','Mayotte');
INSERT INTO countries VALUES('139','MX','Mexico');
INSERT INTO countries VALUES('140','FM','Micronesia, Federated States of');
INSERT INTO countries VALUES('141','MD','Moldova, Republic of');
INSERT INTO countries VALUES('142','MC','Monaco');
INSERT INTO countries VALUES('143','MN','Mongolia');
INSERT INTO countries VALUES('144','MS','Montserrat');
INSERT INTO countries VALUES('145','MA','Morocco');
INSERT INTO countries VALUES('146','MZ','Mozambique');
INSERT INTO countries VALUES('147','MM','Myanmar');
INSERT INTO countries VALUES('148','NA','Namibia');
INSERT INTO countries VALUES('149','NR','Nauru');
INSERT INTO countries VALUES('150','NP','Nepal');
INSERT INTO countries VALUES('151','NL','Netherlands');
INSERT INTO countries VALUES('152','AN','Netherlands Antilles');
INSERT INTO countries VALUES('153','NC','New Caledonia');
INSERT INTO countries VALUES('154','NZ','New Zealand');
INSERT INTO countries VALUES('155','NI','Nicaragua');
INSERT INTO countries VALUES('156','NE','Niger');
INSERT INTO countries VALUES('157','NG','Nigeria');
INSERT INTO countries VALUES('158','NU','Niue');
INSERT INTO countries VALUES('159','NF','Norfork Island');
INSERT INTO countries VALUES('160','MP','Northern Mariana Islands');
INSERT INTO countries VALUES('161','NO','Norway');
INSERT INTO countries VALUES('162','OM','Oman');
INSERT INTO countries VALUES('163','PK','Pakistan');
INSERT INTO countries VALUES('164','PW','Palau');
INSERT INTO countries VALUES('165','PA','Panama');
INSERT INTO countries VALUES('166','PG','Papua New Guinea');
INSERT INTO countries VALUES('167','PY','Paraguay');
INSERT INTO countries VALUES('168','PE','Peru');
INSERT INTO countries VALUES('169','PH','Philippines');
INSERT INTO countries VALUES('170','PN','Pitcairn');
INSERT INTO countries VALUES('171','PL','Poland');
INSERT INTO countries VALUES('172','PT','Portugal');
INSERT INTO countries VALUES('173','PR','Puerto Rico');
INSERT INTO countries VALUES('174','QA','Qatar');
INSERT INTO countries VALUES('175','RE','Reunion');
INSERT INTO countries VALUES('176','RO','Romania');
INSERT INTO countries VALUES('177','RU','Russian Federation');
INSERT INTO countries VALUES('178','RW','Rwanda');
INSERT INTO countries VALUES('179','KN','Saint Kitts and Nevis');
INSERT INTO countries VALUES('180','LC','Saint Lucia');
INSERT INTO countries VALUES('181','VC','Saint Vincent and the Grenadines');
INSERT INTO countries VALUES('182','WS','Samoa');
INSERT INTO countries VALUES('183','SM','San Marino');
INSERT INTO countries VALUES('184','ST','Sao Tome and Principe');
INSERT INTO countries VALUES('185','SA','Saudi Arabia');
INSERT INTO countries VALUES('186','SN','Senegal');
INSERT INTO countries VALUES('187','SC','Seychelles');
INSERT INTO countries VALUES('188','SL','Sierra Leone');
INSERT INTO countries VALUES('189','SG','Singapore');
INSERT INTO countries VALUES('190','SK','Slovakia');
INSERT INTO countries VALUES('191','SI','Slovenia');
INSERT INTO countries VALUES('192','SB','Solomon Islands');
INSERT INTO countries VALUES('193','SO','Somalia');
INSERT INTO countries VALUES('194','ZA','South Africa');
INSERT INTO countries VALUES('195','GS','South Georgia South Sandwich Islands');
INSERT INTO countries VALUES('196','ES','Spain');
INSERT INTO countries VALUES('197','LK','Sri Lanka');
INSERT INTO countries VALUES('198','SH','St. Helena');
INSERT INTO countries VALUES('199','PM','St. Pierre and Miquelon');
INSERT INTO countries VALUES('200','SD','Sudan');
INSERT INTO countries VALUES('201','SR','Suriname');
INSERT INTO countries VALUES('202','SJ','Svalbarn and Jan Mayen Islands');
INSERT INTO countries VALUES('203','SZ','Swaziland');
INSERT INTO countries VALUES('204','SE','Sweden');
INSERT INTO countries VALUES('205','CH','Switzerland');
INSERT INTO countries VALUES('206','SY','Syrian Arab Republic');
INSERT INTO countries VALUES('207','TW','Taiwan');
INSERT INTO countries VALUES('208','TJ','Tajikistan');
INSERT INTO countries VALUES('209','TZ','Tanzania, United Republic of');
INSERT INTO countries VALUES('210','TH','Thailand');
INSERT INTO countries VALUES('211','TG','Togo');
INSERT INTO countries VALUES('212','TK','Tokelau');
INSERT INTO countries VALUES('213','TO','Tonga');
INSERT INTO countries VALUES('214','TT','Trinidad and Tobago');
INSERT INTO countries VALUES('215','TN','Tunisia');
INSERT INTO countries VALUES('216','TR','Turkey');
INSERT INTO countries VALUES('217','TM','Turkmenistan');
INSERT INTO countries VALUES('218','TC','Turks and Caicos Islands');
INSERT INTO countries VALUES('219','TV','Tuvalu');
INSERT INTO countries VALUES('220','UG','Uganda');
INSERT INTO countries VALUES('221','UA','Ukraine');
INSERT INTO countries VALUES('222','AE','United Arab Emirates');
INSERT INTO countries VALUES('223','GB','United Kingdom');
INSERT INTO countries VALUES('224','UM','United States minor outlying islands');
INSERT INTO countries VALUES('225','UY','Uruguay');
INSERT INTO countries VALUES('226','UZ','Uzbekistan');
INSERT INTO countries VALUES('227','VU','Vanuatu');
INSERT INTO countries VALUES('228','VA','Vatican City State');
INSERT INTO countries VALUES('229','VE','Venezuela');
INSERT INTO countries VALUES('230','VN','Vietnam');
INSERT INTO countries VALUES('231','VG','Virigan Islands (British)');
INSERT INTO countries VALUES('232','VI','Virgin Islands (U.S.)');
INSERT INTO countries VALUES('233','WF','Wallis and Futuna Islands');
INSERT INTO countries VALUES('234','EH','Western Sahara');
INSERT INTO countries VALUES('235','YE','Yemen');
INSERT INTO countries VALUES('236','YU','Yugoslavia');
INSERT INTO countries VALUES('237','ZR','Zaire');
INSERT INTO countries VALUES('238','ZM','Zambia');
INSERT INTO countries VALUES('239','ZW','Zimbabwe');



CREATE TABLE `departments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `department_name` varchar(191) NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_head` bigint(20) unsigned DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `departments_company_id_foreign` (`company_id`),
  KEY `departments_department_head_foreign` (`department_head`),
  CONSTRAINT `departments_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `departments_department_head_foreign` FOREIGN KEY (`department_head`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `designations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `designation_name` varchar(191) NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `designations_company_id_foreign` (`company_id`),
  KEY `designations_department_id_foreign` (`department_id`),
  CONSTRAINT `designations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `designations_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `document_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `document_type` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_types_company_id_foreign` (`company_id`),
  CONSTRAINT `document_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_bank_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `account_name` varchar(191) DEFAULT NULL,
  `account_number` varchar(191) NOT NULL,
  `bank_name` varchar(191) NOT NULL,
  `bank_code` varchar(191) NOT NULL,
  `bank_branch` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_bank_accounts_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_bank_accounts_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `relation` varchar(50) NOT NULL,
  `is_primary` tinyint(4) DEFAULT 0,
  `is_dependent` tinyint(4) DEFAULT 0,
  `contact_name` varchar(191) NOT NULL,
  `work_phone` varchar(191) DEFAULT NULL,
  `work_phone_ext` varchar(191) DEFAULT NULL,
  `personal_phone` varchar(191) DEFAULT NULL,
  `home_phone` varchar(191) DEFAULT NULL,
  `work_email` varchar(191) DEFAULT NULL,
  `personal_email` varchar(191) DEFAULT NULL,
  `address1` varchar(191) DEFAULT NULL,
  `address2` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `zip` varchar(191) DEFAULT NULL,
  `country_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_contacts_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_contacts_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_documents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `document_type_id` bigint(20) unsigned DEFAULT NULL,
  `document_type` varchar(191) DEFAULT NULL,
  `document_title` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  `expiry_date` date NOT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_documents_employee_id_foreign` (`employee_id`),
  KEY `employee_documents_document_type_id_foreign` (`document_type_id`),
  CONSTRAINT `employee_documents_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_documents_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_immigrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `document_type_id` bigint(20) unsigned DEFAULT NULL,
  `document_type` varchar(191) DEFAULT NULL,
  `document_number` varchar(191) NOT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  `issue_date` date NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `eligible_review_date` date DEFAULT NULL,
  `country_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_immigrations_employee_id_foreign` (`employee_id`),
  KEY `employee_immigrations_document_type_id_foreign` (`document_type_id`),
  CONSTRAINT `employee_immigrations_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_immigrations_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_interview` (
  `interview_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`interview_id`,`employee_id`),
  KEY `employee_interview_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_interview_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `employee_interview_interview_id_foreign` FOREIGN KEY (`interview_id`) REFERENCES `job_interviews` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_meeting` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `meeting_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`meeting_id`),
  KEY `employee_meeting_meeting_id_foreign` (`meeting_id`),
  CONSTRAINT `employee_meeting_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_meeting_meeting_id_foreign` FOREIGN KEY (`meeting_id`) REFERENCES `meetings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_project` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `project_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`project_id`),
  KEY `employee_project_project_id_foreign` (`project_id`),
  CONSTRAINT `employee_project_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_project_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_qualificaitons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `education_level_id` bigint(20) unsigned DEFAULT NULL,
  `education_level` varchar(191) DEFAULT NULL,
  `institution_name` varchar(191) NOT NULL,
  `from_year` date DEFAULT NULL,
  `to_year` date DEFAULT NULL,
  `language_skill_id` bigint(20) unsigned DEFAULT NULL,
  `general_skill_id` bigint(20) unsigned DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_qualificaitons_employee_id_foreign` (`employee_id`),
  KEY `employee_qualificaitons_education_level_id_foreign` (`education_level_id`),
  KEY `employee_qualificaitons_language_skill_id_foreign` (`language_skill_id`),
  KEY `employee_qualificaitons_general_skill_id_foreign` (`general_skill_id`),
  CONSTRAINT `employee_qualificaitons_education_level_id_foreign` FOREIGN KEY (`education_level_id`) REFERENCES `qualification_education_levels` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_qualificaitons_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_qualificaitons_general_skill_id_foreign` FOREIGN KEY (`general_skill_id`) REFERENCES `qualification_skills` (`id`) ON DELETE SET NULL,
  CONSTRAINT `employee_qualificaitons_language_skill_id_foreign` FOREIGN KEY (`language_skill_id`) REFERENCES `qualification_languages` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `is_bpjs_tk_include` tinyint(1) NOT NULL,
  `is_bpjs_kes_include` tinyint(1) NOT NULL,
  `is_tax_include` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_settings_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_settings_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_support_ticket` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `support_ticket_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`support_ticket_id`),
  KEY `employee_support_ticket_support_ticket_id_foreign` (`support_ticket_id`),
  CONSTRAINT `employee_support_ticket_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_support_ticket_support_ticket_id_foreign` FOREIGN KEY (`support_ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_task` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `task_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`task_id`),
  KEY `employee_task_task_id_foreign` (`task_id`),
  CONSTRAINT `employee_task_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_task_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_training_list` (
  `employee_id` bigint(20) unsigned NOT NULL,
  `training_list_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`employee_id`,`training_list_id`),
  KEY `employee_training_list_training_list_id_foreign` (`training_list_id`),
  CONSTRAINT `employee_training_list_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employee_training_list_training_list_id_foreign` FOREIGN KEY (`training_list_id`) REFERENCES `training_lists` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employee_work_experience` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `company_name` varchar(191) NOT NULL,
  `from_year` date DEFAULT NULL,
  `to_year` date DEFAULT NULL,
  `post` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_work_experience_employee_id_foreign` (`employee_id`),
  CONSTRAINT `employee_work_experience_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `employees` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `staff_id` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `identity_number` varchar(191) NOT NULL,
  `npwp` int(16) DEFAULT NULL,
  `contact_no` varchar(15) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `gender` varchar(191) DEFAULT NULL,
  `office_shift_id` bigint(20) unsigned DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `designation_id` bigint(20) unsigned DEFAULT NULL,
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `role_users_id` bigint(20) unsigned DEFAULT NULL,
  `status_id` bigint(20) unsigned DEFAULT NULL,
  `following_company_id` bigint(20) unsigned DEFAULT NULL,
  `following_employee_id` bigint(20) unsigned DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `exit_date` date DEFAULT NULL,
  `marital_status` varchar(191) DEFAULT NULL,
  `religion` varchar(191) DEFAULT NULL,
  `dependent` varchar(191) NOT NULL,
  `address` text DEFAULT NULL,
  `city` varchar(64) DEFAULT NULL,
  `state` varchar(64) DEFAULT NULL,
  `country` varchar(64) DEFAULT NULL,
  `zip_code` varchar(24) DEFAULT NULL,
  `cv` varchar(64) DEFAULT NULL,
  `skype_id` varchar(64) DEFAULT NULL,
  `fb_id` varchar(64) DEFAULT NULL,
  `twitter_id` varchar(64) DEFAULT NULL,
  `linkedIn_id` varchar(64) DEFAULT NULL,
  `whatsapp_id` varchar(64) DEFAULT NULL,
  `basic_salary` double DEFAULT 0,
  `payslip_type` varchar(191) DEFAULT NULL,
  `attendance_type` varchar(191) DEFAULT NULL,
  `total_leave` int(11) DEFAULT 0,
  `remaining_leave` int(11) DEFAULT 0,
  `last_year_leave` double NOT NULL,
  `pension_type` varchar(50) DEFAULT NULL,
  `pension_amount` double(8,2) DEFAULT 0.00,
  `is_dispensation` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  `is_payroll` tinyint(1) NOT NULL,
  `is_ceo` tinyint(1) NOT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employees_office_shift_id_foreign` (`office_shift_id`),
  KEY `employees_company_id_foreign` (`company_id`),
  KEY `employees_department_id_foreign` (`department_id`),
  KEY `employees_designation_id_foreign` (`designation_id`),
  KEY `employees_location_id_foreign` (`location_id`),
  KEY `employees_role_users_id_foreign` (`role_users_id`),
  KEY `employees_status_id_foreign` (`status_id`),
  KEY `employees_following_company_id_foreign` (`following_company_id`),
  KEY `employees_following_employee_id_foreign` (`following_employee_id`),
  CONSTRAINT `employees_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_designation_id_foreign` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_following_company_id_foreign` FOREIGN KEY (`following_company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_following_employee_id_foreign` FOREIGN KEY (`following_employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `locations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_office_shift_id_foreign` FOREIGN KEY (`office_shift_id`) REFERENCES `office_shifts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employees_role_users_id_foreign` FOREIGN KEY (`role_users_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `employees_status_id_foreign` FOREIGN KEY (`status_id`) REFERENCES `statuses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `department_id` bigint(20) unsigned NOT NULL,
  `event_title` varchar(191) NOT NULL,
  `event_note` mediumtext NOT NULL,
  `event_date` date NOT NULL,
  `event_time` varchar(191) NOT NULL,
  `status` varchar(30) NOT NULL,
  `is_notify` tinyint(4) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `events_company_id_foreign` (`company_id`),
  KEY `events_department_id_foreign` (`department_id`),
  CONSTRAINT `events_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `events_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `expense_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_types_company_id_foreign` (`company_id`),
  CONSTRAINT `expense_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `file_manager_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `allowed_extensions` mediumtext NOT NULL,
  `max_file_size` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `file_managers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `added_by` bigint(20) unsigned DEFAULT NULL,
  `file_name` varchar(191) NOT NULL,
  `file_size` varchar(191) DEFAULT NULL,
  `file_extension` varchar(191) DEFAULT NULL,
  `external_link` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_managers_department_id_foreign` (`department_id`),
  KEY `file_managers_added_by_foreign` (`added_by`),
  CONSTRAINT `file_managers_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `file_managers_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_bank_cashes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_name` varchar(50) NOT NULL,
  `account_balance` varchar(191) NOT NULL,
  `initial_balance` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `branch_code` varchar(191) NOT NULL,
  `bank_branch` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_deposits` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `account_id` bigint(20) unsigned DEFAULT NULL,
  `amount` varchar(30) NOT NULL,
  `category` varchar(30) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `payment_method_id` bigint(20) unsigned DEFAULT NULL,
  `payer_id` bigint(20) unsigned DEFAULT NULL,
  `deposit_reference` varchar(191) NOT NULL,
  `deposit_file` varchar(191) DEFAULT NULL,
  `deposit_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_deposits_company_id_foreign` (`company_id`),
  KEY `finance_deposits_account_id_foreign` (`account_id`),
  KEY `finance_deposits_payment_method_id_foreign` (`payment_method_id`),
  KEY `finance_deposits_payer_id_foreign` (`payer_id`),
  CONSTRAINT `finance_deposits_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_deposits_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_deposits_payer_id_foreign` FOREIGN KEY (`payer_id`) REFERENCES `finance_payers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_deposits_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_expenses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `account_id` bigint(20) unsigned DEFAULT NULL,
  `amount` varchar(30) NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `payment_method_id` bigint(20) unsigned DEFAULT NULL,
  `payee_id` bigint(20) unsigned DEFAULT NULL,
  `expense_reference` varchar(191) NOT NULL,
  `expense_file` varchar(191) DEFAULT NULL,
  `expense_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_expenses_company_id_foreign` (`company_id`),
  KEY `finance_expenses_account_id_foreign` (`account_id`),
  KEY `finance_expenses_payment_method_id_foreign` (`payment_method_id`),
  KEY `finance_expenses_payee_id_foreign` (`payee_id`),
  KEY `finance_expenses_category_id_foreign` (`category_id`),
  CONSTRAINT `finance_expenses_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_expenses_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expense_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_expenses_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_expenses_payee_id_foreign` FOREIGN KEY (`payee_id`) REFERENCES `finance_payees` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_expenses_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_payees` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payee_name` varchar(50) NOT NULL,
  `contact_no` varchar(15) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_payers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payer_name` varchar(50) NOT NULL,
  `contact_no` varchar(15) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `account_id` bigint(20) unsigned DEFAULT NULL,
  `amount` varchar(30) NOT NULL,
  `category` varchar(30) NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `payment_method_id` bigint(20) unsigned DEFAULT NULL,
  `payee_id` bigint(20) unsigned DEFAULT NULL,
  `payer_id` bigint(20) unsigned DEFAULT NULL,
  `expense_reference` varchar(191) DEFAULT NULL,
  `expense_file` varchar(191) DEFAULT NULL,
  `expense_date` date DEFAULT NULL,
  `deposit_reference` varchar(191) DEFAULT NULL,
  `deposit_file` varchar(191) DEFAULT NULL,
  `deposit_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_transactions_company_id_foreign` (`company_id`),
  KEY `finance_transactions_account_id_foreign` (`account_id`),
  KEY `finance_transactions_payment_method_id_foreign` (`payment_method_id`),
  KEY `finance_transactions_payee_id_foreign` (`payee_id`),
  KEY `finance_transactions_payer_id_foreign` (`payer_id`),
  KEY `finance_transactions_category_id_foreign` (`category_id`),
  CONSTRAINT `finance_transactions_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transactions_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expense_types` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transactions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transactions_payee_id_foreign` FOREIGN KEY (`payee_id`) REFERENCES `finance_payees` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transactions_payer_id_foreign` FOREIGN KEY (`payer_id`) REFERENCES `finance_payers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transactions_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `finance_transfers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `from_account_id` bigint(20) unsigned DEFAULT NULL,
  `to_account_id` bigint(20) unsigned DEFAULT NULL,
  `amount` varchar(30) NOT NULL,
  `reference` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `payment_method_id` bigint(20) unsigned DEFAULT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `finance_transfers_company_id_foreign` (`company_id`),
  KEY `finance_transfers_from_account_id_foreign` (`from_account_id`),
  KEY `finance_transfers_to_account_id_foreign` (`to_account_id`),
  KEY `finance_transfers_payment_method_id_foreign` (`payment_method_id`),
  CONSTRAINT `finance_transfers_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transfers_from_account_id_foreign` FOREIGN KEY (`from_account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transfers_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL,
  CONSTRAINT `finance_transfers_to_account_id_foreign` FOREIGN KEY (`to_account_id`) REFERENCES `finance_bank_cashes` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `general_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_title` varchar(191) NOT NULL,
  `site_logo` varchar(191) DEFAULT NULL,
  `time_zone` varchar(191) DEFAULT NULL,
  `currency` varchar(191) DEFAULT NULL,
  `currency_format` varchar(191) DEFAULT NULL,
  `default_payment_bank` varchar(191) DEFAULT NULL,
  `date_format` varchar(191) DEFAULT NULL,
  `theme` varchar(191) DEFAULT NULL,
  `footer` varchar(191) DEFAULT NULL,
  `footer_link` varchar(191) DEFAULT NULL,
  `cron_job_attendance_time` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO general_settings VALUES('1','HR System','logo.png','Asia/Jakarta','Rp','prefix','1','Y-m-d','default.css','Rekret','https://rekret.com','10','2020-07-26 02:00:00','2023-02-05 16:28:54');



CREATE TABLE `goal_trackings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `goal_type_id` bigint(20) unsigned NOT NULL,
  `subject` varchar(191) NOT NULL,
  `target_achievement` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `start_date` varchar(191) NOT NULL,
  `end_date` varchar(191) NOT NULL,
  `progress` int(11) NOT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `goal_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `goal_type` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `holidays` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_name` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `is_publish` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `holidays_company_id_foreign` (`company_id`),
  KEY `holidays_department_id_foreign` (`department_id`),
  CONSTRAINT `holidays_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `holidays_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `indicators` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `designation_id` bigint(20) unsigned NOT NULL,
  `department_id` bigint(20) unsigned NOT NULL,
  `customer_experience` varchar(191) NOT NULL,
  `marketing` varchar(191) NOT NULL,
  `administrator` varchar(191) NOT NULL,
  `professionalism` varchar(191) NOT NULL,
  `integrity` varchar(191) NOT NULL,
  `attendance` varchar(191) NOT NULL,
  `added_by` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `invoice_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(20) unsigned DEFAULT NULL,
  `project_id` bigint(20) unsigned DEFAULT NULL,
  `item_name` varchar(191) NOT NULL,
  `item_tax_type` varchar(191) NOT NULL,
  `item_tax_rate` varchar(191) NOT NULL,
  `item_qty` bigint(20) NOT NULL DEFAULT 0,
  `item_unit_price` bigint(20) NOT NULL,
  `item_sub_total` double NOT NULL,
  `sub_total` double NOT NULL,
  `discount_type` tinyint(4) DEFAULT NULL,
  `discount_figure` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_discount` double NOT NULL,
  `grand_total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_items_invoice_id_foreign` (`invoice_id`),
  KEY `invoice_items_project_id_foreign` (`project_id`),
  CONSTRAINT `invoice_items_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `invoice_items_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `invoices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(191) NOT NULL,
  `client_id` bigint(20) unsigned DEFAULT NULL,
  `project_id` bigint(20) unsigned DEFAULT NULL,
  `invoice_date` date NOT NULL,
  `invoice_due_date` date NOT NULL,
  `sub_total` double NOT NULL,
  `discount_type` tinyint(4) DEFAULT NULL,
  `discount_figure` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_discount` double NOT NULL,
  `grand_total` double NOT NULL,
  `invoice_note` mediumtext DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoices_client_id_foreign` (`client_id`),
  KEY `invoices_project_id_foreign` (`project_id`),
  CONSTRAINT `invoices_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`) ON DELETE SET NULL,
  CONSTRAINT `invoices_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `ip_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `ip_address` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `job_candidates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `full_name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `phone` varchar(191) NOT NULL,
  `address` text DEFAULT NULL,
  `cover_letter` longtext NOT NULL,
  `fb_id` varchar(191) DEFAULT NULL,
  `linkedin_id` varchar(191) DEFAULT NULL,
  `cv` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `remarks` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `job_candidates_job_id_foreign` (`job_id`),
  CONSTRAINT `job_candidates_job_id_foreign` FOREIGN KEY (`job_id`) REFERENCES `job_posts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `job_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_category` mediumtext NOT NULL,
  `url` char(36) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `job_interviews` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `added_by` bigint(20) unsigned DEFAULT NULL,
  `interview_place` varchar(191) NOT NULL,
  `interview_date` date NOT NULL,
  `interview_time` time NOT NULL,
  `description` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `job_interviews_job_id_foreign` (`job_id`),
  KEY `job_interviews_added_by_foreign` (`added_by`),
  CONSTRAINT `job_interviews_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `job_interviews_job_id_foreign` FOREIGN KEY (`job_id`) REFERENCES `job_posts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `job_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `job_category_id` bigint(20) unsigned NOT NULL,
  `job_title` varchar(191) NOT NULL,
  `job_type` varchar(191) NOT NULL,
  `no_of_vacancy` int(11) NOT NULL,
  `job_url` varchar(191) NOT NULL,
  `gender` varchar(30) NOT NULL,
  `min_experience` varchar(20) NOT NULL,
  `short_description` mediumtext NOT NULL,
  `long_description` longtext NOT NULL,
  `closing_date` date NOT NULL,
  `status` tinyint(4) NOT NULL,
  `is_featured` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `job_posts_job_category_id_foreign` (`job_category_id`),
  KEY `job_posts_company_id_foreign` (`company_id`),
  CONSTRAINT `job_posts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `job_posts_job_category_id_foreign` FOREIGN KEY (`job_category_id`) REFERENCES `job_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `leave_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `leave_type` varchar(50) NOT NULL,
  `allocated_day` int(11) DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_types_company_id_foreign` (`company_id`),
  CONSTRAINT `leave_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO leave_types VALUES('1','Manual','','','2024-02-05 15:24:40','2024-02-05 15:24:40');



CREATE TABLE `leaves` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `leave_type_id` bigint(20) unsigned DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `department_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `total_days` int(11) NOT NULL,
  `leave_reason` mediumtext DEFAULT NULL,
  `remarks` varchar(191) DEFAULT NULL,
  `status` varchar(40) NOT NULL,
  `is_half` tinyint(4) DEFAULT 0,
  `is_notify` tinyint(4) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leaves_company_id_foreign` (`company_id`),
  KEY `leaves_employee_id_foreign` (`employee_id`),
  KEY `leaves_leave_type_id_foreign` (`leave_type_id`),
  KEY `leaves_department_id_foreign` (`department_id`),
  CONSTRAINT `leaves_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `leaves_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `leaves_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL,
  CONSTRAINT `leaves_leave_type_id_foreign` FOREIGN KEY (`leave_type_id`) REFERENCES `leave_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `locations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_name` varchar(191) NOT NULL,
  `location_head` bigint(20) unsigned DEFAULT NULL,
  `address1` varchar(191) DEFAULT NULL,
  `address2` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` int(10) unsigned DEFAULT NULL,
  `zip` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `locations_location_head_foreign` (`location_head`),
  KEY `locations_country_foreign` (`country`),
  CONSTRAINT `locations_country_foreign` FOREIGN KEY (`country`) REFERENCES `countries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `locations_location_head_foreign` FOREIGN KEY (`location_head`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO locations VALUES('1','Jakarta','','Tanah Abang II no 81','','Jakarta Pusat','DKI Jakarta','100','10160','2024-02-05 15:35:54','2024-02-05 15:35:54');



CREATE TABLE `log_report_attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `report_attendance_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `log_report_attendances_user_id_foreign` (`user_id`),
  KEY `log_report_attendances_report_attendance_id_foreign` (`report_attendance_id`),
  CONSTRAINT `log_report_attendances_report_attendance_id_foreign` FOREIGN KEY (`report_attendance_id`) REFERENCES `report_attendances` (`id`) ON DELETE SET NULL,
  CONSTRAINT `log_report_attendances_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `mail_receivers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mail_receivers_employee_id_foreign` (`employee_id`),
  CONSTRAINT `mail_receivers_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `meetings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `meeting_title` varchar(191) NOT NULL,
  `meeting_note` mediumtext NOT NULL,
  `meeting_date` date NOT NULL,
  `meeting_time` varchar(191) NOT NULL,
  `status` varchar(30) NOT NULL,
  `is_notify` tinyint(4) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meetings_company_id_foreign` (`company_id`),
  CONSTRAINT `meetings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES('1','2014_10_12_100000_create_password_resets_table','1');
INSERT INTO migrations VALUES('2','2019_08_19_000000_create_failed_jobs_table','1');
INSERT INTO migrations VALUES('3','2020_02_09_103616_create_role_users_table','1');
INSERT INTO migrations VALUES('4','2020_02_10_00000_create_users_table','1');
INSERT INTO migrations VALUES('5','2020_02_12_091317_create_locations_table','1');
INSERT INTO migrations VALUES('6','2020_02_12_091344_create_companies_table','1');
INSERT INTO migrations VALUES('7','2020_02_12_091353_create_departments_table','1');
INSERT INTO migrations VALUES('8','2020_02_12_091742_create_statuses_table','1');
INSERT INTO migrations VALUES('9','2020_02_12_091824_create_office_shifts_table','1');
INSERT INTO migrations VALUES('10','2020_02_12_091936_create_designations_table','1');
INSERT INTO migrations VALUES('11','2020_02_12_092121_create_leave_types_table','1');
INSERT INTO migrations VALUES('12','2020_02_13_100750_create_employees_table','1');
INSERT INTO migrations VALUES('13','2020_02_14_092309_create_leaves_table','1');
INSERT INTO migrations VALUES('14','2020_02_20_115449_create_general_settings_table','1');
INSERT INTO migrations VALUES('15','2020_02_23_054028_create_permission_tables','1');
INSERT INTO migrations VALUES('16','2020_02_23_184712_add_columns_to_permission_table','1');
INSERT INTO migrations VALUES('17','2020_03_19_132718_add_employee_id_on_locations_table','2');
INSERT INTO migrations VALUES('18','2020_03_20_162201_create_announcements_table','2');
INSERT INTO migrations VALUES('19','2020_03_20_201357_create_policies_table','2');
INSERT INTO migrations VALUES('20','2020_03_22_113701_create_holidays_table','2');
INSERT INTO migrations VALUES('21','2020_03_23_100213_create_award_types_table','3');
INSERT INTO migrations VALUES('22','2020_03_23_100248_create_awards_table','3');
INSERT INTO migrations VALUES('23','2020_03_23_123604_create_transfers_table','3');
INSERT INTO migrations VALUES('24','2020_03_23_144135_create_resignations_table','3');
INSERT INTO migrations VALUES('25','2020_03_23_150510_create_travel_types_table','3');
INSERT INTO migrations VALUES('26','2020_03_23_152610_create_travels_table','3');
INSERT INTO migrations VALUES('27','2020_03_23_154228_create_promotions_table','3');
INSERT INTO migrations VALUES('28','2020_03_23_194844_create_complaints_table','3');
INSERT INTO migrations VALUES('29','2020_03_24_134301_create_warnings_type_table','3');
INSERT INTO migrations VALUES('30','2020_03_24_134304_create_warnings_table','3');
INSERT INTO migrations VALUES('31','2020_03_24_143012_create_termination_types_table','3');
INSERT INTO migrations VALUES('32','2020_03_24_143038_create_terminations_table','3');
INSERT INTO migrations VALUES('33','2020_04_06_185530_create_training_types_table','3');
INSERT INTO migrations VALUES('34','2020_04_06_190352_create_trainers_table','3');
INSERT INTO migrations VALUES('35','2020_04_07_083717_create_training_lists_table','3');
INSERT INTO migrations VALUES('36','2020_04_07_103503_create_employee_training_list_table','3');
INSERT INTO migrations VALUES('37','2020_04_08_095050_create_events_table','3');
INSERT INTO migrations VALUES('38','2020_04_08_163144_create_meetings_table','3');
INSERT INTO migrations VALUES('39','2020_04_08_163906_create_employee_meeting_table','3');
INSERT INTO migrations VALUES('40','2020_05_05_212429_create_document_types_table','3');
INSERT INTO migrations VALUES('41','2020_04_09_063646_create_finance_bank_cashes_table','4');
INSERT INTO migrations VALUES('42','2020_04_09_154642_create_finance_payees_table','4');
INSERT INTO migrations VALUES('43','2020_04_09_201357_create_finance_payers_table','4');
INSERT INTO migrations VALUES('44','2020_04_10_064405_create_payment_methods_table','4');
INSERT INTO migrations VALUES('45','2020_04_10_094429_create_expense_types_table','4');
INSERT INTO migrations VALUES('46','2020_04_10_121829_create_finance_deposits_table','4');
INSERT INTO migrations VALUES('47','2020_04_11_084040_create_finance_expenses_table','4');
INSERT INTO migrations VALUES('48','2020_04_11_164442_create_finance_transactions_table','4');
INSERT INTO migrations VALUES('49','2020_04_13_071336_create_finance_transfers_table','4');
INSERT INTO migrations VALUES('50','2020_04_13_135659_create_asset_categories_table','5');
INSERT INTO migrations VALUES('51','2020_04_13_160310_create_assets_table','5');
INSERT INTO migrations VALUES('52','2020_04_15_103730_create_file_manager_settings_table','5');
INSERT INTO migrations VALUES('53','2020_04_15_193003_create_file_managers_table','5');
INSERT INTO migrations VALUES('54','2020_04_18_094856_create_support_tickets_table','5');
INSERT INTO migrations VALUES('55','2020_04_21_052227_create_ticket_comments_table','5');
INSERT INTO migrations VALUES('56','2020_04_21_172758_create_employee_support_ticket_table','5');
INSERT INTO migrations VALUES('57','2020_04_24_070148_create_countries_table','5');
INSERT INTO migrations VALUES('58','2020_04_24_071350_create_clients_table','5');
INSERT INTO migrations VALUES('59','2020_04_25_083125_create_projects_table','5');
INSERT INTO migrations VALUES('60','2020_04_25_092544_create_employee_project_table','5');
INSERT INTO migrations VALUES('61','2020_04_27_132031_create_project_discussions_table','5');
INSERT INTO migrations VALUES('62','2020_04_27_202219_create_project_bugs_table','5');
INSERT INTO migrations VALUES('63','2020_04_28_095459_create_project_files_table','5');
INSERT INTO migrations VALUES('64','2020_04_28_172850_create_tasks_table','5');
INSERT INTO migrations VALUES('65','2020_04_28_183034_create_employee_task_table','5');
INSERT INTO migrations VALUES('66','2020_04_29_164820_create_task_discussions_table','5');
INSERT INTO migrations VALUES('67','2020_04_29_185015_create_task_files_table','5');
INSERT INTO migrations VALUES('68','2020_05_01_093124_create_tax_types_table','5');
INSERT INTO migrations VALUES('69','2020_05_02_100902_create_invoices_table','5');
INSERT INTO migrations VALUES('70','2020_05_02_110310_create_invoice_items_table','5');
INSERT INTO migrations VALUES('71','2020_05_06_085438_create_employee_immigrations_table','6');
INSERT INTO migrations VALUES('72','2020_05_07_191655_create_employee_contacts_table','6');
INSERT INTO migrations VALUES('73','2020_05_08_181821_create_employee_documents_table','6');
INSERT INTO migrations VALUES('74','2020_05_12_200437_create_qualification_education_levels_table','6');
INSERT INTO migrations VALUES('75','2020_05_16_204859_create_qualification_languages_table','6');
INSERT INTO migrations VALUES('76','2020_05_17_181817_create_qualification_skills_table','6');
INSERT INTO migrations VALUES('77','2020_05_17_191414_create_employee_qualificaitons_table','6');
INSERT INTO migrations VALUES('78','2020_05_18_191844_create_employee_work_experience_table','6');
INSERT INTO migrations VALUES('79','2020_05_19_170527_create_employee_bank_accounts_table','6');
INSERT INTO migrations VALUES('80','2020_05_22_201218_create_salary_allowances_table','6');
INSERT INTO migrations VALUES('81','2020_05_23_184036_create_salary_commissions_table','6');
INSERT INTO migrations VALUES('82','2020_05_24_085740_create_salary_deductions_table','6');
INSERT INTO migrations VALUES('83','2020_05_24_103950_create_salary_other_payments_table','6');
INSERT INTO migrations VALUES('84','2020_05_24_163618_create_salary_overtimes_table','6');
INSERT INTO migrations VALUES('85','2020_05_26_134431_create_salary_loans_table','6');
INSERT INTO migrations VALUES('86','2020_06_11_104501_create_payslips_table','7');
INSERT INTO migrations VALUES('87','2020_06_17_055449_create_calendarables_table','7');
INSERT INTO migrations VALUES('88','2020_06_19_083329_create_job_categories_table','7');
INSERT INTO migrations VALUES('89','2020_06_19_152528_create_job_employers_table','7');
INSERT INTO migrations VALUES('90','2020_06_22_052056_create_attendances_table','7');
INSERT INTO migrations VALUES('91','2020_07_05_010713_create_job_posts_table','7');
INSERT INTO migrations VALUES('92','2020_07_06_162706_create_job_candidates_table','7');
INSERT INTO migrations VALUES('93','2020_07_07_144320_create_job_interviews_table','7');
INSERT INTO migrations VALUES('94','2020_07_07_160007_create_candidate_interview_table','7');
INSERT INTO migrations VALUES('95','2020_07_07_160428_create_employee_interview_table','7');
INSERT INTO migrations VALUES('96','2020_07_25_003500_create_official_documents_table','7');
INSERT INTO migrations VALUES('97','2020_04_18_203257_create_notifications_table','8');
INSERT INTO migrations VALUES('98','2020_10_16_202848_create_c_m_s_table','9');
INSERT INTO migrations VALUES('99','2018_08_29_200844_create_languages_table','10');
INSERT INTO migrations VALUES('100','2018_08_29_205156_create_translations_table','10');
INSERT INTO migrations VALUES('101','2021_01_08_072901_create_goal_types_table','10');
INSERT INTO migrations VALUES('102','2021_01_08_165133_create_indicators_table','10');
INSERT INTO migrations VALUES('103','2021_01_09_081319_create_appraisals_table','10');
INSERT INTO migrations VALUES('104','2021_01_10_080158_create_goal_trackings_table','10');
INSERT INTO migrations VALUES('105','2021_03_28_184255_create_ip_settings_table','11');
INSERT INTO migrations VALUES('106','2021_04_05_103029_create_salary_basics_table','12');
INSERT INTO migrations VALUES('107','2023_02_02_084627_create_raw_attendances_table','13');
INSERT INTO migrations VALUES('108','2023_02_05_090809_remove_some_columns_attendances','14');
INSERT INTO migrations VALUES('109','2023_02_05_155637_remove_ip_from_attendances','15');
INSERT INTO migrations VALUES('110','2023_02_08_110401_add_dependent_to_employees','16');
INSERT INTO migrations VALUES('111','2023_02_08_112404_add_identity_number_to_employees','17');
INSERT INTO migrations VALUES('113','2023_02_08_132908_create_table_employee_settings','18');
INSERT INTO migrations VALUES('115','2023_02_09_145414_create_bpjs_table','19');
INSERT INTO migrations VALUES('116','2023_02_09_171342_create_bpjs_kes_table','20');
INSERT INTO migrations VALUES('117','2023_02_09_173033_create_taxes_table','21');
INSERT INTO migrations VALUES('118','2023_02_09_184108_create_ptkp_table','22');
INSERT INTO migrations VALUES('120','2023_02_15_154007_add_is_payroll_and_is_ceo_to_roles','23');
INSERT INTO migrations VALUES('121','2023_02_16_093419_change_dependent_column_type_employees_table','24');
INSERT INTO migrations VALUES('122','2023_02_15_133334_add_is_payroll_and_is_ceo_column_to_employees_table','25');
INSERT INTO migrations VALUES('123','2023_02_17_074147_add_salary_column_to_bpjs_kes_table','25');
INSERT INTO migrations VALUES('124','2023_03_04_233821_add_cut_off_date_to_companies_table','26');
INSERT INTO migrations VALUES('125','2023_03_05_144216_add_cron_job_attendance_time_to_general_settings_table','27');
INSERT INTO migrations VALUES('126','2023_03_05_151917_add_following_attendance_to_employees','28');
INSERT INTO migrations VALUES('127','2023_03_05_172328_create_reimbursement_types_table','29');
INSERT INTO migrations VALUES('128','2023_03_05_173609_create_reimbursements_table','30');
INSERT INTO migrations VALUES('129','2023_03_05_183603_add_status_to_reimbursements_table','31');
INSERT INTO migrations VALUES('130','2023_03_05_184455_add_description_to_reimbursements_table','32');
INSERT INTO migrations VALUES('131','2023_03_05_185007_add_attachment_to_reimbursements_table','33');
INSERT INTO migrations VALUES('132','2023_03_05_191642_add_employee_id_to_reimbursements_table','34');
INSERT INTO migrations VALUES('133','2023_03_18_164052_add_range_in_out_to_office_shifts_table','35');
INSERT INTO migrations VALUES('134','2023_03_18_184359_add_min_work_hour_to_office_shifts_table','36');
INSERT INTO migrations VALUES('135','2023_03_18_185212_add_dispensation_and_position_to_employees_table','37');
INSERT INTO migrations VALUES('136','2023_03_31_043700_add_is_underwork_to_attendances_table','38');
INSERT INTO migrations VALUES('137','2023_03_27_111907_add_status_to_attendances_table','39');
INSERT INTO migrations VALUES('138','2023_04_04_152204_create_report_attendances_table','40');
INSERT INTO migrations VALUES('139','2023_04_04_172924_add_attendance_date_to_report_attendances','41');
INSERT INTO migrations VALUES('140','2023_04_04_191751_set_nullable_status_to_report_attendances','42');
INSERT INTO migrations VALUES('141','2023_04_10_153124_add_last_year_leave_to_employees','43');
INSERT INTO migrations VALUES('142','2023_04_10_205922_create_table_mail_receivers','44');
INSERT INTO migrations VALUES('143','2023_04_11_092333_create_log_report_attendances_table','45');
INSERT INTO migrations VALUES('144','2023_04_14_130059_add_leave_amount_to_companies','46');



CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO model_has_roles VALUES('1','App\\User','1');
INSERT INTO model_has_roles VALUES('1','App\\User','8');
INSERT INTO model_has_roles VALUES('1','App\\User','28');
INSERT INTO model_has_roles VALUES('1','App\\User','29');
INSERT INTO model_has_roles VALUES('1','App\\User','30');
INSERT INTO model_has_roles VALUES('1','App\\User','31');
INSERT INTO model_has_roles VALUES('1','App\\User','36');
INSERT INTO model_has_roles VALUES('1','App\\User','40');
INSERT INTO model_has_roles VALUES('1','App\\User','44');
INSERT INTO model_has_roles VALUES('1','App\\User','46');
INSERT INTO model_has_roles VALUES('1','App\\User','47');
INSERT INTO model_has_roles VALUES('1','App\\User','48');
INSERT INTO model_has_roles VALUES('1','App\\User','162');
INSERT INTO model_has_roles VALUES('1','App\\User','177');
INSERT INTO model_has_roles VALUES('1','App\\User','1991');
INSERT INTO model_has_roles VALUES('2','App\\User','12');
INSERT INTO model_has_roles VALUES('2','App\\User','13');
INSERT INTO model_has_roles VALUES('2','App\\User','14');
INSERT INTO model_has_roles VALUES('2','App\\User','15');
INSERT INTO model_has_roles VALUES('2','App\\User','24');
INSERT INTO model_has_roles VALUES('2','App\\User','25');
INSERT INTO model_has_roles VALUES('2','App\\User','27');
INSERT INTO model_has_roles VALUES('2','App\\User','32');
INSERT INTO model_has_roles VALUES('2','App\\User','33');
INSERT INTO model_has_roles VALUES('2','App\\User','34');
INSERT INTO model_has_roles VALUES('2','App\\User','37');
INSERT INTO model_has_roles VALUES('2','App\\User','38');
INSERT INTO model_has_roles VALUES('2','App\\User','41');
INSERT INTO model_has_roles VALUES('2','App\\User','42');
INSERT INTO model_has_roles VALUES('2','App\\User','43');
INSERT INTO model_has_roles VALUES('2','App\\User','49');
INSERT INTO model_has_roles VALUES('2','App\\User','50');
INSERT INTO model_has_roles VALUES('2','App\\User','52');
INSERT INTO model_has_roles VALUES('2','App\\User','53');
INSERT INTO model_has_roles VALUES('2','App\\User','54');
INSERT INTO model_has_roles VALUES('2','App\\User','57');
INSERT INTO model_has_roles VALUES('2','App\\User','58');
INSERT INTO model_has_roles VALUES('2','App\\User','59');
INSERT INTO model_has_roles VALUES('2','App\\User','60');
INSERT INTO model_has_roles VALUES('2','App\\User','61');
INSERT INTO model_has_roles VALUES('2','App\\User','64');
INSERT INTO model_has_roles VALUES('2','App\\User','65');
INSERT INTO model_has_roles VALUES('2','App\\User','67');
INSERT INTO model_has_roles VALUES('2','App\\User','68');
INSERT INTO model_has_roles VALUES('2','App\\User','72');
INSERT INTO model_has_roles VALUES('2','App\\User','75');
INSERT INTO model_has_roles VALUES('2','App\\User','76');
INSERT INTO model_has_roles VALUES('2','App\\User','77');
INSERT INTO model_has_roles VALUES('2','App\\User','78');
INSERT INTO model_has_roles VALUES('2','App\\User','79');
INSERT INTO model_has_roles VALUES('2','App\\User','80');
INSERT INTO model_has_roles VALUES('2','App\\User','82');
INSERT INTO model_has_roles VALUES('2','App\\User','83');
INSERT INTO model_has_roles VALUES('2','App\\User','84');
INSERT INTO model_has_roles VALUES('2','App\\User','85');
INSERT INTO model_has_roles VALUES('2','App\\User','86');
INSERT INTO model_has_roles VALUES('2','App\\User','87');
INSERT INTO model_has_roles VALUES('2','App\\User','88');
INSERT INTO model_has_roles VALUES('2','App\\User','90');
INSERT INTO model_has_roles VALUES('2','App\\User','91');
INSERT INTO model_has_roles VALUES('2','App\\User','92');
INSERT INTO model_has_roles VALUES('2','App\\User','93');
INSERT INTO model_has_roles VALUES('2','App\\User','94');
INSERT INTO model_has_roles VALUES('2','App\\User','95');
INSERT INTO model_has_roles VALUES('2','App\\User','96');
INSERT INTO model_has_roles VALUES('2','App\\User','97');
INSERT INTO model_has_roles VALUES('2','App\\User','98');
INSERT INTO model_has_roles VALUES('2','App\\User','99');
INSERT INTO model_has_roles VALUES('2','App\\User','100');
INSERT INTO model_has_roles VALUES('2','App\\User','101');
INSERT INTO model_has_roles VALUES('2','App\\User','102');
INSERT INTO model_has_roles VALUES('2','App\\User','103');
INSERT INTO model_has_roles VALUES('2','App\\User','104');
INSERT INTO model_has_roles VALUES('2','App\\User','105');
INSERT INTO model_has_roles VALUES('2','App\\User','106');
INSERT INTO model_has_roles VALUES('2','App\\User','109');
INSERT INTO model_has_roles VALUES('2','App\\User','110');
INSERT INTO model_has_roles VALUES('2','App\\User','111');
INSERT INTO model_has_roles VALUES('2','App\\User','112');
INSERT INTO model_has_roles VALUES('2','App\\User','113');
INSERT INTO model_has_roles VALUES('2','App\\User','114');
INSERT INTO model_has_roles VALUES('2','App\\User','115');
INSERT INTO model_has_roles VALUES('2','App\\User','116');
INSERT INTO model_has_roles VALUES('2','App\\User','117');
INSERT INTO model_has_roles VALUES('2','App\\User','118');
INSERT INTO model_has_roles VALUES('2','App\\User','119');
INSERT INTO model_has_roles VALUES('2','App\\User','120');
INSERT INTO model_has_roles VALUES('2','App\\User','121');
INSERT INTO model_has_roles VALUES('2','App\\User','122');
INSERT INTO model_has_roles VALUES('2','App\\User','123');
INSERT INTO model_has_roles VALUES('2','App\\User','124');
INSERT INTO model_has_roles VALUES('2','App\\User','125');
INSERT INTO model_has_roles VALUES('2','App\\User','126');
INSERT INTO model_has_roles VALUES('2','App\\User','127');
INSERT INTO model_has_roles VALUES('2','App\\User','128');
INSERT INTO model_has_roles VALUES('2','App\\User','129');
INSERT INTO model_has_roles VALUES('2','App\\User','130');
INSERT INTO model_has_roles VALUES('2','App\\User','132');
INSERT INTO model_has_roles VALUES('2','App\\User','133');
INSERT INTO model_has_roles VALUES('2','App\\User','134');
INSERT INTO model_has_roles VALUES('2','App\\User','135');
INSERT INTO model_has_roles VALUES('2','App\\User','136');
INSERT INTO model_has_roles VALUES('2','App\\User','137');
INSERT INTO model_has_roles VALUES('2','App\\User','138');
INSERT INTO model_has_roles VALUES('2','App\\User','139');
INSERT INTO model_has_roles VALUES('2','App\\User','140');
INSERT INTO model_has_roles VALUES('2','App\\User','141');
INSERT INTO model_has_roles VALUES('2','App\\User','142');
INSERT INTO model_has_roles VALUES('2','App\\User','143');
INSERT INTO model_has_roles VALUES('2','App\\User','144');
INSERT INTO model_has_roles VALUES('2','App\\User','145');
INSERT INTO model_has_roles VALUES('2','App\\User','146');
INSERT INTO model_has_roles VALUES('2','App\\User','147');
INSERT INTO model_has_roles VALUES('2','App\\User','148');
INSERT INTO model_has_roles VALUES('2','App\\User','149');
INSERT INTO model_has_roles VALUES('2','App\\User','151');
INSERT INTO model_has_roles VALUES('2','App\\User','152');
INSERT INTO model_has_roles VALUES('2','App\\User','153');
INSERT INTO model_has_roles VALUES('2','App\\User','154');
INSERT INTO model_has_roles VALUES('2','App\\User','155');
INSERT INTO model_has_roles VALUES('2','App\\User','156');
INSERT INTO model_has_roles VALUES('2','App\\User','157');
INSERT INTO model_has_roles VALUES('2','App\\User','159');
INSERT INTO model_has_roles VALUES('2','App\\User','160');
INSERT INTO model_has_roles VALUES('2','App\\User','161');
INSERT INTO model_has_roles VALUES('2','App\\User','167');
INSERT INTO model_has_roles VALUES('2','App\\User','169');
INSERT INTO model_has_roles VALUES('2','App\\User','181');
INSERT INTO model_has_roles VALUES('2','App\\User','182');
INSERT INTO model_has_roles VALUES('2','App\\User','294');
INSERT INTO model_has_roles VALUES('2','App\\User','369');
INSERT INTO model_has_roles VALUES('2','App\\User','436');
INSERT INTO model_has_roles VALUES('2','App\\User','437');
INSERT INTO model_has_roles VALUES('2','App\\User','438');
INSERT INTO model_has_roles VALUES('2','App\\User','439');
INSERT INTO model_has_roles VALUES('2','App\\User','441');
INSERT INTO model_has_roles VALUES('2','App\\User','442');
INSERT INTO model_has_roles VALUES('2','App\\User','443');
INSERT INTO model_has_roles VALUES('2','App\\User','444');
INSERT INTO model_has_roles VALUES('2','App\\User','445');
INSERT INTO model_has_roles VALUES('2','App\\User','447');
INSERT INTO model_has_roles VALUES('2','App\\User','448');
INSERT INTO model_has_roles VALUES('2','App\\User','449');
INSERT INTO model_has_roles VALUES('2','App\\User','450');
INSERT INTO model_has_roles VALUES('2','App\\User','451');
INSERT INTO model_has_roles VALUES('2','App\\User','452');
INSERT INTO model_has_roles VALUES('2','App\\User','453');
INSERT INTO model_has_roles VALUES('2','App\\User','454');
INSERT INTO model_has_roles VALUES('2','App\\User','455');
INSERT INTO model_has_roles VALUES('2','App\\User','456');
INSERT INTO model_has_roles VALUES('2','App\\User','457');
INSERT INTO model_has_roles VALUES('2','App\\User','458');
INSERT INTO model_has_roles VALUES('2','App\\User','459');
INSERT INTO model_has_roles VALUES('2','App\\User','460');
INSERT INTO model_has_roles VALUES('2','App\\User','461');
INSERT INTO model_has_roles VALUES('2','App\\User','462');
INSERT INTO model_has_roles VALUES('2','App\\User','463');
INSERT INTO model_has_roles VALUES('2','App\\User','464');
INSERT INTO model_has_roles VALUES('2','App\\User','465');
INSERT INTO model_has_roles VALUES('2','App\\User','466');
INSERT INTO model_has_roles VALUES('2','App\\User','467');
INSERT INTO model_has_roles VALUES('2','App\\User','468');
INSERT INTO model_has_roles VALUES('2','App\\User','469');
INSERT INTO model_has_roles VALUES('2','App\\User','470');
INSERT INTO model_has_roles VALUES('2','App\\User','471');
INSERT INTO model_has_roles VALUES('2','App\\User','472');
INSERT INTO model_has_roles VALUES('2','App\\User','473');
INSERT INTO model_has_roles VALUES('2','App\\User','474');
INSERT INTO model_has_roles VALUES('2','App\\User','475');
INSERT INTO model_has_roles VALUES('2','App\\User','476');
INSERT INTO model_has_roles VALUES('2','App\\User','477');
INSERT INTO model_has_roles VALUES('2','App\\User','478');
INSERT INTO model_has_roles VALUES('2','App\\User','501');
INSERT INTO model_has_roles VALUES('2','App\\User','503');
INSERT INTO model_has_roles VALUES('2','App\\User','504');
INSERT INTO model_has_roles VALUES('2','App\\User','505');
INSERT INTO model_has_roles VALUES('2','App\\User','506');
INSERT INTO model_has_roles VALUES('2','App\\User','507');
INSERT INTO model_has_roles VALUES('2','App\\User','508');
INSERT INTO model_has_roles VALUES('2','App\\User','509');
INSERT INTO model_has_roles VALUES('2','App\\User','510');
INSERT INTO model_has_roles VALUES('2','App\\User','511');
INSERT INTO model_has_roles VALUES('2','App\\User','512');
INSERT INTO model_has_roles VALUES('2','App\\User','513');
INSERT INTO model_has_roles VALUES('2','App\\User','514');
INSERT INTO model_has_roles VALUES('2','App\\User','515');
INSERT INTO model_has_roles VALUES('2','App\\User','516');
INSERT INTO model_has_roles VALUES('2','App\\User','517');
INSERT INTO model_has_roles VALUES('2','App\\User','518');
INSERT INTO model_has_roles VALUES('2','App\\User','519');
INSERT INTO model_has_roles VALUES('2','App\\User','525');
INSERT INTO model_has_roles VALUES('2','App\\User','526');
INSERT INTO model_has_roles VALUES('2','App\\User','527');
INSERT INTO model_has_roles VALUES('2','App\\User','528');
INSERT INTO model_has_roles VALUES('2','App\\User','529');
INSERT INTO model_has_roles VALUES('2','App\\User','542');
INSERT INTO model_has_roles VALUES('2','App\\User','543');
INSERT INTO model_has_roles VALUES('2','App\\User','544');
INSERT INTO model_has_roles VALUES('2','App\\User','1993');
INSERT INTO model_has_roles VALUES('2','App\\User','1994');
INSERT INTO model_has_roles VALUES('2','App\\User','1995');
INSERT INTO model_has_roles VALUES('2','App\\User','2017');
INSERT INTO model_has_roles VALUES('3','App\\User','39');
INSERT INTO model_has_roles VALUES('4','App\\User','11');
INSERT INTO model_has_roles VALUES('4','App\\User','23');
INSERT INTO model_has_roles VALUES('4','App\\User','26');
INSERT INTO model_has_roles VALUES('4','App\\User','45');
INSERT INTO model_has_roles VALUES('4','App\\User','55');
INSERT INTO model_has_roles VALUES('4','App\\User','62');
INSERT INTO model_has_roles VALUES('4','App\\User','63');
INSERT INTO model_has_roles VALUES('4','App\\User','70');
INSERT INTO model_has_roles VALUES('4','App\\User','71');
INSERT INTO model_has_roles VALUES('4','App\\User','73');
INSERT INTO model_has_roles VALUES('4','App\\User','74');
INSERT INTO model_has_roles VALUES('4','App\\User','81');
INSERT INTO model_has_roles VALUES('4','App\\User','89');
INSERT INTO model_has_roles VALUES('4','App\\User','107');
INSERT INTO model_has_roles VALUES('4','App\\User','108');
INSERT INTO model_has_roles VALUES('4','App\\User','150');
INSERT INTO model_has_roles VALUES('4','App\\User','446');
INSERT INTO model_has_roles VALUES('4','App\\User','1992');
INSERT INTO model_has_roles VALUES('6','App\\User','9');
INSERT INTO model_has_roles VALUES('6','App\\User','10');
INSERT INTO model_has_roles VALUES('6','App\\User','56');
INSERT INTO model_has_roles VALUES('6','App\\User','131');
INSERT INTO model_has_roles VALUES('6','App\\User','163');
INSERT INTO model_has_roles VALUES('6','App\\User','164');
INSERT INTO model_has_roles VALUES('6','App\\User','165');
INSERT INTO model_has_roles VALUES('6','App\\User','166');
INSERT INTO model_has_roles VALUES('6','App\\User','440');
INSERT INTO model_has_roles VALUES('6','App\\User','534');
INSERT INTO model_has_roles VALUES('6','App\\User','535');
INSERT INTO model_has_roles VALUES('6','App\\User','536');
INSERT INTO model_has_roles VALUES('6','App\\User','537');
INSERT INTO model_has_roles VALUES('6','App\\User','538');
INSERT INTO model_has_roles VALUES('6','App\\User','539');
INSERT INTO model_has_roles VALUES('6','App\\User','540');
INSERT INTO model_has_roles VALUES('6','App\\User','541');
INSERT INTO model_has_roles VALUES('6','App\\User','1093');



CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `oauth_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `secret` varchar(100) DEFAULT NULL,
  `provider` varchar(255) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `office_shifts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shift_name` varchar(191) NOT NULL,
  `default_shift` varchar(191) DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `sunday_in` varchar(191) DEFAULT NULL,
  `sunday_out` varchar(191) DEFAULT NULL,
  `saturday_in` varchar(191) DEFAULT NULL,
  `saturday_out` varchar(191) DEFAULT NULL,
  `friday_in` varchar(191) DEFAULT NULL,
  `friday_out` varchar(191) DEFAULT NULL,
  `thursday_in` varchar(191) DEFAULT NULL,
  `thursday_out` varchar(191) DEFAULT NULL,
  `wednesday_in` varchar(191) DEFAULT NULL,
  `wednesday_out` varchar(191) DEFAULT NULL,
  `tuesday_in` varchar(191) DEFAULT NULL,
  `tuesday_out` varchar(191) DEFAULT NULL,
  `monday_in` varchar(191) DEFAULT NULL,
  `monday_out` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `sunday_range_in` varchar(191) NOT NULL,
  `sunday_range_out` varchar(191) NOT NULL,
  `saturday_range_in` varchar(191) NOT NULL,
  `saturday_range_out` varchar(191) NOT NULL,
  `friday_range_in` varchar(191) NOT NULL,
  `friday_range_out` varchar(191) NOT NULL,
  `thursday_range_in` varchar(191) NOT NULL,
  `thursday_range_out` varchar(191) NOT NULL,
  `wednesday_range_in` varchar(191) NOT NULL,
  `wednesday_range_out` varchar(191) NOT NULL,
  `tuesday_range_in` varchar(191) NOT NULL,
  `tuesday_range_out` varchar(191) NOT NULL,
  `monday_range_in` varchar(191) NOT NULL,
  `monday_range_out` varchar(191) NOT NULL,
  `min_work_hour` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `office_shifts_company_id_foreign` (`company_id`),
  CONSTRAINT `office_shifts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `official_documents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `document_type_id` bigint(20) unsigned DEFAULT NULL,
  `added_by` bigint(20) unsigned DEFAULT NULL,
  `document_title` varchar(191) NOT NULL,
  `identification_number` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `document_file` varchar(191) DEFAULT NULL,
  `expiry_date` date NOT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `official_documents_company_id_foreign` (`company_id`),
  KEY `official_documents_document_type_id_foreign` (`document_type_id`),
  KEY `official_documents_added_by_foreign` (`added_by`),
  CONSTRAINT `official_documents_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `official_documents_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `official_documents_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `document_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO password_resets VALUES('new@gmail.com','$2y$10$day4AQ4g8sFvMwhMrTxpJuLXZCpVF2IK9kVS.6qZxeR6b7CVt2eGy','2020-10-06 11:22:35');
INSERT INTO password_resets VALUES('yeremia.salmoon@rudolf.co.id','$2y$10$QGA9grIFTz.d6xaMDjoVvOBse85JJYx3et39qvhrvwPDdsgSWERLG','2023-06-05 11:32:57');
INSERT INTO password_resets VALUES('heri.irawan@timas.com ','$2y$10$F5/UezNEc2LZFsPx8sADSeohM4L.NPFuXxpIC8jV1COMv1NP7HAt6','2023-11-29 10:51:33');
INSERT INTO password_resets VALUES('framces@rekret.com','$2y$10$jNelpVZuC3k59vIpL3PyZux7TIS.rS4w2o0Ff7HMmrb54b6g5c91q','2023-11-29 21:16:54');
INSERT INTO password_resets VALUES('dwitami.wulandari@timas.com','$2y$10$xo.W83ZZ3qE1CqMDyy0sbej7sKdxizIFrKD6fKojW7tJCPn35jSDC','2023-12-06 09:59:43');



CREATE TABLE `payment_methods` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `method_name` varchar(40) NOT NULL,
  `payment_percentage` varchar(100) DEFAULT NULL,
  `account_number` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_methods_company_id_foreign` (`company_id`),
  CONSTRAINT `payment_methods_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payslips` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payslip_key` char(36) NOT NULL,
  `payslip_number` varchar(191) DEFAULT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `payment_type` varchar(191) NOT NULL,
  `basic_salary` double NOT NULL,
  `net_salary` double NOT NULL,
  `allowances` text NOT NULL,
  `commissions` text NOT NULL,
  `loans` text NOT NULL,
  `deductions` text NOT NULL,
  `overtimes` text NOT NULL,
  `other_payments` text NOT NULL,
  `pension_type` varchar(50) DEFAULT NULL,
  `pension_amount` double NOT NULL,
  `hours_worked` int(11) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `month_year` varchar(15) NOT NULL,
  `pph` text DEFAULT NULL,
  `bpjs_kesehatan` text DEFAULT NULL,
  `bpjs_pensiun` text DEFAULT NULL,
  `bpjs_jht` text DEFAULT NULL,
  `bpjs_jkk` text DEFAULT NULL,
  `bpjs_jkm` text DEFAULT NULL,
  `attendance_cut` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payslips_employee_id_foreign` (`employee_id`),
  CONSTRAINT `payslips_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=329 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES('1','user','web','','');
INSERT INTO permissions VALUES('2','view-user','web','','');
INSERT INTO permissions VALUES('3','edit-user','web','','');
INSERT INTO permissions VALUES('4','delete-user','web','','');
INSERT INTO permissions VALUES('5','last-login-user','web','','');
INSERT INTO permissions VALUES('6','role-access-user','web','','');
INSERT INTO permissions VALUES('7','details-employee','web','','');
INSERT INTO permissions VALUES('8','view-details-employee','web','','');
INSERT INTO permissions VALUES('9','store-details-employee','web','','');
INSERT INTO permissions VALUES('10','modify-details-employee','web','','');
INSERT INTO permissions VALUES('11','customize-setting','web','','');
INSERT INTO permissions VALUES('12','role-access','web','','');
INSERT INTO permissions VALUES('13','general-setting','web','','');
INSERT INTO permissions VALUES('14','view-general-setting','web','','');
INSERT INTO permissions VALUES('15','store-general-setting','web','','');
INSERT INTO permissions VALUES('16','mail-setting','web','','');
INSERT INTO permissions VALUES('17','view-mail-setting','web','','');
INSERT INTO permissions VALUES('18','store-mail-setting','web','','');
INSERT INTO permissions VALUES('19','language-setting','web','','');
INSERT INTO permissions VALUES('20','core_hr','web','','');
INSERT INTO permissions VALUES('21','view-calendar','web','','');
INSERT INTO permissions VALUES('22','promotion','web','','');
INSERT INTO permissions VALUES('23','view-promotion','web','','');
INSERT INTO permissions VALUES('24','store-promotion','web','','');
INSERT INTO permissions VALUES('25','edit-promotion','web','','');
INSERT INTO permissions VALUES('26','delete-promotion','web','','');
INSERT INTO permissions VALUES('27','award','web','','');
INSERT INTO permissions VALUES('28','view-award','web','','');
INSERT INTO permissions VALUES('29','store-award','web','','');
INSERT INTO permissions VALUES('30','edit-award','web','','');
INSERT INTO permissions VALUES('31','delete-award','web','','');
INSERT INTO permissions VALUES('32','transfer','web','','');
INSERT INTO permissions VALUES('33','view-transfer','web','','');
INSERT INTO permissions VALUES('34','store-transfer','web','','');
INSERT INTO permissions VALUES('35','edit-transfer','web','','');
INSERT INTO permissions VALUES('36','delete-transfer','web','','');
INSERT INTO permissions VALUES('37','travel','web','','');
INSERT INTO permissions VALUES('38','view-travel','web','','');
INSERT INTO permissions VALUES('39','store-travel','web','','');
INSERT INTO permissions VALUES('40','edit-travel','web','','');
INSERT INTO permissions VALUES('41','delete-travel','web','','');
INSERT INTO permissions VALUES('42','resignation','web','','');
INSERT INTO permissions VALUES('43','view-resignation','web','','');
INSERT INTO permissions VALUES('44','store-resignation','web','','');
INSERT INTO permissions VALUES('45','edit-resignation','web','','');
INSERT INTO permissions VALUES('46','delete-resignation','web','','');
INSERT INTO permissions VALUES('47','complaint','web','','');
INSERT INTO permissions VALUES('48','view-complaint','web','','');
INSERT INTO permissions VALUES('49','store-complaint','web','','');
INSERT INTO permissions VALUES('50','edit-complaint','web','','');
INSERT INTO permissions VALUES('51','delete-complaint','web','','');
INSERT INTO permissions VALUES('52','warning','web','','');
INSERT INTO permissions VALUES('53','view-warning','web','','');
INSERT INTO permissions VALUES('54','store-warning','web','','');
INSERT INTO permissions VALUES('55','edit-warning','web','','');
INSERT INTO permissions VALUES('56','delete-warning','web','','');
INSERT INTO permissions VALUES('57','termination','web','','');
INSERT INTO permissions VALUES('58','view-termination','web','','');
INSERT INTO permissions VALUES('59','store-termination','web','','');
INSERT INTO permissions VALUES('60','edit-termination','web','','');
INSERT INTO permissions VALUES('61','delete-termination','web','','');
INSERT INTO permissions VALUES('62','timesheet','web','','');
INSERT INTO permissions VALUES('63','attendance','web','','');
INSERT INTO permissions VALUES('64','view-attendance','web','','');
INSERT INTO permissions VALUES('65','edit-attendance','web','','');
INSERT INTO permissions VALUES('66','office_shift','web','','');
INSERT INTO permissions VALUES('67','view-office_shift','web','','');
INSERT INTO permissions VALUES('68','store-office_shift','web','','');
INSERT INTO permissions VALUES('69','edit-office_shift','web','','');
INSERT INTO permissions VALUES('70','delete-office_shift','web','','');
INSERT INTO permissions VALUES('71','holiday','web','','');
INSERT INTO permissions VALUES('72','view-holiday','web','','');
INSERT INTO permissions VALUES('73','store-holiday','web','','');
INSERT INTO permissions VALUES('74','edit-holiday','web','','');
INSERT INTO permissions VALUES('75','delete-holiday','web','','');
INSERT INTO permissions VALUES('76','leave','web','','');
INSERT INTO permissions VALUES('77','view-holiday','web','','');
INSERT INTO permissions VALUES('78','store-holiday','web','','');
INSERT INTO permissions VALUES('79','edit-holiday','web','','');
INSERT INTO permissions VALUES('80','delete-holiday','web','','');
INSERT INTO permissions VALUES('81','payment-module','web','','');
INSERT INTO permissions VALUES('82','view-payslip','web','','');
INSERT INTO permissions VALUES('83','make-payment','web','','');
INSERT INTO permissions VALUES('84','make-bulk_payment','web','','');
INSERT INTO permissions VALUES('85','view-paylist','web','','');
INSERT INTO permissions VALUES('86','set-salary','web','','');
INSERT INTO permissions VALUES('87','hr_report','web','','');
INSERT INTO permissions VALUES('88','report-payslip','web','','');
INSERT INTO permissions VALUES('89','report-attendance','web','','');
INSERT INTO permissions VALUES('90','report-training','web','','');
INSERT INTO permissions VALUES('91','report-project','web','','');
INSERT INTO permissions VALUES('92','report-task','web','','');
INSERT INTO permissions VALUES('93','report-employee','web','','');
INSERT INTO permissions VALUES('94','report-account','web','','');
INSERT INTO permissions VALUES('95','report-deposit','web','','');
INSERT INTO permissions VALUES('96','report-expense','web','','');
INSERT INTO permissions VALUES('97','report-transaction','web','','');
INSERT INTO permissions VALUES('98','recruitment','web','','');
INSERT INTO permissions VALUES('99','job_employer','web','','');
INSERT INTO permissions VALUES('100','view-job_employer','web','','');
INSERT INTO permissions VALUES('101','store-job_employer','web','','');
INSERT INTO permissions VALUES('102','edit-job_employer','web','','');
INSERT INTO permissions VALUES('103','delete-job_employer','web','','');
INSERT INTO permissions VALUES('104','job_post','web','','');
INSERT INTO permissions VALUES('105','view-job_post','web','','');
INSERT INTO permissions VALUES('106','store-job_post','web','','');
INSERT INTO permissions VALUES('107','edit-job_post','web','','');
INSERT INTO permissions VALUES('108','delete-job_post','web','','');
INSERT INTO permissions VALUES('109','job_candidate','web','','');
INSERT INTO permissions VALUES('110','view-job_candidate','web','','');
INSERT INTO permissions VALUES('111','store-job_candidate','web','','');
INSERT INTO permissions VALUES('112','delete-job_candidate','web','','');
INSERT INTO permissions VALUES('113','job_interview','web','','');
INSERT INTO permissions VALUES('114','view-job_interview','web','','');
INSERT INTO permissions VALUES('115','store-job_interview','web','','');
INSERT INTO permissions VALUES('116','delete-job_interview','web','','');
INSERT INTO permissions VALUES('117','project-management','web','','');
INSERT INTO permissions VALUES('118','project','web','','');
INSERT INTO permissions VALUES('119','view-project','web','','');
INSERT INTO permissions VALUES('120','store-project','web','','');
INSERT INTO permissions VALUES('121','edit-project','web','','');
INSERT INTO permissions VALUES('122','delete-project','web','','');
INSERT INTO permissions VALUES('123','task','web','','');
INSERT INTO permissions VALUES('124','view-task','web','','');
INSERT INTO permissions VALUES('125','store-task','web','','');
INSERT INTO permissions VALUES('126','edit-task','web','','');
INSERT INTO permissions VALUES('127','delete-task','web','','');
INSERT INTO permissions VALUES('128','client','web','','');
INSERT INTO permissions VALUES('129','view-client','web','','');
INSERT INTO permissions VALUES('130','store-client','web','','');
INSERT INTO permissions VALUES('131','edit-client','web','','');
INSERT INTO permissions VALUES('132','delete-client','web','','');
INSERT INTO permissions VALUES('133','invoice','web','','');
INSERT INTO permissions VALUES('134','view-invoice','web','','');
INSERT INTO permissions VALUES('135','store-invoice','web','','');
INSERT INTO permissions VALUES('136','edit-invoice','web','','');
INSERT INTO permissions VALUES('137','delete-invoice','web','','');
INSERT INTO permissions VALUES('138','ticket','web','','');
INSERT INTO permissions VALUES('139','view-ticket','web','','');
INSERT INTO permissions VALUES('140','store-ticket','web','','');
INSERT INTO permissions VALUES('141','edit-ticket','web','','');
INSERT INTO permissions VALUES('142','delete-ticket','web','','');
INSERT INTO permissions VALUES('143','import-module','web','','');
INSERT INTO permissions VALUES('144','import-attendance','web','','');
INSERT INTO permissions VALUES('145','import-employee','web','','');
INSERT INTO permissions VALUES('146','file_module','web','','');
INSERT INTO permissions VALUES('147','file_manager','web','','');
INSERT INTO permissions VALUES('148','view-file_manager','web','','');
INSERT INTO permissions VALUES('149','store-file_manager','web','','');
INSERT INTO permissions VALUES('150','edit-file_manager','web','','');
INSERT INTO permissions VALUES('151','delete-file_manager','web','','');
INSERT INTO permissions VALUES('152','view-file_config','web','','');
INSERT INTO permissions VALUES('153','official_document','web','','');
INSERT INTO permissions VALUES('154','view-official_document','web','','');
INSERT INTO permissions VALUES('155','store-official_document','web','','');
INSERT INTO permissions VALUES('156','edit-official_document','web','','');
INSERT INTO permissions VALUES('157','delete-official_document','web','','');
INSERT INTO permissions VALUES('158','event-meeting','web','','');
INSERT INTO permissions VALUES('159','meeting','web','','');
INSERT INTO permissions VALUES('160','view-meeting','web','','');
INSERT INTO permissions VALUES('161','store-meeting','web','','');
INSERT INTO permissions VALUES('162','edit-meeting','web','','');
INSERT INTO permissions VALUES('163','delete-meeting','web','','');
INSERT INTO permissions VALUES('164','event','web','','');
INSERT INTO permissions VALUES('165','view-event','web','','');
INSERT INTO permissions VALUES('166','store-event','web','','');
INSERT INTO permissions VALUES('167','edit-event','web','','');
INSERT INTO permissions VALUES('168','delete-event','web','','');
INSERT INTO permissions VALUES('169','role','web','','');
INSERT INTO permissions VALUES('170','view-role','web','','');
INSERT INTO permissions VALUES('171','store-role','web','','');
INSERT INTO permissions VALUES('172','edit-role','web','','');
INSERT INTO permissions VALUES('173','delete-role','web','','');
INSERT INTO permissions VALUES('174','assign-module','web','','');
INSERT INTO permissions VALUES('175','assign-role','web','','');
INSERT INTO permissions VALUES('176','assign-ticket','web','','');
INSERT INTO permissions VALUES('177','assign-project','web','','');
INSERT INTO permissions VALUES('178','assign-task','web','','');
INSERT INTO permissions VALUES('179','finance','web','','');
INSERT INTO permissions VALUES('180','account','web','','');
INSERT INTO permissions VALUES('181','view-account','web','','');
INSERT INTO permissions VALUES('182','store-account','web','','');
INSERT INTO permissions VALUES('183','edit-account','web','','');
INSERT INTO permissions VALUES('184','delete-account','web','','');
INSERT INTO permissions VALUES('185','view-transaction','web','','');
INSERT INTO permissions VALUES('186','view-balance_transfer','web','','');
INSERT INTO permissions VALUES('187','store-balance_transfer','web','','');
INSERT INTO permissions VALUES('188','expense','web','','');
INSERT INTO permissions VALUES('189','view-expense','web','','');
INSERT INTO permissions VALUES('190','store-expense','web','','');
INSERT INTO permissions VALUES('191','edit-expense','web','','');
INSERT INTO permissions VALUES('192','delete-expense','web','','');
INSERT INTO permissions VALUES('193','deposit','web','','');
INSERT INTO permissions VALUES('194','view-deposit','web','','');
INSERT INTO permissions VALUES('195','store-deposit','web','','');
INSERT INTO permissions VALUES('196','edit-deposit','web','','');
INSERT INTO permissions VALUES('197','delete-deposit','web','','');
INSERT INTO permissions VALUES('198','payer','web','','');
INSERT INTO permissions VALUES('199','view-payer','web','','');
INSERT INTO permissions VALUES('200','store-payer','web','','');
INSERT INTO permissions VALUES('201','edit-payer','web','','');
INSERT INTO permissions VALUES('202','delete-payer','web','','');
INSERT INTO permissions VALUES('203','payee','web','','');
INSERT INTO permissions VALUES('204','view-payee','web','','');
INSERT INTO permissions VALUES('205','store-payee','web','','');
INSERT INTO permissions VALUES('206','edit-payee','web','','');
INSERT INTO permissions VALUES('207','delete-payee','web','','');
INSERT INTO permissions VALUES('208','training_module','web','','');
INSERT INTO permissions VALUES('209','trainer','web','','');
INSERT INTO permissions VALUES('210','view-trainer','web','','');
INSERT INTO permissions VALUES('211','store-trainer','web','','');
INSERT INTO permissions VALUES('212','edit-trainer','web','','');
INSERT INTO permissions VALUES('213','delete-trainer','web','','');
INSERT INTO permissions VALUES('214','training','web','','');
INSERT INTO permissions VALUES('215','view-training','web','','');
INSERT INTO permissions VALUES('216','store-training','web','','');
INSERT INTO permissions VALUES('217','edit-training','web','','');
INSERT INTO permissions VALUES('218','delete-training','web','','');
INSERT INTO permissions VALUES('219','access-module','web','','');
INSERT INTO permissions VALUES('220','access-variable_type','web','','');
INSERT INTO permissions VALUES('221','access-variable_method','web','','');
INSERT INTO permissions VALUES('222','access-language','web','','');
INSERT INTO permissions VALUES('223','announcement','web','','');
INSERT INTO permissions VALUES('224','store-announcement','web','','');
INSERT INTO permissions VALUES('225','edit-announcement','web','','');
INSERT INTO permissions VALUES('226','delete-announcement','web','','');
INSERT INTO permissions VALUES('227','company','web','','');
INSERT INTO permissions VALUES('228','view-company','web','','');
INSERT INTO permissions VALUES('229','store-company','web','','');
INSERT INTO permissions VALUES('230','edit-company','web','','');
INSERT INTO permissions VALUES('231','delete-company','web','','');
INSERT INTO permissions VALUES('232','department','web','','');
INSERT INTO permissions VALUES('233','view-department','web','','');
INSERT INTO permissions VALUES('234','store-department','web','','');
INSERT INTO permissions VALUES('235','edit-department','web','','');
INSERT INTO permissions VALUES('236','delete-department','web','','');
INSERT INTO permissions VALUES('237','designation','web','','');
INSERT INTO permissions VALUES('238','view-designation','web','','');
INSERT INTO permissions VALUES('239','store-designation','web','','');
INSERT INTO permissions VALUES('240','edit-designation','web','','');
INSERT INTO permissions VALUES('241','delete-designation','web','','');
INSERT INTO permissions VALUES('242','location','web','','');
INSERT INTO permissions VALUES('243','view-location','web','','');
INSERT INTO permissions VALUES('244','store-location','web','','');
INSERT INTO permissions VALUES('245','edit-location','web','','');
INSERT INTO permissions VALUES('246','delete-location','web','','');
INSERT INTO permissions VALUES('247','policy','web','','');
INSERT INTO permissions VALUES('248','store-policy','web','','');
INSERT INTO permissions VALUES('249','edit-policy','web','','');
INSERT INTO permissions VALUES('250','delete-policy','web','','');
INSERT INTO permissions VALUES('251','view-cms','web','','');
INSERT INTO permissions VALUES('252','store-cms','web','','');
INSERT INTO permissions VALUES('253','store-user','web','','');
INSERT INTO permissions VALUES('254','delete-attendance','web','','');
INSERT INTO permissions VALUES('255','view-leave','web','','');
INSERT INTO permissions VALUES('256','store-leave','web','','');
INSERT INTO permissions VALUES('257','edit-leave','web','','');
INSERT INTO permissions VALUES('258','delete-leave','web','','');
INSERT INTO permissions VALUES('259','cms','web','','');
INSERT INTO permissions VALUES('260','performance','web','','');
INSERT INTO permissions VALUES('261','goal-type','web','','');
INSERT INTO permissions VALUES('262','view-goal-type','web','','');
INSERT INTO permissions VALUES('263','store-goal-type','web','','');
INSERT INTO permissions VALUES('264','edit-goal-type','web','','');
INSERT INTO permissions VALUES('265','delete-goal-type','web','','');
INSERT INTO permissions VALUES('266','goal-tracking','web','','');
INSERT INTO permissions VALUES('267','view-goal-tracking','web','','');
INSERT INTO permissions VALUES('268','store-goal-tracking','web','','');
INSERT INTO permissions VALUES('269','edit-goal-tracking','web','','');
INSERT INTO permissions VALUES('270','delete-goal-tracking','web','','');
INSERT INTO permissions VALUES('271','indicator','web','','');
INSERT INTO permissions VALUES('272','view-indicator','web','','');
INSERT INTO permissions VALUES('273','store-indicator','web','','');
INSERT INTO permissions VALUES('274','edit-indicator','web','','');
INSERT INTO permissions VALUES('275','delete-indicator','web','','');
INSERT INTO permissions VALUES('276','appraisal','web','','');
INSERT INTO permissions VALUES('277','view-appraisal','web','','');
INSERT INTO permissions VALUES('278','store-appraisal','web','','');
INSERT INTO permissions VALUES('279','edit-appraisal','web','','');
INSERT INTO permissions VALUES('280','delete-appraisal','web','','');
INSERT INTO permissions VALUES('281','assets-and-category','web','','');
INSERT INTO permissions VALUES('282','category','web','','');
INSERT INTO permissions VALUES('283','view-assets-category','web','','');
INSERT INTO permissions VALUES('284','store-assets-category','web','','');
INSERT INTO permissions VALUES('285','edit-assets-category','web','','');
INSERT INTO permissions VALUES('286','delete-assets-category','web','','');
INSERT INTO permissions VALUES('287','assets','web','','');
INSERT INTO permissions VALUES('288','view-assets','web','','');
INSERT INTO permissions VALUES('289','store-assets','web','','');
INSERT INTO permissions VALUES('290','edit-assets','web','','');
INSERT INTO permissions VALUES('291','delete-assets','web','','');
INSERT INTO permissions VALUES('292','daily-attendances','web','','');
INSERT INTO permissions VALUES('293','date-wise-attendances','web','','');
INSERT INTO permissions VALUES('294','monthly-attendances','web','','');
INSERT INTO permissions VALUES('295','set-permission','web','','');
INSERT INTO permissions VALUES('296','get-leave-notification','web','','');
INSERT INTO permissions VALUES('297','report-pension','web','','');
INSERT INTO permissions VALUES('299','view-bpjs-tk','web','2023-02-09 15:15:19','2023-02-09 15:15:19');
INSERT INTO permissions VALUES('300','store-bpjs-tk','web','2023-02-09 15:25:01','2023-02-09 15:25:01');
INSERT INTO permissions VALUES('301','delete-bpjs-tk','web','2023-02-09 15:25:07','2023-02-09 15:25:07');
INSERT INTO permissions VALUES('302','edit-bpjs-tk','web','2023-02-09 15:25:13','2023-02-09 15:25:13');
INSERT INTO permissions VALUES('303','view-bpjs-kes','web','2023-02-09 17:15:16','2023-02-09 17:15:16');
INSERT INTO permissions VALUES('304','store-bpjs-kes','web','2023-02-09 17:15:22','2023-02-09 17:15:22');
INSERT INTO permissions VALUES('305','edit-bpjs-kes','web','2023-02-09 17:15:39','2023-02-09 17:15:39');
INSERT INTO permissions VALUES('306','delete-bpjs-kes','web','2023-02-09 17:15:44','2023-02-09 17:15:44');
INSERT INTO permissions VALUES('307','view-tax','web','2023-02-09 17:31:58','2023-02-09 17:31:58');
INSERT INTO permissions VALUES('308','store-tax','web','2023-02-09 17:32:07','2023-02-09 17:32:07');
INSERT INTO permissions VALUES('310','edit-tax','web','2023-02-09 17:32:25','2023-02-09 17:32:25');
INSERT INTO permissions VALUES('311','delete-tax','web','2023-02-09 17:32:31','2023-02-09 17:32:31');
INSERT INTO permissions VALUES('312','view-ptkp','web','2023-02-09 18:42:02','2023-02-09 18:42:02');
INSERT INTO permissions VALUES('313','store-ptkp','web','2023-02-09 18:42:09','2023-02-09 18:42:09');
INSERT INTO permissions VALUES('314','edit-ptkp','web','2023-02-09 18:42:14','2023-02-09 18:42:14');
INSERT INTO permissions VALUES('315','delete-ptkp','web','2023-02-09 18:42:20','2023-02-09 18:42:20');
INSERT INTO permissions VALUES('316','view-reimbursement','web','','');
INSERT INTO permissions VALUES('317','edit-reimbursement','web','','');
INSERT INTO permissions VALUES('318','store-reimbursement','web','','');
INSERT INTO permissions VALUES('319','delete-reimbursement','web','','');
INSERT INTO permissions VALUES('320','view-mail-receiver','web','','');
INSERT INTO permissions VALUES('321','edit-mail-receiver','web','','');
INSERT INTO permissions VALUES('322','store-mail-receiver','web','','');
INSERT INTO permissions VALUES('323','delete-mail-receiver','web','','');
INSERT INTO permissions VALUES('324','view-log-report-attendance','web','','');
INSERT INTO permissions VALUES('325','view-dashboard','web','','');
INSERT INTO permissions VALUES('326','view-organization','web','','');
INSERT INTO permissions VALUES('327','view-announcement','web','','');
INSERT INTO permissions VALUES('328','view-company-policy','web','','');



CREATE TABLE `policies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `description` longtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `added_by` varchar(40) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `policies_company_id_foreign` (`company_id`),
  KEY `policies_added_by_foreign` (`added_by`),
  CONSTRAINT `policies_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `project_bugs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `title` mediumtext NOT NULL,
  `bug_attachment` varchar(191) DEFAULT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_bugs_user_id_foreign` (`user_id`),
  KEY `project_bugs_project_id_foreign` (`project_id`),
  CONSTRAINT `project_bugs_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `project_bugs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `project_discussions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `project_discussion` mediumtext NOT NULL,
  `discussion_attachment` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_discussions_user_id_foreign` (`user_id`),
  KEY `project_discussions_project_id_foreign` (`project_id`),
  CONSTRAINT `project_discussions_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `project_discussions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `project_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `file_title` varchar(191) NOT NULL,
  `file_attachment` varchar(191) NOT NULL,
  `file_description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_files_user_id_foreign` (`user_id`),
  KEY `project_files_project_id_foreign` (`project_id`),
  CONSTRAINT `project_files_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `project_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `projects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `client_id` bigint(20) unsigned DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `project_priority` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `summary` mediumtext DEFAULT NULL,
  `project_status` varchar(40) NOT NULL DEFAULT 'not started',
  `project_note` longtext DEFAULT NULL,
  `project_progress` varchar(191) DEFAULT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `added_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `projects_client_id_foreign` (`client_id`),
  KEY `projects_company_id_foreign` (`company_id`),
  KEY `projects_added_by_foreign` (`added_by`),
  CONSTRAINT `projects_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `projects_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`) ON DELETE SET NULL,
  CONSTRAINT `projects_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `promotions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `promotion_title` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `promotion_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `promotions_company_id_foreign` (`company_id`),
  KEY `promotions_employee_id_foreign` (`employee_id`),
  CONSTRAINT `promotions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `promotions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `ptkp` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `value` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ptkp_company_id_foreign` (`company_id`),
  CONSTRAINT `ptkp_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `qualification_education_levels` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qualification_education_levels_company_id_foreign` (`company_id`),
  CONSTRAINT `qualification_education_levels_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `qualification_languages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qualification_languages_company_id_foreign` (`company_id`),
  CONSTRAINT `qualification_languages_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `qualification_skills` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qualification_skills_company_id_foreign` (`company_id`),
  CONSTRAINT `qualification_skills_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `raw_attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `attendance_date` date NOT NULL,
  `attendance_time` time NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_attendances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `raw_attendances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `reimbursement_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `reimbursements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `reimbursement_type_id` bigint(20) unsigned DEFAULT NULL,
  `amount` double NOT NULL,
  `description` varchar(191) NOT NULL,
  `attachment` varchar(191) NOT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reimbursements_reimbursement_type_id_foreign` (`reimbursement_type_id`),
  KEY `reimbursements_employee_id_foreign` (`employee_id`),
  CONSTRAINT `reimbursements_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL,
  CONSTRAINT `reimbursements_reimbursement_type_id_foreign` FOREIGN KEY (`reimbursement_type_id`) REFERENCES `reimbursement_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `report_attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `attendance_date` date NOT NULL,
  `office_shift_id` int(11) DEFAULT 0,
  `work_time` time DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `is_checked` tinyint(1) NOT NULL,
  `is_underwork` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `report_attendances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `report_attendances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `resignations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `notice_date` date DEFAULT NULL,
  `resignation_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `resignations_company_id_foreign` (`company_id`),
  KEY `resignations_department_id_foreign` (`department_id`),
  KEY `resignations_employee_id_foreign` (`employee_id`),
  CONSTRAINT `resignations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resignations_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resignations_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO role_has_permissions VALUES('7','6');
INSERT INTO role_has_permissions VALUES('8','6');
INSERT INTO role_has_permissions VALUES('9','6');
INSERT INTO role_has_permissions VALUES('10','6');
INSERT INTO role_has_permissions VALUES('20','6');
INSERT INTO role_has_permissions VALUES('21','6');
INSERT INTO role_has_permissions VALUES('22','6');
INSERT INTO role_has_permissions VALUES('23','6');
INSERT INTO role_has_permissions VALUES('24','6');
INSERT INTO role_has_permissions VALUES('25','6');
INSERT INTO role_has_permissions VALUES('26','6');
INSERT INTO role_has_permissions VALUES('27','6');
INSERT INTO role_has_permissions VALUES('28','6');
INSERT INTO role_has_permissions VALUES('29','6');
INSERT INTO role_has_permissions VALUES('30','6');
INSERT INTO role_has_permissions VALUES('31','6');
INSERT INTO role_has_permissions VALUES('32','6');
INSERT INTO role_has_permissions VALUES('33','6');
INSERT INTO role_has_permissions VALUES('34','6');
INSERT INTO role_has_permissions VALUES('35','6');
INSERT INTO role_has_permissions VALUES('36','6');
INSERT INTO role_has_permissions VALUES('42','6');
INSERT INTO role_has_permissions VALUES('43','6');
INSERT INTO role_has_permissions VALUES('44','6');
INSERT INTO role_has_permissions VALUES('46','6');
INSERT INTO role_has_permissions VALUES('47','6');
INSERT INTO role_has_permissions VALUES('48','6');
INSERT INTO role_has_permissions VALUES('49','6');
INSERT INTO role_has_permissions VALUES('50','6');
INSERT INTO role_has_permissions VALUES('51','6');
INSERT INTO role_has_permissions VALUES('52','6');
INSERT INTO role_has_permissions VALUES('53','6');
INSERT INTO role_has_permissions VALUES('54','6');
INSERT INTO role_has_permissions VALUES('55','6');
INSERT INTO role_has_permissions VALUES('56','6');
INSERT INTO role_has_permissions VALUES('57','6');
INSERT INTO role_has_permissions VALUES('58','6');
INSERT INTO role_has_permissions VALUES('59','6');
INSERT INTO role_has_permissions VALUES('60','6');
INSERT INTO role_has_permissions VALUES('61','6');
INSERT INTO role_has_permissions VALUES('62','6');
INSERT INTO role_has_permissions VALUES('71','6');
INSERT INTO role_has_permissions VALUES('72','6');
INSERT INTO role_has_permissions VALUES('73','6');
INSERT INTO role_has_permissions VALUES('74','6');
INSERT INTO role_has_permissions VALUES('75','6');
INSERT INTO role_has_permissions VALUES('76','6');
INSERT INTO role_has_permissions VALUES('98','6');
INSERT INTO role_has_permissions VALUES('104','6');
INSERT INTO role_has_permissions VALUES('105','6');
INSERT INTO role_has_permissions VALUES('106','6');
INSERT INTO role_has_permissions VALUES('107','6');
INSERT INTO role_has_permissions VALUES('108','6');
INSERT INTO role_has_permissions VALUES('109','6');
INSERT INTO role_has_permissions VALUES('110','6');
INSERT INTO role_has_permissions VALUES('112','6');
INSERT INTO role_has_permissions VALUES('113','6');
INSERT INTO role_has_permissions VALUES('114','6');
INSERT INTO role_has_permissions VALUES('115','6');
INSERT INTO role_has_permissions VALUES('116','6');
INSERT INTO role_has_permissions VALUES('145','6');
INSERT INTO role_has_permissions VALUES('223','6');
INSERT INTO role_has_permissions VALUES('224','6');
INSERT INTO role_has_permissions VALUES('225','6');
INSERT INTO role_has_permissions VALUES('226','6');
INSERT INTO role_has_permissions VALUES('227','6');
INSERT INTO role_has_permissions VALUES('228','6');
INSERT INTO role_has_permissions VALUES('229','6');
INSERT INTO role_has_permissions VALUES('230','6');
INSERT INTO role_has_permissions VALUES('231','6');
INSERT INTO role_has_permissions VALUES('232','6');
INSERT INTO role_has_permissions VALUES('233','6');
INSERT INTO role_has_permissions VALUES('234','6');
INSERT INTO role_has_permissions VALUES('235','6');
INSERT INTO role_has_permissions VALUES('236','6');
INSERT INTO role_has_permissions VALUES('237','6');
INSERT INTO role_has_permissions VALUES('238','6');
INSERT INTO role_has_permissions VALUES('239','6');
INSERT INTO role_has_permissions VALUES('240','6');
INSERT INTO role_has_permissions VALUES('241','6');
INSERT INTO role_has_permissions VALUES('242','6');
INSERT INTO role_has_permissions VALUES('243','6');
INSERT INTO role_has_permissions VALUES('244','6');
INSERT INTO role_has_permissions VALUES('245','6');
INSERT INTO role_has_permissions VALUES('246','6');
INSERT INTO role_has_permissions VALUES('247','6');
INSERT INTO role_has_permissions VALUES('248','6');
INSERT INTO role_has_permissions VALUES('249','6');
INSERT INTO role_has_permissions VALUES('250','6');
INSERT INTO role_has_permissions VALUES('255','6');
INSERT INTO role_has_permissions VALUES('256','6');
INSERT INTO role_has_permissions VALUES('257','6');
INSERT INTO role_has_permissions VALUES('258','6');
INSERT INTO role_has_permissions VALUES('296','6');



CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `is_payroll` tinyint(1) NOT NULL,
  `is_ceo` tinyint(1) NOT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES('1','admin','web','Can access and change everything','1','1','1','','');
INSERT INTO roles VALUES('2','employee','web','Default access','0','0','1','2020-07-26 20:50:45','2020-07-26 20:50:45');
INSERT INTO roles VALUES('3','client','web','When you create a client, this role and associated.','0','0','1','2020-10-08 10:10:23','2020-10-08 10:10:23');
INSERT INTO roles VALUES('4','Manager','web','Can Manage','0','0','1','2021-02-24 17:24:58','2021-02-24 17:24:58');
INSERT INTO roles VALUES('6','HR','web','Manage Employee','0','0','1','2021-09-05 10:12:28','2023-02-16 11:50:27');



CREATE TABLE `salary_allowances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(191) NOT NULL,
  `first_date` date DEFAULT NULL,
  `allowance_title` varchar(191) NOT NULL,
  `allowance_amount` varchar(191) NOT NULL,
  `is_taxable` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_allowances_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_allowances_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `salary_basics` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(191) NOT NULL,
  `first_date` date DEFAULT NULL,
  `payslip_type` varchar(191) NOT NULL,
  `basic_salary` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_basics_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_basics_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `salary_commissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(191) NOT NULL,
  `commission_title` varchar(191) NOT NULL,
  `first_date` date DEFAULT NULL,
  `commission_amount` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_commissions_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_commissions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `salary_deductions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(50) NOT NULL,
  `first_date` date DEFAULT NULL,
  `deduction_title` varchar(191) NOT NULL,
  `deduction_amount` varchar(191) NOT NULL,
  `deduction_type` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_deductions_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_deductions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `salary_loans` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(50) NOT NULL,
  `first_date` date DEFAULT NULL,
  `loan_title` varchar(191) NOT NULL,
  `loan_amount` varchar(191) NOT NULL,
  `loan_type` varchar(191) NOT NULL,
  `loan_time` varchar(191) NOT NULL,
  `amount_remaining` varchar(191) NOT NULL,
  `time_remaining` varchar(191) NOT NULL,
  `monthly_payable` varchar(50) NOT NULL,
  `reason` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_loans_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_loans_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `salary_other_payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(50) NOT NULL DEFAULT '',
  `first_date` date DEFAULT NULL,
  `other_payment_title` varchar(191) NOT NULL,
  `other_payment_amount` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_other_payments_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_other_payments_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `salary_overtimes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint(20) unsigned NOT NULL,
  `month_year` varchar(50) NOT NULL,
  `first_date` date DEFAULT NULL,
  `overtime_title` varchar(191) NOT NULL,
  `no_of_days` varchar(191) NOT NULL,
  `overtime_hours` varchar(191) NOT NULL,
  `overtime_rate` varchar(191) NOT NULL,
  `overtime_amount` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `salary_overtimes_employee_id_foreign` (`employee_id`),
  CONSTRAINT `salary_overtimes_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `statuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;




CREATE TABLE `support_tickets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `department_id` bigint(20) unsigned DEFAULT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `ticket_code` varchar(15) NOT NULL,
  `subject` varchar(191) NOT NULL,
  `ticket_priority` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `ticket_remarks` mediumtext DEFAULT NULL,
  `ticket_status` varchar(40) NOT NULL,
  `ticket_note` varchar(191) DEFAULT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `ticket_attachment` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `support_tickets_ticket_code_unique` (`ticket_code`),
  KEY `support_tickets_company_id_foreign` (`company_id`),
  KEY `support_tickets_department_id_foreign` (`department_id`),
  KEY `support_tickets_employee_id_foreign` (`employee_id`),
  CONSTRAINT `support_tickets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `support_tickets_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`) ON DELETE SET NULL,
  CONSTRAINT `support_tickets_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `task_discussions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `task_discussion` mediumtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_discussions_user_id_foreign` (`user_id`),
  KEY `task_discussions_task_id_foreign` (`task_id`),
  CONSTRAINT `task_discussions_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `task_discussions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `task_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `file_title` varchar(191) NOT NULL,
  `file_attachment` varchar(191) NOT NULL,
  `file_description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_files_user_id_foreign` (`user_id`),
  KEY `task_files_task_id_foreign` (`task_id`),
  CONSTRAINT `task_files_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `task_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `tasks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task_name` varchar(191) NOT NULL,
  `project_id` bigint(20) unsigned NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `task_hour` varchar(40) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `task_status` varchar(40) NOT NULL DEFAULT 'not started',
  `task_note` mediumtext DEFAULT NULL,
  `task_progress` varchar(191) DEFAULT NULL,
  `is_notify` tinyint(4) DEFAULT NULL,
  `added_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tasks_project_id_foreign` (`project_id`),
  KEY `tasks_company_id_foreign` (`company_id`),
  KEY `tasks_added_by_foreign` (`added_by`),
  CONSTRAINT `tasks_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tasks_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `tax_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `rate` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `taxes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `min_salary` double NOT NULL,
  `max_salary` double NOT NULL,
  `percentage` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `taxes_company_id_foreign` (`company_id`),
  CONSTRAINT `taxes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `termination_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `termination_title` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `terminations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `terminated_employee` bigint(20) unsigned NOT NULL,
  `termination_type` bigint(20) unsigned DEFAULT NULL,
  `termination_date` date NOT NULL,
  `notice_date` date NOT NULL,
  `status` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `terminations_company_id_foreign` (`company_id`),
  KEY `terminations_terminated_employee_foreign` (`terminated_employee`),
  KEY `terminations_termination_type_foreign` (`termination_type`),
  CONSTRAINT `terminations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `terminations_terminated_employee_foreign` FOREIGN KEY (`terminated_employee`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `terminations_termination_type_foreign` FOREIGN KEY (`termination_type`) REFERENCES `termination_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `ticket_comments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ticket_comments` mediumtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_comments_ticket_id_foreign` (`ticket_id`),
  KEY `ticket_comments_user_id_foreign` (`user_id`),
  CONSTRAINT `ticket_comments_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ticket_comments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `trainers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) NOT NULL,
  `last_name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `contact_no` varchar(15) NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `address` mediumtext DEFAULT NULL,
  `expertise` mediumtext NOT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `trainers_company_id_foreign` (`company_id`),
  CONSTRAINT `trainers_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `training_lists` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `training_cost` varchar(191) NOT NULL,
  `status` varchar(30) NOT NULL,
  `remarks` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `trainer_id` bigint(20) unsigned DEFAULT NULL,
  `training_type_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `training_lists_company_id_foreign` (`company_id`),
  KEY `training_lists_trainer_id_foreign` (`trainer_id`),
  KEY `training_lists_training_type_id_foreign` (`training_type_id`),
  CONSTRAINT `training_lists_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `training_lists_trainer_id_foreign` FOREIGN KEY (`trainer_id`) REFERENCES `trainers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `training_lists_training_type_id_foreign` FOREIGN KEY (`training_type_id`) REFERENCES `training_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `training_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) unsigned NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `transfers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `from_department_id` bigint(20) unsigned DEFAULT NULL,
  `to_department_id` bigint(20) unsigned DEFAULT NULL,
  `employee_id` bigint(20) unsigned DEFAULT NULL,
  `transfer_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfers_company_id_foreign` (`company_id`),
  KEY `transfers_from_department_id_foreign` (`from_department_id`),
  KEY `transfers_to_department_id_foreign` (`to_department_id`),
  KEY `transfers_employee_id_foreign` (`employee_id`),
  CONSTRAINT `transfers_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transfers_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transfers_from_department_id_foreign` FOREIGN KEY (`from_department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transfers_to_department_id_foreign` FOREIGN KEY (`to_department_id`) REFERENCES `departments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `travel_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `arrangement_type` varchar(191) NOT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `travel_types_company_id_foreign` (`company_id`),
  CONSTRAINT `travel_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `travels` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `travel_type` bigint(20) unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `purpose_of_visit` varchar(191) DEFAULT NULL,
  `place_of_visit` varchar(191) DEFAULT NULL,
  `expected_budget` varchar(20) DEFAULT NULL,
  `actual_budget` varchar(20) DEFAULT NULL,
  `travel_mode` varchar(20) NOT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `travels_company_id_foreign` (`company_id`),
  KEY `travels_employee_id_foreign` (`employee_id`),
  KEY `travels_travel_type_foreign` (`travel_type`),
  CONSTRAINT `travels_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `travels_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `travels_travel_type_foreign` FOREIGN KEY (`travel_type`) REFERENCES `travel_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `username` varchar(64) NOT NULL,
  `email` varchar(64) DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(191) NOT NULL,
  `profile_photo` varchar(191) DEFAULT NULL,
  `profile_bg` varchar(191) DEFAULT NULL,
  `role_users_id` bigint(20) unsigned NOT NULL,
  `company_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `contact_no` varchar(15) DEFAULT NULL,
  `last_login_ip` varchar(32) DEFAULT NULL,
  `last_login_date` timestamp(2) NULL DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `users_role_users_id_foreign` (`role_users_id`),
  CONSTRAINT `users_role_users_id_foreign` FOREIGN KEY (`role_users_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2029 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO users VALUES('1','Super','Admin','admin','superadmin@gmail.com','','$2y$10$D12jIhNBhyT3D/SmCfAcg.tNmgaYyhAvtVU2WHJxXNqUE3A2GG1Jm','admin_1639557363.jpg','','1','','1','1234','103.113.77.126','2024-02-05 15:30:29.00','3gXG4CthVDkOCtfHDla2nOXG3zdrsRufDtuBEsVplFwPmgWPjxd54a5lCfse','','2023-07-20 20:07:37','');
INSERT INTO users VALUES('9','Darma','Lin','darma','darmalin@rekret.com','','$2y$10$22XUN.vnJaJseVeOuCJECuFRQHdAampab4B9HePA4e.WdV2ScN1Bi','staff_1616582111.jpg','','6','','1','387292822','127.0.0.1','2023-02-28 19:03:58.00','','2020-07-27 02:51:54','2023-06-14 22:44:54','');
INSERT INTO users VALUES('11','Fram','Ces1','framces','framces@rekret.com','','$2y$10$nJ0kVYLeinYgFPl/e0Xx3uJz3nNINCiaYMvN9YKQiZwUrFUEd1lB6','','','4','','1','67278232','114.5.146.111','2023-08-23 10:19:51.00','','2020-07-27 03:03:25','2023-07-04 12:32:31','');
INSERT INTO users VALUES('51','Admin','Admin','admin_admin','admin@gmail.com','','$2y$10$eoqfN2lGpBHXWtj.WztEM.FLLTH0ofOoAWXERZSHC9mwEaf1NXVc6','gosofunab_1648442766.jpg','','1','','1','1211334234','','','','2022-03-28 11:46:07','2023-06-20 10:17:11','');
INSERT INTO users VALUES('300','','','AA00153','nita.cynthia@timas.com','','$2y$10$0nT8caoJYpQA9D.FYBQZpe1oKcB6HGFoV/hYlQxBK0yFdfGOM.1hW','','','2','','1','087884247982','','','','2023-08-17 23:08:11','2023-08-17 23:08:11','');
INSERT INTO users VALUES('301','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$847RQzE0eHRj5gNjmEg4Le1OChNBBB5u0g7KiU8byiCJ7VS7STmrK','','','2','','1','085945207276','','','','2023-08-17 23:08:11','2023-08-17 23:08:11','');
INSERT INTO users VALUES('302','','','AA00155','mahfudin.nur@timas.com','','$2y$10$0lF0IDAEIfvyDYyhl6wzNuCzV.xJru3UvcxAqWX21dYyfqliMvszi','','','2','','1','0817382906','','','','2023-08-17 23:08:11','2023-08-17 23:08:11','');
INSERT INTO users VALUES('307','','','AF0008','adi.yulianto@timas.com','','$2y$10$p.pTa1yXUdX95QbZk3oRbOFFz467KVXmFUq6FA/yG8r75Zb2.fNUe','','','2','','1','081217657221','','','','2023-08-17 23:08:12','2023-08-17 23:08:12','');
INSERT INTO users VALUES('308','','','AF0009','dany.sitompul@timas.com','','$2y$10$wvI0N/1cHRMdv9Q.49FcOumfmqZQLNYznmuG/EEYtZEofll0I4Af6','','','2','','1','082137543713','','','','2023-08-17 23:08:12','2023-08-17 23:08:12','');
INSERT INTO users VALUES('324','','','AA00152','adi.sutardi@timas.com','','$2y$10$BrKnrmp7GCNOMT2WKbIliOZmn2kXt358ZqdpKqh2Y0.p2G/7x/hre','','','2','','1','087827757751','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('325','','','AA00153','nita.cynthia@timas.com','','$2y$10$CbcDe2sb2wKCXTkCnJmn/.Bav1F0SHXo4MgzKuQiDYLStoZSHw.ny','','','2','','1','087884247982','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('326','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$0pnnFV/LhoflaKFKMhGVUe8LcpTLnZt1ok.KLopXs0ONRyTk8OICu','','','2','','1','085945207276','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('327','','','AA00155','mahfudin.nur@timas.com','','$2y$10$EFdbtdBhU8/NajfqkQhYOO/1ag4xvUgRCITKUWtPtiNjlIePeKxWO','','','2','','1','0817382906','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('328','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$70EKdwQssTbDliRbUuU8YO7ctf04/G3QHu04/olt1ND9chR8IpwTm','','','2','','1','081380806655','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('329','','','AF0005','wahyudin@timas.com ','','$2y$10$8ugQlG7yJ2WRv4QtHt8WHu5.xy.OQG3smYl4AnsyJX2adQjf2nLhK','','','2','','1','081364934014','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('330','','','AF0006','jimmer@timas.com','','$2y$10$ABs4Ay2VUyBZyq2dQPPqKeGk33IXAkEZB.vvoP199dbjP9ath1wQe','','','2','','1','081231047970','','','','2023-08-17 23:10:11','2023-08-17 23:10:11','');
INSERT INTO users VALUES('331','','','AF0007','aulia.gandi@timas.com ','','$2y$10$lhqcwlslhMbZRTPxAi9qnezxBr0AzzSBykTqIPg0UXhe16DBpQFce','','','2','','1','081354168025','','','','2023-08-17 23:10:12','2023-08-17 23:10:12','');
INSERT INTO users VALUES('332','','','AF0008','adi.yulianto@timas.com','','$2y$10$1bZMeCSlHg.RAZHXHIULsefnc6YogKzcgByJaRCw.seMJtur3gRi.','','','2','','1','081217657221','','','','2023-08-17 23:10:12','2023-08-17 23:10:12','');
INSERT INTO users VALUES('333','','','AF0009','dany.sitompul@timas.com','','$2y$10$W8tbvIGvShWpRZsrf0m03.3ZgAMNz9APcn8AGASZd3ZhVyR/11veG','','','2','','1','082137543713','','','','2023-08-17 23:10:12','2023-08-17 23:10:12','');
INSERT INTO users VALUES('334','','','AE03029','asd@gmail.com','','$2y$10$rTRgMxlFl01It48Lh99odeDixMX1Bvw/qIUJorDba2gTZ1l3A7E5K','','','2','','1','082280107578','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('335','','','AE00779','asd1@gmail.com','','$2y$10$rvH9RPEdlw1ek.wsYkuCle6IfG.Cax3ZY9leeZ7fVvG/2JxgZfSpW','','','2','','1','085363049624','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('336','','','AE02752','asd2@gmail.com','','$2y$10$zINWouInl/RC2p0JvhkwKupmrn1ssevpdRhvzL/jMF8zElb0jSTPm','','','2','','1','0','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('337','','','AE02769','asd3@gmail.com','','$2y$10$I21gMtRf9tdTJ8yp.qtsbOwBvJIOdeRZAkTU2TS7BhhxrJqsATDXS','','','2','','1','081272221353','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('338','','','AE02566','asd4@gmail.com','','$2y$10$C8YjevtJJ8OOJO36P27V1eTqj2OgvReVJi/szhrOnhcVZdFlmHQbu','','','2','','1','085349913025','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('339','','','AD00006','asd5@gmail.com','','$2y$10$bo7QQhL3YUuYfSesIYhVdu6PVnLZRipHMH2nyTAMWN2Kul8zG8Wta','','','2','','1','081296091501','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('340','','','AD00007','asd6@gmail.com','','$2y$10$uQlPcqvkF6T2Ryt6pq6fturf9fNXkmxhUihP2Qu/2nydXIPErkgtq','','','2','','1','081365253854','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('341','','','AD00008','asd7@gmail.com','','$2y$10$Snj83R8SlbMzn6JrPqOqeufCcd1yyX2FfVRq..YjH8AX5jQQXaV22','','','2','','1','082174107553','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('342','','','AD00030','asd8@gmail.com','','$2y$10$lNiuk7HCWGCstMW.T3sTnuuyqSGEv1rZ.DasLzIStryyvxpv2OIKq','','','2','','1','082169158099','','','','2023-08-17 23:12:05','2023-08-17 23:12:05','');
INSERT INTO users VALUES('343','','','AD00031','asd9@gmail.com','','$2y$10$rGh2PMntQkKzh5/pmctRauLd47p8Aognz.sq019CqSy4.y2jIJ6wC','','','2','','1','\'085271515545','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('344','','','AB00003','heri.irawan@timas.com ','','$2y$10$K6MSrF82HjoWn0QEhlWrz.JSzab8Z2hBzdhzzz5Wp1WFCj5J28y.u','','','2','','1','081385768634','103.113.77.126','2023-12-18 11:22:15.00','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('345','','','AB00007','franhidayat994@gmail.com','','$2y$10$4yDJGjuqTu68nzW3rifihOUVYfC/eCkRlc.XFsoE64utP3o7m1/la','','','2','','1','085959187871','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('346','','','AB00008','yenitazby@gmail.com','','$2y$10$h5iy9hTCab6jyJP/UloCieYoBFLzqId10VWLT1vchWAKp4RmC5OyK','','','2','','1','082117981448','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('347','','','AB00009','Sarwat aja43@gmail,com','','$2y$10$BTgHfI4r3JweShrijFMujOpzmxeEv7tbRolJto9lkhGuR/4AzoFm.','','','2','','1','082312953978','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('348','','','AB00010','indrawati101069@gmail.com','','$2y$10$PeI6SKW8QfmqCf6VPYH/e.c8EMlgbIzrk94fCTnnQ4TiUcCkGGPVK','','','2','','1','0895803204677','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('349','','','AA00152','adi.sutardi@timas.com','','$2y$10$vfUmUk1pqyqG6/Sr9Y4vSOrGfFKJR8T000ycVrHhRxgVtYQ0XTWLi','','','2','','1','087827757751','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('350','','','AA00153','nita.cynthia@timas.com','','$2y$10$Ngej44V.qNSzz/aOPOWbmeuBDLek5JdbzVhjkCLr3J3Yo3wAVfuYq','','','2','','1','087884247982','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('351','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$9Bf09IGwcLBnZJeWFOGkI.Y0XsNK2lbhP9kmbhLRvqA0NXevWy9TO','','','2','','1','085945207276','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('352','','','AA00155','mahfudin.nur@timas.com','','$2y$10$Za5pq2Lny35HsaKElipdmuV.KT9aUdx0dCeZSYvy84/N7qdH8.kd.','','','2','','1','0817382906','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('353','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$hqWbrGMe6ageu9xzP0Pd0.NHkLmk7Gi4pEB5IlHxeZBswjYno/RJ.','','','2','','1','081380806655','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('354','','','AF0005','wahyudin@timas.com ','','$2y$10$mrYl6lqmgV2WtMxX9gaPFuavAaagCaeud9Lgs1wBkCDPSepvHRd.6','','','2','','1','081364934014','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('355','','','AF0006','jimmer@timas.com','','$2y$10$Srwp6UTx3ncVwhrZs61fGuz/vlWq9rjTox3sLT67g2syyv5EkKdLO','','','2','','1','081231047970','','','','2023-08-17 23:12:06','2023-08-17 23:12:06','');
INSERT INTO users VALUES('356','','','AF0007','aulia.gandi@timas.com ','','$2y$10$2tx5Vy9eRjodzdh1cw8XsO4MQraQq5WCPgErG9tT9yHA7fx14uC.i','','','2','','1','081354168025','','','','2023-08-17 23:12:07','2023-08-17 23:12:07','');
INSERT INTO users VALUES('357','','','AF0008','adi.yulianto@timas.com','','$2y$10$vFd3r02qrVOyXSZgohACbeGVkXivCQOvk5SZr/.NeWkADgMB35M2W','','','2','','1','081217657221','','','','2023-08-17 23:12:07','2023-08-17 23:12:07','');
INSERT INTO users VALUES('358','','','AF0009','dany.sitompul@timas.com','','$2y$10$vqD0OEGQTxp5tNn1UbeDo.s3H2j6LFugVCCiH6Edsl2Uzw9LSLGLG','','','2','','1','082137543713','','','','2023-08-17 23:12:07','2023-08-17 23:12:07','');
INSERT INTO users VALUES('359','','','AE03029','asd@gmail.com','','$2y$10$ahHJV1qznWCR569bW/JMHOh6YMTD/Aw44fdhgP49CPOly3BNC1lUe','','','2','','1','082280107578','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('360','','','AE00779','asd1@gmail.com','','$2y$10$Hi9QDCoKIMEeq.ivfRRIxu5fFSxwV74v7L7kaZpygGVX69tirtxJi','','','2','','1','085363049624','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('361','','','AE02752','asd2@gmail.com','','$2y$10$iR6QXqQZOQE72yA8vHuVSu.EJ0PCqYVUelLZfEQlG6n.QiBdZUmVa','','','2','','1','0','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('362','','','AE02769','asd3@gmail.com','','$2y$10$NtAQQsjQIfyTuP.FA1XHW.Y3lZ7W9CpeXIQJ555jWqERo7nqyYXGq','','','2','','1','081272221353','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('363','','','AE02566','asd4@gmail.com','','$2y$10$SEKMG2tTpzA45mF2wYY4we18NrPksP8T0vY1UQIVswvC.pdYDmZS6','','','2','','1','085349913025','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('364','','','AD00006','asd5@gmail.com','','$2y$10$Bxrf72xfpl9SEnsYSi8Xr.jEaGTIJTeOT/IAFo3JEqCBqWlTzQAvS','','','2','','1','081296091501','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('365','','','AD00007','asd6@gmail.com','','$2y$10$KhTlIw3VlcQ.hIkrg5UxbOvvoMU/q1AprFgxwnxAQCj/BonbPfhOm','','','2','','1','081365253854','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('366','','','AD00008','asd7@gmail.com','','$2y$10$HQi47IZPxs46Q4.dWBOtOeL7UwexYXa6xG8jr6KzXIGKe20cCgEuC','','','2','','1','082174107553','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('367','','','AD00030','asd8@gmail.com','','$2y$10$6d.67KKm3RF0rEvv.7HMD.PUF8nSiHX056dOy2B54RCbXnZxKIZUC','','','2','','1','082169158099','','','','2023-08-17 23:14:28','2023-08-17 23:14:28','');
INSERT INTO users VALUES('368','','','AD00031','asd9@gmail.com','','$2y$10$qeJ66TrvG2l57tPywO6.4uF6dSEpgP3bL7/3sGKfNs7q3BWr1VM1a','','','2','','1','\'085271515545','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('369','Heri','Irawan','ab00003','heri.irawan@timas.com','','$2y$10$FxtkblBLjBuy6KsTbvp17enOdrcsN.UDpYi9EQz5rZueTpSN7dEk6','','','2','','1','081385768634','','','','2023-08-17 23:14:29','2023-08-18 11:11:41','');
INSERT INTO users VALUES('370','','','AB00007','franhidayat994@gmail.com','','$2y$10$4rXj9zflza/MswveQnAIVOqATYZ.XFu7J0QlgBOUujvYNKAmuFUE.','','','2','','1','085959187871','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('371','','','AB00008','yenitazby@gmail.com','','$2y$10$kbEa6tFBlHPv5mbrXetUhu1ms33oU5QjEPMKFyF3vLGqpqxvB7M7S','','','2','','1','082117981448','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('372','','','AB00009','Sarwat aja43@gmail,com','','$2y$10$Ypz0nmtHF2N7wGBWA//8Iet0IrD.QXugL8paVXXQ/3eGrNvVlJTba','','','2','','1','082312953978','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('373','','','AB00010','indrawati101069@gmail.com','','$2y$10$jlsf3o/qFLonbOkPrESOAOdPCqXRXSt2iqCnTD86qOeSTGwrq/P2K','','','2','','1','0895803204677','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('374','','','AA00152','adi.sutardi@timas.com','','$2y$10$pFZZJ5OvdGN1eyN1NRqLN.b9xzGzcLcu.saHgZmkRotFlkWbuVe6m','','','2','','1','087827757751','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('375','','','AA00153','nita.cynthia@timas.com','','$2y$10$AF5ZXrJyYs5FODw96fJBWe3e59iOMQA3oPdmgnzH5ZhjIBNvaC2W.','','','2','','1','087884247982','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('376','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$4r6f66Z58RZshiQ0/QzuE.dgkbk.SKJD9QRJFk7eYzX6YbpnNaJ/y','','','2','','1','085945207276','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('377','','','AA00155','mahfudin.nur@timas.com','','$2y$10$bcOpB7bAoa.dJjlZOoR1vOmfjQlRkFAIE7IZLvVZPKNTS1eueKCkm','','','2','','1','0817382906','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('378','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$CpkAN8R9XBsTdI5g1MV2TuxjjapPaXa0SucSzHBiMjcpE22otC442','','','2','','1','081380806655','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('379','','','AF0005','wahyudin@timas.com ','','$2y$10$FxwfKs7fvqJjaXoYwJue7.gzKsCujsyXNXBYcFvl878kdlm/AbfUq','','','2','','1','081364934014','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('380','','','AF0006','jimmer@timas.com','','$2y$10$fiqB5U15ZIJgV1poQkop3.Xze5m7sYde.VznXoU4hCuXTqT9Xyt9a','','','2','','1','081231047970','','','','2023-08-17 23:14:29','2023-08-17 23:14:29','');
INSERT INTO users VALUES('381','','','AF0007','aulia.gandi@timas.com ','','$2y$10$HsX8BAH7L0FzTHwm/ekdKuhCebq4LJ0Gd1nsgiaUA0aSN4VYSeDo2','','','2','','1','081354168025','','','','2023-08-17 23:14:30','2023-08-17 23:14:30','');
INSERT INTO users VALUES('382','','','AF0008','adi.yulianto@timas.com','','$2y$10$cRs8TGe9KqbT.cJtJb62F.7kFZTdFYedK9cHvKknKsxSwatdNJjC.','','','2','','1','081217657221','','','','2023-08-17 23:14:30','2023-08-17 23:14:30','');
INSERT INTO users VALUES('383','','','AF0009','dany.sitompul@timas.com','','$2y$10$4r3YWsmfpAb11X9LvsDog.fOLxBsuhG4sX4Vqwm0j4CYxOyltbWpe','','','2','','1','082137543713','','','','2023-08-17 23:14:30','2023-08-17 23:14:30','');
INSERT INTO users VALUES('384','','','AE03029','asd@gmail.com','','$2y$10$cvgMr2WrWXj7tA1SWMROxeFdfqxtFDyjZuqKascYDLIkl9VcRQZay','','','2','','1','082280107578','','','','2023-08-17 23:15:51','2023-08-17 23:15:51','');
INSERT INTO users VALUES('385','','','AE00779','asd1@gmail.com','','$2y$10$1E9j0NOdpa0Ar2tj6lSiPepEUCMcZ2HcC/Iac22NtJgq8find3Og6','','','2','','1','085363049624','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('386','','','AE02752','asd2@gmail.com','','$2y$10$X5gRaw1W7MQYhkEMncWuLO2EpgHN8743ZAgCfGQx3xaV4VdpF1XY2','','','2','','1','0','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('387','','','AE02769','asd3@gmail.com','','$2y$10$UMIgvXCQXiwucYqmk7J6suKUkUIKeK.7gOOcaXsWM3Pm7XfxZFfU.','','','2','','1','081272221353','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('388','','','AE02566','asd4@gmail.com','','$2y$10$.83pKmgh3iGeK.C2b2qEVuRaIMFOJt1E1RKDNm7PWjlBQmZeTxsMW','','','2','','1','085349913025','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('389','','','AD00006','asd5@gmail.com','','$2y$10$ZXdUbOe3O7aHeZ2PqzMzsenGYTltVLNuUpdQyEwaV9w7p1u2zHZo2','','','2','','1','081296091501','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('390','','','AD00007','asd6@gmail.com','','$2y$10$3mAiKDxRGPgMYrbmc/.W9OlzpVBJ.oGO.KTm7JqJAthCKL67maEy2','','','2','','1','081365253854','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('391','','','AD00008','asd7@gmail.com','','$2y$10$aPAWN4jz82TM5vUvgmfz7.9NMpuAc..BX5QTB7hGIaDP4DTSJceDO','','','2','','1','082174107553','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('392','','','AD00030','asd8@gmail.com','','$2y$10$.XbTZ4V.S2DkL/vvw0RypesP7s9fi359uy9bItvj6g3guFInTJPlO','','','2','','1','082169158099','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('393','','','AD00031','asd9@gmail.com','','$2y$10$YksWLxHUqm4cTaJT9uWM..M9hWtcmajS0YqliiegPJLa6SVv6K9VW','','','2','','1','\'085271515545','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('394','','','AB00003','heri.irawan@timas.com ','','$2y$10$fkzIyJ6e.VtwkhPQDJflfedSbHGzNtRmcnUjncILEZkF8ARaqw9nG','','','2','','1','081385768634','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('395','','','AB00007','franhidayat994@gmail.com','','$2y$10$jHaiFvbthXbJyyqMghk3qOewG6coRF5umrccbEV.jrWod1LuhJaGG','','','2','','1','085959187871','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('396','','','AB00008','yenitazby@gmail.com','','$2y$10$LvB5Xqcc3El.68dcCM.uteOJNu4C.4JhAZTJDFgOECadgFIDfGu8u','','','2','','1','082117981448','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('397','','','AB00009','Sarwat aja43@gmail,com','','$2y$10$3omFWmDh0o.2gJ06jtL2zOdWCs4wxmE892Wi0.HJG3jKZ62bTF/s2','','','2','','1','082312953978','','','','2023-08-17 23:15:52','2023-08-17 23:15:52','');
INSERT INTO users VALUES('398','','','AB00010','indrawati101069@gmail.com','','$2y$10$VIw6YwAvD3ORtH3iN2mu3OmlZ9CwJy5v1w26qn70qBi2dyKBgBFbi','','','2','','1','0895803204677','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('399','','','AA00152','adi.sutardi@timas.com','','$2y$10$UOIpIY.mT8KPvEsHCUaR6ulPq67a98rj8U106Up4MREgrn7tFY8yi','','','2','','1','087827757751','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('400','','','AA00153','nita.cynthia@timas.com','','$2y$10$HZtCtCuhIWRFBx4Ql9iEHO5KUibGItv/EItSdGhIX37rDfGQgD3nO','','','2','','1','087884247982','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('401','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$rNy5LNUHApZsPPYrGWg4tO8zPZDTR.4YpRiE94GyVvlqikpdeHWpm','','','2','','1','085945207276','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('402','','','AA00155','mahfudin.nur@timas.com','','$2y$10$hj9K2hixN5ChTlCRYXQmh.Leyymq3c3jXejZnRNvEXygmV2lAfeEi','','','2','','1','0817382906','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('403','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$twq3N6d8eyj5hCKwcUlWD.DXVS6m19mCYffzyfuHvqYsT4gLMec8u','','','2','','1','081380806655','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('404','','','AF0005','wahyudin@timas.com ','','$2y$10$MGSF2VSDrvvptgqLg58lpObG2VcGO1aQnVR3erWLRPGAv7ECYUOgq','','','2','','1','081364934014','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('405','','','AF0006','jimmer@timas.com','','$2y$10$/KhcMNUDzeISA3DYKM9Q6.oo/9dbCDpGapAAG03dRkv/X5mC6AnA.','','','2','','1','081231047970','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('406','','','AF0007','aulia.gandi@timas.com ','','$2y$10$5YzXWo3y2cqNWRKi9UC7vOVEfGnylmVXxEZ7FZwhACTutmMp4deJG','','','2','','1','081354168025','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('407','','','AF0008','adi.yulianto@timas.com','','$2y$10$WjVpNkszMZqp9tcd6rfhCOvlZqOi/zWIsZBDrPBLbt7BCUkbdvcES','','','2','','1','081217657221','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('408','','','AF0009','dany.sitompul@timas.com','','$2y$10$xhz.0bO5ewD80kzgVMqeQ.r2K4kCMXXyuzOvaC2Aeon/RHgvLHavO','','','2','','1','082137543713','','','','2023-08-17 23:15:53','2023-08-17 23:15:53','');
INSERT INTO users VALUES('410','','','testusername','test007@gmail.com','','$2y$10$U572g7earzb2vnjwNcfBHeNjuM1zTmJ7HoYs3GfXYfCU1yDoePQGq','','','2','','1','4536267','','','','2023-08-17 23:19:22','2023-08-17 23:19:22','');
INSERT INTO users VALUES('411','','','AE03029','asd@gmail.com','','$2y$10$VvA59ebSL2KnM5Fg0lMZQu961OfUiztM5FZHY.QptIQQnt/XbRe/G','','','2','','1','675728954','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('412','','','AE00779','asd1@gmail.com','','$2y$10$Lg1nNj5.tJ.b6pFicxqhvOkm7GdkbbnwekFC0noNWJo4y4vFEPiuq','','','2','','1','-536296296','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('413','','','AE02752','asd2@gmail.com','','$2y$10$4LiiUuyBHVrwoxo4IxVxrOLJL.iFnfUcgpY.YYyHn3BUtCyLdMwEu','','','2','','1','0','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('414','','','AE02769','asd3@gmail.com','','$2y$10$E.Lf.29ZsceMtRmhYN9t/.3592wP1mz.X1SJhyp4otJq0lWU3dYPi','','','2','','1','-332157271','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('415','','','AE02566','asd4@gmail.com','','$2y$10$41AqPGUvQOBZnTFhid7e3uidJoFIhd/cbcklpAMI01HvIAlYv3naG','','','2','','1','-549432895','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('416','','','AD00006','asd5@gmail.com','','$2y$10$EnFCwp4VeRZlXuHWq88wSOWm2JSnkYJfqHEl3AjApLO1/pQsIFC4u','','','2','','1','-308287123','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('417','','','AD00007','asd6@gmail.com','','$2y$10$7PZLBZRbNSN.4kVWqv6Wo.2SyRXzcwQ87arJnyw/70LmKCGwI5OBO','','','2','','1','-239124770','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('418','','','AD00008','asd7@gmail.com','','$2y$10$bZADehmywU0K2xT0s4ntB.p.13EZ/JlbdEvEvF9Vhd7t0eGN2K3Ua','','','2','','1','569728929','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('419','','','AD00030','asd8@gmail.com','','$2y$10$qylrc9Hya1054BDuwLClIOr8BWry2Y0IM//25BWHHB/tkquvJ8FS2','','','2','','1','564779475','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('420','','','AD00031','asd9@gmail.com','','$2y$10$.5pPSywaPxnja1ZGviAkk.1J3AeRxs5sI0EYJw6jV/bJ6O/DMYlFm','','','2','','1','\'085271515545','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('421','','','AB00003','heri.irawan@timas.com','','$2y$10$ddxgA.HGX4Kf.35F5WOHk.aaUctyJBPuvp3Z/8VY5ic1tjcLAwK6a','','','2','','1','-218609990','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('422','','','AB00007','franhidayat994@gmail.com','','$2y$10$xSBUQTXBKMgUNnohNFhCGe4eKZkwKKM5Q/FiLNBIGFGCA47HEFaGy','','','2','','1','59841951','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('423','','','AB00008','yenitazby@gmail.com','','$2y$10$zADFU8n85pzMEyhZOW.HK.qUdLpHcvvbVihuws5GmsZKM57cF4KVe','','','2','','1','513602824','','','','2023-08-17 23:19:23','2023-08-17 23:19:23','');
INSERT INTO users VALUES('424','','','AB00009','Sarwat aja43@gmail,com','','$2y$10$WZz6IMPcJivx9PolQm.waOZHt.04gYsMk.C3OT/OFMGv3q/aAazIe','','','2','','1','708575354','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('425','','','AB00010','indrawati101069@gmail.com','','$2y$10$0/YA260ZMPi76nbA6lakLuZHsEvSmiLa8RVY99mJsBj6jQpn7DisW','','','2','','1','-1844960187','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('426','','','AA00152','adi.sutardi@timas.com','','$2y$10$Q8VLLNdUDinvbGrZMjJNE.Cdwqeile0i1f09uz9wA9W/JkLq0Kas.','','','2','','1','1928411831','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('427','','','AA00153','nita.cynthia@timas.com','','$2y$10$D3DdhHkJ5UpOipl97l02IegBOd4qkxhyhWeLiKOGFsa9SU5eWgpS6','','','2','','1','1984902062','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('428','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$t/VT436WhXqK0mv7CNU1re/TzQ/i2nyk8VH3BfCoUzcfkjyFCpoDW','','','2','','1','45861356','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('429','','','AA00155','mahfudin.nur@timas.com','','$2y$10$MAzw9EMIcT2sOx5Q3QCeE.AEtlbiEP6R8gcmjEg9MQHrtp0qkRraK','','','2','','1','817382906','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('430','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$/6/9nzVIWh2vgGLLpDs7ouubjCDibTb8ZHniU1sm8uHLzKrPH9CyK','','','2','','1','-223571969','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('431','','','AF0005','wahyudin@timas.com','','$2y$10$Tz/24jS4BMngNM5Smi380.q/WXXhAdtnXWsTOJEzm7pR7GDPeQCJK','','','2','','1','-239444610','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('432','','','AF0006','jimmer@timas.com','','$2y$10$c0NEgs0hlhtAKTA4yYdQV.r41lziPW94F41d9K8dF7naXfk1mAsO.','','','2','','1','-373330654','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('433','','','AF0007','aulia.gandi@timas.com','','$2y$10$TWR7AkDwm3MSzXT/ufTs7.ae8CtD.0tULRvo/ptWQX41exmrmpkmG','','','2','','1','-250210599','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('434','','','AF0008','adi.yulianto@timas.com','','$2y$10$fRJocuou0Y8ylbgoBLJSk.VUtwhod.1/bGB04MWgsY/klBhzPj7ye','','','2','','1','-386721403','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('435','','','AF0009','dany.sitompul@timas.com','','$2y$10$.3lu3CEWowb.sKupMXNT7uBubBRMZA6rvPh/KoDZ2xJ/lrcf4apum','','','2','','1','533165089','','','','2023-08-17 23:19:24','2023-08-17 23:19:24','');
INSERT INTO users VALUES('438','Faleides','Pereira','ad3032','lulu.faleidas@timas.com','','$2y$10$Dgm8CBQa2ETv4CFtTlSs5eIivBZR6iqBusKLuZNhl5RD48rpPno8a','','','2','','1','085310424558','','','','2023-08-18 11:31:14','2023-08-18 11:31:14','');
INSERT INTO users VALUES('439','Daniel','Amaya','ag3033','daniel.amaya@timas.com','','$2y$10$YRpVvUmHOixCwGQvxut5teRwY/Fk.A5nrVk9kxEa/qdxy0rCFRA4.','','','2','','1','081122334455','','','','2023-08-18 11:39:58','2023-08-18 11:39:58','');
INSERT INTO users VALUES('440','Tristanto','TRISTANTO','aa3032','','','$2y$10$Qja0SfmAeZjoINaKGyhn5O7/.fBSopV.ds1HiT.UUkKSrNpadpMqG','','','6','','1','081213308381','103.113.77.126','2023-09-04 09:44:16.00','','2023-08-21 14:38:45','2023-08-23 05:28:50','');
INSERT INTO users VALUES('441','Tristanto','TRISTANTO','aa3032','','','$2y$10$TS.RQiFxYvIGWRL0ulShceNcxfZ8QY2I0BMoXqI/Q7.frx9YiQv9u','','','6','','1','081213308381','','','','2023-08-21 14:38:50','2023-08-21 14:38:50','');
INSERT INTO users VALUES('442','Tristanto','TRISTANTO','aa3032','','','$2y$10$BIUSLVxWqvlIiNU39M14eeKYWFr9cxQU3v4Bx4MM90pEG7yarU/li','','','6','','1','081213308381','','','','2023-08-21 14:39:03','2023-08-21 14:39:03','');
INSERT INTO users VALUES('443','Tristanto','TRISTANTO','aa3032','','','$2y$10$lomxOrAfQ4zrTImovKeTQenogcXyOTyH.LDfj2cXxZCawBkZEeGS2','','','6','','1','081213308381','','','','2023-08-21 14:39:07','2023-08-21 14:39:07','');
INSERT INTO users VALUES('444','Tristanto','TRISTANTO','aa3032','','','$2y$10$ckfiUz1VGM1svWKePFxSx.4kEV6siH1zxYaaxEdJk40ghd8SHA/pu','','','6','','1','081213308381','','','','2023-08-21 14:39:08','2023-08-21 14:39:08','');
INSERT INTO users VALUES('445','Tristanto','TRISTANTO','aa3032','','','$2y$10$Ln0AF.CUnWDeK4GyaYhqK.kqMeB4ryP9tVzzF6tWvdnH.2jMaHWc6','','','6','','1','081213308381','','','','2023-08-21 14:39:08','2023-08-21 14:39:08','');
INSERT INTO users VALUES('446','MERY YULITHA','RAFAEL','aa3033','','','$2y$10$ArPR5LGnzzYZVYAYOL92Ou/V7vYm5pDtJqGOrOUvxuKE7BGmMkKta','','','4','','1','081280003889','103.113.77.126','2023-09-04 10:34:48.00','','2023-08-21 14:50:56','2023-08-22 17:42:35','');
INSERT INTO users VALUES('447','LIANAWATI','GUNAWAN','aa3034','lianawati.gunawan@timas.com','','$2y$10$UObVwz4YPEgSB.BUTl.nGOBBc0frCw9PKIUll.m/HshcW5NNO4g5S','','','2','','1','0817170800','202.169.50.228','2023-08-23 10:06:20.00','','2023-08-21 14:56:29','2023-08-21 14:56:29','');
INSERT INTO users VALUES('448','CAHYONO','CAHYONO','aa3035','cahyono@timas.com','','$2y$10$0ScCX3zY2lLi3/SylDe.YuiUpK4uKY9KvWDKllX0Gn29H3MvWN35i','','','2','','1','081316738896','103.113.77.126','2023-10-24 11:33:12.00','','2023-08-21 15:00:15','2023-08-21 15:00:15','');
INSERT INTO users VALUES('449','Ahmad','Rifai','aa3035','ahmad.rifai@timas.com','','$2y$10$V9caZS0XkgxHQVNxE1G3JOH94k5PJV1bUukcDmZ.rPx29KHLHFQ..','','','2','','1','085882918919','','','','2023-08-21 15:00:47','2023-08-21 15:00:47','');
INSERT INTO users VALUES('450','LILIANY','VERISTIANNY','aa3036','','','$2y$10$sikAL.xTCuqupQj8NzhLaucCgdYaX6acRVPOV2gankH1YF8v5aa/S','','','2','','1','08128026989','','','','2023-08-21 15:05:33','2023-08-21 15:05:33','');
INSERT INTO users VALUES('451','Yudi','Prasetyo','aa3036','yudi.prasetyo@timas.com','','$2y$10$CQHhfgYM1DaISuxV7UIcFuoVELVssx/rBwe10H2Phhmdf1EbEy8hm','','','2','','1','0896-1464-8126','','','','2023-08-21 15:06:39','2023-08-21 15:06:39','');
INSERT INTO users VALUES('452','SAIDIN','SAIDIN','aa3037','','','$2y$10$jeIOk.i7Wn/vl29TvDv8yesrFVRBEAgpqCfExksAGHTj6CUhM/JeW','','','2','','1','081282908558','','','','2023-08-21 15:10:58','2023-08-21 15:10:58','');
INSERT INTO users VALUES('453','Ahmad','Rifai','aa3038','ahmad.rifai@timas.com','','$2y$10$t3XOjRgLklIxBLxpq2uuK.J6NZk5/DC1fNMyZl/GDG1ZhaPOS1gty','','','2','','1','0858-8291-8919','','','','2023-08-21 15:13:31','2023-08-21 15:13:31','');
INSERT INTO users VALUES('454','Yudi','Prasetyo','aa3039','yudi.prasetyo@timas.com','','$2y$10$kYBarbMYcr53q5nw89kzsOvbILSNsAWJWg5Bu0IXoCjjnwOYIa5Pu','','','2','','1','0896-1464-8126','','','','2023-08-21 15:23:13','2023-08-21 15:23:13','');
INSERT INTO users VALUES('455','Yudi','Prasetyo','aa3039','yudi.prasetyo@timas.com','','$2y$10$n36h6oasvy/WZ4TeNN6YL.9Qk7sPigrsxFQE21Jnun7qortTRHo/q','','','2','','1','0896-1464-8126','','','','2023-08-21 15:23:28','2023-08-21 15:23:28','');
INSERT INTO users VALUES('456','MUHLIS','MUHLIS','aa3040','','','$2y$10$Nh8W2FkW1S5Ym5Mhl6.LheONXz5cSrO1X1J16UiC.Ok/tXUOBVYFK','','','2','','1','0852-6745-2855','','','','2023-08-21 15:25:55','2023-08-21 15:25:55','');
INSERT INTO users VALUES('457','Ritci','Ritci','aa3041','ritchi.arie@timas.com','','$2y$10$R39ntotCgtCevG9yk4n/4eq3IOia/ldtnpzX/vNyJyqZpNJN8Pzp6','','','2','','1','0812-8001-5590','','','','2023-08-21 15:29:19','2023-08-21 15:29:19','');
INSERT INTO users VALUES('458','PRANADA','SIMANJUNTAK','aa3042','','','$2y$10$iWwEUOlBfcirgdzQaMvCke/V2bqEx9VQcUgrAkkNUdvGr53JW3J8G','','','2','','1','0852-7135-0358','','','','2023-08-21 15:33:56','2023-08-21 18:50:04','');
INSERT INTO users VALUES('459','Sarifudin','Sarifudin','aa3043','sarifudin@timas.com','','$2y$10$.pVe7wVbSqRWWpqe6CLLDeFRXAP2Fxxb.anJB5FM5z7Ea8ZW08p4O','','','2','','1','0819-1104-2777','','','','2023-08-21 15:43:40','2023-08-21 15:43:40','');
INSERT INTO users VALUES('460','JUMALI','JUMALI','aa3043','','','$2y$10$eSTNkYrZgHrSo0.frNICPOYMokYvkIvggV7J0RIeTGoQn3sP8XtDa','','','2','','1','0853-3235-1166','','','','2023-08-21 15:48:47','2023-08-21 15:48:47','');
INSERT INTO users VALUES('461','Nurziha','Laila','aa3044','nurziha.laila@timas.com','','$2y$10$0tAcYBp7/Ddm2qoOG1ddW.2Ency3bzQ4se18ppcDXTtFzr8NQUaCG','','','2','','1','0813-8950-4887','','','','2023-08-21 15:52:29','2023-08-21 15:52:29','');
INSERT INTO users VALUES('462','Nurziha','Laila','aa3044','nurziha.laila@timas.com','','$2y$10$jKPgXHP8sr94uHu2kyxosuU1LK/FNsBRI/JCA0p6LrnsRoyOKGLy2','','','2','','1','0813-8950-4887','','','','2023-08-21 15:54:06','2023-08-21 15:54:06','');
INSERT INTO users VALUES('464','Sulistyo','Indarto','aa3046','sulistyo.indarto@timas.com','','$2y$10$wijKbQbe41apdLoj.xJXTeawSr/0.mNJKpZL6WsZZmOF0PWYY/IfC','','','2','','1','0812-9413-3838','','','','2023-08-21 16:02:44','2023-08-21 16:02:44','');
INSERT INTO users VALUES('465','Edward','Austa','aa3047','edward.austa@timas.com','','$2y$10$YQlnWllwJ1Tdj9Lv.GbzJuFWvw9H6.R4.TrQLoTvBDJnZ2Prb3VZ2','','','2','','1','0813-6214-6495','','','','2023-08-21 16:05:04','2023-08-21 16:05:04','');
INSERT INTO users VALUES('466','Bambang','Paijo','aa3048','','','$2y$10$IOsb1AzJA2iBCbEUkK020uaItYxzb7E3pkrAWT9Z1zHeNZsUcWOy2','','','2','','1','0838-9277-0953','','','','2023-08-21 16:07:28','2023-08-21 16:07:28','');
INSERT INTO users VALUES('467','Eksa','Pratama','aa3049','','','$2y$10$vHCpgr6duqvbDw6ObDxLX.o8prImnW9oUvcZuNWzp6WUoqbdZIONG','','','2','','1','0823-1118-7978','','','','2023-08-21 16:13:27','2023-08-21 16:13:27','');
INSERT INTO users VALUES('470','Amimi','Amimi','aa3050','','','$2y$10$2YLVJ2KM/VD1DgsHnra3QOLgg74WdxiNYhUFubwOaiB9Qo/FYzWLO','','','2','','1','0838-3175-3507','','','','2023-08-21 16:18:24','2023-08-21 16:18:24','');
INSERT INTO users VALUES('471','Ramadhani Putra','Dewanto','aa3051','','','$2y$10$jGJnYZtJgnYD69XXNWvyY.aDlZQdOeUphdXbk6THaPIeh6HAKqgIq','','','2','','1','08112233445','','','','2023-08-21 16:44:41','2023-08-21 16:44:41','');
INSERT INTO users VALUES('472','Djamintas','Simbolon','aa3052','','','$2y$10$f.iSe7CM2dAeGQsYzmrW1ulcSks3uNAxZhHqDQSmxxBJykjgWnsFO','','','2','','1','0813112233344','','','','2023-08-21 16:49:33','2023-08-21 16:49:33','');
INSERT INTO users VALUES('473','BUDI RUBIYANTO','SUMARNO','aa3053','','','$2y$10$P5RBKi.KqsPX8iBJwwdK6uvNfhK161BBoN4knGOZXr/HCMzPkOzCS','','','2','','1','08782324242424','','','','2023-08-21 16:55:31','2023-08-21 16:55:31','');
INSERT INTO users VALUES('474','RENNI SEPTI','WULANDARI','aa3054','','','$2y$10$lTlMhJmE1PVEB.1WlKqUwOi8zM6BXAbmKoo.s47Ty2.e2uD067Vre','','','2','','1','081314151617','','','','2023-08-21 17:00:23','2023-08-21 17:00:23','');
INSERT INTO users VALUES('475','HARRY','SYAUKANI','aa3055','','','$2y$10$cYZDwWcnJLRgMzTsWRdrQeFMqWfoVM5XTuettfO02WhK6HjvzrAea','','','2','','1','081212131313','','','','2023-08-21 17:06:35','2023-08-21 20:22:11','');
INSERT INTO users VALUES('476','ELYASTA WINANTA','PUTRA','aa3056','','','$2y$10$h5UlNWN/WFWICTZiQrRD..HvfaFrovsb/WUJxmyMrYNn9EsiU1ITy','','','2','','1','085657585960','','','','2023-08-21 17:10:33','2023-08-21 17:10:33','');
INSERT INTO users VALUES('477','DHANI FAYUMI','ASYHAR','aa3057','','','$2y$10$yty1ILZaTQToGglq3TyzeezLXSMXuuqTlu6Qtgt3sElnUDEHpXB2O','','','2','','1','081199887766','','','','2023-08-21 17:14:31','2023-08-21 17:14:31','');
INSERT INTO users VALUES('478','ALFINA IDELIA DOLOK','SARIBU','aa3058','','','$2y$10$DbqSIC8D7h1CgVYZbSHm.OpfwveMM5ZLEzG9xp17k6s863NkWBX.e','','','2','','1','0896979899100','','','','2023-08-21 17:18:17','2023-08-21 17:18:17','');
INSERT INTO users VALUES('479','','','AE03029','asd@gmail.com','','$2y$10$JJ6zJXfnnBx6tHyi8c6qiuvaXj6rganDJoOhBs5tMM1TUrLx9UwFW','','','2','','','082280107578','','','','2023-08-21 20:29:06','2023-08-21 20:29:06','');
INSERT INTO users VALUES('490','','','AB00007','franhidayat994@gmail.com','','$2y$10$S1EJPDxcnQ9XU6R7dGDKbu9aIVo0PGAFfKo0YkYIegNrzrKYvui42','','','2','','','085959187871','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('491','','','AB00008','yenitazby@gmail.com','','$2y$10$wEJNboR8fmOD27eD1ybi8OYDlWR6P1Pgq0dI2Ix61nrgeEK75kJNy','','','2','','','082117981448','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('492','','','AB00009','Sarwat aja43@gmail,com','','$2y$10$hBsnAgPE2hIsXJYcTLqRRec4MApPbY0mkzy5fUpH7eJ3x4OMf3c5a','','','2','','','082312953978','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('493','','','AB00010','indrawati101069@gmail.com','','$2y$10$JHf9tMjNWh5yzgDsjQt1D.bjUrW8wIUpWBB/ooKVGoCSF66tlpnSi','','','2','','','0895803204677','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('494','','','AA00152','adi.sutardi@timas.com','','$2y$10$AYY3z/MjftWPqH3x8V570OkZWxP4gz9O54gck96vyv1tzafKgn5q6','','','2','','','087827757751','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('495','','','AA00153','nita.cynthia@timas.com','','$2y$10$aL.YkRTZ3EWF.vsw/P/cFe/y6LflB5j05sQOP7wGhC3uNFsPf.Arm','','','2','','','087884247982','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('496','','','AA00154','robinur.alamsyah@timas.com','','$2y$10$jo3r0hGOb9l4B4T0eEvi0OkwTUDXvsUP8tfaYM/epGZaj.kXoL.kW','','','2','','','085945207276','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('497','','','AA00155','mahfudin.nur@timas.com','','$2y$10$55cfmmzWiNu6hPiIxRQkiejxXZ1G94GNhm4qoH9ghAMMm89tmhfXK','','','2','','','0817382906','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('498','','','AA00156','sigit.pamungkas@timas.com','','$2y$10$1SUmCw7xQGAEmThM2w2kRON1yY0mBj2EvXFyiqABUioBfx5HP0nMm','','','2','','','081380806655','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('499','','','AF0005','wahyudin@timas.com ','','$2y$10$5IwvRYJZLsPlMGnfE/9SDuG2Hi3znw7jJNWi9ErhH5BP46L0Iiw4y','','','2','','','081364934014','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('500','','','AF0006','jimmer@timas.com','','$2y$10$m3rPA28PxV0Z3iEPrRKYA.4wrV5ehf5kPqgbhUU8kgbmQ9hAlvpSO','','','2','','','081231047970','','','','2023-08-21 20:29:07','2023-08-21 20:29:07','');
INSERT INTO users VALUES('501','Aulia Gandi','Wahono','af0007','aulia.gandi@timas.com','','$2y$10$OzB/2rUW6gI8Z3jeIqL39ePby7.3UElyLaBS8gfQIlAr2XZ4ax2.6','','','2','','1','081354168025','','','','2023-08-21 20:29:07','2023-08-23 09:01:34','');
INSERT INTO users VALUES('502','','','AF0008','adi.yulianto@timas.com','','$2y$10$uWS6yVUlUdbJqAbFakt8BOm3L1/vCP7lPItGl1A3ulXbWIRZJdP/m','','','2','','','081217657221','','','','2023-08-21 20:29:08','2023-08-21 20:29:08','');
INSERT INTO users VALUES('503','Dany Sanjaya','Sitompul','af0009','dany.sitompul@timas.com','','$2y$10$1oRse/DUax8TOHsSvdjbnOqlpZj.C3sT4xVcyGrWGe5SKH8nfpPbO','','','2','','1','082137543713','','','','2023-08-21 20:29:08','2023-08-22 09:04:39','');
INSERT INTO users VALUES('504','Erna','Widiastuti','aa3059','','','$2y$10$Cl8NJfREBbmi9qzk.E.NLurMXSFDxUQ7Fkra4wIchmSPw10o754g2','','','2','','1','0813-8982-7202','','','','2023-08-22 08:42:23','2023-08-22 08:42:23','');
INSERT INTO users VALUES('505','Riswandi','Riswandi','aa3060','','','$2y$10$4pntnKANjV9ialQpt198AuJHFsUc3Sn8Sz638Pldv34btsG6j0W6C','','','2','','1','0813-1993-1982','','','','2023-08-22 08:46:28','2023-08-22 08:46:28','');
INSERT INTO users VALUES('506','Didin','Supidin','aa3061','','','$2y$10$9fLb84b4s0yScdrbiiKrMeLH6GZiMLQC6HHWVQ0MaGgZP/edZdnqu','','','2','','1','081918171615','','','','2023-08-22 08:50:19','2023-08-22 08:50:19','');
INSERT INTO users VALUES('507','Aep','Saepuloh','aa3062','','','$2y$10$6kSqcE4UR67AbejLLnW6T.Pebi3.I6kdvSCRuPpsGL74J2KkVGF22','','','2','','1','0813121098765','','','','2023-08-22 08:52:45','2023-08-22 08:52:45','');
INSERT INTO users VALUES('508','Yanti','Yanti','aa3063','','','$2y$10$EefwhhkxO8zLJMVlapp37Oye98PrApHDUhVrKUPzohQCTZ3Q.945W','','','2','','1','081311571739','','','','2023-08-22 08:58:07','2023-08-22 08:58:07','');
INSERT INTO users VALUES('509','Agus San','Alwi','aa3064','','','$2y$10$rzOmsmGgTkJLdxx9XKYP3OZ2xg0VdmL12gL0lyv2Kp/Q8exPcHWha','','','2','','1','0815-1441-7416','','','','2023-08-22 09:12:57','2023-08-22 09:12:57','');
INSERT INTO users VALUES('510','Eka','Fitriasari','aa3065','','','$2y$10$oz5NIhne2QdqxXyvbUS7juBgYaLwS9RA4q4X6DKwdMn9npVvf.u6C','','','2','','1','0877-7091-2922','','','','2023-08-22 09:18:46','2023-08-22 09:18:46','');
INSERT INTO users VALUES('511','ISRO','MIROJ','aa3066','','','$2y$10$dz/Kzkq9nafHcq73ZwEmdOdMqMl0yVABEnA53JMcXsWS3i.u7AmPi','','','2','','1','0818-0772-7240','','','','2023-08-22 09:27:11','2023-08-22 09:27:11','');
INSERT INTO users VALUES('512','Denny','Ronald','aa3067','','','$2y$10$2CPOPUDcC07BNnOtiSeOnOX2CKpFs9InQkPPczJpyez9960lShKQO','','','2','','1','08595959595959','','','','2023-08-22 09:33:19','2023-08-22 09:33:19','');
INSERT INTO users VALUES('519','Roy','Rendra','aa3074','','','$2y$10$imZTtsCVV5d8Oykj5yKQLuird3A4MfWAmj3PauM.HX9nvFkkoNque','','','2','','1','0817-714-615','','','','2023-08-22 10:09:14','2023-08-22 10:09:14','');
INSERT INTO users VALUES('520','VALENTINA ','EVANI','AA00059','valentina.evani@timas.com','','$2y$10$X6aU8colIDwdSADovRKn6.htIqVvEvfT.uEnTlZzM/UgGayU3mAIW','','','2','','','085771527008','','','','2023-08-22 10:44:39','2023-08-22 10:44:39','');
INSERT INTO users VALUES('521','MOCH','RUSWANDI ','AA00067','moch.ruswandi@timas.com','','$2y$10$JyclGyF4t9jpqFi8tCsG6eFtE6yNTJEnFSKzgrIC70mz.f/ea1NZ6','','','2','','','081383337805','','','','2023-08-22 10:44:39','2023-08-22 10:44:39','');
INSERT INTO users VALUES('525','NAWIN','NAWIN','aa3075','','','$2y$10$KbtpdCXM/Z6K72eeAZQOaut0d2lUEAUL/zskruCMSXiAvV2gqQfmW','','','2','','1','085716782136','','','','2023-08-23 05:01:22','2023-08-23 05:01:22','');
INSERT INTO users VALUES('526','SONNY','HARI MUKTI','aa3076','sonny.hari@timas.com','','$2y$10$iR2EXLCdPHFyw4SEH1p4OucdNIRDFr17sohR8sMGB9GuFiNa4WWci','','','2','','1','081233445566','','','','2023-09-11 08:54:00','2023-09-11 08:54:00','');
INSERT INTO users VALUES('529','DEDE','ROHAYAH','aa00075','dede.rohayah@timas.com','','$2y$10$uyaV8Ri9Y9ieQo9YzbXgYOmTE6RkW5g1Ky3vN72MApqxBfJ5MD6Iq','','','2','','1','083876767760','202.169.50.228','2023-09-11 10:24:04.00','','2023-09-11 08:58:39','2023-12-06 10:36:17','');
INSERT INTO users VALUES('530','SENNY AGUS','WIDIYANTI','AA00074','senny.agus@timas.com','','$2y$10$aSm1OeY4VQqVkCV3p/Ktj.bNNg/C6pJIUvVQqpjliPEzqzJVHnKSe','','','2','','1','081212131314','','','','2023-09-11 08:58:39','2023-09-11 08:58:39','');
INSERT INTO users VALUES('531','OKTA JULIANT DWI','SANGAJI','AA00076','okta.juliant@timas.com','','$2y$10$uF0qasKervc2wmI3allh6uPWm21flsTmOCTe5cDfP.hh1EGx9gGFS','','','2','','1','089797979797','','','','2023-09-11 08:58:39','2023-09-11 08:58:39','');
INSERT INTO users VALUES('532','AGUS ','PUJIONO','AA00077','agus.puijono@timas.com','','$2y$10$DaZuKZRvKxsB7q203tQz6O4A96SwYa23hRpLd79I5S0heyDd41iDS','','','2','','1','081313121212','','','','2023-09-11 08:58:39','2023-09-11 08:58:39','');
INSERT INTO users VALUES('533','TAYA ','MINANTI ','AA00078','taya.minanti@timas.com','','$2y$10$OTTGmcUUY9MRxg6LQDVso.qxOv0IFbsac0nWZhrndHmZrlgZVIqJq','','','2','','1','081297922112','','','','2023-09-11 08:58:39','2023-09-11 08:58:39','');
INSERT INTO users VALUES('534','Dwitami','Wulandari','dwitami','dwitamiwulandari@gmail.com','','$2y$10$6EKLZzgejddu8yqafcs7WuR33mvyZXM/pk0jkaVKqHt7O.lwrAmk.','','','6','[1, 2, 3, 10]','1','085959589646','103.113.77.126','2023-12-18 11:07:48.00','','2023-10-24 10:52:40','2023-11-20 16:50:46','');
INSERT INTO users VALUES('535','HR','HO','hr-ho','hr-ho@gmail.com','','$2y$10$nLxlgVnMhLY./vQuhJhRB.ex314o1EzecVmp7sr/yMOFK8T0GmOKO','','','6','[11]','1','9128390193010','103.113.77.126','2023-11-29 15:59:03.00','','2023-10-30 17:04:04','2023-10-30 17:04:04','');
INSERT INTO users VALUES('536','HR','Plaza','hr-plaza','hr-plaza@gmail.com','','$2y$10$1OyvlHiLgKF5yXYh5wSXsuswPO3qWGCf5iBb7mSzVL//Hzm2nBRGS','','','6','[12]','1','8120273029100','103.113.77.126','2024-02-05 15:29:25.00','','2023-10-30 17:04:45','2023-10-30 17:04:45','');
INSERT INTO users VALUES('537','HR','Fab Shop','hr-shop','hr-shop@gmail.com','','$2y$10$7THUrbzEUBEZjKfp7ZcAhuhrBGC0cr4KqHk5WAo/M7659I69F4IGi','','','6','[13]','1','91027309213021','103.113.77.126','2023-12-06 10:09:40.00','','2023-10-30 17:06:43','2023-10-30 17:06:43','');
INSERT INTO users VALUES('538','HR','Crewing','hr-crew','hr-crew@gmail.com','','$2y$10$oZoKcG4lc7N4/WNV9pt/KukKcVEZwYA.4XEynAVuN7fIygq1Y/nny','','','6','[14]','1','81927391239','103.113.77.126','2023-10-31 10:31:12.00','','2023-10-30 17:07:34','2023-10-30 17:07:34','');
INSERT INTO users VALUES('539','HR','Duri','hr-duri','hr-duri@gmail.com','','$2y$10$xXLh8hX43qjKFaiDGehUM.aQAbNmGz7Di/vwnoXr8tczg5I2/H.5y','','','6','[15]','1','8321487803803','180.241.218.158','2023-11-13 13:14:40.00','','2023-10-30 17:08:09','2023-10-30 17:08:09','');
INSERT INTO users VALUES('540','HR','RAPP','hr-rapp','hr-rapp@gmail.com','','$2y$10$lbd/qG/Or88N52C0xrj7SOJ8QEQA7KvA046XfJi2VbxkTvRKxT8du','','','6','[16]','1','8132974932','103.113.77.126','2024-02-05 11:44:34.00','','2023-10-30 17:08:32','2023-10-30 17:08:32','');
INSERT INTO users VALUES('541','HR','PRI','hr-pri','hr-pri@gmail.com','','$2y$10$J.a03IOTKILAvuCfiEvpceCh3Zv322M0mcPEHzuX4epHO5Egbss9G','','','6','[17]','1','85937945394','103.113.77.126','2023-10-31 10:31:57.00','','2023-10-30 17:09:19','2023-10-30 17:09:19','');
INSERT INTO users VALUES('544','Dwitami','Wulandari','aa00276','dwitami.wulandari@timas.com','','$2y$10$6FNH2hBvhB/5N/5BUna3OuEXA1tsGehlayjPZMKZMPFMbjDyQ0Xie','','','2','','1','085959589646','103.113.77.126','2024-02-05 14:25:28.00','','2023-10-31 17:01:20','2023-10-31 17:01:20','');
INSERT INTO users VALUES('1093','HR','Rekret','hr-rek','hr-rek@gmail.com','','$2y$10$1frw5rtuq8eOE2qKuSxu1u4DbmizG.sBT/Dxs.n1MeQlFoB3HmyU6','','','6','[2, 3, 10]','1','','182.253.87.84','2023-11-21 08:31:14.00','','2023-11-20 14:11:40','2023-11-20 14:11:40','');
INSERT INTO users VALUES('1826','Aldo','Nataniel','Aldo Nataniel','aldo.nataniel@timas.com','','$2y$10$Iz8E40ggD1euugXE/rnsSOSTgQTqDZTYOsFiMR/3iPuMdCXHltEny','','','2','','1','081315084746','','','','2023-12-04 15:21:17','2023-12-04 15:21:17','');
INSERT INTO users VALUES('1827','Heri','Irawan','Heri Irawan','heriirawan081@gmail.com','','$2y$10$E4c.tXWoeQR.49r1FNh2puD2p41oe5UJHBrkCkswwxPste2GgfCJy','','','2','','1','081385768634','','','','2023-12-04 15:21:17','2023-12-04 15:21:17','');
INSERT INTO users VALUES('1828','Raden','Frans Hidayat , Sh','Raden Frans Hidayat , Sh','franhidayat994@gmail.com','','$2y$10$HVEkyrfhi4WOKDjA7OyY1OcE9eVaLQ6MmEwzRxMUx8GcMoEA6eDse','','','2','','1','085959187871','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1829','Yenita','','Yenita','yenitazby@gmail.com','','$2y$10$85.MeBC294.al5uOH9sAoeZcb3VULTBEKr5hUfoRkFYYshLni8Iyq','','','2','','1','082117981448','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1830','Sarwat','','Sarwat','Sarwat aja43@gmail,com','','$2y$10$RyFoYKeABpG4sF0FKo/Ur.0H15gsTUZFK0qbWGXUvEDT32DxW/ICS','','','2','','1','082312953978','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1831','Aminulloh','','Aminulloh','aminullohhifza@gmail.com','','$2y$10$nJtKknJz2./bz0ZmpbAxq.vJoDt5wZJNnPtHduC7g2fbZ1QPxkbFa','','','2','','1','081911291115','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1832','Ijah','Hadijah ','Ijah Hadijah ','ijahadijah269@gmail.com','','$2y$10$IXy4mGXMp7ekDwT1xHYZLujynGNkV7tw1mBe0wq77enjzveAxElti','','','2','','1','081282911305','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1833','Didi','Riyadi','Didi Riyadi','didi.riyadi130486@gmail.com','','$2y$10$C5e1.uZnvaJ8YJzatd4HDuksSe08MR9kRPLm0vlgA9hJJB0WRgyk2','','','2','','1','085216193958','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1834','Kasim','','Kasim','kasimalbantani01@gmail.com ','','$2y$10$65H1gli6JAVanTOOkuv6h.w7nP2qQjWLS2IjEwrgiIQzp.2JbmYIm','','','2','','1','081385348526','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1835','Jaka','','Jaka ','Jaka362514@gmail.com','','$2y$10$3IX4m2Ncy1y9vxj/Ux6FWupFq8CcyDP/xnJJ0P4Uc6VfH2B.aVaLO','','','2','','1','089651594719','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1836','Ahmad','Yani','Ahmad Yani','tama223tama@gmail.com','','$2y$10$FJlYH4c9LkWNLrxKHqRjuu03t9Sy5lwbcGSSyKwg.cfJ4uk91DO9i','','','2','','1','088213714381','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1837','Aswani','','Aswani','Aswanitambak@gmail.com','','$2y$10$naZWU.dFdai8d/gtB6Hj0eoapX.ybSHmbCGjjc79r1oWPU0qPN1Pm','','','2','','1','081398144345','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1838','Wawan','','Wawan','wkang3446@gmail.com','','$2y$10$hez4avV3SpuvSZol8OiMGO1fyWnUwj.UTBEP9jUErzk3K.6sYOkTG','','','2','','1','085219877292','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1839','Firliadi','Al Hapsi','Firliadi Al Hapsi','Firliadi@gmail.com','','$2y$10$q23c0OK/jvaa0KRk4phA4uM2U.U7Hw1veBgEfrS0OryAVmu0c/R9q','','','2','','1','083813123640','','','','2023-12-04 15:21:18','2023-12-04 15:21:18','');
INSERT INTO users VALUES('1840','Siti','Ratna Ainun','Siti Ratna Ainun','ratna.ainun89@yahoo.com','','$2y$10$h1lSNBDY.61CKdo/La2IsOvtFnnqeIhU0ejqMDErMubfp.sfauPJC','','','2','','1','08128602800','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1841','Anton','Frans','Anton Frans','anton.frans@timas.com','','$2y$10$1P3LfIgrLaLLoHKXRVVG2Oxjk3y8AyGu7PZQdb5RV77FL5DY5R/xK','','','2','','1','08121205315','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1842','Sugino','','Sugino','Sugino.aldy@yahoo.com','','$2y$10$9a7uZL8qIOR3qIGMNI9rGuE6JD9fwDtyxcWSB5OPiu77WfKn5aRie','','','2','','1','082110895855','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1843','Nanang','Nasrur','Nanang Nasrur','qc_nanang@yahoo.com','','$2y$10$F.wdnlwwusNS9ZmBAoh8GuPXWELzHQXDPgWZvu/pjxsiyvhLrREKa','','','2','','1','081289244442','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1844','Ethana','Harits Bryano','Ethana Harits Bryano','haritsbryano@gmail.com','','$2y$10$ufdjd7iedU.IcNrFrWpvWOxqjrW6QHfpjQLhrVS5VlQBRoxj7Q6LW','','','2','','1','081285964246','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1845','Saeful','Fariz','Saeful Fariz','Saefulfariz7@gmail.com','','$2y$10$u8VNgJ2CN3WE4a.tDk1IGODS8U8Jb2vIacZ9.MSKShBX6ej.BSntW','','','2','','1','089618507555','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1846','Herry','Suryono, S. Kom','Herry Suryono, S. Kom','herry.suryono34@gmail.com','','$2y$10$x9BEOEKBDcDgHt4WguVys.jVLWxK/1Ne7cevvspuRZkThD.Vlo/J2','','','2','','1','081288195056','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1847','Suhel','','Suhel ','Suhel.binanusantara68@gmail.com','','$2y$10$powj2/QemqwUpP1wDZQMYOCWWUwAHGJIj3PaESoFuH5AB9RenfLLC','','','2','','1','085218729994','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1848','Andri','Kurniawan','Andri Kurniawan','andrikrnwn70@gmail.com','','$2y$10$Hvvkcv5ciwlSCeJaGKod3.gpJSnA6K5ixWSuIOl9DRNpS28jteXEm','','','2','','1','082122231380','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1849','Muhamad','Sulkhi Setiawan','Muhamad Sulkhi Setiawan','Msulhie@gmail.com','','$2y$10$UHGEu/7jUmAKKVKyJ8aMsuqCMZSGdLTotF8wpG2YQQMGTcs1NTMB.','','','2','','1','087786489560','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1850','Muhamad','Irfan Al Amin','Muhamad Irfan Al Amin','irfanalamin9@gmail.com','','$2y$10$wudb8HN9c7t1tmZoOmoBPOMxW0mxTCj/dIJIKzPtnpIqRdudeFpyG','','','2','','1','087771325958','','','','2023-12-04 15:21:19','2023-12-04 15:21:19','');
INSERT INTO users VALUES('1851','Rizki','Ramadhona.W','Rizki Ramadhona.W','rizkiramadhona@yahoo.com','','$2y$10$iv2FO0s3kRbvfREV0sd2e.hXu5wK7uGYllB2hX1Hr8BwW2KN/PulK','','','2','','1','081284939394','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1852','Jefri','Silalahi','Jefri Silalahi','jefriisilalahi2018@gmail.com','','$2y$10$6qDsZZiD27JJIA0jfBEl4.Nj/1SAMRIFvEdpnL6ZILdOK0NZEt3EK','','','2','','1','082178680320','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1853','Moh','Hasyim','Moh Hasyim','moh.hasyim@timas.con','','$2y$10$kzDRNzPQiJruVZofRV85X.mbTiKAPqG0I.0I8IfD6VS30sB2DrcLa','','','2','','1','082312027157','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1854','Alfi','Syahrimadona ','Alfi Syahrimadona ','alfi.syahrimadona@gmail.com','','$2y$10$jRp0dpbEx2OgB.GcZUWnjeFOmdgwQEg5xcUtvdEtQlVNKw2eFcwMi','','','2','','1','081227235553','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1855','Maryono','','Maryono','maryonokoyek1975@gmail.com','','$2y$10$ICzbVyAvQzN55NXcNBqeBOnyTuBrlgvQwI57ivUk2mHN6g7ZdUHku','','','2','','1','081398051559','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1856','Ahmad','Habibi','Ahmad Habibi','ahmadhabibi3425@gmail.com','','$2y$10$/MwtVDfuLG2woyStZW77auwfp5mWg.MbnQ3AqmrILKWTR8aD/Ica2','','','2','','1','087876874679','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1857','Rifqi','Dhaifullah','Rifqi Dhaifullah','rifqidhaifullah18@gmail.com','','$2y$10$ivVLBNLjsQgyzGaGKCHkpe6M/rEcbhhpSinPXKp7YKDUVbcraW3Ya','','','2','','1','085960618570','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1858','Dwi','Yuniar','Dwi Yuniar','Dwi.yuniar@gmail.com','','$2y$10$pk/rmVG5saCoFQPj11Z4WuQ8p9egdekXWsij8Lkh1qWEcWoe0peuC','','','2','','1','087801061993','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1859','Moh.','Arifin Rumaji','Moh. Arifin Rumaji','muharifinrumaji@gmail.com','','$2y$10$wEWE.VVQ0wdfisFMTtJDDOxw1XyREKStCalR7mYe7SM5XNqg6pL/a','','','2','','1','081311014239','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1860','Wahyu','Budianto','Wahyu Budianto','wahyu.belahkulon97@gmail.com','','$2y$10$IAXye58/wbDx.dAeEX5.pOox9YHfS/dhfjtvIyxxYsGk/QK6f8U3G','','','2','','1','089697438880','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1861','Iwan','Siswandi','Iwan Siswandi','isiswandi15@gmail.com','','$2y$10$3lfeBIMEgn5OaG/565lxRu84RskusBiDEcf.Kl/.XNwneDZ0c4.Se','','','2','','1','087808291233','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1862','Vivit','Eri Hidayat ','Vivit Eri Hidayat ','pradiptaerik@gmail.com','','$2y$10$AL7QDjlNJEjdnQ25mQOquO5dxfLOQ7ulXC26eR1osT3.9gEXipkh6','','','2','','1','085718080847','','','','2023-12-04 15:21:20','2023-12-04 15:21:20','');
INSERT INTO users VALUES('1863','Andri','Puji Setiawan','Andri Puji Setiawan','Andripujiset@gmail.com','','$2y$10$MPomJWlAWSxpOerj9.un6e5BcWyYHdELFfJey.iQWIJMMr94bbjyC','','','2','','1','081285858716','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1864','Rendy','Kerisna','Rendy Kerisna','rendy_kerisna@rocket.com','','$2y$10$nV46oWsF8TKOQ33S.dVv6u4ZuSYryDjRAdU02LjTu4D7OwY17d5Nu','','','2','','1','085717662532','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1865','Jaya','Heryana','Jaya Heryana','jay891143@gmail.com','','$2y$10$IQP.ELInxHxK.WmwMm217uiXAKvGRkaScxD.KVL4e0m/52D1hcZAG','','','2','','1','083877606993','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1866','Tarmidi','','Tarmidi','tarmidileo160@gmail.com','','$2y$10$KjVmssPfrOZK6E5.vWv7aut6QMAOmiF/57wNRGohO7Bw1v936KiIS','','','2','','1','087788085051','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1867','Umar','Sumardi','Umar Sumardi','tohaf21@gmail.com','','$2y$10$m29pbi8QSRWtJJkfnfCyFuUGpF0D3gbJf.acW.2rdJQnLzWnL3ZVe','','','2','','1','081389238664','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1868','Nana','Suciatna','Nana Suciatna','sigabjalakrawi@gmail.com','','$2y$10$rnn52VfYyTwavrmnzdqA8.5w28TG/AyYL8m8DA9lOKR5omojympnC','','','2','','1','087886095475','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1869','Suroto','','Suroto','12suroto44@gmail,com','','$2y$10$yfWKql7LoNc1cwt65qksP.GhzKAOt7AQiXiQ5eHbJ7R3GVinqp5kK','','','2','','1','085930285855','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1870','Ismatullah','','Ismatullah ','Imatalvaro822@gmail com','','$2y$10$lQ2w6q/UNsbYYQ89HWWWgeMyC5.SoSmtmU30TW4g9tFQG/ZvSAOlq','','','2','','1','083848584016','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1871','Muhammad','Pahlefi ','Muhammad Pahlefi ','muhammadpahlefi648@gmail.com','','$2y$10$xwCm3nvl/EVta/.qzbnxIOp6amZWJZguEHek6Mg/4OtZmZqriGPK6','','','2','','1','082310436085','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1872','Rudi','Hartono','Rudi Hartono','rudipaster242@gmail.com','','$2y$10$7nE4GGnvDCZqpsTrTTa71uO3K8NzP0.ijWo4SW8hP/Q6jmfxZJ5uW','','','2','','1','081310193667','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1873','Endang','Saputra','Endang Saputra','saputraendang020@gmail.com','','$2y$10$6CsjUDNZDcz3Ae6/yNHbO.XC4TbynKAs0P1OrlJ0HsUT53M/5imdK','','','2','','1','085717635769','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1874','Darwin','Silalahi','Darwin Silalahi','Darwin.silalahi@gmail.com','','$2y$10$Aiu5weYROOB0jK0XkhC5GOO2liQ8yNiYZ5BVvWZWdBqQi6LH8nDUm','','','2','','1','081282099356','','','','2023-12-04 15:21:21','2023-12-04 15:21:21','');
INSERT INTO users VALUES('1875','Saenin','','Saenin','Saeninssenin44@gmail.com','','$2y$10$/QWn6Ij0QsnZrYB9KX4x.urggbeJFl5nnysPgjxHkHkDTJn44CfcS','','','2','','1','085284371675','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1876','Nor','Said','Nor Said','nursaidikram@gmail.com','','$2y$10$1wgb1Jt4v3Q5pmOqipRk3eag5Z6EO2nfaW4nLE8RY3n.X2VO8jSoK','','','2','','1','085219428892','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1877','Rinto','Samosir','Rinto Samosir','samosir.rinto68@gmail.com','','$2y$10$K1E5gKA7HExl.4iCm2YpEu7ADtyQBtgm75tlpn7uThudUUCGn89Ve','','','2','','1','081280512987','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1878','Gentha','Omar Panji Wijaya','Gentha Omar Panji Wijaya','genthapanji@gmail.com','','$2y$10$hwXFBAfqgb0LN8ATqzvua.W7hrZ.rpxAajIbK.VY2AYDcyhGaWQn.','','','2','','1','081291231530','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1879','Yusup','Ramdhani','Yusup Ramdhani','yusuframdani21@gmail.com','','$2y$10$bGAAXeBS.82s5LBJ2CrpVO3tWmRMV1QNCRwMThRoZlpsCRIb5qPJ.','','','2','','1','081314162709','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1880','Suyadi','','Suyadi','suyadiadi406@gmail.com','','$2y$10$drq.MBlMUtJykIgIb.xZUeSr5jT3853BoNH7.fQWLnQ1.i6YHH9B2','','','2','','1','08988665264','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1881','Reza','Dian Permana','Reza Dian Permana','rezarazzor130191@gmail.com','','$2y$10$3u1jia4FZfK0VMzD1lkSzO0R4wO5yfhphypUrTo3E2/QW49QBgaiq','','','2','','1','087778482858','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1882','Muhlis','Dondi Mihardi','Muhlis Dondi Mihardi','muhlisdm69@gmail.com','','$2y$10$j91UqY5UkuSpcS5zjT.g/.KSmvlyMzjEtwd9b6wODjALWPhg1PQqa','','','2','','1','081268345411','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1883','Sanen','','Sanen','sanen205@gmail.com','','$2y$10$Mq69rGVZEdvD9z5S5msk9eHMj.bm8Spzs85Ne8o6Lb.SkBX8HlghG','','','2','','1','082312182233','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1884','Aziz','Amirudin','Aziz Amirudin','azizamir844@gmail.com','','$2y$10$Tvkeq/r7NugqhBKNlNxbWeVgIACQ4OjxFdVvwlaIMBbCMAeIrpEPS','','','2','','1','082312727937','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1885','Ingga','Mulyana','Ingga Mulyana','Inggamulyana24@gmail.com','','$2y$10$TS0tI1ozCR/O6DcbilKSiO7cWVaVs0/qRZEe85Oz40KPDs9BdtTkC','','','2','','1','085712610091','','','','2023-12-04 15:21:22','2023-12-04 15:21:22','');
INSERT INTO users VALUES('1886','Sofan','','Sofan','Sofanopan66@gmail.com','','$2y$10$AWtcsYNf/21sIhZtp3sU.eyFc.u7UUGuwm/KLzd/RugxO1YkJAZ1m','','','2','','1','085939070852','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1887','Erik','Yuliadi','Erik Yuliadi','yuliadierik@gmail.com ','','$2y$10$06g0ypU2SJLW6/44292Ie.dciAH7yL9XL.TMQJRRauQf8jy7SEmRy','','','2','','1','081281143405','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1888','Anggara','Saputra','Anggara Saputra','anggarasaputra8227@gmail.com ','','$2y$10$fUABNWMH/snKfKjWQIiuUuA8laTLBraOTyWpt17MnhRRCsHHvbZSa','','','2','','1','081271442155','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1889','Jhon','Albert Aritonang','Jhon Albert Aritonang','eliskaaritonang78@gmail.com','','$2y$10$Ukt33JJkGaZO4r14Cr3uV.VHIwzr7PPrr3RnxZxyAP3ES0WdW21yO','','','2','','1','081297238758','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1890','Bambang','Irawan','Bambang Irawan','Bambangibenkibenk.gmail.com','','$2y$10$N6Mztp.r5FLrWmnTghPK6OTmA0lXn4HTObRfaW3ceHCEpHeEpIeqC','','','2','','1','057808546949','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1891','Dedi','Rasdianto','Dedi Rasdianto','dedisuhar@gmail.com','','$2y$10$2V8TNV/GXjFIa5mbIZ2NH.2WfDa.THAUvUlE/NQ7.EEhd3zVRcNRS','','','2','','1','082115136397','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1892','Sastro','Wijoyo Butar Butar','Sastro Wijoyo Butar Butar','sastrowijoyo174@gmail.com','','$2y$10$4/AMOyac1xQ4rFHu92vpteSSjVF4f8gGYhaUE5bxYi.UCUlVDcuSG','','','2','','1','081388977156','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1893','Suheri','Bin Iwan','Suheri Bin Iwan','Suheri@gmail.com','','$2y$10$6D2i2AqbGJ.R5fCODJ3IPOFSTaxE2IwW/loZM.3QYoFS.dSA1wjPG','','','2','','1','08311465229','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1894','Suandi','','Suandi','Suandi@gmail.com','','$2y$10$wJL/R08TK7A4JDAtEGJNDuXQq4LufMr1Ph7EodMuGJL.Y6AmY4cM.','','','2','','1','085693396879','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1895','Sunda','','Sunda','Sunda@gmail.com','','$2y$10$yfNnBkikfgq50hyjpsH09OWJ/gUgIHXh4iEvCCc/cdLVdczv8.Ij6','','','2','','1','081285804910','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1896','Imatullah','','Imatullah','imatullah150200@gmail.com','','$2y$10$HFXeH/dGeLIlZcxVaiLf8.uKUnbryyU7gZY85VXOlR9hQqr/9ulEG','','','2','','1','083127321344','','','','2023-12-04 15:21:23','2023-12-04 15:21:23','');
INSERT INTO users VALUES('1897','Mochamad','Haeroni ','Mochamad Haeroni ','muhroni507@gmail.com','','$2y$10$KSTvtdBXS3SefJEerjBZvuyS53Pgipxa3tIw8Pj6UMIfZ0nGpKrB.','','','2','','1','085312974597','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1898','Suparman','','Suparman','suparmanjon123@gmail.com','','$2y$10$E41yQaIrWHTx8k3iJzJYaOdtzdTWHdXfjoHtgsvYMPTkNySEpqoKy','','','2','','1','045217991932','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1899','Osbin','Malau','Osbin Malau','pudanrevan@gmail.com','','$2y$10$hi/4QQJDnsBQyrgjHrClPuIa954x3h4iZYvls9zPMrVz7Yijga8wK','','','2','','1','081294751486','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1900','Yulianto','','Yulianto','juliantoarepac@gmail.com','','$2y$10$o5uVQAnY/QvjG5.ADpB89ePiXtjFmGUfjBWY8jq3HnJR3.Lqx1AeG','','','2','','1','081288713060','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1901','Mamat','','Mamat','widyainayah30@gmail.com','','$2y$10$d6StstC0tdnes0JkRky4geZUDA67QTeOsfowGHSyhhNDjYxaf6yua','','','2','','1','085228044525','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1902','Erwan','','Erwan','erwanerwan752@gmail.com','','$2y$10$HpHIEAQYLHJJJF/ucip3e.eA2101xnxdVTTcV28.vcELkT5YLq4y2','','','2','','1','085216368976','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1903','Matsapik','','Matsapik','matsapikm@gmail.com','','$2y$10$kBJYPlATGrsFzkdXrcW/aOX5dMuWenRAJysrU6Q9rpaI6ZZhwnSPy','','','2','','1','081210084545','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1904','Wigihardi','','Wigihardi','wigihardi76@gmail.com','','$2y$10$d0afuY7J4/99Y9FRKHF/LODM/zFgnIzCP7YIqLTYgnAOV0PNX4D56','','','2','','1','081316820811','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1905','Soleman','','Soleman','Solesoleman257@gmail.com ','','$2y$10$SnQe//M/IdvzOJ5p4dUhJ.SLpPuaYj9B3FmdRwoUmB7/58NnX3oUu','','','2','','1','085691866423','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1906','Akyadi','Bin Ripan','Akyadi Bin Ripan','yadidi87@gmail.com','','$2y$10$u334Pe09oSccr5jUF/dlK.zXV8Sv6TKsClu4ErX1nQSrQqiImAYti','','','2','','1','088214759053','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1907','Dudi','Rohman ','Dudi Rohman ','do3dy.88@gmail.com','','$2y$10$mbojNWiWas6c1VmsWcSnbu1v8u3aj/MxpDGZ2K7d5xFBVuNEzAxIa','','','2','','1','085773412324','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1908','Suparno','','Suparno ','suparno01245678@gmail.com','','$2y$10$W8Y0AQ19CUW0/9fKXcmj2uEubjwmm.7S79GxNAKKJp1BTruiJx8Nq','','','2','','1','082142522143','','','','2023-12-04 15:21:24','2023-12-04 15:21:24','');
INSERT INTO users VALUES('1909','Saepudin','','Saepudin','saepudinpudin837@gmail.com','','$2y$10$Mbq6ODoSqmJbUqB1r1JAfOll0FZKMnzW6ECGFOICrhyZ8Vyla9PGm','','','2','','1','081316935415','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1910','Yusuf','Ade Supriatna ','Yusuf Ade Supriatna ','Yusufadesupriatna123gmail.com','','$2y$10$rYaur/IqHC8l.1BIpbZ20ub8gtvWWF/qX0gpQBYcR7HdSaJgQQMyO','','','2','','1','087871466946','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1911','Saepuloh','','Saepuloh','Saepuls315@gmail.com','','$2y$10$p1v6jINSqejgF/xjACnqA.u./nUwDVMp.a8JIaFugxW0s4fiJA.la','','','2','','1','085782972766','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1912','Nurakhman','','Nurakhman','Nu_achman@yahoo.com','','$2y$10$PyDSV8X5niIt7vYRwdCwO.jeACy2rArdnY8U4tus3LgCsGaXTatrm','','','2','','1','081310748372','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1913','Purwanto','','Purwanto','purwanto321969@gmail.com','','$2y$10$FUFmvb8FtDRlUEoByhwus.B2FgsZsuYu6ZnOJbudTl8jLhkLc4MbW','','','2','','1','085217374535','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1914','M','Musa Efendi','M Musa Efendi','mmusaefendi@gmail.com','','$2y$10$H/6m1WaPtmlOtxE0iyClGuDHtZx8DofTTRg1FsPpOpXgyzoRqb8Am','','','2','','1','081399092269','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1915','Agus','Sofyan','Agus Sofyan','agaysofyan21@gmail.com','','$2y$10$74WJdWt7Yj7PyUPFSjYKFe5EzJEag6kAFNdo0vy5AWVhPHaEA2yRC','','','2','','1','081387866051','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1916','Sukardi','','Sukardi','SSUKARDI135@GMAIL.COM','','$2y$10$mtf0Mn6TOcT8V0NM865/M.hOTMdOIh.cK4ACY1ieY93al6/RHMhh2','','','2','','1','081297238970','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1917','Suyato','','Suyato','suyatoondel41317@gmail.com','','$2y$10$5WX3S7KKDK9u..6A8h99i.IL3cxoQyTWnAA0I3aMVYlktxsX8kupS','','','2','','1','082210476846','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1918','Eli','Hermansyah ','Eli Hermansyah ','elihermansyahhermansyah@gmail.com','','$2y$10$cq.IFRDCUSAqN40247Ni/.rw6wBwjqsBaaHyyuUZyWTWe0p6zUF6u','','','2','','1','087775845142','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1919','Riki','Purwanto','Riki Purwanto','rikipurwanto46890@gmail.com','','$2y$10$GGa39qIPoA89mBXCKQz6Q.The77Fkcxn0K2Lf6cYs0CoKjB2wH47u','','','2','','1','081268966927','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1920','Paryono','','Paryono ','Yonoparyono02@gmail.com','','$2y$10$DnjNfCkAa0RlvNpfhAdlnuxO1UtwEgaouobwmAm6MSkdXW96foP86','','','2','','1','085313652724','','','','2023-12-04 15:21:25','2023-12-04 15:21:25','');
INSERT INTO users VALUES('1921','Iddrisno','Naibaho ','Iddrisno Naibaho ','idrisnaibaho88@gmail.com','','$2y$10$l.RgiS1cqXqTkVjST3m4vuiCBovAu9Dwy1bnk2TSfIEUNNn.nZc5m','','','2','','1','0813857920052','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1922','Rahimudin','','Rahimudin','rahimudin7788@gmail.com','','$2y$10$eXuvULjx6MvZUFmsFg2sN.f/qAmxZl7DrnVLEjVaj9Rs7iqjKlEcG','','','2','','1','081278188622','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1923','Tolhas','Jonier Hutasoit ','Tolhas Jonier Hutasoit ','tolhasjunier@.gmail.comm','','$2y$10$twKUMfi6yFtRW1YYlrzNbevsyWZf7Ajs8YRDoy1Y8jq6is2bmR2Vu','','','2','','1','085210714897','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1924','Roy','Renold Siburian','Roy Renold Siburian','roysiburian17@gmail.com','','$2y$10$H.MzrcQnFECBc8ZxbAwAQuPPUlenfiNP3VppQBK5GfnHoviEL/k7C','','','2','','1','08212935520','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1925','Dian','Hadiansyah ','Dian Hadiansyah ','Dian.h@gmail.com','','$2y$10$ScC.O70djE4pknAsI.A2duwuCIT.mr4VnrHGZBEIx.WKdbs1XlRva','','','2','','1','085920671630','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1926','Junaidi','','Junaidi','Junaidicase@gmail.com','','$2y$10$C.oJWSGvfWKj3XcbDGJ/AexXqt8euXVyx/osgDpvPQX.fhwL3fLnW','','','2','','1','081906274160','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1927','Nikmatullah','','Nikmatullah','Nickkutubuku@gmail.com','','$2y$10$kwB0aQn0882k4fbBkIqPR.7z6Q/e5xOH0HQhlJEHzvqcNEf4Bd8W.','','','2','','1','085693592382','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1928','Irwan','Wahyudi','Irwan Wahyudi','irwanwahyudi469@gmail.com','','$2y$10$ENbP0fAcJAeBac/01sUxl.pXUuKXcl6TwqDv0JYsvBBp7tvtXF1He','','','2','','1','081315128489','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1929','Ajislim','Silaban','Ajislim Silaban','ajislimsilabansilaban@gmail.com','','$2y$10$dVnMVs46zjwpruwik7hJyebdXRTDzEIT2RSHFzqAUwsnYGHoVXiGy','','','2','','1','082353311506','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1930','Mansyur','','Mansyur','ajaikal898@gmail.com','','$2y$10$.u0H/3GD0bLRYwxfKScGCOHWznR5UvHxTwe2z/Pw/nmucHAmNPfF6','','','2','','1','\'083127195698','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1931','Sohadi','','Sohadi','sohadi@gmail.com','','$2y$10$N8yZkaPLgDf7N5WoHb8un.m.XOJjUn9qsrR6AyKnmXMJpaa68yk8a','','','2','','1','083890898941','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1932','Charly','Nababan','Charly Nababan','Charly.n@gmail.com','','$2y$10$opVSxwK6wnzXhxHJkSbln.d8tmiIqZQMVto8732uFK/dQqs0gZ6CO','','','2','','1','081379456337','','','','2023-12-04 15:21:26','2023-12-04 15:21:26','');
INSERT INTO users VALUES('1933','Imbran','','Imbran','Imbran@gmail.com','','$2y$10$7lnqIvSEGscJWpNNibHiLe.GCZjw3Y4LxWw1W5tZfaCh8mXuOOWbC','','','2','','1','082123656003','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1934','Andry','Firmansyah','Andry Firmansyah','andry_firmansyah17@yahoo.com','','$2y$10$uN4bCVzu6jyZ03lp53zfWO0hpTDRsHErC7cpkPGudVokSVPCvKQPu','','','2','','1','085288846363','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1935','Muhamad','Jupri','Muhamad Jupri','Jupri.m@gmail.com','','$2y$10$0T7UWIzaw/VChaJtgxfqZej6Kgi4wyV7daBGQnkemBtZYzMp8b6Gi','','','2','','1','085939419245','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1936','Suhemi','Andriansyah','Suhemi Andriansyah','suhemi@gmail.com','','$2y$10$xkqkuXQazBaxfUbS5yz6Fu6NuYzrsNqaR5zexD7KMdQNkVonJjXpS','','','2','','1','083119047028','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1937','M.Kaman','Sanusi','M.Kaman Sanusi','Kamansanusi6@gmail.com','','$2y$10$j9jrGn8dwQubwcgcl2jKoeNFURk.nkermxeGHaFW8i/zPzQj8heoS','','','2','','1','081283600132','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1938','Willi','Afrilian ','Willi Afrilian ','willydoer1207@gmail.com','','$2y$10$gTThRcke.hGV4.AVqiDuR.DckzBic7xk8fN0MAjtUSmSR.VPSQ6IW','','','2','','1','085959568233','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1939','Heri','Suarno ','Heri Suarno ','Herisuarno@gmail.com','','$2y$10$.NpKYrLcAVtwofGQmOiCaua6USpfHNaZncM.ZtB4TNzm14XDLkEea','','','2','','1','081291318134','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1940','Dasron','Sinaga','Dasron Sinaga','Sinagadasron9@gmail.com','','$2y$10$aYq9irPu7TJiOJqReEjgO.5axiHbQxmS07I8QMOMiVUU3X4tB1xoi','','','2','','1','085215579970','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1941','Muhammad','Kahfi ','Muhammad Kahfi ','muhammadkhf20@gmail.com','','$2y$10$jkG0Do2C5xTLbeNRzz918.T0pI.E.kfMXJxh2UxYaxywt49uCTtH.','','','2','','1','083871952889','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1942','Rohmat','','Rohmat','dyah.fu19@gmail.com','','$2y$10$MiB28664rBiIZ35xGRNjNe.YqudifSYCJWIoJYHhu6sq.HMlKao0W','','','2','','1','081315415696','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1943','Juli','','Juli','heriyadijuli18@gmail.com ','','$2y$10$fXzcCR1l21/oqc.RfKizd.z5t/VrB.8EKJL32TIthzxAsfYOtJH8.','','','2','','1','085216916646','','','','2023-12-04 15:21:27','2023-12-04 15:21:27','');
INSERT INTO users VALUES('1944','Jaja','Sunarja ','Jaja Sunarja ','Jajasunarja52email.com','','$2y$10$ciHGGB66klXMa2RadOZ7ZuXFdWTOpfvj0T4Yx9/UWsaV5exjP.Up6','','','2','','1','085210377746','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1945','Medi','','Medi ','034beno@gmail.com','','$2y$10$C.r53uio1gupqT9EVQ3ziexgGiLaoKI5j7RiSdbVTgdtNTEKZ66WO','','','2','','1','081316761693','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1946','Andri','Wibowo ','Andri Wibowo ','andrie.wibowo71@gmail.com ','','$2y$10$BJ/UIVkQiQW8jQhXX6ii2OYgDO1cmQCb7Om3sYym.9iTAUk1jOFh6','','','2','','1','085329421884','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1947','Yahya','Suparjo ','Yahya Suparjo ','Yahyasuprjo1309@gmail.com','','$2y$10$sz6f2Dtam3g1KAmcWKvRSuDAJUsyVv/m54vmUgwdTxu24TX6XqyW2','','','2','','1','085210759988','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1948','Dadang','Sugianto','Dadang Sugianto','abythea19@gmail.com ','','$2y$10$N4xbbMWr4t4124vXAFLsweJIVPLswsVI2u52LvZ74LsM2Q/AOl86K','','','2','','1','081224074130','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1949','Ridwan','Saidi ','Ridwan Saidi ','Ridwanzea16@gmail.com','','$2y$10$6CoxGfudY73M9H3to.2gQOYPK1IJfwTRL.mTLmXNg4COYCtPj6e4K','','','2','','1','087864745161','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1950','M.','Ali Sodikin','M. Ali Sodikin','hilyaazahra89@gmail.com','','$2y$10$s.cuIPvZULeQC.BiA0cUxOpIKvsmNvRKAnPHRzmYR3kSlKBSlL4nu','','','2','','1','0881010749831','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1951','Utama','Wijaya','Utama Wijaya','0199tamawijaya@gmail.com','','$2y$10$vLKkRhz8If04Zsx339VoyufUHh5XTVWrFc1NtJcEKfvEHtM9INam.','','','2','','1','082175199923','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1952','M.','Fauzy','M. Fauzy','ajie.bae30102015@gmail.com','','$2y$10$K1j3iSGW2vAtt010Gz3x2u3Qx7FOt3wKb5XgkIislm0gNTRBOKxia','','','2','','1','082184373178','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1953','Erlan','','Erlan','erlanamelia01@gmail.com','','$2y$10$OoJ8YCmB7ru2j/WrRNJA3u0LKXDw00xxPOHg3Hk0VrFKEE2t/scjS','','','2','','1','081268030399','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1954','Asep','Achyar Sutisman','Asep Achyar Sutisman','asepachyarsutisman@gmail.com ','','$2y$10$R66ntef23NY3CxyIDqDQ.uS0Ao/LgqdJWrmDw/X2UjjAdOP1GvESm','','','2','','1','089643151668','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1955','Damanhuri','','Damanhuri','damane1378@gmail.com','','$2y$10$Ay.XySCykutyrROwhxtT7eSLjMVcj3MOXJJltB9gWG198z6ds2FdC','','','2','','1','082298339997','','','','2023-12-04 15:21:28','2023-12-04 15:21:28','');
INSERT INTO users VALUES('1956','Sarkani','','Sarkani','kanisarkani982@gmail.com','','$2y$10$wi3KHAytpWJXuxBe8c5lRuD6B8q6Kfh4/mMozFzjktwdYVYqRTnIm','','','2','','1','085211821475','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1957','Saefudin','','Saefudin','Seapudin1970@gmail.com','','$2y$10$hxWiOhBnWXOSv1cmqLGCPudoN5FWdwxdUpMEK79AMWHlB.idPC.xe','','','2','','1','087771446771','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1958','Kemis','','Kemis ','themozt046@gmail.com','','$2y$10$pwyWGcZZZMjSely9EQZ.0e3ZseDdCVddF7IEWlhSOi8OH8mFKIjdq','','','2','','1','081251096886','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1959','Budi','Muharom','Budi Muharom','dhiosaputra968@gmail.com','','$2y$10$66W020UaGJ9F6kRQ6VQVg.cTx60DdJM4ckyRIE656HphShV7KoflO','','','2','','1','082320775526','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1960','Heru','Sumas Aditya','Heru Sumas Aditya','Herusumas65@gmail.com','','$2y$10$WPj35qYJdZdhKv13ymkF/.JxrJbimAJZrTSIgwzSYrjTN9zVWdHcW','','','2','','1','081290562157','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1961','Parsaoran','Gultom','Parsaoran Gultom','gultom.parsaoran1986@gmail.com','','$2y$10$vcnpCyhMNsMC1fQvb.C4F.LH16vXfmEhcCHCDaAd1WAQfQgivHd.u','','','2','','1','\'081227693124','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1962','Santoso','','Santoso','santoso.rms55@gmail.com','','$2y$10$90hxqLE9woX6WSaU6qQBm.90yXeGT9EzH5yN.pXuX03xMWOBcsRhS','','','2','','1','081311342428','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1963','Safiyudin','','Safiyudin','safiyudin@gmail.com','','$2y$10$vZDeBZDapHNNqj2/xlyH/uqgtB20eTji0q8bCBxc1HU3BOtpDMHy.','','','2','','1','085311580122','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1964','Saprudin','','Saprudin','ariep321022@gmail.com','','$2y$10$LgTmOZjiXbFkLHKBz43aNO/AFVhTyw.zMP/71G.l7bBfJTzFeZ3h.','','','2','','1','085946793917','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1965','Muchtar','','Muchtar ','muchtar1766@gmail.com','','$2y$10$KS4yb.jWi/Dqfn8l3FGPZOnuA4Dl7QCVj2uKRIEsgxF1I/70sC3kW','','','2','','1','087771748372','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1966','Dady','Rosyadi ','Dady Rosyadi ','dadyrosyadi14@gmail.com','','$2y$10$1Y21ySDu0m8kUulmFkbkpebDmoJ7ddRFtkuAGFCvlgXV2szD0ZCSi','','','2','','1','08952790225','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1967','Rahmattuloh','','Rahmattuloh','SANUNRAHMAT@gmail.com','','$2y$10$HjhNsxKBTJ1/SyCO6e6fV.lEtBzTwGYNFePzyOiqXeviZy.D9xFRe','','','2','','1','081317516084','','','','2023-12-04 15:21:29','2023-12-04 15:21:29','');
INSERT INTO users VALUES('1968','Dimas','Candra Girisona','Dimas Candra Girisona','dimaschandragirisona@gmail.com','','$2y$10$mlkiljdYzW4TuwSSqOf8LuHMhQ/u0a3LnH2oQBVpvRa0IKgX9dBgy','','','2','','1','081293317538','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1969','Paryanto','','Paryanto','blegohkelana123@gmail.com','','$2y$10$FP6gkZGk9BYkjxd6RcZZgO7aIw.T.mzq9.fE9A/IUbO35tnDRbgUy','','','2','','1','081218061895','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1970','Erik','Extrada ','Erik Extrada ','eextrada05@gmail.com','','$2y$10$nPG4WCokqwJT8HwoNjifsO.AZhdIH4VPYnb90.M8uT4ZsK.AHw3yW','','','2','','1','089529917134','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1971','Nanang','Farid Ariyanto','Nanang Farid Ariyanto','nanang.farid@gmail.com','','$2y$10$XfOtImDU6/Wn.G9p6TkIFOZF7Oldr6/WVkFmlvPyn8Ir5K9R37L3e','','','2','','1','081335306888','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1972','Mochamad','Su\'Udi','Mochamad Su\'Udi','moch.suudi08@gmail.com','','$2y$10$UNTaY1FLZh1tBgju9nRxeua0Db875uLK8dkgEL9c8Bv/QnjBstI.y','','','2','','1','081310908261','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1973','Amin','','Amin','djadiputra514@gmail.cpm','','$2y$10$aeXM4zT2Cw4g5TdpXfBSme8K6.J6K1okgZKopYKEGc0HOdYCebRUW','','','2','','1','085216957457','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1974','Antoni','','Antoni','antonichebungsu@gmail.co','','$2y$10$HCFENBJiusHTtO3vLzAJduazQabmh.hVeAeIh0NOQRetn7YUCKM1a','','','2','','1','083842150483','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1975','Muhammad','Ridwan Amin','Muhammad Ridwan Amin','ridwan4892@gmail.com','','$2y$10$Eq1n4y.6JBCrILqNvrDdseRm0buR4aw6j5/ybXQpwckq1Fu4QHATm','','','2','','1','082122270017 / ','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1976','Aris','Susanto ','Aris Susanto ','arissusanto2938@gmail.com','','$2y$10$lIF0QrOhEaj6mrBgZVfkwu40cdV19wLRXyiRnVs6oOV/3C2W/FoLu','','','2','','1','083826968420','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1977','Sudarwan','','Sudarwan','sudarwan@gmail.com','','$2y$10$M.cMyeq2PhlCKYDYnpQNmeZxFjUCPHE340Wh2ZbhGxgf6Skfi0hLm','','','2','','1','081296697862','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1978','Manap','','Manap','Msabymanap01@gmail.com','','$2y$10$AGwqlQQONVHRa1qFLGpwteZ1NktiL9cUjLLo1o/AcO4/lUNKR980O','','','2','','1','083808510377','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1979','Wahyu','Dwi Saputra','Wahyu Dwi Saputra','wahyuwahyul2003@gmail.com','','$2y$10$ryGicewTzq2UaRhJGuGs6eluJgmRd3PpGFMJwQUGJkHOjEdIsdPiG','','','2','','1','085229332286','','','','2023-12-04 15:21:30','2023-12-04 15:21:30','');
INSERT INTO users VALUES('1980','Moh','Sudari Wibowo','Moh Sudari Wibowo','mohsudari698@gmail.com','','$2y$10$fb7FjixAIuPGtfdBGueyWuCrzMeOdK23ThpNSNWpvPN2B/scqE2vK','','','2','','1','081319698280','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1981','A.Hafidullah','','A.Hafidullah','ahmadhafid548@gmail.com','','$2y$10$RojSdczfso4CJHfOoEY.LOl3A9UqInr7qu/m1HQC4gvi4hfUF9yXS','','','2','','1','085215799454','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1982','Sahroni','','Sahroni','sahroniaduai409@gmail.com','','$2y$10$L3yBkejC4t/74gOegOoRaeGLaXoT3nywq7wF.VenGe8ayqduux3ZC','','','2','','1','081291845422','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1983','Bintang','Chanensya','Bintang Chanensya','zeyyyyuss@gmail.com','','$2y$10$TKuOO9XHLgjkMV3hDTTzrO/26.mrkdGLLUZZgzECRX1o8/RE76rvO','','','2','','1','081212259113','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1984','Kamsarudin','','Kamsarudin','ilhamrakaboom92@gmail.com','','$2y$10$tZHTyxoITRztmz.CEAmFTOr2dpaByHHydHGCxSjQi3cggNV6cUrLq','','','2','','1','082122189601','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1985','Zulkifli','','Zulkifli','falskipli@gmail.com','','$2y$10$VFHWeUH0euVG3wQ2nK.5N.FK3zlIhWYfp9IVIH2sKvxuxdXtIsj/O','','','2','','1','088293046543','','','','2023-12-04 15:21:31','2023-12-04 15:21:31','');
INSERT INTO users VALUES('1986','VALENTINA ','EVANI','AA00059','valentina.evani@timas.com','','$2y$10$wyfrYCj6OB9rveLSo/7WG.Aw0ftwBi74GwgTBngiJ3pdBuLyU76km','','','2','','1','085771527008','','','','2023-12-06 09:50:38','2023-12-06 09:50:38','');
INSERT INTO users VALUES('1987','MOCH','RUSWANDI ','AA00067','moch.ruswandi@timas.com','','$2y$10$0Gjbtuym6YoBqYbjE0EBQOWB0lMrWpJtj6.F0v.Q2nX7PuYx5nKeK','','','2','','1','081383337805','','','','2023-12-06 09:50:38','2023-12-06 09:50:38','');
INSERT INTO users VALUES('1988','AMUDI ','SIMORANGKIR ','AA00070','amudi.simorangkir@timas.com','','$2y$10$w9SV3jxcN424cRvR/k.7WuK997rtufHmEUMVNnpAq4RDcDNbF8jF.','','','2','','1','085283855286','','','','2023-12-06 09:50:38','2023-12-06 09:50:38','');
INSERT INTO users VALUES('1989','DENDI ','MARYANDI','AA00071','dendi.maryandi@timas.com','','$2y$10$Znn0CZpiSRlTEUv6smI8Gu9pkVLkU.rSNWKCZNtUf1NNMdL7r0bBu','','','2','','1','0817828753','','','','2023-12-06 09:50:39','2023-12-06 09:50:39','');
INSERT INTO users VALUES('1990','REGINA ','NOFIANUS ','AA00057','regina.egy@timas.com','','$2y$10$aEtCv69aQ/8QSYRb3IjnH.bfO1.2ltDI7BqSJxnn1N5eUXCcE0.0e','','','2','','1','081291666391','','','','2023-12-06 09:50:39','2023-12-06 09:50:39','');
INSERT INTO users VALUES('1991','Admin','Payroll','admin_payroll','admin_payroll@gmail.com','','$2y$10$x/hZFnRMPufWc/FmuUGIueKRymrNed.8k8aQBhXIs.doGw/AfKiau','','','1','','1','','118.99.110.173','2023-12-12 12:40:13.00','','2023-12-12 12:38:02','2023-12-12 12:38:02','');
INSERT INTO users VALUES('1992','Richard F','Papilaya','aa3077','richard.papilaya@timas.com','','$2y$10$FgLLb0v03eBisJTm6WNbM.rBGfHQzucBy0VJ05Q8J9R9jY3K.q//u','','','4','','1','081288776655','202.169.50.228','2023-12-18 11:07:26.00','','2023-12-18 10:31:55','2024-02-05 11:03:29','');
INSERT INTO users VALUES('1993','Arif Rahman','SR','aa3078','arif.rahman@timas.com','','$2y$10$W9jN9YB5AgsU/tZiPyslBetSuOhVtRJNQwsk/z2yADrM0F2zyxLF2','','','2','','1','082373325808','','','','2024-02-05 10:04:34','2024-02-05 10:56:47','');
INSERT INTO users VALUES('1994','AZMANDA','AZMANDA','ae00555','azmanda@timas.com','','$2y$10$KU/cROQZQmWL2HQ57JaMuO7vIlnyDA.bbx8tp8N4MQAtnpQx07NX2','','','2','','1','085712340987','103.113.77.126','2024-02-05 11:11:06.00','','2024-02-05 10:28:57','2024-02-05 11:02:47','');
INSERT INTO users VALUES('1995','Richard F','Papilaya','aa3079','richard.papilaya@timas.com','','$2y$10$7w9T2w4Kh1T/ACE0zMDCQ.4eX4vUwq.vKLZ09XHWU1arqRMsfCHNq','','','2','','1','','','','','2024-02-05 14:43:11','2024-02-05 14:43:11','');
INSERT INTO users VALUES('1996','AFRIANTO','SIMBOLON','AE03029','afrianto.simbolon@timas.com','','$2y$10$EsLblGp85ZrgHfGehUPGFO2cX2C2FIekGKZ9tWk67koY3SZZ6C4U.','','','2','','1','082280107578','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('1997','Diahayu','Paramudita','AE00779','diahayu.paramudita@timas.com','','$2y$10$g4E0gBKvKRmHyhqqdBRryu/NqQDEIZYXFBCVAmnnAnMPsQcAqUD9u','','','2','','1','085363049624','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('1998','Putri','Arta Manullang','AE02752','putri.manullang@timas.com','','$2y$10$i9ivKl5xjSXcvVGHfJ3F3uPvwble035c8It8peJcs8qkIDDPp20aC','','','2','','1','081212121212','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('1999','Berri','Pratama Putra','AE02769','berri@timas.com','','$2y$10$vjK37Nl4FcPzozVEJDR3nOu4/Ie3dXKfPf.T5HFGmFAPEXZfM.BEi','','','2','','1','081272221353','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2000','Isra','Alfarizi','AE02566','isra.alfarizi@timas.com','','$2y$10$azz7/h0fkrMRboKTlGzRgeuD1a2KaAQ/0CxF9FAydTt21PgtPlPaO','','','2','','1','085349913025','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2001','Rezki','Saputra Noflin','AE02774','rezki.noflin@timas.com','','$2y$10$tTcqc34HjhAaLo7ams/Vkec/sLaAigsIzbsSG2Hd6AnZZgyLOFSUS','','','2','','1','081368094492','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2002','Grant','Samuel Samosir','AE00435','grant.samosir@timas.com','','$2y$10$vY.UJFofz4VhTcggEmOr7eUbWSyVNjg30BHTBYEk9mOMSsPHoHfM.','','','2','','1','081368094492','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2003','Ade','Syaputri','AE02606','ade.syaputri@timas.com','','$2y$10$ZG95u6uHCJLYKl/MWvujJuch3ZkgwuYaIUMtOgAhA9.TUoVRhkBl.','','','2','','1','081261583678','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2004','Aidil','Raka','AE01059','aidil@timas.com','','$2y$10$5npeOk7L0C5d2WnaC4V07e6ofRP8RpA3l7TTuptnOGGdkrVp/OW2O','','','2','','1','082284658586','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2005','SUNARYA','SUNARYA','AE09103','sunarya@timas.com','','$2y$10$88DWPr1mI8zt.aQb9j3PzOc48kPPkx1EElVP/9gXYrI6co3MtEG/G','','','2','','1','081368094492','','','','2024-02-05 14:51:31','2024-02-05 14:51:31','');
INSERT INTO users VALUES('2006','AFRIANTO','SIMBOLON','AE03029','afrianto.simbolon@timas.com','','$2y$10$kkgiIdwNTaeGLSLGGYbZi.1cVyyY9kHvlxyunzKlVN/h.fBnHTaky','','','2','','1','082280107578','','','','2024-02-05 14:59:06','2024-02-05 14:59:06','');
INSERT INTO users VALUES('2007','Diahayu','Paramudita','AE00779','diahayu.paramudita@timas.com','','$2y$10$NcaMgCpwa2Xg6zN5XiVVBe/wAzxnzCoeg7MU2gY5YyYgpf.bwnBp6','','','2','','1','085363049624','','','','2024-02-05 14:59:06','2024-02-05 14:59:06','');
INSERT INTO users VALUES('2008','Putri','Arta Manullang','AE02752','putri.manullang@timas.com','','$2y$10$Clpialz4u5WN91TSc7tlnOV/hRkd4lsTHmnpEq.8HANZF9Jaf8JCi','','','2','','1','081212121212','','','','2024-02-05 14:59:06','2024-02-05 14:59:06','');
INSERT INTO users VALUES('2009','Berri','Pratama Putra','AE02769','berri@timas.com','','$2y$10$fIYfBAyLnAvUR39FMgIDTuz0qNuZeI24d6vjSicsSTj9j39mbl/vC','','','2','','1','081272221353','','','','2024-02-05 14:59:06','2024-02-05 14:59:06','');
INSERT INTO users VALUES('2010','Isra','Alfarizi','AE02566','isra.alfarizi@timas.com','','$2y$10$LwwA1WyRm7EA9h30Y.j6K.LEMg1lF5e00IOJvGpa5FPHyKZyvCGy6','','','2','','1','085349913025','','','','2024-02-05 14:59:06','2024-02-05 14:59:06','');
INSERT INTO users VALUES('2011','Rezki','Saputra Noflin','AE02774','rezki.noflin@timas.com','','$2y$10$eJNfrZ/1ZFqSwJJ9qnx35.fa.EN.fN6zOwhgIRVnZU5sxQDU/atoe','','','2','','1','081368094492','','','','2024-02-05 14:59:07','2024-02-05 14:59:07','');
INSERT INTO users VALUES('2012','Grant','Samuel Samosir','AE00435','grant.samosir@timas.com','','$2y$10$qh61/HDyego7wyaykSBi..RaYO9GcFe2ENRJmjDniHz3lEeLNeE86','','','2','','1','081368094492','','','','2024-02-05 14:59:07','2024-02-05 14:59:07','');
INSERT INTO users VALUES('2013','Ade','Syaputri','AE02606','ade.syaputri@timas.com','','$2y$10$XiJyJQcTeddOSDTjtXkChuaWBl5klsmpxdfZQ7U5RHq1PHeHIsofW','','','2','','1','081261583678','','','','2024-02-05 14:59:07','2024-02-05 14:59:07','');
INSERT INTO users VALUES('2014','Aidil','Raka','AE01059','aidil@timas.com','','$2y$10$.1UAhlMLKZUmChLDcCA3w.L5ep12q0SLt1s7r2py1M8qzrmOCD4ji','','','2','','1','082284658586','','','','2024-02-05 14:59:07','2024-02-05 14:59:07','');
INSERT INTO users VALUES('2015','SUNARYA','SUNARYA','AE09103','sunarya@timas.com','','$2y$10$F/Py.0xknDaL03CM3VdvA.DZ7HsSKGYIGaN711zAmy2c7gAVPAsVm','','','2','','1','081368094492','','','','2024-02-05 14:59:07','2024-02-05 14:59:07','');
INSERT INTO users VALUES('2016','EDWIN','SITORUS','AE02989','edwin.sitorus@timas.com','','$2y$10$.1h9jILsaqpRMquCI3BWeu1A9/Uhg/EdRjjxSdZd5Zy4KUw3Kbzo6','','','2','','1','0','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2017','ZULHENDRI','ZULHENDRI','ae02997','zulhendri.zulhendri@timas.com','','$2y$10$v9kTEGtDGSASGIKVnAVnbeZGMOmr.GViG.dpH.IPvB6g9lrnqhkwi','','','2','','1','0812344556778','','','','2024-02-05 15:17:02','2024-02-05 15:20:54','');
INSERT INTO users VALUES('2018','Bezalel','Pandiangan','AE00967','bezalel.pandiangan@timas.com','','$2y$10$mJNTjuBNiPSUlslj/0QDBuqTgUXwTP26LI0FnxWHnJgZWyRgJwAeC','','','2','','1','085210328729','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2019','Junansi','Gultom','AE00267','junansi.gultom@timas.com','','$2y$10$ZeCWD8msag2Z3xPuUZ2t/eMtkVUMGrXWWDmFFt6jjYZbhcZ/x4kdi','','','2','','1','0821276948993','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2020','Hiskia','Munthe','AE00831','hiskia.munthe@timas.com','','$2y$10$PlFCRYPJVKn5spgo1CKdqOsIa2cLk2eZAi5KeM0kj7YNnZ16PSl2y','','','2','','1','082383461485','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2021','Irfandy','Manurung','AE00366','irfandy.manurung@timas.com','','$2y$10$g2EH.Bs0cWMNNgzmYLCtseQLok.hsHWSXqsuuvSOMoEOAZrrepD8i','','','2','','1','082176705093','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2022','Wilgianti','Wilgianti','AE05152','wilgianti.wilgianti@timas.com','','$2y$10$szyRkhMjf81qHr1VvNKnb.CIQoQva6UfuePiljNMXmJrhW6PGlMxO','','','2','','1','0','','','','2024-02-05 15:17:02','2024-02-05 15:17:02','');
INSERT INTO users VALUES('2023','Amin','Rosidin','AE00253','amin.rosidin@timas.com','','$2y$10$jz/ivHMwMH4h4bja.iniPOSIKIVhOEEttsnWx2eV5PchjL7ZfLU4i','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2024','Sartono','Sartono','AE02403','sartono.sartono@timas.com','','$2y$10$2aFFtqU0IN3pBDKdAANXPeougov5L2qQA.bvauXtF9GfzmP2KSf5i','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2025','Didi','Prabowo','AE02571','didi.prabowo@timas.com','','$2y$10$0rxsqJlN5rv1jZyRbAqHy.bgnWVY7nfjc7eyf/FDBSUdooVaROF96','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2026','Engkus','Kusnadi','AE02396','engkus.kusnadi@timas.com','','$2y$10$G8ItREGj.8jt9ArtXgOtZe.WQu5Gb7Cw4ZA6Afu1iU2zTY1O4Xp2e','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2027','Dayat','Dayat','AE02650','dayat.dayat@timas.com','','$2y$10$wQR2d9LXPN92BeLvOV/i4OdMABzGl24hspt3DcZD.wB0vJX98iPrS','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');
INSERT INTO users VALUES('2028','Aten','Wawan Kusuma','AE02061','aten.wawan kusuma@timas.com','','$2y$10$WJiBDqeSpwalFEs6vuAt9.t0HfeFb/d1QT5g9qz6Qiu5EfXq7ZiEO','','','2','','1','0','','','','2024-02-05 15:17:03','2024-02-05 15:17:03','');



CREATE TABLE `warnings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(191) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` bigint(20) unsigned NOT NULL,
  `warning_to` bigint(20) unsigned NOT NULL,
  `warning_type` bigint(20) unsigned DEFAULT NULL,
  `warning_date` date NOT NULL,
  `status` varchar(40) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warnings_company_id_foreign` (`company_id`),
  KEY `warnings_warning_to_foreign` (`warning_to`),
  KEY `warnings_warning_type_foreign` (`warning_type`),
  CONSTRAINT `warnings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `warnings_warning_to_foreign` FOREIGN KEY (`warning_to`) REFERENCES `employees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `warnings_warning_type_foreign` FOREIGN KEY (`warning_type`) REFERENCES `warnings_type` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `warnings_type` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warning_title` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


SET foreign_key_checks = 1;