@extends('layout.main')
@section('content')
    <section>
        <div class="container-fluid">
            <div class="d-flex justify-content-between mb-30px">
                <div>
                    <h1 class="thin-text">{{ trans('file.Welcome') }} {{ auth()->user()->username }}</h1>
                </div>
                <div>
                    <h4 class="thin-text">{{ __('Today is') }} {{ now()->englishDayOfWeek }}
                        {{ now()->format(env('Date_Format')) }}</h4>
                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <form method="post" action="{{ url('admin/dashboard') }}" id="filter_form" class="form-horizontal">
                        @csrf
                        <div class="row align-items-center">
                            <div class="col-md-3">
                                <div class="form-group mb-0">
                                    <input class="form-control date" placeholder="{{ __('Start Date') }}" readonly=""
                                        id="start_date" name="start_date" type="text" required
                                        value="{{ $start_date }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group mb-0">
                                    <input class="form-control date" placeholder="{{ __('End Date') }}" readonly=""
                                        id="end_date" name="end_date" type="text" required value="{{ $end_date }}">
                                </div>
                            </div>
							<div class="col-md-3">
                                <div class="form-group mb-0">
                                    <div class="form-group">
										<select class="form-control ss selectpicker dynamic" name="filter_gender" id="filter_gender" data-placeholder="Gender"
											data-column="1" tabindex="-1" aria-hidden="true">
											<option value="">{{ __('Gender') }}</option>
											<option value="Male">{{ __('Male') }}</option>
											<option value="Female">{{ __('Female') }}</option>
											{{ csrf_field() }}
										</select>
									</div>
                                </div>
                            </div>
							<div class="col-md-3">
                                <div class="form-group mb-0">
                                    <div class="form-group">
										<select class="form-control ss selectpicker dynamic" name="filter_marital" id="filter_marital" data-placeholder="Marital Status"
											data-column="1" tabindex="-1" aria-hidden="true">
											<option value="">{{ __('Marital Status') }}</option>
											<option value="married">{{ __('Married') }}</option>
											<option value="single">{{ __('Single') }}</option>
											<option value="divorced">{{ __('Divorced') }}</option>
											{{ csrf_field() }}
										</select>
									</div>
                                </div>
                            </div>
							<div class="col-md-3">
                                <div class="form-group mb-0">
                                    <div class="form-group">
										<select class="form-control ss selectpicker dynamic" name="filter_religion" id="filter_religion" data-placeholder="Religion"
											data-column="1" tabindex="-1" aria-hidden="true">
											<option value="">{{ __('Religion') }}</option>
											<option value="islam">{{ __('Islam') }}</option>
											<option value="kristen">{{ __('Kristen') }}</option>
											<option value="katholik">{{ __('Katholik') }}</option>
											<option value="hindu">{{ __('Hindu') }}</option>
											<option value="budha">{{ __('Budha') }}</option>
											<option value="konghucu">{{ __('Konghucu') }}</option>
											{{ csrf_field() }}
										</select>
									</div>
                                </div>
                            </div>
                        </div>
						<div class="clearfix">&nbsp;</div>
						<div class="row align-items-center">
							
                            <div class="col-md-3">
                                <button type="submit" class="filtering btn btn-primary">
                                    {{ __('Filter') }}
                                </button>
                            </div>
                            <div class="col-md-3">
                                <h3>{{ __('Employee Amount') }} : {{ $employees->count() }}</h3>
                            </div>
						</div>
                    </form>
                </div>
            </div>
			<div class="row">
					@foreach($companies as $company)
						<div class="col-md-3 align-items-center">
							<div class="card card-item" id="card_absent">
								<div class="card-body">
									<div class="row">
										<div class="col-md-6">
											<!--<h3 id="employee_count">{{ $company->employees()->where('is_active', 1)->whereNull('exit_date')->whereIn('gender', $gender)->whereIn('marital_status', $marital)->whereIn('religion', $religion)->count() }}</h3>-->
                                            @php($company_ids = (int)$company->id)
                                            <h3 id="employee_count">{{ $employees_count[$company->id] }}</h3>
											<p class="mb-0">{{ $company->company_name }}</p>
											<br>
										</div>
										<div class="col-md-6">
											@if($company->company_logo != null)
												<img class="card-img-top" src="{{ asset('uploads/company_logo') }}/{{ $company->company_logo }}" alt="Company Logo">
											@else
												<img class="card-img-top" src="{{ asset('logo/avatar.jpg') }}" alt="Card image">
											@endif
										</div>
									</div>
								</div>
							</div>
						</div>
					@endforeach
			</div>

            <!-- <div class="row">
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_absent">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="absent_count">{{ $absent_count }}</h3>
                                    <p class="mb-0">{{ __('Absent') }}</p>
                                    <br>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="absentChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_under_work">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="under_work_count">{{ $under_work_count }}</h3>
                                    <p class="mb-0">{{ __('Work Time < 9 Hours') }}</p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="underWorkChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_late">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="late_count">{{ $late_count }}</h3>
                                    <p class="mb-0">{{ __('Late') }}</p>
                                    <br>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="lateChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_over_work">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="over_work_count">{{ $over_work_count }}</h3>
                                    <p class="mb-0">{{ __('Work Time > 11 Hours') }}</p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="overWorkChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_in_after_eight">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="in_after_eight_count">{{ $in_after_eight_count }}</h3>
                                    <p class="mb-0">{{ __('Clock In After 08:15') }}</p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="inAfterEightChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_out_before_five">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="out_before_five_count">{{ $out_before_five_count }}</h3>
                                    <p class="mb-0">{{ __('Clock Out Before 17:15') }}</p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="outBeforeFiveChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_in_after_three">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="out_before_five_count">{{ $in_after_three_count }}</h3>
                                    <p class="mb-0">{{ __('Clock In After 15:15') }}</p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="inAfterThreeChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_out_before_eleven">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="out_before_five_count">{{ $out_before_eleven_count }}</h3>
                                    <p class="mb-0">{{ __('Clock Out Before 23:15') }}</p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="outBeforeElevenChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_in_after_eleven">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="in_after_eleven_count">{{ $in_after_eleven_count }}</h3>
                                    <p class="mb-0">{{ __('Clock In After 23:15') }}</p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="inAfterElevenChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_out_before_eight">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="out_before_eight_count">{{ $out_before_eight_count }}</h3>
                                    <p class="mb-0">{{ __('Clock Out Before 08:15') }}</p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="outBeforeEightChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div> -->
        </div>
    </section>

    <div id="modal_detail" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title">{{ __('Add Employee') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <div class="table-responsive">
                        <table id="dashboard-table" class="table ">
                            <thead>
                                <tr>
                                    <th>{{ __('Employee') }}</th>
                                    <th>{{ __('Total') }}</th>
                                    <th>{{ __('Detail') }}</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">

        (function($) {
            "use strict";
            $(document).ready(function() {
                let date = $('.date');
                date.datepicker({
                    format: '{{ env('Date_Format_JS') }}',
                    autoclose: true,
                    todayHighlight: true,
                    endDate: new Date()
                });

            });
        })(jQuery);

        $('.card-item-test').click(function() {
            $('#modal_detail').modal('show');
            var title = $(this).find('p:first').text();
            var id = $(this).attr('id');
            $('.modal-title').text("{{ __('Detail') }}" + ' ' + title);
            var startDate = $('#start_date').val();
            var endDate = $('#end_date').val();
            var type;
            switch (id) {
                case 'card_absent':
                    type = 'absent';
                    break;
                case 'card_under_work':
                    type = 'under_work';
                    break;
                case 'card_late':
                    type = 'late';
                    break;
                case 'card_over_work':
                    type = 'over_work';
                    break;
                case 'card_in_after_eight':
                    type = 'in_after_eight';
                    break;
                case 'card_out_before_five':
                    type = 'out_before_five';
                    break;
                case 'card_in_after_three':
                    type = 'in_after_three';
                    break;
                case 'card_out_before_eleven':
                    type = 'out_before_eleven';
                    break;
                case 'card_in_after_eleven':
                    type = 'in_after_eleven';
                    break;
                case 'card_out_before_eight':
                    type = 'out_before_eight';
                    break;
                default:
                    type = 'absent';
            }
            fill_datatable(startDate, endDate, type);
        });

        function fill_datatable(startDate = '', endDate = '', type = 'absent') {

            let table_table = $('#dashboard-table').DataTable({
                responsive: true,
                fixedHeader: {
                    header: true,
                },
                processing: true,
                serverSide: true,
                bDestroy: true,
                ajax: {
                    url: "{{ url('admin/dashboard/detail') }}",
                    data: {
                        type: type,
                        start_date: startDate,
                        end_date: endDate,
                        "_token": "{{ csrf_token() }}"
                    }
                },

                columns: [{
                        data: 'employee_name',
                        name: 'employee_name'
                    },
                    {
                        data: 'total',
                        name: 'total',
                    },
                    {
                        data: 'detail',
                        name: 'detail'
                    },
                ],


                "order": [],
                'language': {
                    'lengthMenu': '_MENU_ {{ __('records per page') }}',
                    "info": '{{ trans('file.Showing') }} _START_ - _END_ (_TOTAL_)',
                    "search": '{{ trans('file.Search') }}',
                    'paginate': {
                        'previous': '{{ trans('file.Previous') }}',
                        'next': '{{ trans('file.Next') }}'
                    }
                },

                'columnDefs': [{
                    "orderable": true,
                }],

                'select': {
                    style: 'multi',
                    selector: 'td:first-child'
                },
                'lengthMenu': [
                    [10, 25, 50, -1],
                    [10, 25, 50, "All"]
                ],
            });
            new $.fn.dataTable.FixedHeader(table_table);
        }

        let charts = ['absentChart', 'underWorkChart', 'lateChart', 'overWorkChart', 'inAfterEightChart',
            'outBeforeFiveChart', 'inAfterThreeChart', 'outBeforeElevenChart', 'inAfterElevenChart',
            'outBeforeEightChart'
        ];
        let chartLabels = ["{{ __('Absent') }}", "{{ __('Work Time < 9 Hours') }}", "{{ __('Late') }}",
            "{{ __('Work Time > 11 Hours') }}", "{{ __('Clock In After 08:15') }}",
            "{{ __('Clock Out Before 17:15') }}", "{{ __('Clock In After 15:15') }}",
            "{{ __('Clock Out Before 23:15') }}", "{{ __('Clock In After 23:15') }}",
            "{{ __('Clock Out Before 08:15') }}"
        ];
        let chartData = [
            "{{ $absent_count }}" / ("{{ $employees->count() }}" * "{{ $total_days }}"),
            "{{ $under_work_count }}" / "{{ $attendance_count != 0 ? $attendance_count : '1' }}",
            "{{ $late_count }}" / "{{ $attendance_count != 0 ? $attendance_count : '1' }}",
            "{{ $over_work_count }}" / "{{ $attendance_count != 0 ? $attendance_count : '1' }}",
            "{{ $in_after_eight_count }}" / "{{ $attendance_count != 0 ? $attendance_count : '1' }}",
            "{{ $out_before_five_count }}" / "{{ $attendance_count != 0 ? $attendance_count : '1' }}",
            "{{ $in_after_three_count }}" / "{{ $attendance_count != 0 ? $attendance_count : '1' }}",
            "{{ $out_before_eleven_count }}" / "{{ $attendance_count != 0 ? $attendance_count : '1' }}",
            "{{ $in_after_eleven_count }}" / "{{ $attendance_count != 0 ? $attendance_count : '1' }}",
            "{{ $out_before_eight_count }}" / "{{ $attendance_count != 0 ? $attendance_count : '1' }}"
        ];
        let chartColors = ["#e3342f", "#3490dc", "#6c757d", "#ffed4a", "#6cb2eb", "#e3342f", "#3490dc", "#6c757d",
            "#ffed4a", "#6cb2eb"
        ];

        for (let i = 0; i < charts.length; i++) {
            new Chart(charts[i], {
                type: 'doughnut',
                data: {
                    datasets: [{
                        label: chartLabels[i],
                        percent: (chartData[i] * 100).toFixed(0),
                        backgroundColor: [chartColors[i]]
                    }]
                },
                plugins: [{
                        beforeInit: (chart) => {
                            const dataset = chart.data.datasets[0];
                            chart.data.labels = [dataset.label];
                            dataset.data = [dataset.percent, 100 - dataset.percent];
                        }
                    },
                    {
                        beforeDraw: (chart) => {
                            var width = chart.chart.width,
                                height = chart.chart.height,
                                ctx = chart.chart.ctx;
                            ctx.restore();
                            var fontSize = (height / 75).toFixed(2);
                            ctx.font = fontSize + "em sans-serif";
                            ctx.fillStyle = "#9b9b9b";
                            ctx.textBaseline = "middle";
                            var text = chart.data.datasets[0].percent + "%",
                                textX = Math.round((width - ctx.measureText(text).width) / 2),
                                textY = height / 2;
                            ctx.fillText(text, textX, textY);
                            ctx.save();
                        }
                    }
                ],
                options: {
                    maintainAspectRatio: false,
                    cutoutPercentage: 70,
                    legend: {
                        display: false,
                    },
                    tooltips: {
                        filter: tooltipItem => tooltipItem.index == 0
                    }
                }
            });
        }
    </script>
@endsection
