@extends('layout.main')
@section('content')
    <section>
        <div class="container-fluid">

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('Import EXCEL/CSV file (Manual)') }}</h3>
                </div>
                <div class="card-body">
                    <h6><a href="{{ url('sample_file/sample_attendance.xlsx') }}" class="btn btn-primary"> <i
                                class="fa fa-download"></i> {{ __('Download Sample File') }} </a></h6>
                    <p class="card-text">The first line in downloaded sample file should remain as it is. Please do not
                        change
                        the order of columns in file.</p>
                    {{-- <p class="card-text">The correct column order is (Staff Id, Attendance Date, Clock In, Clock Out).</p> --}}
                    <ul>
                        <li>Date format should be (According to general settings)</li>
                        <li>You must follow the file, otherwise you will get an error while importing the file.</li>
                    </ul>

                    <form action="{{ route('attendances.importPost') }}" autocomplete="off" enctype="multipart/form-data"
                        method="post" accept-charset="utf-8">
                        @csrf
                        @if (auth()->user()->role_users_id == 1)
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>{{ trans('file.Company') }}</label>
                                        <select name="company_id" id="company_add_id"
                                            class="form-control selectpicker dynamic_add" data-live-search="true"
                                            data-live-search-style="contains" data-dependent="department_name"
                                            title='{{ __('Selecting', ['key' => trans('file.Company')]) }}...'>
                                            @foreach ($companies as $company)
                                                <option value="{{ $company->id }}">{{ $company->company_name }}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <fieldset class="form-group">
                                        <label for="logo">{{ trans('file.Upload') }} {{ trans('file.File') }}</label>
                                        <input type="file" class="form-control-file" id="file" name="file"
                                            accept=".xlsx, .xls, .csv, .dat">
                                        <small>{{ __('Please select excel/csv/dat') }} file (allowed file size 2MB)</small>
                                    </fieldset>
                                </div>
                            </div>
                        </div>
                        <div class="mt-1">
                            <div class="form-actions box-footer">
                                <button name="import_form" type="submit" class="btn btn-primary"><i
                                        class="fa fa fa-check-square-o"></i> {{ trans('file.Save') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>


@endsection
