@extends('layout.main')
@section('content')
    <section>
        <div class="container-fluid">
            <div class="card mb-4">
                <div class="card-header with-border">
                    <h3 class="card-title text-center"> {{ __('Report Attendance') }} </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <form method="post" id="filter_form" class="form-horizontal">
                                @csrf
                                <div class="row">
                                    @if (Auth::user()->can('report-attendance'))
                                        <div class="col-md-6" id="dropdown_company">
                                            <div class="form-group">
                                                <label>{{ trans('file.Company') }} *</label>
                                                <select name="company_id" id="company_id"
                                                    class="form-control selectpicker dynamic" data-live-search="true"
                                                    data-live-search-style="contains" data-first_name="first_name"
                                                    data-last_name="last_name" data-dependent="department_name"
                                                    title='{{ __('Selecting', ['key' => trans('file.Company')]) }}...'>
                                                    @php($i = 0)
                                                    @foreach ($companies as $company)
                                                        <option value="{{ $company->id }}" @if($i == 0) selected @endif>{{ $company->company_name }}
                                                        </option>
                                                    @php($i++)
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    @endif
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="start_date">{{ __('Start Date') }}</label>
                                            <input class="form-control month_year date" placeholder="Select Date"
                                                readonly="" id="start_date" name="start_date" type="text" required
                                                value="">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="start_date">{{ __('End Date') }}</label>
                                            <input class="form-control month_year date" placeholder="Select Date"
                                                readonly="" id="end_date" name="end_date" type="text" required
                                                value="">
                                        </div>
                                    </div>

                                </div>

                                <div class="row mt-2">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="form-actions">
                                                <button type="submit" class="filtering btn btn-primary"><i
                                                        class="fa fa-search"></i> {{ trans('file.Search') }}
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <button id="button_back" class="btn btn-secondary"><i class="fa fa-arrow-left"></i>
                        {{ __('Back') }}
                    </button>
                    <a id="a_view_full"> <button class="btn btn-info"><i class="fa fa-eye"></i>
                            {{ __('View Full Page') }}
                        </button> </a>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table id="report_attendance-table" class="table ">
                {{-- <thead>
                    <tr>
                    </tr>
                </thead> --}}
            </table>
        </div>

    </section>

    <div id="formModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title">{{ __('Check Attendance') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <span id="form_result"></span>
                    <form method="post" id="sample_form" class="form-horizontal" enctype="multipart/form-data">

                        @csrf
                        <div class="row">
                            <div class="col-md-12 form-group">
                                <label class="text-bold">{{ __('Employee Name') }}</label>
                                <input type="text" name="employee_name" id="employee_name"
                                    placeholder="{{ __('Employee Name') }}" readonly class="form-control">
                            </div>
                            <div class="col-md-12 form-group">
                                <label class="text-bold">{{ __('Attendance Date') }}</label>
                                <input type="text" name="attendance_date" id="attendance_date"
                                    placeholder="{{ __('Attendance Date') }}" readonly class="form-control">
                            </div>
                            <div class="col-md-12 form-group">
                                <label class="text-bold">{{ __('Status') }}</label>
                                <input type="text" name="status" id="status" placeholder="{{ __('Status') }}"
                                    readonly class="form-control">
                            </div>

                            <div class="col-md-12 form-group">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="is_checked"
                                        id="is_checked" value="1">
                                    <label class="custom-control-label text-bold"
                                        for="is_checked">{{ __('Check') }}</label>
                                </div>
                            </div>

                            <div class="container">
                                <div class="form-group">
                                    <input type="hidden" name="employee_id" id="employee_id" />
                                    <input type="submit" name="action_button" id="action_button"
                                        class="btn btn-warning w-100" value="{{ trans('file.Save') }}" />
                                </div>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>


    <script type="text/javascript">
        (function($) {
            "use strict";
            $(document).ready(function() {

                let date = $('.date');
                date.datepicker({
                    format: '{{ env('Date_Format_JS') }}',
                    autoclose: true,
                    todayHighlight: true,
                    endDate: new Date()
                });
                // date.datepicker("setDate", "1");
            });

            let isEmployee = false;
            let departmentId;
            let startDate;

            fill_datatable($('#start_date').val(), $('#end_date').val(), $('#company_id').val());

            function fill_datatable(start_date = '', end_date = '', company_id = '') {
                $('#button_back').addClass('d-none')
                $('#dropdown_company').removeClass('d-none')
                isEmployee = false;
                if ($.fn.DataTable.isDataTable('#report_attendance-table')) {
                    $('#report_attendance-table').DataTable().clear().destroy();
                }
                $('#report_attendance-table tr').remove();
                $.ajax({
                    url: "{{ route('report_attendance.header') }}",
                    data: {
                        start_date: start_date,
                        end_date: end_date,
                        "_token": "{{ csrf_token() }}"
                    },
                    success: function(data) {
                        var columns = [];
                        columns.push({
                            "data": "department",
                            "title": "Department"
                        })
                        for (var i in data['dates']) {
                            columns.push({
                                "data": data['dates'][i],
                                "title": data['dates'][i]
                            })
                        }
                        let holidays = data['holidays'];
                        let table_table = $('#report_attendance-table').DataTable({
                            // responsive: true,
                            fixedHeader: {
                                header: true,
                            },
                            processing: true,
                            serverSide: true,
                            ajax: {
                                url: "{{ route('report_attendance.index') }}",
                                data: {
                                    start_date: start_date,
                                    end_date: end_date,
                                    company_id: company_id,
                                    "_token": "{{ csrf_token() }}"
                                },
                            },
                            columns: columns,
                            createdRow: (row, data, dataIndex, cells) => {
                                holidays.forEach(element => {
                                    $(cells[element]).css('background-color', '#FFFF00')
                                });
                            },
                            'language': {
                                'lengthMenu': '_MENU_ {{ __('records per page') }}',
                                "info": '{{ trans('file.Showing') }} _START_ - _END_ (_TOTAL_)',
                                "search": '{{ trans('file.Search') }}',
                                'paginate': {
                                    'previous': '{{ trans('file.Previous') }}',
                                    'next': '{{ trans('file.Next') }}'
                                }
                            },
                            'lengthMenu': [
                                [10, 25, 50, -1],
                                [10, 25, 50, "All"]
                            ],
                            dom: '<"row"lfB>rtip',
                            buttons: [{
                                    extend: 'pdf',
                                    text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                                    exportOptions: {
                                        columns: ':visible:Not(.not-exported)',
                                        rows: ':visible'
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'csv',
                                    text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                                    exportOptions: {
                                        columns: ':visible:Not(.not-exported)',
                                        rows: ':visible'
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'print',
                                    text: '<i title="print" class="fa fa-print"></i>',
                                    exportOptions: {
                                        columns: ':visible:Not(.not-exported)',
                                        rows: ':visible'
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'colvis',
                                    text: '<i title="column visibility" class="fa fa-eye"></i>',
                                    columns: ':gt(0)'
                                },
                            ],
                        });
                    }
                });
            }

            $('#report_attendance-table').on('click', 'tr', function() {
                if (!isEmployee) {
                    var table = $('#report_attendance-table').DataTable();
                    var data = table.row(this).data();
                    var id = data.id;
                    departmentId = id;
                    fill_datatable_employee('', '', id);
                }

            });

            $('#report_attendance-table').on('draw.dt', function() {
                $('[data-toggle="tooltip"]').tooltip();
            });

            $('#report_attendance-table').on('click', 'td', function() {
                if (isEmployee) {
                    //Cell
                    var table = $('#report_attendance-table').DataTable();
                    var cell = table.cell(this).data();

                    //column header
                    var col = table.cell(this).index().column + 1;
                    var columnHeader = $("#report_attendance-table thead th:nth-child(" + col + ")").text();

                    //Row
                    var tr = $(this).closest('tr');
                    var row = table.row(tr).data();

                    if (cell.includes('danger')) {
                        status = cell.replace(/<\/?[^>]+(>|$)/g, "");
                        $('#employee_id').val(row['id']);
                        $('#employee_name').val(row['employee_name']);
                        $('#attendance_date').val(columnHeader);
                        $('#status').val(status);
                        $('#formModal').modal('show');
                    }
                }
            });

            function fill_datatable_employee(start_date = '', end_date = '', department_id = '') {
                isEmployee = true;
                $('#button_back').removeClass('d-none')
                $('#dropdown_company').addClass('d-none')
                $('#report_attendance-table').DataTable().clear().destroy();
                $('#report_attendance-table tr').remove();
                $.ajax({
                    url: "{{ route('report_attendance.header') }}",
                    data: {
                        start_date: start_date,
                        end_date: end_date,
                        department_id: department_id,
                        is_employee: true,
                        "_token": "{{ csrf_token() }}"
                    },
                    success: function(data) {
                        var columns = [];
                        columns.push({
                            "data": "employee_name",
                            "title": "Employee"
                        })
                        columns.push({
                            "data": "remaining_leave",
                            "title": "Remaining Leaves"
                        })
                        columns.push({
                            "data": "department",
                            "title": "Department"
                        })
                        for (var i in data['dates']) {
                            columns.push({
                                "data": data['dates'][i],
                                "title": data['dates'][i]
                            })
                        }
                        let holidays = data['holidays'];
                        let table_table = $('#report_attendance-table').DataTable({
                            fixedHeader: {
                                header: true,
                            },
                            processing: true,
                            serverSide: true,
                            ajax: {
                                url: "{{ route('report_attendance.index') }}",
                                data: {
                                    start_date: start_date,
                                    end_date: end_date,
                                    department_id: department_id,
                                    is_employee: true,
                                    "_token": "{{ csrf_token() }}"
                                },
                            },
                            columns: columns,
                            createdRow: (row, data, dataIndex, cells) => {
                                holidays.forEach(element => {
                                    $(cells[element]).css('background-color', '#FFFF00')
                                });
                            },
                            'language': {
                                'lengthMenu': '_MENU_ {{ __('records per page') }}',
                                "info": '{{ trans('file.Showing') }} _START_ - _END_ (_TOTAL_)',
                                "search": '{{ trans('file.Search') }}',
                                'paginate': {
                                    'previous': '{{ trans('file.Previous') }}',
                                    'next': '{{ trans('file.Next') }}'
                                }
                            },
                            'lengthMenu': [
                                [10, 25, 50, -1],
                                [10, 25, 50, "All"]
                            ],
                            dom: '<"row"lfB>rtip',
                            buttons: [{
                                    extend: 'pdf',
                                    text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                                    exportOptions: {
                                        columns: ':visible:Not(.not-exported)',
                                        rows: ':visible'
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'csv',
                                    text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                                    exportOptions: {
                                        columns: ':visible:Not(.not-exported)',
                                        rows: ':visible'
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'print',
                                    text: '<i title="print" class="fa fa-print"></i>',
                                    exportOptions: {
                                        columns: ':visible:Not(.not-exported)',
                                        rows: ':visible'
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'colvis',
                                    text: '<i title="column visibility" class="fa fa-eye"></i>',
                                    columns: ':gt(0)'
                                },
                            ],
                        });
                    }
                });
            }

            function digitCheck(data) {
                if (data < 10) {
                    var result = '0' + data;
                } else {
                    var result = data;
                }
                return result;
            }

            $('#filter_form').on('submit', function(e) {
                e.preventDefault();
                var filter_start_date = $('#start_date').val();
                var filter_end_date = $('#end_date').val();
                var filter_month_year = $('#month_year').val();
                let company_id = $('#company_id').val();
                if (filter_start_date !== '' && filter_end_date === '' || filter_start_date === '' &&
                    filter_end_date !== '') {
                    alert('{{ __('Select Both filter option') }}');
                } else {
                    $('#report_attendance-table').DataTable().clear().destroy();
                    startDate = filter_start_date;
                    if (!isEmployee) {
                        fill_datatable(filter_start_date, filter_end_date, company_id);
                    } else {
                        fill_datatable_employee(filter_start_date, filter_end_date, departmentId)
                    }
                }
            });

            $('.dynamic').change(function() {
                if ($(this).val() !== '') {
                    let value = $(this).val();
                    let first_name = $(this).data('first_name');
                    let last_name = $(this).data('last_name');
                    let _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "{{ route('dynamic_employee') }}",
                        method: "POST",
                        data: {
                            value: value,
                            _token: _token,
                            first_name: first_name,
                            last_name: last_name
                        },
                        success: function(result) {
                            $('select').selectpicker("destroy");
                            $('#employee_id').html(result);
                            $('select').selectpicker();

                        }
                    });
                }
            });

            $('.dynamic').change(function() {
                if ($(this).val() !== '') {
                    let value = $(this).val();
                    let dependent = $(this).data('dependent');
                    let _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "{{ route('dynamic_department') }}",
                        method: "POST",
                        data: {
                            value: value,
                            _token: _token,
                            dependent: dependent
                        },
                        success: function(result) {

                            $('select').selectpicker("destroy");
                            $('#department_id').html(result);
                            $('select').selectpicker();

                        }
                    });
                }
            });

            $('.department_wise_employees').change(function() {
                if ($(this).val() !== '') {
                    let value = $(this).val();
                    let first_name = $(this).data('first_name');
                    let last_name = $(this).data('last_name');
                    let _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "{{ route('dynamic_employee_department') }}",
                        method: "POST",
                        data: {
                            value: value,
                            _token: _token,
                            first_name: first_name,
                            last_name: last_name
                        },
                        success: function(result) {

                            $('select').selectpicker("destroy");
                            $('#employee_id').html(result);
                            $('select').selectpicker();

                        }
                    });
                }
            });

            $("#button_back").click(function() {
                var filter_start_date = $('#start_date').val();
                var filter_end_date = $('#end_date').val();
                let company_id = $('#company_id').val();
                fill_datatable(filter_start_date, filter_end_date, company_id);
            });

            $("#a_view_full").click(function(e) {
                e.preventDefault();
                if (startDate == undefined) {
                    var today = new Date();
                    var dd = String(today.getDate()).padStart(2, '0');
                    var mm = String(today.getMonth() + 1).padStart(2, '0');
                    var yyyy = today.getFullYear();

                    startDate = yyyy + '-' + mm + '-' + dd;
                }

                var company = 0;
                if($('#company_id').val() != '')
                {
                    company = $('#company_id').val();
                }
                location.href = "{{ url('timesheet/full_report_attendances') }}" + "/" + company + "/" + startDate;
            });

            $('#sample_form').on('submit', function(event) {
                event.preventDefault();
                $.ajax({
                    url: "{{ route('report_attendance.check') }}",
                    method: "POST",
                    data: new FormData(this),
                    contentType: false,
                    cache: false,
                    processData: false,
                    dataType: "json",
                    success: function(data) {
                        var html = '';
                        if (data.errors) {
                            html = '<div class="alert alert-danger">';
                            for (var count = 0; count < data.errors.length; count++) {
                                html += '<p>' + data.errors[count] + '</p>';
                            }
                            html += '</div>';
                        }
                        if (data.error) {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if (data.success) {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                            $('#sample_form')[0].reset();
                            $('#formModal').modal('toggle');
                            fill_datatable_employee('', '', departmentId);
                        }
                        $('#form_result').html(html).slideDown(300).delay(5000).slideUp(300);
                    }
                });
            });


        })(jQuery);
    </script>
@endsection
