    
<?php $__env->startSection('content'); ?>
    <section>
        <div class="container-fluid">
            <div class="card mb-4">
                <div class="card-header with-border">
                    <h3 class="card-title text-center"> <?php echo e(__('Generate Payslip')); ?> </h3>
                </div>
                <span id="bulk_payment_result"></span>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <form method="post" id="filter_form" class="form-horizontal">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <select class="form-control ss selectpicker dynamic" name="filter_company" id="company_id" data-dependent="department_name" data-placeholder="Company"
                                                data-column="1" required tabindex="-1" aria-hidden="true">
                                                <option value="0"><?php echo e(__('All Companies')); ?></option>
                                                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($company->id); ?>"><?php echo e($company->company_name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e(csrf_field()); ?>

                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <select class="form-control selectpicker default_dept" name="filter_department" id="department_id" data-placeholder="Department" required tabindex="-1"
                                                aria-hidden="true">
                                                <option value="0"><?php echo e(__('All Departments')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <input class="form-control month_year date" placeholder="<?php echo e(__('Select Month')); ?>" readonly id="month_year" name="month_year" type="text" value="">
                                        </div>
                                    </div>
                                </div>

                                <div class="text-center">
                                    <div class="form-group">
                                        <div class="form-actions">
                                            <button id="payroll_export" type="submit" name="export" class="filtering btn btn-primary"> <i class="fa fa-file-excel-o"></i> <?php echo e(__('DOWNLOAD EXCEL')); ?> </button>
                                            <button id="payslip_filter" type="submit" class="filtering btn btn-primary"> <i class="fa fa-search"></i> <?php echo e(trans('file.Search')); ?> </button>
                                            <button id="bulk_payment" type="submit" class="filtering btn btn-primary"> <i class="fa fa-check-square-o"></i> <?php echo e(__('BULK PAYMENT')); ?> </button>
                                        </div>
                                    </div>
                                </div>
								<div class="row d-flex justify-content-between">
									<div class="text-left">
										Total Pembayaran BPJS Tenaga Kerja : <span id="total_bpjs_tk_comp"></span><br />
										Total Pembayaran BPJS Kesehatan : <span id="total_bpjs_kes_comp"></span><br />
									</div>
									<div class="text-right">
										Total Potongan BPJS Tenaga Kerja : <span id="total_bpjs_tk"></span><br />
										Total Potongan BPJS Kesehatan : <span id="total_bpjs_kes"></span><br />
									</div>
								</div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-title text-center">
            <h3><?php echo e(__('Payment Info')); ?> <span id="details_month_year"></span></h3>
        </div>
        <div class="container-fluid"><span id="general_result"></span></div>
        <div class="table-responsive">
            <table id="pay_list-table" class="table">
                <thead>
                    <tr>
                        <th class="not-exported"></th>
                        <th><?php echo e(trans('file.Name')); ?></th>
                        <th>Basic Salary</th>
                        <th><?php echo e(__('JHT')); ?> Company</th>
                        <th><?php echo e(__('JKK')); ?> Company</th>
                        <th><?php echo e(__('JKM')); ?> Company</th>
                        <th><?php echo e(__('Jaminan Pensiun')); ?> Company</th>
                        <th><?php echo e(__('JHT')); ?> Employee</th>
                        <!--<th><?php echo e(__('JKK')); ?> Employee</th>-->
                        <!--<th><?php echo e(__('JKM')); ?> Employee</th>-->
                        <th><?php echo e(__('Jaminan Pensiun')); ?> Employee</th>
                        <th>BPJS TK Total</th>
                        <!-- <th class="not-exported"><?php echo e(trans('file.action')); ?></th> -->
                    </tr>
                </thead>
            </table>
        </div>

    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="https://unpkg.com/pdfobject@2.2.12/pdfobject.min.js"></script>
    <script type="text/javascript">
        (function($) {
            "use strict";

            $(document).ready(function() {

                let date = $('.date');
                date.datepicker({
                    format: "MM-yyyy",
                    startView: "months",
                    minViewMode: 1,
                    autoclose: true,
                }).datepicker("setDate", new Date());

                fill_datatable();

                function fill_datatable(filter_company = '', filter_department = '', filter_month_year = '') {
                    $('#details_month_year').html($('#month_year').val());
                    let table_table = $('#pay_list-table').DataTable({
						
                        initComplete: function(settings, json) {
							console.log(json);
							$('#total_salary_sum').html(json.total_salary_sum);
							$('#total_monthly_pph').html(json.pph_monthly_sum);
							$('#total_bpjs_tk').html(json.bpjs_tk_sum);
							$('#total_bpjs_kes').html(json.bpjs_kes_sum);
							$('#total_bpjs_tk_comp').html(json.bpjs_tk_sum_comp);
							$('#total_bpjs_kes_comp').html(json.bpjs_kes_sum_comp);
                            this.api().columns([1]).every(function(data) {
                                console.log("DATA: ", data);
                                var column = this;
                                var select = $('<select><option value=""></option></select>')
                                    .appendTo($(column.footer()).empty())
                                    .on('change', function() {
                                        var val = $.fn.dataTable.util.escapeRegex(
                                            $(this).val()
                                        );

                                        column
                                            .search(val ? '^' + val + '$' : '', true, false)
                                            .draw();
                                    });

                                column.data().unique().sort().each(function(d, j) {
                                    select.append('<option value="' + d + '">' + d + '</option>');
                                    $('select').selectpicker('refresh');
                                });
                            });
                        },
                        responsive: true,
                        fixedHeader: {
                            header: true,
                            footer: true
                        },
                        processing: true,
                        serverSide: true,
                        ajax: {
                            url: "<?php echo e(route('payroll.bpjs')); ?>",
                            data: {
                                filter_company: filter_company,
                                filter_department: filter_department,
                                filter_month_year: filter_month_year,
                                "_token": "<?php echo e(csrf_token()); ?>"
                            }
                        },

                        columns: [{
                                data: 'id',
                                orderable: false,
                                searchable: false
                            },
                            {
                                data: 'employee_name',
                                name: 'employee_name'
                            },
                            {
                                data: 'salary',
                                name: 'salary'
                            },
                            {
                                data: 'jht_comp',
                                name: 'jht_comp',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            {
                                data: 'jkk_comp',
                                name: 'jkk_comp',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            {
                                data: 'jkm_comp',
                                name: 'jkm_comp',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            {
                                data: 'pensiun_comp',
                                name: 'pensiun_comp',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            {
                                data: 'jht',
                                name: 'jht',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            // {
                            //     data: 'jkk',
                            //     name: 'jkk',
                            //     render: function(data) {
                            //         if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                            //             return data + ' <?php echo e(config('variable.currency')); ?>';
                            //         } else {
                            //             return '<?php echo e(config('variable.currency')); ?> ' + data;

                            //         }
                            //     }
                            // },
                            // {
                            //     data: 'jkm',
                            //     name: 'jkm',
                            //     render: function(data) {
                            //         if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                            //             return data + ' <?php echo e(config('variable.currency')); ?>';
                            //         } else {
                            //             return '<?php echo e(config('variable.currency')); ?> ' + data;

                            //         }
                            //     }
                            // },
                            {
                                data: 'pensiun',
                                name: 'pensiun',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            {
                                data: 'bpjs_tk_tot',
                                name: 'bpjs_tk_tot',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            // {
                            //     data: 'action',
                            //     name: 'action',
                            //     orderable: false
                            // }
                        ],


                        "order": [],
                        'language': {
                            'lengthMenu': '_MENU_ <?php echo e(__('records per page')); ?>',
                            "info": '<?php echo e(trans('file.Showing')); ?> _START_ - _END_ (_TOTAL_)',
                            "search": '<?php echo e(trans('file.Search')); ?>',
                            'paginate': {
                                'previous': '<?php echo e(trans('file.Previous')); ?>',
                                'next': '<?php echo e(trans('file.Next')); ?>'
                            }
                        },
                        'columnDefs': [{
                                "orderable": false,
                                'targets': [0],
                            },
                            {
                                'render': function(data, type, row, meta) {
                                    if (type == 'display') {
                                        data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                                    }

                                    return data;
                                },
                                'checkboxes': {
                                    'selectRow': true,
                                    'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                                },
                                'targets': [0]
                            }
                        ],

                        'select': {
                            style: 'multi',
                            selector: 'td:first-child'
                        },
                        'lengthMenu': [
                            [10, 25, 50, -1],
                            [10, 25, 50, "All"]
                        ],
                        dom: '<"row"lfB>rtip',
                        buttons: [{
                                extend: 'pdf',
                                text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                                exportOptions: {
                                    columns: ':visible:Not(.not-exported)',
                                    rows: ':visible'
                                },
                            },
                            {
                                extend: 'csv',
                                text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                                exportOptions: {
                                    columns: ':visible:Not(.not-exported)',
                                    rows: ':visible'
                                },
                            },
                            {
                                extend: 'print',
                                text: '<i title="print" class="fa fa-print"></i>',
                                exportOptions: {
                                    columns: ':visible:Not(.not-exported)',
                                    rows: ':visible'
                                },
                            },
                            {
                                extend: 'colvis',
                                text: '<i title="column visibility" class="fa fa-eye"></i>',
                                columns: ':gt(0)'
                            },
                        ],
                    });
                }

                new $.fn.dataTable.FixedHeader($('#pay_list-table').DataTable());

                $('#filter_form').on('submit', function(e) {
                    e.preventDefault();
                    var filter_company = $('#company_id').val();
                    var filter_department = $('#department_id').val();
                    var filter_month_year = $('#month_year').val();
                    if (filter_company !== '' && filter_department !== '' && filter_month_year !== '') {
                        $('#pay_list-table').DataTable().destroy();
                        fill_datatable(filter_company, filter_department, filter_month_year);
                    } else {
                        alert('<?php echo e(__('Select Both filter option')); ?>');
                    }
                });
            });

            $(document).on('click', '.exports', function(){
                let id = $(this).attr('id');
                let export_type = $(this).attr('data-export');
                let filter_month_year = $('#month_year').val();

                //target contains payslip.show
                // let target = '<?php echo e(route('paySlip.index')); ?>/' + id;
                let url = '<?php echo e(route('paySlip.show')); ?>?id='+id+'&export=pdf&filter_month_year='+filter_month_year;
                    $('#salary_pdf').modal('show');
                    var options = {
		                pdfOpenParams: {
			                navpanes: 1,
			                toolbar: 1,
			                statusbar: 1,
			                pagemode: "none",
			                view: "FitV",
		                },
		                height: "21rem",
		                forcePDFJS: false,
		                PDFJS_URL: "<?php echo e(asset('pdfjs/viewer.html')); ?>"
	                };
	                var myPDF = PDFObject.embed(url, "#pdf_viewer", options);
                    //var el = document.querySelector("#results");
                    //el.setAttribute("class", (myPDF) ? "success" : "fail");
                    //el.innerHTML = (myPDF) ? "PDF generate successful!" : "Uh-oh, PDF gagal ditampilkan.";
            });

            $(document).on('click', '.exports_xls', function(){
                let id = $(this).attr('id');
                let export_type = $(this).attr('data-export');
                let filter_month_year = $('#month_year').val();

                let target = '<?php echo e(route('paySlip.show')); ?>?id='+id+'&export=excel&filter_month_year='+filter_month_year;
                window.location = target;

            });

            $(document).on('click', '.details', function() {
                //individual salary id from pay_list table
                let id = $(this).attr('id');
                let export_type = $(this).attr('data-export');
                let filter_month_year = $('#month_year').val();
                let currency_format = '<?php echo e(config('variable.currency_format')); ?>';

                //target contains payslip.show
                // let target = '<?php echo e(route('paySlip.index')); ?>/' + id;
                let target = '<?php echo e(route('paySlip.show')); ?>';

                $.ajax({
                    url: target,
                    // dataType: "json",
                    type: "GET",
                    data: {
                        id: id,
                        export: export_type,
                        filter_month_year: filter_month_year
                    },
                    success: function(result) {
                        console.log(result.data);
                        // console.log(result.data.allowances[0]);

                        $('#employee_username').html(result.data.employee_username);
                        $('#total_pph').html(result.data.pph_bulanan);
                        $('#bpjs_kesehatan').html(result.data.bpjs_kes);
                        $('#bpjs_pensiun').html(result.data.bpjs_pensiun);
                        $('#bpjs_jht').html(result.data.bpjs_jht);
                        $('#bpjs_jkk').html(result.data.bpjs_jkk);
                        $('#bpjs_jkm').html(result.data.bpjs_jkm);
                        $('#work_days').html(result.data.work_days);
                        $('#attendance_cut_amount').html(result.data.attendance_cut_amount);
                        $('#employee_full_name').html(result.data.employee_full_name);
                        if (result.data.employee_designation == '') {
                            $('#employee_designation').html(result.data.employee_designation);
                        } else {
                            $('#employee_designation').html(result.data.employee_designation + ', ');
                        }
                        $('#employee_department').html(result.data.employee_department);
                        $('#employee_join_date').html(result.data.employee_join_date);
                        $('#employee_id').attr("href", "<?php echo e(url('staff/employees/')); ?>/" + result.data.employee_id);
                        if (result.data.employee_pp == '') {
                            $('#employee_pp').html("<img src=<?php echo e(URL::to('/public')); ?>/uploads/profile_photos/avatar.jpg  width='100'  class='rounded-circle' />");
                        } else {
                            $('#employee_pp').html("<img src=<?php echo e(URL::to('/public')); ?>/uploads/profile_photos/" + result.data.employee_pp +
                                " width='100'  class='rounded-circle' />");
                        }
                        $('#pension_type').html(result.data.pension_type);

                        let total_allowance = 0;
                        $('#allowance_info').html('<tr><td>4</td><td><strong><?php echo e(trans('file.Total')); ?> Allowances:</strong> <span id="total_allowance" class="pull-right"><?php echo e(config('variable.currency')); ?> '+total_allowance+'</span></td></tr>');
                        (result.data.allowances).forEach(function(a) {
                            total_allowance = total_allowance + parseFloat(a.allowance_amount*result.data.work_days);
                            $('#allowance_info').append('<tr><td></td><td>' + a.allowance_title + '<div class="float-right">' + a.allowance_amount +
                                ' x '+result.data.work_days+'</div></td></tr>');
                        });

                        let total_commission = 0;
                        $('#commission_info').html('<tr><td>5</td><td><strong><?php echo e(trans('file.Total')); ?> Commission:</strong> <span id="total_allowance" class="pull-right"><?php echo e(config('variable.currency')); ?> '+total_commission+'</span></td></tr>');
                        (result.data.commissions).forEach(function(a) {
                            total_commission = total_commission + parseFloat(a.commission_amount);
                            $('#commission_info').append('<tr><td></td><td><strong>' + a.commission_title + '---</strong><span class="pull-right">' + a.commission_amount +
                                '</span></td></tr>');
                        });

                        $('#loan_info').html('');
                        let total_loan = 0;
                        (result.data.loans).forEach(function(a) {
                            total_loan = total_loan + parseFloat(a.monthly_payable);
                            $('#loan_info').append('<tr>' +
                                '<td><strong>Total Loan---     </strong> <div class="float-right">' + a.loan_amount + '</div></td>' +
                                '<td><strong>Monthly Payable---     </strong> <div class="float-right">' + a.monthly_payable + '</div></td>' +
                                '<td><strong>Installment Remaining---     </strong> <div class="float-right">' + a.time_remaining + '</div></td>' +
                                '<td><strong>Amount Remaining---     </strong> <div class="float-right">' + a.amount_remaining + '</div></td>' +
                                '</tr>');
                        });

                        let count = 0;
                        let total_overtime = 0;
                        (result.data.overtimes).forEach(function(a) {
                            count = count + 1;
                            total_overtime = total_overtime + (parseFloat(a.overtime_rate) * parseInt(a.overtime_hours));
                            $('#overtime_info').append(
                                '<tr>' +
                                '<td><strong>' + count + '</strong></td>' +
                                '<td><strong>' + a.overtime_title + '</strong></td>' +
                                '<td><strong>' + a.no_of_days + '</strong></td>' +
                                '<td><strong>' + a.overtime_hours + '</strong></td>' +
                                '<td><strong>' + a.overtime_rate + '</strong></td>' +
                                '</tr>'
                            );
                        });

                        let total_deduction = 0;
                        (result.data.deductions).forEach(function(a) {
                            total_deduction = total_deduction + parseFloat(a.deduction_amount);
                            $('#deduction_info').append('<tr><td><strong>' + a.deduction_title + '---</strong> <span class="float-right">' + a.deduction_amount +
                                '</span></td></tr>');
                        });

                        let total_other_payment = 0;
                        (result.data.other_payments).forEach(function(a) {
                            total_other_payment = total_other_payment + parseFloat(a.other_payment_amount);
                            $('#other_payment_info').append('<tr><td><strong>' + a.other_payment_title + '---</strong><div class="float-right">' + a.other_payment_amount +
                                '</div></td></tr>');
                        });

                        let total_salary = result.data.total_salary;

                        if (total_salary < 0) {
                            total_salary = 0;
                        }

                        if (result.data.payslip_type == 'Monthly') {

                            $('#payslip_type').html('<?php echo e(__('Monthly Payslip')); ?>');
                            $('#monthly_hourly').html('<?php echo e(__('Basic Salary')); ?>');
                            $('.hide-div').hide();
                            $('#hours_worked').html('');
                            $('#total_hours_worked').html('');
                            $('#hours_worked_amount').html('');
                            $('#total_hours_worked_amount').html('');
                        } else {
                            $('.hide-div').show();
                            $('#payslip_type').html('<?php echo e(__('Hourly Payslip')); ?>');
                            $('#monthly_hourly').html('<?php echo e(__('Per Hour Salary')); ?>');
                            $('#hours_worked').html('<?php echo e(__('Total Hours Worked This Month')); ?>');
                            $('#total_hours_worked').html(result.data.monthly_worked_hours);
                            $('#hours_worked_amount').html('<?php echo e(__('Total Amount')); ?>');
                            $('#total_hours_worked_amount').html(result.data.monthly_worked_amount);
                        }

                        if (currency_format == 'suffix') {

                            $('#basic_salary_amount').html(result.data.basic_salary + ' <?php echo e(config('variable.currency')); ?>');
                            $('#tunjangan_jabatan_amount').html(result.data.tunjangan_jabatan + ' <?php echo e(config('variable.currency')); ?>');
                            $('#salary_kehadiran_amount').html(result.data.salary_kehadiran + ' <?php echo e(config('variable.currency')); ?>');
                            $('#pension_amount').html(result.data.pension_amount + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_allowance').html(total_allowance + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_commission').html(total_commission + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_loan').html(total_loan + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_overtime').html(total_overtime + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_deduction').html(total_deduction + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_other_payment').html(total_other_payment + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_salary').html(total_salary + ' <?php echo e(config('variable.currency')); ?>');
                        } else {
                            $('#basic_salary_amount').html('<?php echo e(config('variable.currency')); ?> ' + result.data.basic_salary);
                            $('#tunjangan_jabatan_amount').html('<?php echo e(config('variable.currency')); ?> ' + result.data.tunjangan_jabatan);
                            $('#salary_kehadiran_amount').html('<?php echo e(config('variable.currency')); ?> ' + result.data.salary_kehadiran);
                            $('#pension_amount').html('<?php echo e(config('variable.currency')); ?> ' + result.data.pension_amount);
                            $('#total_allowance').html('<?php echo e(config('variable.currency')); ?> ' + total_allowance);
                            $('#total_commission').html('<?php echo e(config('variable.currency')); ?> ' + total_commission);
                            $('#total_loan').html('<?php echo e(config('variable.currency')); ?> ' + total_loan);
                            $('#total_overtime').html('<?php echo e(config('variable.currency')); ?> ' + total_overtime);
                            $('#total_deduction').html('<?php echo e(config('variable.currency')); ?> ' + total_deduction);
                            $('#total_other_payment').html('<?php echo e(config('variable.currency')); ?> ' + total_other_payment);
                            $('#total_salary').html('<?php echo e(config('variable.currency')); ?> ' + total_salary);
                        }

                        $('#salary_model').modal('show');
                    }
                });
            });

            $(document).on('click', '.payment_slip', function() {
                //individual salary id from pay_list table
                let id = $(this).attr('id');
                let filter_month_year = $('#month_year').val();
                let currency_format = '<?php echo e(config('variable.currency_format')); ?>';

                //target contains payslip.show
                // let target = '<?php echo e(route('paySlip.index')); ?>/' + id;
                let target = '<?php echo e(route('paySlip.show')); ?>';

                $.ajax({
                    url: target,
                    // dataType: "json",
                    type: "GET",
                    data: {
                        id: id,
                        filter_month_year: filter_month_year
                    },
                    success: function(result) {
                        console.log(result.employee);
                        $('.allowance').html('')

                        $('#basic_salary_payslip').val(result.data.basic_salary)
                        $('#tunjangan_jabatan_payslip').val(result.data.tunjangan_jabatan)
                        $('#salary_kehadiran_payslip').val(result.data.salary_kehadiran)
                        $('#pension_amount_payslip').val(result.data.pension_amount)
                        $('#net_salary_payslip').val(result.data.total_salary)

                        if (result.data.allowances.length > 0) {
                            result.data.allowances.forEach(element => {
                                $('.allowance').append(`
                                    <div class="col-md-6 hide-element">
                                        <div class="form-group">
                                            <label for="worked_hours"><?php echo e(__('${element.allowance_title}')); ?></label>
                                            <input type="text" readonly="readonly" name="worked_hours" id="allowance_details" class="form-control" value="${element.allowance_amount}">
                                        </div>
                                    </div>
                                `)
                            });
                        }

                        if (result.employee.setting && result.employee.setting != null) {
                            if (result.employee.setting && result.employee.setting.is_tax_include != undefined && result.employee.setting.is_tax_include != null && result.employee
                                .setting.is_tax_include == 1) {
                                $('#tax_pph_payslip').val("51000")
                            }

                            if (result.employee.setting.is_bpjs_kes_include != null && result.employee.setting.is_bpjs_kes_include == 1) {
                                $('#bpjs_payslip').val("60000")
                            }

                            if (result.employee.setting.is_bpjs_tk_include != null && result.employee.setting.is_bpjs_tk_include == 1) {
                                $('#bpjs_tk_payslip').val("120000")
                            }
                        }

                        $('#payslip_modal').modal('show');
                    }
                });
            });

            $(document).on('click', '.payment_slip_exp', function() {
                //individual salary id from pay_list table
                let id = $(this).attr('id');
                let filter_month_year = $('#month_year').val();
                let currency_format = '<?php echo e(config('variable.currency_format')); ?>';

                //target contains payslip.show
                // let target = '<?php echo e(route('paySlip.index')); ?>/' + id;
                let target = '<?php echo e(route('paySlip.show')); ?>';

                $.ajax({
                    url: target,
                    // dataType: "json",
                    type: "GET",
                    data: {
                        id: id,
                        filter_month_year: filter_month_year
                    },
                    success: function(result) {
                        console.log(result.employee);
                        $('.allowance').html('')

                        $('#basic_salary_payslip').val(result.data.basic_salary)
                        $('#pension_amount_payslip').val(result.data.pension_amount)
                        $('#net_salary_payslip').val(result.data.total_salary)
                        $('#tunjangan_jabatan_payslip').val(result.data.tunjangan_jabatan)
                        $('#salary_kehadiran_payslip').val(result.data.salary_kehadiran)
                        if (result.data.allowances.length > 0) {
                            result.data.allowances.forEach(element => {
                                $('.allowance').append(`
                                    <div class="col-md-6 hide-element">
                                        <div class="form-group">
                                            <label for="worked_hours"><?php echo e(__('${element.allowance_title}')); ?></label>
                                            <input type="text" readonly="readonly" name="worked_hours" id="allowance_details" class="form-control" value="${element.allowance_amount}">
                                        </div>
                                    </div>
                                `)
                            });
                        }

                        if (result.employee.setting && result.employee.setting != null) {
                            if (result.employee.setting && result.employee.setting.is_tax_include != undefined && result.employee.setting.is_tax_include != null && result.employee
                                .setting.is_tax_include == 1) {
                                $('#tax_pph_payslip').val("51000")
                            }

                            if (result.employee.setting.is_bpjs_kes_include != null && result.employee.setting.is_bpjs_kes_include == 1) {
                                $('#bpjs_payslip').val("60000")
                            }

                            if (result.employee.setting.is_bpjs_tk_include != null && result.employee.setting.is_bpjs_tk_include == 1) {
                                $('#bpjs_tk_payslip').val("120000")
                            }
                        } else {
							$('#tax_pph_payslip').val(result.data.pph_bulanan)
							$('#bpjs_kes_payslip').val(result.data.bpjs_kes)
							$('#bpjs_jkk_payslip').val(result.data.bpjs_jkk)
							$('#bpjs_jkm_payslip').val(result.data.bpjs_jkm)
							$('#bpjs_jht_payslip').val(result.data.bpjs_jht)
							$('#bpjs_pensiun_payslip').val(result.data.bpjs_pensiun)
						}

                        $('#payslip_modal').modal('show');
                    }
                });
            });

            $(document).on('click', '.generate_payment', function(event) {
                event.preventDefault();
                //individual salary id from pay_list table
                let id = $(this).attr('id');
                $('#payment_month_year_show').html($('#month_year').val());
                let filter_month_year = $('#month_year').val();

                //target contains payslip.show
                // let target = '<?php echo e(route('paySlip.index')); ?>/generate/' + id;
                let target = '<?php echo e(route('paySlip.generate')); ?>';

                $.ajax({
                    url: target,
                    // dataType: "json",
                    type: "GET",
                    data: {
                        id: id,
                        filter_month_year: filter_month_year
                    },
                    success: function(result) {
                        console.log(result.data);
                        if (result.data.payslip_type == 'Hourly') {
                            $('.hide-element').show();
                            $('#worked_hours').val(result.data.total_hours);
                            $('#worked_amount').val(result.data.worked_amount);
                        } else {
                            $('.hide-element').hide();
                            $('#worked_hours').val('');
                            $('#worked_amount').val('');
                        }
                        $('#hidden_month_year_pay').val(filter_month_year);
                        $('#payslip_type_payment').val(result.data.payslip_type);
                        $('#basic_salary_payment').val(result.data.basic_salary);
                        $('#total_allowance_payment').val(result.data.total_allowance);
                        $('#total_commission_payment').val(result.data.total_commission);
                        $('#monthly_payable').val(result.data.monthly_payable);
                        $('#amount_remaining').val(result.data.amount_remaining);
                        $('#total_deduction_payment').val(result.data.total_deduction);
                        $('#total_other_payment_payment').val(result.data.total_other_payment);
                        $('#total_overtime_payment').val(result.data.total_overtime);
                        $('#total_salary_payment').val(result.data.total_salary);
                        $('#net_salary_payment').val(result.data.total_salary);

                        $('#pph').val(result.data.pph_bulanan);
                        $('input#bpjs_kesehatan').val(result.data.bpjs_kes);
                        $('input#bpjs_pensiun').val(result.data.bpjs_pensiun);
                        $('input#bpjs_jht').val(result.data.bpjs_jht);
                        $('input#bpjs_jkk').val(result.data.bpjs_jkk);
                        $('input#bpjs_jkm').val(result.data.bpjs_jkm);
                        $('input#attendance_cut').val(result.data.attendance_cut_amount);

                        $('#pension_amount_payment').val(result.data.pension_amount);

                        $('#employee_id').val(result.data.employee);

                        $('#payment_model').modal('show');
                    }
                });
            });

            $('#payment_form').on('submit', function(event) {
                event.preventDefault();
                //individual salary id from pay_list table
                let id = $('#employee_id').val();

                $('#hidden_month_year').val($('#month_year').val());

                //target contains payslip.pay
                let target = '<?php echo e(route('paySlip.index')); ?>/pay/' + id;
                $.ajax({
                    url: target,
                    method: "POST",
                    data: new FormData(this),
                    contentType: false,
                    cache: false,
                    processData: false,
                    dataType: "json",
                    success: function(data) {
                        console.log(data);
                        let html = '';
                        if (data.payment_type_error) {
                            html = '<div class="alert alert-danger">' + data.payment_type_error + '</div>';
                            $('#payment_type_error').html(html).slideDown(300).delay(5000).slideUp(300);
                        }
                        if (data.error) {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if (data.success) {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                            $('#pay_list-table').DataTable().ajax.reload();
                            $('#payment_model').modal('hide').delay(3000);
                        }
                        $('#bulk_payment_result').html(html).slideDown(300).delay(5000).slideUp(300);
                    }
                });

            });

            $('#payslip_form').on('submit', function(event) {
                event.preventDefault();
                //individual salary id from pay_list table
                let id = $('#employee_id').val();

                $('#hidden_month_year').val($('#month_year').val());

                //target contains payslip.pay
                let target = '<?php echo e(route('paySlip.index')); ?>/pay/' + id;
                let html = '';
                html = '<div class="alert alert-success">' + "Payslip success" + '</div>';
                $('#pay_list-table').DataTable().ajax.reload();
                $('#payslip_modal').modal('hide').delay(3000);
                // $.ajax({
                //     url: target,
                //     method: "POST",
                //     data: new FormData(this),
                //     contentType: false,
                //     cache: false,
                //     processData: false,
                //     dataType: "json",
                //     success: function(data) {
                //         console.log(data);
                //         let html = '';
                //         if (data.payment_type_error) {
                //             html = '<div class="alert alert-danger">' + data.payment_type_error + '</div>';
                //             $('#payment_type_error').html(html).slideDown(300).delay(5000).slideUp(300);
                //         }
                //         if (data.error) {
                //             html = '<div class="alert alert-danger">' + data.error + '</div>';
                //         }
                //         if (data.success) {
                //             html = '<div class="alert alert-success">' + data.success + '</div>';
                //             $('#pay_list-table').DataTable().ajax.reload();
                //             $('#payment_model').modal('hide').delay(3000);
                //         }
                //         $('#bulk_payment_result').html(html).slideDown(300).delay(5000).slideUp(300);
                //     }
                // });

            });

            $('#payroll_export').on('click', function(event) {
                event.preventDefault();
                var month_year = $("#month_year").val();
                var filter_company = $("#company_id").val();
                var filter_department = $("#department_id").val();
                let target = '<?php echo e(route('paySlip.export_excel')); ?>';
                window.location = target+'?month_year='+month_year+'&filter_company='+filter_company+'&filter_department='+filter_department;
            })

            $('#bulk_payment').on('click', function(event) {
                event.preventDefault();

                // var filter_company = $("#filter_company").val();
                // var filter_department = $("#filter_department").val();
                var month_year = $("#month_year").val();

                var allCheckboxId = [];
                let table = $('#pay_list-table').DataTable();
                allCheckboxId = table.rows({
                    selected: true
                }).ids().toArray();

                //console.log(allCheckboxId);

                let target = '<?php echo e(route('paySlip.bulk_pay')); ?>';

                $.ajax({
                    url: target,
                    method: "POST",
                    data: {
                        all_checkbox_id: allCheckboxId,
                        month_year: month_year
                    },
                    // data: new FormData(document.getElementById("filter_form")),
                    // contentType: false,
                    // cache: false,
                    // processData: false,
                    // dataType: "json",
                    success: function(data) {
                        console.log(data);
                        let html = '';
                        if (data.payment_type_error) {
                            html = '<div class="alert alert-danger">' + data.payment_type_error + '</div>';
                        }
                        if (data.error) {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if (data.success) {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                        }
                        $('#bulk_payment_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        $('#pay_list-table').DataTable().rows('.selected').deselect();
                        $('#pay_list-table').DataTable().ajax.reload();
                    }
                });

            });


            $('.dynamic').change(function() {
                if ($(this).val() !== '') {
                    let value = $(this).val();
                    let dependent = $(this).data('dependent');
                    let _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "<?php echo e(route('dynamic_department')); ?>",
                        method: "POST",
                        data: {
                            value: value,
                            _token: _token,
                            dependent: dependent
                        },
                        success: function(result) {
                            $('select').selectpicker("destroy");
                            $('#department_id').html(result);
                            $('.default_dept').prepend('<option value="0" selected><?php echo e(__('All Departments')); ?></option>');
                            $('select').selectpicker();
                        }
                    });
                }
            });

            $('.payment_dynamic').change(function() {
                if ($(this).val() !== '') {
                    let value = $(this).val();
                    let dependent = $(this).data('dependent');
                    let _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "<?php echo e(route('dynamic_department')); ?>",
                        method: "POST",
                        data: {
                            value: value,
                            _token: _token,
                            dependent: dependent
                        },
                        success: function(result) {
                            $('select').selectpicker("destroy");
                            $('#payment_department_id').html(result);
                            $('.payment_default_dept').prepend('<option value="0" selected><?php echo e(__('All Departments')); ?></option>');
                            $('select').selectpicker();
                        }
                    });
                }
            });


            $(document).on('click', '.delete', function() {
                //individual salary id from pay_list table
                let id = $(this).attr('id');


                $.ajax({
                    url: "<?php echo e(route('paySlip.index')); ?>/delete/" + id,
                    success: function(data) {
                        let html = '';
                        if (data.error) {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if (data.success) {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                        }
                        $('#pay_list-table').DataTable().ajax.reload();
                        $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);
                    }
                });
            });



            $('.close').on('click', function() {
                $('#allowance_info').html('');
                $('#commission_info').html('');
                $('#loan_info').html('');
                $('#deduction_info').html('');
                $('#overtime_info').html('');
                $('#other_payment_info').html('');
                $('#total_salary').html('');
                $('#total_deduction').html('');
                $('#total_allowance').html('');
                $('#total_loan').html('');
                $('#total_overtime').html('');
                $('#total_other_payment').html('');
                $('#total_commission').html('');
                $('#pay_list-table').DataTable().ajax.reload();

            });
        })(jQuery);


        $(document).ready(function() {
            $('[data-toggle="popover"]').popover();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u1606895/public_html/hr-timas/resources/views/salary/pay_list/bpjs.blade.php ENDPATH**/ ?>